// Revision: 13 1.5.1.4 source/ui/baseapp/ievent.cpp, basewin, ioc.v400, 001006  
/*******************************************************************************
* FILE NAME: ievent.cpp                                                        *
*                                                                              *
* DESCRIPTION:                                                                 *
*   This file contains the implementation of classes/functions declared        *
*   in ievent.hpp.                                                             *
*                                                                              *
* COPYRIGHT:                                                                   *
*   IBM Open Class Library                                                     *
*   (C) Copyright International Business Machines Corporation 1992, 1997       *
*   Licensed Material - Program-Property of IBM - All Rights Reserved.         *
*   US Government Users Restricted Rights - Use, duplication, or disclosure    *
*   restricted by GSA ADP Schedule Contract with IBM Corp.                     *
*                                                                              *
*******************************************************************************/
#include <ibase.hpp>
#ifdef IC_MOTIF
extern "C" {
#include <pthread.h>
}
#endif

#define INCL_WINERRORS
#define INCL_WINMESSAGEMGR
#define INCL_WINWINDOWMGR
extern "C" {
  #include <iwindefs.h>
}

#include <ievent.hpp>
#include <itrace.hpp>
#include <iwindow.hpp>

// Segment definitions.
#ifdef IC_PAGETUNE
  #define _IEVENT_CPP_
  #include <ipagetun.h>
#endif

#ifdef IC_MOTIF
// defect 29176
int __page_size;
int __page_size_K;
int __page_sizeX16;
int __page_sizeX24;
int __page_sizeM1;
pthread_mutex_t _mutex_global_np;
#endif

/*------------------------------------------------------------------------------
| IEvent::IEvent                                                               |
------------------------------------------------------------------------------*/
IEvent::IEvent ( IWindow* window,
                 unsigned long eventId,
                 const IEventParameter1& parameter1,
                 const IEventParameter2& parameter2 )
  : hCl( 0 )
  , fdispatchingWindow( window )
  , p_controlHandle( 0 )
  , ulClEvtId( eventId )
  , epCl1( parameter1 )
  , epCl2( parameter2 )
  , erCl( 0 )
  , fCursor (0 )
  , fHandlerList(0)
#ifdef IC_MOTIFWIN
  , dispatchToOwner(true)
  , fOwnerLevels( -1 )
#endif
  , pData( 0 )
{
  if ( window )
  {
    this->hCl = window->handle();
    this->p_controlHandle = window->handle();
  }
}

/*------------------------------------------------------------------------------
| IEvent::IEvent                                                               |
------------------------------------------------------------------------------*/
IEvent::IEvent ( const IWindowHandle& handle,
                 unsigned long eventId,
                 const IEventParameter1& parameter1,
                 const IEventParameter2& parameter2 )
  : hCl( handle )
  , fdispatchingWindow( 0 )
  , p_controlHandle( handle)
  , ulClEvtId( eventId )
  , epCl1( parameter1 )
  , epCl2( parameter2 )
  , erCl( 0 )
  , fCursor (0 )
  , fHandlerList (0)
#ifdef IC_MOTIFWIN
  , dispatchToOwner(true)
  , fOwnerLevels( -1 )
#endif
  , pData( 0 )
{ }

/*------------------------------------------------------------------------------
| IEvent::IEvent                                                               |
------------------------------------------------------------------------------*/
IEvent :: IEvent ( const IEvent& event )
  : hCl( event.hCl )
  , fdispatchingWindow( event.fdispatchingWindow )
  , p_controlHandle( event.p_controlHandle )
  , ulClEvtId( event.ulClEvtId )
  , epCl1( event.epCl1 )
  , epCl2( event.epCl2 )
  , erCl( event.erCl )
  , fCursor ( event.fCursor )
  , fHandlerList ( event.fHandlerList )
#ifdef IC_MOTIFWIN
  , dispatchToOwner(event.dispatchToOwner)
  , fOwnerLevels( event.fOwnerLevels )
#endif
   , pData(0)
{
}

/*------------------------------------------------------------------------------
| IEvent::operator=                                                            |
------------------------------------------------------------------------------*/
IEvent& IEvent::operator= (const IEvent &event)
{
  if (this != &event)
  {
    hCl = event.hCl;
    fdispatchingWindow = event.fdispatchingWindow;
    p_controlHandle = event.p_controlHandle;
    ulClEvtId = event.ulClEvtId;
    epCl1 = event.epCl1;
    epCl2 = event.epCl2;
    erCl = event.erCl;
    fCursor = event.fCursor;
    fHandlerList = event.fHandlerList;
#ifdef IC_MOTIFWIN
    dispatchToOwner = event.dispatchToOwner;
    fOwnerLevels = event.fOwnerLevels;
#endif
    // no private data defined.
    // delete pData;
    // pData = new IEventPrivateData();
  }
  return *this;
}

/*------------------------------------------------------------------------------
   Destructor (here so compiler doesn't generate one).
------------------------------------------------------------------------------*/
IEvent :: ~IEvent ( )
{
  // no private data defined.
  // delete pData;
}

/**************************************************************************/
/* Return the IWindow object pointer for the window which had this event. */
/**************************************************************************/
IWindow* IEvent::window ( ) const
{
  IMODTRACE_ALL( "IEvent::window" );
  // Optimization.  If the dispatchingHandle and handle() are the same
  // then just return the dispatchingWindow and avoid a windowWithHandle call.
  IWindow* pwin = this->dispatchingWindow();
  if ( !pwin || (pwin->handle() != this->handle()) )
     pwin = IWindow::windowWithHandle( this->handle() );
  return pwin;
}

/*****************************************************************/
/* Return the IWindow object pointer for the dispatching window. */
/*****************************************************************/
IWindow* IEvent::dispatchingWindow ( ) const
{
  IMODTRACE_ALL( "IEvent::dispatchingWindow" );
  if (!fdispatchingWindow)
  {
     // If not set, set the value to a default value of the window associated
     // with this event.  This code should generally not be used because
     // the IOC window procedure/callbacks should call setDispatchingWindow
     // as soon as the handle is known.
    IEvent* localthis = (IEvent*)this;
    localthis->setDispatchingWindow( IWindow::windowWithHandle( handle() ) );
  }
  return fdispatchingWindow;
}

/*------------------------------------------------------------------------------
| IEvent::setDispatchingHandle                                                 |
------------------------------------------------------------------------------*/
IEvent& IEvent::setDispatchingHandle  ( const IWindowHandle& handle )
{
  return this->setDispatchingWindow( IWindow::windowWithHandle( handle ) );
}

/***********************************************************************/
/* Return the IWindow object pointer for the original control window.  */
/***********************************************************************/
IWindow* IEvent::controlWindow ( ) const
{
  IMODTRACE_ALL( "IEvent::controlWindow" );
  IWindow* pwin = 0;
  if ( this->controlHandle() )
  {
    // Optimization.  If the dispatching handle and control handle are the same
    // then just return the dispatchingWindow and avoid a windowWithHandle call.
    pwin = this->dispatchingWindow();
    if ( !pwin || (pwin->handle() != this->controlHandle() ) )
      pwin = IWindow::windowWithHandle( this->controlHandle() );
  }
  return pwin;
}

#ifdef IC_MOTIFWIN
bool IEvent::passToOwner() const

{
  return dispatchToOwner;
}

IEvent& IEvent::setPassToOwner( bool passOn )

{
  dispatchToOwner = passOn;
  return *this;
}

IEvent& IEvent::setNumberOfLevels( int levels )

{
  fOwnerLevels = levels;
  return *this;
}


IEvent& IEvent::decrementOwnerLevels()
{
  // if the levels are greater than 0 then decrement it.We don't need to bother
  // decrementing -1, that is the value used for parameters that can go all the
  // owner chain
  if ( fOwnerLevels > 0 )
  {
    fOwnerLevels--;
  }
  // if the levels ever get to 0 then we are done going up the owner chain.
  if ( fOwnerLevels == 0 )
  {
    dispatchToOwner = false;
  }
  return *this;
}
#endif
