// Revision: 61 1.4.2.1 source/ui/baseapp/iarglist.cpp, basewin, ioc.v400, 001006 
/*******************************************************************************
* FILE NAME: iarglist.cpp                                                      *
*                                                                              *
* DESCRIPTION:                                                                 *
*   This file contains the implementation of classes/functions declared        *
*   in iarglist.hpp.                                                           *
*                                                                              *
* COPYRIGHT:                                                                   *
*   Licensed Materials - Property of IBM                                       *
*   (C) Copyright IBM Corporation 1992, 1997                                   *
*   All Rights Reserved                                                        *
*   US Government Users Restricted Rights - Use, duplication, or               *
*   disclosure                                                                 *
*   restricted by GSA ADP Schedule Contract with IBM Corp.                     *
*                                                                              *
*******************************************************************************/
#include <iwindefs.h>

#include <iarglist.hpp>

// Segment definitions.
#ifdef IC_PAGETUNE
    #define _IARGLIST_CPP_
    #include <ipagetun.h>
#endif

#pragma enum(4)
#pragma pack(push,4)

class IArgListData
{
public:

IArgListData();
IArgListData( const IArgListData& argListData);
~IArgListData();

void setArgs( char* name, XtArgVal value );

void
 *arglist();

int
  numberOfArgs,
  maxArgs;
ArgList
  args;
};

#pragma pack(pop)
#pragma enum(pop)

IArgListData::IArgListData()
  : numberOfArgs( 0 )
  , maxArgs(10)
{
  args = new Arg[maxArgs];
}

IArgListData::IArgListData( const IArgListData& argListData)
{
  numberOfArgs = argListData.numberOfArgs;
  maxArgs = argListData.maxArgs;
  args = new Arg[maxArgs];
  for ( int i=0; i < numberOfArgs; i++ )
  {
    XtSetArg( args[i], argListData.args[i].name,
                         argListData.args[i].value );
  }
}
IArgListData::~IArgListData()
{
  delete [] args;
}

void IArgListData::setArgs( char* name, XtArgVal value )
{
  // if setting this arg is greater than the number of args
  // that we allocated space for then create a bigger arg list and
  // copy the args to the new list.
  if ( numberOfArgs == maxArgs )
  {
    maxArgs = 2*maxArgs;
    ArgList tempArg = new Arg[maxArgs];
    for ( int i=0; i < numberOfArgs; i++ )
    {
      XtSetArg( tempArg[i], args[i].name,
                            args[i].value );
    }
    // Don't forget to free the old arg list.
    delete [] args;
    args = tempArg;
  }
  XtSetArg( args[numberOfArgs], name, value );
  numberOfArgs++;
}

void *IArgListData::arglist()
{
  return args;
}

IArgList::IArgList( )
  : pData(0)
{
    pData = new IArgListData( );
}

IArgList::IArgList( const IArgList& ArgList )
  : pData(0)
{
    pData = new IArgListData( *ArgList.pData );
}

IArgList::~IArgList()
{
    delete pData;
}

IArgList
 &IArgList::operator=( const IArgList& ArgList )
{
  if (this != &ArgList )
  {
      delete pData;
      pData = new IArgListData( *ArgList.pData );
  }
  return *this;
}

IArgList& IArgList::setResource( char* arg, long value )
{
  pData->setArgs( arg, value );
  return *this;
}

void* IArgList::argList()
{
  return pData->arglist();
}

unsigned long IArgList::numberOfArgs()
{
  return pData->numberOfArgs;
}

