#include <ibase.hpp>
#include <igbm.hpp>
#include <icconst.h>
/*
*****************************************************************************************
*                                                                                       *
* COPYRIGHT:                                                                            *
*   IBM Open Class Library                                                              *
*   (C) Copyright International Business Machines Corporation,  1997                    *
*   Licensed Material - Program-Property of IBM - All Rights Reserved.                  *
*   US Government Users Restricted Rights - Use, duplication, or disclosure             *
*   restricted by GSA ADP Schedule Contract with IBM Corp.                              *
*                                                                                       *
*****************************************************************************************
*/
// Revision: 56 1.4.1.5 source/ographic/igbm.cpp, graphics, ioc.v400, 001006 
/*

IGBMHELP.C  Helpers for GBM file I/O stuff

*/

/*...sincludes:0:*/
#include <stdio.h>
#include <ctype.h>
#include <stddef.h>
#include <stdlib.h>
#include <string.h>
#include <memory.h>
#include <malloc.h>
#ifdef IC_MOTIF
#include <unistd.h>
#else
#include <io.h>
#endif
#include <fcntl.h>
#include <sys/types.h>
#include <sys/stat.h>
#if 0
#include "igbmstnd.hpp"
#include "igbmhelp.hpp"
#include "igbm.hpp"
#include <ibase.hpp>

// Segment definitions
#ifdef IC_PAGETUNE
  #define _IGBMHELP_CPP_
  #include <ipagetun.h>
#endif
#endif // 0

#ifdef IC_PM
#define INCL_DOS
#define INCL_WIN
#define INCL_DOSPROCESS

#define INCL_GPI
#define INCL_DEV
#define INCL_BITMAPFILEFORMAT
#include <os2.h>
#endif // IC_PM

/*...vgbm\46\h:0:*/
/*...e*/

/*...sgbm_same:0:*/
bool gbm_same(char *s1, char *s2, int n)
        {
        for ( ; n--; s1++, s2++ )
                if ( tolower(*s1) != tolower(*s2) )
                        return false;
        return true;
        }
/*...e*/
/*...sgbm_find_word:0:*/
char *gbm_find_word(char *str, char *substr)
        {
        char buf[100+1], *s;
        int  len = strlen(substr);

        for ( s  = strtok(strcpy(buf, str), " \t,");
              s != NULL;
              s  = strtok(NULL, " \t,") )
                if ( gbm_same(s, substr, len) && s[len] == '\0' )
                        return str + (s - buf);
        return NULL;
        }
/*...e*/
/*...sgbm_find_word_prefix:0:*/
char *gbm_find_word_prefix(char *str, char *substr)
        {
        char buf[100+1], *s;
        int  len = strlen(substr);

        for ( s  = strtok(strcpy(buf, str), " \t,");
              s != NULL;
              s  = strtok(NULL, " \t,") )
                if ( gbm_same(s, substr, len) )
                        return str + (s - buf);
        return NULL;
        }
/*...e*/
/*...sreading ahead:0:*/
#define AHEAD_BUF 0x4000

typedef struct
        {
        byte buf[AHEAD_BUF];
        int inx, cnt;
        int fd;
        } AHEAD;

AHEAD *gbm_create_ahead(int fd)
        {
        AHEAD *ahead;

        if ( (ahead = (AHEAD *)malloc(sizeof(AHEAD))) == NULL ) // mjs
                return NULL;

        ahead->inx = 0;
        ahead->cnt = 0;
        ahead->fd  = fd;

        return ahead;
        }

void gbm_destroy_ahead(AHEAD *ahead)
        {
        free(ahead);
        }

int gbm_read_ahead(AHEAD *ahead)
        {
        if ( ahead->inx >= ahead->cnt )
                {
                ahead->cnt = read(ahead->fd, (char *) ahead->buf, AHEAD_BUF);
                if ( ahead->cnt <= 0 )
                        return -1;
                ahead->inx = 0;
                }
        return (int) (unsigned int) ahead->buf[ahead->inx++];
        }
/*...e*/
/*
*****************************************************************************************
*                                                                                       *
* COPYRIGHT:                                                                            *
*   IBM Open Class Library                                                              *
*   (C) Copyright International Business Machines Corporation,  1997                    *
*   Licensed Material - Program-Property of IBM - All Rights Reserved.                  *
*   US Government Users Restricted Rights - Use, duplication, or disclosure             *
*   restricted by GSA ADP Schedule Contract with IBM Corp.                              *
*                                                                                       *
*****************************************************************************************
*/
// Revision: 56 1.4.1.5 source/ographic/igbm.cpp, graphics, ioc.v400, 001006 
/*

IGBMPGM.C  Poskanzers PGM format

Reads as 8 bit grey image.
Writes grey equivelent of passed in 8 bit colour data (no palette written).
Output options: r,g,b,k (default: k)

*/

#if 0
#pragma priority( -2147481424 )

/*...sincludes:0:*/
#include <stdio.h>
#include <ctype.h>
#include <stddef.h>
#include <stdlib.h>
#include <string.h>
#include <memory.h>
#include <malloc.h>
#ifdef AIX
#include <unistd.h>
#else
#include <io.h>
#endif
#include <fcntl.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <igbmstnd.hpp>
#include <igbm.hpp>
#include <igbmhelp.hpp>
#include <icconst.h>
#include <ibase.hpp>

// Segment definitions
#ifdef IC_PAGETUNE
  #define _IGBMPGM_CPP_
  #include <ipagetun.h>
#endif
#endif // 0

/*...vgbm\46\h:0:*/
/*...vgbmhelp\46\h:0:*/
/*...e*/

/*...suseful:0:*/
#define low_byte(w)     ((byte)  ((w)&0x00ff)    )
#define high_byte(w)    ((byte) (((w)&0xff00)>>8))
#define make_word(a,b)  (((word)a) + (((word)b) << 8))
/*...e*/
/*...smake_output_palette:0:*/
#define SW4(a,b,c,d)    ((a)*8+(b)*4+(c)*2+(d))

#ifndef DEFINED_MAKE_OUTPUT_PALETTE
#define DEFINED_MAKE_OUTPUT_PALETTE
static bool make_output_palette(GBMRGB gbmrgb[], byte grey[], char *opt)
        {
        bool k = ( gbm_find_word(opt, "k") != NULL );
        bool r = ( gbm_find_word(opt, "r") != NULL );
        bool g = ( gbm_find_word(opt, "g") != NULL );
        bool b = ( gbm_find_word(opt, "b") != NULL );
        int     i;

        switch ( SW4(k,r,g,b) )
                {
                case SW4(0,0,0,0):
                        /* Default is the same as "k" */
                case SW4(1,0,0,0):
                        for ( i = 0; i < 0x100; i++ )
                                grey[i] = (byte) ( ((word) gbmrgb[i].r *  77 +
                                                     (word) gbmrgb[i].g * 151 +
                                                     (word) gbmrgb[i].b *  28) >> 8 );
                        return true;
                case SW4(0,1,0,0):
                        for ( i = 0; i < 0x100; i++ )
                                grey[i] = gbmrgb[i].r;
                        return true;
                case SW4(0,0,1,0):
                        for ( i = 0; i < 0x100; i++ )
                                grey[i] = gbmrgb[i].g;
                        return true;
                case SW4(0,0,0,1):
                        for ( i = 0; i < 0x100; i++ )
                                grey[i] = gbmrgb[i].b;
                        return true;
                }
        return false;
        }
#endif // DEFINED_MAKE_OUTPUT_PALETTE
/*...e*/

#ifndef STUFF_0
#define STUFF_0
/*...sposk stuff:0:*/
/*...sread_byte:0:*/
static byte read_byte(int fd)
        {
        byte b = 0;

        read(fd, (char *) &b, 1);
        return b;
        }
/*...e*/
/*...sread_char:0:*/
static char read_char(int fd)
        {
        char c;

        while ( (c = read_byte(fd)) == '#' )
                /* Discard to end of line */
                while ( (c = read_byte(fd)) != '\n' )
                        ;
        return c;
        }
/*...e*/
/*...sread_num:0:*/
static int read_num(int fd)
        {
        char c;
        int num;

        while ( isspace(c = read_char(fd)) )
                ;
        num = c - '0';
        while ( isdigit(c = read_char(fd)) )
                num = num * 10 + (c - '0');
        return num;
        }
/*...e*/
/*...sread_posk_header:0:*/
static void read_posk_header(int fd, int *h1, int *h2, int *w, int *h, int *m)
        {
        lseek(fd, 0L, SEEK_SET);
        *h1 = read_byte(fd);
        *h2 = read_byte(fd);
        *w  = read_num(fd);
        *h  = read_num(fd);
        *m  = read_num(fd);
        }
#endif // STUFF0
/*...e*/
/*...e*/

static GBMFT pgm_gbmft =
        {
        "Greymap",
        "Portable Greyscale-map (binary P5 type)",
        "PGM",
        GBM_FT_R8|
        GBM_FT_W8,
        };

#define GBM_ERR_PGM_BAD_M       ((GBM_ERR) 100)

/*...spgm_qft:0:*/
GBM_ERR pgm_qft(GBMFT *gbmft)
        {
        *gbmft = pgm_gbmft;
        return GBM_ERR_OK;
        }
/*...e*/
/*...spgm_rhdr:0:*/
GBM_ERR pgm_rhdr(char *fn, int fd, GBM *gbm, char *opt)
        {
        int     h1, h2, w, h, m;

        fn=fn; opt=opt; /* Suppress 'unref arg' compiler warnings */

        read_posk_header(fd, &h1, &h2, &w, &h, &m);
        if ( h1 != 'P' || h2 != '5' )
                return GBM_ERR_BAD_MAGIC;

        if ( w <= 0 || h <= 0 )
                return GBM_ERR_BAD_SIZE;

        if ( m <= 1 || m >= 0x100 )
                return GBM_ERR_PGM_BAD_M;

        gbm->w   = w;
        gbm->h   = h;
        gbm->bpp = 8;

        return GBM_ERR_OK;
        }
/*...e*/
/*...spgm_rpal:0:*/
GBM_ERR pgm_rpal(int fd, GBM *gbm, GBMRGB *gbmrgb)
        {
        int     h1, h2, w, h, m, i;

        gbm=gbm; /* Suppress 'unref arg' compiler warning */

        read_posk_header(fd, &h1, &h2, &w, &h, &m);
        for ( i = 0; i < m; i++ )
                gbmrgb[i].r =
                gbmrgb[i].g =
                gbmrgb[i].b = (byte) (i * 0xff / (m - 1));

        return GBM_ERR_OK;
        }
/*...e*/
/*...spgm_rdata:0:*/
GBM_ERR pgm_rdata(int fd, GBM *gbm, byte *data)
        {
        int     h1, h2, w, h, m, i, stride;
        byte    *p;

        read_posk_header(fd, &h1, &h2, &w, &h, &m);

        stride = ((gbm->w + 3) & ~3);
        p = data + ((gbm->h - 1) * stride);
        for ( i = gbm->h - 1; i >= 0; i-- )
                {
                read(fd, p, gbm->w);
                p -= stride;
                }
        return GBM_ERR_OK;
        }
/*...e*/
/*...spgm_w:0:*/
GBM_ERR pgm_w(char *fn, int fd, GBM *gbm, GBMRGB *gbmrgb, byte *data, char *opt)
        {
        char s[100+1];
        int i, j, stride;
        byte grey[0x100];
        byte *p, *linebuf;

        fn=fn; opt=opt; /* Suppress 'unref arg' compiler warnings */

        if ( gbm->bpp != 8 )
                return GBM_ERR_NOT_SUPP;

        if ( !make_output_palette(gbmrgb, grey, opt) )
                return GBM_ERR_BAD_OPTION;

        if ( (linebuf = (byte*)malloc(gbm->w)) == NULL )  // mjs
                return GBM_ERR_MEM;

        sprintf(s,
                "P5\n# Written by Generalised Bitmap Module\n%d %d 255\n",
                gbm->w, gbm->h);
        write(fd, s, strlen(s));

        stride = ((gbm->w + 3) & ~3);
        p = data + ((gbm->h - 1) * stride);
        for ( i = gbm->h - 1; i >= 0; i-- )
                {
                for ( j = 0; j < gbm->w; j++ )
                        linebuf[j] = grey[p[j]];
                write(fd, linebuf, gbm->w);
                p -= stride;
                }

        free(linebuf);

        return GBM_ERR_OK;
        }
/*...e*/
/*...spgm_err:0:*/
unsigned long pgm_err(GBM_ERR rc)
        {
        switch ( (int) rc )
                {
                case GBM_ERR_PGM_BAD_M:
                        return IC_GBM_PGM_BAD_M;
                }
        return 0;
        }
/*...e*/
/*
*****************************************************************************************
*                                                                                       *
* COPYRIGHT:                                                                            *
*   IBM Open Class Library                                                              *
*   (C) Copyright International Business Machines Corporation,  1997                    *
*   Licensed Material - Program-Property of IBM - All Rights Reserved.                  *
*   US Government Users Restricted Rights - Use, duplication, or disclosure             *
*   restricted by GSA ADP Schedule Contract with IBM Corp.                              *
*                                                                                       *
*****************************************************************************************
*/
// Revision: 56 1.4.1.5 source/ographic/igbm.cpp, graphics, ioc.v400, 001006 
/*

IGBMPPM.C  Poskanzers PPM format

Reads and writes 24 bit RGB.

*/

#if 0
#pragma priority( -2147481424 )

/*...sincludes:0:*/
#include <stdio.h>
#include <ctype.h>
#include <stddef.h>
#include <stdlib.h>
#include <string.h>
#include <memory.h>
#include <malloc.h>
#ifdef AIX
#include <unistd.h>
#else
#include <io.h>
#endif
#include <fcntl.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <igbmstnd.hpp>
#include <igbm.hpp>
#include <igbmhelp.hpp>
#include <icconst.h>

// Segment definitions
#ifdef IC_PAGETUNE
  #define _IGBMPPM_CPP_
  #include <ipagetun.h>
#endif
#endif // 0

/*...suseful:0:*/
#define low_byte(w)     ((byte)  ((w)&0x00ff)    )
#define high_byte(w)    ((byte) (((w)&0xff00)>>8))
#define make_word(a,b)  (((word)a) + (((word)b) << 8))
/*...e*/

#ifndef STUFF_0
#define STUFF_0
/*...sposk stuff:0:*/
/*...sread_byte:0:*/
static byte read_byte(int fd)
        {
        byte b = 0;

        read(fd, (char *) &b, 1);
        return  b;
        }
/*...e*/
/*...sread_char:0:*/
static char read_char(int fd)
        {
        char c;

        while ( (c = read_byte(fd)) == '#' )
                /* Discard to end of line */
                while ( (c = read_byte(fd)) != '\n' )
                        ;
        return c;
        }
/*...e*/
/*...sread_num:0:*/
static int read_num(int fd)
        {
        char c;
        int num;

        while ( isspace(c = read_char(fd)) )
                ;
        num = c - '0';
        while ( isdigit(c = read_char(fd)) )
                num = num * 10 + (c - '0');
        return num;
        }
/*...e*/
/*...sread_posk_header:0:*/
static void read_posk_header(int fd, int *h1, int *h2, int *w, int *h, int *m)
        {
        lseek(fd, 0L, SEEK_SET);
        *h1 = read_byte(fd);
        *h2 = read_byte(fd);
        *w  = read_num(fd);
        *h  = read_num(fd);
        *m  = read_num(fd);
        }
#endif // STUFF_0
/*...e*/
/*...e*/

static GBMFT ppm_gbmft =
        {
        "Pixmap",
        "Portable Pixel-map (binary P6 type)",
        "PPM",
        GBM_FT_R24|
        GBM_FT_W24,
        };

#define GBM_ERR_PPM_BAD_M       ((GBM_ERR) 200)

/*...srgb_bgr:0:*/
#ifndef SRGB_BGR_0
#define SRGB_BGR_0
static void rgb_bgr(byte *p, byte *q, int n)
        {
        while ( n-- )
                {
                byte    r = *p++;
                byte    g = *p++;
                byte    b = *p++;

                *q++ = b;
                *q++ = g;
                *q++ = r;
                }
        }
/*...e*/
#endif // SRGB_BGR_0

/*...sppm_qft:0:*/
GBM_ERR ppm_qft(GBMFT *gbmft)
        {
        *gbmft = ppm_gbmft;
        return GBM_ERR_OK;
        }
/*...e*/
/*...sppm_rhdr:0:*/
GBM_ERR ppm_rhdr(char *fn, int fd, GBM *gbm, char *opt)
        {
        int     h1, h2, w, h, m;

        fn=fn; opt=opt; /* Suppress 'unref arg' compiler warnings */

        read_posk_header(fd, &h1, &h2, &w, &h, &m);
        if ( h1 != 'P' || h2 != '6' )
                return GBM_ERR_BAD_MAGIC;

        if ( w <= 0 || h <= 0 )
                return GBM_ERR_BAD_SIZE;

        if ( m <= 1 || m >= 0x100 )
                return GBM_ERR_PPM_BAD_M;

        gbm->w   = w;
        gbm->h   = h;
        gbm->bpp = 24;

        return GBM_ERR_OK;
        }
/*...e*/
/*...sppm_rpal:0:*/
GBM_ERR ppm_rpal(int fd, GBM *gbm, GBMRGB *gbmrgb)
        {
        fd=fd; gbm=gbm; gbmrgb=gbmrgb; /* Suppress 'unref arg' compiler warnings */

        return GBM_ERR_OK;
        }
/*...e*/
/*...sppm_rdata:0:*/
GBM_ERR ppm_rdata(int fd, GBM *gbm, byte *data)
        {
        int     h1, h2, w, h, m, i, stride;
        byte    *p;

        read_posk_header(fd, &h1, &h2, &w, &h, &m);

        stride = ((gbm->w * 3 + 3) & ~3);
        p = data + ((gbm->h - 1) * stride);
        for ( i = gbm->h - 1; i >= 0; i-- )
                {
                read(fd, p, gbm->w * 3);
                rgb_bgr(p, p, gbm->w);
                p -= stride;
                }
        return GBM_ERR_OK;
        }
/*...e*/
/*...sppm_w:0:*/
GBM_ERR ppm_w(char *fn, int fd, GBM *gbm, GBMRGB *gbmrgb, byte *data, char *opt)
        {
        char    s[100+1];
        int     i, stride;
        byte    *p, *linebuf;

        fn=fn; gbmrgb=gbmrgb; opt=opt; /* Suppress 'unref arg' compiler warnings */

        if ( gbm->bpp != 24 )
                return GBM_ERR_NOT_SUPP;

        if ( (linebuf = (byte*)malloc(gbm->w * 3)) == NULL ) // mjs
                return GBM_ERR_MEM;

        sprintf(s,
                "P6\n# Written by Generalised Bitmap Module\n%d %d 255\n",
                gbm->w, gbm->h);
        write(fd, s, strlen(s));

        stride = ((gbm->w * 3 + 3) & ~3);
        p = data + ((gbm->h - 1) * stride);
        for ( i = gbm->h - 1; i >= 0; i-- )
                {
                rgb_bgr(p, linebuf, gbm->w);
                write(fd, linebuf, gbm->w * 3);
                p -= stride;
                }

        free(linebuf);

        return GBM_ERR_OK;
        }
/*...e*/
/*...sppm_err:0:*/
unsigned long ppm_err(GBM_ERR rc)
        {
        switch ( (int) rc )
                {
                case GBM_ERR_PPM_BAD_M:
                        return IC_GBM_PGM_BAD_M;
                }
        return 0;
        }
/*...e*/
/*
*****************************************************************************************
*                                                                                       *
* COPYRIGHT:                                                                            *
*   IBM Open Class Library                                                              *
*   (C) Copyright International Business Machines Corporation,  1997                    *
*   Licensed Material - Program-Property of IBM - All Rights Reserved.                  *
*   US Government Users Restricted Rights - Use, duplication, or disclosure             *
*   restricted by GSA ADP Schedule Contract with IBM Corp.                              *
*                                                                                       *
*****************************************************************************************
*/
// Revision: 56 1.4.1.5 source/ographic/igbm.cpp, graphics, ioc.v400, 001006 
/*

IGBMBMP.C  OS/2 1.1, 1.2, 2.0 and Windows 3.0 support

Reads and writes any OS/2 1.x bitmap.
Will also read uncompressed, RLE4 and RLE8 Windows 3.x bitmaps too.
There are horrific file structure alignment considerations hence each
word,dword is read individually.
Input options: index=# (default: 0)

*/

#if 0
#pragma priority( -2147481424 )

/*...sincludes:0:*/
#include <stdio.h>
#include <ctype.h>
#include <stddef.h>
#include <stdlib.h>
#include <string.h>
#include <memory.h>
#include <malloc.h>
#ifdef AIX
#include <unistd.h>
#else
#include <io.h>
#endif
#include <fcntl.h>
#include <sys/types.h>
#include <sys/stat.h>

#include <igbmstnd.hpp>
#include <igbm.hpp>
#include <igbmhelp.hpp>
#include <icconst.h>
#include <ibase.hpp>
#endif // 0

#ifdef IC_WIN
#define SV_CXSCREEN            SM_CXSCREEN
#define SV_CYSCREEN            SM_CYSCREEN
#define IQUERYSYSVALUE(idx)             (GetSystemMetrics( idx ))
#endif // IC_WIN
#ifdef IC_PM
#define IQUERYSYSVALUE(idx)             (WinQuerySysValue( HWND_DESKTOP, idx ))
#endif // IC_PM

#if 0
// Segment definitions
#ifdef IC_PAGETUNE
  #define _IGBMBMP_CPP_
  #include <ipagetun.h>
#endif
#endif // 0

/*...vgbm\46\h:0:*/
/*...vgbmhelp\46\h:0:*/

#ifndef min
#define min(a,b)        (((a)<(b))?(a):(b))
#endif
/*...e*/

#ifndef SUSEFUL_0
#define SUSEFUL_0

/*...suseful:0:*/
#define low_byte(w)     ((byte)  ((w)&0x00ff)    )
#define high_byte(w)    ((byte) (((w)&0xff00)>>8))
#define make_word(a,b)  (((word)a) + (((word)b) << 8))

/*...sread_word:0:*/
static bool read_word(int fd, word *w)
        {
        byte low = 0, high = 0;

        read(fd, (char *) &low, 1);
        read(fd, (char *) &high, 1);
        *w = (word) (low + ((word) high << 8));
        return true;
        }
/*...e*/
/*...sread_dword:0:*/
static bool read_dword(int fd, dword *d)
        {
        word low, high;

        read_word(fd, &low);
        read_word(fd, &high);
        *d = low + ((dword) high << 16);
        return true;
        }
/*...e*/
/*...swrite_word:0:*/
static bool write_word(int fd, word w)
        {
        byte    low  = (byte) w;
        byte    high = (byte) (w >> 8);

        write(fd, &low, 1);
        write(fd, &high, 1);
        return true;
        }
/*...e*/
/*...swrite_dword:0:*/
static bool write_dword(int fd, dword d)
        {
        write_word(fd, (word) d);
        write_word(fd, (word) (d >> 16));
        return true;
        }
/*...e*/
/*...e*/
#endif // SUSEFUL_0

static GBMFT bmp_gbmft =
        {
        "Bitmap",
        "OS/2 1.1, 1.2, 2.0 / Windows 3.0 bitmap",
        "BMP VGA BGA RLE DIB RL4 RL8",
        GBM_FT_R1|GBM_FT_R4|GBM_FT_R8|GBM_FT_R24|
        GBM_FT_W1|GBM_FT_W4|GBM_FT_W8|GBM_FT_W24,
        };

#define GBM_ERR_BMP_PLANES      ((GBM_ERR) 300)
#define GBM_ERR_BMP_BITCOUNT    ((GBM_ERR) 301)
#define GBM_ERR_BMP_CBFIX       ((GBM_ERR) 302)
#define GBM_ERR_BMP_COMP        ((GBM_ERR) 303)
#define GBM_ERR_BMP_OFFSET      ((GBM_ERR) 304)

typedef struct
        {
        dword   base;
        bool windows;
        dword   cbFix;
        dword   ulCompression;
        dword   cclrUsed;
        dword   offBits;
        bool inv, invb;
        } BMP_PRIV;

#define BFT_BMAP        0x4d42
#define BFT_BITMAPARRAY 0x4142
#ifndef IC_PM
#define BCA_UNCOMP      0x00000000L
#define BCA_RLE8        0x00000001L
#define BCA_RLE4        0x00000002L
#define BCA_RLE24       0x00000004L
#endif
#define BCA_HUFFFMAN1D  0x00000003L
#define MSWCC_EOL       0
#define MSWCC_EOB       1
#define MSWCC_DELTA     2

/*...sinvert:0:*/
static void invert(byte *buffer, unsigned count)
        {
        while ( count-- )
                *buffer++ ^= (byte) 0xff;
        }
/*...e*/
/*...sswap_pal:0:*/
static void swap_pal(GBMRGB *gbmrgb)
        {
        GBMRGB tmp = gbmrgb[0];
        gbmrgb[0] = gbmrgb[1];
        gbmrgb[1] = tmp;
        }
/*...e*/

/*...sbmp_qft:0:*/
GBM_ERR bmp_qft(GBMFT *gbmft)
        {
        *gbmft = bmp_gbmft;
        return GBM_ERR_OK;
        }
/*...e*/
/*...sbmp_rhdr:0:*/
GBM_ERR bmp_rhdr(char *fn, int fd, GBM *gbm, char *opt)
{
  word usType,
       xHotspot,
       yHotspot;
  dword cbSize,
        offBits,
        cbFix;
  BMP_PRIV *bmp_priv = (BMP_PRIV *) gbm->priv;

  bmp_priv->inv  = ( gbm_find_word(opt, "inv" ) != NULL );
  bmp_priv->invb = ( gbm_find_word(opt, "invb") != NULL );

  fn=fn; /* Suppress 'unref arg' compiler warnings */

  lseek(fd, 0L, SEEK_SET);

  read_word(fd, &usType);

#ifndef IC_MOTIF
  if ( usType == BFT_BITMAPARRAY )
  /*...shandle bitmap arrays:16:*/
  {
    bool match(false);
    char    *index;
//  int     i;
    long    curPos;
    dword   cbSize2,
            offNext;
    word    cxScreen(IQUERYSYSVALUE(SV_CXSCREEN)),
            cyScreen(IQUERYSYSVALUE(SV_CYSCREEN)),
            xDelta(0xFFFF),
            yDelta(0xFFFF),
            cxDisplay,
            cyDisplay;

//  if ( (index = gbm_find_word_prefix(opt, "index=")) != NULL )
//    sscanf(index + 6, "%d", &i);
//  else
//    i = 0;

    read_dword(fd, &cbSize2);
    read_dword(fd, &offNext);
    read_word(fd, &cxDisplay);
    read_word(fd, &cyDisplay);
    curPos = tell( fd );

    while (!match)
    {
      if ( cxScreen == cxDisplay &&
           cyScreen == cyDisplay )
      {
        match = true;
        break;
      }
      else if (!( cxDisplay > cxScreen && cyDisplay > cyScreen)  &&

               (((cxScreen - cxDisplay) < xDelta) &&
                ((cyScreen - cyDisplay) < yDelta)))
      {
        xDelta = cxScreen - cxDisplay;
        yDelta = cyScreen - cyDisplay;
        curPos = tell( fd );
      }
      if ( offNext == 0L )
        break;
      lseek(fd, (long) offNext, SEEK_SET);
      read_word(fd, &usType);
      read_dword(fd, &cbSize2);
      read_dword(fd, &offNext);
      read_word(fd, &cxDisplay);
      read_word(fd, &cyDisplay);

      if ( usType != BFT_BITMAPARRAY )
        return GBM_ERR_BAD_MAGIC;
    }

    if (!match)
    {
      lseek(fd, curPos, SEEK_SET);
    }


//    lseek(fd, 4L + 4L + 2L + 2L, SEEK_CUR);
    read_word(fd, &usType);
  }
#endif // IC_MOTIF


  if ( usType != BFT_BMAP )
    return GBM_ERR_BAD_MAGIC;

  bmp_priv->base = lseek(fd, 0L, SEEK_CUR) - 2L;

  read_dword(fd, &cbSize);
  read_word(fd, &xHotspot);
  read_word(fd, &yHotspot);
  read_dword(fd, &offBits);
  read_dword(fd, &cbFix);

  bmp_priv->offBits = offBits;

  if ( cbFix == 12 )

  /* OS/2 1.x uncompressed bitmap */
  {
    word cx,
         cy,
         cPlanes,
         cBitCount;

    read_word(fd, &cx);
    read_word(fd, &cy);
    read_word(fd, &cPlanes);
    read_word(fd, &cBitCount);

    if ( cx == 0 || cy == 0 )
      return GBM_ERR_BAD_SIZE;
    if ( cPlanes != 1 )
      return GBM_ERR_BMP_PLANES;
    if ( cBitCount != 1 && cBitCount != 4 && cBitCount != 8 && cBitCount != 24 )
      return GBM_ERR_BMP_BITCOUNT;

    gbm->w   = (int) cx;
    gbm->h   = (int) cy;
    gbm->bpp = (int) cBitCount;

    bmp_priv->windows = false;
  }

  else if ( cbFix >= 16 && cbFix <= 64 &&
          ((cbFix & 3) == 0 || cbFix == 42 || cbFix == 46) )

  /*...sOS\47\2 2\46\0 and Windows 3\46\0:16:*/
  {
    word cPlanes,
         cBitCount,
         usUnits,
         usReserved,
         usRecording,
         usRendering;
    dword ulWidth,
          ulHeight,
          ulCompression;
    dword ulSizeImage,
          ulXPelsPerMeter,
          ulYPelsPerMeter;
    dword cclrUsed,
          cclrImportant,
          cSize1,
          cSize2,
          ulColorEncoding,
          ulIdentifier;

    read_dword(fd, &ulWidth);
    read_dword(fd, &ulHeight);
    read_word(fd, &cPlanes);
    read_word(fd, &cBitCount);

    if ( cbFix > 16 )
      read_dword(fd, &ulCompression);
    else
      ulCompression = BCA_UNCOMP;

    if ( cbFix > 20 )
      read_dword(fd, &ulSizeImage);
    if ( cbFix > 24 )
      read_dword(fd, &ulXPelsPerMeter);
    if ( cbFix > 28 )
      read_dword(fd, &ulYPelsPerMeter);
    if ( cbFix > 32 )
      read_dword(fd, &cclrUsed);
    else
      cclrUsed = ( 1 << cBitCount );
    if ( cBitCount != 24 && cclrUsed == 0 )
      cclrUsed = ( 1 << cBitCount );
    if ( cbFix > 36 )
      read_dword(fd, &cclrImportant);
    if ( cbFix > 40 )
      read_word(fd, &usUnits);
    if ( cbFix > 42 )
      read_word(fd, &usReserved);
    if ( cbFix > 44 )
      read_word(fd, &usRecording);
    if ( cbFix > 46 )
      read_word(fd, &usRendering);
    if ( cbFix > 48 )
      read_dword(fd, &cSize1);
    if ( cbFix > 52 )
      read_dword(fd, &cSize2);
    if ( cbFix > 56 )
      read_dword(fd, &ulColorEncoding);
    if ( cbFix > 60 )
      read_dword(fd, &ulIdentifier);

    if ( ulWidth == 0L || ulHeight == 0L )
      return GBM_ERR_BAD_SIZE;

    if ( cPlanes != 1 )
      return GBM_ERR_BMP_PLANES;
    if ( cBitCount != 1 && cBitCount != 4 && cBitCount != 8 && cBitCount != 24 )
      return GBM_ERR_BMP_BITCOUNT;

    gbm->w   = (int) ulWidth;
    gbm->h   = (int) ulHeight;
    gbm->bpp = (int) cBitCount;

    bmp_priv->windows       = true;
    bmp_priv->cbFix         = cbFix;
    bmp_priv->ulCompression = ulCompression;
    bmp_priv->cclrUsed      = cclrUsed;
  }

  else
    return GBM_ERR_BMP_CBFIX;

  return GBM_ERR_OK;
}

/*...sbmp_rpal:0:*/
GBM_ERR bmp_rpal(int fd, GBM *gbm, GBMRGB *gbmrgb)
{
  BMP_PRIV *bmp_priv = (BMP_PRIV *) gbm->priv;

  if ( gbm->bpp != 24 )
  {
    int i;
    byte b[4];

    if ( bmp_priv->windows )
    /*...sOS\47\2 2\46\0 and Windows 3\46\0:24:*/
    {
      lseek(fd, bmp_priv->base + 14L + bmp_priv->cbFix, SEEK_SET);
      for ( i = 0; i < (int) bmp_priv->cclrUsed; i++ )
      {
        read(fd, b, 4);
        gbmrgb[i].b = b[0];
        gbmrgb[i].g = b[1];
        gbmrgb[i].r = b[2];
      }
    }

    else
    /*...sOS\47\2 1\46\1\44\ 1\46\2:24:*/
    {
      lseek(fd, bmp_priv->base + 26L, SEEK_SET);
      for ( i = 0; i < (1 << gbm->bpp); i++ )
      {
        read(fd, b, 3);
        gbmrgb[i].b = b[0];
        gbmrgb[i].g = b[1];
        gbmrgb[i].r = b[2];
      }
    }

  }

  if ( gbm->bpp == 1 && !bmp_priv->inv )
    swap_pal(gbmrgb);

  return GBM_ERR_OK;
}

/*...sbmp_rdata:0:*/
GBM_ERR bmp_rdata(int fd, GBM *gbm, byte *data)
        {
        BMP_PRIV *bmp_priv = (BMP_PRIV *) gbm->priv;
        int cLinesWorth = ((gbm->bpp * gbm->w + 31) / 32) * 4;

        if ( bmp_priv->windows )
/*...sOS\47\2 2\46\0 and Windows 3\46\0:16:*/
{
lseek(fd, bmp_priv->offBits, SEEK_SET);

switch ( (int) bmp_priv->ulCompression )
        {
/*...sBCA_UNCOMP:24:*/
case BCA_UNCOMP:
        read(fd, data, gbm->h * cLinesWorth);
        break;
/*...e*/
/*...sBCA_RLE8:24:*/
case BCA_RLE8:
        {
        AHEAD *ahead;
        int stride = ((gbm->w + 3) & ~3);
        int x = 0, y = 0;
        bool eof8 = false;

        if ( (ahead = gbm_create_ahead(fd)) == NULL )
                return GBM_ERR_MEM;

        while ( !eof8 )
                {
                byte c = (byte) gbm_read_ahead(ahead);
                byte d = (byte) gbm_read_ahead(ahead);

                if ( c )
                        {
                        memset(data, d, c);
                        x += c;
                        data += c;
                        }
                else
                        switch ( d )
                                {
/*...sMSWCC_EOL:56:*/
case MSWCC_EOL:
        {
        int     to_eol = stride - x;

        memset(data, 0, to_eol);
        x = 0; y++;
        data += to_eol;
        }
        break;
/*...e*/
/*...sMSWCC_EOB:56:*/
case MSWCC_EOB:
        if ( y < gbm->h )
                {
                int     to_eol = stride - x;

                memset(data, 0, to_eol);
                x = 0; y++;
                data += to_eol;
                while ( y < gbm->h )
                        {
                        memset(data, 0, stride);
                        data += stride;
                        y++;
                        }
                }
        eof8 = true;
        break;
/*...e*/
/*...sMSWCC_DELTA:56:*/
case MSWCC_DELTA:
        {
        byte dx = (byte) gbm_read_ahead(ahead);
        byte dy = (byte) gbm_read_ahead(ahead);
        int fill = dx + dy * stride;

        x += dx; y += dy;

        memset(data, 0, fill);
        data += fill;
        }
        break;
/*...e*/
/*...sdefault:56:*/
default:
        {
        int     n = (int) d;

        while ( n-- > 0 )
                *data++ = (byte) gbm_read_ahead(ahead);
        x += d;
        if ( d & 1 )
                gbm_read_ahead(ahead); /* Align */
        }
        break;
/*...e*/
                                }
                }

        gbm_destroy_ahead(ahead);
        }
        break;
/*...e*/
/*...sBCA_RLE4:24:*/
case BCA_RLE4:
        {
        AHEAD *ahead;
        int x = 0, y = 0;
        bool eof4 = false;
        int inx = 0;

        if ( (ahead = gbm_create_ahead(fd)) == NULL )
                return GBM_ERR_MEM;

        memset(data, 0, gbm->h * cLinesWorth);

        while ( !eof4 )
                {
                byte c = (byte) gbm_read_ahead(ahead);
                byte d = (byte) gbm_read_ahead(ahead);

                if ( c )
                        {
                        byte h, l;
                        int i;

                        if ( x & 1 )
                                {
                                h = (byte) (d >> 4); l = (byte) (d << 4);
                                }
                        else
                                {
                                h = (byte) (d & 0xf0); l = (byte) (d & 0x0f);
                                }
                        for ( i = 0; i < (int) c; i++, x++ )
                                if ( x & 1 )
                                        data[inx++] |= l;
                                else
                                        data[inx]   |= h;
                        }
                else
                        switch ( d )
                                {
/*...sMSWCC_EOL:56:*/
case MSWCC_EOL:
        for ( ; x < gbm->w; x++ )
                if ( x & 1 )
                        inx++;
        x = 0; y++;
        inx = ((inx + 3) & ~3); /* Align output */
        break;
/*...e*/
/*...sMSWCC_EOB:56:*/
case MSWCC_EOB:
        eof4 = true;
        break;
/*...e*/
/*...sMSWCC_DELTA:56:*/
case MSWCC_DELTA:
        {
        byte dx = (byte) gbm_read_ahead(ahead);
        byte dy = (byte) gbm_read_ahead(ahead);

        y   += dy;
        inx += dy * cLinesWorth;

        if ( dx > 0 )
                {
                if ( x & 1 )
                        {
                        inx++;
                        x++;
                        dx--;
                        }

                inx += (dx / 2);
                x += dx;
                }

        }
        break;
/*...e*/
/*...sdefault:56:*/
default:
        {
        int     i, nr = 0;

        if ( x & 1 )
                {
                for ( i = 0; i < (int) d; i += 2 )
                        {
                        byte b = (byte) gbm_read_ahead(ahead);

                        data[inx++] |= (b >> 4);
                        data[inx  ] |= (b << 4);
                        nr++;
                        }
                if ( i < (int) d )
                        {
                        data[inx++] |= ((byte) gbm_read_ahead(ahead) >> 4);
                        nr++;
                        }
                }

        else
                {
                for ( i = 0; i < (int) d; i += 2 )
                        {
                        data[inx++] = (byte) gbm_read_ahead(ahead);
                        nr++;
                        }
                if ( i < (int) d )
                        {
                        data[inx] = (byte) gbm_read_ahead(ahead);
                        nr++;
                        }
                }
        x += d;

        if ( nr & 1 )
                gbm_read_ahead(ahead); /* Align input stream to next word */
        }
        break;
/*...e*/
                                }
                }

        gbm_destroy_ahead(ahead);
        }
        break;
/*...e*/
/*...sdefault:24:*/
default:
        return GBM_ERR_BMP_COMP;
/*...e*/
        }
}
/*...e*/
        else
/*...sOS\47\2 1\46\1\44\ 1\46\2:16:*/
{
lseek(fd, bmp_priv->offBits, SEEK_SET);
read(fd, data, cLinesWorth * gbm->h);
}
/*...e*/

        if ( bmp_priv->invb )
                invert(data, cLinesWorth * gbm->h);

        return GBM_ERR_OK;
        }
/*...e*/
/*...sbmp_w:0:*/
/*...swrite_inv:0:*/
static unsigned write_inv(int fd, char *buffer, unsigned count)
        {
        char small_buf[1024];
        unsigned so_far = 0, this_go, written;

        while ( so_far < count )
                {
                this_go = min(count - so_far, 1024);
                memcpy(small_buf, buffer + so_far, this_go);
                invert((unsigned char*)small_buf, this_go);       // mjs
                if ( (written = write(fd, small_buf, this_go)) != this_go )
                        return so_far + written;
                so_far += written;
                }

        return so_far;
        }
/*...e*/

GBM_ERR bmp_w(char *fn, int fd, GBM *gbm, GBMRGB *gbmrgb, byte *data, char *opt)
        {
        bool pm11 = ( gbm_find_word(opt, "1.1" ) != NULL );
        bool win  = ( gbm_find_word(opt, "win" ) != NULL ||
                         gbm_find_word(opt, "2.0" ) != NULL );
        bool inv  = ( gbm_find_word(opt, "inv" ) != NULL );
        bool invb = ( gbm_find_word(opt, "invb") != NULL );
        int cRGB;
        GBMRGB gbmrgb_1bpp[2];

        if ( pm11 && win )
                return GBM_ERR_BAD_OPTION;

        fn=fn; /* Suppress 'unref arg' compiler warning */

        cRGB = ( (1 << gbm->bpp) & 0x1ff );
                /* 1->2, 4->16, 8->256, 24->0 */

        if ( cRGB == 2 )
/*...shandle messy 1bpp case:16:*/
{
/*
The palette entries inside a 1bpp PM bitmap are not honored, or handled
correctly by most programs. Current thinking is that they have no actual
meaning. Under OS/2 PM, bitmap 1's re fg and 0's are bg, and it is the job of
the displayer to pick fg and bg. We will pick fg=black, bg=white in the bitmap
file we save. If we do not write black and white, we find that most programs
will incorrectly honor these entries giving unpredicatable (and often black on
a black background!) results.
*/

gbmrgb_1bpp[0].r = gbmrgb_1bpp[0].g = gbmrgb_1bpp[0].b = 0xff;
gbmrgb_1bpp[1].r = gbmrgb_1bpp[1].g = gbmrgb_1bpp[1].b = 0x00;

/*
We observe these values must be the wrong way around to keep most PM
programs happy, such as WorkPlace Shell WPFolder backgrounds.
*/

if ( !inv )
        swap_pal(gbmrgb_1bpp);

gbmrgb = gbmrgb_1bpp;
}
/*...e*/

        if ( pm11 )
/*...sOS\47\2 1\46\1:16:*/
{
word usType, xHotspot, yHotspot, cx, cy, cPlanes, cBitCount;
dword cbSize, offBits, cbFix;
int cLinesWorth, i, total, actual;

usType      = BFT_BMAP;
xHotspot    = 0;
yHotspot    = 0;
cbFix       = 12L;
cx          = gbm->w;
cy          = gbm->h;
cPlanes     = 1;
cBitCount   = gbm->bpp;
cLinesWorth = (((cBitCount * cx + 31) / 32) * cPlanes) * 4;
offBits     = 26L + cRGB * 3L;
cbSize      = offBits + (dword) cy * (dword) cLinesWorth;

write_word(fd, usType);
write_dword(fd, cbSize);
write_word(fd, xHotspot);
write_word(fd, yHotspot);
write_dword(fd, offBits);
write_dword(fd, cbFix);
write_word(fd, cx);
write_word(fd, cy);
write_word(fd, cPlanes);
write_word(fd, cBitCount);

for ( i = 0; i < cRGB; i++ )
        {
        byte b[3];

        b[0] = gbmrgb[i].b;
        b[1] = gbmrgb[i].g;
        b[2] = gbmrgb[i].r;
        if ( write(fd, b, 3) != 3 )
                return GBM_ERR_WRITE;
        }

total = gbm->h * cLinesWorth;
if ( invb )
        actual = write_inv(fd, (char*)data, total); // mjs
else
        actual = write(fd, (char*)data, total);     // mjs
if ( actual != total )
        return GBM_ERR_WRITE;
}
/*...e*/
        else
/*...sOS\47\2 2\46\0 and Windows 3\46\0:16:*/
{
word usType, xHotspot, yHotspot, cPlanes, cBitCount;
dword cx, cy, cbSize, offBits, cbFix, ulCompression, cbImage;
dword cxResolution, cyResolution, cclrUsed, cclrImportant;
int cLinesWorth, i, total, actual;

usType      = BFT_BMAP;
xHotspot    = 0;
yHotspot    = 0;
cbFix       = 40L;
cx          = gbm->w;
cy          = gbm->h;
cPlanes     = 1;
cBitCount   = gbm->bpp;
cLinesWorth = (((cBitCount * (int) cx + 31) / 32) * cPlanes) * 4;
offBits     = 54L + cRGB * 4L;
cbSize      = offBits + (dword) cy * (dword) cLinesWorth;

ulCompression = BCA_UNCOMP;
cbImage       = cLinesWorth * gbm->h;
cxResolution  = 0;
cyResolution  = 0;
cclrUsed      = 0;
cclrImportant = 0;

write_word(fd, usType);
write_dword(fd, cbSize);
write_word(fd, xHotspot);
write_word(fd, yHotspot);
write_dword(fd, offBits);

write_dword(fd, cbFix);
write_dword(fd, cx);
write_dword(fd, cy);
write_word(fd, cPlanes);
write_word(fd, cBitCount);
write_dword(fd, ulCompression);
write_dword(fd, cbImage);
write_dword(fd, cxResolution);
write_dword(fd, cyResolution);
write_dword(fd, cclrUsed);
write_dword(fd, cclrImportant);

for ( i = 0; i < cRGB; i++ )
        {
        byte b[4];

        b[0] = gbmrgb[i].b;
        b[1] = gbmrgb[i].g;
        b[2] = gbmrgb[i].r;
        b[3] = 0;
        if ( write(fd, b, 4) != 4 )
                return GBM_ERR_WRITE;
        }

total = gbm->h * cLinesWorth;
if ( invb )
        actual = write_inv(fd, (char*)data, total);  // mjs
else
        actual = write(fd, (char*)data, total);      // mjs
if ( actual != total )
        return GBM_ERR_WRITE;
}
/*...e*/

        return GBM_ERR_OK;
        }
/*...e*/
/*...sbmp_err:0:*/
unsigned long bmp_err(GBM_ERR rc)
        {
        switch ( (int) rc )
                {
                case GBM_ERR_BMP_PLANES:
                        return IC_GBM_BMP_PLANES;
                case GBM_ERR_BMP_BITCOUNT:
                        return IC_GBM_BMP_BITCOUNT;
                case GBM_ERR_BMP_CBFIX:
                        return IC_GBM_BMP_CBFIX;
                case GBM_ERR_BMP_COMP:
                        return IC_GBM_BMP_COMP;
                case GBM_ERR_BMP_OFFSET:
                        return IC_GBM_BMP_OFFSET;
                }
        return 0;

        }
/*
*****************************************************************************************
*                                                                                       *
* COPYRIGHT:                                                                            *
*   IBM Open Class Library                                                              *
*   (C) Copyright International Business Machines Corporation,  1997                    *
*   Licensed Material - Program-Property of IBM - All Rights Reserved.                  *
*   US Government Users Restricted Rights - Use, duplication, or disclosure             *
*   restricted by GSA ADP Schedule Contract with IBM Corp.                              *
*                                                                                       *
*****************************************************************************************
*/
// Revision: 56 1.4.1.5 source/ographic/igbm.cpp, graphics, ioc.v400, 001006 
/*

IGBMTGA.C  Truevision Targa/Vista support

Reads any uncompressed or runlength compresed type as 8 bit or 24 bit.
Writes out only as 8 bit or 24 bit.
Output options: 16,24,32, ydown,yup (default: 24 yup)

*/

#if 0
#pragma priority( -2147481424 )

/*...sincludes:0:*/
#include <stdio.h>
#include <ctype.h>
#include <stddef.h>
#include <stdlib.h>
#include <string.h>
#include <memory.h>
#include <malloc.h>
#ifdef AIX
#include <unistd.h>
#else
#include <io.h>
#endif
#include <fcntl.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <igbmstnd.hpp>
#include <igbm.hpp>
#include <igbmhelp.hpp>
#include <icconst.h>
#include <ibase.hpp>

// Segment definitions
#ifdef IC_PAGETUNE
  #define _IGBMTGA_CPP_
  #include <ipagetun.h>
#endif
#endif // 0

/*...vgbm\46\h:0:*/
/*...vgbmhelp\46\h:0:*/
/*...e*/

/*...suseful:0:*/
#define low_byte(w)     ((byte)  ((w)&0x00ff)    )
#define high_byte(w)    ((byte) (((w)&0xff00)>>8))
#define make_word(a,b)  (((word)a) + (((word)b) << 8))
/*...e*/

static GBMFT tga_gbmft =
        {
        "Targa",
        "Truevision Targa/Vista bitmap",
        "TGA VST AFI",
        GBM_FT_R8|GBM_FT_R24|
        GBM_FT_W8|GBM_FT_W24,
        };

#define GBM_ERR_TGA_BAD_BPP     ((GBM_ERR) 400)
#define GBM_ERR_TGA_BAD_TYPE    ((GBM_ERR) 401)
#define GBM_ERR_TGA_BAD_PAL     ((GBM_ERR) 402)

/*...starga file header definition:0:*/
/*

A Targa file is a header, followed by an identification string, followed by
a color map, followed by the data for the image. Both the identification
string and the color-map can be of zero length.

*/

#define TGA_NO_IMAGE    0               /* No image data included in file    */
#define TGA_UNCOMP_CM   1               /* Uncompressed, Color-Mapped (VDA/D */
                                        /* and Targa M-8 images)             */
#define TGA_UNCOMP_RGB  2               /* Uncompressed, RGB images (eg: ICB */
                                        /* Targa 16, 24 and 32)              */
#define TGA_UNCOMP_BW   3               /* Uncompressed, B/W images (eg:     */
                                        /* Targa 8 and Targa M-8 images)     */
#define TGA_RL_CM       9               /* Run-length, Color-Mapped (VDA/D   */
                                        /* and Targa M-8 images)             */
#define TGA_RL_RGB      10              /* Run-length, RGB images (eg: ICB   */
                                        /* Targa 16, 24 and 32)              */
#define TGA_RL_BW       11              /* Run-length, B/W images (eg: Targa */
                                        /* 8 and Targa M-8)                  */
#define TGA_COMP_CM     32              /* Compressed Color-Mapped (VDA/D)   */
                                        /* data using Huffman, Delta, and    */
                                        /* run length encoding               */
#define TGA_COMP_CM_4   33              /* Compressed Color-Mapped (VDA/D)   */
                                        /* data using Huffman, Delta, and    */
                                        /* run length encoding in 4 passes   */

#define IDB_ATTRIBUTES  0x0f            /* How many attrib bits per pixel    */
                                        /* ie: 1 for T16, 8 for T32          */
#define IDB_ORIGIN      0x20            /* Origin in top left corner bit     */
                                        /* else its in bottom left corner    */
#define IDB_INTERLEAVE  0xc0            /* Interleave bits as defined below  */
#define IDB_NON_INT     0x00            /* Non-Interlaced                    */
#define IDB_2_WAY       0x40            /* 2 way (even/odd) interleaving     */
#define IDB_4_WAY       0x80            /* 4 way interleaving (eg: AT&T PC)  */

typedef struct
        {
        byte n_chars_in_id;             /* Length of identification text     */
        byte color_map_present;         /* 0 means no, 1 yes                 */
        byte image_type;                /* Type of image file, one of TGA_   */
        byte color_map_start_low;       /* These 5 bytes are only valid if   */
        byte color_map_start_high;      /* color_map_present is 1. They      */
        byte color_map_length_low;      /* Specify the size of the color map */
        byte color_map_length_high;     /* and where it starts from          */
        byte color_map_entry_bits;      /* Bits per color map entry          */
                                        /* Typically 15, 16, 24 or 32        */
        byte x_origin_low;
        byte x_origin_high;
        byte y_origin_low;
        byte y_origin_high;
        byte width_low;
        byte width_high;
        byte height_low;
        byte height_high;
        byte bpp;                       /* Typically 16, 24 or 32            */
        byte image_descriptor;          /* Split into IDB_ bits              */
        } TGA_HEADER;

#define SIZEOF_TGA_HEADER 18
/*...e*/
/*...sconverters:0:*/
/*...st24_t32:0:*/
static void t24_t32(byte *dest, byte *src, int n)
        {
        while ( n-- )
                {
                *dest++ = *src++;
                *dest++ = *src++;
                *dest++ = *src++;
                dest++;
                }
        }
/*...e*/
/*...st32_t24:0:*/
static void t32_t24(byte *dest, byte *src, int n)
        {
        while ( n-- )
                {
                *dest++ = *src++;
                *dest++ = *src++;
                *dest++ = *src++;
                src++;
                }
        }
/*...e*/
/*...st24_t16:0:*/
static void t24_t16(byte *dest, byte *src, int n)
        {
        while ( n-- )
                {
                word    b = (word) (*src++ & 0xf8);
                word    g = (word) (*src++ & 0xf8);
                word    r = (word) (*src++ & 0xf8);
                word    w;

                w = ((r << 7) | (g << 2) | (b >> 3));

                *dest++ = (byte)  w;
                *dest++ = (byte) (w >> 8);
                }
        }
/*...e*/
/*...st16_t24:0:*/
static void t16_t24(byte *dest, byte *src, int n)
        {
        while ( n-- )
                {
                word    l = *src++;
                word    h = *src++;
                word    w = l + (h << 8);

                *dest++ = (byte) ((w & 0x001f) << 3);
                *dest++ = (byte) ((w & 0x03e0) >> 2);
                *dest++ = (byte) ((w & 0x7c00) >> 7);
                }
        }
/*...e*/
/*...e*/
typedef struct
        {
        TGA_HEADER header;
        } TGA_PRIV;

/*...stga_qft:0:*/
GBM_ERR tga_qft(GBMFT *gbmft)
        {
        *gbmft = tga_gbmft;
        return GBM_ERR_OK;
        }
/*...e*/
/*...stga_rhdr:0:*/
GBM_ERR tga_rhdr(char *fn, int fd, GBM *gbm, char *opt)
        {
        TGA_PRIV *priv = (TGA_PRIV *) gbm->priv;

        fn=fn; opt=opt; /* Suppress 'unref arg' compiler warnings */

        lseek(fd, 0L, SEEK_SET);
        read(fd, (char *) &(priv->header), SIZEOF_TGA_HEADER);

        switch ( priv->header.image_type )
                {
                case TGA_RL_BW:
                case TGA_UNCOMP_BW:
                        if ( priv->header.bpp != 8 )
                                return GBM_ERR_TGA_BAD_BPP;
                        break;
                case TGA_RL_CM:
                case TGA_UNCOMP_CM:
                        if ( priv->header.bpp != 8 )
                                return GBM_ERR_TGA_BAD_BPP;
                        if ( priv->header.color_map_entry_bits != 24 )
                                return GBM_ERR_TGA_BAD_PAL;
                        break;
                case TGA_RL_RGB:
                case TGA_UNCOMP_RGB:
                        if ( priv->header.bpp != 16 &&
                             priv->header.bpp != 24 &&
                             priv->header.bpp != 32 )
                                return GBM_ERR_TGA_BAD_BPP;
                        break;
                default:
                        return GBM_ERR_TGA_BAD_TYPE;
                }

        gbm->w = make_word(priv->header.width_low , priv->header.width_high );
        gbm->h = make_word(priv->header.height_low, priv->header.height_high);

        if ( gbm->w <= 0 || gbm->h <= 0 )
                return GBM_ERR_BAD_SIZE;

        gbm->bpp = ( priv->header.bpp == 8 ) ? 8 : 24;

        return GBM_ERR_OK;
        }
/*...e*/
/*...stga_rpal:0:*/
GBM_ERR tga_rpal(int fd, GBM *gbm, GBMRGB *gbmrgb)
        {
        TGA_PRIV *priv = (TGA_PRIV *) gbm->priv;

        switch ( priv->header.image_type )
                {
/*...sTGA_UNCOMP_BW\44\ TGA_RL_BW:16:*/
case TGA_UNCOMP_BW:
case TGA_RL_BW:
        {
        int i;
        for (  i = 0; i < 0x100; i++ )
                gbmrgb[i].b =
                gbmrgb[i].g =
                gbmrgb[i].r = (byte) i;
        }
        break;
/*...e*/
/*...sTGA_UNCOMP_CM\44\ TGA_RL_CM:16:*/
case TGA_UNCOMP_CM:
case TGA_RL_CM:
        {
        int color_map_start, color_map_length, i;

        lseek(fd, (long) (SIZEOF_TGA_HEADER+priv->header.n_chars_in_id), SEEK_SET);

        color_map_start  = make_word(priv->header.color_map_start_low , priv->header.color_map_start_high );
        color_map_length = make_word(priv->header.color_map_length_low, priv->header.color_map_length_high);

        memset(gbmrgb, 0, 0x100 * sizeof(GBMRGB));
        for ( i = color_map_start; i < color_map_start + color_map_length; i++ )
                {
                byte b[3];

                if ( read(fd, (char *) b, 3) != 3 )
                        return GBM_ERR_READ;
                gbmrgb[i].b = b[0];
                gbmrgb[i].g = b[1];
                gbmrgb[i].r = b[2];
                }
        }
        break;
/*...e*/
                }

        return GBM_ERR_OK;
        }
/*...e*/
/*...stga_rdata:0:*/
GBM_ERR tga_rdata(int fd, GBM *gbm, byte *data)
        {
        TGA_PRIV *priv = (TGA_PRIV *) gbm->priv;
        byte *p;
        int i, stride;

        lseek(fd, (long) (SIZEOF_TGA_HEADER + priv->header.n_chars_in_id), SEEK_SET);

        if ( priv->header.color_map_present )
                {
                int color_map_length;
                int bpp_pal = priv->header.color_map_entry_bits;
                        /* Valid values are 32, 24, 16 and sometimes 15 */

                if ( bpp_pal == 15 ) bpp_pal = 16;

                color_map_length = make_word(priv->header.color_map_length_low, priv->header.color_map_length_high);
                lseek(fd, (long) ((color_map_length * bpp_pal) / 8L), SEEK_CUR);
                }

        stride = ((gbm->w*gbm->bpp + 31) / 32) * 4;
        p = data;
        if ( (priv->header.image_descriptor & IDB_ORIGIN) != 0 )
                {
                p += (gbm->h-1) * stride;
                stride = -stride;
                }

        switch ( priv->header.image_type )
                {
/*...sTGA_RL_BW\44\ TGA_RL_CM\44\ TGA_RL_RGB:16:*/
case TGA_RL_CM:
case TGA_RL_BW:
case TGA_RL_RGB:
        {
        AHEAD *ahead;
        int x = 0, y = 0;
        if ( (ahead = gbm_create_ahead(fd)) == NULL )
                return GBM_ERR_MEM;
        switch ( priv->header.bpp )
                {
/*...s8:32:*/
case 8:
        while ( y < gbm->h )
                {
                int i, cnt = gbm_read_ahead(ahead);
                if ( cnt == -1 )
                        {
                        gbm_destroy_ahead(ahead);
                        return GBM_ERR_READ;
                        }
                if ( cnt & 0x80 )
                        {
                        byte v = (byte) gbm_read_ahead(ahead);
                        for ( i = 0x80; i <= cnt; i++ )
                                {
                                data[x++] = v;
                                if ( x == gbm->w )
                                        { x = 0; y++; data += stride; }
                                }
                        }
                else
                        for ( i = 0; i <= cnt; i++ )
                                {
                                data[x++] = (byte) gbm_read_ahead(ahead);
                                if ( x == gbm->w )
                                        { x = 0; y++; data += stride; }
                                }
                }
        break;
/*...e*/
/*...s16:32:*/
/*
We have 3 bytes per pixel in the data array, indexed by p.
We will read 2 bytes per pixel into the right hand 2/3 of each line.
Then we will expand leftwards to fill the full width afterwards.
*/

case 16:

        p += gbm->w;

        while ( y < gbm->h )
                {
                int i, cnt = gbm_read_ahead(ahead);
                if ( cnt == -1 )
                        {
                        gbm_destroy_ahead(ahead);
                        return GBM_ERR_READ;
                        }
                if ( cnt & 0x80 )
                        {
                        byte v1 = (byte) gbm_read_ahead(ahead);
                        byte v2 = (byte) gbm_read_ahead(ahead);
                        for ( i = 0x80; i <= cnt; i++ )
                                {
                                p[x++] = v1;
                                p[x++] = v2;
                                if ( x == gbm->w*2 )
                                        { x = 0; y++; p += stride; }
                                }
                        }
                else
                        for ( i = 0; i <= cnt; i++ )
                                {
                                p[x++] = (byte) gbm_read_ahead(ahead);
                                p[x++] = (byte) gbm_read_ahead(ahead);
                                if ( x == gbm->w*2 )
                                        { x = 0; y++; p += stride; }
                                }
                }

        if ( stride < 0 )
                stride = -stride;
        for ( y = 0, p = data; y < gbm->h; y++, p += stride )
                t16_t24(p, p+gbm->w, gbm->w);

        break;
/*...e*/
/*...s24:32:*/
case 24:
        while ( y < gbm->h )
                {
                int i, cnt = gbm_read_ahead(ahead);
                if ( cnt == -1 )
                        {
                        gbm_destroy_ahead(ahead);
                        return GBM_ERR_READ;
                        }
                if ( cnt & 0x80 )
                        {
                        byte v1 = (byte) gbm_read_ahead(ahead);
                        byte v2 = (byte) gbm_read_ahead(ahead);
                        byte v3 = (byte) gbm_read_ahead(ahead);
                        for ( i = 0x80; i <= cnt; i++ )
                                {
                                p[x++] = v1;
                                p[x++] = v2;
                                p[x++] = v3;
                                if ( x == gbm->w*3 )
                                        { x = 0; y++; p += stride; }
                                }
                        }
                else
                        for ( i = 0; i <= cnt; i++ )
                                {
                                p[x++] = (byte) gbm_read_ahead(ahead);
                                p[x++] = (byte) gbm_read_ahead(ahead);
                                p[x++] = (byte) gbm_read_ahead(ahead);
                                if ( x == gbm->w*3 )
                                        { x = 0; y++; p += stride; }
                                }
                }
        break;
/*...e*/
/*...s32:32:*/
case 32:
        while ( y < gbm->h )
                {
                int i, cnt = gbm_read_ahead(ahead);
                if ( cnt == -1 )
                        {
                        gbm_destroy_ahead(ahead);
                        return GBM_ERR_READ;
                        }
                if ( cnt & 0x80 )
                        {
                        byte v1 = (byte) gbm_read_ahead(ahead);
                        byte v2 = (byte) gbm_read_ahead(ahead);
                        byte v3 = (byte) gbm_read_ahead(ahead);
                        gbm_read_ahead(ahead); /* Discard alpha channel */
                        for ( i = 0x80; i <= cnt; i++ )
                                {
                                p[x++] = v1;
                                p[x++] = v2;
                                p[x++] = v3;
                                if ( x == gbm->w*3 )
                                        { x = 0; y++; p += stride; }
                                }
                        }
                else
                        for ( i = 0; i <= cnt; i++ )
                                {
                                p[x++] = (byte) gbm_read_ahead(ahead);
                                p[x++] = (byte) gbm_read_ahead(ahead);
                                p[x++] = (byte) gbm_read_ahead(ahead);
                                gbm_read_ahead(ahead); /* Discard alpha channel */
                                if ( x == gbm->w*3 )
                                        { x = 0; y++; p += stride; }
                                }
                }
        break;
/*...e*/
                }
        gbm_destroy_ahead(ahead);
        }
        break;
/*...e*/
/*...sTGA_UNCOMP_BW\44\ TGA_UNCOMP_CM\44\ TGA_UNCOMP_RGB:16:*/
case TGA_UNCOMP_BW:
case TGA_UNCOMP_CM:
case TGA_UNCOMP_RGB:
        switch ( priv->header.bpp )
                {
/*...s8:32:*/
case 8:
        for ( i = 0; i < gbm->h; i++, p += stride )
                if ( read(fd, p, gbm->w) != gbm->w )
                        return GBM_ERR_READ;
        break;
/*...e*/
/*...s16:32:*/
case 16:
        for ( i = 0; i < gbm->h; i++, p += stride )
                {
                if ( read(fd, p+gbm->w, gbm->w * 2) != gbm->w * 2 )
                        return GBM_ERR_READ;
                t16_t24(p, p+gbm->w, gbm->w);
                }
        break;
/*...e*/
/*...s24:32:*/
case 24:
        for ( i = 0; i < gbm->h; i++, p += stride )
                if ( read(fd, p, gbm->w * 3) != gbm->w * 3 )
                        return GBM_ERR_READ;
        break;
/*...e*/
/*...s32:32:*/
case 32:
        {
        byte *linebuf;
        if ( (linebuf = (byte*)malloc(gbm->w * 4)) == NULL )   // mjs
                return GBM_ERR_MEM;

        for ( i = 0; i < gbm->h; i++, p += stride )
                {
                if ( read(fd, linebuf, gbm->w * 4) != gbm->w * 4 )
                        {
                        free(linebuf);
                        return GBM_ERR_READ;
                        }
                t32_t24(p, linebuf, gbm->w);
                }

        free(linebuf);
        }
        break;
/*...e*/
                }
        break;
/*...e*/
                }

        return GBM_ERR_OK;
        }
/*...e*/
/*...stga_w:0:*/
#define SW3(a,b,c)      ((a)*4+(b)*2+(c))

GBM_ERR tga_w(char *fn, int fd, GBM *gbm, GBMRGB *gbmrgb, byte *data, char *opt)
        {
        TGA_HEADER tga_header;
        int i, stride, obpp;
        byte *p;
        bool o16   = ( gbm_find_word(opt, "16"   ) != NULL );
        bool o24   = ( gbm_find_word(opt, "24"   ) != NULL );
        bool o32   = ( gbm_find_word(opt, "32"   ) != NULL );
        bool yup   = ( gbm_find_word(opt, "yup"  ) != NULL );
        bool ydown = ( gbm_find_word(opt, "ydown") != NULL );

        fn=fn; /* Suppress 'unref arg' compiler warning */

        if ( gbm->bpp == 24 )
                switch ( SW3(o16,o24,o32) )
                        {
                        case SW3(1,0,0):        obpp = 16;      break;
                        case SW3(0,0,0):
                        case SW3(0,1,0):        obpp = 24;      break;
                        case SW3(0,0,1):        obpp = 32;      break;
                        default:                return GBM_ERR_BAD_OPTION;
                        }
        else
                {
                if ( o16 || o24 || o32 )
                        return GBM_ERR_BAD_OPTION;
                obpp = 8;
                }

        if ( yup && ydown )
                return GBM_ERR_BAD_OPTION;

        tga_header.n_chars_in_id         = 0;
        tga_header.image_type            = ( obpp == 8 ) ? TGA_UNCOMP_CM : TGA_UNCOMP_RGB;
        tga_header.x_origin_low          = low_byte(0);
        tga_header.x_origin_high         = high_byte(0);
        tga_header.y_origin_low          = low_byte(0);
        tga_header.y_origin_high         = high_byte(0);
        tga_header.color_map_start_low   = low_byte(0);
        tga_header.color_map_start_high  = high_byte(0);
        if ( gbm->bpp == 8 )
                {
                tga_header.color_map_present     = (byte) 1;
                tga_header.color_map_length_low  = low_byte(0x100);
                tga_header.color_map_length_high = high_byte(0x100);
                tga_header.color_map_entry_bits  = 24;
                }
        else
                {
                tga_header.color_map_present     = (byte) 0;
                tga_header.color_map_length_low  = low_byte(0);
                tga_header.color_map_length_high = high_byte(0);
                tga_header.color_map_entry_bits  = 0;
                }
        tga_header.width_low             = low_byte(gbm->w);
        tga_header.width_high            = high_byte(gbm->w);
        tga_header.height_low            = low_byte(gbm->h);
        tga_header.height_high           = high_byte(gbm->h);
        tga_header.bpp                   = (byte) obpp;
        tga_header.image_descriptor      = IDB_NON_INT;

        if ( ydown )
                tga_header.image_descriptor |= IDB_ORIGIN;

        write(fd, (char *) &tga_header, SIZEOF_TGA_HEADER);

        switch ( obpp )
                {
/*...s8:16:*/
case 8:
        for ( i = 0; i < 0x100; i++ )
                {
                byte    b[3];

                b[0] = gbmrgb[i].b;
                b[1] = gbmrgb[i].g;
                b[2] = gbmrgb[i].r;
                write(fd, b, 3);
                }

        stride = ((gbm->w + 3) & ~3);
        p = data;

        if ( ydown )
                {
                data += ((gbm->h - 1) * stride);
                stride = -stride;
                }

        for ( i = 0; i < gbm->h; i++ )
                {
                write(fd, p, gbm->w);
                p += stride;
                }
        break;
/*...e*/
/*...s16:16:*/
case 16:
        {
        byte    *linebuf;

        if ( (linebuf = (byte*)malloc(gbm->w * 2)) == NULL )  // mjs
                return GBM_ERR_MEM;

        stride = ((gbm->w * 3 + 3) & ~3);
        p = data;

        if ( ydown )
                {
                data += ((gbm->h - 1) * stride);
                stride = -stride;
                }

        for ( i = 0; i < gbm->h; i++ )
                {
                t24_t16(linebuf, p, gbm->w);
                write(fd, linebuf, gbm->w * 2);
                p += stride;
                }

        free(linebuf);
        }
        break;
/*...e*/
/*...s24:16:*/
case 24:
        stride = ((gbm->w * 3 + 3) & ~3);
        p = data;

        if ( ydown )
                {
                data += ((gbm->h - 1) * stride);
                stride = -stride;
                }

        for ( i = 0; i < gbm->h; i++ )
                {
                write(fd, p, gbm->w * 3);
                p += stride;
                }
        break;
/*...e*/
/*...s32:16:*/
case 32:
        {
        byte    *linebuf;

        if ( (linebuf = (byte*)malloc(gbm->w * 4)) == NULL )  // mjs
                return GBM_ERR_MEM;

        stride = ((gbm->w * 3 + 3) & ~3);
        p = data;

        if ( ydown )
                {
                data += ((gbm->h - 1) * stride);
                stride = -stride;
                }

        for ( i = 0; i < gbm->h; i++ )
                {
                t24_t32(linebuf, p, gbm->w);
                write(fd, linebuf, gbm->w * 4);
                p += stride;
                }

        free(linebuf);
        }
        break;
/*...e*/
                }

        return GBM_ERR_OK;
        }
/*...e*/
/*...stga_err:0:*/
unsigned long tga_err(GBM_ERR rc)
        {
        switch ( (int) rc )
                {
                case GBM_ERR_TGA_BAD_BPP:
                        return IC_GBM_TGA_BAD_BPP;
                case GBM_ERR_TGA_BAD_TYPE:
                        return IC_GBM_TGA_BAD_TYPE;
                case GBM_ERR_TGA_BAD_PAL:
                        return IC_GBM_TGA_BAD_PAL;
                }
        return 0;
        }
/*...e*/
/*
*****************************************************************************************
*                                                                                       *
* COPYRIGHT:                                                                            *
*   IBM Open Class Library                                                              *
*   (C) Copyright International Business Machines Corporation,  1997                    *
*   Licensed Material - Program-Property of IBM - All Rights Reserved.                  *
*   US Government Users Restricted Rights - Use, duplication, or disclosure             *
*   restricted by GSA ADP Schedule Contract with IBM Corp.                              *
*                                                                                       *
*****************************************************************************************
*/
// Revision: 56 1.4.1.5 source/ographic/igbm.cpp, graphics, ioc.v400, 001006 
/*

IGBMKPS.C  IBM KIPS support

Reads array as 8 bit palettised colour.
Writes 8 bit palettised colour.
Input options: pal,kpl (default: pal)
Output options: pal,kpl (default: pal)

*/

#if 0
#pragma priority( -2147481424 )

/*...sincludes:0:*/
#include <stdio.h>
#include <ctype.h>
#include <stddef.h>
#include <stdlib.h>
#include <string.h>
#include <memory.h>
#include <malloc.h>
#ifdef AIX
#include <unistd.h>
#else
#include <io.h>
#endif
#include <fcntl.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <igbmstnd.hpp>
#include <igbm.hpp>
#include <igbmhelp.hpp>
#include <icconst.h>
#include <ibase.hpp>

// Segment definitions
#ifdef IC_PAGETUNE
  #define _IGBMKPS_CPP_
  #include <ipagetun.h>
#endif
#endif // 0

/*...vgbm\46\h:0:*/
/*...vgbmhelp\46\h:0:*/

/* Handle case for UNIX machines where O_BINARY has no meaning */

#ifndef O_BINARY
#define O_BINARY        0
#endif
/*...e*/

/*...suseful:0:*/
#define low_byte(w)     ((byte)  ((w)&0x00ff)    )
#define high_byte(w)    ((byte) (((w)&0xff00)>>8))
#define make_word(a,b)  (((word)a) + (((word)b) << 8))
/*...e*/
/*...sextension:0:*/
#ifndef DEFINED_EXXXTENSION_FN
#define DEFINED_EXXXTENSION_FN
static char *extension(char *fn)
        {
        char    *dot, *slash;

        if ( (dot = strrchr(fn, '.')) == NULL )
                return NULL;

        if ( (slash = strpbrk(fn, "/\\")) == NULL )
                return dot + 1;

        return ( slash < dot ) ? dot + 1 : NULL;
        }
/*...e*/
#endif // DEFINED_EXXXTENSION_FN

static GBMFT kps_gbmft =
        {
        "KIPS",
        "IBM KIPS",
        "KPS",
        GBM_FT_R8|
        GBM_FT_W8,
        };

#define GBM_ERR_KPS_OPEN        ((GBM_ERR) 500)
#define GBM_ERR_KPS_CREATE      ((GBM_ERR) 501)

/*...skps file header definition:0:*/
/*
This defines the 32 byte header found on .KPS and .KPL files.
*/

#define KPS_SIGNITURE   "DFIMAG00"

typedef struct
        {
        byte    signiture[8];           /* Usually "DFIMAG00"                */
        byte    height_low;
        byte    height_high;            /* Image height in pixels            */
        byte    width_low;
        byte    width_high;             /* Image width in pixels             */
        byte    unknown[20];            /* 20 unknown bytes                  */
        } KPS_HEADER;
/*...e*/

typedef struct
        {
        char    fn[600+1];
        bool kpl;
        } KPS_PRIV;

/*...skps_qft:0:*/
GBM_ERR kps_qft(GBMFT *gbmft)
        {
        *gbmft = kps_gbmft;
        return GBM_ERR_OK;
        }
/*...e*/
/*...skps_rhdr:0:*/
GBM_ERR kps_rhdr(char *fn, int fd, GBM *gbm, char *opt)
        {
        bool pal = ( gbm_find_word(opt, "pal") != NULL );
        bool kpl = ( gbm_find_word(opt, "kpl") != NULL );
        KPS_HEADER kps_header;
        KPS_PRIV *priv = (KPS_PRIV *) gbm->priv;
        int     w, h;

        if ( kpl && pal )
                return GBM_ERR_BAD_OPTION;

        read(fd, (char *) &kps_header, sizeof(KPS_HEADER));

        if ( memcmp(kps_header.signiture, KPS_SIGNITURE, strlen(KPS_SIGNITURE)) )
                return GBM_ERR_BAD_MAGIC;

        w = make_word(kps_header.width_low , kps_header.width_high );
        h = make_word(kps_header.height_low, kps_header.height_high);

        if ( w <= 0 || h <= 0 )
                return GBM_ERR_BAD_SIZE;

        gbm->w   = w;
        gbm->h   = h;
        gbm->bpp = 8;

        /* Keep these for a later kps_rpal() call */

        strcpy(priv->fn, fn);
        priv->kpl = kpl;

        return GBM_ERR_OK;
        }
/*...e*/
/*...skps_rpal:0:*/
GBM_ERR kps_rpal(int fd, GBM *gbm, GBMRGB *gbmrgb)
        {
        KPS_PRIV *priv = (KPS_PRIV *) gbm->priv;
        char    fn2[600+1], *ext;

        fd=fd; /* Suppress 'unref arg' compiler warning */

        strcpy(fn2, priv->fn);
        ext = extension(fn2);
        if ( priv->kpl )
/*...sread a \46\kpl palette file:16:*/
{
int     fd2, i, w, h;
byte    p[3][0x100];
KPS_HEADER kps_header;

if ( ext != NULL )
        strcpy(ext, "kpl");
else
        strcat(fn2, ".kpl");

if ( (fd2 = open(fn2, O_RDONLY | O_BINARY)) == -1 )
        return GBM_ERR_KPS_OPEN;

read(fd2, (char *) &kps_header, sizeof(KPS_HEADER));
if ( memcmp(kps_header.signiture, KPS_SIGNITURE, strlen(KPS_SIGNITURE)) )
        return GBM_ERR_BAD_MAGIC;

w = make_word(kps_header.width_low , kps_header.width_high );
h = make_word(kps_header.height_low, kps_header.height_high);

if ( w != 0x100 || h != 3 )
        return GBM_ERR_BAD_SIZE;

read(fd2, &(p[0][0]), 0x300);
close(fd2);

for ( i = 0; i < 0x100; i++ )
        {
        gbmrgb[i].r = p[0][i];
        gbmrgb[i].b = p[1][i];
        gbmrgb[i].g = p[2][i];
        }
}
/*...e*/
        else
/*...sread a \46\pal palette file:16:*/
{
int     fd2, i;
byte    b[4];

if ( ext != NULL )
        strcpy(ext, "pal");
else
        strcat(fn2, ".pal");

if ( (fd2 = open(fn2, O_RDONLY | O_BINARY)) == -1 )
        return GBM_ERR_KPS_OPEN;

for ( i = 0; i < 0x100; i++ )
        {
        read(fd2, (char *) b, 4);
        gbmrgb[i].r = b[0];
        gbmrgb[i].b = b[1];
        gbmrgb[i].g = b[2];
        }
close(fd2);
}
/*...e*/

        return GBM_ERR_OK;
        }
/*...e*/
/*...skps_rdata:0:*/
GBM_ERR kps_rdata(int fd, GBM *gbm, byte *data)
        {
        int     i, stride;
        byte    *p;

        stride = ((gbm->w + 3) & ~3);
        p = data + ((gbm->h - 1) * stride);
        for ( i = gbm->h - 1; i >= 0; i-- )
                {
                read(fd, p, gbm->w);
                p -= stride;
                }

        return GBM_ERR_OK;
        }
/*...e*/
/*...skps_w:0:*/
GBM_ERR kps_w(char *fn, int fd, GBM *gbm, GBMRGB *gbmrgb, byte *data, char *opt)
        {
        KPS_HEADER kps_header;
        int     i, stride;
        byte    *p;
        char    fn2[600+1], *ext;
        bool pal = ( gbm_find_word(opt, "pal") != NULL );
        bool kpl = ( gbm_find_word(opt, "kpl") != NULL );

        if ( gbm->bpp != 8 )
                return GBM_ERR_NOT_SUPP;

        if ( pal && kpl )
                return GBM_ERR_BAD_OPTION;

        memcpy(kps_header.signiture, KPS_SIGNITURE, strlen(KPS_SIGNITURE));
        kps_header.width_low   = low_byte(gbm->w);
        kps_header.width_high  = high_byte(gbm->w);
        kps_header.height_low  = low_byte(gbm->h);
        kps_header.height_high = high_byte(gbm->h);
        kps_header.unknown[0] = 1;
        memset(&kps_header.unknown[1], 0, 19);
        write(fd, (char *) &kps_header, sizeof(KPS_HEADER));

        stride = ((gbm->w + 3) & ~3);
        p = data + ((gbm->h - 1) * stride);
        for ( i = gbm->h - 1; i >= 0; i-- )
                {
                write(fd, p, gbm->w);
                p -= stride;
                }

        strcpy(fn2, fn);
        ext = extension(fn2);
        if ( kpl )
/*...swrite a \46\kpl palette file:16:*/
{
int     fd2, j;
byte    palette[3][0x100];

if ( ext != NULL )
        strcpy(ext, "kpl");
else
        strcat(fn2, ".kpl");

if ( (fd2 = open(fn2, O_CREAT | O_TRUNC | O_WRONLY | O_BINARY, S_IREAD | S_IWRITE)) == -1 )
        return GBM_ERR_KPS_CREATE;

kps_header.width_low   = low_byte(0x100);
kps_header.width_high  = high_byte(0x100);
kps_header.height_low  = low_byte(3);
kps_header.height_high = high_byte(3);
write(fd2, (char *) &kps_header, sizeof(KPS_HEADER));

for ( j = 0; j < 0x100; j++ )
        {
        palette[0][j] = gbmrgb[j].r;
        palette[1][j] = gbmrgb[j].b;
        palette[2][j] = gbmrgb[j].g;
        }

write(fd2, &(palette[0][0]), 0x300);
close(fd2);
}
/*...e*/
        else
/*...swrite a \46\pal palette file:16:*/
{
int     fd2;
byte    b[4];

if ( ext != NULL )
        strcpy(ext, "pal");
else
        strcat(fn2, ".pal");

if ( (fd2 = open(fn2, O_CREAT | O_TRUNC | O_WRONLY | O_BINARY, S_IREAD | S_IWRITE)) == -1 )
        return GBM_ERR_KPS_CREATE;

b[3] = 0;
for ( i = 0; i < 0x100; i++ )
        {
        b[0] = gbmrgb[i].r;
        b[1] = gbmrgb[i].b;
        b[2] = gbmrgb[i].g;
        write(fd2, (char *) b, 4);
        }
close(fd2);
}
/*...e*/

        return GBM_ERR_OK;
        }
/*...e*/
/*...skps_err:0:*/
unsigned long kps_err(GBM_ERR rc)
        {
        switch ( (int) rc )
                {
                case GBM_ERR_KPS_OPEN:
                        return IC_GBM_KPS_OPEN;
                case GBM_ERR_KPS_CREATE:
                        return IC_GBM_KPS_CREATE;
                }
        return 0;
        }
/*
*****************************************************************************************
*                                                                                       *
* COPYRIGHT:                                                                            *
*   IBM Open Class Library                                                              *
*   (C) Copyright International Business Machines Corporation,  1997                    *
*   Licensed Material - Program-Property of IBM - All Rights Reserved.                  *
*   US Government Users Restricted Rights - Use, duplication, or disclosure             *
*   restricted by GSA ADP Schedule Contract with IBM Corp.                              *
*                                                                                       *
*****************************************************************************************
*/
// Revision: 56 1.4.1.5 source/ographic/igbm.cpp, graphics, ioc.v400, 001006 
/*

IGBMIAX.C  IBM Image Access eXecutive support

Reads array as 8 bit greyscale.
Writes grey equivelent of passed in 8 bit colour data (no palette written).
Input options: width=# (default: 512)
Output options: r,g,b,k (default: k)

*/

#if 0
#pragma priority( -2147481424 )

/*...sincludes:0:*/
#include <stdio.h>
#include <ctype.h>
#include <stddef.h>
#include <stdlib.h>
#include <string.h>
#include <memory.h>
#include <malloc.h>
#ifdef AIX
#include <unistd.h>
#else
#include <io.h>
#endif
#include <fcntl.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <igbmstnd.hpp>
#include <igbm.hpp>
#include <igbmhelp.hpp>
#include <icconst.h>
#include <ibase.hpp>

// Segment definitions
#ifdef IC_PAGETUNE
  #define _IGBMIAX_CPP_
  #include <ipagetun.h>
#endif
#endif // 0

/*...vgbm\46\h:0:*/
/*...vgbmhelp\46\h:0:*/
/*...e*/

/*...suseful:0:*/
#define low_byte(w)     ((byte)  ((w)&0x00ff)    )
#define high_byte(w)    ((byte) (((w)&0xff00)>>8))
#define make_word(a,b)  (((word)a) + (((word)b) << 8))
/*...e*/
/*...smake_output_palette:0:*/
#define SW4(a,b,c,d)    ((a)*8+(b)*4+(c)*2+(d))

#ifndef DEFINED_MAKE_OUTPUT_PALETTE
#define DEFINED_MAKE_OUTPUT_PALETTE
static bool make_output_palette(GBMRGB gbmrgb[], byte grey[], char *opt)
        {
        bool k = ( gbm_find_word(opt, "k") != NULL );
        bool r = ( gbm_find_word(opt, "r") != NULL );
        bool g = ( gbm_find_word(opt, "g") != NULL );
        bool b = ( gbm_find_word(opt, "b") != NULL );
        int     i;

        switch ( SW4(k,r,g,b) )
                {
                case SW4(0,0,0,0):
                        /* Default is the same as "k" */
                case SW4(1,0,0,0):
                        for ( i = 0; i < 0x100; i++ )
                                grey[i] = (byte) ( ((word) gbmrgb[i].r *  77 +
                                                     (word) gbmrgb[i].g * 151 +
                                                     (word) gbmrgb[i].b *  28) >> 8 );
                        return true;
                case SW4(0,1,0,0):
                        for ( i = 0; i < 0x100; i++ )
                                grey[i] = gbmrgb[i].r;
                        return true;
                case SW4(0,0,1,0):
                        for ( i = 0; i < 0x100; i++ )
                                grey[i] = gbmrgb[i].g;
                        return true;
                case SW4(0,0,0,1):
                        for ( i = 0; i < 0x100; i++ )
                                grey[i] = gbmrgb[i].b;
                        return true;
                }
        return false;
        }
#endif // DEFINED_MAKE_OUTPUT_PALETTE
/*...e*/

static GBMFT iax_gbmft =
        {
        "IAX",
        "IBM Image Access eXecutive",
        "IAX",
        GBM_FT_R8|
        GBM_FT_W8,
        };

#define GBM_ERR_IAX_SIZE        ((GBM_ERR) 1500)

/*...siax_qft:0:*/
GBM_ERR iax_qft(GBMFT *gbmft)
        {
        *gbmft = iax_gbmft;
        return GBM_ERR_OK;
        }
/*...e*/
/*...siax_rhdr:0:*/
GBM_ERR iax_rhdr(char *fn, int fd, GBM *gbm, char *opt)
        {
        long    length;
        int     w, h;
        char    *width;

        fn=fn; fd=fd; /* Suppress 'unref arg' compiler warnings */

        length = lseek(fd, 0L, SEEK_END);
        lseek(fd, 0L, SEEK_SET);

        if ( (width = gbm_find_word_prefix(opt, "width=")) != NULL )
                sscanf(width + 6, "%d", &w);
        else
                w = 512;

        h = (int) (length / w);

        if ( w <= 0 || h <= 0 )
                return GBM_ERR_BAD_SIZE;

        if ( w * h != length )
                return GBM_ERR_IAX_SIZE;

        gbm->w   = w;
        gbm->h   = h;
        gbm->bpp = 8;

        return GBM_ERR_OK;
        }
/*...e*/
/*...siax_rpal:0:*/
GBM_ERR iax_rpal(int fd, GBM *gbm, GBMRGB *gbmrgb)
        {
        int     i;

        fd=fd; gbm=gbm; /* Suppress 'unref arg' compiler warnings */

        for ( i = 0; i < 0x100; i++ )
                gbmrgb[i].r =
                gbmrgb[i].g =
                gbmrgb[i].b = (byte) i;

        return GBM_ERR_OK;
        }
/*...e*/
/*...siax_rdata:0:*/
GBM_ERR iax_rdata(int fd, GBM *gbm, byte *data)
        {
        int     i, stride;
        byte    *p;

        stride = ((gbm->w + 3) & ~3);
        p = data + ((gbm->h - 1) * stride);
        for ( i = gbm->h - 1; i >= 0; i-- )
                {
                read(fd, p, gbm->w);
                p -= stride;
                }
        return GBM_ERR_OK;
        }
/*...e*/
/*...siax_w:0:*/
GBM_ERR iax_w(char *fn, int fd, GBM *gbm, GBMRGB *gbmrgb, byte *data, char *opt)
        {
        int     i, j, stride;
        byte    grey[0x100];
        byte    *p, *linebuf;

        fn=fn; /* Suppress 'unref arg' compiler warning */

        if ( gbm->bpp != 8 )
                return GBM_ERR_NOT_SUPP;

        if ( !make_output_palette(gbmrgb, grey, opt) )
                return GBM_ERR_BAD_OPTION;

        if ( (linebuf = (byte*)malloc(gbm->w)) == NULL )
                return GBM_ERR_MEM;

        stride = ((gbm->w + 3) & ~3);
        p = data + ((gbm->h - 1) * stride);
        for ( i = gbm->h - 1; i >= 0; i-- )
                {
                for ( j = 0; j < gbm->w; j++ )
                        linebuf[j] = grey[p[j]];
                write(fd, linebuf, gbm->w);
                p -= stride;
                }

        free(linebuf);

        return GBM_ERR_OK;
        }
/*...e*/
/*...siax_err:0:*/
unsigned long iax_err(GBM_ERR rc)
        {
        switch ( (int) rc )
                {
                case GBM_ERR_IAX_SIZE:
                        return IC_GBM_IAX_SIZE;
                }
        return 0;
        }
/*...e*/
/*
*****************************************************************************************
*                                                                                       *
* COPYRIGHT:                                                                            *
*   IBM Open Class Library                                                              *
*   (C) Copyright International Business Machines Corporation,  1997                    *
*   Licensed Material - Program-Property of IBM - All Rights Reserved.                  *
*   US Government Users Restricted Rights - Use, duplication, or disclosure             *
*   restricted by GSA ADP Schedule Contract with IBM Corp.                              *
*                                                                                       *
*****************************************************************************************
*/
// Revision: 56 1.4.1.5 source/ographic/igbm.cpp, graphics, ioc.v400, 001006 
/*

IGBMPCX.C  ZSoft PC Paintbrush support

Reads and writes 1,4,8 and 24 bit colour files.

*/

#if 0
#pragma priority( -2147481424 )

/*...sincludes:0:*/
#include <stdio.h>
#include <ctype.h>
#include <stddef.h>
#include <stdlib.h>
#include <string.h>
#include <memory.h>
#include <malloc.h>
#ifdef AIX
#include <unistd.h>
#else
#include <io.h>
#endif
#include <fcntl.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <igbmstnd.hpp>
#include <igbm.hpp>
#include <igbmhelp.hpp>
#include <icconst.h>
#include <ibase.hpp>

// Segment definitions
#ifdef IC_PAGETUNE
  #define _IGBMPCX_CPP_
  #include <ipagetun.h>
#endif
#endif // 0

/*...vgbm\46\h:0:*/
/*...vgbmhelp\46\h:0:*/
/*...e*/

/*...suseful:0:*/
#define low_byte(w)     ((byte)  ((w)&0x00ff)    )
#define high_byte(w)    ((byte) (((w)&0xff00)>>8))
#define make_word(a,b)  (((word)a) + (((word)b) << 8))
/*...e*/

static GBMFT pcx_gbmft =
        {
        "PCX",
        "ZSoft PC Paintbrush Image format",
        "PCX",
        GBM_FT_R1|GBM_FT_R4|GBM_FT_R8|GBM_FT_R24|
        GBM_FT_W1|GBM_FT_W4|GBM_FT_W8|GBM_FT_W24,
        };

#define GBM_ERR_PCX_BAD_VERSION ((GBM_ERR) 700)
#define GBM_ERR_PCX_BAD_ENCMODE ((GBM_ERR) 701)
#define GBM_ERR_PCX_BAD_BITS    ((GBM_ERR) 702)
#define GBM_ERR_PCX_BAD_TRAILER ((GBM_ERR) 703)

typedef struct
        {
        byte version, bpppp, planes;
        int bytes_per_line;
        bool trunc;
        } PCX_PRIV;

/*...spcx_qft:0:*/
GBM_ERR pcx_qft(GBMFT *gbmft)
        {
        *gbmft = pcx_gbmft;
        return GBM_ERR_OK;
        }
/*...e*/
/*...spcx_rhdr:0:*/
GBM_ERR pcx_rhdr(char *fn, int fd, GBM *gbm, char *opt)
        {
        PCX_PRIV *pcx_priv = (PCX_PRIV *) gbm->priv;
        byte    hdr[70];
        word    x1, y1, x2, y2;
        int     w, h, bpp;

        fn=fn; /* Suppress 'unref arg' compiler warning */

        pcx_priv->trunc = ( gbm_find_word(opt, "trunc" ) != NULL );

        lseek(fd, 0L, SEEK_SET);

        read(fd, hdr, 70);
        if ( hdr[0] != 0x0a )
                return GBM_ERR_BAD_MAGIC;
        pcx_priv->version = hdr[1];
        if ( pcx_priv->version == 4 || pcx_priv->version > 5 )
                return GBM_ERR_PCX_BAD_VERSION;
        if ( hdr[2] != 1 )
                return GBM_ERR_PCX_BAD_ENCMODE;

        pcx_priv->bpppp = hdr[3]; pcx_priv->planes = hdr[65];
#define SWITCH2(a,b)    (((a)<<8)|(b))
        switch ( SWITCH2(pcx_priv->bpppp, pcx_priv->planes) )
                {
                case SWITCH2(1,1): bpp =  1; break;
                case SWITCH2(4,1): bpp =  4; break;
                case SWITCH2(8,1): bpp =  8; break;
                case SWITCH2(8,3): bpp = 24; break; /* Extended 24 bit style */
                case SWITCH2(1,4): bpp =  4; break; /* EGA RGBI style */
                default: return GBM_ERR_PCX_BAD_BITS;
                }

        x1 = make_word(hdr[ 4], hdr[ 5]);
        y1 = make_word(hdr[ 6], hdr[ 7]);
        x2 = make_word(hdr[ 8], hdr[ 9]);
        y2 = make_word(hdr[10], hdr[11]);

        w = x2 - x1 + 1;
        h = y2 - y1 + 1;

        if ( w <= 0 || h <= 0 )
                return GBM_ERR_BAD_SIZE;

        pcx_priv->bytes_per_line = make_word(hdr[66], hdr[67]);

        gbm->w   = w;
        gbm->h   = h;
        gbm->bpp = bpp;

        return GBM_ERR_OK;
        }
/*...e*/
/*...spcx_rpal:0:*/
GBM_ERR pcx_rpal(int fd, GBM *gbm, GBMRGB *gbmrgb)
        {
        switch ( gbm->bpp )
                {
/*...s1 \45\ fixed b\47\w palette:16:*/
case 1:
        gbmrgb[0].r = gbmrgb[0].g = gbmrgb[0].b = 0x00;
        gbmrgb[1].r = gbmrgb[1].g = gbmrgb[1].b = 0xff;
        break;
/*...e*/
/*...s4 \45\ read palette if 1 plane\44\ fix one if 4 plane RGBI:16:*/
case 4:
        /* Use inline palette */
        {
        byte    b[16*3];
        int     i;

        lseek(fd, 16L, SEEK_SET);
        read(fd, b, 16 * 3);
        for ( i = 0; i < 16; i++ )
                {
                gbmrgb[i].r = b[i * 3 + 0];
                gbmrgb[i].g = b[i * 3 + 1];
                gbmrgb[i].b = b[i * 3 + 2];
                }
        }
        break;
/*...e*/
/*...s8 \45\ read palette from end of file:16:*/
case 8:
        {
        byte    trailer_id;
        byte    b[0x100*3];
        int     i;

        lseek(fd, -0x301L, SEEK_END);
        read(fd, &trailer_id, 1);
        if ( trailer_id != 0x0c )
                return GBM_ERR_PCX_BAD_TRAILER;

        read(fd, b, 0x100 * 3);
        for ( i = 0; i < 0x100; i++ )
                {
                gbmrgb[i].r = b[i * 3 + 0];
                gbmrgb[i].g = b[i * 3 + 1];
                gbmrgb[i].b = b[i * 3 + 2];
                }
        }
        break;
/*...e*/
                }
        return GBM_ERR_OK;
        }
/*...e*/
/*...spcx_rdata:0:*/
/*...sread_pcx_line:0:*/
static void read_pcx_line(
        AHEAD *ahead, byte *line, int bytes_per_line,
        byte *runleft, byte *runval
        )
        {
        /* Handle left overs from previous line */

        while ( *runleft > 0 && bytes_per_line > 0 )
                {
                *line++ = *runval;
                (*runleft)--;
                bytes_per_line--;
                }

        /* Normal code */

        while ( bytes_per_line )
                {
                byte b1 = (byte) gbm_read_ahead(ahead);

                if ( (b1 & 0xc0) == 0xc0 )
                        {
                        byte b2 = (byte) gbm_read_ahead(ahead);

                        b1 &= 0x3f;
                        if ( b1 > bytes_per_line )
                                {
                                (*runleft) = (byte) (b1 - bytes_per_line);
                                (*runval) = b2;
                                b1 = bytes_per_line;
                                }
                        memset(line, b2, b1);
                        line += b1;
                        bytes_per_line -= b1;
                        }
                else
                        {
                        *line++ = b1;
                        bytes_per_line--;
                        }
                }
        }
/*...e*/
/*...sspread:0:*/
static void spread(byte b, byte bit_to_set, byte *dest)
        {
        if ( b & 0x80 ) dest[0] |= (bit_to_set & 0xf0);
        if ( b & 0x40 ) dest[0] |= (bit_to_set & 0x0f);
        if ( b & 0x20 ) dest[1] |= (bit_to_set & 0xf0);
        if ( b & 0x10 ) dest[1] |= (bit_to_set & 0x0f);
        if ( b & 0x08 ) dest[2] |= (bit_to_set & 0xf0);
        if ( b & 0x04 ) dest[2] |= (bit_to_set & 0x0f);
        if ( b & 0x02 ) dest[3] |= (bit_to_set & 0xf0);
        if ( b & 0x01 ) dest[3] |= (bit_to_set & 0x0f);
        }
/*...e*/

GBM_ERR pcx_rdata(int fd, GBM *gbm, byte *data)
        {
        PCX_PRIV *pcx_priv = (PCX_PRIV *) gbm->priv;
        bool trunc = pcx_priv->trunc;
        int bytes_per_line = pcx_priv->bytes_per_line;
        int stride, y;
        byte *line;
        AHEAD *ahead;
        byte runleft = 0, runval;

        if ( (ahead = gbm_create_ahead(fd)) == NULL )
                return GBM_ERR_MEM;

        lseek(fd, 128L, SEEK_SET);

        if ( (line = (byte*)malloc(bytes_per_line)) == NULL )
                {
                gbm_destroy_ahead(ahead);
                return GBM_ERR_MEM;
                }

        switch ( gbm->bpp )
                {
/*...s1:16:*/
case 1:
        stride = ((gbm->w + 31) / 32) * 4;
        for ( y = gbm->h - 1; y >= 0; y-- )
                {
                read_pcx_line(ahead, data + y * stride, bytes_per_line, &runleft, &runval);
                if ( trunc )
                        runleft = 0;
                }
        break;
/*...e*/
/*...s4:16:*/
case 4:
        stride = ((gbm->w * 4 + 31) / 32) * 4;
        if ( pcx_priv->planes == 1 )
                for ( y = gbm->h - 1; y >= 0; y-- )
                        {
                        read_pcx_line(ahead, data + y * stride, bytes_per_line, &runleft, &runval);
                        if ( trunc )
                                runleft = 0;
                        }
        else
                {
                int     p, x;
                int     bytes = (gbm->w / 8);
                int     bits  = (gbm->w & 7);

                memset(data, 0, gbm->h * stride);
                for ( y = gbm->h - 1; y >= 0; y-- )
                        for ( p = 0x11; p <= 0x88 ; p <<= 1 )
                                {
                                byte    *dest = data + y * stride;

                                read_pcx_line(ahead, line, bytes_per_line, &runleft, &runval);
                                if ( trunc )
                                        runleft = 0;
                                for ( x = 0; x < bytes; x++, dest += 4 )
                                        spread(line[x], p, dest);
                                if ( bits )
                                        spread((byte) (line[x] & (0xff00 >> bits)), p, dest);
                                }
                }
        break;
/*...e*/
/*...s8:16:*/
case 8:
        stride = ((gbm->w + 3) & ~3);
        for ( y = gbm->h - 1; y >= 0; y-- )
                {
                read_pcx_line(ahead, data + y * stride, bytes_per_line, &runleft, &runval);
                if ( trunc )
                        runleft = 0;
                }
        break;
/*...e*/
/*...s24:16:*/
case 24:
        {
        int     p, x;

        stride = ((gbm->w * 3 + 3) & ~3);
        for ( y = gbm->h - 1; y >= 0; y-- )
                for ( p = 2; p >= 0; p-- )
                        {
                        read_pcx_line(ahead, line, bytes_per_line, &runleft, &runval);
                        if ( trunc )
                                runleft = 0;
                        for ( x = 0; x < gbm->w; x++ )
                                data[y * stride + p + x * 3] = line[x];
                        }
        }
        break;
/*...e*/
                }

        free(line);

        gbm_destroy_ahead(ahead);

        return GBM_ERR_OK;
        }
/*...e*/
/*...spcx_w:0:*/
/*...spcx_rle:0:*/
static byte pcx_run(byte *src, int n_src)
        {
        byte cnt = 1;
        byte b = *src++;

        --n_src;
        while ( cnt < 0x3f && n_src > 0 && *src == b )
                { cnt++; n_src--; src++; }

        return cnt;
        }

static void pcx_rle(byte *src, int n_src, byte *dst, int *n_dst)
        {
        *n_dst = 0;
        while ( n_src )
                {
                byte    len;

                if ( (len = pcx_run(src, n_src)) > 1 || (*src & 0xc0) == 0xc0 )
                        {
                        *dst++ = (byte) (0xc0 | len);
                        *dst++ = *src;
                        (*n_dst) += 2;
                        }
                else
                        {
                        *dst++ = *src;
                        (*n_dst)++;
                        }
                src += len;
                n_src -= len;
                }
        }
/*...e*/

GBM_ERR pcx_w(char *fn, int fd, GBM *gbm, GBMRGB *gbmrgb, byte *data, char *opt)
        {
        int i, y, stride = ((gbm->bpp * gbm->w + 31) / 32) * 4;
        byte *line;
        byte hdr[128];
        int bytes_per_line, cnt;

        fn=fn; opt=opt; /* Suppress 'unref arg' compiler warning */

        memset(hdr, 0, 128);
        hdr[ 0] = 0x0a;                 /* Magic # */
        hdr[ 1] = 5;                            /* Version 5 */
        hdr[ 2] = 1;                            /* RLE compression */
        hdr[ 3] = (byte) ( ( gbm->bpp == 24 ) ? 8 : gbm->bpp );
                                                /* Bits per plane */
        hdr[ 4] = low_byte(0);
        hdr[ 5] = high_byte(0);         /* Top left x */
        hdr[ 6] = low_byte(0);
        hdr[ 7] = high_byte(0);         /* Top left y */
        hdr[ 8] = low_byte(gbm->w - 1);
        hdr[ 9] = high_byte(gbm->w - 1);        /* Bottom right x */
        hdr[10] = low_byte(gbm->h - 1);
        hdr[11] = high_byte(gbm->h - 1);        /* Bottom right y */
        hdr[12] = low_byte(0);
        hdr[13] = high_byte(0);         /* Horizontal resolution ??? */
        hdr[14] = low_byte(0);
        hdr[15] = high_byte(0);         /* Vertical resolution ??? */

        if ( gbm->bpp == 4 )
                for ( i = 0; i < 16; i++ )
                        {
                        hdr[16 + i * 3    ] = gbmrgb[i].r;
                        hdr[16 + i * 3 + 1] = gbmrgb[i].g;
                        hdr[16 + i * 3 + 2] = gbmrgb[i].b;
                        }

        hdr[65] = (byte) ( ( gbm->bpp == 24 ) ? 3 : 1 );
                                                /* Planes */
        bytes_per_line = (gbm->w * hdr[3] + 7) / 8;
        if ( bytes_per_line & 1 )
                bytes_per_line++;
        hdr[66] = low_byte(bytes_per_line);
        hdr[67] = high_byte(bytes_per_line);
        hdr[68] = 1;                            /* Colour or b/w */

        write(fd, hdr, 128);

        if ( (line = (byte*)malloc(bytes_per_line * 2)) == NULL )  // mjs
                return GBM_ERR_MEM;

        switch ( gbm->bpp )
                {
/*...s1\44\4\44\8:16:*/
case 1:
case 4:
case 8:
        for ( y = gbm->h - 1; y >= 0; y-- )
                {
                pcx_rle(data + y * stride, bytes_per_line, line, &cnt);
                if ( write(fd, line, cnt) != cnt )
                        {
                        free(line);
                        return GBM_ERR_WRITE;
                        }
                }
        break;
/*...e*/
/*...s24:16:*/
case 24:
        {
        byte    *line2;
        int     p, x;

        if ( (line2 = (byte*)malloc(bytes_per_line)) == NULL )  // mjs
                {
                free(line);
                return GBM_ERR_MEM;
                }

        for ( y = gbm->h - 1; y >= 0; y-- )
                for ( p = 2; p >= 0; p-- )
                        {
                        byte    *src = data + y * stride;

                        for ( x = 0; x < gbm->w; x++ )
                                line2[x] = src[x * 3 + p];

                        pcx_rle(line2, bytes_per_line, line, &cnt);
                        if ( write(fd, line, cnt) != cnt )
                                {
                                free(line2);
                                free(line);
                                return GBM_ERR_WRITE;
                                }
                        }
        free(line2);
        }
        break;
/*...e*/
                }

        free(line);

        if ( gbm->bpp == 8 )
                {
                byte    pal[1 + 0x100 * 3];

                pal[0] = 0x0c;
                for ( i = 0; i < 0x100; i++ )
                        {
                        pal[i * 3 + 1] = gbmrgb[i].r;
                        pal[i * 3 + 2] = gbmrgb[i].g;
                        pal[i * 3 + 3] = gbmrgb[i].b;
                        }
                write(fd, pal, 1 + 0x100 * 3);
                }

        return GBM_ERR_OK;
        }
/*...e*/
/*...spcx_err:0:*/
unsigned long pcx_err(GBM_ERR rc)
        {
        switch ( (int) rc )
                {
                case GBM_ERR_PCX_BAD_VERSION:
                        return IC_GBM_PCX_BAD_VERSION;
                case GBM_ERR_PCX_BAD_ENCMODE:
                        return IC_GBM_PCX_BAD_ENCMODE;
                case GBM_ERR_PCX_BAD_BITS:
                        return IC_GBM_PCX_BAD_BITS;
                case GBM_ERR_PCX_BAD_TRAILER:
                        return IC_GBM_PCX_BAD_TRAILER;
                }
        return 0;
        }
/*...e*/
/* NOSHIP */
/*
*****************************************************************************************
*                                                                                       *
* COPYRIGHT:                                                                            *
*   IBM Open Class Library                                                              *
*   (C) Copyright International Business Machines Corporation,  1997                    *
*   Licensed Material - Program-Property of IBM - All Rights Reserved.                  *
*   US Government Users Restricted Rights - Use, duplication, or disclosure             *
*   restricted by GSA ADP Schedule Contract with IBM Corp.                              *
*                                                                                       *
*****************************************************************************************
*/
// Revision: 56 1.4.1.5 source/ographic/igbm.cpp, graphics, ioc.v400, 001006 
#ifndef _IGBTIFH_
#define _IGBTIFH_
/*******************************************************************************
* FILE NAME: igbtifh.h                                                         *
*                                                                              *
* DESCRIPTION:                                                                 *
*   Declaration of the class(es):                                              *
*     IGBMTIFH.H  Interface to TIFF file handling stuff                        *
*                                                                              *
*     Added #defines for many more tags.                                       *
*     Added #defines for most of the new TIFF 6.0 tags.                        *
*     Added #defines for the new tag field types.                              *
*     Reading numeric tags will now accept signed field types too.             *
*                                                                              *
*******************************************************************************/

#define TE_OK           0
#define TE_MEM          1
#define TE_VERSION      2
#define TE_N_TAGS       3
#define TE_TAG_TYPE     4
#define TE_N_IFD        5

/*
Image tags used in TIFF files. The types given with each one is what they
usually are. A program should not assume that this is always the case.
The most sensible way of handling things that could be short or long is to
use the numeric_tag() predicate and the value_of_tag() functions.
*/

/*...stags:0:*/
#define T_NEWSUBFILETYPE        254     /* data is long */
#define T_SUBFILETYPE           255     /* data is short */
#define T_IMAGEWIDTH            256     /* data is a short */
#define T_IMAGELENGTH           257     /* data is a short */
#define T_BITSPERSAMPLE         258     /* data is a short */
#define T_COMPRESSION           259     /* data is a short */
#define T_PHOTOMETRIC           262     /* data is short */
#define T_THRESHOLDING          263     /* data is short */
#define T_CELLWIDTH             264
#define T_CELLLENGTH            265
#define T_FILLORDER             266     /* data is short */
#define T_DOCNAME               269     /* data is ASCII */
#define T_DESCRIPTION           270     /* data is ASCII */
#define T_MAKE                  271     /* data is ASCII */
#define T_MODEL                 272     /* data is ASCII */
#define T_STRIPOFFSETS          273     /* data is short or long */
#define T_ORIENTATION           274     /* data is short */
#define T_SAMPLESPERPIXEL       277     /* data is short */
#define T_ROWSPERSTRIP          278     /* data is short or long */
#define T_STRIPBYTECOUNTS       279     /* data is short */
#define T_MINSAMPLEVALUE        280     /* data is short or long */
#define T_MAXSAMPLEVALUE        281     /* data is short or long */
#define T_XRESOLUTION           282     /* data is rational */
#define T_YRESOLUTION           283     /* data is rational */
#define T_PLANARCONFIG          284     /* data is short */
#define T_PAGENAME              285     /* data is ASCII */
#define T_XPOSITION             286
#define T_YPOSITION             287
#define T_FREEOFFSETS           288
#define T_FREEBYTECOUNTS        289
#define T_GRAYRESPONSEUNIT      290     /* data is a short */
#define T_GRAYRESPONSECURVE     291     /* data is a set of shorts */
#define T_GROUP3OPTIONS         292     /* data is a long */
#define T_GROUP4OPTIONS         293     /* data is a long */
#define T_RESOLUTIONUNIT        296     /* data is short */
#define T_PAGENUMBER            297     /* data is 2 shorts */
#define T_COLORRESPONSECURVES   301     /* data is 3 sets of shorts */
#define T_SOFTWARE              305     /* data is ASCII */
#define T_DATETIME              306
#define T_ARTIST                315     /* data is ASCII */
#define T_HOSTCOMPUTER          316     /* data is ASCII */
#define T_PREDICTOR             317     /* data is a short */
#define T_WHITEPOINT            318
#define T_PRIMARYCHROMA         319     /* data us 6 rationals */
#define T_COLORMAP              320     /* data is 3 sets of shorts */
#define T_HALFTONEHINTS         321     /* data is 2 shorts */
#define T_TILEWIDTH             322     /* data is 1 short */
#define T_TILELENGTH            323     /* data is 1 short */
#define T_TILEOFFSETS           324     /* data is # tiles long */
#define T_TILEBYTECOUNTS        325     /* data is # tiles long */
#define T_INKSET                332     /* data is 1 short */
#define T_INKNAMES              333     /* data is ASCII */
#define T_NUMBEROFINKS          334     /* data is 1 short */
#define T_DOTRANGE              336     /* data is 2 or 2 * samples per pixel bytes or shorts */
#define T_TARGETPRINTER         337     /* data is ASCII */
#define T_EXTRASAMPLES          338     /* data is 1 short */
#define T_SAMPLEFORMAT          339     /* data is samples per pixel shorts */
#define T_SMINSAMPLEVALUE       340     /* data is samples per pixel ? */
#define T_SMAXSAMPLEVALUE       341     /* data is samples per pixel ? */
#define T_TRANSFERRANGE         342     /* data is 6 shorts */
#define T_JPEGPROC              512     /* data is 1 short */
#define T_JPEGINTERCHANGEFMT    513     /* data is 1 long */
#define T_JPEGINTERCHANGEFMTLEN 514     /* data is 1 long */
#define T_JPEGRESTARTINTERVAL   515     /* data is 1 short */
#define T_JPEGLOSSLESSPRED      517     /* data is samples per pixel shorts */
#define T_JPEGPOINTTRANSFORMS   518     /* data is samples per pixel shorts */
#define T_JPEGOTABLES           519     /* data is samples per pixel longs */
#define T_JPEGDCTABLES          520     /* data is samples per pixel longs */
#define T_JPEGACTABLES          521     /* data is samples per pixel longs */
#define T_COEFFICIENTS          529     /* data is 3 rationals */
#define T_SUBSAMPLING           530     /* data is 2 shorts */
#define T_REFERENCEBLACKWHITE   532     /* data is 6 rationals */
/*...e*/

typedef struct { long numerator, denominator; } rational;

#define D_BYTE          1               /* data is unsigned 8 bit */
#define D_ASCII         2               /* data is ASCIIZ string */
#define D_SHORT         3               /* data is unsigned 16 bit */
#define D_LONG          4               /* data is unsigned 32 bit */
#define D_RATIONAL      5               /* data is 2 LONGs */
#define D_SBYTE         6               /* data is signed 8 bit */
#define D_UNDEFINED     7               /* data 8 bit anything */
#define D_SSHORT        8               /* data is signed 16 bit */
#define D_SLONG         9               /* data is signed 32 bit */
#define D_SRATIONAL     10              /* data is 2 SLONGs */
#define D_FLOAT         11              /* data is 4-byte IEEE format */
#define D_DOUBLE        12              /* data is 8-byte IEEE format */

typedef struct
        {
        short   type;
        short   data_type;
        long    length;
        void    *value;
        } TAG;

#define MAX_TAGS        200

typedef struct
        {
        short   n_tags;
        TAG     tags [MAX_TAGS];
        } IFD;

typedef struct
        {
        short   byte_order;
        short   version_no;
        IFD     *ifd;
        } IFH;

#ifndef _GBMTIFH_

/*
Proposed method for loading a TIFF file :-
        1) Open file.
        2) Use read_ifh_and_ifd() to get header.
           If an error occurs returned error code not TE_OK.
        3) Use locate_tag() and value_of_tag() etc. to test presence and
           validity of tags.
        4) In particular use value_of_tag_n() to get at T_STRIPOFFSETS,
           to extract the offsets into the file where the raw data is.
        5) Read the raw data.
        6) Close the file.
        7) Free the IFH structure using free_ifh().
*/

extern int read_ifh_and_ifd(int fd, int n_ifds_to_skip, IFH **ifh_return);
extern bool numeric_tag(TAG *tag);
extern long value_of_tag(TAG *tag);
extern long value_of_tag_n(TAG *tag, int n);
extern TAG *locate_tag(IFD *ifd, short type);
extern void free_ifh(IFH *ifh);

/*
Proposed method for saving a TIFF file :-
        1) Open file
           If fails use tiff_errno.
        2) Use make_ifh() to create an empty IFH (and its IFD).
           If fails then out of memory.
        3) Setup all the tags - those that you don't know set to 0.
           If fails then out of memory.
        4) Use write_ifh_and_ifd() to write the IFH.
           If fails look at tiff_errno.
        5) Write all the raw data to the file, using ftell() to
           keep a record of where strips start and how long they are.
        6) In particular update tags T_STRIPOFFSETS and T_STRIPBYTECOUNTS.
        7) Use write_ifd() to rewrite the IFD.
        8) Close the file.
        9) Use free_ifh() to deallocate the IFH.

It is important to realise that a second write of the IFD is necessary since
the StripOffsets and StripByteCounts tags cannot be known until the compressed
data has actually been written. Although the TIFF spec allows us to write the
compressed data BEFORE we write the IFD, I find that some programs (notably
the IBM utility IDUCNVT.EXE) insist that the IFD is before the data).
*/

extern IFH *make_ifh(void);
extern bool add_byte_tag(IFD *ifd, short type, byte *value, int n);
extern bool add_ascii_tag(IFD *ifd, short type, char *value);
extern bool add_short_tag(IFD *ifd, short type, short *value, int n);
extern bool add_long_tag(IFD *ifd, short type, long *value, int n);
extern bool add_rational_tag(IFD *ifd, short type, rational *value, int n);
extern bool write_ifh_and_ifd(IFH *ifh, int fd);
extern void update_byte_tag(IFD *ifd, short type, byte *value);
extern void update_ascii_tag(IFD *ifd, short type, char *value);
extern void update_short_tag(IFD *ifd, short type, short *value);
extern void update_long_tag(IFD *ifd, short type, long *value);
extern void update_rational_tag(IFD *ifd, short type, rational *value);
extern bool update_ifd(IFD *ifd, int fd);

#endif

#endif
/*
*****************************************************************************************
*                                                                                       *
* COPYRIGHT:                                                                            *
*   IBM Open Class Library                                                              *
*   (C) Copyright International Business Machines Corporation,  1997                    *
*   Licensed Material - Program-Property of IBM - All Rights Reserved.                  *
*   US Government Users Restricted Rights - Use, duplication, or disclosure             *
*   restricted by GSA ADP Schedule Contract with IBM Corp.                              *
*                                                                                       *
*****************************************************************************************
*/
// Revision: 56 1.4.1.5 source/ographic/igbm.cpp, graphics, ioc.v400, 001006 

/*

IGBMTIFH.C  Routines to handle TIFF file headers

*/

#if 0
/*...sincludes:0:*/
#include <stdio.h>
#include <stdlib.h>
#include <stddef.h>
#include <malloc.h>
#include <memory.h>
#include <string.h>
#ifdef AIX
#include <unistd.h>
#else
#include <io.h>
#endif
#include <fcntl.h>
#include "igbmstnd.hpp"
#define _GBMTIFH_
#include "igbmtifh.hpp"
#include <ibase.hpp>

// Segment definitions
#ifdef IC_PAGETUNE
  #define _IGBMTIFH_CPP_
  #include <ipagetun.h>
#endif
#endif // 0

/*...vgbmtifh\46\h:0:*/
/*...e*/

/*...susefull:0:*/
#define ifd_malloc()    ((IFD *) malloc(sizeof(IFD)))
#define ifd_free(ifd)   free((char *) ifd)

#define ifh_malloc()    ((IFH *) malloc(sizeof(IFH)))
#define ifh_free(ifh)   free((char *) ifh)

static int sizeof_data_type(short data_type)
        {
        switch ( data_type )
                {
                case D_BYTE:
                case D_SBYTE:
                case D_ASCII:
                case D_UNDEFINED:
                        return 1;
                case D_SHORT:
                case D_SSHORT:
                        return sizeof(short);
                case D_LONG:
                case D_SLONG:
                        return sizeof(long);
                case D_RATIONAL:
                case D_SRATIONAL:
                        return sizeof(rational);
                case D_FLOAT:
                        return 4;
                case D_DOUBLE:
                        return 8;
                }
        return 1;
        }

static void tag_free(TAG *tag)
        {
        free(tag->value);
        }

/*
This finds the slot for the new tag. It returns NULL if the limit of
MAX_TAGS tags is curruntly defined.
*/

static TAG *get_tag_slot(short type, IFD *ifd)
        {
        int     i;

        if ( ifd->n_tags == MAX_TAGS )
                return NULL;

        for ( i = ifd->n_tags;
              i > 0 && ifd->tags[i - 1].type >= type;
              i-- )
                memcpy(ifd->tags + i,
                       ifd->tags + i - 1,
                       sizeof(TAG));

        ifd->n_tags++;

        /* now i == slot, with greater than elements moved up */

        return &(ifd->tags[i]);
        }
/*...e*/

/*...sread_ifh_and_ifd:0:*/
/*...sread_long:0:*/
#define make_long(b1,b2,b3,b4) ( ((long)(b1)<<24) | ((long)(b2)<<16) | ((long)(b3)<<8) | (long)(b4) )

static long read_long(int fd, bool motorola)
        {
        byte b[4];

        read(fd, b, 4);
        return  ( motorola ) ?
                make_long(b[0], b[1], b[2], b[3]) :
                make_long(b[3], b[2], b[1], b[0]) ;
        }
/*...e*/
/*...sread_short:0:*/
#define make_short(b1,b2) ( ((short)(b1)<<8) | (short)(b2) )

static short read_short(int fd, bool motorola)
        {
        byte b[2];

        read(fd, b, 2);
        return ( motorola ) ?
                make_short(b[0], b[1]) :
                make_short(b[1], b[0]) ;
        }
/*...e*/
/*...sread_rational:0:*/
static void read_rational(int fd, bool motorola, rational *r)
        {
        r->numerator   = read_long(fd, motorola);
        r->denominator = read_long(fd, motorola);
        }
/*...e*/
/*...sread_tag:0:*/
static int read_tag(int fd, bool motorola, TAG *tag)
        {
        int     i, s, n;
        long    len;
        long    seek_to, old_pos;

        tag->type      = read_short(fd, motorola);
        tag->data_type = read_short(fd, motorola);
        tag->length    = read_long(fd, motorola);

        if ( tag->type & 0x8000 )
                /* proprietry tag */
                {
                lseek(fd, 4L, SEEK_CUR);        /* skip data */
                return TE_OK;                   /* assumed ok */
                }

        n   = (int) tag->length;

/*...sbugfix for UBU\39\s writing of ColorMap tag:8:*/
/* UBU writes out a length feild of 256 when it should write 768 */

if ( tag->type == T_COLORMAP && (n / 3) * 3 != n )
        n *= 3;
/*...e*/

        s   = sizeof_data_type(tag->data_type);
        len = s * n;

        if ( len > 4 )
                /* will have to seek for data */
                {
                seek_to = read_long(fd, motorola);
                old_pos = lseek(fd, 0L, SEEK_CUR);
                lseek(fd, seek_to, SEEK_SET);
                }

        if ( (tag->value = malloc((int) len)) == NULL )
                return TE_MEM;

        switch ( tag->data_type )
                {
                case D_BYTE:
                case D_SBYTE:
                        read(fd, tag->value, n);
                        break;
                case D_ASCII:
                        read(fd, tag->value, n);
                        break;
                case D_SHORT:
                case D_SSHORT:
                        {
                        short   *short_ptr = (short *) tag->value;

                        for ( i = 0; i < n; i++ )
                                *short_ptr++ = read_short(fd, motorola);
                        }
                        break;
                case D_LONG:
                case D_SLONG:
                        {
                        long    *long_ptr = (long *) tag->value;

                        for ( i = 0; i < n; i++ )
                                *long_ptr++ = read_long(fd, motorola);
                        }
                        break;
                case D_RATIONAL:
                case D_SRATIONAL:
                        {
                        rational *rational_ptr = (rational *) tag->value;

                        for ( i = 0; i < n; i++ )
                                read_rational(fd, motorola, rational_ptr++);
                        }
                        break;
                case D_FLOAT:
                        /* Skip 4 byte IEEE floating point */
                        lseek(fd, 4 * len, SEEK_CUR);
                        break;
                case D_DOUBLE:
                        /* Skip 8 byte IEEE double precision floating point */
                        lseek(fd, 8 * len, SEEK_CUR);
                        break;
                default:
                        read(fd, tag->value, (int) len);
                        break;
                }

        if ( len > 4 )
                lseek(fd, old_pos, SEEK_SET);
        else if ( len < 4 )
                lseek(fd, 4L - len, SEEK_CUR);  /* advance past gap */

        return TE_OK;
        }
/*...e*/
/*...sread_ifd:0:*/
/*
For the time being we will assume there is only one IFD in
a given TIFF file. When this code was written, the author
knew of no software packages that support multiple IFDs.
*/

/*...sclean_up_ifd:0:*/
static void clean_up_ifd(IFD *ifd, int n)
        {
        int     i;
        TAG     *tag;

        for ( i = 0; i < n; i++ )
                {
                tag = &(ifd->tags[i]);
                if ( !(tag->type & 0x8000) )    /* its not read in */
                        tag_free(tag);
                }
        ifd_free(ifd);
        }
/*...e*/

static int read_ifd(int fd, bool motorola, IFD **ifd_return)
        {
        IFD     *ifd;
        int     i, ecode;

        if ( (ifd = ifd_malloc()) == NULL )
                return TE_MEM;

        /* ensure we can handle all the tags */

        if ( (ifd->n_tags = read_short(fd, motorola)) > MAX_TAGS )
                {
                ifd_free(ifd); return TE_N_TAGS;
                }

        /* get the tags */

        for ( i = 0; i < ifd->n_tags; i++ )
                if ( (ecode = read_tag(fd, motorola, &(ifd->tags[i]))) != TE_OK )
                        {
                        clean_up_ifd(ifd, i);
                        return ecode;
                        }

        *ifd_return = ifd;

        return TE_OK;
        }
/*...e*/
/*...sskip_ifd:0:*/
/* Returns TRUE if there is another IFD afterwards */

static bool skip_ifd(int fd, bool motorola)
        {
        short n_tags = read_short(fd, motorola);
        long offset_ifd;
        lseek(fd, 12L * n_tags, SEEK_CUR);
        offset_ifd = read_long(fd, motorola);
        if ( offset_ifd == 0L )
                return FALSE;
        lseek(fd, offset_ifd, SEEK_SET);
        return TRUE;
        }
/*...e*/

int read_ifh_and_ifd(int fd, int n_ifds_to_skip, IFH **ifh_return)
        {
        IFH     *ifh;
        long    offset_ifd;
        bool motorola;
        int     ecode;

        if ( (ifh = ifh_malloc()) == NULL )
                return TE_MEM;

        read(fd, (char *) &(ifh->byte_order), sizeof(short));
        motorola = ( ifh->byte_order == ('M' << 8) + 'M' );

        /* Apparently, the following number has great univeral significance! */
        /* See the TIFF 5.0 spec. for details! */

        if ( (ifh->version_no = read_short(fd, motorola)) != 42 )
                {
                ifh_free(ifh); return TE_VERSION;
                }

        offset_ifd = read_long(fd, motorola);
        lseek(fd, offset_ifd, SEEK_SET);
        while ( n_ifds_to_skip-- > 0 )
                if ( !skip_ifd(fd, motorola) )
                        return TE_N_IFD;

        if ( (ecode = read_ifd(fd, motorola, &(ifh->ifd))) != TE_OK )
                {
                ifh_free(ifh); return ecode;
                }

        *ifh_return = ifh;

        return TE_OK;
        }
/*...e*/
/*...slocate_tag:0:*/
TAG *locate_tag(IFD *ifd, short type)
        {
        int i;

        for ( i = 0; i < ifd->n_tags; i++ )
                if ( ifd->tags[i].type == type )
                        return &(ifd->tags[i]);
        return NULL;
        }
/*...e*/
/*...snumeric_tag:0:*/
bool numeric_tag(TAG *tag)
        {
        short t = tag->data_type;
        return t == D_BYTE  ||
               t == D_SHORT || t == D_SSHORT ||
               t == D_LONG  || t == D_SLONG  ;
        }
/*...e*/
/*...svalue_of_tag_n:0:*/
/*
For a numeric tag, return the value of the nth item in it.
Upto the caller to know that tag is signed or unsigned.
*/

long value_of_tag_n(TAG *tag, int n)
        {
        switch ( tag->data_type )
                {
                case D_BYTE:
                        {
                        unsigned char *p = (unsigned char *) tag->value;
                        return (long) (unsigned long) p[n];
                        }
                case D_SBYTE:
                        {
                        signed char *p = (signed char *) tag->value;
                        return (long) p[n];
                        }
                case D_SHORT:
                        {
                        unsigned short *p = (unsigned short *) tag->value;
                        return (long) (unsigned long) p[n];
                        }
                case D_SSHORT:
                        {
                        signed short *p = (signed short *) tag->value;
                        return (long) p[n];
                        }
                case D_LONG:
                        {
                        unsigned long *p = (unsigned long *) tag->value;
                        return (long) p[n];
                        }
                case D_SLONG:
                        {
                        signed long *p = (signed long *) tag->value;
                        return (long) p[n];
                        }
                }
        return 0L;
        }
/*...e*/
/*...svalue_of_tag:0:*/
/*
For a numeric tag, return the value of the 1st value in it.
This is usefull for tags that typically only have 1 value anyway.
*/

long value_of_tag(TAG *tag)
        {
        return value_of_tag_n(tag, 0);
        }
/*...e*/
/*...sfree_ifh:0:*/
void    free_ifh(IFH *ifh)
        {
        IFD     *ifd;

        ifd = ifh->ifd;
        clean_up_ifd(ifd, ifd->n_tags);
        ifh_free(ifh);
        }
/*...e*/
/*...smake_ifh:0:*/
/*
Creates an empty IFH set up for the image.
Also creates an IFD as part of the IFH.
Use add_?_tag() routines to add tags to IFH's IFD.
*/

IFH     *make_ifh(void)
        {
        IFH     *ifh;
        IFD     *ifd;

        if ( (ifh = ifh_malloc()) == NULL )
                return NULL;

        if ( (ifh->ifd = ifd = ifd_malloc()) == NULL )
                {
                ifh_free(ifh);
                return NULL;
                }

        ifh->byte_order = ('I' << 8) + 'I';
        ifh->version_no = 42;

        ifd->n_tags = 0;

        return ifh;
        }
/*...e*/
/*...sadd_byte_tag:0:*/
bool add_byte_tag(IFD *ifd, short type, byte *value, int n)
        {
        byte    *byte_ptr;
        TAG     *tag;

        if ( (byte_ptr = (byte *) malloc(n * sizeof(byte))) == NULL )
                return FALSE;
        if ( (tag = get_tag_slot(type, ifd)) == NULL )
                return FALSE;
        tag->type      = type;
        tag->data_type = D_BYTE;
        tag->length    = (long) n;
        if ( value != NULL )
                memcpy(tag->value = (char *) byte_ptr,
                       value,
                       n * sizeof(byte));
        return TRUE;
        }
/*...e*/
/*...sadd_ascii_tag:0:*/
bool add_ascii_tag(IFD *ifd, short type, char *value)
        {
        char    *ascii_ptr;
        TAG     *tag;
        int     n;

        n = strlen(value) + 1;
        if ( (ascii_ptr = (char *) malloc(n)) == NULL )
                return FALSE;
        if ( (tag = get_tag_slot(type, ifd)) == NULL )
                return FALSE;
        tag->type      = type;
        tag->data_type = D_ASCII;
        tag->length    = (long) n;
        strcpy((char*)(tag->value = ascii_ptr), value);   // mjs
        return TRUE;
        }
/*...e*/
/*...sadd_short_tag:0:*/
bool add_short_tag(IFD *ifd, short type, short *value, int n)
        {
        short   *short_ptr;
        TAG     *tag;

        if ( (short_ptr = (short *) malloc(n * sizeof(short))) == NULL )
                return FALSE;
        if ( (tag = get_tag_slot(type, ifd)) == NULL )
                return FALSE;
        tag->type      = type;
        tag->data_type = D_SHORT;
        tag->length    = (long) n;
        if ( value != NULL )
                memcpy(tag->value = (char *) short_ptr,
                       value,
                       n * sizeof(short));
        return TRUE;
        }
/*...e*/
/*...sadd_long_tag:0:*/
bool add_long_tag(IFD *ifd, short type, long *value, int n)
        {
        long    *long_ptr;
        TAG     *tag;

        if ( (long_ptr = (long *) malloc(n * sizeof(long))) == NULL )
                return FALSE;
        if ( (tag = get_tag_slot(type, ifd)) == NULL )
                return FALSE;
        tag->type      = type;
        tag->data_type = D_LONG;
        tag->length    = (long) n;
        if ( value != NULL )
                memcpy(tag->value = (char *) long_ptr,
                       value,
                       n * sizeof(long));
        return TRUE;
        }
/*...e*/
/*...sadd_rational_tag:0:*/
bool add_rational_tag(IFD *ifd, short type, rational *value, int n)
        {
        rational *rational_ptr;
        TAG     *tag;

        if ( (rational_ptr = (rational *) malloc(n * sizeof(rational))) == NULL )
                return FALSE;
        if ( (tag = get_tag_slot(type, ifd)) == NULL )
                return FALSE;
        tag->type      = type;
        tag->data_type = D_RATIONAL;
        tag->length    = (long) n;
        if ( value != NULL )
                memcpy(tag->value = (char *) rational_ptr,
                       value,
                       n * sizeof(rational));
        return TRUE;
        }
/*...e*/
/*...swrite_ifh_and_ifd:0:*/
/*...spad:0:*/
static bool pad(int fd, int n)
        {
        static char padding[] = { 0, 0, 0, 0 };

        return write(fd, padding, n) == n;
        }
/*...e*/
/*...swrite_short:0:*/
static bool write_short(int fd, short s)
        {
        byte b[2];

        b[0] = (byte)  (s & 0x00ff);
        b[1] = (byte) ((s & 0xff00) >> 8);

        return write(fd, b, 2) == 2;
        }
/*...e*/
/*...swrite_long:0:*/
static bool write_long(int fd, long l)
        {
        byte b[4];

        b[0] = (byte)  (l & 0x000000ffL);
        b[1] = (byte) ((l & 0x0000ff00L) >>  8);
        b[2] = (byte) ((l & 0x00ff0000L) >> 16);
        b[3] = (byte) ((l & 0xff000000L) >> 24);

        return write(fd, b, 4) == 4;
        }
/*...e*/
/*...swrite_rational:0:*/
static bool write_rational(int fd, rational *rational)
        {
        return write_long(fd, rational->numerator  ) &&
               write_long(fd, rational->denominator) ;
        }
/*...e*/
/*...swrite_tag:0:*/
static bool write_tag(int fd, TAG *tag, long *offset_upto)
        {
        bool ok;
        int     s, i, n, len;
        long    offset_return_to;

        ok = write_short(fd, tag->type) &&
             write_short(fd, tag->data_type) &&
             write_long(fd, tag->length);

        if ( !ok )
                return FALSE;

        /* if we can fit the tag into 4 bytes, do so */
        /* else we will have to allocate some disc space */

        s = sizeof_data_type(tag->data_type);
        n = (int) tag->length;
        len = s * n;

        if ( len > 4 )
                {
                if ( !write_long(fd, *offset_upto) )
                        return FALSE;
                offset_return_to = lseek(fd, 0L, SEEK_CUR);
                lseek(fd, *offset_upto, SEEK_SET);
                }

        /* actually write the tag */

        switch ( tag->data_type )
                {
                case D_BYTE:
                case D_ASCII:
                        if  ( write(fd, tag->value, n) != n )
                                return FALSE;
                        break;
                case D_SHORT:
                        {
                        short   *short_ptr = (short *) tag->value;

                        for ( i = 0; i < n; i++ )
                                if ( !write_short(fd, *short_ptr++) )
                                        return FALSE;
                        }
                        break;
                case D_LONG:
                        {
                        long    *long_ptr = (long *) tag->value;

                        for ( i = 0; i < n; i++ )
                                if ( !write_long(fd, *long_ptr++) )
                                        return FALSE;
                        }
                        break;
                case D_RATIONAL:
                        {
                        rational *rational_ptr = (rational *) tag->value;

                        for ( i = 0; i < n; i++ )
                                if ( !write_rational(fd, rational_ptr++) )
                                        return FALSE;
                        }
                        break;
                }

        if ( len > 4 )
                {
                if ( (*offset_upto = lseek(fd, 0L, SEEK_CUR)) & 1L )
                        /* pad to make next offset even */
                        {
                        if ( !pad(fd, 1) )
                                return FALSE;
                        (*offset_upto)++;
                        }
                lseek(fd, offset_return_to, SEEK_SET);
                }
        else if ( len < 4 )
                if ( !pad(fd, 4 - len) )
                        return FALSE;
        return TRUE;
        }
/*...e*/
/*...swrite_ifd:0:*/
/*
Given an IFD, write it out to disc.
Also patch the IFH (which we know will be at the start of the file).
In writing out a tag we may need some more disc space other than
that for the IFD table. This occurs when a field is larger than
4 bytes. What we do is to keep a pointer to the next free space
(after the table) and write_tag() will advance it if it uses any
extra space.
*/

bool write_ifd(int fd, IFD *ifd)
        {
        int     i, n;
        long    offset_upto;

        if ( !write_short(fd, n = ifd->n_tags) )
                return FALSE;

        /* write out tags */

        offset_upto = lseek(fd, 0L, SEEK_CUR) + n * 12L + 4L;
                /* leave space for each tag plus next IFD ptr */

        for ( i = 0; i < n; i++ )
                if ( !write_tag(fd, &(ifd->tags[i]), &offset_upto) )
                        return FALSE;

        /* done writing out the IFD, now put null next IFD pointer */

        if ( !write_long(fd, 0L) )
                return FALSE;

        lseek(fd, offset_upto, SEEK_SET);

        return TRUE;
        }
/*...e*/

bool write_ifh_and_ifd(IFH *ifh, int fd)
        {
        return write_short(fd, ifh->byte_order) &&
               write_short(fd, ifh->version_no) &&
               write_long(fd, 8L) &&
               write_ifd(fd, ifh->ifd);
        }
/*...e*/
/*...supdate_byte_tag:0:*/
void    update_byte_tag(IFD *ifd, short type, byte *value)
        {
        TAG     *tag;
        int     n;

        tag = locate_tag(ifd, type);
        n = (int) tag->length;
        memcpy(tag->value, value, n * sizeof(byte));
        }
/*...e*/
/*...supdate_ascii_tag:0:*/
void    update_ascii_tag(IFD *ifd, short type, char *value)
        {
        TAG     *tag;
        int     n;

        tag = locate_tag(ifd, type);
        n = (int) tag->length;
        memcpy(tag->value, value, n);
        }
/*...e*/
/*...supdate_short_tag:0:*/
void    update_short_tag(IFD *ifd, short type, short *value)
        {
        TAG     *tag;
        int     n;

        tag = locate_tag(ifd, type);
        n = (int) tag->length;
        memcpy(tag->value, value, n * sizeof(short));
        }
/*...e*/
/*...supdate_long_tag:0:*/
void    update_long_tag(IFD *ifd, short type, long *value)
        {
        TAG     *tag;
        int     n;

        tag = locate_tag(ifd, type);
        n = (int) tag->length;
        memcpy(tag->value, value, n * sizeof(long));
        }
/*...e*/
/*...supdate_rational_tag:0:*/
void    update_rational_tag(IFD *ifd, short type, rational *value)
        {
        TAG     *tag;
        int     n;

        tag = locate_tag(ifd, type);
        n = (int) tag->length;
        memcpy(tag->value, value, n * sizeof(rational));
        }
/*...e*/
/*...supdate_ifd:0:*/
/*
Go back to the IFD, and rewrite it.
*/

bool update_ifd(IFD *ifd, int fd)
        {
        lseek(fd, 8L, SEEK_SET);
        return write_ifd(fd, ifd);
        }
/*...e*/
/*
*****************************************************************************************
*                                                                                       *
* COPYRIGHT:                                                                            *
*   IBM Open Class Library                                                              *
*   (C) Copyright International Business Machines Corporation,  1997                    *
*   Licensed Material - Program-Property of IBM - All Rights Reserved.                  *
*   US Government Users Restricted Rights - Use, duplication, or disclosure             *
*   restricted by GSA ADP Schedule Contract with IBM Corp.                              *
*                                                                                       *
*****************************************************************************************
*/
// Revision: 56 1.4.1.5 source/ographic/igbm.cpp, graphics, ioc.v400, 001006 
/*

IGBMTIF.C  Microsoft/Aldus Tagged Image File Format support

Reads and writes 1,4,8 and 24 bit colour files.
Supports uncompressed, Packbits and LZW compressed files only.
Input option: index=N (default is 0)
Output options: artist=,software=,make=,model=,host=,documentname=,pagename=,
                imagedescription=,pal1bpp

Added support to allow SamplePerPixel>=3 for RGB data (TIFF 6.0 new feature).
Added rejection test of FillOrder!=1.
Added rejection test of PlanarConfiguration!=1.
Added support for CMYK images.
Changed write of 1bpp data to Baseline black and white write.
Added pal1bpp output option meaning don't force Baseline write of 1bpp data.
Improved error messages substantially.
Fixed Packbits compression.
Added support for PlanarConfiguration==2 for RGB images only.
Added Predictor==2 support for bps==8, spp=1 case.
Added Predictor==2 support for bps==8, spp>=3 case.
Removed Too Many Strips limitation.
Faster LZW code.

*/

#if 0
#pragma priority( -2147481424 )

/*...sincludes:0:*/
#include <stdio.h>
#include <ctype.h>
#include <stddef.h>
#include <stdlib.h>
#include <string.h>
#include <memory.h>
#include <malloc.h>
#ifdef AIX
#include <unistd.h>
#else
#include <io.h>
#endif
#include <fcntl.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <igbmstnd.hpp>
#include <igbm.hpp>
#include <igbmhelp.hpp>
#include <igbmtifh.hpp>
#include <icconst.h>
#include <ibase.hpp>

// Segment definitions
#ifdef IC_PAGETUNE
  #define _IGBMTIF_CPP_
  #include <ipagetun.h>
#endif
#endif // 0

/*...vgbm\46\h:0:*/
/*...vgbmhelp\46\h:0:*/
/*...vgbmtifh\46\h:0:*/

#ifndef min
#define min(a,b)        (((a)<(b))?(a):(b))
#endif
/*...e*/

static GBMFT tif_gbmft =
        {
        "TIFF",
        "Tagged Image File Format support (almost TIFF 6.0 Baseline)",
        "TIF TIFF",
        GBM_FT_R1|GBM_FT_R4|GBM_FT_R8|GBM_FT_R24|
        GBM_FT_W1|GBM_FT_W4|GBM_FT_W8|GBM_FT_W24,
        };

/*...serror codes:0:*/
#define GBM_ERR_TIF_VERSION             ((GBM_ERR) 800)
#define GBM_ERR_TIF_N_TAGS              ((GBM_ERR) 801)
#define GBM_ERR_TIF_TAG_TYPE            ((GBM_ERR) 802)
#define GBM_ERR_TIF_HEADER              ((GBM_ERR) 803)
#define GBM_ERR_TIF_MISSING_TAG         ((GBM_ERR) 804)
#define GBM_ERR_TIF_SPP_BIT             ((GBM_ERR) 805)
#define GBM_ERR_TIF_BPS_BIT             ((GBM_ERR) 806)
#define GBM_ERR_TIF_SPP_RGB             ((GBM_ERR) 807)
#define GBM_ERR_TIF_BPS_RGB             ((GBM_ERR) 808)
#define GBM_ERR_TIF_SPP_PAL             ((GBM_ERR) 809)
#define GBM_ERR_TIF_BPS_PAL             ((GBM_ERR) 810)
#define GBM_ERR_TIF_SPP_CMYK            ((GBM_ERR) 811)
#define GBM_ERR_TIF_BPS_CMYK            ((GBM_ERR) 812)
#define GBM_ERR_TIF_COMP_1D_MH          ((GBM_ERR) 813)
#define GBM_ERR_TIF_COMP_T4             ((GBM_ERR) 814)
#define GBM_ERR_TIF_COMP_T6             ((GBM_ERR) 815)
#define GBM_ERR_TIF_COMP                ((GBM_ERR) 816)
#define GBM_ERR_TIF_COLORMAP            ((GBM_ERR) 817)
#define GBM_ERR_TIF_CORRUPT             ((GBM_ERR) 818)
#define GBM_ERR_TIF_PREDICTOR           ((GBM_ERR) 819)
#define GBM_ERR_TIF_PHOTO_TRANS         ((GBM_ERR) 821)
#define GBM_ERR_TIF_PHOTO_Y_Cb_Cr       ((GBM_ERR) 822)
#define GBM_ERR_TIF_PHOTO               ((GBM_ERR) 823)
#define GBM_ERR_TIF_FILLORDER           ((GBM_ERR) 824)
#define GBM_ERR_TIF_PLANARCONFIG_1      ((GBM_ERR) 825)
#define GBM_ERR_TIF_PLANARCONFIG_12     ((GBM_ERR) 826)
#define GBM_ERR_TIF_INKSET              ((GBM_ERR) 827)
#define GBM_ERR_TIF_ORIENT              ((GBM_ERR) 828)
#define GBM_ERR_TIF_INDEX               ((GBM_ERR) 829)
/*...e*/

/*
#define MAX_STRIPS      200
*/
#define MAX_STRIPS      ((PRIV_SIZE-9*sizeof(int)-0x100*sizeof(GBMRGB))/sizeof(long))

typedef struct
        {
        GBMRGB gbmrgb[0x100];
        int rps, spp, bps, comp, photo, orient, planar, predictor, inx;
        long so[MAX_STRIPS];
        } TIF_PRIV;

#define ENC_NONE        ((int) 1)
#define ENC_G3_1D_MH    ((int) 2)
#define ENC_T4          ((int) 3)
#define ENC_T6          ((int) 4)
#define ENC_LZW         ((int) 5)
#define ENC_PACKBITS    ((int) 32773)

#define PHOTO_BIT0      0
#define PHOTO_BIT1      1
#define PHOTO_RGB       2
#define PHOTO_PAL       3
#define PHOTO_TRANS     4
#define PHOTO_CMYK      5
#define PHOTO_Y_Cb_Cr   6

/*...srgb_bgr:0:*/
#ifndef SRGB_BGR_0
#define SRGB_BGR_0
static void rgb_bgr(byte *p, byte *q, int n)
        {
        while ( n-- )
                {
                byte    r = *p++;
                byte    g = *p++;
                byte    b = *p++;

                *q++ = b;
                *q++ = g;
                *q++ = r;
                }
        }
/*...e*/
#endif // SRGB_BGR_0

typedef unsigned int cword;

/*...stif_qft:0:*/
GBM_ERR tif_qft(GBMFT *gbmft)
        {
        *gbmft = tif_gbmft;
        return GBM_ERR_OK;
        }
/*...e*/
/*...stif_rhdr:0:*/
/*...svalue_of_tag_def:0:*/
static long value_of_tag_def(IFD *ifd, short type, long def)
        {
        TAG *tag;

        if ( (tag = locate_tag(ifd, type)) != NULL )
                return value_of_tag(tag);
        else
                return def;
        }
/*...e*/

GBM_ERR tif_rhdr(char *fn, int fd, GBM *gbm, char *opt)
        {
        TIF_PRIV *tif_priv = (TIF_PRIV *) gbm->priv;
        TAG *tag_w, *tag_h, *tag_so;
        GBM_ERR rc;
        IFH     *ifh;
        IFD     *ifd;
        int     inx = 0, strip, n_strips, fillorder;
        char    *index;

        if ( (index = gbm_find_word_prefix(opt, "index=")) != NULL )
                sscanf(index + 6, "%d", &inx);
        tif_priv->inx = inx;

        fn=fn; /* Suppress 'unref arg' compiler warnings */

        lseek(fd, 0L, SEEK_SET);
        switch ( read_ifh_and_ifd(fd, inx, &ifh) )
                {
                case TE_OK:             rc = GBM_ERR_OK;                break;
                case TE_MEM:            rc = GBM_ERR_MEM;               break;
                case TE_VERSION:        rc = GBM_ERR_TIF_VERSION;       break;
                case TE_N_TAGS:         rc = GBM_ERR_TIF_N_TAGS;        break;
                case TE_TAG_TYPE:       rc = GBM_ERR_TIF_TAG_TYPE;      break;
                case TE_N_IFD:          rc = GBM_ERR_TIF_INDEX;         break;
                default:                rc = GBM_ERR_TIF_HEADER;        break;
                }

        if ( rc != GBM_ERR_OK )
                return rc;

        ifd = ifh->ifd;

        if ( (tag_w  = locate_tag(ifd, T_IMAGEWIDTH  )) == NULL ||
             (tag_h  = locate_tag(ifd, T_IMAGELENGTH )) == NULL ||
             (tag_so = locate_tag(ifd, T_STRIPOFFSETS)) == NULL )
                {
                free_ifh(ifh);
                return GBM_ERR_TIF_MISSING_TAG;
                }

        gbm->w           = (int) value_of_tag(tag_w);
        gbm->h           = (int) value_of_tag(tag_h);
        tif_priv->photo  = (int) value_of_tag_def(ifd, T_PHOTOMETRIC    , 1L);
        tif_priv->rps    = (int) value_of_tag_def(ifd, T_ROWSPERSTRIP   , (long) gbm->h);
        tif_priv->spp    = (int) value_of_tag_def(ifd, T_SAMPLESPERPIXEL, 1L);
        tif_priv->bps    = (int) value_of_tag_def(ifd, T_BITSPERSAMPLE  , 1L);
        tif_priv->comp   = (int) value_of_tag_def(ifd, T_COMPRESSION    , 1L);
        tif_priv->orient = (int) value_of_tag_def(ifd, T_ORIENTATION    , 1L);
        tif_priv->planar = (int) value_of_tag_def(ifd, T_PLANARCONFIG   , 1L);

        rc = GBM_ERR_OK;
        switch ( tif_priv->photo )
                {
/*...sPHOTO_BITx    \45\ bitmap or greyscale:16:*/
case PHOTO_BIT0:
case PHOTO_BIT1:
        if ( tif_priv->spp != 1 )
                rc = GBM_ERR_TIF_SPP_BIT;
        else if ( tif_priv->bps != 1 && tif_priv->bps != 4 && tif_priv->bps != 8 )
                rc = GBM_ERR_TIF_BPS_BIT;
        else
                {
                int     i, n_pal;

                n_pal = ( 1 << tif_priv->bps );
                for ( i = 0; i < n_pal; i++ )
                        {
                        tif_priv->gbmrgb[i].r =
                        tif_priv->gbmrgb[i].g =
                        tif_priv->gbmrgb[i].b = (byte) ((0xff * i) / (n_pal - 1));
                        }
                if ( tif_priv->photo == PHOTO_BIT0 )
                        for ( i = 0; i < n_pal; i++ )
                                {
                                tif_priv->gbmrgb[i].r ^= 0xff;
                                tif_priv->gbmrgb[i].g ^= 0xff;
                                tif_priv->gbmrgb[i].b ^= 0xff;
                                }
                }
        gbm->bpp = tif_priv->bps;
        break;
/*...e*/
/*...sPHOTO_RGB     \45\ 24 bit data:16:*/
/* It is possible for sample per pixel to be greater than 3.
   This implies there are extra samples (which we will ignore).
   This is a new TIFF 6.0 feature. */

case PHOTO_RGB:
        if ( tif_priv->spp < 3 )
                rc = GBM_ERR_TIF_SPP_RGB;
        else if ( tif_priv->bps != 8 )
                rc = GBM_ERR_TIF_BPS_RGB;
        gbm->bpp = 24;
        break;
/*...e*/
/*...sPHOTO_PAL     \45\ palettised:16:*/
/*
There are 2 known bugs in commonly available TIFF files today.
UBU will only write a ColorMap tag with a length field of 256 (not 256 * 3).
This bug is fixed inside my TIFF library itself!
OS/2 Image Support will write all palette entrys as bytes!
*/

case PHOTO_PAL:
        if ( tif_priv->spp != 1 )
                rc = GBM_ERR_TIF_SPP_PAL;
        else if ( tif_priv->bps != 1 && tif_priv->bps != 4 && tif_priv->bps != 8 )
                rc = GBM_ERR_TIF_BPS_PAL;
        else
                {
                int     i, n_pal;
                TAG     *tag_cm;

                n_pal = (1 << tif_priv->bps);
                if ( (tag_cm = locate_tag(ifd, T_COLORMAP)) != NULL )
                        {
                        GBMRGB  *gbmrgb;

                        for ( i = 0, gbmrgb = tif_priv->gbmrgb; i < n_pal; i++, gbmrgb++ )
                                {
                                gbmrgb->r = (byte) (value_of_tag_n(tag_cm,             i) >> 8);
                                gbmrgb->g = (byte) (value_of_tag_n(tag_cm,     n_pal + i) >> 8);
                                gbmrgb->b = (byte) (value_of_tag_n(tag_cm, 2 * n_pal + i) >> 8);
                                }
/*...sfix for OS\47\2 Image Support \40\and others\41\:40:*/
{
byte    bugfix = 0;

for ( i = 0, gbmrgb = tif_priv->gbmrgb; i < n_pal; i++, gbmrgb++ )
        bugfix |= (gbmrgb->r | gbmrgb->g | gbmrgb->b);

if ( bugfix == 0 )
        for ( i = 0, gbmrgb = tif_priv->gbmrgb; i < n_pal; i++, gbmrgb++ )
                {
                gbmrgb->r = (byte) value_of_tag_n(tag_cm,             i);
                gbmrgb->g = (byte) value_of_tag_n(tag_cm,     n_pal + i);
                gbmrgb->b = (byte) value_of_tag_n(tag_cm, 2 * n_pal + i);
                }
}
/*...e*/
                        }
                else
                        rc = GBM_ERR_TIF_COLORMAP;
                }
        gbm->bpp = tif_priv->bps;
        break;
/*...e*/
/*...sPHOTO_TRANS   \45\ transparency mask:16:*/
case PHOTO_TRANS:
        rc = GBM_ERR_TIF_PHOTO_TRANS;
        break;
/*...e*/
/*...sPHOTO_CMYK    \45\ CMYK or other seperated image:16:*/
/* This is a colour seperated image.
   Typically expect 4 seperations, for CMYK.
   Can be other numbers, and possibly 4 with non standard ink colours.
   Ignore all but 4 seperations which are CMYK.
   Consider this a 24 bit RGB, mapping will occur from CMYK to RGB. */

case PHOTO_CMYK:
        if ( tif_priv->spp != 4 )
                rc = GBM_ERR_TIF_SPP_CMYK;
        else if ( tif_priv->bps != 8 )
                rc = GBM_ERR_TIF_BPS_CMYK;
        else if ( value_of_tag_def(ifd, T_INKSET, 1L) != 1 )
                rc = GBM_ERR_TIF_INKSET;
        else
                gbm->bpp = 24;
        break;
/*...e*/
/*...sPHOTO_Y_Cb_Cr \45\ Y\45\Cb\45\Cr colour space:16:*/
case PHOTO_Y_Cb_Cr:
        rc = GBM_ERR_TIF_PHOTO_Y_Cb_Cr;
        break;
/*...e*/
/*...sdefault       \45\ wierd PhotometricInterpretation:16:*/
default:
        rc = GBM_ERR_TIF_PHOTO;
        break;
/*...e*/
                }

        if ( rc != GBM_ERR_OK )
                { free_ifh(ifh); return rc; }

        /* Remember where strips are, and how big they are */

        n_strips = (gbm->h + (tif_priv->rps - 1)) / tif_priv->rps;
        if ( tif_priv->photo == PHOTO_RGB && tif_priv->planar == 2 )
                n_strips *= 3;

        if ( n_strips <= MAX_STRIPS )
                for ( strip = 0; strip < n_strips; strip++ )
                        tif_priv->so[strip] = value_of_tag_n(tag_so, strip);

        if ( tif_priv->comp != ENC_NONE     &&
             tif_priv->comp != ENC_PACKBITS &&
             tif_priv->comp != ENC_LZW      )
/*...sreject compression type:16:*/
{
free_ifh(ifh);
switch ( tif_priv->comp )
        {
        case ENC_G3_1D_MH:      return GBM_ERR_TIF_COMP_1D_MH;
        case ENC_T4:            return GBM_ERR_TIF_COMP_T4   ;
        case ENC_T6:            return GBM_ERR_TIF_COMP_T6   ;
        default:                return GBM_ERR_TIF_COMP      ;
        }
}
/*...e*/

        if ( tif_priv->orient != 1 && tif_priv->orient != 4 )
                { free_ifh(ifh); return GBM_ERR_TIF_ORIENT; }

        fillorder = (int) value_of_tag_def(ifd, T_FILLORDER, 1L);
        if ( fillorder != 1 )
                { free_ifh(ifh); return GBM_ERR_TIF_FILLORDER; }

        if ( tif_priv->photo == PHOTO_RGB )
                /* Allow photo of 1 or 2 */
                {
                if ( tif_priv->planar != 1 && tif_priv->planar != 2 )
                        { free_ifh(ifh); return GBM_ERR_TIF_PLANARCONFIG_12; }
                }
        else
                /* Allow photo of 1 only */
                {
                if ( tif_priv->planar != 1 )
                        { free_ifh(ifh); return GBM_ERR_TIF_PLANARCONFIG_1; }
                }

        tif_priv->predictor = (int) value_of_tag_def(ifd, T_PREDICTOR, 1L);

        /* Only allow predictor of 1, unless a special case we handle */
        if ( tif_priv->predictor != 1 &&
             !(tif_priv->comp == ENC_LZW &&
               tif_priv->bps == 8 &&
               (tif_priv->spp == 1 || tif_priv->spp >= 3)) )
                { free_ifh(ifh); return GBM_ERR_TIF_PREDICTOR; }

        free_ifh(ifh);

        return GBM_ERR_OK;
        }
/*...e*/
/*...stif_rpal:0:*/
GBM_ERR tif_rpal(int fd, GBM *gbm, GBMRGB *gbmrgb)
        {
        TIF_PRIV *tif_priv = (TIF_PRIV *) gbm->priv;

        fd=fd; /* Suppress 'unref arg' compiler warning */

        if ( gbm->bpp != 24 )
                memcpy(gbmrgb, tif_priv->gbmrgb, (1 << gbm->bpp) * sizeof(GBMRGB));

        return GBM_ERR_OK;
        }
/*...e*/
/*...stif_rdata:0:*/
/*
TIFF data is usually stored top-left-origin based.
ie: We ignore the private "Orientation" tag.
Our data format in memory has bigger padding than TIFF.
It has 'istride' bytes per line, GBM uses/requires 'stride' bytes per line.
Therefore we read it to the part of the strip area and then expand downwards.
*/

/*...sget_strip_packbits \45\ get bytes with packbits decompression:0:*/
static GBM_ERR get_strip_packbits(int fd, byte *dest, long n_bytes)
        {
        AHEAD *ahead;

        if ( (ahead = gbm_create_ahead(fd)) == NULL )
                return GBM_ERR_MEM;

        while ( n_bytes > 0 )
                {
                byte b = (byte) gbm_read_ahead(ahead);

                if ( b < 0x80 )
                        {
                        unsigned int count = b + 1;

                        do
                                *dest++ = (byte) gbm_read_ahead(ahead);
                        while ( --count > 0 );
                        n_bytes -= (b + 1);
                        }
                else if ( b > 0x80 )
                        {
                        unsigned int count = 0x101 - (unsigned int) b;
                        byte c = (byte) gbm_read_ahead(ahead);

                        memset(dest, c, count);
                        dest += count;
                        n_bytes -= count;
                        }
                }

        gbm_destroy_ahead(ahead);
        return GBM_ERR_OK;
        }
/*...e*/
/*...sget_strip_lzw      \45\ get bytes with TIFF style LZW decompression:0:*/
/*
This code run on output of FotoTouch and some sample TIFFs from an afs
directory on the IBM IP-network.
*/

/*...sread context:0:*/
typedef struct
        {
        int fd;                         /* File descriptor to read */
        int inx, size;                  /* Index and size in bits */
        byte buf[255+3];                /* Buffer holding bits */
        int code_size;                  /* Number of bits to return at once */
        word read_mask;                 /* 2^code_size-1 */
        } READ_TCONTEXT;

static word read_tcode(READ_TCONTEXT *c)
        {
        int raw_code, byte_inx;

        if ( c->inx + c->code_size > c->size )
/*...snot enough bits in buffer\44\ refill it:16:*/
/* Not very efficient, but infrequently called */

{
int bytes_to_lose = (c->inx >> 3);
int bytes;

/* Note biggest code size is 12 bits */
/* And this can at worst span 3 bytes */
memcpy(c->buf, c->buf + bytes_to_lose, 3);
(c->inx) &= 7;
(c->size) -= (bytes_to_lose << 3);
bytes = 255 - ( c->size >> 3 );
if ( (bytes = read(c->fd, c->buf + (c->size >> 3), bytes)) <= 0 )
        return 0xffff;
(c->size) += (bytes << 3);
}
/*...e*/

        byte_inx = (c->inx >> 3);
        raw_code = ((c->buf[byte_inx    ]) << 16) +
                   ((c->buf[byte_inx + 1]) <<  8) +
                   ( c->buf[byte_inx + 2]       ) ;
        raw_code <<= ((c->inx) & 7);
        (c->inx) += (byte) (c->code_size);
        raw_code >>= ( 24 - c->code_size );
        return (word) raw_code & c->read_mask;
        }
/*...e*/

#define INIT_CODE_SIZE  9

static GBM_ERR get_strip_lzw(int fd, byte *dest, long n_bytes)
        {
        word max_code;                  /* 1 << code_size */
        word clear_code;                /* Code to clear table */
        word eoi_code;                  /* End of information code */
        word first_free_code;           /* First free code */
        word free_code;                 /* Next available free code slot */
        int i, out_count = 0;
        word code, cur_code, old_code, in_code, fin_char;
        word *prefix, *suffix, *outcode;
        READ_TCONTEXT c;
        bool table_full = false;

        n_bytes=n_bytes; /* Suppress 'unref arg' compiler warning */

        if ( (prefix = (word *) malloc(4096 * sizeof(word))) == NULL )
                return GBM_ERR_MEM;
        if ( (suffix = (word *) malloc(4096 * sizeof(word))) == NULL )
                {
                free(prefix);
                return GBM_ERR_MEM;
                }
        if ( (outcode = (word *) malloc(4097 * sizeof(word))) == NULL )
                {
                free(suffix);
                free(prefix);
                return GBM_ERR_MEM;
                }

        /* Initial read context */

        c.inx            = 0;
        c.size           = 0;
        c.fd             = fd;
        c.code_size      = INIT_CODE_SIZE;
        c.read_mask      = (word) ( (1 << INIT_CODE_SIZE) - 1 );

        /* 2^min_code size accounts for all colours in file */

        clear_code = (word) ( 1 << (INIT_CODE_SIZE - 1) );
        eoi_code = (word) (clear_code + 1);
        free_code = first_free_code = (word) (clear_code + 2);

        max_code = (word) ( 1 << INIT_CODE_SIZE );

        while ( (code = read_tcode(&c)) != eoi_code && code != 0xffff )
                {
                if ( code == clear_code )
                        {
                        c.code_size = INIT_CODE_SIZE;
                        c.read_mask = (word) ( (1 << INIT_CODE_SIZE) - 1);
                        max_code = (word) ( 1 << INIT_CODE_SIZE );
                        free_code = first_free_code;
                        cur_code = old_code = code = read_tcode(&c);
                        if ( code == eoi_code || code == 0xffff )
                                break;
                        fin_char = cur_code;
                        *dest++ = (byte) fin_char;
                        table_full = false;
                        }
                else
                        {
                        cur_code = in_code = code;
                        if ( cur_code >= free_code )
                                {
                                cur_code = old_code;
                                outcode[out_count++] = fin_char;
                                }
                        while ( cur_code > 0xff )
                                {
                                if ( out_count > 4096 )
                                        {
                                        free(outcode);
                                        free(suffix);
                                        free(prefix);
                                        return GBM_ERR_TIF_CORRUPT;
                                        }
                                outcode[out_count++] = suffix[cur_code];
                                cur_code = prefix[cur_code];
                                }
                        fin_char = cur_code;
                        outcode[out_count++] = fin_char;
                        for ( i = out_count - 1; i >= 0; i-- )
                                *dest++ = outcode[i];
                        out_count = 0;

                        /* Update dictionary */

                        if ( !table_full )
                                {
                                prefix[free_code] = old_code;
                                suffix[free_code] = fin_char;

                                /* Advance to next free slot */

                                if ( ++free_code >= max_code - 1 )
                                        {
                                        if ( c.code_size < 12 )
                                                {
                                                c.code_size++;
                                                max_code <<= 1;
                                                c.read_mask = (word) (( 1 << c.code_size ) - 1);
                                                }
                                        else
                                                table_full = true;
                                        }
                                }
                        old_code = in_code;
                        }
                }

        free(outcode);
        free(suffix);
        free(prefix);

        if ( code == 0xffff )
                return GBM_ERR_READ;

        return GBM_ERR_OK;
        }
/*...e*/
/*...sget_strip_lzw_pred \45\ get_strip_lzw with non 1 predictor fixup:0:*/
static GBM_ERR get_strip_lzw_pred(
        int fd,
        byte *dest,
        long n_bytes,
        TIF_PRIV *tif_priv,
        int w, int h
        )
        {
        GBM_ERR rc;

        if ( (rc = get_strip_lzw(fd, dest, n_bytes)) != GBM_ERR_OK )
                return rc;

        if ( tif_priv->predictor == 2 )
                /* Note: This is only allowed if bps==8 */
                        {
                        int x, y, spp = tif_priv->spp;
                        for ( y = 0; y < h; y++, dest += w * spp )
                                for ( x = spp; x < w * spp; x++ )
                                        dest[x] += dest[x - spp];
                        }

        return GBM_ERR_OK;
        }
/*...e*/
/*...sget_strip_comp     \45\ get strip\44\ dealing with any compression:0:*/
/* n_bytes is passed in as istride * n_lines */

static GBM_ERR get_strip_comp(
        int fd,
        byte *dest,
        long so, long n_bytes,
        TIF_PRIV *tif_priv,
        int w, int h
        )
        {
        lseek(fd, so, SEEK_SET);
        switch ( tif_priv->comp )
                {
/*...sENC_NONE     \45\ no compression:16:*/
case ENC_NONE:
        return ( (int) n_bytes == read(fd, dest, (int) n_bytes) ) ?
                        GBM_ERR_OK : GBM_ERR_READ;
/*...e*/
/*...sENC_PACKBITS \45\ packbits:16:*/
case ENC_PACKBITS:
        return get_strip_packbits(fd, dest, n_bytes);
/*...e*/
/*...sENC_LZW      \45\ lzw:16:*/
case ENC_LZW:
        return get_strip_lzw_pred(fd, dest, n_bytes, tif_priv, w, h);
/*...e*/
                }
        return GBM_ERR_NOT_SUPP;
        }
/*...e*/
/*...sget_strip          \45\ get strip\44\ discarding extra samples\44\ and CMYK mapping:0:*/
/*
If there are too many samples per pixel, this code can ignore the extra ones.
Also, if CMYK data is being read, it will read the CMYK, and convert.
This requires a temporary buffer, to read the original data in.
The original data is then 'converted'.
*/

static GBM_ERR get_strip(
        int fd,
        byte *dest,
        long so, long n_bytes,
        TIF_PRIV *tif_priv,
        int w, int h
        )
        {
        byte *buf = dest;
        GBM_ERR rc;

        if ( tif_priv->photo == PHOTO_CMYK )
/*...sallocate space for CMYK image:16:*/
{
n_bytes = (long) w * 4L * (long) h;
if ( (buf = (byte*)malloc(n_bytes)) == NULL )   // mjs
        return GBM_ERR_MEM;
}
/*...e*/
        else if ( tif_priv->photo == PHOTO_RGB && tif_priv->spp > 3 )
/*...sallocate space for image \43\ extra samples:16:*/
{
n_bytes = (long) w * tif_priv->spp * (long) h;
if ( (buf = (byte*)malloc(n_bytes)) == NULL )  // mjs
        return GBM_ERR_MEM;
}
/*...e*/

        if ( (rc = get_strip_comp(fd, buf, so, n_bytes, tif_priv, w, h)) != GBM_ERR_OK )
                {
                if ( buf != dest )
                        free(buf);
                return rc;
                }

        if ( tif_priv->photo == PHOTO_CMYK )
/*...sconvert from CMYK to RGB:16:*/
{
int x, yy;
byte *buf_p = buf, *dest_p = dest;
for ( yy = 0; yy < h; yy++ )
        for ( x = 0; x < w; x++ )
                {
                word c = *buf_p++;
                word m = *buf_p++;
                word y = *buf_p++;
                word k = *buf_p++;

                /* Exploit 8 bit modulo arithmetic by biasing by + 0x100 */

                word r = 0x1ff - (c + k);
                word g = 0x1ff - (m + k);
                word b = 0x1ff - (y + k);

                if ( r < 0x100 ) r = 0x100;
                if ( g < 0x100 ) g = 0x100;
                if ( b < 0x100 ) b = 0x100;

                *dest_p++ = (byte) r;
                *dest_p++ = (byte) g;
                *dest_p++ = (byte) b;
                }

free(buf);
}
/*...e*/
        else if ( tif_priv->photo == PHOTO_RGB && tif_priv->spp > 3 )
/*...sextract\44\ ignoring extra\45\samples:16:*/
{
int x, y, skip = tif_priv->spp - 2;
byte *buf_p = buf, *dest_p = dest;
for ( y = 0; y < h; y++ )
        for ( x = 0; x < w; x++ )
                {
                *dest_p++ = *buf_p++;
                *dest_p++ = *buf_p++;
                *dest_p++ = *buf_p  ;
                buf_p += skip;
                }

free(buf);
}
/*...e*/

        return GBM_ERR_OK;
        }
/*...e*/
/*...sget_image          \45\ get all strips\44\ result is whole image:0:*/
/*
This routine calls get_strip() to get strips data one after another until it
has read the entire images worth of data. Of course, scan lines are aligned on
byte boundaries, and the data is usually considered to be image top to bottom.
*/

static GBM_ERR get_image(
        int fd,
        byte *dest,
        TIF_PRIV *tif_priv,
        long *so,
        GBM *gbm,
        int *strip
        )
        {
        GBM_ERR rc;
        int y, istride = ((gbm->w * gbm->bpp + 7) / 8);

        for ( y = 0; y < gbm->h; y += tif_priv->rps, (*strip)++ )
                {
                int n_lines = min(tif_priv->rps, gbm->h - y);
                if ( (rc = get_strip(fd, dest + y * istride,
                                     so[*strip],
                                     (long) n_lines * (long) istride,
                                     tif_priv,
                                     gbm->w, n_lines)) != GBM_ERR_OK )
                        return rc;
                }

        return GBM_ERR_OK;
        }
/*...e*/
/*...sget_image_planar   \45\ get all strips\44\ allowing for PlanarConfiguration:0:*/
/*
get_image() will assume the data is in PlanarConfiguration==1, ie: chunky
pixel mode. This is true most of the time. But sometimes we will actually
allow PlanarConfiguration==2. In this case, use get_image() and then fix-up
the results.
*/

static GBM_ERR get_image_planar(
        int fd,
        byte *dest,
        TIF_PRIV *tif_priv,
        long *so,
        GBM *gbm
        )
        {
        int strip = 0;

        if ( tif_priv->photo == PHOTO_RGB &&
             tif_priv->planar == 2 )
/*...sread 3 seperate planes\44\ and combine them:16:*/
/*
If PhotometricInterpretation==RGB and
   SamplesPerPixel>=3 and
   BitsPerSample==8 then
        we allow PlanarConfiguration==2

I have successfully read in a PlanarConfiguration==2 RGB TIFF file by using
the "read 3 images" logic below. This image had RowsPerStrip==1, and so
technically either fold below would have worked. I think the read 3 images
logic is a better interpretation of the TIFF 6.0 spec., but until I find
some other images I can handle, I will keep the alternative peice of code.
*/

{
GBM_ERR rc;
GBM gbm_planar;
int saved_spp = tif_priv->spp;
int n_bytes = gbm->w * gbm->h;
int x, y;
byte *buf, *p[3];

if ( (buf = (byte*)malloc(n_bytes * 3)) == NULL )
        return GBM_ERR_MEM;
p[0] = buf;
p[1] = p[0] + n_bytes;
p[2] = p[1] + n_bytes;

tif_priv->spp = 1;
/*...sread 3 images:16:*/
{
int i;

gbm_planar.w   = gbm->w;
gbm_planar.h   = gbm->h;
gbm_planar.bpp = 8;
for ( i = 0; i < 3; i++ )
        if ( (rc = get_image(fd, p[i], tif_priv, so, &gbm_planar, &strip)) != GBM_ERR_OK )
                {
                tif_priv->spp = saved_spp;
                free(buf);
                return rc;
                }
}
/*...e*/
#ifdef NEVER
/*...sread single image 3x too high:16:*/
gbm_planar.w   = gbm->w;
gbm_planar.h   = gbm->h * 3;
gbm_planar.bpp = 8;
if ( (rc = get_image(fd, buf, tif_priv, so, &gbm_planar, &strip)) != GBM_ERR_OK )
        {
        tif_priv->spp = saved_spp;
        free(buf);
        return rc;
        }
/*...e*/
#endif
tif_priv->spp = saved_spp;

for ( y = 0; y < gbm->h; y++ )
        for ( x = 0; x < gbm->w; x++ )
                {
                *dest++ = *(p[0])++;
                *dest++ = *(p[1])++;
                *dest++ = *(p[2])++;
                }
free(buf);
return GBM_ERR_OK;
}
/*...e*/
        else
                return get_image(fd, dest, tif_priv, so, gbm, &strip);
        }
/*...e*/
/*...sget_image_orient   \45\ get all strips\44\ correctly orientated:0:*/
static GBM_ERR get_image_orient(
        int fd,
        byte *dest,
        TIF_PRIV *tif_priv,
        long *so,
        GBM *gbm
        )
        {
        switch ( tif_priv->orient )
                {
/*...s1 \45\ usual Baseline required case:16:*/
/*
File has array[scanlines_down] of array[pixels_across] of pixel.
GBMs bitmap data is array[scanlines_up] of array[pixels_across] of pixel.
So call get_image_planar(), and vertically reflect resulting data.
*/

case 1:
        {
        int istride = ((gbm->bpp * gbm->w + 7) / 8);
        byte *p0, *p1, *p2;
        GBM_ERR rc;
        if ( (rc = get_image_planar(fd, dest, tif_priv, so, gbm)) != GBM_ERR_OK )
                return rc;
        if ( (p0 = (byte*)malloc(istride)) == NULL )
                return GBM_ERR_MEM;
        for ( p1 = dest, p2 = p1 + (gbm->h - 1) * istride;
              p1 < p2;
              p1 += istride, p2 -= istride )
                {
                memcpy(p0, p1, istride);
                memcpy(p1, p2, istride);
                memcpy(p2, p0, istride);
                }
        free(p0);
        return GBM_ERR_OK;
        }
/*...e*/
/*...s4 \45\ vertically swapped case we can easily handle:16:*/
/*
File has array[scanlines_up] of array[pixels_across] of pixel.
Exactly matches GBMs layout of a bitmap.
So simply call get_image() and be done with.
*/

case 4:
        return get_image_planar(fd, dest, tif_priv, so, gbm);
/*...e*/
                }
        return GBM_ERR_NOT_SUPP; /* Shouldn't get here */
        }
/*...e*/
/*...sget_image_strippy  \45\ get all strips\44\ when there are loads of them:0:*/
static GBM_ERR get_image_strippy(
        int fd,
        byte *dest,
        TIF_PRIV *tif_priv,
        GBM *gbm
        )
        {
        int n_strips = (gbm->h + (tif_priv->rps - 1)) / tif_priv->rps;
        long *so = tif_priv->so;

        if ( n_strips > MAX_STRIPS )
/*...sre\45\read TIFF file header:16:*/
{
GBM_ERR rc;
int strip;
IFH *ifh;
IFD *ifd;
TAG *tag_so;

if ( (so = (long*)malloc(n_strips * sizeof(long))) == NULL )  // mjs
        return GBM_ERR_MEM;

lseek(fd, 0L, SEEK_SET);
if ( read_ifh_and_ifd(fd, tif_priv->inx, &ifh) != TE_OK )
        {
        free(so);
        return GBM_ERR_MEM;
        }
ifd = ifh->ifd;
tag_so = locate_tag(ifd, T_STRIPOFFSETS);
for ( strip = 0; strip < n_strips; strip++ )
        so[strip] = value_of_tag_n(tag_so, strip);
free_ifh(ifh);

rc = get_image_orient(fd, dest, tif_priv, so, gbm);

free(so);
return rc;
}
/*...e*/
        else
                return get_image_orient(fd, dest, tif_priv, so, gbm);
        }
/*...e*/

GBM_ERR tif_rdata(int fd, GBM *gbm, byte *data)
        {
        TIF_PRIV *tif_priv = (TIF_PRIV *) gbm->priv;
        int stride = ((gbm->bpp * gbm->w + 31) / 32) * 4;
        int istride = ((gbm->bpp * gbm->w + 7) / 8);
        int bias = gbm->h * (stride - istride);
        GBM_ERR rc;

        /* Read in data, packed close, and upside down */

        if ( (rc = get_image_strippy(fd, data + bias, tif_priv, gbm)) != GBM_ERR_OK )
                return rc;

/*...snow expand out from byte padding to dword padding:8:*/
if ( bias )
        {
        int y;
        byte *dest = data, *src  = data + bias;

        for ( y = 0; y < gbm->h; y++, dest += stride, src += istride )
                memcpy(dest, src, istride);
        }
/*...e*/
/*...snow RGB\45\\62\BGR if 24 bit data returned:8:*/
if ( gbm->bpp == 24 )
        {
        int y;
        byte *p = data;

        for ( y = 0; y < gbm->h; y++, p += stride )
                rgb_bgr(p, p, gbm->w);
        }
/*...e*/

        return GBM_ERR_OK;
        }
/*...e*/
/*...stif_w:0:*/
/*
Write out data in a single large strip for now.
Note that the palette entrys are written as ((r << 8) | r).
This means they are 257/256 too big (insignificant).
Most programs only look at the top 8 bits (ie: no error).
A few (incorrectly) look at the bottom 8 bits.
Therefore we cater for all programs, with minimal fuss.
*/

/*...suser_tag:0:*/
static bool user_tag(IFD *ifd, char *name, short type, char *opt, char *def)
        {
        char    buf[200+1], *s;

        if ( (s = gbm_find_word_prefix(opt, name)) != NULL )
                sscanf(s + strlen(name), "%s", buf);
        else
                strcpy(buf, def);

        if ( *buf == '\0' )
                return true;

        return add_ascii_tag(ifd, type, buf);
        }
/*...e*/
/*...swrite_strip:0:*/
static GBM_ERR write_strip(int fd, int w, int h, int bpp, byte *data)
        {
        int stride = ((bpp * w + 31) / 32) * 4;
        int ostride = ((bpp * w + 7) / 8);
        int y;
        data += ((h - 1) * stride);
        if ( bpp == 24 )
/*...sreverse rgb\47\bgr ordering and write:16:*/
{
byte *line;

if ( (line = (byte*)malloc(ostride)) == NULL )  // mjs
        return GBM_ERR_MEM;
for ( y = 0; y < h; y++, data -= stride )
        {
        rgb_bgr(data, line, w);
        if ( write(fd, line, ostride) != ostride )
                {
                free(line);
                return GBM_ERR_WRITE;
                }
        }
free(line);
}
/*...e*/
        else
/*...swrite:16:*/
for ( y = 0; y < h; y++, data -= stride )
        if ( write(fd, data, ostride) != ostride )
                return GBM_ERR_WRITE;
/*...e*/
        return GBM_ERR_OK;
        }
/*...e*/
/*...swrite_strip_lzw \45\ new fast tail\43\col lookup version:0:*/
/*
This is a tricky bit of code to get right.
This code blantantly copied and hacked from that in gbmgif.c!
hashvalue is calculated from a string of pixels cumulatively.
hashtable is searched starting at index hashvalue for to find the entry.
hashtable is big enough so that MAX_HASH > 4*MAX_DICT.
*/

/*...swrite context:0:*/
#define L_BUF 1024

typedef struct
        {
        int fd;                         /* Open file descriptor to write to */
        int inx;                        /* Bit index into buf */
        int code_size;                  /* Code size in bits */
        byte buf[L_BUF+2];              /* Biggest block + overflow space */
        } WRITE_TCONTEXT;

static bool write_tcode(int code, WRITE_TCONTEXT *w)
        {
        byte *buf = w->buf + (w->inx >> 3);

        code <<= (24-w->code_size);
        code >>= (w->inx&7);
        *buf++ |= (byte) (code >> 16);
        *buf++  = (byte) (code >>  8);
        *buf    = (byte)  code       ;

        (w->inx) += (w->code_size);
        if ( w->inx >= L_BUF * 8 )
                /* Flush out full buffer */
                {
                if ( write(w->fd, w->buf, L_BUF) != L_BUF )
                        return false;
                memcpy(w->buf, w->buf + L_BUF, 2);
                memset(w->buf + 2, 0, L_BUF);
                (w->inx) -= (L_BUF * 8);
                }

        return true;
        }

static bool flush_tcode(WRITE_TCONTEXT *w)
        {
        int bytes = ((w->inx + 7) >> 3);

        if ( bytes )
                {
                if ( write(w->fd, w->buf, bytes) != bytes )
                        return false;
                }

        return true;
        }
/*...e*/

#define MAX_HASH        17777           /* Probably prime, and > 4096        */
#define MAX_DICT        4096            /* Dictionary size                   */
#define INIT_HASH(p)    (((p)+3)*301)   /* Initial hash value                */
#define INIT_CODE_SIZE  9
#define CLEAR_CODE      ((cword) 0x100)
#define EOI_CODE        ((cword) 0x101)

#ifndef DEFINDED_DICT
#define DEFINDED_DICT
typedef struct { cword tail; byte col; } DICT;
#endif // DEFINDED_DICT

static GBM_ERR write_strip_lzw(int fd, int w, int h, int bpp, byte *data)
        {
        int stride = ((bpp * w + 31) / 32) * 4;
        int ostride = ((bpp * w + 7) / 8);
        WRITE_TCONTEXT wc;
        cword last_code, max_code, tail;
        int x, y;
        unsigned int hashvalue, lenstring, j;
        DICT *dict, **hashtable;

        if ( (dict = (DICT *) malloc(MAX_DICT * sizeof(DICT))) == NULL )
                return GBM_ERR_MEM;

        if ( (hashtable = (DICT **) malloc(MAX_HASH * sizeof(DICT *))) == NULL )
                {
                free(dict);
                return GBM_ERR_MEM;
                }

        /* Setup write context */

        wc.fd        = fd;
        wc.inx       = 0;
        wc.code_size = INIT_CODE_SIZE;
        memset(wc.buf, 0, sizeof(wc.buf));

        if ( !write_tcode(CLEAR_CODE, &wc) )
                {
                free(hashtable);
                free(dict);
                return GBM_ERR_WRITE;
                }

        last_code = EOI_CODE;
        max_code  = ( 1 << INIT_CODE_SIZE );
        lenstring = 0;

        for ( j = 0; j < MAX_HASH; j++ )
                hashtable[j] = NULL;

        data += ( (h - 1) * stride );
        for ( y = h - 1; y >= 0; y--, data -= stride )
                {
                int inx1 = 0, inx2 = 2;
                for ( x = 0; x < ostride; x++ )
                        {
                        byte col;
/*...sget byte to write to col:24:*/
if ( bpp == 24 )
        /* Have to handle rgb/bgr reverse as we go along */
        {
        col = data[inx1+inx2];
        if ( --inx2 < 0 )
                {
                inx1 += 3; inx2 = 2;
                }
        }
else
        col = data[x];
/*...e*/
/*...sLZW encode:24:*/
if ( ++lenstring == 1 )
        {
        tail      = col;
        hashvalue = INIT_HASH(col);
        }
else
        {
        hashvalue *= ( col + lenstring + 4 );
        j = ( hashvalue %= MAX_HASH );
        while ( hashtable[j] != NULL &&
                ( hashtable[j]->tail != tail ||
                  hashtable[j]->col  != col  ) )
                if ( ++j >= MAX_HASH )
                        j = 0;
        if ( hashtable[j] != NULL )
                /* Found in the strings table */
                tail = (hashtable[j]-dict);
        else
                /* Not found */
                {
                if ( !write_tcode(tail, &wc) )
                        {
                        free(hashtable);
                        free(dict);
                        return GBM_ERR_WRITE;
                        }
                hashtable[j]       = dict + ++last_code;
                hashtable[j]->tail = tail;
                hashtable[j]->col  = col;
                tail               = col;
                hashvalue          = INIT_HASH(col);
                lenstring          = 1;

/* Note: Things change 1 earlier than in the GIF LZW case, hence -1. */

                if ( last_code >= max_code -1 )
                        /* Next code will be written longer */
                        {
                        max_code <<= 1;
                        wc.code_size++;
                        }
                else if ( last_code >= MAX_DICT-2 )
                        /* Reset tables */
                        {
                        if ( !write_tcode(tail      , &wc) ||
                             !write_tcode(CLEAR_CODE, &wc) )
                                {
                                free(hashtable);
                                free(dict);
                                return GBM_ERR_WRITE;
                                }
                        lenstring    = 0;
                        last_code    = EOI_CODE;
                        wc.code_size = INIT_CODE_SIZE;
                        max_code     = ( 1 << INIT_CODE_SIZE );
                        for ( j = 0; j < MAX_HASH; j++ )
                                hashtable[j] = NULL;
                        }
                }
        }
/*...e*/
                        }
                }

        free(hashtable);
        free(dict);

        if ( !write_tcode(tail    , &wc) ||
             !write_tcode(EOI_CODE, &wc) ||
             !flush_tcode(          &wc) )
                return GBM_ERR_WRITE;

        return GBM_ERR_OK;
        }
/*...e*/

GBM_ERR tif_w(char *fn, int fd, GBM *gbm, GBMRGB *gbmrgb, byte *data, char *opt)
        {
        bool baseline = ( gbm_find_word(opt, "pal1bpp") == NULL );
        bool lzw      = ( gbm_find_word(opt, "lzw"    ) != NULL );
        IFH     *ifh;
        IFD     *ifd;
        long    w = gbm->w;
        long    h = gbm->h;
        long    stripoffset, stripbytecount;
        short   samplesperpixel, bitspersample[3], photo, comp;
        short   colormap[0x100+0x100+0x100];
        bool ok;
        GBM_ERR rc;

        fn=fn; /* Suppress 'unref arg' compiler warning */

        if ( (ifh = make_ifh()) == NULL )
                return GBM_ERR_MEM;

        ifd = ifh->ifd;

        if ( gbm->bpp == 1 && baseline )
                {
                word k0 = (word) gbmrgb[0].r + (word) gbmrgb[0].g + (word) gbmrgb[0].b;
                word k1 = (word) gbmrgb[1].r + (word) gbmrgb[1].g + (word) gbmrgb[1].b;
                samplesperpixel   = 1;
                bitspersample[0] = 1;
                photo = ( k0 < k1 ) ? PHOTO_BIT1 : PHOTO_BIT0; /* Black is zero : White is zero */
                }
        else if ( gbm->bpp == 24 )
                {
                samplesperpixel   = 3;
                bitspersample[0] =
                bitspersample[1] =
                bitspersample[2] = 8;
                photo = PHOTO_RGB;
                }
        else
                {
                samplesperpixel   = 1;
                bitspersample[0] = (short) gbm->bpp;
                photo = PHOTO_PAL;
                }

        comp = ( lzw ) ? ENC_LZW : ENC_NONE;

        ok = add_long_tag(ifd, T_IMAGEWIDTH, &w, 1) &&
             add_long_tag(ifd, T_IMAGELENGTH, &h, 1) &&
             add_long_tag(ifd, T_STRIPOFFSETS, &stripoffset, 1) &&
             add_long_tag(ifd, T_STRIPBYTECOUNTS, &stripbytecount, 1) &&
             add_short_tag(ifd, T_SAMPLESPERPIXEL, &samplesperpixel, 1) &&
             add_short_tag(ifd, T_BITSPERSAMPLE, bitspersample, samplesperpixel) &&
             add_short_tag(ifd, T_PHOTOMETRIC, &photo, 1) &&
             add_short_tag(ifd, T_COMPRESSION, &comp, 1) &&
             user_tag(ifd, "artist=", T_ARTIST, opt, "") &&
             user_tag(ifd, "software=", T_MAKE, opt, "Generalised Bitmap Module") &&
             user_tag(ifd, "make=", T_MAKE, opt, "") &&
             user_tag(ifd, "model=", T_MODEL, opt, "") &&
             user_tag(ifd, "hostcomputer=", T_HOSTCOMPUTER, opt, "") &&
             user_tag(ifd, "documentname=", T_DOCNAME, opt, "") &&
             user_tag(ifd, "pagename=", T_PAGENAME, opt, "") &&
             user_tag(ifd, "imagedescription=", T_DESCRIPTION, opt, "");

        if ( gbm->bpp != 24 )
                {
                int     i, n_cols = (1 << gbm->bpp);

                for ( i = 0; i < n_cols; i++ )
                        {
                        short   r = (short) gbmrgb[i].r;
                        short   g = (short) gbmrgb[i].g;
                        short   b = (short) gbmrgb[i].b;

                        colormap[             i] = ((r << 8) | r);
                        colormap[    n_cols + i] = ((g << 8) | g);
                        colormap[2 * n_cols + i] = ((b << 8) | b);
                        }
                if ( gbm->bpp != 1 || !baseline )
                        ok &= add_short_tag(ifd, T_COLORMAP, colormap, n_cols * 3);
                }

        if ( !ok )
                {
                free_ifh(ifh);
                return GBM_ERR_MEM;
                }

        if ( !write_ifh_and_ifd(ifh, fd) )
                {
                free_ifh(ifh);
                return GBM_ERR_WRITE;
                }

        stripoffset = lseek(fd, 0L, SEEK_CUR);

        if ( lzw )
                rc = write_strip_lzw(fd, gbm->w, gbm->h, gbm->bpp, data);
        else
                rc = write_strip(fd, gbm->w, gbm->h, gbm->bpp, data);

        if ( rc != GBM_ERR_OK )
                {
                free_ifh(ifh);
                return rc;
                }

        stripbytecount = lseek(fd, 0L, SEEK_CUR) - stripoffset;

        update_long_tag(ifd, T_STRIPOFFSETS, &stripoffset);
        update_long_tag(ifd, T_STRIPBYTECOUNTS, &stripbytecount);

        if ( !update_ifd(ifd, fd) )
                {
                free_ifh(ifh);
                return GBM_ERR_WRITE;
                }

        free_ifh(ifh);

        return GBM_ERR_OK;
        }
/*...e*/
/*...stif_err:0:*/
unsigned long tif_err(GBM_ERR rc)
        {
        switch ( (int) rc )
                {
                case GBM_ERR_TIF_VERSION:
                        return IC_GBM_TIF_VERSION;
                case GBM_ERR_TIF_N_TAGS:
                        return IC_GBM_TIF_N_TAGS;
                case GBM_ERR_TIF_TAG_TYPE:
                        return IC_GBM_TIF_TAG_TYPE;
                case GBM_ERR_TIF_HEADER:
                        return IC_GBM_TIF_HEADER;
                case GBM_ERR_TIF_MISSING_TAG:
                        return IC_GBM_TIF_MISSING_TAG;
                case GBM_ERR_TIF_SPP_BIT:
                        return IC_GBM_TIF_SPP_BIT;
                case GBM_ERR_TIF_BPS_BIT:
                        return IC_GBM_TIF_BPS_BIT;
                case GBM_ERR_TIF_SPP_RGB:
                        return IC_GBM_TIF_SPP_RGB;
                case GBM_ERR_TIF_BPS_RGB:
                        return IC_GBM_TIF_BPS_RGB;
                case GBM_ERR_TIF_SPP_PAL:
                        return IC_GBM_TIF_SPP_PAL;
                case GBM_ERR_TIF_BPS_PAL:
                        return IC_GBM_TIF_BPS_PAL;
                case GBM_ERR_TIF_SPP_CMYK:
                        return IC_GBM_TIF_SPP_CMYK;
                case GBM_ERR_TIF_BPS_CMYK:
                        return IC_GBM_TIF_BPS_CMYK;
                case GBM_ERR_TIF_COMP_1D_MH:
                        return IC_GBM_TIF_COMP_1D_MH;
                case GBM_ERR_TIF_COMP_T4:
                        return IC_GBM_TIF_COMP_T4;
                case GBM_ERR_TIF_COMP_T6:
                        return IC_GBM_TIF_COMP_T6;
                case GBM_ERR_TIF_COMP:
                        return IC_GBM_TIF_COMP;
                case GBM_ERR_TIF_COLORMAP:
                        return IC_GBM_TIF_COLORMAP;
                case GBM_ERR_TIF_CORRUPT:
                        return IC_GBM_TIF_CORRUPT;
                case GBM_ERR_TIF_PREDICTOR:
                        return IC_GBM_TIF_PREDICTOR;
                case GBM_ERR_TIF_PHOTO_TRANS:
                        return IC_GBM_TIF_PHOTO_TRANS;
                case GBM_ERR_TIF_PHOTO_Y_Cb_Cr:
                        return IC_GBM_TIF_PHOTO_Y_Cb_Cr;
                case GBM_ERR_TIF_PHOTO:
                        return IC_GBM_TIF_PHOTO;
                case GBM_ERR_TIF_FILLORDER:
                        return IC_GBM_TIF_FILLORDER;
                case GBM_ERR_TIF_PLANARCONFIG_1:
                        return IC_GBM_TIF_PLANARCONFIG_1;
                case GBM_ERR_TIF_PLANARCONFIG_12:
                        return IC_GBM_TIF_PLANARCONFIG_12;
                case GBM_ERR_TIF_INKSET:
                        return IC_GBM_TIF_INKSET;
                case GBM_ERR_TIF_ORIENT:
                        return IC_GBM_TIF_ORIENT;
                case GBM_ERR_TIF_INDEX:
                        return IC_GBM_TIF_INDEX;
                }
        return 0;
        }
/*
*****************************************************************************************
*                                                                                       *
* COPYRIGHT:                                                                            *
*   IBM Open Class Library                                                              *
*   (C) Copyright International Business Machines Corporation,  1997                    *
*   Licensed Material - Program-Property of IBM - All Rights Reserved.                  *
*   US Government Users Restricted Rights - Use, duplication, or disclosure             *
*   restricted by GSA ADP Schedule Contract with IBM Corp.                              *
*                                                                                       *
*****************************************************************************************
*/
// Revision: 56 1.4.1.5 source/ographic/igbm.cpp, graphics, ioc.v400, 001006 
/*

IGBMLBM.C  Amiga IFF / ILBM format

*/

#if 0
#pragma priority( -2147481424 )

/*...sincludes:0:*/
#include <stdio.h>
#include <ctype.h>
#include <stddef.h>
#include <stdlib.h>
#include <string.h>
#include <memory.h>
#include <malloc.h>
#ifdef AIX
#include <unistd.h>
#else
#include <io.h>
#endif
#include <fcntl.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <igbmstnd.hpp>
#include <igbm.hpp>
#include <igbmhelp.hpp>
#include <icconst.h>
#include <ibase.hpp>

// Segment definitions
#ifdef IC_PAGETUNE
  #define _IGBMLBM_CPP_
  #include <ipagetun.h>
#endif
#endif // 0

/*...vgbm\46\h:0:*/
/*...vgbmhelp\46\h:0:*/
/*...e*/

/*...smapping:0:*/
/*...sget_dword:0:*/
static dword get_dword(byte *b)
        {
        return    (dword) b[3]         +
                (((dword) b[2]) <<  8) +
                (((dword) b[1]) << 16) +
                (((dword) b[0]) << 24) ;
        }
/*...e*/
/*...sget_word:0:*/
static word get_word(byte *b)
        {
        return    (word) b[1]        +
                (((word) b[0]) << 8) ;
        }
/*...e*/
/*...sput_dword:0:*/
static void put_dword(byte *b, dword n)
        {
        b[3] = (byte) n;
        n >>= 8;
        b[2] = (byte) n;
        n >>= 8;
        b[1] = (byte) n;
        n >>= 8;
        b[0] = (byte) n;
        }
/*...e*/
/*...sput_word:0:*/
static void put_word(byte *b, word n)
        {
        b[1] = (byte) n;
        n >>= 8;
        b[0] = (byte) n;
        }
/*...e*/
/*...e*/

static GBMFT lbm_gbmft =
        {
        "ILBM",
        "Amiga IFF / ILBM Interleaved bitmap",
        "IFF LBM",
        GBM_FT_R1|GBM_FT_R4|GBM_FT_R8|GBM_FT_R24|
        GBM_FT_W1|GBM_FT_W4|GBM_FT_W8|GBM_FT_W24,
        };

#define GBM_ERR_LBM_FORM        ((GBM_ERR) 900)
#define GBM_ERR_LBM_ILBM        ((GBM_ERR) 901)
#define GBM_ERR_LBM_BMHD_2      ((GBM_ERR) 902)
#define GBM_ERR_LBM_BMHD_0      ((GBM_ERR) 903)
#define GBM_ERR_LBM_BMHD_SIZE   ((GBM_ERR) 904)
#define GBM_ERR_LBM_BPP         ((GBM_ERR) 905)
#define GBM_ERR_LBM_CMAP_SIZE   ((GBM_ERR) 906)
#define GBM_ERR_LBM_COMP        ((GBM_ERR) 907)
#define GBM_ERR_LBM_CAMG_SIZE   ((GBM_ERR) 908)
#define GBM_ERR_LBM_SHAM_VER    ((GBM_ERR) 909)

typedef struct
        {
        byte pal[0x100 * 3];
        dword body, size_body;
        byte actual_bpp, comp;
        long sham;
        } LBM_PRIV;

#define CAMG_LACE       0x00000004
#define CAMG_EHB        0x00000080
#define CAMG_HAM        0x00000800
#define CAMG_1000       0x00001000      /* Meaning unknown */
#define CAMG_4000       0x00004000      /* Meaning unknown */
#define CAMG_HIRES      0x00008000
#define CAMG_20000      0x00020000      /* Meaning unknown */

/*...slbm_qft:0:*/
GBM_ERR lbm_qft(GBMFT *gbmft)
        {
        *gbmft = lbm_gbmft;
        return GBM_ERR_OK;
        }
/*...e*/
/*...slbm_rhdr:0:*/
GBM_ERR lbm_rhdr(char *fn, int fd, GBM *gbm, char *opt)
        {
        LBM_PRIV *priv = (LBM_PRIV *) gbm->priv;
        byte b[20];
        int w, h, bpp, actual_size_cmap;
        bool had_bmhd = false, had_cmap = false, had_body = false;
        dword camg = 0;

        fn=fn; opt=opt; /* Suppress 'unref arg' compiler warnings */

        lseek(fd, 0L, SEEK_SET);
        if ( read(fd, b, 12) != 12 )
                return GBM_ERR_READ;

        if ( memcmp(b, "FORM", 4) )
                return GBM_ERR_LBM_FORM;

        if ( memcmp(b + 8, "ILBM", 4) )
                return GBM_ERR_LBM_ILBM;

        priv->sham = -1L;

        while ( !had_bmhd || !had_cmap || !had_body )
                {
                dword size;

                if ( read(fd, b, 8) != 8 )
                        return GBM_ERR_READ;
                size = get_dword(b + 4);
                if ( !memcmp(b, "BMHD", 4) )
/*...sbitmap header:24:*/
{
if ( had_bmhd )
        return GBM_ERR_LBM_BMHD_2;

if ( size != 20 )
        return GBM_ERR_LBM_BMHD_SIZE;

if ( read(fd, b, 20) != 20 )
        return GBM_ERR_READ;

priv->comp = b[10];
if ( priv->comp != 0 && priv->comp != 1 )
        /* Expect compression type to be uncomp or RLE */
        return GBM_ERR_LBM_COMP;

w = get_word(b);
h = get_word(b + 2);

if ( w < 0 || w > 10000 || h < 0 || h > 10000 )
        return GBM_ERR_BAD_SIZE;

priv->actual_bpp = b[8];

switch ( priv->actual_bpp )
        {
        case 1:
                bpp = 1; break;
        case 2: case 3: case 4:
                bpp = 4; break;
        case 5: case 6: case 7: case 8:
                bpp = 8; break;
        default:
                return GBM_ERR_LBM_BPP;
        }

if ( priv->actual_bpp == 6 )
        /* In case no CAMG chunk present */
        /* Assume HAM6, and will probably be right */
        camg = CAMG_HAM;

had_bmhd = true;
}
/*...e*/
                else if ( !memcmp(b, "CAMG", 4) )
/*...sC\61\ Amiga mode info:24:*/
{
if ( !had_bmhd )
        return GBM_ERR_LBM_BMHD_0;

if ( size != 4 )
        return GBM_ERR_LBM_CAMG_SIZE;

if ( read(fd, b, 4) != 4 )
        return GBM_ERR_READ;

camg = get_dword(b);
}
/*...e*/
                else if ( !memcmp(b, "CMAP", 4) )
/*...scolour map:24:*/
{
if ( !had_bmhd )
        return GBM_ERR_LBM_BMHD_0;
actual_size_cmap = size;
if ( read(fd, priv->pal, size) != size )
        return GBM_ERR_READ;
had_cmap = true;
}
/*...e*/
                else if ( !memcmp(b, "SHAM", 4) )
/*...ssham:24:*/
{
if ( read(fd, b, 2) != 2 )
        return GBM_ERR_READ;

if ( get_word(b) != 0 )
        return GBM_ERR_LBM_SHAM_VER;

priv->sham = lseek(fd, 0L, SEEK_CUR);

lseek(fd, ((size - 2 + 1) & ~1), SEEK_CUR);
}
/*...e*/
                else if ( !memcmp(b, "BODY", 4) )
/*...sbody of data:24:*/
{
if ( !had_bmhd )
        return GBM_ERR_LBM_BMHD_0;

priv->body = (dword) lseek(fd, 0L, SEEK_CUR);
priv->size_body = size;
had_body = true;
}
/*...e*/
                else
                        lseek(fd, ((size + 1) & ~1), SEEK_CUR);
                }

/*...saccount for ehb\44\ ham6 and ham8:8:*/
{
int entrys = ( 1 << priv->actual_bpp );
int size_cmap = entrys * 3;
bool ehb = false, sham = false, ham6 = false, ham8 = false;

if ( priv->sham != -1L )
        sham = true; /* Allow Sliced HAM mode */
if ( (camg & CAMG_EHB) != 0 && actual_size_cmap * 2 == size_cmap )
        ehb = true; /* Allow Extra-HalfBrite mode */
else if ( (camg & CAMG_HAM) != 0 && actual_size_cmap == 0x10*3 && size_cmap == 0x40*3 )
        ham6 = true; /* Allow HAM6 mode */
else if ( (camg & CAMG_HAM) != 0 && actual_size_cmap == 0x40*3 && size_cmap == 0x100*3 )
        ham8 = true; /* Allow HAM8 mode */
else if ( actual_size_cmap != size_cmap )
        return GBM_ERR_LBM_CMAP_SIZE;
if ( ehb )
/*...sreplicate palette:16:*/
{
int i;
for ( i = 0; i < actual_size_cmap; i++ )
        priv->pal[actual_size_cmap + i] = (priv->pal[i] >> 1);
}
/*...e*/
else if ( ham6 )
/*...snobble all but top 4 bits of palette entries:16:*/
{
int i;
for ( i = 0; i < 0x10 * 3; i++ )
        priv->pal[i] &= 0xf0;
bpp = 24;
}
/*...e*/
else if ( ham8 || sham )
        bpp = 24;
}
/*...e*/

        gbm->w   = w;
        gbm->h   = h;
        gbm->bpp = bpp;

        return GBM_ERR_OK;
        }
/*...e*/
/*...slbm_rpal:0:*/
GBM_ERR lbm_rpal(int fd, GBM *gbm, GBMRGB *gbmrgb)
        {
        LBM_PRIV *priv = (LBM_PRIV *) gbm->priv;
        byte *p = priv->pal;
        int i, entrys = ( 1 << priv->actual_bpp );

        fd=fd; /* Suppress 'unref arg' compiler warning */

        if ( gbm->bpp == 24 )
                return GBM_ERR_OK;

        for ( i = 0; i < entrys; i++ )
                {
                gbmrgb[i].r = *p++;
                gbmrgb[i].g = *p++;
                gbmrgb[i].b = *p++;
                }

        return GBM_ERR_OK;
        }
/*...e*/
/*...slbm_rdata:0:*/
/*...sget_line:0:*/
/*...sread_line   \45\ compression type 0 \45\ uncompressed:0:*/
static bool read_line(AHEAD *ahead, byte *dest, int w)
        {
        while ( w-- )
                {
                int b = gbm_read_ahead(ahead);
                if ( b == -1 )
                        return false;
                *dest++ = b;
                }
        return true;
        }
/*...e*/
/*...sdecode_line \45\ compression type 1 \45\ RLE:0:*/
static bool decode_line(AHEAD *ahead, byte *dest, int w)
        {
        int x = 0;

        while ( x < w )
                {
                int c = gbm_read_ahead(ahead);

                if ( c == -1 )
                        return false;

                if ( c & 0x80 )
                        {
                        int cnt = (0x100 - c + 1);

                        memset(dest, (byte) gbm_read_ahead(ahead), cnt);
                        x += cnt;
                        dest += cnt;
                        }
                else
                        {
                        int cnt = (c + 1);

                        x += cnt;
                        while ( cnt-- )
                                {
                                int b = gbm_read_ahead(ahead);
                                if ( b == -1 )
                                        return false;
                                *dest++ = (byte) b;
                                }
                        }
                }
        return true;
        }
/*...e*/

static bool get_line(LBM_PRIV *priv, AHEAD *ahead, byte *dest, int w)
        {
        switch ( priv->comp )
                {
                case 0:
                        return read_line(ahead, dest, w);
                case 1:
                        return decode_line(ahead, dest, w);
                }
        return false; /* Shouldn't get here */
        }
/*...e*/
/*...sget_planes_8:0:*/
static bool get_planes_8(
        AHEAD *ahead,
        LBM_PRIV *priv,
        byte *buf,
        byte *data,
        int w,
        int n_planes
        )
        {
        int plane, p;
        int scan = ((((w + 7) >> 3)+1)/2)*2;

        memset(data, 0, w);
        for ( plane = 0, p = 0x01; plane < n_planes; plane++, p <<= 1 )
                {
                int i;

                if ( !get_line(priv, ahead, buf, scan) )
                        return false;
                for ( i = 0; i < w; i++ )
                        if ( buf[i >> 3] & (0x80 >> (i & 7)) )
                                data[i] |= p;
                }
        return true;
        }
/*...e*/

GBM_ERR lbm_rdata(int fd, GBM *gbm, byte *data)
        {
        LBM_PRIV *priv = (LBM_PRIV *) gbm->priv;
        AHEAD *ahead;
        int stride = ((gbm->w * gbm->bpp + 31) / 32) * 4;
        int scan = ((((gbm->w + 7) >> 3)+1)/2)*2;
        lseek(fd, priv->body, SEEK_SET);

        if ( (ahead = gbm_create_ahead(fd)) == NULL )
                return GBM_ERR_MEM;

        data += ((gbm->h - 1) * stride);

        switch ( gbm->bpp )
                {
/*...s24:16:*/
/*
Hold and modify.
Or even sliced hold and modify.
*/

case 24:
        {
        byte *buf, *ham, *sham_pals;
        int y, n_sham_pals, sham_inx = 0;

        if ( (buf = (byte*)malloc(scan)) == NULL )  // mjs
                {
                gbm_destroy_ahead(ahead);
                return GBM_ERR_MEM;
                }

        if ( (ham = (byte*)malloc(gbm->w)) == NULL )
                {
                free(buf);
                gbm_destroy_ahead(ahead);
                return GBM_ERR_MEM;
                }

        if ( priv->sham != -1L )
/*...sread SHAM palettes:32:*/
/* SHAM holds 200 lines of 16 words each with a 0rgb palette entry */
/* If <= 200 lines then one line per palette */
/* Else two lines per palette */

{
n_sham_pals = ( gbm->h < 200 ) ? gbm->h : 200;
if ( (sham_pals = (byte*)malloc(n_sham_pals * 16 * 2)) == NULL )
        {
        free(ham);
        free(buf);
        gbm_destroy_ahead(ahead);
        return GBM_ERR_MEM;
        }

lseek(fd, priv->sham, SEEK_SET);
if ( read(fd, sham_pals, n_sham_pals * 16 * 2) != n_sham_pals * 16 * 2 )
        {
        free(sham_pals);
        free(ham);
        free(buf);
        gbm_destroy_ahead(ahead);
        return GBM_ERR_READ;
        }
lseek(fd, priv->body, SEEK_SET);
}
/*...e*/

        for ( y = 0; y < gbm->h; y++, data -= stride )
                {
                if ( !get_planes_8(ahead, priv, buf, ham, gbm->w, priv->actual_bpp) )
                        {
                        if ( priv->sham != -1L )
                                free(sham_pals);
                        free(buf);
                        free(ham);
                        gbm_destroy_ahead(ahead);
                        return GBM_ERR_READ;
                        }

                if ( priv->sham != -1L )
/*...sconvert from SHAM6 to 24 bit rgb:40:*/
{
byte r = 0, g = 0, b = 0;
int i;
for ( i = 0; i < gbm->w; i++ )
        {
        byte val = (ham[i] & 0x0f);
        switch ( ham[i] & 0x30 )
                {
                case 0x00:
                        {
                        word pal = get_word(sham_pals + ((sham_inx * 16 + val) * 2));
                        r = (byte) ((pal & 0x0f00) >> 4);
                        g = (byte)  (pal & 0x00f0)      ;
                        b = (byte) ((pal & 0x000f) << 4);
                        }
                        break;
                case 0x10:
                        b = (val << 4);
                        break;
                case 0x20:
                        r = (val << 4);
                        break;
                case 0x30:
                        g = (val << 4);
                        break;
                }
        data[i * 3    ] = b;
        data[i * 3 + 1] = g;
        data[i * 3 + 2] = r;
        }
if ( gbm->h <= 200 || (y & 1) != 0 )
        if ( ++sham_inx == n_sham_pals )
                sham_inx = 0;
}
/*...e*/
                else if ( priv->actual_bpp == 6 )
/*...sconvert from HAM6 to 24 bit rgb:40:*/
{
byte r = 0, g = 0, b = 0;
int i;
for ( i = 0; i < gbm->w; i++ )
        {
        byte val = (ham[i] & 0x0f);
        switch ( ham[i] & 0x30 )
                {
                case 0x00:
                        r = priv->pal[val * 3    ];
                        g = priv->pal[val * 3 + 1];
                        b = priv->pal[val * 3 + 2];
                        break;
                case 0x10:
                        b = (val << 4);
                        break;
                case 0x20:
                        r = (val << 4);
                        break;
                case 0x30:
                        g = (val << 4);
                        break;
                }
        data[i * 3    ] = b;
        data[i * 3 + 1] = g;
        data[i * 3 + 2] = r;
        }
}
/*...e*/
                else
/*...sconvert from HAM8 to 24 bit rgb:40:*/
{
byte r = 0, g = 0, b = 0;
int i;
for ( i = 0; i < gbm->w; i++ )
        {
        byte val = (ham[i] & 0x3f);
        switch ( ham[i] & 0xc0 )
                {
                case 0x00:
                        r = priv->pal[val * 3    ];
                        g = priv->pal[val * 3 + 1];
                        b = priv->pal[val * 3 + 2];
                        break;
                case 0x40:
                        b = ((r & 0x03) | (val << 2));
                        break;
                case 0x80:
                        r = ((b & 0x03) | (val << 2));
                        break;
                case 0xc0:
                        g = ((g & 0x03) | (val << 2));
                        break;
                }
        data[i * 3    ] = b;
        data[i * 3 + 1] = g;
        data[i * 3 + 2] = r;
        }
}
/*...e*/
                }

        if ( priv->sham != -1L )
                free(sham_pals);
        free(ham);
        free(buf);
        }
        break;
/*...e*/
/*...s8:16:*/
case 8:
        {
        byte *buf;
        int y;

        if ( (buf = (byte*)malloc(scan)) == NULL )  // mjs
                {
                gbm_destroy_ahead(ahead);
                return GBM_ERR_MEM;
                }

        for ( y = 0; y < gbm->h; y++, data -= stride )
                if ( !get_planes_8(ahead, priv, buf, data, gbm->w, priv->actual_bpp) )
                        {
                        free(buf);
                        gbm_destroy_ahead(ahead);
                        return GBM_ERR_READ;
                        }

        free(buf);
        }
        break;
/*...e*/
/*...s4:16:*/
case 4:
        {
        byte *buf;
        int y;

        if ( (buf = (byte*)malloc(scan)) == NULL )
                {
                gbm_destroy_ahead(ahead);
                return GBM_ERR_MEM;
                }

        for ( y = 0; y < gbm->h; y++, data -= stride )
                {
                int plane, p;

                memset(data, 0, stride);
                for ( plane = 0, p = 0x11; plane < priv->actual_bpp; plane++,p <<= 1 )
                        {
                        int i, mask;

                        if ( !get_line(priv, ahead, buf, scan) )
                                {
                                free(buf);
                                gbm_destroy_ahead(ahead);
                                return GBM_ERR_READ;
                                }
                        for ( i = 0, mask = 0xf0; i < gbm->w; i++, mask ^= 0xff )
                                if ( buf[i >> 3] & (0x80 >> (i & 7)) )
                                        data[i >> 1] |= (p & mask);
                        }
                }

        free(buf);
        }
        break;
/*...e*/
/*...s1:16:*/
case 1:
        {
        int y;

        for ( y = 0; y < gbm->h; y++, data -= stride )
                if ( !get_line(priv, ahead, data, scan) )
                        {
                        gbm_destroy_ahead(ahead);
                        return GBM_ERR_READ;
                        }
        }
        break;
/*...e*/
                }

        gbm_destroy_ahead(ahead);

        return GBM_ERR_OK;
        }
/*...e*/
/*...slbm_w:0:*/
/*...swrite_bmhd:0:*/
static GBM_ERR write_bmhd(int fd, GBM *gbm, int bpp, char *opt)
        {
        byte bmhd[8+20];
        int xpos = 0, ypos = 0, transcol = 0, xaspect = 1, yaspect = 1;
        int xscreen = gbm->w, yscreen = gbm->h;

/*...soutput options:8:*/
{
char *s;

if ( (s = gbm_find_word_prefix(opt, "xpos=")) != NULL )
        sscanf(s + 5, "%d", &xpos);

if ( (s = gbm_find_word_prefix(opt, "ypos=")) != NULL )
        sscanf(s + 5, "%d", &ypos);

if ( (s = gbm_find_word_prefix(opt, "transcol=")) != NULL )
        sscanf(s + 9, "%d", &transcol);

if ( (s = gbm_find_word_prefix(opt, "xaspect=")) != NULL )
        sscanf(s + 8, "%d", &xaspect);

if ( (s = gbm_find_word_prefix(opt, "yaspect=")) != NULL )
        sscanf(s + 8, "%d", &yaspect);

if ( (s = gbm_find_word_prefix(opt, "xscreen=")) != NULL )
        sscanf(s + 8, "%d", &xscreen);

if ( (s = gbm_find_word_prefix(opt, "yscreen=")) != NULL )
        sscanf(s + 8, "%d", &yscreen);
}
/*...e*/

        memcpy(bmhd, "BMHD", 4);
        put_dword(bmhd+4, (dword) 20);
        put_word(bmhd+8, gbm->w);
        put_word(bmhd+8+2, gbm->h);
        put_word(bmhd+8+4, xpos);
        put_word(bmhd+8+6, ypos);
        bmhd[8+8] = (byte) bpp;

        bmhd[8+9] = 0;                  /* Masking 0=None, 1=Mask, 2=Transparent, 3=Lasso */
        bmhd[8+10] = 1;         /* Compression, 0=None, 1=RLE */
        bmhd[8+11] = 0;         /* Unused */
        put_word(bmhd+8+12, (word) transcol); /* Transparent colour */
        bmhd[8+14] = (byte) xaspect;    /* X Aspect (often 10) */
        bmhd[8+15] = (byte) yaspect;    /* Y Aspect (often 11) */

        put_word(bmhd+8+16, xscreen);   /* Screen width */
        put_word(bmhd+8+18, yscreen);   /* Screen height */

        if ( write(fd, bmhd, 8+20) != 8+20 )
                return GBM_ERR_WRITE;

        return GBM_ERR_OK;
        }
/*...e*/
/*...swrite_camg:0:*/
static GBM_ERR write_camg(int fd, dword camg_value)
        {
        byte camg[8+4];

        memcpy(camg, "CAMG", 4);
        put_dword(camg+4, (dword) 4);
        put_dword(camg+8, camg_value);

        if ( write(fd, camg, 8+4) != 8+4 )
                return GBM_ERR_WRITE;

        return GBM_ERR_OK;
        }
/*...e*/
/*...swrite_cmap:0:*/
static GBM_ERR write_cmap(int fd, GBMRGB *gbmrgb, int bpp)
        {
        byte cmap[8+0x100*3];
        int i, entrys = ( 1 << bpp );
        int size_cmap = 3 * entrys;

        memcpy(cmap, "CMAP", 4);
        put_dword(cmap+4, (dword) size_cmap);
        for ( i = 0; i < entrys; i++ )
                {
                cmap[8+i*3+0] = gbmrgb[i].r;
                cmap[8+i*3+1] = gbmrgb[i].g;
                cmap[8+i*3+2] = gbmrgb[i].b;
                }

        if ( write(fd, cmap, 8 + size_cmap) != 8 + size_cmap )
                return GBM_ERR_WRITE;

        return GBM_ERR_OK;
        }
/*...e*/
/*...swrite_body:0:*/
/*...slbm_rle:0:*/
/*...slbm_run:0:*/
static byte lbm_run(byte *src, int n_src)
        {
        byte cnt = 1;
        byte b = *src++;

        --n_src;
        while ( cnt < 0x81 && n_src > 0 && *src == b )
                { cnt++; n_src--; src++; }

        return cnt;
        }
/*...e*/
/*...slbm_lit:0:*/
static byte lbm_lit(byte *src, int n_src)
        {
        byte cnt = 1;

        ++src; --n_src;
        while ( cnt < 0x80 && n_src > 0 && *src != src[-1] )
                { cnt++; n_src--; src++; }

        return cnt;
        }
/*...e*/

static void lbm_rle(byte *src, int n_src, byte *dst, int *n_dst)
        {
        *n_dst = 0;
        while ( n_src )
                {
                byte    len;

                if ( (len = lbm_run(src, n_src)) > 1 )
                        {
                        *dst++ = (byte) (0x100 - (len - 1));
                        *dst++ = *src;
                        (*n_dst) += 2;
                        }
                else
                        {
                        len = lbm_lit(src, n_src);
                        *dst++ = (byte) (len - 1);
                        memcpy(dst, src, len);
                        dst += len;
                        (*n_dst) += ( 1 + len );
                        }
                src += len;
                n_src -= len;
                }
        }
/*...e*/

static GBM_ERR write_body(int fd, GBM *gbm, int bpp, int n_planes, byte *data, long *end)
        {
        int scan = ((((gbm->w + 7) / 8)+1)/2)*2;
        int stride = ((gbm->w * bpp + 31) / 32) * 4;
        byte *comp;
        int n_comp;
        byte body[8];
        long offset_body, offset_end;

        memcpy(body, "BODY", 4);
        /* body[4..7] will be filled in later */

        if ( write(fd, body, 8) != 8 )
                return GBM_ERR_WRITE;

        offset_body = lseek(fd, 0L, SEEK_CUR);

        data += ( gbm->h - 1 ) * stride;

        if ( (comp = (byte*)malloc(scan * 3)) == NULL )
                return GBM_ERR_MEM;

        switch ( bpp )
                {
/*...s8:16:*/
case 8:
        {
        int     y;
        byte    *buf;

        if ( (buf = (byte*)malloc(scan)) == NULL )
                {
                free(comp);
                return GBM_ERR_MEM;
                }

        for ( y = 0; y < gbm->h; y++, data -= stride )
                {
                int p, plane;

                for ( plane = 0, p = 0x01; plane < n_planes; plane++, p <<= 1 )
                        {
                        int j;

                        memset(buf, 0, scan);
                        for ( j = 0; j < gbm->w; j++ )
                                if ( data[j] & p )
                                        buf[j >> 3] |= (0x80 >> (j & 7));
                        lbm_rle(buf, scan, comp, &n_comp);
                        if ( write(fd, comp, n_comp) != n_comp )
                                {
                                free(buf);
                                free(comp);
                                return GBM_ERR_WRITE;
                                }
                        }
                }
        free(buf);
        }
        break;
/*...e*/
/*...s4:16:*/
case 4:
        {
        int     y;
        byte    *buf;

        if ( (buf = (byte*)malloc(scan)) == NULL )
                {
                free(comp);
                return GBM_ERR_MEM;
                }

        for ( y = 0; y < gbm->h; y++, data -= stride )
                {
                int     p;

                for ( p = 0x11; p <= 0x88; p <<= 1 )
                        {
                        int     j, mask;

                        memset(buf, 0, scan);
                        for ( j = 0, mask = 0xf0; j < gbm->w; j++, mask ^= 0xff )
                                if ( data[j >> 1] & (p & mask) )
                                        buf[j >> 3] |= (0x80 >> (j & 7));
                        lbm_rle(buf, scan, comp, &n_comp);
                        if ( write(fd, comp, n_comp) != n_comp )
                                {
                                free(buf);
                                free(comp);
                                return GBM_ERR_WRITE;
                                }
                        }
                }
        free(buf);
        }
        break;
/*...e*/
/*...s1:16:*/
case 1:
        {
        int     y;

        for ( y = 0; y < gbm->h; y++, data -= stride )
                {
                lbm_rle(data, scan, comp, &n_comp);
                if ( write(fd, comp, n_comp) != n_comp )
                        {
                        free(comp);
                        return GBM_ERR_WRITE;
                        }
                }
        }
        break;
/*...e*/
                }

        free(comp);

        offset_end = lseek(fd, 0L, SEEK_CUR);

        if ( (offset_end - offset_body) & 1 )
                /* BODY is an odd # of bytes long! oops, better 'fix' this */
                {
                byte b = 0; /* Pad byte must be zero */
                if ( write(fd, &b, 1) != 1 )
                        return GBM_ERR_WRITE;
                offset_end++;
                }

        put_dword(body + 4, offset_end - offset_body);
        lseek(fd, offset_body - 4L, SEEK_SET);
        if ( write(fd, body + 4, 4) != 4 )
                return GBM_ERR_WRITE;

        *end = offset_end;

        return GBM_ERR_OK;
        }
/*...e*/

static byte posdiff[0x100];
#define absdiff(a,b) posdiff[(byte)((a)-(b))]
/*...slbm_build_abstab:0:*/
static void lbm_build_abstab(void)
        {
        int i;

        for ( i = 0; i < 0x80; i++ )
                posdiff[i] = (byte) i;
        for ( i = 1; i <= 0x80; i++ )
                posdiff[0x100 - i] = (byte) i;
        }
/*...e*/
/*...slbm_ham6:0:*/
/*
We will assume a simple greyscale palette, to make life easy.
Palette entries 0 to 15 will be 00, 11, 22, 33, ... ff.
Start the line with a close grey.
Try to get as many components right first time.
Then for each pixel, pick colours to get as many components right each go.
*/

static void lbm_ham6(byte *data, byte *ham, int n)
        {
        if ( n-- > 0 )
                {
                byte cb = (*data++ >> 4);
                byte cg = (*data++ >> 4);
                byte cr = (*data++ >> 4);

                switch ( (cr==cg?4:0) + (cg==cb?2:0) + (cb==cr?1:0) )
                        {
/*...s0 \45\ none same:24:*/
case 0:
        *ham++ = cr = cg = cb = ( cr + cg + cb ) / 3;
        break;
/*...e*/
/*...s1 \45\ r\61\b:24:*/
case 1:
        *ham++ = cg = cr;
        break;
/*...e*/
/*...s2 \45\ g\61\b:24:*/
case 2:
        *ham++ = cr = cg;
        break;
/*...e*/
/*...s4 \45\ r\61\g:24:*/
case 4:
        *ham++ = cb = cr;
        break;
/*...e*/
/*...s7 \45\ r\61\g\61\b:24:*/
case 7:
        *ham++ = cr;
        break;
/*...e*/
                        }

                while ( n-- > 0 )
                        {
                        byte b = (*data++ >> 4);
                        byte g = (*data++ >> 4);
                        byte r = (*data++ >> 4);

                        switch ( ((cr==r)?4:0) + ((cg==g)?2:0) + ((cb==b)?1:0) )
                                {
/*...s0 \45\ none same:32:*/
/*
3 colour components need modifying.
Can take upto 3 pixels to get the desired colour.
Picking a grey might fix up 2 or more colour components.
Pick r,g or b modify to get as close as possible.
*/

case 0:
        if ( ((r==g)?1:0) + ((g==b)?1:0) + ((b==r)?1:0) > 0 )
                { *ham++ = cr = cg = cb = ( (r==g) ? r : b ); }
        else if ( absdiff(cr,r) >= absdiff(cg,g) && absdiff(cr,r) >= absdiff(cb,b) )
                { *ham++ = (0x20 | r); cr = r; }
        else if ( absdiff(cg,g) >= absdiff(cr,r) && absdiff(cg,g) >= absdiff(cb,b) )
                { *ham++ = (0x30 | g); cg = g; }
        else
                { *ham++ = (0x10 | b); cb = b; }
        break;
/*...e*/
/*...s1 \45\ b same:32:*/
/*
2 colour components need modifying.
Can take upto 2 pixels to get the desired colour.
Picking a grey might fix up both colour components.
Pick r or g modify to get as close as possible.
After this, we expect to have <= 1 colour components in error.
*/

case 1:
        if ( r == g && g == b )
                { *ham++ = cr = cg = b; }
        else if ( absdiff(cr,r) >= absdiff(cg,g) )
                { *ham++ = (0x20 | r); cr = r; }
        else
                { *ham++ = (0x30 | g); cg = g; }
        break;
/*...e*/
/*...s2 \45\ g same:32:*/
/*
2 colour components need modifying.
Can take upto 2 pixels to get the desired colour.
Picking a grey might fix up both colour components.
Pick r or b modify to get as close as possible.
After this, we expect to have <= 1 colour components in error.
*/

case 2:
        if ( r == g && g == b )
                { *ham++ = cr = cb = g; }
        else if ( absdiff(cr,r) >= absdiff(cb,b) )
                { *ham++ = (0x20 | r); cr = r; }
        else
                { *ham++ = (0x10 | b); cb = b; }
        break;
/*...e*/
/*...s3 \45\ g\44\b same:32:*/
case 3:
        *ham++ = (0x20 | r); cr = r;
        break;
/*...e*/
/*...s4 \45\ r same:32:*/
/*
2 colour components need modifying.
Can take upto 2 pixels to get the desired colour.
Picking a grey might fix up both colour components.
Pick g or b modify to get as close as possible.
After this, we expect to have <= 1 colour components in error.
*/

case 4:
        if ( r == g && g == b )
                { *ham++ = cg = cb = r; }
        else if ( absdiff(cg,g) >= absdiff(cb,b) )
                { *ham++ = (0x30 | g); cg = g; }
        else
                { *ham++ = (0x10 | b); cb = b; }
        break;
/*...e*/
/*...s5 \45\ r\44\b same:32:*/
case 5:
        *ham++ = (0x30 | g); cg = g;
        break;
/*...e*/
/*...s6 \45\ r\44\g same:32:*/
case 6:
        *ham++ = (0x10 | b); cb = b;
        break;
/*...e*/
/*...s7 \45\ r\44\g\44\b same:32:*/
case 7:
        *ham++ = (0x10 | b);
        break;
/*...e*/
                                }
                        }
                }
        }
/*...e*/

GBM_ERR lbm_w(char *fn, int fd, GBM *gbm, GBMRGB *gbmrgb, byte *data, char *opt)
        {
        byte formilbm[8+4];
        long end;
        GBM_ERR rc;

        fn=fn; /* Suppress 'unref args' compiler warning */

        memcpy(formilbm, "FORM", 4);
        /* formilbm[4..7] will be filled in later */
        memcpy(formilbm+8, "ILBM", 4);
        if ( write(fd, formilbm, 8+4) != 8+4 )
                return GBM_ERR_WRITE;

        if ( gbm->bpp == 24 )
/*...smap to ham6 write bmhd\44\ camg\44\ cmap and body:16:*/
{
byte *ham;
GBMRGB gbmrgb_grey[0x10];
int stride8 = ((gbm->w + 3) & ~3);
int stride24 = ((gbm->w * 3 + 3) & ~3);
int i;

if ( (rc = write_bmhd(fd, gbm, 6, opt)) != GBM_ERR_OK )
        return rc;

if ( (rc = write_camg(fd, CAMG_HAM)) != GBM_ERR_OK )
        return rc;

for ( i = 0; i <= 0x10; i++ )
        gbmrgb_grey[i].r = gbmrgb_grey[i].g = gbmrgb_grey[i].b = (byte) (i * 0x11);

if ( (rc = write_cmap(fd, gbmrgb_grey, 4)) != GBM_ERR_OK )
        return rc;

if ( (ham = (byte*)malloc(stride8 * gbm->h)) == NULL )  // mjs
        return GBM_ERR_MEM;

lbm_build_abstab();
for ( i = 0; i < gbm->h; i++ )
        lbm_ham6(data + i * stride24, ham + i * stride8, gbm->w);

if ( (rc = write_body(fd, gbm, 8, 6, ham, &end)) != GBM_ERR_OK )
        {
        free(ham);
        return rc;
        }

free(ham);
}
/*...e*/
        else
/*...swrite bmhd\44\ cmap and body:16:*/
{
if ( (rc = write_bmhd(fd, gbm, gbm->bpp, opt)) != GBM_ERR_OK )
        return rc;

if ( (rc = write_cmap(fd, gbmrgb, gbm->bpp)) != GBM_ERR_OK )
        return rc;

if ( (rc = write_body(fd, gbm, gbm->bpp, gbm->bpp, data, &end)) != GBM_ERR_OK )
        return rc;
}
/*...e*/

        put_dword(formilbm + 4, end - 8L);
        lseek(fd, 4L, SEEK_SET);
        if ( write(fd, formilbm + 4, 4) != 4 )
                return GBM_ERR_WRITE;

        return GBM_ERR_OK;
        }
/*...e*/
/*...slbm_err:0:*/
unsigned long lbm_err(GBM_ERR rc)
        {
        switch ( (int) rc )
                {
                case GBM_ERR_LBM_FORM:
                        return IC_GBM_LBM_FORM;
                case GBM_ERR_LBM_ILBM:
                        return IC_GBM_LBM_ILBM;
                case GBM_ERR_LBM_BMHD_2:
                        return IC_GBM_LBM_BMHD_2;
                case GBM_ERR_LBM_BMHD_0:
                        return IC_GBM_LBM_BMHD_0;
                case GBM_ERR_LBM_BMHD_SIZE:
                        return IC_GBM_LBM_BMHD_SIZE;
                case GBM_ERR_LBM_BPP:
                        return IC_GBM_LBM_BPP;
                case GBM_ERR_LBM_CMAP_SIZE:
                        return IC_GBM_LBM_CMAP_SIZE;
                case GBM_ERR_LBM_COMP:
                        return IC_GBM_LBM_COMP;
                case GBM_ERR_LBM_CAMG_SIZE:
                        return IC_GBM_LBM_CAMG_SIZE;
                case GBM_ERR_LBM_SHAM_VER:
                        return IC_GBM_LBM_SHAM_VER;
                }
        return 0;
        }
/*
*****************************************************************************************
*                                                                                       *
* COPYRIGHT:                                                                            *
*   IBM Open Class Library                                                              *
*   (C) Copyright International Business Machines Corporation,  1997                    *
*   Licensed Material - Program-Property of IBM - All Rights Reserved.                  *
*   US Government Users Restricted Rights - Use, duplication, or disclosure             *
*   restricted by GSA ADP Schedule Contract with IBM Corp.                              *
*                                                                                       *
*****************************************************************************************
*/
// Revision: 56 1.4.1.5 source/ographic/igbm.cpp, graphics, ioc.v400, 001006 
/*

IGBMVID.C  YUV12C M-Motion Video Frame Buffer format

Reads and writes 24 bit RGB.

*/

#if 0
#pragma priority( -2147481424 )

/*...sincludes:0:*/
#include <stdio.h>
#include <ctype.h>
#include <stddef.h>
#include <stdlib.h>
#include <string.h>
#include <memory.h>
#include <malloc.h>
#ifdef AIX
#include <unistd.h>
#else
#include <io.h>
#endif
#include <fcntl.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <igbmstnd.hpp>
#include <igbm.hpp>
#include <igbmhelp.hpp>
#include <icconst.h>

// Segment definitions
#ifdef IC_PAGETUNE
  #define _IGBMVID_CPP_
  #include <ipagetun.h>
#endif
#endif // 0

/*...vgbm\46\h:0:*/
/*...vgbmhelp\46\h:0:*/
/*...e*/

/*...suseful:0:*/
#define low_byte(w)     ((byte)  ((w)&0x00ff)    )
#define high_byte(w)    ((byte) (((w)&0xff00)>>8))
#define make_word(a,b)  (((word)a) + (((word)b) << 8))
/*...e*/

static GBMFT vid_gbmft =
        {
        "YUV12C",
        "YUV12C M-Motion Video Frame Buffer",
        "VID",
        GBM_FT_R24|GBM_FT_W24,
        };

#define GBM_ERR_VID_BAD_W       ((GBM_ERR) 1000)

/*...svid_qft:0:*/
GBM_ERR vid_qft(GBMFT *gbmft)
        {
        *gbmft = vid_gbmft;
        return GBM_ERR_OK;
        }
/*...e*/
/*...svid_rhdr:0:*/
GBM_ERR vid_rhdr(char *fn, int fd, GBM *gbm, char *opt)
        {
        int w, h;
        byte buf[16];

        fn=fn; opt=opt; /* Suppress 'unref arg' compiler warnings */

        if ( read(fd, buf, 16) != 16 )
                return GBM_ERR_READ;

        if ( memcmp(buf, "YUV12C", 6) )
                return GBM_ERR_BAD_MAGIC;

        w = make_word(buf[12], buf[13]);
        h = make_word(buf[14], buf[15]);

        if ( w & 3 )
                return GBM_ERR_VID_BAD_W;

        if ( w <= 0 || h <= 0 )
                return GBM_ERR_BAD_SIZE;

        gbm->w   = w;
        gbm->h   = h;
        gbm->bpp = 24;

        return GBM_ERR_OK;
        }
/*...e*/
/*...svid_rpal:0:*/
GBM_ERR vid_rpal(int fd, GBM *gbm, GBMRGB *gbmrgb)
        {
        fd=fd; gbm=gbm; gbmrgb=gbmrgb; /* Suppress 'unref arg' compiler warnings */

        return GBM_ERR_OK;
        }
/*...e*/
/*...svid_rdata:0:*/
/*...sdata tables:0:*/
static short tab1[] =
        {
        0,2,5,8,11,14,17,20,
        22,25,28,31,34,37,40,42,
        45,48,51,54,57,60,62,65,
        68,71,74,77,80,82,85,88,
        91,94,97,100,102,105,108,111,
        114,117,120,122,125,128,131,134,
        137,140,142,145,148,151,154,157,
        160,163,165,168,171,174,177,180,
        -183,-180,-177,-174,-171,-168,-165,-163,
        -160,-157,-154,-151,-148,-145,-142,-140,
        -137,-134,-131,-128,-125,-122,-120,-117,
        -114,-111,-108,-105,-102,-100,-97,-94,
        -91,-88,-85,-82,-80,-77,-74,-71,
        -68,-65,-62,-60,-57,-54,-51,-48,
        -45,-42,-40,-37,-34,-31,-28,-25,
        -22,-20,-17,-14,-11,-8,-5,-2,
        };

static short tab2[] =
        {
        0,0,-1,-1,-2,-2,-3,-3,
        -4,-4,-5,-5,-6,-7,-7,-8,
        -8,-9,-9,-10,-10,-11,-11,-12,
        -13,-13,-14,-14,-15,-15,-16,-16,
        -17,-17,-18,-19,-19,-20,-20,-21,
        -21,-22,-22,-23,-23,-24,-24,-25,
        -26,-26,-27,-27,-28,-28,-29,-29,
        -30,-30,-31,-32,-32,-33,-33,-34,
        34,34,33,33,32,32,31,30,
        30,29,29,28,28,27,27,26,
        26,25,24,24,23,23,22,22,
        21,21,20,20,19,19,18,17,
        17,16,16,15,15,14,14,13,
        13,12,11,11,10,10,9,9,
        8,8,7,7,6,5,5,4,
        4,3,3,2,2,1,1,0,
        };

static short tab3[] =
        {
        0,-1,-2,-3,-4,-5,-6,-8,
        -9,-10,-11,-12,-13,-14,-16,-17,
        -18,-19,-20,-21,-23,-24,-25,-26,
        -27,-28,-29,-31,-32,-33,-34,-35,
        -36,-37,-39,-40,-41,-42,-43,-44,
        -46,-47,-48,-49,-50,-51,-52,-54,
        -55,-56,-57,-58,-59,-60,-62,-63,
        -64,-65,-66,-67,-69,-70,-71,-72,
        73,72,71,70,69,67,66,65,
        64,63,62,60,59,58,57,56,
        55,54,52,51,50,49,48,47,
        46,44,43,42,41,40,39,37,
        36,35,34,33,32,31,29,28,
        27,26,25,24,23,21,20,19,
        18,17,16,14,13,12,11,10,
        9,8,6,5,4,3,2,1,
        };

static short tab4[] =
        {
        0,2,4,6,9,11,13,15,
        18,20,22,24,27,29,31,33,
        36,38,40,42,45,47,49,51,
        54,56,58,60,63,65,67,69,
        72,74,76,78,81,83,85,87,
        90,92,94,96,99,101,103,105,
        108,110,112,115,117,119,121,124,
        126,128,130,133,135,137,139,142,
        -144,-142,-139,-137,-135,-133,-130,-128,
        -126,-124,-121,-119,-117,-115,-112,-110,
        -108,-105,-103,-101,-99,-96,-94,-92,
        -90,-87,-85,-83,-81,-78,-76,-74,
        -72,-69,-67,-65,-63,-60,-58,-56,
        -54,-51,-49,-47,-45,-42,-40,-38,
        -36,-33,-31,-29,-27,-24,-22,-20,
        -18,-15,-13,-11,-9,-6,-4,-2,
        };

#ifdef NEVER
static void make_tables(void)
        {
        int     i;
        signed char j;

        for ( i = 0, j = 0; i < 0x80; i++, j += 2 )
                {
#ifdef NEVER
                /* Version 1 */
                tab1[i] = (short) ( 1.7874 * j);
                tab2[i] = (short) (-0.3396 * j);
                tab3[i] = (short) (-0.7188 * j);
                tab4[i] = (short) ( 1.4094 * j);
#endif
                /* Version 2, 80% Saturation */
                tab1[i] = (short) ( 1.4299 * j);
                tab2[i] = (short) (-0.2717 * j);
                tab3[i] = (short) (-0.5751 * j);
                tab4[i] = (short) ( 1.1275 * j);
                }
        }
#endif
/*...e*/
/*...sdecode_sites:0:*/
/*

Supplied wordwise:

Which pixel:        00000000     11111111    2222 2222    33333333
What comp:      uuvvyyyyyyyguuvv yyyyyyyguuvvyyyy yyygu_v_yyyyyyyg
Bit posn:       76767654321 5454 7654321 32327654 321 1 1 7654321

Supplied bytewise:

Which pixel:    0000         0000     2222 11111111 33333333 2222
What comp:      yyyguuvv uuvvyyyy uuvvyyyy yyyyyyyg yyyyyyyg yyygu_v_
Bit posn:       321 5454 76767654 32327654 7654321  7654321  321 1 1

Desired:

Which pixel:    00000000 11111111 22222222 33333333
What comp:      yyyyyyy_ yyyyyyy_ yyyyyyy_ yyyyyyy_ uuuuuuu_ vvvvvvv_

*/

void    decode_sites(byte *src, byte *dest, int n_sites)
        {
        for ( ; n_sites--; src += 6 )
                {
                *dest++ = (byte) ( ((byte) (src[0] & 0xe0)>>4) |
                                   ((byte) (src[1] & 0x0f)<<4) );
                *dest++ = (byte)    (byte) (src[3] & 0xfe)      ;
                *dest++ = (byte) ( ((byte) (src[2] & 0x0f)<<4) |
                                   ((byte) (src[5] & 0xe0)>>4) );
                *dest++ = (byte)    (byte) (src[4] & 0xfe)      ;
                *dest++ = (byte) ( ((byte) (src[0] & 0x0c)<<2) |
                                    (byte) (src[1] & 0xc0)     |
                                   ((byte) (src[2] & 0xc0)>>4) |
                                   ((byte) (src[5] & 0x08)>>2) );
                *dest++ = (byte) ( ((byte) (src[0] & 0x03)<<4) |
                                   ((byte) (src[1] & 0x30)<<2) |
                                   ((byte) (src[2] & 0x30)>>2) |
                                    (byte) (src[5] & 0x02)     );
                }
        }
/*...e*/
/*...sconvert_sites:0:*/
/*...sVersion1:0:*/
/*

Site has Y1 Y2 Y3 Y4 U V.

Input is of the form Y1 Y2 Y3 Y4 U V

R = ( V * 179 / 127 ) + Y

B = ( U * 227 / 127 ) + Y

    170 * Y - 51 * R - 19 * B
G = -------------------------
              100

Rewrite to give better optimisation ...

R = Y + 1.4094 * V

B = Y + 1.7874 * U

G = Y - 0.7188 * V - 0.3396 * U

*/
/*...e*/
/*...sVersion2\44\ 80\37\ saturation \40\as recommended\41\:0:*/
/*

Site has Y1 Y2 Y3 Y4 U V.

Input is of the form Y1 Y2 Y3 Y4 U V

R = 0.8 * ( V * 179 / 127 ) + Y

B = 0.8 * ( U * 227 / 127 ) + Y

    170 * Y - 51 * R - 19 * B
G = -------------------------
              100

Rewrite to give better optimisation ...

R = Y + 1.1275 * V

B = Y + 1.4299 * U

G = Y - 0.5751 * V - 0.2717 * U

*/
/*...e*/

void convert_sites(byte *src, byte *dest, int n_sites)
        {
        for ( ; n_sites--; src += 6 )
                {
                byte u   = (src[4] >> 1);
                byte v   = (src[5] >> 1);
                short tu = tab1[u];
                short ts = tab2[u] + tab3[v];
                short tv = tab4[v];
                int p;

                for ( p = 0; p < 4; p++ )
                        {
                        short b = (short) ((unsigned short) src[p]) + tu;
                        short g = (short) ((unsigned short) src[p]) + ts;
                        short r = (short) ((unsigned short) src[p]) + tv;

                        if ( b < 0 ) b = 0; else if ( b > 0xff ) b = 0xff;
                        if ( g < 0 ) g = 0; else if ( g > 0xff ) g = 0xff;
                        if ( r < 0 ) r = 0; else if ( r > 0xff ) r = 0xff;

                        *dest++ = (byte) b;
                        *dest++ = (byte) g;
                        *dest++ = (byte) r;
                        }
                }
        }
/*...e*/

GBM_ERR vid_rdata(int fd, GBM *gbm, byte *data)
        {
        int     stride = ((gbm->w * 3 + 3) & ~3);
        int     n_sites = gbm->w / 4;
        byte    *ibuffer, *sbuffer, *p;
        int     i;

        if ( (ibuffer = (byte*)malloc(n_sites * 6)) == NULL )  // mjs
                return GBM_ERR_MEM;

        if ( (sbuffer = (byte*)malloc(n_sites * 6)) == NULL )  // mjs
                {
                free(ibuffer);
                return GBM_ERR_MEM;
                }

        lseek(fd, 16L, SEEK_SET);

        p = data + ((gbm->h - 1) * stride);
        for ( i = gbm->h - 1; i >= 0; i-- )
                {
                if ( read(fd, (char *) ibuffer, n_sites * 6) != n_sites * 6 )
                        {
                        free(sbuffer);
                        free(ibuffer);
                        return GBM_ERR_READ;
                        }
                decode_sites(ibuffer, sbuffer, n_sites);
                convert_sites(sbuffer, p, n_sites);
                p -= stride;
                }
        free(sbuffer);
        free(ibuffer);
        return GBM_ERR_OK;
        }
/*...e*/
/*...svid_w:0:*/
/*...sconvert_to_yuv:0:*/
/*...sVersion1:0:*/
/*

Y = 51 * R + 100 * G + 19 * B
    -------------------------
             170

U = ( B - Y ) * 127 / 227

V = ( R - Y ) * 127 / 179

*/
/*...e*/
/*...sVersion2\44\ 80\37\ saturation \40\as recommended\41\:0:*/
/*

Y = 51 * R + 100 * G + 19 * B
    -------------------------
             170

U = (1 / 0.8) * ( B - Y ) * 127 / 227

V = (1 / 0.8) * ( R - Y ) * 127 / 179

*/
/*...e*/

void convert_to_yuv(byte *src, byte *dest, int n_sites)
        {
        while ( n_sites-- )
                {
                short u = 0, v = 0;
                int i;

                for ( i = 0; i < 4; i++ )
                        {
                        byte b = *src++;
                        byte g = *src++;
                        byte r = *src++;
                        short y = ( 51 * r + 100 * g + 19 * b ) / 170;

                        u += ( (b - y) * (127 * 5) / (227 * 4) );
                        v += ( (r - y) * (127 * 5) / (179 * 4) );

                        if ( y < 0 ) y = 0; else if ( y > 0xff ) y = 0xff;

                        *dest++ = (byte) (y & 0xfe);
                        }

                u >>= 2; v >>= 2;

                if ( u < -0x80 ) u = -0x80; else if ( u > 0x7f ) u = 0x7f;
                if ( v < -0x80 ) v = -0x80; else if ( v > 0x7f ) v = 0x7f;

                *dest++ = (byte) (u & 0xfe);
                *dest++ = (byte) (v & 0xfe);
                }
        }
/*...e*/
/*...sencode_sites:0:*/
/*

Supplied:

Which pixel:    00000000 11111111 22222222 33333333
What comp:      yyyyyyy_ yyyyyyy_ yyyyyyy_ yyyyyyy_ uuuuuuu_ vvvvvvv_

Desired bytewise:

Which pixel:    0000         0000     2222 11111111 33333333 2222
What comp:      yyyguuvv uuvvyyyy uuvvyyyy yyyyyyyg yyyyyyyg yyygu_v_
Bit posn:       321 5454 76767654 32327654 7654321  7654321  321 1 1

*/

void    encode_sites(byte *src, byte *dest, int n_sites)
        {
        for ( ; n_sites--; src += 6 )
                {
                *dest++ = (byte) ( ((byte) (src[0] & 0x0e)<<4) |
                                   ((byte) (src[4] & 0x30)>>2) |
                                   ((byte) (src[5] & 0x30)>>4) );
                *dest++ = (byte) (  (byte) (src[4] & 0xc0)     |
                                   ((byte) (src[5] & 0xc0)>>2) |
                                   ((byte) (src[0] & 0xf0)>>4) );
                *dest++ = (byte) ( ((byte) (src[4] & 0x0c)<<4) |
                                   ((byte) (src[5] & 0x0c)<<2) |
                                   ((byte) (src[2] & 0xf0)>>4) );
                *dest++ = (byte)    (byte) (src[1] & 0xfe)      ;
                *dest++ = (byte)    (byte) (src[3] & 0xfe)      ;
                *dest++ = (byte) ( ((byte) (src[2] & 0x0e)<<4) |
                                   ((byte) (src[4] & 0x02)<<2) |
                                    (byte) (src[5] & 0x02)     );
                }
        }
/*...e*/

GBM_ERR vid_w(char *fn, int fd, GBM *gbm, GBMRGB *gbmrgb, byte *data, char *opt)
        {
        byte buf[16];
        int xpos = 0, ypos = 0;
        int stride = ((gbm->w * 3 + 3) & ~3);
        int n_sites = gbm->w / 4;
        byte *obuffer, *sbuffer, *p;
        int i;
        char *s;

        fn=fn; gbmrgb=gbmrgb; /* Suppress 'unref arg' compiler warnings */

        if ( (s = gbm_find_word_prefix(opt, "xpos=")) != NULL )
                sscanf(s + 5, "%d", &xpos);

        if ( (s = gbm_find_word_prefix(opt, "ypos=")) != NULL )
                sscanf(s + 5, "%d", &ypos);

        memcpy(buf, "YUV12C", 6);
        buf[ 6] = 0;
        buf[ 7] = 0;
        buf[ 8] = low_byte(xpos);
        buf[ 9] = high_byte(xpos);
        buf[10] = low_byte(ypos);
        buf[11] = high_byte(ypos);
        buf[12] = low_byte(gbm->w & ~3);
        buf[13] = high_byte(gbm->w & ~3);
        buf[14] = low_byte(gbm->h);
        buf[15] = high_byte(gbm->h);

        if ( write(fd, buf, 16) != 16 )
                return GBM_ERR_WRITE;

        if ( (obuffer = (byte*)malloc(n_sites * 6)) == NULL )  // mjs
                return GBM_ERR_MEM;

        if ( (sbuffer = (byte*)malloc(n_sites * 6)) == NULL )  // mjs
                {
                free(obuffer);
                return GBM_ERR_MEM;
                }

        p = data + ((gbm->h - 1) * stride);
        for ( i = gbm->h - 1; i >= 0; i-- )
                {
                convert_to_yuv(p, sbuffer, n_sites);
                encode_sites(sbuffer, obuffer, n_sites);
                if ( write(fd, (char *) obuffer, n_sites * 6) != n_sites * 6 )
                        {
                        free(sbuffer);
                        free(obuffer);
                        return GBM_ERR_WRITE;
                        }
                p -= stride;
                }
        free(sbuffer);
        free(obuffer);

        return GBM_ERR_OK;
        }
/*...e*/
/*...svid_err:0:*/
unsigned long vid_err(GBM_ERR rc)
        {
        switch ( (int) rc )
                {
                case GBM_ERR_VID_BAD_W:
                        return IC_GBM_VID_BAD_W;
                }
        return 0;
        }
/*...e*/
/*
*****************************************************************************************
*                                                                                       *
* COPYRIGHT:                                                                            *
*   IBM Open Class Library                                                              *
*   (C) Copyright International Business Machines Corporation,  1997                    *
*   Licensed Material - Program-Property of IBM - All Rights Reserved.                  *
*   US Government Users Restricted Rights - Use, duplication, or disclosure             *
*   restricted by GSA ADP Schedule Contract with IBM Corp.                              *
*                                                                                       *
*****************************************************************************************
*/
// Revision: 56 1.4.1.5 source/ographic/igbm.cpp, graphics, ioc.v400, 001006 
/*

IGBMGIF.C  Graphics Interchange Format support

Input options: index=# to get a given image in the file
Output options: xscreen=#,yscreen=#,background=#,xpos=#,ypos=#,transcol=#.

*/

#if 0
#pragma priority( -2147481424 )

/*...sincludes:0:*/
#include <stdio.h>
#include <ctype.h>
#include <stddef.h>
#include <stdlib.h>
#include <string.h>
#include <memory.h>
#include <malloc.h>
#ifdef AIX
#include <unistd.h>
#else
#include <io.h>
#endif
#include <fcntl.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <igbmstnd.hpp>
#include <igbm.hpp>
#include <igbmhelp.hpp>
#include <icconst.h>
#include <ibase.hpp>

// Segment definitions
#ifdef IC_PAGETUNE
  #define _IGBMGIF_CPP_
  #include <ipagetun.h>
#endif
#endif // 0

/*...vgbm\46\h:0:*/
/*...vgbmhelp\46\h:0:*/
/*...e*/

/*...suseful:0:*/
#define low_byte(w)     ((byte)  ((w)&0x00ff)    )
#define high_byte(w)    ((byte) (((w)&0xff00)>>8))
#define make_word(a,b)  (((word)a) + (((word)b) << 8))
/*...e*/

static GBMFT gif_gbmft =
        {
        "GIF",
        "CompuServe Graphics Interchange Format",
        "GIF",
        GBM_FT_R1|GBM_FT_R4|GBM_FT_R8|
        GBM_FT_W1|GBM_FT_W4|GBM_FT_W8,
        };

#define GBM_ERR_GIF_BPP         ((GBM_ERR) 1100)
#define GBM_ERR_GIF_TERM        ((GBM_ERR) 1101)
#define GBM_ERR_GIF_CODE_SIZE   ((GBM_ERR) 1102)
#define GBM_ERR_GIF_CORRUPT     ((GBM_ERR) 1103)

typedef struct
        {
        bool ilace, errok;
        int bpp;
        byte pal[0x100 * 3];
        } GIF_PRIV;

typedef unsigned int cword;

/*...sgif_qft:0:*/
GBM_ERR gif_qft(GBMFT *gbmft)
        {
        *gbmft = gif_gbmft;
        return GBM_ERR_OK;
        }
/*...e*/
/*...sgif_rhdr:0:*/
GBM_ERR gif_rhdr(char *fn, int fd, GBM *gbm, char *opt)
        {
        GIF_PRIV *gif_priv = (GIF_PRIV *) gbm->priv;
        byte signiture[6], scn_desc[7], image_desc[10];
        char *index;
        int img = 0, img_want = 1;
        int bits_gct;

        fn=fn; /* Suppress 'unref arg' compiler warnings */

        /* Discover which image in GIF file we want */

        if ( (index = gbm_find_word_prefix(opt, "index=")) != NULL )
                sscanf(index + 6, "%d", &img_want);

        gif_priv->errok = ( gbm_find_word(opt, "errok") != NULL );

        /* Read and validate signiture block */

        lseek(fd, 0L, SEEK_SET);
        if ( read(fd, signiture, 6) != 6 )
                return GBM_ERR_READ;
        if ( memcmp(signiture, "GIF87a", 6) &&
             memcmp(signiture, "GIF89a", 6) )
                return GBM_ERR_BAD_MAGIC;

        /* Read screen descriptor */

        if ( read(fd, scn_desc, 7) != 7 )
                return GBM_ERR_READ;
        gif_priv->bpp = bits_gct = (scn_desc[4] & 7) + 1;

        if ( scn_desc[4] & 0x80 )
                /* Global colour table follows screen descriptor */
                {
                if ( read(fd, gif_priv->pal, 3 << bits_gct) != (3 << bits_gct) )
                        return GBM_ERR_READ;
                }
        else
                /* Blank out palette, but make entry 1 white */
                {
                memset(gif_priv->pal, 0, 3 << bits_gct);
                gif_priv->pal[3] =
                gif_priv->pal[4] =
                gif_priv->pal[5] = 0xff;
                }

        /* Expected image descriptors / extension blocks / terminator */

        while ( img < img_want )
                {
                if ( read(fd, image_desc, 1) != 1 )
                        return GBM_ERR_READ;
                switch ( image_desc[0] )
                        {
/*...s0x2c \45\ image descriptor:24:*/
case 0x2c:
        if ( read(fd, image_desc + 1, 9) != 9 )
                return GBM_ERR_READ;
        gbm->w = make_word(image_desc[5], image_desc[6]);
        gbm->h = make_word(image_desc[7], image_desc[8]);
        gif_priv->ilace = ( (image_desc[9] & 0x40) != 0 );

        if ( image_desc[9] & 0x80 )
                /* Local colour table follows */
                {
                gif_priv->bpp = (scn_desc[9] & 7) + 1;
                if ( read(fd, gif_priv->pal, 3 << gif_priv->bpp) != (3 << gif_priv->bpp) )
                        return GBM_ERR_READ;
                }

        if ( ++img != img_want )
                /* Skip the image data */
                {
                byte code_size, block_size;

                if ( read(fd, &code_size, 1) != 1 )
                        return GBM_ERR_READ;
                do
                        {
                        if ( read(fd, &block_size, 1) != 1 )
                                return GBM_ERR_READ;
                        lseek(fd, block_size, SEEK_SET);
                        }
                while ( block_size );
                }

        break;
/*...e*/
/*...s0x21 \45\ extension block:24:*/
/* Ignore all extension blocks */

case 0x21:
        {
        byte func_code, byte_count;

        if ( read(fd, &func_code, 1) != 1 )
                return GBM_ERR_READ;
        do
                {
                if ( read(fd, &byte_count, 1) != 1 )
                        return GBM_ERR_READ;
                lseek(fd, byte_count, SEEK_CUR);
                }
        while ( byte_count );
        }
        break;
/*...e*/
/*...s0x3b \45\ terminator:24:*/
/* Oi, we were hoping to get an image descriptor! */

case 0x3b:
        return GBM_ERR_GIF_TERM;
/*...e*/
                        }
                }

        switch ( gif_priv->bpp )
                {
                case 1:         gbm->bpp = 1;           break;
                case 2:
                case 3:
                case 4:         gbm->bpp = 4;           break;
                case 5:
                case 6:
                case 7:
                case 8:         gbm->bpp = 8;           break;
                default:        return GBM_ERR_GIF_BPP;
                }

        return GBM_ERR_OK;
        }
/*...e*/
/*...sgif_rpal:0:*/
GBM_ERR gif_rpal(int fd, GBM *gbm, GBMRGB *gbmrgb)
        {
        GIF_PRIV *gif_priv = (GIF_PRIV *) gbm->priv;
        byte *pal = gif_priv->pal;
        int i;

        fd=fd; /* Suppress 'unref arg' compiler warning */

        memset(gbmrgb, 0x80, (sizeof(GBMRGB) << gbm->bpp));

        for ( i = 0; i < (1 << gif_priv->bpp); i++ )
                {
                gbmrgb[i].r = *pal++;
                gbmrgb[i].g = *pal++;
                gbmrgb[i].b = *pal++;
                }

        return GBM_ERR_OK;
        }
/*...e*/
/*...sgif_rdata:0:*/
/*...sread context:0:*/
typedef struct
        {
        int fd;                         /* File descriptor to read */
        int inx, size;                  /* Index and size in bits */
        byte buf[255+3];                /* Buffer holding bits */
        int code_size;                  /* Number of bits to return at once */
        cword read_mask;                /* 2^code_size-1 */
        } READ_CONTEXT;

static cword read_code(READ_CONTEXT *c)
        {
        int raw_code, byte_inx;

        if ( c->inx + c->code_size > c->size )
/*...snot enough bits in buffer\44\ refill it:16:*/
/* Not very efficient, but infrequently called */

{
int bytes_to_lose = (c->inx >> 3);
byte bytes;

/* Note biggest code size is 12 bits */
/* And this can at worst span 3 bytes */
memcpy(c->buf, c->buf + bytes_to_lose, 3);
(c->inx) &= 7;
(c->size) -= (bytes_to_lose << 3);
if ( read(c->fd, &bytes, 1) != 1 )
        return 0xffff;
if ( read(c->fd, c->buf + (c->size >> 3), bytes) != bytes )
        return ( 0xffff );
(c->size) += (bytes << 3);
}
/*...e*/

        byte_inx = (c->inx >> 3);
        raw_code = c->buf[byte_inx] + ((c->buf[byte_inx + 1]) << 8);
        if ( c->code_size > 8 )
                raw_code += ((c->buf[byte_inx + 2]) << 16);
        raw_code >>= ((c->inx) & 7);
        (c->inx) += (byte) (c->code_size);

        return (cword) raw_code & c->read_mask;
        }
/*...e*/
/*...soutput context:0:*/
typedef struct
        {
        int x, y, w, h, bpp, pass;
        bool ilace;
        int stride;
        byte *data, *data_this_line;
        } OUTPUT_CONTEXT;

static void output(byte value, OUTPUT_CONTEXT *o)
        {
        if ( o->y >= o->h )
                return;

        switch ( o->bpp )
                {
                case 1:
                        if ( (o->x) & 7 )
                                o->data_this_line[(o->x) >> 3] |= (value << (7 - ((o->x) & 7)));
                        else
                                o->data_this_line[(o->x) >> 3] = (value << 7);
                        break;
                case 4:
                        if ( (o->x) & 1 )
                                o->data_this_line[(o->x) >> 1] |= value;
                        else
                                o->data_this_line[(o->x) >> 1] = (value << 4);
                        break;
                case 8:
                        o->data_this_line[o->x] = value;
                        break;
                }

        if ( ++(o->x) < o->w )
                return;

        o->x = 0;
        if ( o->ilace )
                {
                switch ( o->pass )
                        {
                        case 0:
                                (o->y) += 8;
                                if ( o->y >= o->h )
                                        {
                                        (o->pass)++;
                                        o->y = 4;
                                        }
                                break;
                        case 1:
                                (o->y) += 8;
                                if ( o->y >= o->h )
                                        {
                                        (o->pass)++;
                                        o->y = 2;
                                        }
                                break;
                        case 2:
                                (o->y) += 4;
                                if ( o->y >= o->h )
                                        {
                                        (o->pass)++;
                                        o->y = 1;
                                        }
                                break;
                        case 3:
                                (o->y) += 2;
                                break;
                        }
                o->data_this_line = o->data + (o->h - 1 - o->y) * o->stride;
                }
        else
                {
                (o->y)++;
                o->data_this_line -= (o->stride);
                }
        }
/*...e*/

GBM_ERR gif_rdata(int fd, GBM *gbm, byte *data)
        {
        GIF_PRIV *gif_priv = (GIF_PRIV *) gbm->priv;
        byte min_code_size;             /* As read from the file */
        int init_code_size;             /* Initial code size */
        cword max_code;                 /* 1 << code_size */
        cword clear_code;               /* Code to clear table */
        cword eoi_code;                 /* End of information code */
        cword first_free_code;          /* First free code */
        cword free_code;                /* Next available free code slot */
        word bit_mask;                  /* Output pixel mask */
        int i, out_count = 0;
        cword code, cur_code, old_code, in_code, fin_char;
        cword *prefix, *suffix, *outcode;
        READ_CONTEXT c;
        OUTPUT_CONTEXT o;
        bool table_full = false;     /* To help implement deferred clear */

        if ( (prefix = (cword *) malloc(4096 * sizeof(cword))) == NULL )
                return GBM_ERR_MEM;
        if ( (suffix = (cword *) malloc(4096 * sizeof(cword))) == NULL )
                {
                free(prefix);
                return GBM_ERR_MEM;
                }
        if ( (outcode = (cword *) malloc(4097 * sizeof(cword))) == NULL )
                {
                free(suffix);
                free(prefix);
                return GBM_ERR_MEM;
                }

        if ( read(fd, &min_code_size, 1) != 1 )
                {
                free(outcode);
                free(suffix);
                free(prefix);
                return GBM_ERR_READ;
                }

        if ( min_code_size < 2 || min_code_size > 9 )
                {
                free(outcode);
                free(suffix);
                free(prefix);
                return GBM_ERR_GIF_CODE_SIZE;
                }

        /* Initial read context */

        c.inx            = 0;
        c.size           = 0;
        c.fd             = fd;
        c.code_size      = min_code_size + 1;
        c.read_mask      = (cword) (( 1 << c.code_size ) - 1);

        /* Initialise pixel-output context */

        o.x              = 0;
        o.y              = 0;
        o.pass           = 0;
        o.w              = gbm->w;
        o.h              = gbm->h;
        o.bpp            = gbm->bpp;
        o.ilace          = gif_priv->ilace;
        o.stride         = ( (gbm->w * gbm->bpp + 31) / 32 ) * 4;
        o.data           = data;
        o.data_this_line = data + (gbm->h - 1) * o.stride;

        bit_mask = (word) ((1 << gif_priv->bpp) - 1);

        /* 2^min_code size accounts for all colours in file */

        clear_code = (cword) ( 1 << min_code_size );
        eoi_code = (cword) (clear_code + 1);
        free_code = first_free_code = (cword) (clear_code + 2);

        /* 2^(min_code_size+1) includes clear and eoi code and space too */

        init_code_size = c.code_size;
        max_code = (cword) ( 1 << c.code_size );

        while ( (code = read_code(&c)) != eoi_code && code != 0xffff && o.y < o.h )
                {
                if ( code == clear_code )
                        {
                        c.code_size = init_code_size;
                        max_code = (cword) ( 1 << c.code_size );
                        c.read_mask = (cword) (max_code - 1);
                        free_code = first_free_code;
                        cur_code = old_code = code = read_code(&c);
                        if ( code == 0xffff )
                                break;
                        fin_char = (cur_code & bit_mask);
                        output(fin_char, &o);
                        table_full = false;
                        }
                else
                        {
                        cur_code = in_code = code;
                        if ( cur_code >= free_code )
                                {
                                cur_code = old_code;
                                outcode[out_count++] = fin_char;
                                }
                        while ( cur_code > bit_mask )
                                {
                                if ( out_count > 4096 )
                                        {
                                        free(outcode);
                                        free(suffix);
                                        free(prefix);
                                        return gif_priv->errok ? GBM_ERR_OK : GBM_ERR_GIF_CORRUPT;
                                        }
                                outcode[out_count++] = suffix[cur_code];
                                cur_code = prefix[cur_code];
                                }
                        fin_char = (cur_code & bit_mask);
                        outcode[out_count++] = fin_char;
                        for ( i = out_count - 1; i >= 0; i-- )
                                output(outcode[i], &o);
                        out_count = 0;

                        /* Update dictionary */

                        if ( !table_full )
                                {
                                prefix[free_code] = old_code;
                                suffix[free_code] = fin_char;

                                /* Advance to next free slot */

                                if ( ++free_code >= max_code )
                                        {
                                        if ( c.code_size < 12 )
                                                {
                                                c.code_size++;
                                                max_code <<= 1;
                                                c.read_mask = (cword) (( 1 << c.code_size ) - 1);
                                                }
                                        else
                                                table_full = true;
                                        }
                                }
                        old_code = in_code;
                        }
                }

        free(outcode);
        free(suffix);
        free(prefix);

        if ( code == 0xffff )
                return gif_priv->errok ? GBM_ERR_OK : GBM_ERR_READ;

        return GBM_ERR_OK;
        }
/*...e*/
/*...sgif_w:0:*/
/*
We won't write any GIF89a or higher extensions into file.
Write palette as global colour table, not local.
*/

/*...swrite context:0:*/
typedef struct
        {
        int fd;                         /* Open file descriptor to write to */
        int inx;                        /* Bit index into buf */
        int code_size;                  /* Code size in bits */
        byte buf[255+2];                /* Biggest block + overflow space */
        } WRITE_CONTEXT;

static bool write_code(int code, WRITE_CONTEXT *w)
        {
        byte *buf = w->buf + (w->inx >> 3);

        code <<= ((w->inx) & 7);
        *buf++ |= (byte)  code       ;
/*...scomment about IBM C\45\Set\47\2 optmiser bug:8:*/
/* C-Set/2 with CSD0044 optimiser bug shows itself in following code :-
        LEA     EDI,[EDX+01H]
        MOV     CL,AL
        SAR     CL,08H          ; What!
        MOV     [EDI],CL
*/
/*...e*/
        *buf++  = (byte) (code >>  8);
        *buf    = (byte) (code >> 16);

        (w->inx) += (w->code_size);
        if ( w->inx >= 255 * 8 )
                /* Flush out full buffer */
                {
                byte bytes = 255;

                if ( write(w->fd, &bytes, 1) != 1 )
                        return false;
                if ( write(w->fd, w->buf, 255) != 255 )
                        return false;

                memcpy(w->buf, w->buf + 255, 2);
                memset(w->buf + 2, 0, 255);
                (w->inx) -= (255 * 8);
                }

        return true;
        }

static bool flush_code(WRITE_CONTEXT *w)
        {
        byte bytes = ((w->inx + 7) >> 3);

        if ( bytes )
                {
                if ( write(w->fd, &bytes, 1) != 1 )
                        return false;
                if ( write(w->fd, w->buf, bytes) != bytes )
                        return false;
                }

        /* Data block terminator - a block of zero size */

        bytes = 0;
        return write(w->fd, &bytes, 1) == 1;
        }
/*...e*/

#ifndef DEFINDED_DICT
#define DEFINDED_DICT
typedef struct { cword tail; byte col; } DICT;
#endif // DEFINDED_DICT

GBM_ERR gif_w(char *fn, int fd, GBM *gbm, GBMRGB *gbmrgb, byte *data, char *opt)
        {
        int xpos = 0, ypos = 0;
        int xscreen = gbm->w, yscreen = gbm->h;
        int inx_background = 0, inx_transcol = -1;

/*...shandle options:8:*/
{
char *s;

fn=fn; /* Suppress 'unref arg' compiler warnings */

if ( gbm->bpp != 1 && gbm->bpp != 4 && gbm->bpp != 8 )
        return GBM_ERR_NOT_SUPP;

if ( (s = gbm_find_word_prefix(opt, "xscreen=")) != NULL )
        sscanf(s + 8, "%d", &xscreen);

if ( (s = gbm_find_word_prefix(opt, "yscreen=")) != NULL )
        sscanf(s + 8, "%d", &yscreen);

if ( (s = gbm_find_word_prefix(opt, "background=")) != NULL )
        sscanf(s + 11, "%d", &inx_background);

if ( (s = gbm_find_word_prefix(opt, "xpos=")) != NULL )
        sscanf(s + 5, "%d", &xpos);

if ( (s = gbm_find_word_prefix(opt, "ypos=")) != NULL )
        sscanf(s + 5, "%d", &ypos);

if ( (s = gbm_find_word_prefix(opt, "transcol=")) != NULL )
        sscanf(s + 9, "%d", &inx_transcol);
}
/*...e*/
/*...swrite header etc\46\:8:*/
{
byte scn_desc[7], image_desc[10]; int p;
char *sig = inx_transcol != -1 ? "GIF89a" : "GIF87a";

/* Write signiture */

if ( write(fd, sig, 6) != 6 )
        return GBM_ERR_WRITE;

/* Write screen descriptor */

scn_desc[0] = low_byte(xscreen);
scn_desc[1] = high_byte(xscreen);
scn_desc[2] = low_byte(yscreen);
scn_desc[3] = high_byte(yscreen);
scn_desc[4] = (0x80 | ((gbm->bpp - 1) * 0x11));
                        /* Global colour table follows */
                        /* Quality bpp == gct bpp == gbm->bpp */
scn_desc[5] = (byte) inx_background;
scn_desc[6] = 0;
if ( write(fd, scn_desc, 7) != 7 )
        return GBM_ERR_WRITE;

/* Write global colour table */

for ( p = 0; p < (1 << gbm->bpp); p++ )
        {
        byte pal[3];

        pal[0] = gbmrgb[p].r;
        pal[1] = gbmrgb[p].g;
        pal[2] = gbmrgb[p].b;
        if ( write(fd, pal, 3) != 3 )
                return GBM_ERR_WRITE;
        }

if ( inx_transcol != -1 )
        /* Do GIF89a "Graphic Control Extension" application extension block */
        {
        char gce[8];
        gce[0] = 0x21;                  /* Extension Introducer */
        gce[1] = 0xf9;                  /* Graphic Control Label */
        gce[2] = 4;                     /* Block size */
        gce[3] = 0x01;                  /* No 'disposal', no 'user input' */
                                        /* Just transparent index present */
        gce[4] = 0;                     /* Delay time, 0 => not set */
        gce[5] = 0;                     /* Delay time, 0 => not set */
        gce[6] = (char) inx_transcol;   /* Transparent colour index */
        gce[7] = 0;                     /* Block size, 0 => end of extension */
        if ( write(fd, gce, 8) != 8 )
                return GBM_ERR_WRITE;
        }

/* Do image descriptor block */

image_desc[0] = (byte) 0x2c;
image_desc[1] = low_byte(xpos);
image_desc[2] = high_byte(xpos);
image_desc[3] = low_byte(ypos);
image_desc[4] = high_byte(ypos);
image_desc[5] = low_byte(gbm->w);
image_desc[6] = high_byte(gbm->w);
image_desc[7] = low_byte(gbm->h);
image_desc[8] = high_byte(gbm->h);
image_desc[9] = gbm->bpp - 1;
        /* Non-interlaced, no local colour map, no sorted palette */
if ( write(fd, image_desc, 10) != 10 )
        return GBM_ERR_WRITE;
}
/*...e*/
/*...sLZW encode data\44\ tail\43\col lookup version:8:*/
/*
hashvalue is calculated from a string of pixels cumulatively.
hashtable is searched starting at index hashvalue for to find the entry.
hashtable is big enough so that MAX_HASH > 4*MAX_DICT.
*/

#define MAX_HASH        17777                   /* Probably prime and > 4096 */
#define MAX_DICT        4096                    /* Dictionary size           */
#define INIT_HASH(p)    (((p)+3)*301)           /* Initial hash value        */

{
int stride = ((gbm->w * gbm->bpp + 31) / 32) * 4;
byte min_code_size, *pdata;
int init_code_size, x, y;
cword clear_code, eoi_code, last_code, max_code, tail;
unsigned int hashvalue, lenstring, j;
DICT *dict, **hashtable;
WRITE_CONTEXT w;

/* Now LZW encode data */

if ( (dict = (DICT *) malloc(MAX_DICT * sizeof(DICT))) == NULL )
        return GBM_ERR_MEM;

if ( (hashtable = (DICT **) malloc(MAX_HASH * sizeof(DICT *))) == NULL )
        {
        free(dict);
        return GBM_ERR_MEM;
        }

/* Initialise encoder variables */

init_code_size = gbm->bpp + 1;
if ( init_code_size == 2 )
        /* Room for col0, col1, cc, eoi, but no others! */
        init_code_size++;

min_code_size = init_code_size - 1;
if ( write(fd, &min_code_size, 1) != 1 )
        {
        free(hashtable);
        free(dict);
        return GBM_ERR_WRITE;
        }

clear_code = ( 1 << min_code_size );
eoi_code   = clear_code + 1;
last_code  = eoi_code;
max_code   = ( 1 << init_code_size );
lenstring  = 0;

/* Setup write context */

w.fd        = fd;
w.inx       = 0;
w.code_size = init_code_size;
memset(w.buf, 0, sizeof(w.buf));

if ( !write_code(clear_code, &w) )
        {
        free(hashtable);
        free(dict);
        return GBM_ERR_WRITE;
        }

for ( j = 0; j < MAX_HASH; j++ )
        hashtable[j] = NULL;

data += ( (gbm->h - 1) * stride );
for ( y = gbm->h - 1; y >= 0; y--, data -= stride )
        for ( x = 0, pdata = data; x < gbm->w; x++ )
                {
                byte col;
/*...sget col:24:*/
switch ( gbm->bpp )
        {
        case 8:
                col = *pdata++;
                break;
        case 4:
                if ( x & 1 )
                        col = (*pdata++ & 0x0f);
                else
                        col = (*pdata >> 4);
                break;
        default: /* must be 1 */
                if ( (x & 7) == 7 )
                        col = (*pdata++ & 0x01);
                else
                        col = ((*pdata >> (7-(x&7))) & 0x01);
                break;
        }
/*...e*/
/*...sLZW encode:24:*/
if ( ++lenstring == 1 )
        {
        tail      = col;
        hashvalue = INIT_HASH(col);
        }
else
        {
        hashvalue *= ( col + lenstring + 4 );
        j = ( hashvalue %= MAX_HASH );
        while ( hashtable[j] != NULL &&
                ( hashtable[j]->tail != tail ||
                  hashtable[j]->col  != col  ) )
                if ( ++j >= MAX_HASH )
                        j = 0;
        if ( hashtable[j] != NULL )
                /* Found in the strings table */
                tail = (hashtable[j]-dict);
        else
                /* Not found */
                {
                if ( !write_code(tail, &w) )
                        {
                        free(hashtable);
                        free(dict);
                        return GBM_ERR_WRITE;
                        }
                hashtable[j]       = dict + ++last_code;
                hashtable[j]->tail = tail;
                hashtable[j]->col  = col;
                tail               = col;
                hashvalue          = INIT_HASH(col);
                lenstring          = 1;

                if ( last_code >= max_code )
                        /* Next code will be written longer */
                        {
                        max_code <<= 1;
                        w.code_size++;
                        }
                else if ( last_code >= MAX_DICT-2 )
                        /* Reset tables */
                        {
                        if ( !write_code(tail      , &w) ||
                             !write_code(clear_code, &w) )
                                {
                                free(hashtable);
                                free(dict);
                                return GBM_ERR_WRITE;
                                }
                        lenstring   = 0;
                        last_code   = eoi_code;
                        w.code_size = init_code_size;
                        max_code    = ( 1 << init_code_size );
                        for ( j = 0; j < MAX_HASH; j++ )
                                hashtable[j] = NULL;
                        }
                }
        }
/*...e*/
                }

free(hashtable);
free(dict);

if ( !write_code(tail    , &w) ||
     !write_code(eoi_code, &w) ||
     !flush_code(          &w) )
        return GBM_ERR_WRITE;
}
/*...e*/
/*...swrite terminator:8:*/
{
byte term = (byte) 0x3b;
if ( write(fd, &term, 1) != 1 )
        return GBM_ERR_WRITE;
}
/*...e*/

        return GBM_ERR_OK;
        }
/*...e*/
/*...sgif_err:0:*/
unsigned long gif_err(GBM_ERR rc)
        {
        switch ( (int) rc )
                {
                case GBM_ERR_GIF_BPP:
                        return IC_GBM_GIF_BPP;
                case GBM_ERR_GIF_TERM:
                        return IC_GBM_GIF_TERM;
                case GBM_ERR_GIF_CODE_SIZE:
                        return IC_GBM_GIF_CODE_SIZE;
                case GBM_ERR_GIF_CORRUPT:
                        return IC_GBM_GIF_CORRUPT;
                }
        return 0;
        }
/*
*****************************************************************************************
*                                                                                       *
* COPYRIGHT:                                                                            *
*   IBM Open Class Library                                                              *
*   (C) Copyright International Business Machines Corporation,  1997                    *
*   Licensed Material - Program-Property of IBM - All Rights Reserved.                  *
*   US Government Users Restricted Rights - Use, duplication, or disclosure             *
*   restricted by GSA ADP Schedule Contract with IBM Corp.                              *
*                                                                                       *
*****************************************************************************************
*/
// Revision: 56 1.4.1.5 source/ographic/igbm.cpp, graphics, ioc.v400, 001006 
/*

IGBMXBM.C  X Windows Bitmap support

Reads and writes most X bitmaps

*/

#if 0
#pragma priority( -2147481424 )

/*...sincludes:0:*/
#include <stdio.h>
#include <ctype.h>
#include <stddef.h>
#include <stdlib.h>
#include <string.h>
#include <memory.h>
#include <malloc.h>
#ifdef AIX
#include <unistd.h>
#else
#include <io.h>
#endif
#include <fcntl.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <igbmstnd.hpp>
#include <igbm.hpp>
#include <igbmhelp.hpp>
#include <icconst.h>
#include <ibase.hpp>

// Segment definitions
#ifdef IC_PAGETUNE
  #define _IGBMXBM_CPP_
  #include <ipagetun.h>
#endif
#endif // 0

static GBMFT xbm_gbmft =
        {
        "XBitmap",
        "X Windows Bitmap",
        "XBM",
        GBM_FT_R1|
        GBM_FT_W1,
        };

#define GBM_ERR_XBM_EXP_ID      ((GBM_ERR) 1300)
#define GBM_ERR_XBM_UNEXP_EOF   ((GBM_ERR) 1301)
#define GBM_ERR_XBM_EXP_CHAR    ((GBM_ERR) 1302)
#define GBM_ERR_XBM_EXP_LSQR    ((GBM_ERR) 1303)
#define GBM_ERR_XBM_EXP_RSQR    ((GBM_ERR) 1304)
#define GBM_ERR_XBM_EXP_EQUALS  ((GBM_ERR) 1305)
#define GBM_ERR_XBM_EXP_LCUR    ((GBM_ERR) 1306)
#define GBM_ERR_XBM_EXP_RCUR    ((GBM_ERR) 1307)
#define GBM_ERR_XBM_EXP_COMMA   ((GBM_ERR) 1308)
#define GBM_ERR_XBM_EXP_NUMBER  ((GBM_ERR) 1309)
#define GBM_ERR_XBM_EXP_SEMI    ((GBM_ERR) 1310)

#define MAX_BUF 1024
#define MAX_ID  100

typedef struct
        {
        int fd;
        int inx, cnt;
        byte buf[MAX_BUF];
        byte id[MAX_ID+1];
        int number;
        int size;
        } XBM_PRIV;

/*...srev:0:*/
static byte rev_t[0x100] =
        {
        0x00, 0x80, 0x40, 0xc0, 0x20, 0xa0, 0x60, 0xe0,
        0x10, 0x90, 0x50, 0xd0, 0x30, 0xb0, 0x70, 0xf0,
        0x08, 0x88, 0x48, 0xc8, 0x28, 0xa8, 0x68, 0xe8,
        0x18, 0x98, 0x58, 0xd8, 0x38, 0xb8, 0x78, 0xf8,
        0x04, 0x84, 0x44, 0xc4, 0x24, 0xa4, 0x64, 0xe4,
        0x14, 0x94, 0x54, 0xd4, 0x34, 0xb4, 0x74, 0xf4,
        0x0c, 0x8c, 0x4c, 0xcc, 0x2c, 0xac, 0x6c, 0xec,
        0x1c, 0x9c, 0x5c, 0xdc, 0x3c, 0xbc, 0x7c, 0xfc,
        0x02, 0x82, 0x42, 0xc2, 0x22, 0xa2, 0x62, 0xe2,
        0x12, 0x92, 0x52, 0xd2, 0x32, 0xb2, 0x72, 0xf2,
        0x0a, 0x8a, 0x4a, 0xca, 0x2a, 0xaa, 0x6a, 0xea,
        0x1a, 0x9a, 0x5a, 0xda, 0x3a, 0xba, 0x7a, 0xfa,
        0x06, 0x86, 0x46, 0xc6, 0x26, 0xa6, 0x66, 0xe6,
        0x16, 0x96, 0x56, 0xd6, 0x36, 0xb6, 0x76, 0xf6,
        0x0e, 0x8e, 0x4e, 0xce, 0x2e, 0xae, 0x6e, 0xee,
        0x1e, 0x9e, 0x5e, 0xde, 0x3e, 0xbe, 0x7e, 0xfe,
        0x01, 0x81, 0x41, 0xc1, 0x21, 0xa1, 0x61, 0xe1,
        0x11, 0x91, 0x51, 0xd1, 0x31, 0xb1, 0x71, 0xf1,
        0x09, 0x89, 0x49, 0xc9, 0x29, 0xa9, 0x69, 0xe9,
        0x19, 0x99, 0x59, 0xd9, 0x39, 0xb9, 0x79, 0xf9,
        0x05, 0x85, 0x45, 0xc5, 0x25, 0xa5, 0x65, 0xe5,
        0x15, 0x95, 0x55, 0xd5, 0x35, 0xb5, 0x75, 0xf5,
        0x0d, 0x8d, 0x4d, 0xcd, 0x2d, 0xad, 0x6d, 0xed,
        0x1d, 0x9d, 0x5d, 0xdd, 0x3d, 0xbd, 0x7d, 0xfd,
        0x03, 0x83, 0x43, 0xc3, 0x23, 0xa3, 0x63, 0xe3,
        0x13, 0x93, 0x53, 0xd3, 0x33, 0xb3, 0x73, 0xf3,
        0x0b, 0x8b, 0x4b, 0xcb, 0x2b, 0xab, 0x6b, 0xeb,
        0x1b, 0x9b, 0x5b, 0xdb, 0x3b, 0xbb, 0x7b, 0xfb,
        0x07, 0x87, 0x47, 0xc7, 0x27, 0xa7, 0x67, 0xe7,
        0x17, 0x97, 0x57, 0xd7, 0x37, 0xb7, 0x77, 0xf7,
        0x0f, 0x8f, 0x4f, 0xcf, 0x2f, 0xaf, 0x6f, 0xef,
        0x1f, 0x9f, 0x5f, 0xdf, 0x3f, 0xbf, 0x7f, 0xff,
        };
/*...e*/
/*...sbuffered text read:0:*/
static int nextbuf(XBM_PRIV *xbm_priv)
        {
        int cnt;

        if ( (cnt = read(xbm_priv->fd, xbm_priv->buf, MAX_BUF)) <= 0 )
                return -1;
        xbm_priv->cnt = cnt;
        xbm_priv->inx = 1;
        return ( xbm_priv->buf[0] );
        }

#define nextchar(x) ( ((x)->inx<(x)->cnt) ? \
        (int) (unsigned int) ((x)->buf[((x)->inx)++]) : nextbuf(x) )

static void pushchar(XBM_PRIV *xbm_priv, int c)
        {
        if ( c != -1 )
                xbm_priv->buf[--(xbm_priv->inx)] = (byte) c;
        }

typedef byte SYM;
#define S_DEFINE        ((SYM)  1)
#define S_ID            ((SYM)  2)
#define S_NUMBER        ((SYM)  3)
#define S_STATIC        ((SYM)  4)
#define S_CHAR          ((SYM)  5)
#define S_SHORT         ((SYM)  6)
#define S_LSQR          ((SYM)  7)
#define S_RSQR          ((SYM)  8)
#define S_LCUR          ((SYM)  9)
#define S_RCUR          ((SYM) 10)
#define S_COMMA         ((SYM) 11)
#define S_SEMI          ((SYM) 12)
#define S_EQUALS        ((SYM) 13)
#define S_EOF           ((SYM) 14)
#define S_ERROR_COMMENT ((SYM) 15)
#define S_ERROR_ID      ((SYM) 16)
#define S_ERROR_MINUS   ((SYM) 17)
#define S_ERROR_NUMBER  ((SYM) 18)

static int valof(char c)
        {
        if ( c >= 'a' && c <= 'f' )
                return c - 'a' + 10;
        if ( c >= 'A' && c <= 'F' )
                return c - 'A' + 10;
        return c - '0';
        }

static SYM nextsym(XBM_PRIV *xbm_priv)
        {
        int c, i, sign = 1;

        for ( ;; )
                {
                while ( (c = nextchar(xbm_priv)) != -1 && isspace(c) )
                        ;
                if ( c == -1 )
                        return S_EOF;

                if ( c != '/' )
                        break;

                if ( (c = nextchar(xbm_priv)) != '*' )
                        return S_ERROR_COMMENT;

                if ( (c = nextchar(xbm_priv)) == -1 )
                        return S_EOF;

                do
                        while ( c != '*' )
                                if ( (c = nextchar(xbm_priv)) == -1 )
                                        return S_EOF;
                while ( (c = nextchar(xbm_priv)) != -1 && c != '/' );
                if ( c == -1 )
                        return S_EOF;
                }

        switch ( c )
                {
                case '[':       return S_LSQR  ;
                case ']':       return S_RSQR  ;
                case '{':       return S_LCUR  ;
                case '}':       return S_RCUR  ;
                case ',':       return S_COMMA ;
                case ';':       return S_SEMI  ;
                case '=':       return S_EQUALS;
                }

        if ( isdigit(c) || c == '-' )
                {
                if ( c == '-' )
                        {
                        sign = -1;
                        if ( (c = nextchar(xbm_priv)) == -1 )
                                return S_ERROR_MINUS;
                        if ( !isdigit(c) )
                                return S_ERROR_NUMBER;
                        }
                if ( c == '0' )
                        {
                        xbm_priv->number = 0;
                        if ( (c = nextchar(xbm_priv)) == 'x' || c == 'X' )
                                /* Hex number */
                                {
                                while ( (c = nextchar(xbm_priv)) != -1 && isxdigit(c) )
                                        {
                                        xbm_priv->number <<= 4;
                                        xbm_priv->number += valof(c);
                                        }
                                }
                        else
                                /* Octal number */
                                while ( c != -1 && c >= '0' && c <= '7' )
                                        {
                                        xbm_priv->number <<= 3;
                                        xbm_priv->number += ( c - '0' );
                                        c = nextchar(xbm_priv);
                                        }
                        }
                else
                        {
                        xbm_priv->number = ( c - '0' );
                        while ( (c = nextchar(xbm_priv)) != -1 && isdigit(c) )
                                {
                                xbm_priv->number *= 10;
                                xbm_priv->number += ( c - '0' );
                                }
                        }

                xbm_priv->number *= sign;

                pushchar(xbm_priv, c);
                return S_NUMBER;
                }

        i = 0;
        do
                xbm_priv->id[i++] = c;
        while ( (c = nextchar(xbm_priv)) != -1 && (isalnum(c) || c == '_') && i < MAX_ID );
        xbm_priv->id[i] = '\0';

        pushchar(xbm_priv, c);

        if ( !strcmp((const char*)xbm_priv->id, "#define") ) return S_DEFINE; // mjs
        if ( !strcmp((const char*)xbm_priv->id, "static" ) ) return S_STATIC;
        if ( !strcmp((const char*)xbm_priv->id, "char"   ) ) return S_CHAR  ;
        if ( !strcmp((const char*)xbm_priv->id, "short"  ) ) return S_SHORT ;

        if ( !isalnum(xbm_priv->id[0]) )
                return S_ERROR_ID;

        return S_ID;
        }
/*...e*/

/*...sxbm_qft:0:*/
GBM_ERR xbm_qft(GBMFT *gbmft)
        {
        *gbmft = xbm_gbmft;
        return GBM_ERR_OK;
        }
/*...e*/
/*...sxbm_rhdr:0:*/
GBM_ERR xbm_rhdr(char *fn, int fd, GBM *gbm, char *opt)
        {
        XBM_PRIV *xbm_priv = (XBM_PRIV *) gbm->priv;
        SYM sym;

        fn=fn; opt=opt; /* Suppress 'unref arg' compiler warnings */

        lseek(fd, 0L, SEEK_SET);

        xbm_priv->fd  = fd;
        xbm_priv->inx = 0;
        xbm_priv->cnt = 0;

        gbm->w   = -1;
        gbm->h   = -1;
        gbm->bpp = 1;

        while ( (sym = nextsym(xbm_priv)) == S_DEFINE )
                {
                char *p;

                if ( (sym = nextsym(xbm_priv)) != S_ID )
                        return GBM_ERR_XBM_EXP_ID;
                if ( (p = strrchr((char*)xbm_priv->id, '_')) != NULL )
                        p++;
                else
                        p = (char *) (xbm_priv->id);

                if ( !strcmp(p, "width") )
                        {
                        if ( (sym = nextsym(xbm_priv)) != S_NUMBER )
                                return GBM_ERR_XBM_EXP_NUMBER;
                        gbm->w = xbm_priv->number;
                        }
                else if ( !strcmp(p, "height") )
                        {
                        if ( (sym = nextsym(xbm_priv)) != S_NUMBER )
                                return GBM_ERR_XBM_EXP_NUMBER;
                        gbm->h = xbm_priv->number;
                        }
                else
                        {
                        if ( (sym = nextsym(xbm_priv)) != S_NUMBER )
                                return GBM_ERR_XBM_EXP_NUMBER;
                        }

                }

        if ( gbm->w == -1 || gbm->h == -1 )
                return GBM_ERR_BAD_SIZE;

        if ( sym == S_STATIC )
                sym = nextsym(xbm_priv);

        if ( sym == S_EOF )
                return GBM_ERR_XBM_UNEXP_EOF;

        switch ( sym )
                {
                case S_CHAR:
                        xbm_priv->size = 8;
                        break;
                case S_SHORT:
                        xbm_priv->size = 16;
                        break;
                default:
                        return GBM_ERR_XBM_EXP_CHAR;
                }

        if ( nextsym(xbm_priv) != S_ID )
                return GBM_ERR_XBM_EXP_ID;

        if ( nextsym(xbm_priv) != S_LSQR )
                return GBM_ERR_XBM_EXP_LSQR;

        if ( nextsym(xbm_priv) != S_RSQR )
                return GBM_ERR_XBM_EXP_RSQR;

        if ( nextsym(xbm_priv) != S_EQUALS )
                return GBM_ERR_XBM_EXP_EQUALS;

        if ( nextsym(xbm_priv) != S_LCUR )
                return GBM_ERR_XBM_EXP_LCUR;

        return GBM_ERR_OK;
        }
/*...e*/
/*...sxbm_rpal:0:*/
GBM_ERR xbm_rpal(int fd, GBM *gbm, GBMRGB *gbmrgb)
        {
        fd=fd; gbm=gbm; /* Suppress 'unref arg' compiler warnings */

        gbmrgb[0].r = 0xff;
        gbmrgb[0].g = 0xff;
        gbmrgb[0].b = 0xff; /* White background */
        gbmrgb[1].r = 0x00;
        gbmrgb[1].g = 0x00;
        gbmrgb[1].b = 0x00; /* Black background */
        return GBM_ERR_OK;
        }
/*...e*/
/*...sxbm_rdata:0:*/
GBM_ERR xbm_rdata(int fd, GBM *gbm, byte *data)
        {
        XBM_PRIV *xbm_priv = (XBM_PRIV *) gbm->priv;
        int stride = ( ( gbm->w * gbm->bpp + 31 ) / 32 ) * 4;
        int x, y;
        SYM sym;
        bool keep_going = true;

        fd=fd; /* Suppres 'unref arg' compiler warning */

        memset(data, 0, gbm->h * stride);
        data += ( (gbm->h - 1) * stride );

        switch ( xbm_priv->size )
                {
/*...s8:16:*/
case 8:
        for ( y = gbm->h - 1; keep_going && y >= 0; y--, data -= stride )
                for ( x = 0; keep_going && x < ((gbm->w + 7) >> 3); x++ )
                        if ( (sym = nextsym(xbm_priv)) == S_RCUR )
                                keep_going = false;
                        else if ( sym != S_NUMBER )
                                return GBM_ERR_XBM_EXP_NUMBER;
                        else
                                {
                                data[x] = rev_t[xbm_priv->number];

                                sym = nextsym(xbm_priv);
                                if ( sym == S_RCUR )
                                        keep_going = false;
                                else if ( sym != S_COMMA )
                                        return GBM_ERR_XBM_EXP_COMMA;
                                }
        break;
/*...e*/
/*...s16:16:*/
case 16:
        for ( y = gbm->h - 1; keep_going && y >= 0; y--, data -= stride )
                for ( x = 0; keep_going && x < ((gbm->w + 15) >> 4); x++ )
                        if ( (sym = nextsym(xbm_priv)) == S_RCUR )
                                keep_going = false;
                        else if ( sym != S_NUMBER )
                                return GBM_ERR_XBM_EXP_NUMBER;
                        else
                                {
                                data[x * 2    ] = rev_t[xbm_priv->number & 0xff];
                                data[x * 2 + 1] = rev_t[xbm_priv->number >> 8  ];

                                sym = nextsym(xbm_priv);
                                if ( sym == S_RCUR )
                                        keep_going = false;
                                else if ( sym != S_COMMA )
                                        return GBM_ERR_XBM_EXP_COMMA;
                                }
        break;
/*...e*/
                }

        if ( keep_going )
                if ( nextsym(xbm_priv) != S_RCUR )
                        return GBM_ERR_XBM_EXP_RCUR;

        if ( nextsym(xbm_priv) != S_SEMI )
                return GBM_ERR_XBM_EXP_SEMI;

        return GBM_ERR_OK;
        }
/*...e*/
/*...sxbm_w:0:*/
/*
Write darkest colour as 1s, lightest colour with 0s.
*/

GBM_ERR xbm_w(char *fn, int fd, GBM *gbm, GBMRGB *gbmrgb, byte *data, char *opt)
        {
        int stride = ((gbm->w * gbm->bpp + 31) / 32) * 4;
        int x, y, col = 0;
        char s[100+1], name[100+1], *dot, *p;
        int k0, k1, loc_xor;

        opt=opt; /* Suppress 'unref arg' compiler warning */

        /* Normally palette entry 0 brightest is usual */
        /* If not reverse all the bits */

        k0 = gbmrgb[0].r * 77 + gbmrgb[0].g * 151 + gbmrgb[0].b * 28;
        k1 = gbmrgb[1].r * 77 + gbmrgb[1].g * 151 + gbmrgb[1].b * 28;

        loc_xor = ( k0 > k1 ) ? 0 : 0xff;

        /* Make the name from the filename, without the extension */

        strncpy(name, fn, 100);
        if ( (dot = strrchr(name, '.')) != NULL )
                *dot = '\0';

        /* Nobble any potentially nasty characters */

        if ( !isalpha(*name) )
                *name = '_';
        for ( p = name + 1; *p; p++ )
                if ( !isalnum(*p) )
                        *p = '_';

        sprintf(s, "#define %s_width %d\r\n" , name, gbm->w);
        if ( write(fd, s, strlen(s)) != strlen(s) )
                return GBM_ERR_WRITE;
        sprintf(s, "#define %s_height %d\r\n", name, gbm->h);
        if ( write(fd, s, strlen(s)) != strlen(s) )
                return GBM_ERR_WRITE;
        sprintf(s, "static char %s_bits[] = {\r\n", name);
        if ( write(fd, s, strlen(s)) != strlen(s) )
                return GBM_ERR_WRITE;

        data += (gbm->h - 1) * stride;
        for ( y = gbm->h - 1; y >= 0; y--, data -= stride )
                for ( x = 0; x < ((gbm->w + 7) >> 3); x++ )
                        {
                        sprintf(s, "0x%02x,", rev_t[data[x]] ^ loc_xor);
                        col += 5;
                        if ( col > 70 )
                                {
                                strcat(s, "\r\n");
                                col = 0;
                                }
                        if ( write(fd, s, strlen(s)) != strlen(s) )
                                return GBM_ERR_WRITE;
                        }

        if ( col )
                {
                if ( write(fd, "\r\n", 2) != 2 )
                        return GBM_ERR_WRITE;
                }

        if ( write(fd, "};\r\n", 4) != 4 )
                return GBM_ERR_WRITE;

        return GBM_ERR_OK;
        }
/*...e*/
/*...sxbm_err:0:*/
unsigned long xbm_err(GBM_ERR rc)
        {
        switch ( (int) rc )
                {
                case GBM_ERR_XBM_EXP_ID:
                        return IC_GBM_XBM_EXP_ID;
                case GBM_ERR_XBM_UNEXP_EOF:
                        return IC_GBM_XBM_UNEXP_EOF;
                case GBM_ERR_XBM_EXP_CHAR:
                        return IC_GBM_XBM_EXP_CHAR;
                case GBM_ERR_XBM_EXP_LSQR:
                        return IC_GBM_XBM_EXP_LSQR;
                case GBM_ERR_XBM_EXP_RSQR:
                        return IC_GBM_XBM_EXP_RSQR;
                case GBM_ERR_XBM_EXP_EQUALS:
                        return IC_GBM_XBM_EXP_EQUALS;
                case GBM_ERR_XBM_EXP_LCUR:
                        return IC_GBM_XBM_EXP_LCUR;
                case GBM_ERR_XBM_EXP_RCUR:
                        return IC_GBM_XBM_EXP_RCUR;
                case GBM_ERR_XBM_EXP_COMMA:
                        return IC_GBM_XBM_EXP_COMMA;
                case GBM_ERR_XBM_EXP_NUMBER:
                        return IC_GBM_XBM_EXP_NUMBER;
                case GBM_ERR_XBM_EXP_SEMI:
                        return IC_GBM_XBM_EXP_SEMI;
                }
        return 0;
        }
/*
*****************************************************************************************
*                                                                                       *
* COPYRIGHT:                                                                            *
*   IBM Open Class Library                                                              *
*   (C) Copyright International Business Machines Corporation,  1997                    *
*   Licensed Material - Program-Property of IBM - All Rights Reserved.                  *
*   US Government Users Restricted Rights - Use, duplication, or disclosure             *
*   restricted by GSA ADP Schedule Contract with IBM Corp.                              *
*                                                                                       *
*****************************************************************************************
*/
// Revision: 56 1.4.1.5 source/ographic/igbm.cpp, graphics, ioc.v400, 001006 
/*

IGBMSPR.C  Archimedes Sprite from RiscOS Format support

In Archimedes terminology, a sprite is a bitmap with an optional mask plane.

Reads a sprite from file created by *ScreenSave or *SSave command.
Will also write such a file containing a single sprite.

Input options: index=# (default: 0)

*/

#if 0
#pragma priority( -2147481424 )

/*...sincludes:0:*/
#include <stdio.h>
#include <ctype.h>
#include <stddef.h>
#include <stdlib.h>
#include <string.h>
#include <memory.h>
#include <malloc.h>
#ifdef AIX
#include <unistd.h>
#else
#include <io.h>
#endif
#include <fcntl.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <igbmstnd.hpp>
#include <igbm.hpp>
#include <igbmhelp.hpp>
#include <icconst.h>
#include <ibase.hpp>

// Segment definitions
#ifdef IC_PAGETUNE
  #define _IGBMSPR_CPP_
  #include <ipagetun.h>
#endif
#endif // 0

#ifndef min
#define min(a,b)        (((a)<(b))?(a):(b))
#endif
/*...e*/

#ifndef SUSEFUL_0
#define SUSEFUL_0

/*...suseful:0:*/
#define low_byte(w)     ((byte)  ((w)&0x00ff)    )
#define high_byte(w)    ((byte) (((w)&0xff00)>>8))
#define make_word(a,b)  (((word)a) + (((word)b) << 8))

/*...sread_word:0:*/
static bool read_word(int fd, word *w)
        {
        byte low = 0, high = 0;

        read(fd, (char *) &low, 1);
        read(fd, (char *) &high, 1);
        *w = (word) (low + ((word) high << 8));
        return true;
        }
/*...e*/
/*...sread_dword:0:*/
static bool read_dword(int fd, dword *d)
        {
        word low, high;

        read_word(fd, &low);
        read_word(fd, &high);
        *d = low + ((dword) high << 16);
        return true;
        }
/*...e*/
/*...swrite_word:0:*/
static bool write_word(int fd, word w)
        {
        byte low  = (byte) w;
        byte high = (byte) (w >> 8);

        return write(fd, &low, 1) == 1 && write(fd, &high, 1) == 1;
        }
/*...e*/
/*...swrite_dword:0:*/
static bool write_dword(int fd, dword d)
        {
        return write_word(fd, (word) d) && write_word(fd, (word) (d >> 16));
        }
/*...e*/
/*...e*/
#endif // SUSEFUL_0

static GBMFT spr_gbmft =
        {
        "Sprite",
        "Archimedes Sprite from RiscOS",
        "SPR SPRITE",
        GBM_FT_R1|GBM_FT_R4|GBM_FT_R8|
        GBM_FT_W1|GBM_FT_W4|GBM_FT_W8,
        };

#define GBM_ERR_SPR_FIRST       ((GBM_ERR) 1400)
#define GBM_ERR_SPR_MODE        ((GBM_ERR) 1401)
#define GBM_ERR_SPR_OFFSET      ((GBM_ERR) 1402)
#define GBM_ERR_SPR_PAL8        ((GBM_ERR) 1403)

typedef struct
        {
        long pos_palette, pos_image, pos_mask;
        dword bytes_per_line, first_bit, last_bit, actual_bpp;
        } SPR_PRIV;

/*...sbpp_of_mode\44\ mode_of_bpp:0:*/
static int bpp_of_mode[] =
        {
        1,      /*  0: 640x256 */
        2,      /*  1: 320x256 */
        4,      /*  2: 160x256 */
        -1,     /*  3: Text only */
        1,      /*  4: 320x256 */
        2,      /*  5: 160x256 */
        2,      /*  6: 160x256 */
        -1,     /*  7: Teletext */
        2,      /*  8: 640x256 */
        4,      /*  9: 320x256 */
        8,      /* 10: 160x256 */
        2,      /* 11: 640x250 */
        4,      /* 12: 640x256 */
        8,      /* 13: 320x256 */
        4,      /* 14: 640x250 */
        8,      /* 15: 640x256 */
        4,      /* 16: 1056x250 */
        4,      /* 17: 1056x256 */
        1,      /* 18: 640x512 multisync-monitor */
        2,      /* 19: 640x512 multisync-monitor */
        4,      /* 20: 640x512 multisync-monitor */
        8,      /* 21: 640x512 multisync-monitor */
        -1,     /* 22: ? */
        1,      /* 23: 1152x896 61.2Hz-hires-montor */
        8,      /* 24: 1056x256 */
        1,      /* 25: 640x480 multisync-or-60Hz-VGA-monitor */
        2,      /* 26: 640x480 multisync-or-60Hz-VGA-monitor */
        4,      /* 27: 640x480 multisync-or-60Hz-VGA-monitor */
        8,      /* 28: 640x480 multisync-or-60Hz-VGA-monitor */
        };

#define N_MODES 29

/* Return highest resolution mode for given bits per pixel. */

static int mode_of_bpp[] = { -1,23,-1,-1,17,-1,-1,-1,24 };
/*...e*/
/*...squick tables:0:*/
/* These are to account for the reverse ordering of pixels in a scan line. */

static byte nibble_swap[0x100] =
        {
        0x00,0x10,0x20,0x30,0x40,0x50,0x60,0x70,
        0x80,0x90,0xa0,0xb0,0xc0,0xd0,0xe0,0xf0,
        0x01,0x11,0x21,0x31,0x41,0x51,0x61,0x71,
        0x81,0x91,0xa1,0xb1,0xc1,0xd1,0xe1,0xf1,
        0x02,0x12,0x22,0x32,0x42,0x52,0x62,0x72,
        0x82,0x92,0xa2,0xb2,0xc2,0xd2,0xe2,0xf2,
        0x03,0x13,0x23,0x33,0x43,0x53,0x63,0x73,
        0x83,0x93,0xa3,0xb3,0xc3,0xd3,0xe3,0xf3,
        0x04,0x14,0x24,0x34,0x44,0x54,0x64,0x74,
        0x84,0x94,0xa4,0xb4,0xc4,0xd4,0xe4,0xf4,
        0x05,0x15,0x25,0x35,0x45,0x55,0x65,0x75,
        0x85,0x95,0xa5,0xb5,0xc5,0xd5,0xe5,0xf5,
        0x06,0x16,0x26,0x36,0x46,0x56,0x66,0x76,
        0x86,0x96,0xa6,0xb6,0xc6,0xd6,0xe6,0xf6,
        0x07,0x17,0x27,0x37,0x47,0x57,0x67,0x77,
        0x87,0x97,0xa7,0xb7,0xc7,0xd7,0xe7,0xf7,
        0x08,0x18,0x28,0x38,0x48,0x58,0x68,0x78,
        0x88,0x98,0xa8,0xb8,0xc8,0xd8,0xe8,0xf8,
        0x09,0x19,0x29,0x39,0x49,0x59,0x69,0x79,
        0x89,0x99,0xa9,0xb9,0xc9,0xd9,0xe9,0xf9,
        0x0a,0x1a,0x2a,0x3a,0x4a,0x5a,0x6a,0x7a,
        0x8a,0x9a,0xaa,0xba,0xca,0xda,0xea,0xfa,
        0x0b,0x1b,0x2b,0x3b,0x4b,0x5b,0x6b,0x7b,
        0x8b,0x9b,0xab,0xbb,0xcb,0xdb,0xeb,0xfb,
        0x0c,0x1c,0x2c,0x3c,0x4c,0x5c,0x6c,0x7c,
        0x8c,0x9c,0xac,0xbc,0xcc,0xdc,0xec,0xfc,
        0x0d,0x1d,0x2d,0x3d,0x4d,0x5d,0x6d,0x7d,
        0x8d,0x9d,0xad,0xbd,0xcd,0xdd,0xed,0xfd,
        0x0e,0x1e,0x2e,0x3e,0x4e,0x5e,0x6e,0x7e,
        0x8e,0x9e,0xae,0xbe,0xce,0xde,0xee,0xfe,
        0x0f,0x1f,0x2f,0x3f,0x4f,0x5f,0x6f,0x7f,
        0x8f,0x9f,0xaf,0xbf,0xcf,0xdf,0xef,0xff,
        };
static byte bit_swap[0x100] =
        {
        0x00,0x80,0x40,0xc0,0x20,0xa0,0x60,0xe0,
        0x10,0x90,0x50,0xd0,0x30,0xb0,0x70,0xf0,
        0x08,0x88,0x48,0xc8,0x28,0xa8,0x68,0xe8,
        0x18,0x98,0x58,0xd8,0x38,0xb8,0x78,0xf8,
        0x04,0x84,0x44,0xc4,0x24,0xa4,0x64,0xe4,
        0x14,0x94,0x54,0xd4,0x34,0xb4,0x74,0xf4,
        0x0c,0x8c,0x4c,0xcc,0x2c,0xac,0x6c,0xec,
        0x1c,0x9c,0x5c,0xdc,0x3c,0xbc,0x7c,0xfc,
        0x02,0x82,0x42,0xc2,0x22,0xa2,0x62,0xe2,
        0x12,0x92,0x52,0xd2,0x32,0xb2,0x72,0xf2,
        0x0a,0x8a,0x4a,0xca,0x2a,0xaa,0x6a,0xea,
        0x1a,0x9a,0x5a,0xda,0x3a,0xba,0x7a,0xfa,
        0x06,0x86,0x46,0xc6,0x26,0xa6,0x66,0xe6,
        0x16,0x96,0x56,0xd6,0x36,0xb6,0x76,0xf6,
        0x0e,0x8e,0x4e,0xce,0x2e,0xae,0x6e,0xee,
        0x1e,0x9e,0x5e,0xde,0x3e,0xbe,0x7e,0xfe,
        0x01,0x81,0x41,0xc1,0x21,0xa1,0x61,0xe1,
        0x11,0x91,0x51,0xd1,0x31,0xb1,0x71,0xf1,
        0x09,0x89,0x49,0xc9,0x29,0xa9,0x69,0xe9,
        0x19,0x99,0x59,0xd9,0x39,0xb9,0x79,0xf9,
        0x05,0x85,0x45,0xc5,0x25,0xa5,0x65,0xe5,
        0x15,0x95,0x55,0xd5,0x35,0xb5,0x75,0xf5,
        0x0d,0x8d,0x4d,0xcd,0x2d,0xad,0x6d,0xed,
        0x1d,0x9d,0x5d,0xdd,0x3d,0xbd,0x7d,0xfd,
        0x03,0x83,0x43,0xc3,0x23,0xa3,0x63,0xe3,
        0x13,0x93,0x53,0xd3,0x33,0xb3,0x73,0xf3,
        0x0b,0x8b,0x4b,0xcb,0x2b,0xab,0x6b,0xeb,
        0x1b,0x9b,0x5b,0xdb,0x3b,0xbb,0x7b,0xfb,
        0x07,0x87,0x47,0xc7,0x27,0xa7,0x67,0xe7,
        0x17,0x97,0x57,0xd7,0x37,0xb7,0x77,0xf7,
        0x0f,0x8f,0x4f,0xcf,0x2f,0xaf,0x6f,0xef,
        0x1f,0x9f,0x5f,0xdf,0x3f,0xbf,0x7f,0xff,
        };

static byte pair_swap[0x10] =
        {
        0x00,0x10,0x20,0x30,0x01,0x11,0x21,0x31,
        0x02,0x12,0x22,0x32,0x03,0x13,0x23,0x33,
        };
/*...e*/

/*...sspr_qft:0:*/
GBM_ERR spr_qft(GBMFT *gbmft)
        {
        *gbmft = spr_gbmft;
        return GBM_ERR_OK;
        }
/*...e*/
/*...sspr_rhdr:0:*/
GBM_ERR spr_rhdr(char *fn, int fd, GBM *gbm, char *opt)
        {
        SPR_PRIV *priv = (SPR_PRIV *) gbm->priv;
        char *index;
        int i;
        dword num_sprites, offset_sprite, pos_sprite;
        dword dword_w, scans_h, first_bit, last_bit, bits_per_line;
        dword offset_image, offset_mask, mode;

        fn=fn; /* Suppress 'unref arg' compiler warnings */

        lseek(fd, 0L, SEEK_SET);

        if ( (index = gbm_find_word_prefix(opt, "index=")) != NULL )
                sscanf(index + 6, "%d", &i);
        else
                i = 0;

        read_dword(fd, &num_sprites);
        if ( i >= num_sprites )
                return GBM_ERR_SPR_OFFSET;
        read_dword(fd, &offset_sprite);
        pos_sprite = lseek(fd, offset_sprite - 4L, SEEK_SET);

        while ( i-- > 0 )
                {
                read_dword(fd, &offset_sprite);
                pos_sprite = lseek(fd, pos_sprite + offset_sprite, SEEK_SET);
                }

        lseek(fd, 16, SEEK_CUR);        /* Skip 4 byte next-ptr + 12 byte name */
        read_dword(fd, &dword_w);       /* Width in dwords - 1 */
        read_dword(fd, &scans_h);       /* Scan lines high - 1 */
        read_dword(fd, &first_bit);     /* First bit used (left end of row) */
        read_dword(fd, &last_bit);      /* Last bit used (right end of row) */
        read_dword(fd, &offset_image);  /* Offset of image data */
        read_dword(fd, &offset_mask);   /* Offset of mask plane or above if none */
        read_dword(fd, &mode);          /* Mode sprite defined in */

        if ( first_bit & 7 )
                return GBM_ERR_SPR_FIRST;
        if ( mode >= N_MODES )
                return GBM_ERR_SPR_MODE;
        if ( (gbm->bpp = priv->actual_bpp = bpp_of_mode[mode]) == -1 )
                return GBM_ERR_SPR_MODE;

        gbm->h = (int) (scans_h+1);
        if ( gbm->h < 0 || gbm->h > 10000 )
                return GBM_ERR_BAD_SIZE;

        if ( gbm->bpp == 2 )
                gbm->bpp = 4;

        bits_per_line = ((dword_w+1) * 32) - first_bit - (32 - (last_bit+1));
        gbm->w = (int) (bits_per_line / priv->actual_bpp);
        if ( gbm->w < 0 || gbm->w > 10000 )
                return GBM_ERR_BAD_SIZE;

#ifdef IC_MOTIF
        priv->pos_palette    = lseek(fd, 0L, SEEK_CUR);

#else
        priv->pos_palette    = tell(fd);
#endif
        priv->pos_image      = (long) pos_sprite + offset_image;
        priv->pos_mask       = (long) pos_sprite + offset_mask;
        priv->bytes_per_line = (dword_w + 1) * 4;
        priv->first_bit      = first_bit;
        priv->last_bit       = last_bit;

        return GBM_ERR_OK;
        }
/*...e*/
/*...sspr_rpal:0:*/
/*...sread_pal:0:*/
/* Palette entry is 2 dwords, which are same if no flashing */
/* We will simply use first dword in each case */

static bool read_pal(int fd, GBMRGB *gbmrgb)
        {
        byte pal[8];
        if ( read(fd, pal, 8) != 8 )
                return false;
        gbmrgb->r = pal[1];
        gbmrgb->g = pal[2];
        gbmrgb->b = pal[3];
        return true;
        }
/*...e*/

/*...sgbmrgb_1bpp:0:*/
/*
I do not expect the palette to be missing from a file defined in a mode with 2
colours because the Wimp uses 16 colours, and I am led to beleive it is the
only thing that saves files without the palette. However, if I am wrong...
*/

static GBMRGB gbmrgb_1bpp[2] =
        {
        {0xff,0xff,0xff},       /* 0=White */
        {0x00,0x00,0x00},       /* 1=black */
        };
/*...e*/
/*...sgbmrgb_2bpp:0:*/
/*
I do not expect the palette to be missing from a file defined in a mode with 4
colours because the Wimp uses 16 colours, and I am led to beleive it is the
only thing that saves files without the palette. However, if I am wrong...
*/

static GBMRGB gbmrgb_2bpp[4] =
        {
        {0xff,0xff,0xff},
        {0xaa,0xaa,0xaa},
        {0x55,0x55,0x55},
        {0x00,0x00,0x00},
        };
/*...e*/
/*...sgbmrgb_4bpp:0:*/
/*
This is the default Wimp defined 16 colour palette.
The exact r,g,b values are not known so some nice bold examples of each,
according to their descriptions in the RiscOS books have been found manually.
*/

static GBMRGB gbmrgb_4bpp[16] =
        {
        {0xff,0xff,0xff},       /* 0=white */
        {0xdb,0xdb,0xdb},       /* 1=grey */
        {0xb6,0xb6,0xb6},       /* 2=grey */
        {0x92,0x92,0x92},       /* 3=grey */
        {0x6d,0x6d,0x6d},       /* 4=grey */
        {0x49,0x49,0x49},       /* 5=grey */
        {0x24,0x24,0x24},       /* 6=grey */
        {0x00,0x00,0x00},       /* 7=black */
        {0x00,0x00,0xff},       /* 8=dark blue */
        {0xff,0xff,0x00},       /* 9=yellow */
        {0x00,0xff,0x00},       /* a=green */
        {0xff,0x00,0x00},       /* b=red */
        {0xff,0xd8,0xd8},       /* c=cream */
        {0x40,0x80,0x40},       /* d=army green */
        {0xff,0x9c,0x00},       /* e=orange */
        {0x00,0xb9,0xff},       /* f=light blue */
        };
/*...e*/
/*...sexpand_0x10:0:*/
/*
The Archimedes does not have 0x100 palette registers, it has 0x10 VIDC registers.
Given an 8 bit pixel :-
        Bits 3-0 are bits 3-0 of palette index
        Bit 4 overrides red bit 7
        Bit 5 overrides green bit 6
        Bit 6 overrides green bit 7
        Bit 7 overrides blue bit 7
So we duplicate the 0x10 values we have read, and make the others from them.
*/

static void expand_0x10(GBMRGB *gbmrgb)
        {
        int i, bank;

        for ( bank = 0x10; bank < 0x100; bank += 0x10 )
                {
                byte override_r = ((bank & 0x10) << 3);
                byte override_g = ((bank & 0x60) << 1);
                byte override_b =  (bank & 0x80)      ;
                for ( i = 0; i < 0x10; i++ )
                        {
                        gbmrgb[bank + i].r = ((gbmrgb[i].r & 0x7f) | override_r);
                        gbmrgb[bank + i].g = ((gbmrgb[i].g & 0x3f) | override_g);
                        gbmrgb[bank + i].b = ((gbmrgb[i].b & 0x7f) | override_b);
                        }
                }
        }
/*...e*/
/*...sexpand_0x40:0:*/
/*
The Archimedes does not have 0x100 palette registers, it has 0x10.
Planning for the future, files can be written with 0x40 palette entries.
Given an 8 bit pixel :-
        Bits 5-0 are bits 5-0 of palette index
        Bit 6 overrides green bit 7
        Bit 7 overrides blue bit 7
So we duplicate the 0x40 values we have read, and make the others from them.
Now, although we have seen files with 0x40 entries, when you take the first
0x10, and perform expand_0x10 on them, the result is the same as this routine.
Clearly Acorn are looking forward to a day when the VIDC chip has 0x40
registers.
*/

static void expand_0x40(GBMRGB *gbmrgb)
        {
        int i, bank;

        for ( bank = 0; bank < 0x100; bank += 0x40 )
                {
                byte override_g = ((bank & 0x40) << 1);
                byte override_b =  (bank & 0x80)      ;
                for ( i = 0; i < 0x40; i++ )
                        {
                        gbmrgb[bank + i].r =   gbmrgb[i].r;
                        gbmrgb[bank + i].g = ((gbmrgb[i].g & 0x7f) | override_g);
                        gbmrgb[bank + i].b = ((gbmrgb[i].b & 0x7f) | override_b);
                        }
                }
        }
/*...e*/

GBM_ERR spr_rpal(int fd, GBM *gbm, GBMRGB *gbmrgb)
        {
        SPR_PRIV *priv = (SPR_PRIV *) gbm->priv;
        int npal = (priv->pos_image - priv->pos_palette) / 8;

        if ( npal == 0 )
/*...sno palette in file\44\ use the default Wimp one:16:*/
switch ( priv->actual_bpp )
        {
        case 1: memcpy(gbmrgb, gbmrgb_1bpp, sizeof(gbmrgb_1bpp)); break;
        case 2: memcpy(gbmrgb, gbmrgb_2bpp, sizeof(gbmrgb_2bpp)); break;
        case 4: memcpy(gbmrgb, gbmrgb_4bpp, sizeof(gbmrgb_4bpp)); break;
        case 8:
/*...sdefault palette:32:*/
{
int i;
for ( i = 0; i < 0x10; i++ )
        {
        byte tint = ((i & 0x03) << 4);
        gbmrgb[i].r = tint + ((i & 0x04) << 4);
        gbmrgb[i].g = tint;
        gbmrgb[i].b = tint + ((i & 0x08) << 3);
        }
expand_0x10(gbmrgb);
}
/*...e*/
                break;
        }

/*...e*/
        else
/*...sread palette from disk:16:*/
{
int i;
lseek(fd, priv->pos_palette, SEEK_SET);
for ( i = 0; i < npal; i++ )
        if ( !read_pal(fd, gbmrgb + i) )
                return GBM_ERR_READ;

if ( gbm->bpp == 8 )
        /* Handle getting too few palette entries */
        {
        if ( npal == 0x40 )
                expand_0x40(gbmrgb);
        else if ( npal == 0x10 )
                expand_0x10(gbmrgb);
        else
                return GBM_ERR_SPR_PAL8;
        }
}
/*...e*/

        return GBM_ERR_OK;
        }
/*...e*/
/*...sspr_rdata:0:*/
GBM_ERR spr_rdata(int fd, GBM *gbm, byte *data)
        {
        int stride = ((gbm->bpp * gbm->w + 31) / 32) * 4;
        SPR_PRIV *priv = (SPR_PRIV *) gbm->priv;
        int scan_stride = priv->bytes_per_line;
        int scan_first = ((priv->first_bit) >> 3);
        int scan_bytes, i, j;
        byte *datal = data + (gbm->h - 1) * stride;

        lseek(fd, priv->pos_image, SEEK_SET);

        switch ( priv->actual_bpp )
                {
/*...s8 \45\ read mapped pixels:16:*/
case 8:
        scan_bytes = gbm->w;
        for ( j = 0; j < gbm->h; j++, datal -= stride )
                {
                lseek(fd, priv->pos_image + j * scan_stride + scan_first, SEEK_SET);
                if ( read(fd, datal, scan_bytes) != scan_bytes )
                        return GBM_ERR_READ;
                }
        break;
/*...e*/
/*...s4 \45\ read pixels\44\ nibble swapping:16:*/
case 4:
        scan_bytes = ((gbm->w + 1) >> 1);
        for ( j = 0; j < gbm->h; j++, datal -= stride )
                {
                lseek(fd, priv->pos_image + j * scan_stride + scan_first, SEEK_SET);
                if ( read(fd, datal, scan_bytes) != scan_bytes )
                        return GBM_ERR_READ;
                for ( i = 0; i < scan_bytes; i++ )
                        datal[i] = nibble_swap[datal[i]];
                }
        break;
/*...e*/
/*...s2 \45\ read pixels\44\ bit\45\pair reversing and expanding:16:*/
/*
Data is coming in a 2bpp, but we don't actually support this.
So we will expand the data to 4bpp as we read it.
We will do this inline, by reading into the second half.
*/

case 2:
        scan_bytes = ((gbm->w + 3) >> 2);
        for ( j = 0; j < gbm->h; j++, datal -= stride )
                {
                lseek(fd, priv->pos_image + j * scan_stride + scan_first, SEEK_SET);
                if ( read(fd, datal + scan_bytes, scan_bytes) != scan_bytes )
                        return GBM_ERR_READ;
                for ( i = 0; i < scan_bytes; i++ )
                        {
                        datal[i * 2    ] = pair_swap[datal[scan_bytes + i] & 0x0f];
                        datal[i * 2 + 1] = pair_swap[datal[scan_bytes + i] >> 4  ];
                        }
                }
        break;
/*...e*/
/*...s1 \45\ read pixels\44\ bit reversing:16:*/
case 1:
        scan_bytes = ((gbm->w + 7) >> 3);
        for ( j = 0; j < gbm->h; j++, datal -= stride )
                {
                lseek(fd, priv->pos_image + j * scan_stride + scan_first, SEEK_SET);
                if ( read(fd, datal, scan_bytes) != scan_bytes )
                        return GBM_ERR_READ;
                for ( i = 0; i < scan_bytes; i++ )
                        datal[i] = bit_swap[datal[i]];
                }
        break;
/*...e*/
                }

        return GBM_ERR_OK;
        }
/*...e*/
/*...sspr_w:0:*/
/*
We have a problem here for 256 colour modes.
The 256 colours we are asked to write can be any colours and unrelated.
There are only 16 VIDC palette registers, and the other 4 bits in an 8 bit
byte override specific palette entry bits.
We will ignore all but the top 4 bits of each colour component. ie: just 7-4.
Therefore we will write a specifically fixed palette :-
        Bits 1 to 0 will be bits 5 and 4 for all 3 guns.
        Bit 2 will be red bit 6
        Bit 3 will be blue bit 6
        Bit 4 will be red bit 7
        Bit 5 will be green bit 6
        Bit 6 will be green bit 7
        Bit 7 will be blue bit 7
This is the default palette used by RiscOS.
We will map all incoming palette entrys first, to give a quick lookup table.
*/

/*...swrite_pal:0:*/
static bool write_pal(int fd, GBMRGB gbmrgb)
        {
        byte pal[8];
        int j;
        pal[0] = pal[4] = 0x00;
        pal[1] = pal[5] = (byte) (gbmrgb.r & 0xf0);
        pal[2] = pal[6] = (byte) (gbmrgb.g & 0xf0);
        pal[3] = pal[7] = (byte) (gbmrgb.b & 0xf0);
        for ( j = 0; j < 8; j++ )
                pal[j] += (pal[j] >> 4);
        return write(fd, pal, 8) == 8;
        }
/*...e*/

GBM_ERR spr_w(char *fn, int fd, GBM *gbm, GBMRGB *gbmrgb, byte *data, char *opt)
        {
        int stride = ((gbm->bpp * gbm->w + 31) / 32) * 4;
        int i, j, npal = ( 1 << gbm->bpp );
        dword dword_w, last_bit, offset_image, mode;
        char name[12];
        byte qpal[0x100], *buf;
        bool ok;

        opt=opt; /* Suppress 'unref arg' warning */

        if ( gbm->bpp == 24 )
                return GBM_ERR_NOT_SUPP;

        if ( npal == 0x100 )
                npal = 0x10;

        ok  = write_dword(fd, 1);               /* Number of sprites */
        ok &= write_dword(fd, 12 + 4);          /* Offset to sprite */
        ok &= write_dword(fd, (12 + 44 + npal * 8 + stride * gbm->h) + 4);
                                                /* Offset to free word (beyond sprites) */
        ok &= write_dword(fd, 44 + npal * 8 + stride * gbm->h);

/*...sbuild a name:8:*/
/*
We will use the supplied filename to build the name field.
We will ignore the path part (if any present).
Also we will chop of the file extension of .spr if present.
(This change was by customer request).
Also, map to lower case to keep RiscOS programs happy.
This isn't documented, but appears to be the case.
*/

{
char *p = fn, *q;
if ( (q = strrchr(p, '\\')) != NULL )
        p = q + 1;
if ( (q = strrchr(p, '/')) != NULL )
        p = q + 1;
memset(name, 0, 12);
strncpy(name, p, 11);
if ( (q = strrchr(name, '.')) != NULL && gbm_same(q + 1, "spr", 4) )
        memset(q, '\0', 4);
for ( p = name; (p - name) < 12 && *p != '\0'; p++ )
        *p = tolower(*p);
}
/*...e*/
        ok &= ( write(fd, name, 12) == 12 );

        dword_w = ((gbm->w * gbm->bpp + 31) / 32) - 1;
        ok &= write_dword(fd, dword_w);         /* Width in dwords - 1 */
        ok &= write_dword(fd, gbm->h - 1);      /* Scan lines high - 1 */
        ok &= write_dword(fd, 0);               /* First bit used (left end of row) */
        last_bit = ((gbm->w * gbm->bpp - 1) & 0x1f);
        ok &= write_dword(fd, last_bit);        /* Last bit used (right end of row) */
        offset_image = ( 44 + npal * 8 );
        ok &= write_dword(fd, offset_image);    /* Offset of image data */
        ok &= write_dword(fd, offset_image);    /* Offset of mask plane or above if none */
        mode = mode_of_bpp[gbm->bpp];
        ok &= write_dword(fd, mode);            /* Mode sprite defined in */

        if ( !ok )
                return GBM_ERR_WRITE;

        /* Write palette */

        switch ( gbm->bpp )
                {
/*...s8 \45\ write RiscOS default palette\44\ and work out mapping:16:*/
case 8:

        /* Write the fixed RiscOS default palette */
        for ( i = 0; i < 0x10; i++ )
                {
                GBMRGB gbmrgb_def;
                byte tint = ((i & 0x03) << 4);
                gbmrgb_def.r = tint + ((i & 0x04) << 4);
                gbmrgb_def.g = tint;
                gbmrgb_def.b = tint + ((i & 0x08) << 3);
                if ( !write_pal(fd, gbmrgb_def) )
                        return GBM_ERR_WRITE;
                }

        /* Determine palette mapping */
        for ( i = 0; i < 0x100; i++ )
                {
                byte r = gbmrgb[i].r;
                byte g = gbmrgb[i].g;
                byte b = gbmrgb[i].b;
                byte k32 = ((((r & 0x30) + (g & 0x30) + (b & 0x30)) / 3) & 0x30);
                qpal[i] =  (b & 0x80)       +
                           ((g & 0xc0) >> 1) +
                           ((r & 0x80) >> 3) +
                           ((b & 0x40) >> 3) +
                           ((r & 0x40) >> 4) +
                           (k32 >> 4);
                }
        break;
/*...e*/
/*...s4\44\1 \45\ write 16 or 2 entry palette:16:*/
case 4:
case 1:
        /* Write the palette */
        for ( i = 0; i < (1 << gbm->bpp); i++ )
                if ( !write_pal(fd, gbmrgb[i]) )
                        return GBM_ERR_WRITE;
        break;
/*...e*/
                }

        /* Write data */

        if ( (buf = (byte*)malloc(stride)) == NULL )
                return GBM_ERR_MEM;
        memset(buf, 0, stride);

        data += (gbm->h - 1) * stride; /* Start at the top */
        switch ( gbm->bpp )
                {
/*...s8 \45\ write mapped pixels\44\ funny order:16:*/
case 8:
        for ( j = 0; j < gbm->h; j++, data -= stride )
                {
                for ( i = 0; i < stride; i++ )
                        buf[i] = qpal[data[i]];
                if ( write(fd, buf, stride) != stride )
                        {
                        free(buf);
                        return GBM_ERR_WRITE;
                        }
                }
        break;
/*...e*/
/*...s4 \45\ write pixels\44\ funny order:16:*/
case 4:
        for ( j = 0; j < gbm->h; j++, data -= stride )
                {
                for ( i = 0; i < stride; i++ )
                        buf[i] = nibble_swap[data[i]];
                if ( write(fd, buf, stride) != stride )
                        {
                        free(buf);
                        return GBM_ERR_WRITE;
                        }
                }
        break;
/*...e*/
/*...s1 \45\ write pixels\44\ funny order:16:*/
case 1:
        for ( j = 0; j < gbm->h; j++, data -= stride )
                {
                for ( i = 0; i < stride; i++ )
                        buf[i] = bit_swap[data[i]];
                if ( write(fd, buf, stride) != stride )
                        {
                        free(buf);
                        return GBM_ERR_WRITE;
                        }
                }
        break;
/*...e*/
                }

        free(buf);

        return GBM_ERR_OK;
        }
/*...e*/
/*...sspr_err:0:*/
unsigned long spr_err(GBM_ERR rc)
        {
        switch ( (int) rc )
                {
                case GBM_ERR_SPR_FIRST:
                        return IC_GBM_SPR_FIRST;
                case GBM_ERR_SPR_MODE:
                        return IC_GBM_SPR_MODE;
                case GBM_ERR_SPR_OFFSET:
                        return IC_GBM_SPR_OFFSET;
                case GBM_ERR_SPR_PAL8:
                        return IC_GBM_SPR_PAL8;
                }
        return 0;
        }
/*
*****************************************************************************************
*                                                                                       *
* COPYRIGHT:                                                                            *
*   IBM Open Class Library                                                              *
*   (C) Copyright International Business Machines Corporation,  1997                    *
*   Licensed Material - Program-Property of IBM - All Rights Reserved.                  *
*   US Government Users Restricted Rights - Use, duplication, or disclosure             *
*   restricted by GSA ADP Schedule Contract with IBM Corp.                              *
*                                                                                       *
*****************************************************************************************
*/
// Revision: 56 1.4.1.5 source/ographic/igbm.cpp, graphics, ioc.v400, 001006 
/*

IGBMPSG.C  PSEG support

Reads and writes PSEG files.
Input options: fixrec (attempt to handle corrupt record structure)
Output options: double (will double scale factor in header)

This code was written using a subset of the full documentation.
The missing bits were filled in by reverse engineering a selection of files.
Guesses as to which records are important were made (BeginPageSegment etc.)
and these seem to correspond with other conversion programs choices.
Also image (and cell) widths and heights can apparently be any value, although
all PSEGs I have seen always use a multiple of 8 (and 32). This code will allow
any width that is a multiple of 8 (for easy coding), and any height at all.

When a PSEG is uploaded to VM, it must have its VM FILE block record structure
reestablished. Various VM EXECs exist to do this, such as FIXL3820, REFLOW, and
REST38PP, although in my experience, FIXL3820 always works, and REST38PP always
fails for large files.

*/

#if 0
#pragma priority( -2147481424 )

/*...sincludes:0:*/
#include <stdio.h>
#include <ctype.h>
#include <stddef.h>
#include <stdlib.h>
#include <string.h>
#include <memory.h>
#include <malloc.h>
#ifdef AIX
#include <unistd.h>
#else
#include <io.h>
#endif
#include <fcntl.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <igbmstnd.hpp>
#include <igbm.hpp>
#include <igbmhelp.hpp>
#include <icconst.h>
#include <ibase.hpp>

// Segment definitions
#ifdef IC_PAGETUNE
  #define _IGBMPSG_CPP_
  #include <ipagetun.h>
#endif
#endif // 0

/*...vgbm\46\h:0:*/
/*...vgbmhelp\46\h:0:*/

#ifndef min
#define min(a,b)        (((a)<(b))?(a):(b))
#endif
/*...e*/

/*...suseful:0:*/
#define low_byte(w)     ((byte)  ((w)&0x00ff)    )
#define high_byte(w)    ((byte) (((w)&0xff00)>>8))
#define make_word(a,b)  (((word)a) + (((word)b) << 8))
/*...e*/

static GBMFT psg_gbmft =
        {
        "PSEG",
        "IBM Printer Page Segment",
        "PSE PSEG PSEG38PP PSEG3820",
        GBM_FT_R1|
        GBM_FT_W1,
        };

#define GBM_ERR_PSEG_NOT_5A     ((GBM_ERR) 1600)
#define GBM_ERR_PSEG_BAD_RECORD ((GBM_ERR) 1601)
#define GBM_ERR_PSEG_SIZE       ((GBM_ERR) 1602)
#define GBM_ERR_PSEG_INV_WIDTH  ((GBM_ERR) 1603)
#define GBM_ERR_PSEG_INV_DEFCEL ((GBM_ERR) 1604)
#define GBM_ERR_PSEG_INV_CEL    ((GBM_ERR) 1605)
#define GBM_ERR_PSEG_INV_CELPOS ((GBM_ERR) 1606)
#define GBM_ERR_PSEG_UNEX_REC   ((GBM_ERR) 1607)

typedef struct
        {
        long pos;
        int xcellsizedef, ycellsizedef;
        bool fix_badrec;
        } PSEG_PRIV;

/*...smax:0:*/
#ifndef max
#define max(a,b) (((a)>(b))?(a):(b))
#endif
/*...e*/
/*...sascii \47\ ebcdic:0:*/
#ifdef NEVER
/*...sebcdic_to_ascii:0:*/
static byte ebcdic_to_ascii[0x100] =
        {
        0x00,0x01,0x02,0x03,0xcf,0x09,0xd3,0x7f,
        0xd4,0xd5,0xc3,0x0b,0x0c,0x0d,0x0e,0x0f,
        0x10,0x11,0x12,0x13,0xc7,0xb4,0x08,0xc9,
        0x18,0x19,0xcc,0xcd,0x83,0x1d,0xd2,0x1f,
        0x81,0x82,0x1c,0x84,0x86,0x0a,0x17,0x1b,
        0x89,0x91,0x92,0x95,0xa2,0x05,0x06,0x07,
        0xe0,0xee,0x16,0xe5,0xd0,0x1e,0xea,0x04,
        0x8a,0xf6,0xc6,0xc2,0x14,0x15,0xc1,0x1a,
        0x20,0xa6,0xe1,0x80,0xeb,0x90,0x9f,0xe2,
        0xab,0x8b,0x9b,0x2e,0x3c,0x28,0x2b,0x7c,
        0x26,0xa9,0xaa,0x9c,0xdb,0xa5,0x99,0xe3,
        0xa8,0x9e,0x21,0x24,0x2a,0x29,0x3b,0x5e,
        0x2d,0x2f,0xdf,0xdc,0x9a,0xdd,0xde,0x98,
        0x9d,0xac,0xba,0x2c,0x25,0x5f,0x3e,0x3f,
        0xd7,0x88,0x94,0xb0,0xb1,0xb2,0xfc,0xd6,
        0xfb,0x60,0x3a,0x23,0x40,0x27,0x3d,0x22,
        0xf8,0x61,0x62,0x63,0x64,0x65,0x66,0x67,
        0x68,0x69,0x96,0xa4,0xf3,0xaf,0xae,0xc5,
        0x8c,0x6a,0x6b,0x6c,0x6d,0x6e,0x6f,0x70,
        0x71,0x72,0x97,0x87,0xce,0x93,0xf1,0xfe,
        0xc8,0x7e,0x73,0x74,0x75,0x76,0x77,0x78,
        0x79,0x7a,0xef,0xc0,0xda,0x5b,0xf2,0xf9,
        0xb5,0xb6,0xfd,0xb7,0xb8,0xb9,0xe6,0xbb,
        0xbc,0xbd,0x8d,0xd9,0xbf,0x5d,0xd8,0xc4,
        0x7b,0x41,0x42,0x43,0x44,0x45,0x46,0x47,
        0x48,0x49,0xcb,0xca,0xbe,0xe8,0xec,0xed,
        0x7d,0x4a,0x4b,0x4c,0x4d,0x4e,0x4f,0x50,
        0x51,0x52,0xa1,0xad,0xf5,0xf4,0xa3,0x8f,
        0x5c,0xe7,0x53,0x54,0x55,0x56,0x57,0x58,
        0x59,0x5a,0xa0,0x85,0x8e,0xe9,0xe4,0xd1,
        0x30,0x31,0x32,0x33,0x34,0x35,0x36,0x37,
        0x38,0x39,0xb3,0xf7,0xf0,0xfa,0xa7,0xff,
        };
/*...e*/
#endif
/*...sascii_to_ebcdic:0:*/
static byte ascii_to_ebcdic[0x100] =
        {
        0x00,0x01,0x02,0x03,0x37,0x2d,0x2e,0x2f,
        0x16,0x05,0x25,0x0b,0x0c,0x0d,0x0e,0x0f,
        0x10,0x11,0x12,0x13,0x3c,0x3d,0x32,0x26,
        0x18,0x19,0x3f,0x27,0x22,0x1d,0x35,0x1f,
        0x40,0x5a,0x7f,0x7b,0x5b,0x6c,0x50,0x7d,
        0x4d,0x5d,0x5c,0x4e,0x6b,0x60,0x4b,0x61,
        0xf0,0xf1,0xf2,0xf3,0xf4,0xf5,0xf6,0xf7,
        0xf8,0xf9,0x7a,0x5e,0x4c,0x7e,0x6e,0x6f,
        0x7c,0xc1,0xc2,0xc3,0xc4,0xc5,0xc6,0xc7,
        0xc8,0xc9,0xd1,0xd2,0xd3,0xd4,0xd5,0xd6,
        0xd7,0xd8,0xd9,0xe2,0xe3,0xe4,0xe5,0xe6,
        0xe7,0xe8,0xe9,0xad,0xe0,0xbd,0x5f,0x6d,
        0x79,0x81,0x82,0x83,0x84,0x85,0x86,0x87,
        0x88,0x89,0x91,0x92,0x93,0x94,0x95,0x96,
        0x97,0x98,0x99,0xa2,0xa3,0xa4,0xa5,0xa6,
        0xa7,0xa8,0xa9,0xc0,0x4f,0xd0,0xa1,0x07,
        0x43,0x20,0x21,0x1c,0x23,0xeb,0x24,0x9b,
        0x71,0x28,0x38,0x49,0x90,0xba,0xec,0xdf,
        0x45,0x29,0x2a,0x9d,0x72,0x2b,0x8a,0x9a,
        0x67,0x56,0x64,0x4a,0x53,0x68,0x59,0x46,
        0xea,0xda,0x2c,0xde,0x8b,0x55,0x41,0xfe,
        0x58,0x51,0x52,0x48,0x69,0xdb,0x8e,0x8d,
        0x73,0x74,0x75,0xfa,0x15,0xb0,0xb1,0xb3,
        0xb4,0xb5,0x6a,0xb7,0xb8,0xb9,0xcc,0xbc,
        0xab,0x3e,0x3b,0x0a,0xbf,0x8f,0x3a,0x14,
        0xa0,0x17,0xcb,0xca,0x1a,0x1b,0x9c,0x04,
        0x34,0xef,0x1e,0x06,0x08,0x09,0x77,0x70,
        0xbe,0xbb,0xac,0x54,0x63,0x65,0x66,0x62,
        0x30,0x42,0x47,0x57,0xee,0x33,0xb6,0xe1,
        0xcd,0xed,0x36,0x44,0xce,0xcf,0x31,0xaa,
        0xfc,0x9e,0xae,0x8c,0xdd,0xdc,0x39,0xfb,
        0x80,0xaf,0xfd,0x78,0x76,0xb2,0x9f,0xff,
        };
/*...e*/

static void ebcdic(char *dst, char *src)
        {
        while ( *src )
                *dst++ = ascii_to_ebcdic[*src++];
        }
/*...e*/
/*...sgetword:0:*/
static int getword(byte *c)
        {
        return (int) ( ((unsigned int) c[0] << 8) + (unsigned int) c[1] );
        }
/*...e*/
/*...sputword:0:*/
static void putword(char *c, int d)
        {
        c[0] = (char) (d>>8);
        c[1] = (char)  d    ;
        }
/*...e*/

/*...spsg_qft:0:*/
GBM_ERR psg_qft(GBMFT *gbmft)
        {
        *gbmft = psg_gbmft;
        return GBM_ERR_OK;
        }
/*...e*/
/*...spsg_rhdr:0:*/
GBM_ERR psg_rhdr(char *fn, int fd, GBM *gbm, char *opt)
        {
        PSEG_PRIV *psg_priv = (PSEG_PRIV *) gbm->priv;
        char buf[1+2+6];

        fn=fn; /* Suppress 'unref arg' compiler warnings */

        psg_priv->fix_badrec = ( gbm_find_word(opt, "fixrec") != NULL );

        lseek(fd, 0L, SEEK_SET);

        gbm->bpp =  1;
        gbm->w   = -1;

        while ( read(fd, buf, sizeof(buf)) == sizeof(buf) )
                {
                long seek_by; int f;
                if ( psg_priv->fix_badrec )
                        for ( f = 0; buf[0] != 0x5a && f < 10; f++ )
                                {
                                long pos = lseek(fd, 0L, SEEK_CUR);
                                if ( pos == 0L )
                                        break;
                                lseek(fd, pos - (sizeof(buf)+1), SEEK_SET);
                                read(fd, buf, sizeof(buf));
                                }
                if ( buf[0] != 0x5a )
                        return GBM_ERR_PSEG_NOT_5A;
                seek_by = (long) getword((unsigned char*)(buf+1))-(2+6);
                if      ( !memcmp(buf+1+2, "\xd3\xee\xee", 3) )
                        ; /* Comment record, ignore it */
                else if ( !memcmp(buf+1+2, "\xd3\xa8\x5f", 3) )
                        ; /* BeginPageSegment, ignore it */
                else if ( !memcmp(buf+1+2, "\xd3\xa8\x7b", 3) )
                        ; /* BeginImageBlock, ignore it */
                else if ( !memcmp(buf+1+2, "\xd3\xa7\x7b", 3) )
                        ; /* ImageOutputControl, ignore it */
                else if ( !memcmp(buf+1+2, "\xd3\xa6\x7b", 3) )
                        /* InputImageDescriptor, remember its info */
                        {
                        byte buf2[6+12+2+2+6+2+2+4];
                        if ( read(fd, buf2, sizeof(buf2)) != sizeof(buf2) )
                                return GBM_ERR_READ;
                        seek_by -= sizeof(buf2);
                        gbm->w = getword(buf2+6+12);
                        gbm->h = getword(buf2+6+12+2);
                        if ( gbm->w & 7 )
                                return GBM_ERR_PSEG_INV_WIDTH;
                        psg_priv->xcellsizedef = getword(buf2+6+12+2+2+6);
                        psg_priv->ycellsizedef = getword(buf2+6+12+2+2+6+2);
                        if ( psg_priv->xcellsizedef == 0 &&
                             psg_priv->ycellsizedef == 0 )
                                /* No cell structure, image is one lump */
                                {
                                psg_priv->xcellsizedef = gbm->w;
                                psg_priv->ycellsizedef = gbm->h;
                                }
                        else if ( psg_priv->xcellsizedef & 7 )
                                /* Insist upon a multiple of 8 */
                                return GBM_ERR_PSEG_INV_DEFCEL;
                        }
                else if ( !memcmp(buf+1+2, "\xd3\xee\x7b", 3) ||
                          !memcmp(buf+1+2, "\xd3\xac\x7b", 3) )
                        /* RasterData, or */
                        /* ImageCellPosition, seek back and abort loop */
                        {
                        psg_priv->pos = lseek(fd, - (long) sizeof(buf), SEEK_CUR);
                        return gbm->w != -1 ? GBM_ERR_OK : GBM_ERR_PSEG_SIZE;
                        }
                else
                        return GBM_ERR_PSEG_BAD_RECORD;
                lseek(fd, seek_by, SEEK_CUR);
                }

        return GBM_ERR_READ;
        }
/*...e*/
/*...spsg_rpal:0:*/
GBM_ERR psg_rpal(int fd, GBM *gbm, GBMRGB *gbmrgb)
        {
        gbmrgb[0].r = gbmrgb[0].g = gbmrgb[0].b = 0xff;
        gbmrgb[1].r = gbmrgb[1].g = gbmrgb[1].b = 0x00;
        return GBM_ERR_OK;
        }
/*...e*/
/*...spsg_rdata:0:*/
GBM_ERR psg_rdata(int fd, GBM *gbm, byte *data)
        {
        PSEG_PRIV *psg_priv = (PSEG_PRIV *) gbm->priv;
        char buf[1+2+6];
        int stride = ( ( gbm->w*gbm->bpp + 31 ) / 32 ) * 4;
        int xcellpos  = 0;
        int ycellpos  = 0;
        int xcellsize = psg_priv->xcellsizedef;
        int ycellsize = psg_priv->ycellsizedef;

        lseek(fd, psg_priv->pos, SEEK_SET);

        while ( read(fd, buf, sizeof(buf)) == sizeof(buf) )
                {
                long seek_by; int f;
                if ( psg_priv->fix_badrec )
                        for ( f = 0; buf[0] != 0x5a && f < 10; f++ )
                                {
                                long pos = lseek(fd, 0L, SEEK_CUR);
                                if ( pos == 0L )
                                        break;
                                lseek(fd, pos - (sizeof(buf)+1), SEEK_SET);
                                read(fd, buf, sizeof(buf));
                                }
                if ( buf[0] != 0x5a )
                        return GBM_ERR_PSEG_NOT_5A;
                seek_by = (long) getword((unsigned char*)(buf+1))-(2+6);
                if      ( !memcmp(buf+1+2, "\xd3\xee\xee", 3) )
                        ; /* Comment record, ignore it */
                else if ( !memcmp(buf+1+2, "\xd3\xa8\x5f", 3) )
                        return GBM_ERR_PSEG_UNEX_REC; /* BeginPageSegment */
                else if ( !memcmp(buf+1+2, "\xd3\xa8\x7b", 3) )
                        return GBM_ERR_PSEG_UNEX_REC; /* BeginImageBlock */
                else if ( !memcmp(buf+1+2, "\xd3\xa7\x7b", 3) )
                        return GBM_ERR_PSEG_UNEX_REC; /* ImageOutputControl */
                else if ( !memcmp(buf+1+2, "\xd3\xa6\x7b", 3) )
                        return GBM_ERR_PSEG_UNEX_REC; /* InputImageDescriptor */
                else if ( !memcmp(buf+1+2, "\xd3\xac\x7b", 3) )
                        /* ImageCellPosition, ignore it */
                        {
                        byte buf2[12], *p;
                        int xfillsize, yfillsize, y;
                        if ( read(fd, buf2, sizeof(buf2)) != sizeof(buf2) )
                                return GBM_ERR_READ;
                        xcellpos  = getword(buf2);
                        if ( xcellpos & 7 )
                                return GBM_ERR_PSEG_INV_CELPOS;
                        ycellpos  = getword(buf2+2);
                        xcellsize = getword(buf2+4);
                        if ( xcellsize & 7 )
                                return GBM_ERR_PSEG_INV_CEL;
                        ycellsize = getword(buf2+6);
                        xfillsize = getword(buf2+8);
                        yfillsize = getword(buf2+10);
                        if ( xfillsize != 0xffff && yfillsize != 0xffff )
                                {
                                p = data + ( (gbm->h-1-ycellpos) * stride + xcellpos/8 );
                                for ( y = 0; y < yfillsize; y++, p -= stride )
                                        memset(p, 0x00, xfillsize/8);
                                }
                        seek_by -= sizeof(buf2);
                        }
                else if ( !memcmp(buf+1+2, "\xd3\xee\x7b", 3) )
                        /* RasterData, use the data */
                        {
                        byte *p = data + ( (gbm->h-1-ycellpos) * stride + xcellpos/8 );
                        int xc = xcellsize/8;

                        for ( ; seek_by >= xc; seek_by -= xc, p -= stride, ycellpos++, ycellsize-- )
                                if ( read(fd, p, xc) != xc )
                                        return GBM_ERR_READ;
                        }
                else if ( !memcmp(buf+1+2, "\xd3\xa9\x7b", 3) )
                        /* EndImageBlock */
                        return GBM_ERR_OK;
                else
                        return GBM_ERR_PSEG_BAD_RECORD;
                lseek(fd, seek_by, SEEK_CUR);
                }

        return GBM_ERR_READ;
        }
/*...e*/
/*...spsg_w:0:*/
/*...srecord:0:*/
static bool record(int fd, byte *rec, char *six, int len)
        {
        rec[0] = 0x5a;
        putword((char*)(rec+1), 2+6+len);
        memcpy(rec+1+2, six, 6);
        return write(fd, rec, 1+2+6+len) == 1+2+6+len;
        }
/*...e*/

GBM_ERR psg_w(char *fn, int fd, GBM *gbm, GBMRGB *gbmrgb, byte *data, char *opt)
        {
        static char by_gbm[] = "Written by GBM", buf8[8+1];
        static byte *rec, *r;
        int stride = ( ( gbm->w + 31 ) / 32 ) * 4;
        int len = (gbm->w+7)/8;
        int i;
        byte lastbits = 0xff;

        if ( gbm->bpp != 1 )
                return GBM_ERR_NOT_SUPP;

        if ( gbm->w > 2400 || gbm->h > 2400 )
                return GBM_ERR_BAD_SIZE;

        if ( (rec = (byte*)malloc(1+2+6+max(100,stride))) == NULL )
                return GBM_ERR_MEM;
        r = rec + 1+2+6;

        sprintf(buf8, "%-8.8s", fn);
        ebcdic(buf8, buf8);

        /* Comment */
        ebcdic((char *) r, by_gbm);
        if ( !record(fd, rec, "\xd3\xee\xee\x00\x00\x00", strlen(by_gbm)) )
                { free(rec); return GBM_ERR_WRITE; }

        /* BeginPageSegment (we will use filename) */
        memcpy(r, buf8, 8);
        if ( !record(fd, rec, "\xd3\xa8\x5f\x00\x00\x00", 8) )
                { free(rec); return GBM_ERR_WRITE; }

        /* BeginImageBlock (use filename again) */
        if ( !record(fd, rec, "\xd3\xa8\x7b\x00\x00\x00", 8) )
                { free(rec); return GBM_ERR_WRITE; }

        /* ImageOutputControl */
        memset(r, 0x00, 6+4+8); /* Image Block Origin, Orientation, Reserved */
        r[8] = 0x2d; /* 90 degrees */
        if ( gbm_find_word(opt, "double") != NULL )
                memcpy(r+6+4+8, "\x07\xd0\x07\xd0", 4); /* Scale factor */
        else
                memcpy(r+6+4+8, "\x03\xe8\x03\xe8", 4); /* x2 scale factor */
        memset(r+6+4+8+4, 0xff, 2);
        if ( !record(fd, rec, "\xd3\xa7\x7b\x00\x00\x00", 6+4+8+4+2) )
                { free(rec); return GBM_ERR_WRITE; }

        /* ImageInputDescriptor */
        memset(r, 0x00, 6+12+2+2+6);
               r[2] = 0x09; /* 0 or 0x09? */
               r[3] = 0x60; /* 0 or 0x60? */
               r[4] = 0x09; /* 0 or 0x09? */
               r[5] = 0x60; /* 0 or 0x60? */
               r[6 +  8] = 0x09;
               r[6 +  9] = 0x60;
               r[6 + 10] = 0x09;
               r[6 + 11] = 0x60;
        putword(  (char*)(r+6+12), (gbm->w+7)&~7);   // mjs
        putword(  (char*)(r+6+12+2), gbm->h);
               r[6+12+2+2 + 4] = 0x2d;
        putword(  (char*)(r+6+12+2+2+6), 0);     /* Not writing in cells */
        putword(  (char*)(r+6+12+2+2+6+2), 0);   /* Not writing in cells */
        memcpy(r+6+12+2+2+6+2+2, "\x00\x01\xff\xff", 4);
        if ( !record(fd, rec, "\xd3\xa6\x7b\x00\x00\x00", 6+12+2+2+6+2+2+4) )
                { free(rec); return GBM_ERR_WRITE; }

        if ( gbm->w&7 )
                lastbits = (byte) ( 0xff00 >> (gbm->w&7) );
        data += (gbm->h-1) * stride;
        for ( i = 0; i < gbm->h; i++, data -= stride )
                {
                memcpy(r, data, len); r[len-1] &= lastbits;
                if ( !record(fd, rec, "\xd3\xee\x7b\x00\x00\x00", len) )
                        { free(rec); return GBM_ERR_WRITE; }
                }

        /* EndImageBlock, (use filename) */
        memcpy(r, buf8, 8);
        if ( !record(fd, rec, "\xd3\xa9\x7b\x00\x00\x00", 8) )
                { free(rec); return GBM_ERR_WRITE; }

        /* EndPageSegment (use filename from before) */
        if ( !record(fd, rec, "\xd3\xa9\x5f\x00\x00\x00", 8) )
                { free(rec); return GBM_ERR_WRITE; }

        free(rec);

        return GBM_ERR_OK;
        }
/*...e*/
/*...spsg_err:0:*/
unsigned long psg_err(GBM_ERR rc)
        {
        switch ( (int) rc )
                {
                case GBM_ERR_PSEG_NOT_5A:
                        return IC_GBM_PSEG_NOT_5A;
                case GBM_ERR_PSEG_BAD_RECORD:
                        return IC_GBM_PSEG_BAD_RECORD;
                case GBM_ERR_PSEG_SIZE:
                        return IC_GBM_PSEG_SIZE;
                case GBM_ERR_PSEG_INV_WIDTH:
                        return IC_GBM_PSEG_INV_WIDTH;
                case GBM_ERR_PSEG_INV_DEFCEL:
                        return IC_GBM_PSEG_INV_DEFCEL;
                case GBM_ERR_PSEG_INV_CEL:
                        return IC_GBM_PSEG_INV_CEL;
                case GBM_ERR_PSEG_INV_CELPOS:
                        return IC_GBM_PSEG_INV_CELPOS;
                case GBM_ERR_PSEG_UNEX_REC:
                        return IC_GBM_PSEG_UNEX_REC;
                }
        return 0;
        }
/*
*****************************************************************************************
*                                                                                       *
* COPYRIGHT:                                                                            *
*   IBM Open Class Library                                                              *
*   (C) Copyright International Business Machines Corporation,  1997                    *
*   Licensed Material - Program-Property of IBM - All Rights Reserved.                  *
*   US Government Users Restricted Rights - Use, duplication, or disclosure             *
*   restricted by GSA ADP Schedule Contract with IBM Corp.                              *
*                                                                                       *
*****************************************************************************************
*/
// Revision: 56 1.4.1.5 source/ographic/igbm.cpp, graphics, ioc.v400, 001006 
/*

IGBM.C  General Bitmap Code

*/

#if 0
#pragma priority( -2147481424 )

/*...sincludes:0:*/
#include <stdio.h>
#include <ctype.h>
#include <stddef.h>
#include <stdlib.h>
#include <string.h>
#include <memory.h>
#include <igbmstnd.hpp>
#include <igbm.hpp>
#endif // 0
//#ifndef IC_MOTIF
#if 0
#include <igbmhelp.hpp>

#include <igbmpgm.hpp>
#include <igbmppm.hpp>
#include <igbmbmp.hpp>
#include <igbmtga.hpp>
#include <igbmkps.hpp>
#include <igbmiax.hpp>
#include <igbmpcx.hpp>
#include <igbmtif.hpp>
#include <igbmlbm.hpp>
#include <igbmvid.hpp>
#include <igbmgif.hpp>
#include <igbmxbm.hpp>
#include <igbmspr.hpp>
#include <igbmpsg.hpp>
#include <icconst.h>

// Segment definitions
#ifdef IC_PAGETUNE
  #define _IGBM_CPP_
  #include <ipagetun.h>
#endif
#endif // 0

typedef struct
        {
        GBM_ERR (*query_filetype)(GBMFT *gbmft);
        GBM_ERR (*read_header )(char *fn, int fd, GBM *gbm, char *opt);
        GBM_ERR (*read_palette)(int fd, GBM *gbm, GBMRGB *gbmrgb);
        GBM_ERR (*read_data   )(int fd, GBM *gbm, byte *data);
        GBM_ERR (*write       )(char *fn, int fd, GBM *gbm, GBMRGB *gbmrgb, byte *data, char *opt);
        unsigned long (*err   )(GBM_ERR rc);
        } FT;

static FT fts[] =
        {
        bmp_qft, bmp_rhdr, bmp_rpal, bmp_rdata, bmp_w, bmp_err,
        gif_qft, gif_rhdr, gif_rpal, gif_rdata, gif_w, gif_err,
        pcx_qft, pcx_rhdr, pcx_rpal, pcx_rdata, pcx_w, pcx_err,
        tif_qft, tif_rhdr, tif_rpal, tif_rdata, tif_w, tif_err,
        tga_qft, tga_rhdr, tga_rpal, tga_rdata, tga_w, tga_err,
        lbm_qft, lbm_rhdr, lbm_rpal, lbm_rdata, lbm_w, lbm_err,
        vid_qft, vid_rhdr, vid_rpal, vid_rdata, vid_w, vid_err,
        pgm_qft, pgm_rhdr, pgm_rpal, pgm_rdata, pgm_w, pgm_err,
        ppm_qft, ppm_rhdr, ppm_rpal, ppm_rdata, ppm_w, ppm_err,
        kps_qft, kps_rhdr, kps_rpal, kps_rdata, kps_w, kps_err,
        iax_qft, iax_rhdr, iax_rpal, iax_rdata, iax_w, iax_err,
        xbm_qft, xbm_rhdr, xbm_rpal, xbm_rdata, xbm_w, xbm_err,
        spr_qft, spr_rhdr, spr_rpal, spr_rdata, spr_w, spr_err,
        psg_qft, psg_rhdr, psg_rpal, psg_rdata, psg_w, psg_err,
        };

#define N_FT    (sizeof(fts) / sizeof(fts[0]))
/*...e*/

/*...sextension:0:*/
#ifndef DEFINED_EXXXTENSION_FN
#define DEFINED_EXXXTENSION_FN
static char *extension(char *fn)
        {
        char *dot, *slash;

        if ( (dot = strrchr(fn, '.')) == NULL )
                return NULL;

        if ( (slash = strpbrk(fn, "/\\")) == NULL )
                return dot + 1;

        return ( slash < dot ) ? dot + 1 : NULL;
        }
/*...e*/
#endif // DEFINED_EXXXTENSION_FN

#if 0
/*...sgbm_init:0:*/
GBM_ERR gbm_init(void)
        {
        return GBM_ERR_OK;
        }
/*...e*/
/*...sgbm_deinit:0:*/
GBM_ERR gbm_deinit(void)
        {
        return GBM_ERR_OK;
        }
/*...e*/
/*...sgbm_query_n_filetypes:0:*/
GBM_ERR gbm_query_n_filetypes(int *n_ft)
        {
        *n_ft = N_FT;
        return GBM_ERR_OK;
        }
/*...e*/
#endif // 0

/*...sgbm_guess_filetype:0:*/
GBM_ERR gbm_guess_filetype(char *fn, int *ft)
        {
        int i;
        char *ext = extension(fn);

        if ( ext == NULL )
                ext = "";

        for ( i = 0; i < N_FT; i++ )
                {
                GBMFT   gbmft;
                char    buf[100+1], *s;

                fts[i].query_filetype(&gbmft);
                for ( s  = strtok(strcpy(buf, gbmft.extensions), " \t,");
                      s != NULL;
                      s  = strtok(NULL, " \t,") )
                        if ( gbm_same(s, ext, strlen(ext) + 1) )
                                {
                                *ft = i;
                                return GBM_ERR_OK;
                                }
                }
        return GBM_ERR_NOT_FOUND;
        }
/*...e*/

/*...sgbm_query_filetype:0:*/
GBM_ERR gbm_query_filetype(int ft, GBMFT *gbmft)
        {
        return (*fts[ft].query_filetype)(gbmft);
        }
/*...e*/
/*...sgbm_read_header:0:*/
GBM_ERR gbm_read_header(char *fn, int fd, int ft, GBM *gbm, char *opt)
        {
        return (*fts[ft].read_header)(fn, fd, gbm, opt);
        }
/*...e*/
/*...sgbm_read_palette:0:*/
GBM_ERR gbm_read_palette(int fd, int ft, GBM *gbm, GBMRGB *gbmrgb)
        {
        return (*fts[ft].read_palette)(fd, gbm, gbmrgb);
        }
/*...e*/
/*...sgbm_read_data:0:*/
GBM_ERR gbm_read_data(int fd, int ft, GBM *gbm, byte *data)
        {
        return (*fts[ft].read_data)(fd, gbm, data);
        }
/*...e*/
/*...sgbm_write:0:*/
GBM_ERR gbm_write(char *fn, int fd, int ft, GBM *gbm, GBMRGB *gbmrgb, byte *data, char *opt)
        {
        return (*fts[ft].write)(fn, fd, gbm, gbmrgb, data, opt);
        }
/*...e*/

/*...sgbm_err:0:*/
unsigned long gbm_err(GBM_ERR rc)
        {
        int ft;

        switch ( (int) rc )
                {
                case GBM_ERR_OK:
                        return 0;
                case GBM_ERR_MEM:
                        return IC_HEAP_EXHAUSTED;
                case GBM_ERR_NOT_SUPP:
                        return IC_GBM_NOT_SUPPORTED;
                case GBM_ERR_BAD_OPTION:
                        return IC_GBM_BAD_OPTION;
                case GBM_ERR_NOT_FOUND:
                        return IC_GBM_NOT_FOUND;
                case GBM_ERR_BAD_MAGIC:
                        return IC_GBM_BAD_MAGIC;
                case GBM_ERR_BAD_SIZE:
                        return IC_GBM_BAD_SIZE;
                case GBM_ERR_READ:
                        return IC_GBM_READ_FAILED;
                case GBM_ERR_WRITE:
                        return IC_GBM_WRITE_FAILED;
                }

        for ( ft = 0; ft < N_FT; ft++ )
                {
                unsigned err;

                if ( (err = (*fts[ft].err)(rc)) != 0 )
                        return err;
                }

        return IC_GBM_UNKNOWN_ERROR;
        }

//#endif //IC_MOTIF
/*
*****************************************************************************************
*                                                                                       *
* COPYRIGHT:                                                                            *
*   IBM Open Class Library                                                              *
*   (C) Copyright International Business Machines Corporation,  1997                    *
*   Licensed Material - Program-Property of IBM - All Rights Reserved.                  *
*   US Government Users Restricted Rights - Use, duplication, or disclosure             *
*   restricted by GSA ADP Schedule Contract with IBM Corp.                              *
*                                                                                       *
*****************************************************************************************
*/
// Revision: 56 1.4.1.5 source/ographic/igbm.cpp, graphics, ioc.v400, 001006 
/*

IGBMMIR.C  Produce Mirror Image of General Bitmap

*/

#if 0
#pragma priority( -2147481424 )

/*...sincludes:0:*/
#include <stdio.h>
#include <string.h>
#include <stddef.h>
#include <stdlib.h>
#include <memory.h>
#include <malloc.h>
#include "igbmstnd.hpp"
#include "igbm.hpp"
#include <ibase.hpp>

// Segment definitions
#ifdef IC_PAGETUNE
  #define _IGBMMIR_CPP_
  #include <ipagetun.h>
#endif

/*...vgbm\46\h:0:*/
/*...e*/
#endif // 0

/*...sgbm_ref_vert:0:*/
bool gbm_ref_vert(GBM *gbm, byte *data)
        {
        int     stride = ( ((gbm->w * gbm->bpp + 31)/32) * 4 );
        byte    *p1 = data;
        byte    *p2 = data + (gbm->h - 1) * stride;
        byte    *p3;

        if ( (p3 = (byte*)malloc(stride)) == NULL )
                return false;

        for ( ; p1 < p2; p1 += stride, p2 -= stride )
                {
                memcpy(p3, p1, stride);
                memcpy(p1, p2, stride);
                memcpy(p2, p3, stride);
                }

        free(p3);

        return true;
        }
/*...e*/
/*...sgbm_ref_horz:0:*/
/*...sref_horz_24:0:*/
static void ref_horz_24(byte *dst, byte *src, int n)
        {
        dst += n * 3;
        while ( n-- )
                {
                dst -= 3;
                dst[0] = *src++;
                dst[1] = *src++;
                dst[2] = *src++;
                }
        }
/*...e*/
/*...sref_horz_8:0:*/
static void ref_horz_8(byte *dst, byte *src, int n)
        {
        dst += n;
        while ( n-- )
                *(--dst) = *src++;
        }
/*...e*/
/*...sref_horz_4:0:*/
static byte rev4[0x100];

static void table_4(void)
        {
        int     i;

        for ( i = 0; i < 0x100; i++ )
                rev4[i] = (byte) ( ((i & 0x0f) << 4) | ((i & 0xf0) >> 4) );
        }

static void ref_horz_4(byte *dst, byte *src, int n)
        {
        if ( (n & 1) == 0 )
                {
                n /= 2;
                dst += n;
                while ( n-- )
                        *(--dst) = rev4[*src++];
                }
        else
                {
                n /= 2;
                src += n;
                while ( n-- )
                        {
                        *dst    = (byte) (*(src--) & 0xf0);
                        *dst++ |= (byte) (* src    & 0x0f);
                        }
                *dst = (byte) (*src & 0xf0);
                }
        }
/*...e*/
/*...sref_horz_1:0:*/
static byte rev[0x100]; /* Reverses all bits in a byte */
static byte rev_top[7][0x100]; /* Reverses top N bits of a byte */
static byte rev_bot[7][0x100]; /* Reverses bottom N bits of a byte */
static byte lmask[8] = { 0, 0x80,0xc0,0xe0,0xf0,0xf8,0xfc,0xfe };

static void table_1(void)
        {
        int i;

        for ( i = 0; i < 0x100; i++ )
                {
                int j, p, q, b = 0;

                for ( p = 0x01, q = 0x80; p < 0x100; p <<= 1, q >>= 1 )
                        if ( i & p )
                                b |= q;
                rev[i] = b;

                for ( j = 1; j < 8; j++ )
                        {
                        byte l = 0, r = 0;
                        byte lm = 0x80, lmr = (byte) (0x80 >> (j - 1));
                        byte rm = 0x01, rmr = (byte) (0x01 << (j - 1));
                        int k;

                        for ( k = 0; k < j; k++ )
                                {
                                if ( i & (lm >> k) ) l |= (lmr << k);
                                if ( i & (rm << k) ) r |= (rmr >> k);
                                }
                        rev_top[j-1][i] = l;
                        rev_bot[j-1][i] = r;
                        }
                }
        }

static void ref_horz_1(byte *dst, byte *src, int n)
        {
        int     last = ( n & 7 );

        n >>= 3;
        if ( last == 0 )
                {
                dst += n;
                while ( n-- )
                        *(--dst) = rev[*src++];
                }
        else
                {
                byte    *lrev = rev_top[   last -1];
                byte    *rrev = rev_bot[(8-last)-1];
                byte    lm = lmask[last], rm = 0xff - lm;

                src += n;
                while ( n-- )
                        {
                        *dst    = lrev[*(src--) & lm];
                        *dst++ |= rrev[* src    & rm];
                        }
                *dst = lrev[*src & lm];
                }
        }
/*...e*/

bool gbm_ref_horz(GBM *gbm, byte *data)
        {
        int     stride = ( ((gbm->w * gbm->bpp + 31)/32) * 4 );
        int     y;
        byte    *p = data;
        byte    *tmp;

        if ( (tmp = (byte*)malloc(stride)) == NULL )
                return false;

        switch ( gbm->bpp )
                {
                case 24:
                        for ( y = 0; y < gbm->h; y++, p += stride )
                                {
                                ref_horz_24(tmp, p, gbm->w);
                                memcpy(p, tmp, stride);
                                }
                        break;
                case 8:
                        for ( y = 0; y < gbm->h; y++, p += stride )
                                {
                                ref_horz_8(tmp, p, gbm->w);
                                memcpy(p, tmp, stride);
                                }
                        break;
                case 4:
                        table_4();
                        for ( y = 0; y < gbm->h; y++, p += stride )
                                {
                                ref_horz_4(tmp, p, gbm->w);
                                memcpy(p, tmp, stride);
                                }
                        break;
                case 1:
                        table_1();
                        for ( y = 0; y < gbm->h; y++, p += stride )
                                {
                                ref_horz_1(tmp, p, gbm->w);
                                memcpy(p, tmp, stride);
                                }
                        break;
                }

        free(tmp);

        return true;
        }
/*...e*/
/*...sgbm_transpose:0:*/
void gbm_transpose(GBM *gbm, byte *data, byte *data_t)
        {
        int stride   = ((gbm->w * gbm->bpp + 31) / 32) * 4;
        int stride_t = ((gbm->h * gbm->bpp + 31) / 32) * 4;

        switch ( gbm->bpp )
                {
/*...s24:16:*/
case 24:
        {
        int data_step = stride - gbm->w * 3;
        int p_step = stride_t - 2;
        int x, y;

        for ( y = 0; y < gbm->h; y++ )
                {
                byte *p = data_t; data_t += 3;

                for ( x = 0; x < gbm->w; x++ )
                        {
                        *p++ = *data++;
                        *p++ = *data++;
                        *p   = *data++;
                        p += p_step;
                        }
                data += data_step;
                }
        }
        break;
/*...e*/
/*...s8:16:*/
case 8:
        {
        int data_step = stride - gbm->w;
        int x, y;

        for ( y = 0; y < gbm->h; y++ )
                {
                byte *p = data_t++;

                for ( x = 0; x < gbm->w; x++ )
                        {
                        *p = *data++;
                        p += stride_t;
                        }
                data += data_step;
                }
        }
        break;
/*...e*/
/*...s4:16:*/
case 4:
        {
        int x, y;

        for ( y = 0; y < gbm->h; y += 2 )
                {
                for ( x = 0; x < gbm->w; x += 2 )
/*...s2x2 transpose to 2x2:40:*/
{
byte *src      = data + y * stride + (x >> 1);
byte ab        = src[0     ];
byte cd        = src[stride];
byte *dst      = data_t + x * stride_t + (y >> 1);
dst[0       ] = (byte) ((ab & 0xf0) | (cd >> 4));
dst[stride_t] = (byte) ((ab << 4) | (cd & 0x0f));
}
/*...e*/
                if ( x < gbm->w )
/*...s1x2 transpose to 2x1:40:*/
{
byte *src    = data + y * stride + (x >> 1);
byte a0      = src[0     ];
byte b0      = src[stride];
byte *dst    = data_t + x * stride_t + (y >> 1);
dst[0     ] = (byte) ((a0 & 0xf0) | (b0 >> 4));
}
/*...e*/
                }
        if ( y < gbm->h )
                {
                for ( x = 0; x < gbm->w; x += 2 )
/*...s2x1 transpose to 1x2:40:*/
{
byte *src      = data + y * stride + (x >> 1);
byte ab        = src[0     ];
byte *dst      = data_t + x * stride_t + (y >> 1);
dst[0       ] = (byte) (ab & 0xf0);
dst[stride_t] = (byte) (ab << 4);
}
/*...e*/
                if ( x < gbm->w )
/*...s1x1 transpose to 1x1:40:*/
{
byte *src    = data + y * stride + (x >> 1);
byte a0      = src[0     ];
byte *dst    = data_t + x * stride_t + (y >> 1);
dst[0     ] = (byte) (a0 & 0xf0);
}
/*...e*/
                }
        }
        break;
/*...e*/
/*...s1:16:*/
case 1:
        {
        int x, y;
        byte xbit, ybit;

        memset(data_t, 0, gbm->w * stride_t);

        ybit = 0x80;
        for ( y = 0; y < gbm->h; y++ )
                {
                xbit = 0x80;
                for ( x = 0; x < gbm->w; x++ )
                        {
                        byte *src = data   + y * stride   + (x >> 3);
                        byte *dst = data_t + x * stride_t + (y >> 3);

                        if ( *src & xbit )
                                *dst |= ybit;

                        if ( (xbit >>= 1) == 0 )
                                xbit = 0x80;
                        }
                if ( (ybit >>= 1) == 0 )
                        ybit = 0x80;
                }
        }
        break;
/*...e*/
                }
        }
/*...e*/
/*
*****************************************************************************************
*                                                                                       *
* COPYRIGHT:                                                                            *
*   IBM Open Class Library                                                              *
*   (C) Copyright International Business Machines Corporation,  1997                    *
*   Licensed Material - Program-Property of IBM - All Rights Reserved.                  *
*   US Government Users Restricted Rights - Use, duplication, or disclosure             *
*   restricted by GSA ADP Schedule Contract with IBM Corp.                              *
*                                                                                       *
*****************************************************************************************
*/
// Revision: 56 1.4.1.5 source/ographic/igbm.cpp, graphics, ioc.v400, 001006 
/*

IGBMSCAL.C  Scale bitmap to new size

*/

#if 0
/*...sincludes:0:*/
#include <stdio.h>
#include <stddef.h>
#include <stdlib.h>
#include <string.h>
#include <memory.h>
#include "igbmstnd.hpp"
#include "igbm.hpp"

// Segment definitions
#ifdef IC_PAGETUNE
  #define _IGBMSCAL_CPP_
  #include <ipagetun.h>
#endif
#endif // 0

/*...vgbm\46\h:0:*/
/*...e*/

/*...sgbm_simple_scale \45\ point sampled:0:*/
/*...ssimple_scale_1:0:*/
static void simple_scale_1(
        byte *s,
        byte *d, int dw,
        int xs[]
        )
        {
        int sx = 0;
        byte bit, value;

        for ( ; dw >= 8; dw -= 8 )
                {
                for ( value = 0, bit = 0x80; bit > 0; bit >>= 1 )
                        {
                        if ( s[sx>>3]&(0x80>>(sx&7)) ) value |= bit;
                        sx += *xs++;
                        }
                *d++ = value;
                }

        if ( dw > 0 )
                {
                for ( value = 0, bit = 0x80; dw-- > 0; bit >>= 1 )
                        {
                        if ( s[sx>>3]&(0x80>>(sx&7)) ) value |= bit;
                        sx += *xs++;
                        }
                *d = value;
                }
        }
/*...e*/
/*...ssimple_scale_4:0:*/
static void simple_scale_4(
        byte *s,
        byte *d, int dw,
        int xs[]
        )
        {
        int sx = 0;
        for ( ;; )
                {
                if ( dw-- == 0 ) return;
                if ( sx&1 ) *d = (s[sx>>1] << 4);
                else        *d = (s[sx>>1]&0xf0);
                sx += *xs++;

                if ( dw-- == 0 ) return;
                if ( sx&1 ) *d++ |= (s[sx>>1]&0x0f);
                else        *d++ |= (s[sx>>1] >> 4);
                sx += *xs++;
                }
        }
/*...e*/
/*...ssimple_scale_8:0:*/
static void simple_scale_8(
        byte *s,
        byte *d, int dw,
        int xs[]
        )
        {
        while ( dw-- > 0 )
                {
                *d++ = *s;
                s += *xs++;
                }
        }
/*...e*/
/*...ssimple_scale_24:0:*/
static void simple_scale_24(
        byte *s,
        byte *d, int dw,
        int xs[]
        )
        {
        while ( dw-- > 0 )
                {
                *d++ = s[0];
                *d++ = s[1];
                *d++ = s[2];
                s += ( 3 * *xs++ );
                }
        }
/*...e*/
/*...sfast_simple_scale_1:0:*/
static void fast_simple_scale_1(
        byte *s,
        byte *d, int dw,
        int xs[]
        )
        {
        xs=xs; /* Suppress warnings */
        memcpy(d, s, (dw+7) >> 3);
        }
/*...e*/
/*...sfast_simple_scale_4:0:*/
static void fast_simple_scale_4(
        byte *s,
        byte *d, int dw,
        int xs[]
        )
        {
        xs=xs; /* Suppress warnings */
        memcpy(d, s, (dw+1)>>1);
        }
/*...e*/
/*...sfast_simple_scale_8:0:*/
static void fast_simple_scale_8(
        byte *s,
        byte *d, int dw,
        int xs[]
        )
        {
        xs=xs; /* Suppress warnings */
        memcpy(d, s, dw);
        }
/*...e*/
/*...sfast_simple_scale_24:0:*/
static void fast_simple_scale_24(
        byte *s,
        byte *d, int dw,
        int xs[]
        )
        {
        xs=xs; /* Suppress warnings */
        memcpy(d, s, dw*3);
        }
/*...e*/

GBM_ERR gbm_simple_scale(
        byte *s, int sw, int sh,
        byte *d, int dw, int dh,
        int bpp
        )
        {
        int sst = ( (sw * bpp + 31) / 32 ) * 4;
        int dst = ( (dw * bpp + 31) / 32 ) * 4;
        int *xs, *ys, i;
        void (*scaler)(byte *s, byte *d, int dw, int xs[]);

        /* Allocate memory for step arrays */

        if ( (xs = (int*)malloc((dw+1+dh+1)*sizeof(int))) == NULL )
                return GBM_ERR_MEM;
        ys = xs + (dw+1);

        /* Make mapping to 0..dx from 0..sx (and same for y) */

        for ( i = 0; i <= dw; i++ )
                xs[i] = (i * sw) / dw;

        for ( i = 0; i <= dh; i++ )
                ys[i] = (i * sh) / dh;

        /* Compute step coefficients */

        for ( i = 0; i < dw; i++ )
                xs[i] = xs[i+1] - xs[i];

        for ( i = 0; i < dh; i++ )
                ys[i] = ys[i+1] - ys[i];

        /* Pick a scaling routine. Special optimisation to prevent
           excessive work scaling horizontally if widths are the same.
           Effectively reduces this code to a memcpy. */

        if ( dw == sw )
                switch ( bpp )
                        {
                        case 1 : scaler = fast_simple_scale_1 ; break;
                        case 4 : scaler = fast_simple_scale_4 ; break;
                        case 8 : scaler = fast_simple_scale_8 ; break;
                        case 24: scaler = fast_simple_scale_24; break;
                        }
        else
                switch ( bpp )
                        {
                        case 1 : scaler = simple_scale_1 ; break;
                        case 4 : scaler = simple_scale_4 ; break;
                        case 8 : scaler = simple_scale_8 ; break;
                        case 24: scaler = simple_scale_24; break;
                        }

        /* Now do guts of scaling */

        while ( dh-- > 0 )
                {
                (*scaler)(s, d, dw, xs);
                d += dst;
                s += (sst * *ys++);
                }

        free(xs);
        return GBM_ERR_OK;
        }
/*...e*/
/*
*****************************************************************************************
*                                                                                       *
* COPYRIGHT:                                                                            *
*   IBM Open Class Library                                                              *
*   (C) Copyright International Business Machines Corporation,  1997                    *
*   Licensed Material - Program-Property of IBM - All Rights Reserved.                  *
*   US Government Users Restricted Rights - Use, duplication, or disclosure             *
*   restricted by GSA ADP Schedule Contract with IBM Corp.                              *
*                                                                                       *
*****************************************************************************************
*/
// Revision: 56 1.4.1.5 source/ographic/igbm.cpp, graphics, ioc.v400, 001006 
/*

IGBMERR.C  Error diffusion Module

*/

#if 0
#pragma priority( -2147481424 )

/*...sincludes:0:*/
#include <stdio.h>
#include <stddef.h>
#include <stdlib.h>
#include <string.h>
#include <memory.h>
#include "igbmstnd.hpp"
#include "igbm.hpp"
#include <ibase.hpp>

// Segment definitions
#ifdef IC_PAGETUNE
  #define _IGBMERR_CPP_
  #include <ipagetun.h>
#endif
#endif // 0

/*...vgbm\46\h:0:*/
/*...e*/
/*...svars:0:*/
static bool inited = FALSE;

/*
Tables used for quick saturated addition and subtraction.
*/

static byte usat[256+256+256];
#define U_SAT_ADD(a,b)  usat[(a)+(b)+256]

static short ssat[256+256+256+256];
#define S_SAT_ADD(a,b)  ssat[(a)+(b)+512]

/*
For 6Rx6Gx6B, 7Rx8Gx4B palettes etc.
*/

static byte index4[0x100];
static byte index6[0x100];
static byte index7[0x100];
static byte index8[0x100];
static byte index16[0x100];
static byte scale4[] = { 0, 85, 170, 255 };
static byte scale6[] = { 0, 51, 102, 153, 204, 255 };
static byte scale7[] = { 0, 43, 85, 128, 170, 213, 255 };
static byte scale8[] = { 0, 36, 73, 109, 146, 182, 219, 255 };
static byte scale16[] = { 0, 17, 34, 51, 68, 85, 102, 119, 136,
                           153, 170, 187, 204, 221, 238, 255 };

static word randtab[0x100];
static int randinx = 0;
/*...e*/
/*...sinit:0:*/
/*
This function initialises this module.
It does this by preparing the quick saturated addition and subraction tables.
*/

/*...snearest_inx:0:*/
#ifndef abs
#define abs(x)  (((x)>=0)?(x):-(x))
#endif

static byte nearest_inx(byte value, byte ab[], unsigned short cb)
        {
        byte b, inx, inx_min;
        short diff, diff_min;

        b = ab[0];
        diff_min = abs((short) value - (short) b);
        inx_min = 0;
        for ( inx = 1; (unsigned short) inx < cb; inx++ )
                {
                b = ab[inx];
                diff = abs((short) value - (short) b);
                if ( diff < diff_min )
                        {
                        diff_min = diff;
                        inx_min = inx;
                        }
                }
        return inx_min;
        }
/*...e*/

static void init(void)
        {
        int i;

        if ( inited )
                return;

        memset(usat, 0, 0x100);
        for ( i = 0; i < 0x100; i++ )
                usat[i +  0x100] = (byte) i;
        memset(usat + 0x200, 0xff, 0x100);

        for ( i = -0x200; i < -0x100; i++ )
                ssat[i + 0x200] = -0x100;
        for ( i = -0x100; i < 0x100; i++ )
                ssat[i + 0x200] = i;
        for ( i = 0x100; i < 0x200; i++ )
                ssat[i + 0x200] = 0xff;

        /* For 7 Red x 8 Green x 4 Blue palettes etc. */

        for ( i = 0; i < 0x100; i++ )
                {
                index4 [i] = nearest_inx((byte) i, scale4 , sizeof(scale4 ));
                index6 [i] = nearest_inx((byte) i, scale6 , sizeof(scale6 ));
                index7 [i] = nearest_inx((byte) i, scale7 , sizeof(scale7 ));
                index8 [i] = nearest_inx((byte) i, scale8 , sizeof(scale8 ));
                index16[i] = nearest_inx((byte) i, scale16, sizeof(scale16));
                }

        /* For faster random number calculation */

        for ( i = 0; i < 0x100; i++ )
                randtab [i] = (word) (rand() % (51*0x100));

        inited = TRUE;
        }
/*...e*/
/*...serrdiff:0:*/
static bool errdiff(
        GBM *gbm, byte *src, byte *dest,
        int dest_bpp,
        void (*errdiff_line)(byte *src, byte *dest, short *errs, int cx)
        )
        {
        int     stride_src = ((gbm->w * 3 + 3) & ~3);
        int     stride_dest = ((gbm->w * dest_bpp + 31) / 32) * 4;
        byte    *buf;
        short   *errs;
        int     y;

        if ( (buf = (byte*)malloc(stride_src + 3)) == NULL )
                return FALSE;

        if ( (errs = (short*)malloc((gbm->w + 1) * 3 * sizeof(short))) == NULL )
                {
                free(buf);
                return FALSE;
                }

        memset(errs, 0, (gbm->w + 1) * 3 * sizeof(short));

        for ( y = 0; y < gbm->h; y++ )
                {
                memcpy(buf, src + y * stride_src, stride_src);
                (*errdiff_line)(buf, dest + y * stride_dest, errs, gbm->w);
                }

        free(buf);
        free(errs);

        return TRUE;
        }
/*...e*/

/*...sgbm_errdiff_line_24     \45\ error diffuse to fewer bits per pixel one line:0:*/
/*
This function takes a line of RGB data, a destination buffer and a buffer of
error terms and performs one lines worth (a given # of pixels) of error
diffusion.
*/

void gbm_errdiff_line_24(byte *src, byte *dest, short *errs, int cx, byte rm, byte gm, byte bm)
        {
        int x, ptr = 0;

        init();

        /* Step 1: Add error terms to newly supplied line */

        for ( x = 0; x < cx * 3; x++ )
                src[x] = U_SAT_ADD((int) src[x], (int) errs[x]);

        /* Step 2: Zero out error terms */

        memset(errs, 0, cx * 3 * sizeof(errs[0]));

        /* Step 3: Go along data, finding nearest colour and propagating error */

        randinx = rand();

        for ( x = 0; x < cx; x++ )
                {
                byte b     = *src++;
                byte g     = *src++;
                byte r     = *src++;
                byte bi    = (b & bm);
                byte gi    = (g & gm);
                byte ri    = (r & rm);
                int  be    = b - (int) bi;
                int  ge    = g - (int) gi;
                int  re    = r - (int) ri;
                word rn    = randtab[(byte) (randinx++)];
                int  right = (rn >> 8);
                int  down  = ((rn & 0xff) % (63 - right));
                int  be1   = ((be * right) >> 6);
                int  ge1   = ((ge * right) >> 6);
                int  re1   = ((re * right) >> 6);
                int  be2   = ((be * down) >> 6);
                int  ge2   = ((ge * down) >> 6);
                int  re2   = ((re * down) >> 6);
                int  be3   = be - be1 - be2;
                int  ge3   = ge - ge1 - ge2;
                int  re3   = re - re1 - re2;

                *dest++ = bi;
                *dest++ = gi;
                *dest++ = ri;

                src[0] = U_SAT_ADD((int) src[0], be1);
                src[1] = U_SAT_ADD((int) src[1], ge1);
                src[2] = U_SAT_ADD((int) src[2], re1);

                errs[ptr    ] = S_SAT_ADD((int) errs[ptr    ], be2);
                errs[ptr + 1] = S_SAT_ADD((int) errs[ptr + 1], ge2);
                errs[ptr + 2] = S_SAT_ADD((int) errs[ptr + 2], re2);

                ptr += 3;

                errs[ptr    ] = S_SAT_ADD((int) errs[ptr    ], be3);
                errs[ptr + 1] = S_SAT_ADD((int) errs[ptr + 1], ge3);
                errs[ptr + 2] = S_SAT_ADD((int) errs[ptr + 2], re3);
                }
        }
/*...e*/
/*...sgbm_errdiff_24          \45\ error diffuse to fewer bits per pixel:0:*/
bool gbm_errdiff_24(GBM *gbm, byte *data24, byte *data24a, byte rm, byte gm, byte bm)
        {
        int     stride = ((gbm->w * 3 + 3) & ~3);
        byte    *buf;
        short   *errs;
        int     y;

        if ( (buf = (byte*)malloc(stride + 3)) == NULL )
                return FALSE;

        if ( (errs = (short*)malloc((gbm->w + 1) * 3 * sizeof(short))) == NULL )
                {
                free(buf);
                return FALSE;
                }

        memset(errs, 0, (gbm->w + 1) * 3 * sizeof(short));

        for ( y = 0; y < gbm->h; y++ )
                {
                memcpy(buf, data24 + y * stride, stride);
                gbm_errdiff_line_24(buf, data24a + y * stride, errs, gbm->w, rm, gm, bm);
                }

        free(buf);
        free(errs);

        return TRUE;
        }
/*...e*/

/*...sgbm_errdiff_pal_6R6G6B  \45\ return 6Rx6Gx6B palette:0:*/
/*
This function makes the palette for the 6 red x 6 green x 6 blue palette.
216 palette entrys used. Remaining 40 left blank.
*/

void gbm_errdiff_pal_6R6G6B(GBMRGB *gbmrgb)
        {
        byte volatile r;        /* C-Set/2 optimiser fix */
        byte volatile g;
        byte volatile b;

        init();
        memset(gbmrgb, 0x80, 0x100 * sizeof(GBMRGB));
        for ( r = 0; r < 6; r++ )
                for ( g = 0; g < 6; g++ )
                        for ( b = 0; b < 6; b++ )
                                {
                                gbmrgb->r = scale6[r];
                                gbmrgb->g = scale6[g];
                                gbmrgb->b = scale6[b];
                                gbmrgb++;
                                }
        }
/*...e*/
/*...sgbm_errdiff_line_6R6G6B \45\ error diffuse to 6Rx6Gx6B one line:0:*/
/*
This function takes a line of RGB data, a destination buffer and a buffer of
error terms and performs one lines worth (a given # of pixels) of error
diffusion.
*/

void gbm_errdiff_line_6R6G6B(byte *src, byte *dest, short *errs, int cx)
        {
        int x, ptr = 0;

        init();

        /* Step 1: Add error terms to newly supplied line */

        for ( x = 0; x < cx * 3; x++ )
                src[x] = U_SAT_ADD((int) src[x], (int) errs[x]);

        /* Step 2: Zero out error terms */

        memset(errs, 0, (cx + 1) * 3 * sizeof(errs[0]));

        /* Step 3: Go along data, finding nearest colour and propagating error */

        randinx = rand();

        for ( x = 0; x < cx; x++ )
                {
                byte b     = *src++;
                byte g     = *src++;
                byte r     = *src++;
                byte bi    = index6[b];
                byte gi    = index6[g];
                byte ri    = index6[r];
                int  be    = b - ((int) scale6[bi]);
                int  ge    = g - ((int) scale6[gi]);
                int  re    = r - ((int) scale6[ri]);
                word rn    = randtab[(byte) (randinx++)];
                int  right = (int) (rn >> 8);
                int  down  = (int) ((rn & 0xff) % (63 - right));
                int  be1   = ((be * right) >> 6);
                int  ge1   = ((ge * right) >> 6);
                int  re1   = ((re * right) >> 6);
                int  be2   = ((be * down) >> 6);
                int  ge2   = ((ge * down) >> 6);
                int  re2   = ((re * down) >> 6);
                int  be3   = be - be1 - be2;
                int  ge3   = ge - ge1 - ge2;
                int  re3   = re - re1 - re2;

                *dest++ = (byte) (6 * (6 * ri + gi) + bi);

                src[0] = U_SAT_ADD((int) src[0], be1);
                src[1] = U_SAT_ADD((int) src[1], ge1);
                src[2] = U_SAT_ADD((int) src[2], re1);

                errs[ptr    ] = S_SAT_ADD((int) errs[ptr    ], be2);
                errs[ptr + 1] = S_SAT_ADD((int) errs[ptr + 1], ge2);
                errs[ptr + 2] = S_SAT_ADD((int) errs[ptr + 2], re2);

                ptr += 3;

                errs[ptr    ] = S_SAT_ADD((int) errs[ptr    ], be3);
                errs[ptr + 1] = S_SAT_ADD((int) errs[ptr + 1], ge3);
                errs[ptr + 2] = S_SAT_ADD((int) errs[ptr + 2], re3);
                }
        }
/*...e*/
/*...sgbm_errdiff_6R6G6B      \45\ error diffuse to 6Rx6Gx6B:0:*/
bool gbm_errdiff_6R6G6B(GBM *gbm, byte *data24, byte *data8)
        {
        return errdiff(gbm, data24, data8, 8, gbm_errdiff_line_6R6G6B);
        }
/*...e*/

/*...sgbm_errdiff_pal_7R8G4B  \45\ return 7Rx8Gx4B palette:0:*/
/*
This function makes the palette for the 7 red x 8 green x 4 blue palette.
224 palette entrys used. Remaining 32 left blank.
Colours calculated to match those used by 8514/A PM driver.
*/

void gbm_errdiff_pal_7R8G4B(GBMRGB *gbmrgb)
        {
        byte volatile r;        /* C-Set/2 optimiser fix */
        byte volatile g;
        byte volatile b;

        init();

        memset(gbmrgb, 0x80, 0x100 * sizeof(GBMRGB));
        for ( r = 0; r < 7; r++ )
                for ( g = 0; g < 8; g++ )
                        for ( b = 0; b < 4; b++ )
                                {
                                gbmrgb->r = scale7[r];
                                gbmrgb->g = scale8[g];
                                gbmrgb->b = scale4[b];
                                gbmrgb++;
                                }
        }
/*...e*/
/*...sgbm_errdiff_line_7R8G4B \45\ error diffuse to 7Rx8Gx4B one line:0:*/
/*
This function takes a line of RGB data, a destination buffer and a buffer of
error terms and performs one lines worth (a given # of pixels) of error
diffusion.
*/

void gbm_errdiff_line_7R8G4B(byte *src, byte *dest, short *errs, int cx)
        {
        int x, ptr = 0;

        init();

        /* Step 1: Add error terms to newly supplied line */

        for ( x = 0; x < cx * 3; x++ )
                src[x] = U_SAT_ADD((int) src[x], (int) errs[x]);

        /* Step 2: Zero out error terms */

        memset(errs, 0, (cx + 1) * 3 * sizeof(errs[0]));

        /* Step 3: Go along data, finding nearest colour and propagating error */

        randinx = rand();

        for ( x = 0; x < cx; x++ )
                {
                byte b     = *src++;
                byte g     = *src++;
                byte r     = *src++;
                byte bi    = index4[b];
                byte gi    = index8[g];
                byte ri    = index7[r];
                int  be    = b - ((int) scale4[bi]);
                int  ge    = g - ((int) scale8[gi]);
                int  re    = r - ((int) scale7[ri]);
                word rn    = randtab[(byte) (randinx++)];
                int  right = (rn >> 8);
                int  down  = ((rn & 0xff) % (63 - right));
                int  be1   = ((be * right) >> 6);
                int  ge1   = ((ge * right) >> 6);
                int  re1   = ((re * right) >> 6);
                int  be2   = ((be * down) >> 6);
                int  ge2   = ((ge * down) >> 6);
                int  re2   = ((re * down) >> 6);
                int  be3   = be - be1 - be2;
                int  ge3   = ge - ge1 - ge2;
                int  re3   = re - re1 - re2;

                *dest++ = (byte) (4 * (8 * ri + gi) + bi);

                src[0] = U_SAT_ADD((int) src[0], be1);
                src[1] = U_SAT_ADD((int) src[1], ge1);
                src[2] = U_SAT_ADD((int) src[2], re1);

                errs[ptr    ] = S_SAT_ADD((int) errs[ptr    ], be2);
                errs[ptr + 1] = S_SAT_ADD((int) errs[ptr + 1], ge2);
                errs[ptr + 2] = S_SAT_ADD((int) errs[ptr + 2], re2);

                ptr += 3;

                errs[ptr    ] = S_SAT_ADD((int) errs[ptr    ], be3);
                errs[ptr + 1] = S_SAT_ADD((int) errs[ptr + 1], ge3);
                errs[ptr + 2] = S_SAT_ADD((int) errs[ptr + 2], re3);
                }
        }
/*...e*/
/*...sgbm_errdiff_7R8G4B      \45\ error diffuse to 7Rx8Gx4B:0:*/
bool gbm_errdiff_7R8G4B(GBM *gbm, byte *data24, byte *data8)
        {
        return errdiff(gbm, data24, data8, 8, gbm_errdiff_line_7R8G4B);
        }
/*...e*/

/*...sgbm_errdiff_pal_VGA     \45\ return default VGA palette:0:*/
/*
This function makes the palette for the 16 colour VGA palette.
*/

static GBMRGB gbmrgb_vga[] =
        {
          0,  0,  0,
        128,  0,  0,
          0,128,  0,
        128,128,  0,
          0,  0,128,
        128,  0,128,
          0,128,128,
        128,128,128,
        204,204,204,
        255,  0,  0,
          0,255,  0,
        255,255,  0,
          0,  0,255,
        255,  0,255,
          0,255,255,
        255,255,255,
        };

void gbm_errdiff_pal_VGA(GBMRGB *gbmrgb)
        {
        init();
        memcpy((char *) gbmrgb, (char *) gbmrgb_vga, sizeof(gbmrgb_vga));
        }
/*...e*/
/*...sgbm_errdiff_line_VGA    \45\ error diffuse to default VGA palette one line:0:*/
/*
This function takes a line of RGB data, a destination buffer and a buffer of
error terms and performs one lines worth (a given # of pixels) of error
diffusion.
*/

/*...scalc_nearest:0:*/
/*
This function, when given am RGB colour, finds the VGA palette entry closest
to it. We deliberately bias away from the two grey palette entries.
*/

static byte calc_nearest(byte r, byte g, byte b)
        {
        long min_dist = 3L * 256L * 256L * 10L;
        byte bi, bi_min;

        for ( bi = 0; bi < 0x10; bi++ )
                {
                long b_dist = ((long) b - (long) gbmrgb_vga[bi].b);
                long g_dist = ((long) g - (long) gbmrgb_vga[bi].g);
                long r_dist = ((long) r - (long) gbmrgb_vga[bi].r);
                long dist = r_dist * r_dist + g_dist * g_dist + b_dist * b_dist;

                if ( bi == 7 || bi == 8 )
                        /* Bias away from this colour */
                        dist <<= 3;

                if ( dist < min_dist )
                        {
                        min_dist = dist;
                        bi_min = bi;
                        }
                }
        return bi_min;
        }
/*...e*/
/*...snearest_colour:0:*/
/*
This function finds the closest VGA palette colour to a given RGB value.
It uses a lookup table to avoid performing distance calculations to the
16 palette entrys. The table is pre-calculated.
*/

/*...squick lookup table:0:*/
/*...v_gbmerr\46\c \45\ used to make quick_tab:0:*/

static byte quick_tab[16][16][16] =
        {
        0,0,0,0,255,4,4,4,4,4,4,4,12,12,12,12,
        0,0,0,0,255,4,4,4,4,4,4,4,12,12,12,12,
        0,0,0,0,255,4,4,4,4,4,4,4,12,12,12,12,
        0,0,0,0,255,4,4,4,4,4,4,4,12,12,12,12,
        255,255,255,255,255,255,255,255,255,255,255,255,255,12,12,12,
        2,2,2,2,255,6,6,6,6,6,6,6,6,255,12,12,
        2,2,2,2,255,6,6,6,6,6,6,6,6,6,255,12,
        2,2,2,2,255,6,6,6,6,6,6,6,6,6,6,255,
        2,2,2,2,255,6,6,6,6,6,6,6,6,6,6,255,
        2,2,2,2,255,6,6,6,6,6,6,6,6,6,255,14,
        2,2,2,2,255,6,6,6,6,6,6,6,6,255,14,14,
        2,2,2,2,255,6,6,6,6,6,6,6,255,14,14,14,
        10,10,10,10,255,6,6,6,6,6,6,255,14,14,14,14,
        10,10,10,10,10,255,6,6,6,6,255,14,14,14,14,14,
        10,10,10,10,10,10,255,6,6,255,14,14,14,14,14,14,
        10,10,10,10,10,10,10,255,255,14,14,14,14,14,14,14,
        0,0,0,0,255,4,4,4,4,4,4,4,12,12,12,12,
        0,0,0,0,255,4,4,4,4,4,4,4,12,12,12,12,
        0,0,0,0,255,4,4,4,4,4,4,4,12,12,12,12,
        0,0,0,0,255,4,4,4,4,4,4,4,12,12,12,12,
        255,255,255,255,255,255,255,255,255,255,255,255,255,12,12,12,
        2,2,2,2,255,6,6,6,6,6,6,6,6,255,12,12,
        2,2,2,2,255,6,6,6,6,6,6,6,6,6,255,12,
        2,2,2,2,255,6,6,6,6,6,6,6,6,6,6,255,
        2,2,2,2,255,6,6,6,6,6,6,6,6,6,6,255,
        2,2,2,2,255,6,6,6,6,6,6,6,6,6,255,14,
        2,2,2,2,255,6,6,6,6,6,6,6,6,255,14,14,
        2,2,2,2,255,6,6,6,6,6,6,6,255,14,14,14,
        10,10,10,10,255,6,6,6,6,6,6,255,14,14,14,14,
        10,10,10,10,10,255,6,6,6,6,255,14,14,14,14,14,
        10,10,10,10,10,10,255,6,6,255,14,14,14,14,14,14,
        10,10,10,10,10,10,10,255,255,14,14,14,14,14,14,14,
        0,0,0,0,255,4,4,4,4,4,4,4,12,12,12,12,
        0,0,0,0,255,4,4,4,4,4,4,4,12,12,12,12,
        0,0,0,0,255,4,4,4,4,4,4,4,12,12,12,12,
        0,0,0,0,255,4,4,4,4,4,4,4,12,12,12,12,
        255,255,255,255,255,255,255,255,255,255,255,255,255,12,12,12,
        2,2,2,2,255,6,6,6,6,6,6,6,6,255,12,12,
        2,2,2,2,255,6,6,6,6,6,6,6,6,6,255,12,
        2,2,2,2,255,6,6,6,6,6,6,6,6,6,6,255,
        2,2,2,2,255,6,6,6,6,6,6,6,6,6,6,255,
        2,2,2,2,255,6,6,6,6,6,6,6,6,6,255,14,
        2,2,2,2,255,6,6,6,6,6,6,6,6,255,14,14,
        2,2,2,2,255,6,6,6,6,6,6,6,255,14,14,14,
        10,10,10,10,255,6,6,6,6,6,6,255,14,14,14,14,
        10,10,10,10,10,255,6,6,6,6,255,14,14,14,14,14,
        10,10,10,10,10,10,255,6,6,255,14,14,14,14,14,14,
        10,10,10,10,10,10,10,255,255,14,14,14,14,14,14,14,
        0,0,0,0,255,4,4,4,4,4,4,4,12,12,12,12,
        0,0,0,0,255,4,4,4,4,4,4,4,12,12,12,12,
        0,0,0,0,255,4,4,4,4,4,4,4,12,12,12,12,
        0,0,0,0,255,4,4,4,4,4,4,4,12,12,12,12,
        255,255,255,255,255,255,255,255,255,255,255,255,255,12,12,12,
        2,2,2,2,255,6,6,6,6,6,6,6,6,255,12,12,
        2,2,2,2,255,6,6,6,6,6,6,6,6,6,255,12,
        2,2,2,2,255,6,6,6,6,6,6,6,6,6,6,255,
        2,2,2,2,255,6,6,6,6,6,6,6,6,6,6,255,
        2,2,2,2,255,6,6,6,6,6,6,6,6,6,255,14,
        2,2,2,2,255,6,6,6,6,6,6,6,6,255,14,14,
        2,2,2,2,255,6,6,6,6,6,6,6,255,14,14,14,
        10,10,10,10,255,6,6,6,6,6,6,255,14,14,14,14,
        10,10,10,10,10,255,6,6,6,6,255,14,14,14,14,14,
        10,10,10,10,10,10,255,6,6,255,14,14,14,14,14,14,
        10,10,10,10,10,10,10,255,255,14,14,14,14,14,14,14,
        255,255,255,255,255,255,255,255,255,255,255,255,255,12,12,12,
        255,255,255,255,255,255,255,255,255,255,255,255,255,12,12,12,
        255,255,255,255,255,255,255,255,255,255,255,255,255,12,12,12,
        255,255,255,255,255,255,255,255,255,255,255,255,255,12,12,12,
        255,255,255,255,255,255,255,255,255,255,255,255,255,12,12,12,
        255,255,255,255,255,6,6,6,6,6,6,6,6,255,12,12,
        255,255,255,255,255,6,6,6,6,6,6,6,6,6,255,12,
        255,255,255,255,255,6,6,6,6,6,6,6,6,6,6,255,
        255,255,255,255,255,6,6,6,6,6,6,6,6,6,6,255,
        255,255,255,255,255,6,6,6,6,6,6,6,6,6,255,14,
        255,255,255,255,255,6,6,6,6,6,6,6,6,255,14,14,
        255,255,255,255,255,6,6,6,6,6,6,6,255,14,14,14,
        255,255,255,255,255,6,6,6,6,6,6,255,14,14,14,14,
        10,10,10,10,10,255,6,6,6,6,255,14,14,14,14,14,
        10,10,10,10,10,10,255,6,6,255,14,14,14,14,14,14,
        10,10,10,10,10,10,10,255,255,14,14,14,14,14,14,14,
        1,1,1,1,255,5,5,5,5,5,5,5,5,255,12,12,
        1,1,1,1,255,5,5,5,5,5,5,5,5,255,12,12,
        1,1,1,1,255,5,5,5,5,5,5,5,5,255,12,12,
        1,1,1,1,255,5,5,5,5,5,5,5,5,255,12,12,
        255,255,255,255,255,5,5,5,5,5,5,5,5,255,12,12,
        3,3,3,3,3,255,255,255,255,255,255,255,255,255,12,12,
        3,3,3,3,3,255,6,6,6,6,6,6,6,6,255,12,
        3,3,3,3,3,255,6,255,255,6,6,6,6,6,6,255,
        3,3,3,3,3,255,6,255,255,6,6,6,6,6,6,255,
        3,3,3,3,3,255,6,6,6,6,6,6,6,6,255,14,
        3,3,3,3,3,255,6,6,6,6,6,6,6,255,14,14,
        3,3,3,3,3,255,6,6,6,6,6,6,255,14,14,14,
        3,3,3,3,3,255,6,6,6,6,6,255,14,14,14,14,
        255,255,255,255,255,255,6,6,6,6,255,14,14,14,14,14,
        10,10,10,10,10,10,255,6,6,255,14,14,14,14,14,14,
        10,10,10,10,10,10,10,255,255,14,14,14,14,14,14,14,
        1,1,1,1,255,5,5,5,5,5,5,5,5,5,255,12,
        1,1,1,1,255,5,5,5,5,5,5,5,5,5,255,12,
        1,1,1,1,255,5,5,5,5,5,5,5,5,5,255,12,
        1,1,1,1,255,5,5,5,5,5,5,5,5,5,255,12,
        255,255,255,255,255,5,5,5,5,5,5,5,5,5,255,12,
        3,3,3,3,3,255,5,5,5,5,5,5,5,5,255,12,
        3,3,3,3,3,3,255,255,255,255,255,255,255,255,255,12,
        3,3,3,3,3,3,255,255,255,255,255,6,6,6,6,255,
        3,3,3,3,3,3,255,255,255,255,255,6,6,6,6,255,
        3,3,3,3,3,3,255,255,255,255,255,6,6,6,255,14,
        3,3,3,3,3,3,255,255,255,255,6,6,6,255,14,14,
        3,3,3,3,3,3,255,6,6,6,6,6,255,14,14,14,
        3,3,3,3,3,3,255,6,6,6,6,255,14,14,14,14,
        3,3,3,3,3,3,255,6,6,6,255,14,14,14,14,14,
        255,255,255,255,255,255,255,6,6,255,14,14,14,14,14,14,
        10,10,10,10,10,10,10,255,255,14,14,14,14,14,14,14,
        1,1,1,1,255,5,5,5,5,5,5,5,5,5,5,255,
        1,1,1,1,255,5,5,5,5,5,5,5,5,5,5,255,
        1,1,1,1,255,5,5,5,5,5,5,5,5,5,5,255,
        1,1,1,1,255,5,5,5,5,5,5,5,5,5,5,255,
        255,255,255,255,255,5,5,5,5,5,5,5,5,5,5,255,
        3,3,3,3,3,255,5,255,255,5,5,5,5,5,5,255,
        3,3,3,3,3,3,255,255,255,255,255,5,5,5,5,255,
        3,3,3,3,3,255,255,7,7,7,255,255,255,255,255,255,
        3,3,3,3,3,255,255,7,7,7,255,6,6,6,6,255,
        3,3,3,3,3,3,255,7,7,255,255,6,6,6,255,14,
        3,3,3,3,3,3,255,255,255,255,255,6,6,255,14,14,
        3,3,3,3,3,3,3,255,6,6,6,6,255,14,14,14,
        3,3,3,3,3,3,3,255,6,6,6,255,14,14,14,14,
        3,3,3,3,3,3,3,255,6,6,255,14,14,14,14,14,
        3,3,3,3,3,3,3,255,6,255,14,14,14,14,14,14,
        255,255,255,255,255,255,255,255,255,14,14,14,14,14,14,14,
        1,1,1,1,255,5,5,5,5,5,5,5,5,5,5,255,
        1,1,1,1,255,5,5,5,5,5,5,5,5,5,5,255,
        1,1,1,1,255,5,5,5,5,5,5,5,5,5,5,255,
        1,1,1,1,255,5,5,5,5,5,5,5,5,5,5,255,
        255,255,255,255,255,5,5,5,5,5,5,5,5,5,5,255,
        3,3,3,3,3,255,5,255,255,5,5,5,5,5,5,255,
        3,3,3,3,3,3,255,255,255,255,255,5,5,5,5,255,
        3,3,3,3,3,255,255,7,7,7,255,5,5,5,5,255,
        3,3,3,3,3,255,255,7,7,7,255,255,255,255,255,255,
        3,3,3,3,3,3,255,7,7,7,255,255,255,255,255,15,
        3,3,3,3,3,3,255,255,255,255,255,255,255,255,15,15,
        3,3,3,3,3,3,3,3,255,255,255,255,255,15,15,15,
        3,3,3,3,3,3,3,3,255,255,255,255,15,15,15,15,
        3,3,3,3,3,3,3,3,255,255,255,15,15,15,15,15,
        3,3,3,3,3,3,3,3,255,255,15,15,15,15,15,15,
        255,255,255,255,255,255,255,255,255,15,15,15,15,15,15,15,
        1,1,1,1,255,5,5,5,5,5,5,5,5,5,255,13,
        1,1,1,1,255,5,5,5,5,5,5,5,5,5,255,13,
        1,1,1,1,255,5,5,5,5,5,5,5,5,5,255,13,
        1,1,1,1,255,5,5,5,5,5,5,5,5,5,255,13,
        255,255,255,255,255,5,5,5,5,5,5,5,5,5,255,13,
        3,3,3,3,3,255,5,5,5,5,5,5,5,5,255,13,
        3,3,3,3,3,3,255,255,255,255,255,5,5,5,255,13,
        3,3,3,3,3,3,255,7,7,255,255,5,5,5,255,13,
        3,3,3,3,3,3,255,7,7,7,255,255,255,255,255,15,
        3,3,3,3,3,3,255,255,7,7,255,255,255,15,15,15,
        3,3,3,3,3,3,255,255,255,255,255,255,15,15,15,15,
        3,3,3,3,3,3,3,3,255,255,255,15,15,15,15,15,
        3,3,3,3,3,3,3,3,255,255,15,15,15,15,15,15,
        3,3,3,3,3,3,3,3,255,15,15,15,15,15,15,15,
        255,255,255,255,255,255,255,255,255,15,15,15,15,15,15,15,
        11,11,11,11,11,11,11,11,15,15,15,15,15,15,15,15,
        1,1,1,1,255,5,5,5,5,5,5,5,5,255,13,13,
        1,1,1,1,255,5,5,5,5,5,5,5,5,255,13,13,
        1,1,1,1,255,5,5,5,5,5,5,5,5,255,13,13,
        1,1,1,1,255,5,5,5,5,5,5,5,5,255,13,13,
        255,255,255,255,255,5,5,5,5,5,5,5,5,255,13,13,
        3,3,3,3,3,255,5,5,5,5,5,5,5,255,13,13,
        3,3,3,3,3,3,255,255,255,255,5,5,5,255,13,13,
        3,3,3,3,3,3,255,255,255,255,255,5,5,255,13,13,
        3,3,3,3,3,3,255,255,255,255,255,255,255,255,15,15,
        3,3,3,3,3,3,255,255,255,255,255,255,15,15,15,15,
        3,3,3,3,3,3,3,255,255,255,255,255,255,255,15,15,
        3,3,3,3,3,3,3,3,255,255,255,255,255,255,255,15,
        3,3,3,3,3,3,3,3,255,15,255,255,255,255,255,15,
        255,255,255,255,255,255,255,255,255,15,255,255,255,255,15,15,
        11,11,11,11,11,11,11,11,15,15,15,255,255,15,15,15,
        11,11,11,11,11,11,11,11,15,15,15,15,15,15,15,15,
        1,1,1,1,255,5,5,5,5,5,5,5,255,13,13,13,
        1,1,1,1,255,5,5,5,5,5,5,5,255,13,13,13,
        1,1,1,1,255,5,5,5,5,5,5,5,255,13,13,13,
        1,1,1,1,255,5,5,5,5,5,5,5,255,13,13,13,
        255,255,255,255,255,5,5,5,5,5,5,5,255,13,13,13,
        3,3,3,3,3,255,5,5,5,5,5,5,255,13,13,13,
        3,3,3,3,3,3,255,5,5,5,5,5,255,13,13,13,
        3,3,3,3,3,3,3,255,5,5,5,5,255,13,13,13,
        3,3,3,3,3,3,3,3,255,255,255,255,255,15,15,15,
        3,3,3,3,3,3,3,3,255,255,255,15,15,15,15,15,
        3,3,3,3,3,3,3,3,255,255,255,255,255,255,255,15,
        3,3,3,3,3,3,3,3,255,15,255,255,8,255,255,15,
        255,255,255,255,255,255,255,255,255,15,255,8,8,8,255,15,
        11,11,11,11,11,11,11,11,15,15,255,255,8,255,255,15,
        11,11,11,11,11,11,11,11,15,15,255,255,255,255,15,15,
        11,11,11,11,11,11,11,11,15,15,15,15,15,15,15,15,
        9,9,9,9,255,5,5,5,5,5,5,255,13,13,13,13,
        9,9,9,9,255,5,5,5,5,5,5,255,13,13,13,13,
        9,9,9,9,255,5,5,5,5,5,5,255,13,13,13,13,
        9,9,9,9,255,5,5,5,5,5,5,255,13,13,13,13,
        255,255,255,255,255,5,5,5,5,5,5,255,13,13,13,13,
        3,3,3,3,3,255,5,5,5,5,5,255,13,13,13,13,
        3,3,3,3,3,3,255,5,5,5,5,255,13,13,13,13,
        3,3,3,3,3,3,3,255,5,5,5,255,13,13,13,13,
        3,3,3,3,3,3,3,3,255,255,255,255,15,15,15,15,
        3,3,3,3,3,3,3,3,255,255,15,15,15,15,15,15,
        3,3,3,3,3,3,3,3,255,15,255,255,255,255,255,15,
        255,255,255,255,255,255,255,255,255,15,255,8,8,8,255,15,
        11,11,11,11,11,11,11,11,15,15,255,8,8,8,255,15,
        11,11,11,11,11,11,11,11,15,15,255,8,8,255,255,15,
        11,11,11,11,11,11,11,11,15,15,255,255,255,255,15,15,
        11,11,11,11,11,11,11,11,15,15,15,15,15,15,15,15,
        9,9,9,9,9,255,5,5,5,5,255,13,13,13,13,13,
        9,9,9,9,9,255,5,5,5,5,255,13,13,13,13,13,
        9,9,9,9,9,255,5,5,5,5,255,13,13,13,13,13,
        9,9,9,9,9,255,5,5,5,5,255,13,13,13,13,13,
        9,9,9,9,9,255,5,5,5,5,255,13,13,13,13,13,
        255,255,255,255,255,255,5,5,5,5,255,13,13,13,13,13,
        3,3,3,3,3,3,255,5,5,5,255,13,13,13,13,13,
        3,3,3,3,3,3,3,255,5,5,255,13,13,13,13,13,
        3,3,3,3,3,3,3,3,255,255,255,15,15,15,15,15,
        3,3,3,3,3,3,3,3,255,15,15,15,15,15,15,15,
        255,255,255,255,255,255,255,255,255,15,255,255,255,255,15,15,
        11,11,11,11,11,11,11,11,15,15,255,255,8,255,255,15,
        11,11,11,11,11,11,11,11,15,15,255,8,8,255,255,15,
        11,11,11,11,11,11,11,11,15,15,255,255,255,255,255,15,
        11,11,11,11,11,11,11,11,15,15,15,255,255,255,15,15,
        11,11,11,11,11,11,11,11,15,15,15,15,15,15,15,15,
        9,9,9,9,9,9,255,5,5,255,13,13,13,13,13,13,
        9,9,9,9,9,9,255,5,5,255,13,13,13,13,13,13,
        9,9,9,9,9,9,255,5,5,255,13,13,13,13,13,13,
        9,9,9,9,9,9,255,5,5,255,13,13,13,13,13,13,
        9,9,9,9,9,9,255,5,5,255,13,13,13,13,13,13,
        9,9,9,9,9,9,255,5,5,255,13,13,13,13,13,13,
        255,255,255,255,255,255,255,5,5,255,13,13,13,13,13,13,
        3,3,3,3,3,3,3,255,5,255,13,13,13,13,13,13,
        3,3,3,3,3,3,3,3,255,255,15,15,15,15,15,15,
        255,255,255,255,255,255,255,255,255,15,15,15,15,15,15,15,
        11,11,11,11,11,11,11,11,15,15,15,255,255,15,15,15,
        11,11,11,11,11,11,11,11,15,15,255,255,255,255,15,15,
        11,11,11,11,11,11,11,11,15,15,255,255,255,255,15,15,
        11,11,11,11,11,11,11,11,15,15,15,255,255,255,15,15,
        11,11,11,11,11,11,11,11,15,15,15,15,15,15,15,15,
        11,11,11,11,11,11,11,11,15,15,15,15,15,15,15,15,
        9,9,9,9,9,9,9,255,255,13,13,13,13,13,13,13,
        9,9,9,9,9,9,9,255,255,13,13,13,13,13,13,13,
        9,9,9,9,9,9,9,255,255,13,13,13,13,13,13,13,
        9,9,9,9,9,9,9,255,255,13,13,13,13,13,13,13,
        9,9,9,9,9,9,9,255,255,13,13,13,13,13,13,13,
        9,9,9,9,9,9,9,255,255,13,13,13,13,13,13,13,
        9,9,9,9,9,9,9,255,255,13,13,13,13,13,13,13,
        255,255,255,255,255,255,255,255,255,13,13,13,13,13,13,13,
        255,255,255,255,255,255,255,255,255,15,15,15,15,15,15,15,
        11,11,11,11,11,11,11,11,15,15,15,15,15,15,15,15,
        11,11,11,11,11,11,11,11,15,15,15,15,15,15,15,15,
        11,11,11,11,11,11,11,11,15,15,15,15,15,15,15,15,
        11,11,11,11,11,11,11,11,15,15,15,15,15,15,15,15,
        11,11,11,11,11,11,11,11,15,15,15,15,15,15,15,15,
        11,11,11,11,11,11,11,11,15,15,15,15,15,15,15,15,
        11,11,11,11,11,11,11,11,15,15,15,15,15,15,15,15,
        };
/*...e*/

static byte nearest_colour(byte r, byte g, byte b)
        {
        byte i;

        if ( (i = quick_tab[r >> 4][g >> 4][b >> 4]) != (byte) 0xff )
                return i;

        return calc_nearest(r, g, b);
        }
/*...e*/

void gbm_errdiff_line_VGA(byte *src, byte *dest, short *errs, int cx)
        {
        bool left = TRUE;
        int x, ptr = 0;

        init();

        /* Step 1: Add error terms to newly supplied line */

        for ( x = 0; x < cx * 3; x++ )
                src[x] = U_SAT_ADD((int) src[x], (int) errs[x]);

        /* Step 2: Zero out error terms */

        memset(errs, 0, (cx + 1) * 3 * sizeof(errs[0]));

        /* Step 3: Go along data, finding nearest colour and propagating error */

        randinx = rand();

        for ( x = 0; x < cx; x++ )
                {
                byte b     = *src++;
                byte g     = *src++;
                byte r     = *src++;
                byte bi    = nearest_colour(r, g, b);
                int  be    = (int) b - (int) gbmrgb_vga[bi].b;
                int  ge    = (int) g - (int) gbmrgb_vga[bi].g;
                int  re    = (int) r - (int) gbmrgb_vga[bi].r;
                word rn    = randtab[(byte) (randinx++)];
                int  right = (rn >> 8);
                int  down  = ((rn & 0xff) % (63 - right));
                int  be1   = ((be * right) >> 6);
                int  ge1   = ((ge * right) >> 6);
                int  re1   = ((re * right) >> 6);
                int  be2   = ((be * down) >> 6);
                int  ge2   = ((ge * down) >> 6);
                int  re2   = ((re * down) >> 6);
                int  be3   = be - be1 - be2;
                int  ge3   = ge - ge1 - ge2;
                int  re3   = re - re1 - re2;

                if ( left )
                        *dest = (byte) (bi << 4);
                else
                        *dest++ |= bi;

                left = !left;

                src[0] = U_SAT_ADD((int) src[0], be1);
                src[1] = U_SAT_ADD((int) src[1], ge1);
                src[2] = U_SAT_ADD((int) src[2], re1);

                errs[ptr    ] = S_SAT_ADD((int) errs[ptr    ], be2);
                errs[ptr + 1] = S_SAT_ADD((int) errs[ptr + 1], ge2);
                errs[ptr + 2] = S_SAT_ADD((int) errs[ptr + 2], re2);

                ptr += 3;

                errs[ptr    ] = S_SAT_ADD((int) errs[ptr    ], be3);
                errs[ptr + 1] = S_SAT_ADD((int) errs[ptr + 1], ge3);
                errs[ptr + 2] = S_SAT_ADD((int) errs[ptr + 2], re3);
                }
        }
/*...e*/
/*...sgbm_errdiff_VGA         \45\ error diffuse to default VGA palette:0:*/
bool gbm_errdiff_VGA(GBM *gbm, byte *data24, byte *data4)
        {
        return errdiff(gbm, data24, data4, 4, gbm_errdiff_line_VGA);
        }
/*...e*/

/*...sgbm_errdiff_pal_8       \45\ return default 8 colour palette:0:*/
/*
This function makes the palette for the 16 colour 8 colour palette.
*/

static GBMRGB gbmrgb_8[] =
        {
          0,  0,  0,
          0,  0,255,
          0,255,  0,
          0,255,255,
        255,  0,  0,
        255,  0,255,
        255,255,  0,
        255,255,255,
          0,  0,  0,
          0,  0,  0,
          0,  0,  0,
          0,  0,  0,
          0,  0,  0,
          0,  0,  0,
          0,  0,  0,
          0,  0,  0,
        };

void gbm_errdiff_pal_8(GBMRGB *gbmrgb)
        {
        init();
        memcpy((char *) gbmrgb, (char *) gbmrgb_8, sizeof(gbmrgb_8));
        }
/*...e*/
/*...sgbm_errdiff_line_8      \45\ error diffuse to default 8 colour palette one line:0:*/
/*
This function takes a line of RGB data, a destination buffer and a buffer of
error terms and performs one lines worth (a given # of pixels) of error
diffusion.
*/

void gbm_errdiff_line_8(byte *src, byte *dest, short *errs, int cx)
        {
        bool left = TRUE;
        int x, ptr = 0;

        init();

        /* Step 1: Add error terms to newly supplied line */

        for ( x = 0; x < cx * 3; x++ )
                src[x] = U_SAT_ADD((int) src[x], (int) errs[x]);

        /* Step 2: Zero out error terms */

        memset(errs, 0, (cx + 1) * 3 * sizeof(errs[0]));

        /* Step 3: Go along data, finding nearest colour and propagating error */

        randinx = rand();

        for ( x = 0; x < cx; x++ )
                {
                byte b     = *src++;
                byte g     = *src++;
                byte r     = *src++;
                byte bi    = ((r&0x80)>>5) | ((g&0x80)>>6) | ((b&0x80)>>7);
                int  be    = (int) b - (int) gbmrgb_8[bi].b;
                int  ge    = (int) g - (int) gbmrgb_8[bi].g;
                int  re    = (int) r - (int) gbmrgb_8[bi].r;
                word rn    = randtab[(byte) (randinx++)];
                int  right = (rn >> 8);
                int  down  = ((rn & 0xff) % (63 - right));
                int  be1   = ((be * right) >> 6);
                int  ge1   = ((ge * right) >> 6);
                int  re1   = ((re * right) >> 6);
                int  be2   = ((be * down) >> 6);
                int  ge2   = ((ge * down) >> 6);
                int  re2   = ((re * down) >> 6);
                int  be3   = be - be1 - be2;
                int  ge3   = ge - ge1 - ge2;
                int  re3   = re - re1 - re2;

                if ( left )
                        *dest = (byte) (bi << 4);
                else
                        *dest++ |= bi;

                left = !left;

                src[0] = U_SAT_ADD((int) src[0], be1);
                src[1] = U_SAT_ADD((int) src[1], ge1);
                src[2] = U_SAT_ADD((int) src[2], re1);

                errs[ptr    ] = S_SAT_ADD((int) errs[ptr    ], be2);
                errs[ptr + 1] = S_SAT_ADD((int) errs[ptr + 1], ge2);
                errs[ptr + 2] = S_SAT_ADD((int) errs[ptr + 2], re2);

                ptr += 3;

                errs[ptr    ] = S_SAT_ADD((int) errs[ptr    ], be3);
                errs[ptr + 1] = S_SAT_ADD((int) errs[ptr + 1], ge3);
                errs[ptr + 2] = S_SAT_ADD((int) errs[ptr + 2], re3);
                }
        }
/*...e*/
/*...sgbm_errdiff_8           \45\ error diffuse to default 8 colour palette:0:*/
bool gbm_errdiff_8(GBM *gbm, byte *data24, byte *data4)
        {
        return errdiff(gbm, data24, data4, 4, gbm_errdiff_line_8);
        }
/*...e*/

/*...sgbm_errdiff_pal_4G      \45\ return 4 bit greyscale palette:0:*/
/*
This function makes the palette for the 16 colour VGA palette.
*/

void gbm_errdiff_pal_4G(GBMRGB *gbmrgb)
        {
        int i;

        init();
        for ( i = 0; i < 0x10; i++ )
                {
                gbmrgb[i].r = scale16[i];
                gbmrgb[i].g = scale16[i];
                gbmrgb[i].b = scale16[i];
                }
        }
/*...e*/
/*...sgbm_errdiff_line_4G     \45\ error diffuse to 4 bit greyscale palette one line:0:*/
/*
This function takes a line of RGB data, a destination buffer and a buffer of
error terms and performs one lines worth (a given # of pixels) of error
diffusion.
*/

void gbm_errdiff_line_4G(byte *src, byte *dest, short *errs, int cx)
        {
        bool left = TRUE;
        int x, ptr = 0;
        byte *pb;

        init();

        /* Step 1: Add error terms to newly supplied line */

        for ( x = 0, pb = src; x < cx; x++ )
                {
                byte b = *pb++;
                byte g = *pb++;
                byte r = *pb++;

                src[x] = (byte) (((word) r * 77 + (word) g * 151 + (word) b * 28) >> 8);
                src[x] = U_SAT_ADD((int) src[x], (int) errs[x]);
                }

        /* Step 2: Zero out error terms */

        memset(errs, 0, (cx + 1) * sizeof(errs[0]));

        /* Step 3: Go along data, finding nearest colour and propagating error */

        randinx = rand();

        for ( x = 0; x < cx; x++ )
                {
                byte grey  = *src++;
                byte inx   = index16[grey];
                int  err   = (int) grey - (int) scale16[inx];
                word rn    = randtab[(byte) (randinx++)];
                int  right = (rn >> 8);
                int  down  = ((rn & 0xff) % (63 - right));
                int  err1  = ((err * right) >> 6);
                int  err2  = ((err * down ) >> 6);
                int  err3  = err - err1 - err2;

                if ( left )
                        *dest = (byte) (inx << 4);
                else
                        *dest++ |= inx;

                left = !left;

                src[0] = U_SAT_ADD((int) src[0], err1);

                errs[ptr] = S_SAT_ADD((int) errs[ptr], err2);

                ptr++;

                errs[ptr] = S_SAT_ADD((int) errs[ptr], err3);
                }
        }
/*...e*/
/*...sgbm_errdiff_4G          \45\ error diffuse to 4 bit greyscale palette:0:*/
bool gbm_errdiff_4G(GBM *gbm, byte *data24, byte *data4)
        {
        return errdiff(gbm, data24, data4, 4, gbm_errdiff_line_4G);
        }
/*...e*/

/*...sgbm_errdiff_pal_BW      \45\ return black and white palette:0:*/
/*
This function returns the b/w palette.
(We consider the image to be likely black on white,
hence the ordering of the palette entries).
*/

static GBMRGB gbmrgb_bw[] =
        {
        255,255,255,
        0,0,0,
        };

void gbm_errdiff_pal_BW(GBMRGB *gbmrgb)
        {
        init();
        memcpy((char *) gbmrgb, (char *) gbmrgb_bw, sizeof(gbmrgb_bw));
        }
/*...e*/
/*...sgbm_errdiff_line_BW     \45\ error diffuse to black and white one line:0:*/
/*
This function takes a line of RGB data, a destination buffer and a buffer of
error terms and performs one lines worth (a given # of pixels) of error
diffusion.
*/

void gbm_errdiff_line_BW(byte *src, byte *dest, short *errs, int cx)
        {
        int x, bit = 0, ptr = 0;
        byte *pb;

        init();

        /* Step 1: Add error terms to newly supplied line */

        for ( x = 0, pb = src; x < cx; x++ )
                {
                byte b = *pb++;
                byte g = *pb++;
                byte r = *pb++;

                src[x] = (byte) (((word) r * 77 + (word) g * 151 + (word) b * 28) >> 8);
                src[x] = U_SAT_ADD((int) src[x], (int) errs[x]);
                }

        /* Step 2: Zero out error terms */

        memset(errs, 0, (cx + 1) * sizeof(errs[0]));

        /* Step 3: Go along data, finding nearest colour and propagating error */

        memset(dest, 0, (cx + 7) >> 3);

        randinx = rand();

        for ( x = 0; x < cx; x++ )
                {
                byte grey  = *src++;
                byte inx   = (byte) (grey < 0x80);
                int  err   = (int) grey - (int) gbmrgb_bw[inx].b;
                word rn    = randtab[(byte) (randinx++)];
                int  right = (rn >> 8);
                int  down  = ((rn & 0xff) % (63 - right));
                int  err1  = ((err * right) >> 6);
                int  err2  = ((err * down ) >> 6);
                int  err3  = err - err1 - err2;

                if ( inx )
                        *dest |= (0x80 >> bit);

                if ( ++bit == 8 )
                        {
                        bit = 0;
                        dest++;
                        }

                src[0] = U_SAT_ADD((int) src[0], err1);

                errs[ptr] = S_SAT_ADD((int) errs[ptr], err2);

                ptr++;

                errs[ptr] = S_SAT_ADD((int) errs[ptr], err3);
                }
        }
/*...e*/
/*...sgbm_errdiff_BW          \45\ error diffuse to black and white:0:*/
bool gbm_errdiff_BW(GBM *gbm, byte *data24, byte *data1)
        {
        return errdiff(gbm, data24, data1, 1, gbm_errdiff_line_BW);
        }
/*...e*/
/*
*****************************************************************************************
*                                                                                       *
* COPYRIGHT:                                                                            *
*   IBM Open Class Library                                                              *
*   (C) Copyright International Business Machines Corporation,  1997                    *
*   Licensed Material - Program-Property of IBM - All Rights Reserved.                  *
*   US Government Users Restricted Rights - Use, duplication, or disclosure             *
*   restricted by GSA ADP Schedule Contract with IBM Corp.                              *
*                                                                                       *
*****************************************************************************************
*/
// Revision: 56 1.4.1.5 source/ographic/igbm.cpp, graphics, ioc.v400, 001006 
/*

IGBMHT.C  Halftoner

*/

#if 0
#pragma priority( -2147481424 )

/*...sincludes:0:*/
#include <stdio.h>
#include <stddef.h>
#include <stdlib.h>
#include <string.h>
#include <memory.h>
#include "igbmstnd.hpp"
#include "igbm.hpp"
#include <ibase.hpp>

// Segment definitions
#ifdef IC_PAGETUNE
  #define _IGBMHT_CPP_
  #include <ipagetun.h>
#endif
#endif // 0

/*...vgbm\46\h:0:*/
/*...e*/
/*...svars:0:*/
static bool _inited = FALSE;

/*
For 6Rx6Gx6B, 7Rx8Gx4B palettes etc.
*/

static byte _index4[0x400];
static byte _index6[0x400];
static byte _index7[0x400];
static byte _index8[0x400];
static byte _scale4[] = { 0, 85, 170, 255 };
static byte _scale6[] = { 0, 51, 102, 153, 204, 255 };
static byte _scale7[] = { 0, 43, 85, 128, 170, 213, 255 };
static byte _scale8[] = { 0, 36, 73, 109, 146, 182, 219, 255 };

static byte map_to_012[0x900];
        /* Returns 0 if index <  0x80                  */
        /*         1 if index >= 0x80 and index < 0xff */
        /*         2 if index  = 0xff                  */
static byte map_to_inx[3][3][3];

static GBMRGB gbmRGBvga[] =
        {
          0,  0,  0,
        128,  0,  0,
          0,128,  0,
        128,128,  0,
          0,  0,128,
        128,  0,128,
          0,128,128,
        128,128,128,
        204,204,204,
        255,  0,  0,
          0,255,  0,
        255,255,  0,
          0,  0,255,
        255,  0,255,
          0,255,255,
        255,255,255,
        };

static GBMRGB gbmRGB8[] =
        {
          0,  0,  0,
          0,  0,255,
          0,255,  0,
          0,255,255,
        255,  0,  0,
        255,  0,255,
        255,255,  0,
        255,255,255,
          0,  0,  0,
          0,  0,  0,
          0,  0,  0,
          0,  0,  0,
          0,  0,  0,
          0,  0,  0,
          0,  0,  0,
          0,  0,  0,
        };
/*...e*/
/*...sdivt:0:*/
/*
This fold encompases a way to get rapid division via lookup tables.
*/

static word divt9[9 * 0x100];
static word divt7[9 * 0x100];
static word divt6[9 * 0x100];
static word divt5[9 * 0x100];
static word divt3[9 * 0x100];

/*...smake_divt:0:*/
static void make_divt(word *divt, int size, int by)
        {
        int i;

        for ( i = 0; i < size; i++ )
                divt[i] = (word) (i / by);
        }
/*...e*/

#define div9(w) divt9[w]
#define div8(w) ((w)>>3)
#define div7(w) divt7[w]
#define div6(w) divt6[w]
#define div5(w) divt5[w]
#define div4(w) ((w)>>2)
#define div3(w) divt3[w]
#define div2(w) ((w)>>1)
/*...e*/
/*...sinit:0:*/
/*
This function initialises this module.
*/

/*...stakeout_inx:0:*/
/*
For the supplied value, find the index of the highest value in the scale
less than or equal to the value.
*/

static byte takeout_inx(int value, byte ab[], unsigned short cb)
        {
        byte inx = 0;
        unsigned short i;

        for ( i = 0; i < cb; i++ )
                if ( (unsigned short) ab[i] <= (unsigned short) value )
                        inx = i;

        return inx;
        }
/*...e*/
/*...stakeout_inx_vga:0:*/
/*
The idea is to take as much of the r, g and b as possible by chosing a
colour from the VGA palette that leaves as little left over as possible.
Since there are 2 mid-greys, we discourage the use of one.
The only justification for this is that the results seem to come out better!
Also, I have tried allowing takefrom to return the closest index, allowing
more to be taken than r,g and b. This gives less grey results, but the
output is a lot dirtier and speckled.
*/

static byte takeout_inx_vga(word r, word g, word b)
        {
        byte inx;
        byte inx_min = 0;
        int e_min = (int) ( r + g + b );

        for ( inx = 1; inx < 16; inx++ )
                if ( inx != 8 )
                        {
                        int re = (int) ( r - (word) gbmRGBvga[inx].r );
                        int ge = (int) ( g - (word) gbmRGBvga[inx].g );
                        int be = (int) ( b - (word) gbmRGBvga[inx].b );

                        if ( re >= 0 && ge >= 0 && be >= 0 )
                                {
                                int e = re + ge + be;

                                if ( e < e_min )
                                        {
                                        e_min = e;
                                        inx_min = inx;
                                        }
                                }
                        }
        return inx_min;
        }
/*...e*/

static void _init(void)
        {
        static word val[] = { 0, 0x80, 0xff };
        int i;
        int volatile r;         /* C-Set/2 optimiser fix */
        int volatile g;
        int volatile b;

        if ( _inited )
                return;

        /* For 7 Red x 8 Green x 4 Blue palettes etc. */

        for ( i = 0; i < 0x400; i++ )
                {
                _index4[i] = takeout_inx(i, _scale4 , sizeof(_scale4));
                _index6[i] = takeout_inx(i, _scale6 , sizeof(_scale6));
                _index7[i] = takeout_inx(i, _scale7 , sizeof(_scale7));
                _index8[i] = takeout_inx(i, _scale8 , sizeof(_scale8));
                }

        memset(map_to_012, 0, 0x80);
        memset(map_to_012 + 0x80, 1, 0x7f);
        memset(map_to_012 + 0xff, 2, 0x801);

        for ( r = 0; r < 3; r++ )
                for ( g = 0; g < 3; g++ )
                        for ( b = 0; b < 3; b++ )
                                map_to_inx[r][g][b] = takeout_inx_vga(val[r], val[g], val[b]);

        make_divt(divt9, sizeof(divt9)/sizeof(word), 9);
        make_divt(divt7, sizeof(divt7)/sizeof(word), 7);
        make_divt(divt6, sizeof(divt6)/sizeof(word), 6);
        make_divt(divt5, sizeof(divt5)/sizeof(word), 5);
        make_divt(divt3, sizeof(divt3)/sizeof(word), 3);

        _inited = TRUE;
        }
/*...e*/
/*...stakefrom:0:*/
#define takefrom(r,g,b) ( map_to_inx[map_to_012[r]][map_to_012[g]][map_to_012[b]] )
/*...e*/
/*...ssplit_into:0:*/
/* n is only ever 2, 3, 4, 6 or 9 */

static void split_into(
        word r, word g, word b,
        int n, byte *inxs
        )
        {
        byte inx;

        if ( n >= 9 )
                {
                inx = takefrom(div9(r), div9(g), div9(b));
                b -= gbmRGBvga[inx].b;
                g -= gbmRGBvga[inx].g;
                r -= gbmRGBvga[inx].r;
                *inxs++ = inx;

                inx = takefrom(div8(r), div8(g), div8(b));
                b -= gbmRGBvga[inx].b;
                g -= gbmRGBvga[inx].g;
                r -= gbmRGBvga[inx].r;
                *inxs++ = inx;

                inx = takefrom(div7(r), div7(g), div7(b));
                b -= gbmRGBvga[inx].b;
                g -= gbmRGBvga[inx].g;
                r -= gbmRGBvga[inx].r;
                *inxs++ = inx;
                }

        if ( n >= 6 )
                {
                inx = takefrom(div6(r), div6(g), div6(b));
                b -= gbmRGBvga[inx].b;
                g -= gbmRGBvga[inx].g;
                r -= gbmRGBvga[inx].r;
                *inxs++ = inx;

                inx = takefrom(div5(r), div5(g), div5(b));
                b -= gbmRGBvga[inx].b;
                g -= gbmRGBvga[inx].g;
                r -= gbmRGBvga[inx].r;
                *inxs++ = inx;
                }

        if ( n >= 4 )
                {
                inx = takefrom(div4(r), div4(g), div4(b));
                b -= gbmRGBvga[inx].b;
                g -= gbmRGBvga[inx].g;
                r -= gbmRGBvga[inx].r;
                *inxs++ = inx;
                }

        if ( n >= 3 )
                {
                inx = takefrom(div3(r), div3(g), div3(b));
                b -= gbmRGBvga[inx].b;
                g -= gbmRGBvga[inx].g;
                r -= gbmRGBvga[inx].r;
                *inxs++ = inx;
                }

        inx = takefrom(div2(r), div2(g), div2(b));
        b -= gbmRGBvga[inx].b;
        g -= gbmRGBvga[inx].g;
        r -= gbmRGBvga[inx].r;
        *inxs++ = inx;

        *inxs = takefrom(r, g, b);
        }
/*...e*/
/*...stakefrom8:0:*/
/*
Find the largest colour from the 8 colour palette.
*/

#define takefrom8(r,g,b) ( (((r)>=255)<<2) | (((g)>=255)<<1) | ((b)>=255) )
/*...e*/
/*...ssplit_into8:0:*/
/* n is only ever 2, 3, 4, 6 or 9 */

static void split_into8(
        word r, word g, word b,
        int n, byte *inxs
        )
        {
        byte inx;

        if ( n >= 9 )
                {
                inx = takefrom8(div9(r), div9(g), div9(b));
                b -= gbmRGB8[inx].b;
                g -= gbmRGB8[inx].g;
                r -= gbmRGB8[inx].r;
                *inxs++ = inx;

                inx = takefrom8(div8(r), div8(g), div8(b));
                b -= gbmRGB8[inx].b;
                g -= gbmRGB8[inx].g;
                r -= gbmRGB8[inx].r;
                *inxs++ = inx;

                inx = takefrom8(div7(r), div7(g), div7(b));
                b -= gbmRGB8[inx].b;
                g -= gbmRGB8[inx].g;
                r -= gbmRGB8[inx].r;
                *inxs++ = inx;
                }

        if ( n >= 6 )
                {
                inx = takefrom8(div6(r), div6(g), div6(b));
                b -= gbmRGB8[inx].b;
                g -= gbmRGB8[inx].g;
                r -= gbmRGB8[inx].r;
                *inxs++ = inx;

                inx = takefrom8(div5(r), div5(g), div5(b));
                b -= gbmRGB8[inx].b;
                g -= gbmRGB8[inx].g;
                r -= gbmRGB8[inx].r;
                *inxs++ = inx;
                }

        if ( n >= 4 )
                {
                inx = takefrom8(div4(r), div4(g), div4(b));
                b -= gbmRGB8[inx].b;
                g -= gbmRGB8[inx].g;
                r -= gbmRGB8[inx].r;
                *inxs++ = inx;
                }

        if ( n >= 3 )
                {
                inx = takefrom8(div3(r), div3(g), div3(b));
                b -= gbmRGB8[inx].b;
                g -= gbmRGB8[inx].g;
                r -= gbmRGB8[inx].r;
                *inxs++ = inx;
                }

        inx = takefrom8(div2(r), div2(g), div2(b));
        b -= gbmRGB8[inx].b;
        g -= gbmRGB8[inx].g;
        r -= gbmRGB8[inx].r;
        *inxs++ = inx;

        *inxs = takefrom8(r, g, b);
        }
/*...e*/

/*...sgbm_ht_24_2x2     \45\ halftone by 2x2 to r\58\g\58\b bits:0:*/
void gbm_ht_24_2x2(GBM *gbm, byte *src24, byte *dest24, byte rm, byte gm, byte bm)
        {
        int stride = ((gbm->w * 3 + 3) & ~3);
        int x, y;

        _init();

        src24 -= stride;
        dest24 -= stride;

        for ( y = 0; y < gbm->h - 1; y += 2 )
                {
                byte *src24a  = (src24 += stride);
                byte *src24b  = (src24 += stride);
                byte *dest24a = (dest24 += stride);
                byte *dest24b = (dest24 += stride);

                for ( x = 0; x < gbm->w - 1; x += 2 )
/*...s2x2 case:24:*/
{
word r,g,b;
byte ri,gi,bi;
byte *tmp;

b  = *src24a++; g  = *src24a++; r  = *src24a++;
b += *src24a++; g += *src24a++; r += *src24a++;
b += *src24b++; g += *src24b++; r += *src24b++;
b += *src24b++; g += *src24b++; r += *src24b++;

bi = (div4(b) & bm); gi = (div4(g) & gm); ri = (div4(r) & rm);
*dest24a++ = bi; *dest24a++ = gi; *dest24a++ = ri;
b -= bi; g -= gi; r -= ri;

if ( b > 255 * 3 ) b = 255 * 3;
if ( g > 255 * 3 ) g = 255 * 3;
if ( r > 255 * 3 ) r = 255 * 3;

bi = (div3(b) & bm); gi = (div3(g) & gm); ri = (div3(r) & rm);
*dest24a++ = bi; *dest24a++ = gi; *dest24a++ = ri;
b -= bi; g -= gi; r -= ri;

if ( b > 255 * 2 ) b = 255 * 2;
if ( g > 255 * 2 ) g = 255 * 2;
if ( r > 255 * 2 ) r = 255 * 2;

bi = (div2(b) & bm); gi = (div2(g) & gm); ri = (div2(r) & rm);
*dest24b++ = bi; *dest24b++ = gi; *dest24b++ = ri;
b -= bi; g -= gi; r -= ri;

if ( b > 255 ) b = 255;
if ( g > 255 ) g = 255;
if ( r > 255 ) r = 255;

bi = (b & bm); gi = (g & gm); ri = (r & rm);
*dest24b++ = bi; *dest24b++ = gi; *dest24b++ = ri;

tmp = dest24a; dest24a = dest24b; dest24b = tmp;
}
/*...e*/
                if ( x < gbm->w )
/*...s1x2 case:24:*/
{
word r,g,b;
byte ri, gi, bi;

b  = *src24a++; g  = *src24a++; r  = *src24a;
b += *src24b++; g += *src24b++; r += *src24b;

bi = (div2(b) & bm); gi = (div2(g) & gm); ri = (div2(r) & rm);
*dest24a++ = bi; *dest24a++ = gi; *dest24a++ = ri;
b -= bi; g -= gi; r -= ri;

if ( b > 255 ) b = 255;
if ( g > 255 ) g = 255;
if ( r > 255 ) r = 255;

bi = (b & bm); gi = (g & gm); ri = (r & rm);
*dest24b++ = bi; *dest24b++ = gi; *dest24b   = ri;
}
/*...e*/
                }
        if ( y < gbm->h )
                {
                byte *src24a  = src24 + stride;
                byte *dest24a = dest24 + stride;

                for ( x = 0; x < gbm->w - 1; x += 2 )
/*...s2x1 case:24:*/
{
word r,g,b;
byte ri, gi, bi;

b  = *src24a++; g  = *src24a++; r  = *src24a++;
b += *src24a++; g += *src24a++; r += *src24a++;

bi = (div2(b) & bm); gi = (div2(g) & gm); ri = (div2(r) & rm);
*dest24a++ = bi; *dest24a++ = gi; *dest24a++ = ri;
b -= bi; g -= gi; r -= ri;

if ( b > 255 ) b = 255;
if ( g > 255 ) g = 255;
if ( r > 255 ) r = 255;

bi = (b & bm); gi = (g & gm); ri = (r & rm);
*dest24a++ = bi; *dest24a++ = gi; *dest24a++ = ri;
}
/*...e*/
                if ( x < gbm->w )
/*...s1x1 case:24:*/
{
byte ri, gi, bi;

bi = ((*src24a++) & bm); gi = ((*src24a++) & gm); ri = ((*src24a) & rm);
*dest24a++ = bi; *dest24a++ = gi; *dest24a = ri;
}
/*...e*/
                }
        }
/*...e*/

/*...sgbm_ht_pal_6R6G6B \45\ return 6Rx6Gx6B palette:0:*/
/*
This function makes the palette for the 6 red x 6 green x 6 blue palette.
216 palette entrys used. Remaining 40 left blank.
*/

void gbm_ht_pal_6R6G6B(GBMRGB *gbmrgb)
        {
        byte volatile r;        /* C-Set/2 optimiser fix */
        byte volatile g;
        byte volatile b;

        _init();
        memset(gbmrgb, 0x80, 0x100 * sizeof(GBMRGB));
        for ( r = 0; r < 6; r++ )
                for ( g = 0; g < 6; g++ )
                        for ( b = 0; b < 6; b++ )
                                {
                                gbmrgb->r = _scale6[r];
                                gbmrgb->g = _scale6[g];
                                gbmrgb->b = _scale6[b];
                                gbmrgb++;
                                }
        }
/*...e*/
/*...sgbm_ht_6R6G6B_2x2 \45\ halftone by 2x2 to 6Rx6Gx6B palette:0:*/
#define PIX666(ri,gi,bi)        (byte) (6 * (6 * ri + gi) + bi)

void gbm_ht_6R6G6B_2x2(GBM *gbm, byte *src24, byte *dest8)
        {
        int stride24 = ((gbm->w * 3 + 3) & ~3);
        int stride8  = ((gbm->w     + 3) & ~3);
        int x, y;

        _init();

        src24 -= stride24;
        dest8 -= stride8;

        for ( y = 0; y < gbm->h - 1; y += 2 )
                {
                byte *src24a = (src24 += stride24);
                byte *src24b = (src24 += stride24);
                byte *dest8a = (dest8 += stride8);
                byte *dest8b = (dest8 += stride8);

                for ( x = 0; x < gbm->w - 1; x += 2 )
/*...s2x2 case:24:*/
{
word r,g,b;
byte ri,gi,bi;
byte *tmp;

b  = *src24a++; g  = *src24a++; r  = *src24a++;
b += *src24a++; g += *src24a++; r += *src24a++;
b += *src24b++; g += *src24b++; r += *src24b++;
b += *src24b++; g += *src24b++; r += *src24b++;

bi = _index6[div4(b)]; gi = _index6[div4(g)]; ri = _index6[div4(r)];
*dest8a++ = PIX666(ri,gi,bi);
b -= _scale6[bi]; g -= _scale6[gi]; r -= _scale6[ri];

bi = _index6[div3(b)]; gi = _index6[div3(g)]; ri = _index6[div3(r)];
*dest8a++ = PIX666(ri,gi,bi);
b -= _scale6[bi]; g -= _scale6[gi]; r -= _scale6[ri];

bi = _index6[div2(b)]; gi = _index6[div2(g)]; ri = _index6[div2(r)];
*dest8b++ = PIX666(ri,gi,bi);
b -= _scale6[bi]; g -= _scale6[gi]; r -= _scale6[ri];

bi = _index6[b      ]; gi = _index6[g      ]; ri = _index6[r      ];
*dest8b++ = PIX666(ri,gi,bi);

tmp = dest8a; dest8a = dest8b; dest8b = tmp;
}
/*...e*/
                if ( x < gbm->w )
/*...s1x2 case:24:*/
{
word r,g,b;
byte ri, gi, bi;

b  = *src24a++; g  = *src24a++; r  = *src24a;
b += *src24b++; g += *src24b++; r += *src24b;

bi = _index6[div2(b)]; gi = _index6[div2(g)]; ri = _index6[div2(r)];
*dest8a = PIX666(ri,gi,bi);
b -= _scale6[bi]; g -= _scale6[gi]; r -= _scale6[ri];

bi = _index6[b      ]; gi = _index6[g      ]; ri = _index6[r      ];
*dest8b = PIX666(ri,gi,bi);
}
/*...e*/
                }
        if ( y < gbm->h )
                {
                byte *src24a = src24 + stride24;
                byte *dest8a = dest8 + stride8;

                for ( x = 0; x < gbm->w - 1; x += 2 )
/*...s2x1 case:24:*/
{
word r,g,b;
byte ri, gi, bi;

b  = *src24a++; g  = *src24a++; r  = *src24a++;
b += *src24a++; g += *src24a++; r += *src24a++;

bi = _index6[div2(b)]; gi = _index6[div2(g)]; ri = _index6[div2(r)];
*dest8a++ = PIX666(ri,gi,bi);
b -= _scale6[bi]; g -= _scale6[gi]; r -= _scale6[ri];

bi = _index6[b      ]; gi = _index6[g      ]; ri = _index6[r      ];
*dest8a++ = PIX666(ri,gi,bi);
}
/*...e*/
                if ( x < gbm->w )
/*...s1x1 case:24:*/
{
byte ri, gi, bi;

bi = _index6[*src24a++]; gi = _index6[*src24a++]; ri = _index6[*src24a];
*dest8a = PIX666(ri,gi,bi);
}
/*...e*/
                }
        }
/*...e*/

/*...sgbm_ht_pal_7R8G4B \45\ return 7Rx8Gx4B palette:0:*/
/*
This function makes the palette for the 7 red x 8 green x 4 blue palette.
224 palette entrys used. Remaining 32 left blank.
Colours calculated to match those used by 8514/A PM driver.
*/

void gbm_ht_pal_7R8G4B(GBMRGB *gbmrgb)
        {
        byte volatile r;        /* C-Set/2 optimiser fix */
        byte volatile g;
        byte volatile b;

        _init();

        memset(gbmrgb, 0x80, 0x100 * sizeof(GBMRGB));
        for ( r = 0; r < 7; r++ )
                for ( g = 0; g < 8; g++ )
                        for ( b = 0; b < 4; b++ )
                                {
                                gbmrgb->r = _scale7[r];
                                gbmrgb->g = _scale8[g];
                                gbmrgb->b = _scale4[b];
                                gbmrgb++;
                                }
        }
/*...e*/
/*...sgbm_ht_7R8G4B_2x2 \45\ halftone by 2x2 to 7Rx8Gx4B palette:0:*/
#define PIX784(ri,gi,bi)        (byte) (((((ri)<<3)+(gi))<<2)+(bi))

void gbm_ht_7R8G4B_2x2(GBM *gbm, byte *src24, byte *dest8)
        {
        int stride24 = ((gbm->w * 3 + 3) & ~3);
        int stride8  = ((gbm->w     + 3) & ~3);
        int x, y;

        _init();

        src24 -= stride24;
        dest8 -= stride8;

        for ( y = 0; y < gbm->h - 1; y += 2 )
                {
                byte *src24a = (src24 += stride24);
                byte *src24b = (src24 += stride24);
                byte *dest8a = (dest8 += stride8);
                byte *dest8b = (dest8 += stride8);

                for ( x = 0; x < gbm->w - 1; x += 2 )
/*...s2x2 case:24:*/
{
word r,g,b;
byte ri,gi,bi;
byte *tmp;

b  = *src24a++; g  = *src24a++; r  = *src24a++;
b += *src24a++; g += *src24a++; r += *src24a++;
b += *src24b++; g += *src24b++; r += *src24b++;
b += *src24b++; g += *src24b++; r += *src24b++;

bi = _index4[div4(b)]; gi = _index8[div4(g)]; ri = _index7[div4(r)];
*dest8a++ = PIX784(ri,gi,bi);
b -= _scale4[bi]; g -= _scale8[gi]; r -= _scale7[ri];

bi = _index4[div3(b)]; gi = _index8[div3(g)]; ri = _index7[div3(r)];
*dest8a++ = PIX784(ri,gi,bi);
b -= _scale4[bi]; g -= _scale8[gi]; r -= _scale7[ri];

bi = _index4[div2(b)]; gi = _index8[div2(g)]; ri = _index7[div2(r)];
*dest8b++ = PIX784(ri,gi,bi);
b -= _scale4[bi]; g -= _scale8[gi]; r -= _scale7[ri];

bi = _index4[b      ]; gi = _index8[g      ]; ri = _index7[r      ];
*dest8b++ = PIX784(ri,gi,bi);

tmp = dest8a; dest8a = dest8b; dest8b = tmp;
}
/*...e*/
                if ( x < gbm->w )
/*...s1x2 case:24:*/
{
word r,g,b;
byte ri, gi, bi;

b  = *src24a++; g  = *src24a++; r  = *src24a;
b += *src24b++; g += *src24b++; r += *src24b;

bi = _index4[div2(b)]; gi = _index8[div2(g)]; ri = _index7[div2(r)];
*dest8a = PIX784(ri,gi,bi);
b -= _scale4[bi]; g -= _scale8[gi]; r -= _scale7[ri];

bi = _index4[b      ]; gi = _index8[g      ]; ri = _index7[r      ];
*dest8b = PIX784(ri,gi,bi);
}
/*...e*/
                }
        if ( y < gbm->h )
                {
                byte *src24a = src24 + stride24;
                byte *dest8a = dest8 + stride8;

                for ( x = 0; x < gbm->w - 1; x += 2 )
/*...s2x1 case:24:*/
{
word r,g,b;
byte ri, gi, bi;

b  = *src24a++; g  = *src24a++; r  = *src24a++;
b += *src24a++; g += *src24a++; r += *src24a++;

bi = _index4[div2(b)]; gi = _index8[div2(g)]; ri = _index7[div2(r)];
*dest8a++ = PIX784(ri,gi,bi);
b -= _scale4[bi]; g -= _scale8[gi]; r -= _scale7[ri];

bi = _index4[b      ]; gi = _index8[g      ]; ri = _index7[r      ];
*dest8a++ = PIX784(ri,gi,bi);
}
/*...e*/
                if ( x < gbm->w )
/*...s1x1 case:24:*/
{
byte ri, gi, bi;

bi = _index4[*src24a++]; gi = _index8[*src24a++]; ri = _index7[*src24a];
*dest8a = PIX784(ri,gi,bi);
}
/*...e*/
                }
        }
/*...e*/

/*...sgbm_ht_pal_VGA    \45\ return default VGA palette:0:*/
/*
This function makes the palette for the 16 colour VGA palette.
*/

void gbm_ht_pal_VGA(GBMRGB *gbmrgb)
        {
        _init();
        memcpy((char *) gbmrgb, (char *) gbmRGBvga, sizeof(gbmRGBvga));
        }
/*...e*/
/*...sgbm_ht_VGA_2x2    \45\ halftone by 2x2 to default VGA palette:0:*/
void gbm_ht_VGA_2x2(GBM *gbm, byte *src24, byte *dest4)
        {
        int stride24 = ((gbm->w * 3 + 3) & ~3);
        int stride4  = ((gbm->w * 4 + 31) / 32) * 4;
        int x, y;

        _init();

        src24 -= stride24;
        dest4 -= stride4;

        for ( y = 0; y < gbm->h - 1; y += 2 )
                {
                byte *src24a = (src24 += stride24);
                byte *src24b = (src24 += stride24);
                byte *dest4a = (dest4 += stride4);
                byte *dest4b = (dest4 += stride4);

                for ( x = 0; x < gbm->w - 1; x += 2 )
/*...s2x2 case:24:*/
{
word r,g,b;
byte inx;
byte *tmp;

b  = *src24a++; g  = *src24a++; r  = *src24a++;
b += *src24a++; g += *src24a++; r += *src24a++;
b += *src24b++; g += *src24b++; r += *src24b++;
b += *src24b++; g += *src24b++; r += *src24b++;

inx = takefrom(div4(r), div4(g), div4(b)); *dest4a    = (inx << 4);
b -= gbmRGBvga[inx].b; g -= gbmRGBvga[inx].g; r -= gbmRGBvga[inx].r;

inx = takefrom(div3(r), div3(g), div3(b)); *dest4a++ |= inx;
b -= gbmRGBvga[inx].b; g -= gbmRGBvga[inx].g; r -= gbmRGBvga[inx].r;

inx = takefrom(div2(r), div2(g), div2(b)); *dest4b    = (inx << 4);
b -= gbmRGBvga[inx].b; g -= gbmRGBvga[inx].g; r -= gbmRGBvga[inx].r;

inx = takefrom(r      , g      , b      ); *dest4b++ |= inx;

tmp = dest4a; dest4a = dest4b; dest4b = tmp;
}
/*...e*/
                if ( x < gbm->w )
/*...s1x2 case:24:*/
{
word r,g,b;
byte inx;

b  = *src24a++; g  = *src24a++; r  = *src24a;
b += *src24b++; g += *src24b++; r += *src24b;

inx = takefrom(div2(r), div2(g), div2(b)); *dest4a = (inx << 4);
b -= gbmRGBvga[inx].b; g -= gbmRGBvga[inx].g; r -= gbmRGBvga[inx].r;

inx = takefrom(r      , g      , b      ); *dest4b = (inx << 4);
}
/*...e*/
                }
        if ( y < gbm->h )
                {
                byte *src24a = src24 + stride24;
                byte *dest4a = dest4 + stride4;

                for ( x = 0; x < gbm->w - 1; x += 2 )
/*...s2x1 case:24:*/
{
word r,g,b;
byte inx;

b  = *src24a++; g  = *src24a++; r  = *src24a++;
b += *src24a++; g += *src24a++; r += *src24a++;

inx = takefrom(div2(r), div2(g), div2(b)); *dest4a = (inx << 4);
b -= gbmRGBvga[inx].b; g -= gbmRGBvga[inx].g; r -= gbmRGBvga[inx].r;

inx = takefrom(r      , g      , b      ); *dest4a++ |= inx;
}
/*...e*/
                if ( x < gbm->w )
/*...s1x1 case:24:*/
{
word r, g, b;
byte inx;

b = *src24a++; g = *src24a++; r = *src24a;
inx = takefrom(r, g, b); *dest4a = (inx << 4);
}
/*...e*/
                }
        }
/*...e*/
/*...sgbm_ht_VGA_3x3    \45\ halftone by 3x3 to default VGA palette:0:*/
void gbm_ht_VGA_3x3(GBM *gbm, byte *src24, byte *dest4)
        {
        int stride24 = ((gbm->w * 3 + 3) & ~3);
        int stride4  = ((gbm->w * 4 + 31) / 32) * 4;
        int x, y;

        _init();

        src24 -= stride24;
        dest4 -= stride4;

        for ( y = 0; y < gbm->h - 2; y += 3 )
                {
                byte *src24a = (src24 += stride24);
                byte *src24b = (src24 += stride24);
                byte *src24c = (src24 += stride24);
                byte *dest4a = (dest4 += stride4);
                byte *dest4b = (dest4 += stride4);
                byte *dest4c = (dest4 += stride4);
                bool left = TRUE;

                for ( x = 0; x < gbm->w - 2; x += 3, left = !left )
/*...s3x3 case:24:*/
{
word r,g,b;
byte inxs[9];
byte *tmp;

b  = *src24a++; g  = *src24a++; r  = *src24a++;
b += *src24a++; g += *src24a++; r += *src24a++;
b += *src24a++; g += *src24a++; r += *src24a++;
b += *src24b++; g += *src24b++; r += *src24b++;
b += *src24b++; g += *src24b++; r += *src24b++;
b += *src24b++; g += *src24b++; r += *src24b++;
b += *src24c++; g += *src24c++; r += *src24c++;
b += *src24c++; g += *src24c++; r += *src24c++;
b += *src24c++; g += *src24c++; r += *src24c++;

split_into(r, g, b, 9, inxs);

if ( left )
        {
        *dest4a++ = ((inxs[0] << 4) | inxs[1]); *dest4a = (inxs[2] << 4);
        *dest4b++ = ((inxs[3] << 4) | inxs[4]); *dest4b = (inxs[5] << 4);
        *dest4c++ = ((inxs[6] << 4) | inxs[7]); *dest4c = (inxs[8] << 4);
        }
else
        {
        *dest4a++ |= inxs[0]; *dest4a++ = ((inxs[1] << 4) | inxs[2]);
        *dest4b++ |= inxs[3]; *dest4b++ = ((inxs[4] << 4) | inxs[5]);
        *dest4c++ |= inxs[6]; *dest4c++ = ((inxs[7] << 4) | inxs[8]);
        }

tmp = dest4a; dest4a = dest4b; dest4b = dest4c; dest4c = tmp;
}
/*...e*/
                if ( x < gbm->w - 1 )
/*...s2x3 case:24:*/
{
word r,g,b;
byte inxs[6];

b  = *src24a++; g  = *src24a++; r  = *src24a++;
b += *src24a++; g += *src24a++; r += *src24a++;
b += *src24b++; g += *src24b++; r += *src24b++;
b += *src24b++; g += *src24b++; r += *src24b++;
b += *src24c++; g += *src24c++; r += *src24c++;
b += *src24c++; g += *src24c++; r += *src24c++;

split_into(r, g, b, 6, inxs);

if ( left )
        {
        *dest4a = ((inxs[0] << 4) | inxs[1]);
        *dest4b = ((inxs[2] << 4) | inxs[3]);
        *dest4c = ((inxs[4] << 4) | inxs[5]);
        }
else
        {
        *dest4a++ |= inxs[0]; *dest4a = (inxs[1] << 4);
        *dest4b++ |= inxs[2]; *dest4b = (inxs[3] << 4);
        *dest4c++ |= inxs[4]; *dest4c = (inxs[5] << 4);
        }
}
/*...e*/
                else if ( x < gbm->w )
/*...s1x3 case:24:*/
{
word r,g,b;
byte inxs[3];

b  = *src24a++; g  = *src24a++; r  = *src24a++;
b += *src24b++; g += *src24b++; r += *src24b++;
b += *src24c++; g += *src24c++; r += *src24c++;

split_into(r, g, b, 3, inxs);

if ( left )
        {
        *dest4a = (inxs[0] << 4);
        *dest4b = (inxs[1] << 4);
        *dest4c = (inxs[2] << 4);
        }
else
        {
        *dest4a |= inxs[0];
        *dest4b |= inxs[1];
        *dest4c |= inxs[2];
        }
}
/*...e*/
                }
        if ( y < gbm->h - 1 )
                {
                byte *src24a = (src24 += stride24);
                byte *src24b = (src24 += stride24);
                byte *dest4a = (dest4 += stride4);
                byte *dest4b = (dest4 += stride4);
                bool left = TRUE;

                for ( x = 0; x < gbm->w - 2; x += 3, left = !left )
/*...s3x2 case:24:*/
{
word r,g,b;
byte inxs[6];
byte *tmp;

b  = *src24a++; g  = *src24a++; r  = *src24a++;
b += *src24a++; g += *src24a++; r += *src24a++;
b += *src24a++; g += *src24a++; r += *src24a++;
b += *src24b++; g += *src24b++; r += *src24b++;
b += *src24b++; g += *src24b++; r += *src24b++;
b += *src24b++; g += *src24b++; r += *src24b++;

split_into(r, g, b, 6, inxs);

if ( left )
        {
        *dest4a++ = (inxs[0] << 4) | inxs[1]; *dest4a = (inxs[2] << 4);
        *dest4b++ = (inxs[3] << 4) | inxs[4]; *dest4b = (inxs[5] << 4);
        }
else
        {
        *dest4a++ |= inxs[0]; *dest4a++ = ((inxs[1] << 4) | inxs[2]);
        *dest4b++ |= inxs[3]; *dest4b++ = ((inxs[4] << 4) | inxs[5]);
        }

tmp = dest4a; dest4a = dest4b; dest4b = tmp;
}
/*...e*/
                if ( x < gbm->w - 1 )
/*...s2x2 case:24:*/
{
word r,g,b;
byte inxs[4];

b  = *src24a++; g  = *src24a++; r  = *src24a++;
b += *src24a++; g += *src24a++; r += *src24a++;
b += *src24b++; g += *src24b++; r += *src24b++;
b += *src24b++; g += *src24b++; r += *src24b++;

split_into(r, g, b, 4, inxs);

if ( left )
        {
        *dest4a = ((inxs[0] << 4) | inxs[1]);
        *dest4b = ((inxs[2] << 4) | inxs[3]);
        }
else
        {
        *dest4a++ |= inxs[0]; *dest4a = (inxs[1] << 4);
        *dest4b++ |= inxs[2]; *dest4b = (inxs[3] << 4);
        }
}
/*...e*/
                else if ( x < gbm->w )
/*...s1x2 case:24:*/
{
word r,g,b;
byte inxs[2];

b  = *src24a++; g  = *src24a++; r  = *src24a++;
b += *src24b++; g += *src24b++; r += *src24b++;

split_into(r, g, b, 2, inxs);

if ( left )
        {
        *dest4a = (inxs[0] << 4);
        *dest4b = (inxs[1] << 4);
        }
else
        {
        *dest4a |= inxs[0];
        *dest4b |= inxs[1];
        }
}
/*...e*/
                }
        else if ( y < gbm->h )
                {
                byte *src24a = (src24 += stride24);
                byte *dest4a = (dest4 += stride4);
                bool left = TRUE;

                for ( x = 0; x < gbm->w - 2; x += 3, left = !left )
/*...s3x1 case:24:*/
{
word r,g,b;
byte inxs[3];

b  = *src24a++; g  = *src24a++; r  = *src24a++;
b += *src24a++; g += *src24a++; r += *src24a++;
b += *src24a++; g += *src24a++; r += *src24a++;

split_into(r, g, b, 3, inxs);

if ( left )
        {
        *dest4a++ = ((inxs[0] << 4) | inxs[1]); *dest4a = (inxs[2] << 4);
        }
else
        {
        *dest4a++ |= inxs[0]; *dest4a++ = ((inxs[1] << 4) | inxs[2]);
        }
}
/*...e*/
                if ( x < gbm->w - 1 )
/*...s2x1 case:24:*/
{
word r,g,b;
byte inxs[2];

b  = *src24a++; g  = *src24a++; r  = *src24a++;
b += *src24a++; g += *src24a++; r += *src24a++;

split_into(r, g, b, 4, inxs);

if ( left )
        *dest4a = ((inxs[0] << 4) | inxs[1]);
else
        {
        *dest4a++ |= inxs[0]; *dest4a = (inxs[1] << 4);
        }
}
/*...e*/
                else if ( x < gbm->w )
/*...s1x1 case:24:*/
{
word r,g,b;
byte inx;

b  = *src24a++; g  = *src24a++; r  = *src24a++;

inx = takefrom(r, g, b);

if ( left )
        *dest4a = (inx << 4);
else
        *dest4a |= inx;
}
/*...e*/
                }
        }
/*...e*/

/*...sgbm_ht_pal_8      \45\ return default 8 colour palette:0:*/
/*
This function makes the palette for the 8 colour palette.
*/

void gbm_ht_pal_8(GBMRGB *gbmrgb)
        {
        _init();
        memcpy((char *) gbmrgb, (char *) gbmRGB8, sizeof(gbmRGB8));
        }
/*...e*/
/*...sgbm_ht_8_2x2      \45\ halftone by 2x2 to default 8 colour palette:0:*/
void gbm_ht_8_2x2(GBM *gbm, byte *src24, byte *dest4)
        {
        int stride24 = ((gbm->w * 3 + 3) & ~3);
        int stride4  = ((gbm->w * 4 + 31) / 32) * 4;
        int x, y;

        _init();

        src24 -= stride24;
        dest4 -= stride4;

        for ( y = 0; y < gbm->h - 1; y += 2 )
                {
                byte *src24a = (src24 += stride24);
                byte *src24b = (src24 += stride24);
                byte *dest4a = (dest4 += stride4);
                byte *dest4b = (dest4 += stride4);

                for ( x = 0; x < gbm->w - 1; x += 2 )
/*...s2x2 case:24:*/
{
word r,g,b;
byte inx;
byte *tmp;

b  = *src24a++; g  = *src24a++; r  = *src24a++;
b += *src24a++; g += *src24a++; r += *src24a++;
b += *src24b++; g += *src24b++; r += *src24b++;
b += *src24b++; g += *src24b++; r += *src24b++;

inx = takefrom8(r >> 2, g >> 2, b >> 2); *dest4a    = (inx << 4);
b -= gbmRGB8[inx].b; g -= gbmRGB8[inx].g; r -= gbmRGB8[inx].r;

inx = takefrom8(r  / 3, g  / 3, b  / 3); *dest4a++ |= inx;
b -= gbmRGB8[inx].b; g -= gbmRGB8[inx].g; r -= gbmRGB8[inx].r;

inx = takefrom8(r >> 1, g >> 1, b >> 1); *dest4b    = (inx << 4);
b -= gbmRGB8[inx].b; g -= gbmRGB8[inx].g; r -= gbmRGB8[inx].r;

inx = takefrom8(r     , g     , b     ); *dest4b++ |= inx;

tmp = dest4a; dest4a = dest4b; dest4b = tmp;
}
/*...e*/
                if ( x < gbm->w )
/*...s1x2 case:24:*/
{
word r,g,b;
byte inx;

b  = *src24a++; g  = *src24a++; r  = *src24a;
b += *src24b++; g += *src24b++; r += *src24b;

inx = takefrom8(r >> 1, g >> 1, b >> 1); *dest4a = (inx << 4);
b -= gbmRGB8[inx].b; g -= gbmRGB8[inx].g; r -= gbmRGB8[inx].r;

inx = takefrom8(r     , g     , b     ); *dest4b = (inx << 4);
}
/*...e*/
                }
        if ( y < gbm->h )
                {
                byte *src24a = src24 + stride24;
                byte *dest4a = dest4 + stride4;

                for ( x = 0; x < gbm->w - 1; x += 2 )
/*...s2x1 case:24:*/
{
word r,g,b;
byte inx;

b  = *src24a++; g  = *src24a++; r  = *src24a++;
b += *src24a++; g += *src24a++; r += *src24a++;

inx = takefrom8(r >> 1, g >> 1, b >> 1); *dest4a    = (inx << 4);
b -= gbmRGB8[inx].b; g -= gbmRGB8[inx].g; r -= gbmRGB8[inx].r;

inx = takefrom8(r     , g     , b     ); *dest4a++ |= inx;
}
/*...e*/
                if ( x < gbm->w )
/*...s1x1 case:24:*/
{
word r, g, b;
byte inx;

b = *src24a++; g = *src24a++; r = *src24a;
inx = takefrom8(r, g, b); *dest4a = (inx << 4);
}
/*...e*/
                }
        }
/*...e*/
/*...sgbm_ht_8_3x3      \45\ halftone by 3x3 to default 8 colour palette:0:*/
void gbm_ht_8_3x3(GBM *gbm, byte *src24, byte *dest4)
        {
        int stride24 = ((gbm->w * 3 + 3) & ~3);
        int stride4  = ((gbm->w * 4 + 31) / 32) * 4;
        int x, y;

        _init();

        src24 -= stride24;
        dest4 -= stride4;

        for ( y = 0; y < gbm->h - 2; y += 3 )
                {
                byte *src24a = (src24 += stride24);
                byte *src24b = (src24 += stride24);
                byte *src24c = (src24 += stride24);
                byte *dest4a = (dest4 += stride4);
                byte *dest4b = (dest4 += stride4);
                byte *dest4c = (dest4 += stride4);
                bool left = TRUE;

                for ( x = 0; x < gbm->w - 2; x += 3, left = !left )
/*...s3x3 case:24:*/
{
word r,g,b;
byte inxs[9];
byte *tmp;

b  = *src24a++; g  = *src24a++; r  = *src24a++;
b += *src24a++; g += *src24a++; r += *src24a++;
b += *src24a++; g += *src24a++; r += *src24a++;
b += *src24b++; g += *src24b++; r += *src24b++;
b += *src24b++; g += *src24b++; r += *src24b++;
b += *src24b++; g += *src24b++; r += *src24b++;
b += *src24c++; g += *src24c++; r += *src24c++;
b += *src24c++; g += *src24c++; r += *src24c++;
b += *src24c++; g += *src24c++; r += *src24c++;

split_into8(r, g, b, 9, inxs);

if ( left )
        {
        *dest4a++ = ((inxs[0] << 4) | inxs[1]); *dest4a = (inxs[2] << 4);
        *dest4b++ = ((inxs[3] << 4) | inxs[4]); *dest4b = (inxs[5] << 4);
        *dest4c++ = ((inxs[6] << 4) | inxs[7]); *dest4c = (inxs[8] << 4);
        }
else
        {
        *dest4a++ |= inxs[0]; *dest4a++ = ((inxs[1] << 4) | inxs[2]);
        *dest4b++ |= inxs[3]; *dest4b++ = ((inxs[4] << 4) | inxs[5]);
        *dest4c++ |= inxs[6]; *dest4c++ = ((inxs[7] << 4) | inxs[8]);
        }

tmp = dest4a; dest4a = dest4b; dest4b = dest4c; dest4c = tmp;
}
/*...e*/
                if ( x < gbm->w - 1 )
/*...s2x3 case:24:*/
{
word r,g,b;
byte inxs[6];

b  = *src24a++; g  = *src24a++; r  = *src24a++;
b += *src24a++; g += *src24a++; r += *src24a++;
b += *src24b++; g += *src24b++; r += *src24b++;
b += *src24b++; g += *src24b++; r += *src24b++;
b += *src24c++; g += *src24c++; r += *src24c++;
b += *src24c++; g += *src24c++; r += *src24c++;

split_into8(r, g, b, 6, inxs);

if ( left )
        {
        *dest4a = ((inxs[0] << 4) | inxs[1]);
        *dest4b = ((inxs[2] << 4) | inxs[3]);
        *dest4c = ((inxs[4] << 4) | inxs[5]);
        }
else
        {
        *dest4a++ |= inxs[0]; *dest4a = (inxs[1] << 4);
        *dest4b++ |= inxs[2]; *dest4b = (inxs[3] << 4);
        *dest4c++ |= inxs[4]; *dest4c = (inxs[5] << 4);
        }
}
/*...e*/
                else if ( x < gbm->w )
/*...s1x3 case:24:*/
{
word r,g,b;
byte inxs[3];

b  = *src24a++; g  = *src24a++; r  = *src24a++;
b += *src24b++; g += *src24b++; r += *src24b++;
b += *src24c++; g += *src24c++; r += *src24c++;

split_into8(r, g, b, 3, inxs);

if ( left )
        {
        *dest4a = (inxs[0] << 4);
        *dest4b = (inxs[1] << 4);
        *dest4c = (inxs[2] << 4);
        }
else
        {
        *dest4a |= inxs[0];
        *dest4b |= inxs[1];
        *dest4c |= inxs[2];
        }
}
/*...e*/
                }
        if ( y < gbm->h - 1 )
                {
                byte *src24a = (src24 += stride24);
                byte *src24b = (src24 += stride24);
                byte *dest4a = (dest4 += stride4);
                byte *dest4b = (dest4 += stride4);
                bool left = TRUE;

                for ( x = 0; x < gbm->w - 2; x += 3, left = !left )
/*...s3x2 case:24:*/
{
word r,g,b;
byte inxs[6];
byte *tmp;

b  = *src24a++; g  = *src24a++; r  = *src24a++;
b += *src24a++; g += *src24a++; r += *src24a++;
b += *src24a++; g += *src24a++; r += *src24a++;
b += *src24b++; g += *src24b++; r += *src24b++;
b += *src24b++; g += *src24b++; r += *src24b++;
b += *src24b++; g += *src24b++; r += *src24b++;

split_into8(r, g, b, 6, inxs);

if ( left )
        {
        *dest4a++ = (inxs[0] << 4) | inxs[1]; *dest4a = (inxs[2] << 4);
        *dest4b++ = (inxs[3] << 4) | inxs[4]; *dest4b = (inxs[5] << 4);
        }
else
        {
        *dest4a++ |= inxs[0]; *dest4a++ = ((inxs[1] << 4) | inxs[2]);
        *dest4b++ |= inxs[3]; *dest4b++ = ((inxs[4] << 4) | inxs[5]);
        }

tmp = dest4a; dest4a = dest4b; dest4b = tmp;
}
/*...e*/
                if ( x < gbm->w - 1 )
/*...s2x2 case:24:*/
{
word r,g,b;
byte inxs[4];

b  = *src24a++; g  = *src24a++; r  = *src24a++;
b += *src24a++; g += *src24a++; r += *src24a++;
b += *src24b++; g += *src24b++; r += *src24b++;
b += *src24b++; g += *src24b++; r += *src24b++;

split_into8(r, g, b, 4, inxs);

if ( left )
        {
        *dest4a = ((inxs[0] << 4) | inxs[1]);
        *dest4b = ((inxs[2] << 4) | inxs[3]);
        }
else
        {
        *dest4a++ |= inxs[0]; *dest4a = (inxs[1] << 4);
        *dest4b++ |= inxs[2]; *dest4b = (inxs[3] << 4);
        }
}
/*...e*/
                else if ( x < gbm->w )
/*...s1x2 case:24:*/
{
word r,g,b;
byte inxs[2];

b  = *src24a++; g  = *src24a++; r  = *src24a++;
b += *src24b++; g += *src24b++; r += *src24b++;

split_into8(r, g, b, 2, inxs);

if ( left )
        {
        *dest4a = (inxs[0] << 4);
        *dest4b = (inxs[1] << 4);
        }
else
        {
        *dest4a |= inxs[0];
        *dest4b |= inxs[1];
        }
}
/*...e*/
                }
        else if ( y < gbm->h )
                {
                byte *src24a = (src24 += stride24);
                byte *dest4a = (dest4 += stride4);
                bool left = TRUE;

                for ( x = 0; x < gbm->w - 2; x += 3, left = !left )
/*...s3x1 case:24:*/
{
word r,g,b;
byte inxs[3];

b  = *src24a++; g  = *src24a++; r  = *src24a++;
b += *src24a++; g += *src24a++; r += *src24a++;
b += *src24a++; g += *src24a++; r += *src24a++;

split_into8(r, g, b, 3, inxs);

if ( left )
        {
        *dest4a++ = ((inxs[0] << 4) | inxs[1]); *dest4a = (inxs[2] << 4);
        }
else
        {
        *dest4a++ |= inxs[0]; *dest4a++ = ((inxs[1] << 4) | inxs[2]);
        }
}
/*...e*/
                if ( x < gbm->w - 1 )
/*...s2x1 case:24:*/
{
word r,g,b;
byte inxs[2];

b  = *src24a++; g  = *src24a++; r  = *src24a++;
b += *src24a++; g += *src24a++; r += *src24a++;

split_into8(r, g, b, 4, inxs);

if ( left )
        *dest4a = ((inxs[0] << 4) | inxs[1]);
else
        {
        *dest4a++ |= inxs[0]; *dest4a = (inxs[1] << 4);
        }
}
/*...e*/
                else if ( x < gbm->w )
/*...s1x1 case:24:*/
{
word r,g,b;
byte inx;

b  = *src24a++; g  = *src24a++; r  = *src24a++;

inx = takefrom8(r, g, b);

if ( left )
        *dest4a = (inx << 4);
else
        *dest4a |= inx;
}
/*...e*/
                }
        }
/*...e*/
/*
*****************************************************************************************
*                                                                                       *
* COPYRIGHT:                                                                            *
*   IBM Open Class Library                                                              *
*   (C) Copyright International Business Machines Corporation,  1997                    *
*   Licensed Material - Program-Property of IBM - All Rights Reserved.                  *
*   US Government Users Restricted Rights - Use, duplication, or disclosure             *
*   restricted by GSA ADP Schedule Contract with IBM Corp.                              *
*                                                                                       *
*****************************************************************************************
*/
// Revision: 56 1.4.1.5 source/ographic/igbm.cpp, graphics, ioc.v400, 001006 
/*

IGBMODEL.C  Work on the model used in GbmV2

*/

#if 0
#ifdef IC_PM
#define INCL_DOS
#define INCL_WIN
#define INCL_GPI
#define INCL_DEV
#define INCL_BITMAPFILEFORMAT
#include <os2.h>
#endif // IC_PM
#include <stdio.h>
#include <ctype.h>
#include <stdlib.h>
#include <string.h>
#include <malloc.h>
#include <memory.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <io.h>
#include <fcntl.h>
#include <math.h>
#ifdef IC_WIN
#include <wingdi.h>
#endif // IC_WIN
#include <igbmstnd.hpp>
#include <igbm.hpp>
#include <igbmtrnc.hpp>
#include <igbmerr.hpp>
#include <igbmht.hpp>
#include <igbmhist.hpp>
#include <igbmmcut.hpp>
#include <igbmmir.hpp>
#include <igbmrect.hpp>
#include <igbmscal.hpp>
#include <igbmodel.hpp>
#include <icconst.h>
#endif // 0
#ifdef IC_WIN
#include <iexcept.hpp>
#endif // IC_WIN

#if 0
// Segment definitions
#ifdef IC_PAGETUNE
  #define _IGBMODEL_CPP_
  #include <ipagetun.h>
#endif
#endif // 0

#ifdef IC_WIN
// Macro to determine to round off the given value to the closest byte
#define WIDTHBYTES(i)   ((i+31)/32*4)


HBITMAP LoadBitmapResource( HINSTANCE     hInstance,
                            LPSTR         lpString,
                            HPALETTE     *lphPalette)
{
  HRSRC              hRsrc;
  HGLOBAL            hGlobal;
  HBITMAP            hBitmapFinal(0);
  HBITMAP            hBitmapTemp(0);
  LPBITMAPINFOHEADER lpbi;
  HDC                hdc;
  int                iNumColors(0);
  int                bitOffset(0);

  if (hRsrc = FindResource(hInstance, lpString, RT_BITMAP))
  {
    hGlobal = LoadResource(hInstance, hRsrc);
    lpbi = (LPBITMAPINFOHEADER)LockResource(hGlobal);
    hdc = GetDC(0);

    if (((LPBITMAPINFOHEADER)lpbi)->biSize == 12)
    {
      // OS/2 1.x uncompressed bitmap
      *lphPalette =  CreateDIBPal((LPBITMAPINFO)lpbi, true, &iNumColors);
      bitOffset = ((PBITMAPCOREINFO)lpbi)->bmciHeader.bcSize + iNumColors * sizeof(RGBTRIPLE);
    }
    else
    {
      *lphPalette =  CreateDIBPal((LPBITMAPINFO)lpbi, false, &iNumColors);
      bitOffset = lpbi->biSize + iNumColors * sizeof(RGBQUAD);
    }

    if (*lphPalette)
    {
      SelectPalette(hdc,*lphPalette,false);
      RealizePalette(hdc);
    }

    hBitmapFinal = CreateDIBitmap(hdc,
                                  (LPBITMAPINFOHEADER)lpbi,
                                  (LONG)CBM_INIT,
                                  (LPSTR)lpbi + bitOffset,
                                  (LPBITMAPINFO)lpbi,
                                  DIB_RGB_COLORS );

    ReleaseDC(0,hdc);
    UnlockResource(hGlobal);
    FreeResource(hGlobal);
  }
  return (hBitmapFinal);
}

/******************************Public*Routine******************************\
*
* CreateDIBPal
*
* Effects: Creates a logical palette from the DIB.
*
\**************************************************************************/
HPALETTE CreateDIBPal(LPBITMAPINFO pbmi, bool bCoreHdr, int *iNumClr)
{
  LOGPALETTE    *plogPal;
  UINT          uiSizPal;
  INT           i;
  WORD          wBitCount;
  HPALETTE      ghPal = 0;

  if (bCoreHdr)
  {
    wBitCount = ((LPBITMAPCOREINFO)pbmi)->bmciHeader.bcBitCount;
  }
  else
  {
    wBitCount = pbmi->bmiHeader.biBitCount;
  }

  switch (wBitCount)
  {
    case 16:
    case 24:
    case 32:                            // Does PM supports these?
        return false;
    default:
        *iNumClr = (1 << wBitCount);
        break;
  }

  uiSizPal = sizeof(WORD)*2 + sizeof(PALETTEENTRY)*(*iNumClr);
  if ((plogPal = (LOGPALETTE *) malloc(uiSizPal)) == NULL)
  {
    return (HPALETTE)0;
  }

  plogPal->palVersion    = 0x300;
  plogPal->palNumEntries = (WORD) *iNumClr;

  if (bCoreHdr)
  {
    for (i=0; i < *iNumClr; i++)
    {
      plogPal->palPalEntry[i].peRed   = ((LPBITMAPCOREINFO)pbmi)->bmciColors[i].rgbtRed;
      plogPal->palPalEntry[i].peGreen = ((LPBITMAPCOREINFO)pbmi)->bmciColors[i].rgbtGreen;
      plogPal->palPalEntry[i].peBlue  = ((LPBITMAPCOREINFO)pbmi)->bmciColors[i].rgbtBlue;
      plogPal->palPalEntry[i].peFlags = 0;
    }
  }
  else
  {
    for (i=0; i< *iNumClr; i++)
    {
      plogPal->palPalEntry[i].peRed   = pbmi->bmiColors[i].rgbRed;
      plogPal->palPalEntry[i].peGreen = pbmi->bmiColors[i].rgbGreen;
      plogPal->palPalEntry[i].peBlue  = pbmi->bmiColors[i].rgbBlue;
      plogPal->palPalEntry[i].peFlags = 0;
    }
  }

  ghPal = CreatePalette((LPLOGPALETTE)plogPal);

  free(plogPal);

  return ghPal;
}
#endif // IC_WIN

static int StrideOf(MOD *mod)
{
  return ( ( mod->gbm.w * mod->gbm.bpp + 31 ) / 32 ) * 4;
}

static bool AllocateData(MOD *mod)
{
  mod->bufSize = StrideOf(mod) * mod->gbm.h;
  if ( (mod->pbData = (BYTE*)malloc(mod->bufSize)) == NULL )
    return false;

  return true;
}

MOD_ERR ModCreate( int w, int h, int bpp, GBMRGB gbmrgb[], MOD *modNew )
{
  modNew->gbm.w   = w;
  modNew->gbm.h   = h;
  modNew->gbm.bpp = bpp;
  if ( gbmrgb != NULL && bpp != 24 )
          memcpy(&(modNew->gbmrgb), gbmrgb, sizeof(GBMRGB) << bpp);
  if ( !AllocateData(modNew) )
          return MOD_ERR_MEM;
  return MOD_ERR_OK;
}

MOD_ERR ModDelete(MOD *mod)
{
  if (mod->pbData != 0)
    free(mod->pbData);
  return MOD_ERR_OK;
}

MOD_ERR ModCopy(MOD *mod, MOD *modNew)
{
  modNew->gbm.w   = mod->gbm.w;
  modNew->gbm.h   = mod->gbm.h;
  modNew->gbm.bpp = mod->gbm.bpp;
  if ( mod->gbm.bpp != 24 )
          memcpy(modNew->gbmrgb, mod->gbmrgb, sizeof(GBMRGB) << mod->gbm.bpp);

  if ( !AllocateData(modNew) )
          return MOD_ERR_MEM;
  memcpy(modNew->pbData, mod->pbData, StrideOf(mod) * mod->gbm.h);

  return MOD_ERR_OK;
}

MOD_ERR ModMove(MOD *mod, MOD *modNew)
{
  memcpy(modNew, mod, sizeof(MOD));
  return MOD_ERR_OK;
}

MOD_ERR ModCreateFromFile( CHAR *szFn, int *ft, CHAR *szOpt, MOD *modNew )
{
  GBM_ERR grc;
  int fd;

  if (*ft == UNKNOWN_IMAGETYPE)
    if ( (grc = gbm_guess_filetype(szFn, ft)) != GBM_ERR_OK )
      return MOD_ERR_GBM(grc);

  if ( (fd = open(szFn, O_RDONLY|O_BINARY)) == -1 )
    return MOD_ERR_OPEN;

  if ( (grc = gbm_read_header(szFn, fd, *ft, &(modNew->gbm), szOpt)) != GBM_ERR_OK )
  {
    close(fd);
    return MOD_ERR_GBM(grc);
  }

  if ( (grc = gbm_read_palette(fd, *ft, &(modNew->gbm), modNew->gbmrgb)) != GBM_ERR_OK )
  {
    close(fd);
    return MOD_ERR_GBM(grc);
  }

  if ( !AllocateData(modNew) )
  {
    close(fd);
    return MOD_ERR_MEM;
  }

  if ( (grc = gbm_read_data(fd, *ft, &(modNew->gbm), (unsigned char*)modNew->pbData)) != GBM_ERR_OK )
  {
    free(modNew->pbData);
    modNew->pbData = 0;
    close(fd);
    return MOD_ERR_GBM(grc);
  }

  close(fd);

  return MOD_ERR_OK;
}

MOD_ERR ModWriteToFile( MOD *mod, int ft, CHAR *szFn, CHAR *szOpt )
{
  GBM_ERR grc;
  int fd, flag;
  GBMFT gbmft;

  if (ft == UNKNOWN_IMAGETYPE)
    if ( (grc = gbm_guess_filetype(szFn, &ft)) != GBM_ERR_OK )
      return grc;

  gbm_query_filetype(ft, &gbmft);
  switch ( mod->gbm.bpp )
          {
          case 1:         flag = GBM_FT_W1;       break;
          case 4:         flag = GBM_FT_W4;       break;
          case 8:         flag = GBM_FT_W8;       break;
          case 24:        flag = GBM_FT_W24;      break;
          }

  if ( (gbmft.flags & flag) == 0 )
          return MOD_ERR_SUPPORT;

  if ( (fd = open(szFn, O_CREAT|O_TRUNC|O_WRONLY|O_BINARY, S_IREAD|S_IWRITE)) == -1 )
          return MOD_ERR_CREATE;

  if ( (grc = gbm_write(szFn, fd, ft, &(mod->gbm), mod->gbmrgb, (unsigned char*)mod->pbData, szOpt)) != GBM_ERR_OK )
          {
          close(fd);
          unlink(szFn);
          return MOD_ERR_GBM(grc);
          }

  close(fd);

  return MOD_ERR_OK;
}

MOD_ERR ModExpandTo24Bpp(MOD *mod, MOD *mod24)
{
  MOD_ERR mrc;
  int stride, stride24, y;

  if ( (mrc = ModCreate(mod->gbm.w, mod->gbm.h,
       24, mod->gbmrgb, mod24)) != MOD_ERR_OK )
          return mrc;

  stride   = StrideOf(mod  );
  stride24 = StrideOf(mod24);

  for ( y = 0; y < mod->gbm.h; y++ )
  {
    BYTE *pbSrc  = mod  ->pbData + y * stride  ;
    BYTE *pbDest = mod24->pbData + y * stride24;
    int x;

    switch ( mod->gbm.bpp )
    {
      case 1:
      {
        BYTE c;

        for ( x = 0; x < mod->gbm.w; x++ )
        {
          if ( (x & 7) == 0 )
                  c = *pbSrc++;
          else
                  c <<= 1;

          *pbDest++ = mod->gbmrgb[c >> 7].b;
          *pbDest++ = mod->gbmrgb[c >> 7].g;
          *pbDest++ = mod->gbmrgb[c >> 7].r;
        }
      }
      break;

      case 4:
        for ( x = 0; x + 1 < mod->gbm.w; x += 2 )
        {
          BYTE c = *pbSrc++;

          *pbDest++ = mod->gbmrgb[c >> 4].b;
          *pbDest++ = mod->gbmrgb[c >> 4].g;
          *pbDest++ = mod->gbmrgb[c >> 4].r;
          *pbDest++ = mod->gbmrgb[c & 15].b;
          *pbDest++ = mod->gbmrgb[c & 15].g;
          *pbDest++ = mod->gbmrgb[c & 15].r;
        }

        if ( x < mod->gbm.w )
        {
          BYTE c = *pbSrc;

          *pbDest++ = mod->gbmrgb[c >> 4].b;
          *pbDest++ = mod->gbmrgb[c >> 4].g;
          *pbDest++ = mod->gbmrgb[c >> 4].r;
        }
      break;

      case 8:
        for ( x = 0; x < mod->gbm.w; x++ )
        {
          BYTE c = *pbSrc++;

          *pbDest++ = mod->gbmrgb[c].b;
          *pbDest++ = mod->gbmrgb[c].g;
          *pbDest++ = mod->gbmrgb[c].r;
        }
      break;

      case 24:
        memcpy(pbDest, pbSrc, stride);
      break;
    }
  }
  return MOD_ERR_OK;
}

MOD_ERR ModReflectHorz(MOD *mod, MOD *modNew)
{
  MOD_ERR mrc;
  if ( (mrc = ModCopy(mod, modNew)) != MOD_ERR_OK )
          return mrc;
  if ( !gbm_ref_horz(&(modNew->gbm), (unsigned char*)modNew->pbData) )
          {
          free(modNew->pbData);
          modNew->pbData = 0;
          return MOD_ERR_MEM;
          }
  return MOD_ERR_OK;
}

/*...sModReflectVert:0:*/
MOD_ERR ModReflectVert(MOD *mod, MOD *modNew)
{
  MOD_ERR mrc;
  if ( (mrc = ModCopy(mod, modNew)) != MOD_ERR_OK )
          return mrc;
  if ( !gbm_ref_vert(&(modNew->gbm), (unsigned char*)modNew->pbData) )
          {
          free(modNew->pbData);
          modNew->pbData = 0;
          return MOD_ERR_MEM;
          }
  return MOD_ERR_OK;
}

MOD_ERR ModTranspose(MOD *mod, MOD *modNew)
{
  modNew->gbm.w   = mod->gbm.h;
  modNew->gbm.h   = mod->gbm.w;
  modNew->gbm.bpp = mod->gbm.bpp;
  if ( mod->gbm.bpp != 24 )
          memcpy(modNew->gbmrgb, mod->gbmrgb, sizeof(GBMRGB) << mod->gbm.bpp);
  if ( !AllocateData(modNew) )
          return MOD_ERR_MEM;
  gbm_transpose(&(mod->gbm), (unsigned char*)mod->pbData, (unsigned char*)modNew->pbData);
  return MOD_ERR_OK;
}

MOD_ERR ModRotate90(MOD *mod, MOD *modNew)
{
  MOD_ERR mrc;
  MOD modTmp;

  if ( (mrc = ModReflectVert(mod, &modTmp)) != MOD_ERR_OK )
          return mrc;
  mrc = ModTranspose(&modTmp, modNew);
  ModDelete(&modTmp);
  return mrc;
}

/*...sModRotate180:0:*/
MOD_ERR ModRotate180(MOD *mod, MOD *modNew)
{
  MOD_ERR mrc;
  if ( (mrc = ModCopy(mod, modNew)) != MOD_ERR_OK )
          return mrc;
  if ( !gbm_ref_horz(&(modNew->gbm), (unsigned char*)modNew->pbData) )
          {
          free(modNew->pbData);
          modNew->pbData = 0;
          return MOD_ERR_MEM;
          }
  if ( !gbm_ref_vert(&(modNew->gbm), (unsigned char*)modNew->pbData) )
          {
          free(modNew->pbData);
          modNew->pbData = 0;
          return MOD_ERR_MEM;
          }
  return MOD_ERR_OK;
}

/*...sModRotate270:0:*/
int ModRotate270(MOD *mod, MOD *modNew)
{
  MOD_ERR mrc;
  MOD modTmp;

  if ( (mrc = ModReflectHorz(mod, &modTmp)) != MOD_ERR_OK )
          return mrc;
  mrc = ModTranspose(&modTmp, modNew);
  ModDelete(&modTmp);
  return (int)mrc;
}

#if 0
#ifdef RELEASE_V3
/*...sModExtractSubrectangle:0:*/
MOD_ERR ModExtractSubrectangle( MOD *mod, int x, int y, int w, int h, MOD *modNew )
{
  modNew->gbm.w   = w;
  modNew->gbm.h   = h;
  modNew->gbm.bpp = mod->gbm.bpp;
  if ( mod->gbm.bpp != 24 )
          memcpy(modNew->gbmrgb, mod->gbmrgb, sizeof(GBMRGB) << mod->gbm.bpp);

  if ( !AllocateData(modNew) )
          return MOD_ERR_MEM;

  gbm_subrectangle(&(mod->gbm), x, y, w, h, (unsigned char*)mod->pbData, (unsigned char*)modNew->pbData);

  return MOD_ERR_OK;
}

MOD_ERR ModBlit( MOD *modDst, int dx, int dy, MOD *modSrc, int sx, int sy,
                 int w, int h )
{
  if ( sx < 0 || sx+w > modSrc->gbm.w ||
       sy < 0 || sy+h > modSrc->gbm.h ||
       dx < 0 || dx+w > modDst->gbm.w ||
       dy < 0 || dy+h > modDst->gbm.h )
          return MOD_ERR_CLIP;
  gbm_blit(
          (unsigned char*)modSrc->pbData, modSrc->gbm.w, sx, sy,
          (unsigned char*)modDst->pbData, modDst->gbm.w, dx, dy,
          w, h,
          modSrc->gbm.bpp);
  return MOD_ERR_OK;
}

static double lstar_from_i(double y)
{
  y = pow(1.16 * y, 1.0/3.0) - 0.16;

  if ( y < 0.0 ) y = 0.0; else if ( y > 1.0 ) y = 1.0;

  return ( y );
}

static double i_from_lstar(double y)
{
  y = pow(y + 0.16, 3.0) / 1.16;

  if ( y < 0.0 ) y = 0.0; else if ( y > 1.0 ) y = 1.0;

  return ( y );
}

static double pal_from_i(double y, double gam, double shelf)
        {
        y = pow(y,1.0 / gam) * (1.0 - shelf) + shelf;

        if ( y < 0.0 ) y = 0.0; else if ( y > 1.0 ) y = 1.0;

        return ( y );
        }

static double i_from_pal(double y, double gam, double shelf)
        {
        if ( y >= shelf )
                y = pow((y - shelf) / (1.0 - shelf), gam);
        else
                y = 0.0;

        if ( y < 0.0 ) y = 0.0; else if ( y > 1.0 ) y = 1.0;

        return ( y );
        }
/*...e*/

static void map_compute(int m, byte remap [], double gam, double shelf)
        {
        int     i;

        for ( i = 0; i < 0x100; i++ )
                {
                double y = (double) i / 255.0;

                switch ( m )
                        {
                        case CVT_I_TO_P: y = pal_from_i(y, gam, shelf); break;
                        case CVT_P_TO_I: y = i_from_pal(y, gam, shelf); break;
                        case CVT_I_TO_L: y = lstar_from_i(y); break;
                        case CVT_L_TO_I: y = i_from_lstar(y); break;
                        case CVT_P_TO_L: y = lstar_from_i(i_from_pal(y, gam, shelf)); break;
                        case CVT_L_TO_P: y = pal_from_i(i_from_lstar(y), gam, shelf); break;
                        }

                remap [i] = (byte) (y * 255.0);
                }
        }
/*...e*/
/*...smap_data:0:*/
static void map_data(byte *data, int w, int h, byte remap [])
        {
        int stride = ((w * 3 + 3) & ~3);
        int x, y;

        for ( y = 0; y < h; y++, data += stride )
                for ( x = 0; x < w * 3; x++ )
                        data [x] = remap [data [x]];
        }
/*...e*/
/*...smap_palette:0:*/
static void map_palette(GBMRGB *gbmrgb, int npals, byte remap [])
        {
        for ( ; npals--; gbmrgb++ )
                {
                gbmrgb -> b = remap [gbmrgb -> b];
                gbmrgb -> g = remap [gbmrgb -> g];
                gbmrgb -> r = remap [gbmrgb -> r];
                }
        }
/*...e*/

MOD_ERR ModColourAdjust(
        MOD *mod,
        int map, double gama, double shelf,
        MOD *modNew
        )
        {
        MOD_ERR mrc;
        BYTE abRemap[0x100];

        if ( (mrc = ModCopy(mod, modNew)) != MOD_ERR_OK )
                return mrc;

        map_compute(map, (unsigned char*)abRemap, gama, shelf);

        if ( mod->gbm.bpp == 24 )
                map_data((unsigned char*)modNew->pbData, modNew->gbm.w, modNew->gbm.h, (unsigned char*)abRemap);
        else
                map_palette(modNew->gbmrgb, 1 << modNew->gbm.bpp, (unsigned char*)abRemap);

        return MOD_ERR_OK;
        }
/*...e*/
/*...sModBppMap:0:*/
/*...sBppMap:0:*/
/*...sToGreyPal:0:*/
static VOID ToGreyPal(GBMRGB *gbmrgb)
        {
        int     i;

        for ( i = 0; i < 0x100; i++ )
                gbmrgb [i].r =
                gbmrgb [i].g =
                gbmrgb [i].b = (byte) i;
        }
/*...e*/
/*...sToGrey:0:*/
static VOID ToGrey(GBM *gbm, byte *src_data, byte *dest_data)
        {
        int     src_stride  = ((gbm -> w * 3 + 3) & ~3);
        int     dest_stride = ((gbm -> w     + 3) & ~3);
        int     y;

        for ( y = 0; y < gbm -> h; y++ )
                {
                byte    *src  = src_data;
                byte    *dest = dest_data;
                int     x;

                for ( x = 0; x < gbm -> w; x++ )
                        {
                        byte    b = *src++;
                        byte    g = *src++;
                        byte    r = *src++;

                        *dest++ = (byte) (((word) r * 77 + (word) g * 151 + (word) b * 28) >> 8);
                        }

                src_data  += src_stride;
                dest_data += dest_stride;
                }
        gbm -> bpp = 8;
        }
/*...e*/
/*...sTripelPal:0:*/
static VOID TripelPal(GBMRGB *gbmrgb)
        {
        int     i;

        memset(gbmrgb, 0, 0x100 * sizeof(GBMRGB));

        for ( i = 0; i < 0x40; i++ )
                {
                gbmrgb [i       ].r = (byte) (i << 2);
                gbmrgb [i + 0x40].g = (byte) (i << 2);
                gbmrgb [i + 0x80].b = (byte) (i << 2);
                }
        }
/*...e*/
/*...sTripel:0:*/
static VOID Tripel(GBM *gbm, byte *src_data, byte *dest_data)
{
        int     src_stride  = ((gbm -> w * 3 + 3) & ~3);
        int     dest_stride = ((gbm -> w     + 3) & ~3);
        int     y;

        for ( y = 0; y < gbm -> h; y++ )
                {
                byte    *src  = src_data;
                byte    *dest = dest_data;
                int     x;

                for ( x = 0; x < gbm -> w; x++ )
                        {
                        byte    b = *src++;
                        byte    g = *src++;
                        byte    r = *src++;

                        switch ( (x+y)%3 )
                                {
                                case 0: *dest++ = (byte)         (r >> 2) ;     break;
                                case 1: *dest++ = (byte) (0x40 + (g >> 2));     break;
                                case 2: *dest++ = (byte) (0x80 + (b >> 2));     break;
                                }
                        }

                src_data  += src_stride;
                dest_data += dest_stride;
                }
        gbm -> bpp = 8;
        }
/*...e*/
#endif
#endif // 0

static bool BppMap(
        MOD *mod24,
        int iPal, int iAlg,
        int iKeepRed, int iKeepGreen, int iKeepBlue, int nCols,
        MOD *modNew
        )
        {
        BYTE rm = (BYTE) (0xff00 >> iKeepRed  );
        BYTE gm = (BYTE) (0xff00 >> iKeepGreen);
        BYTE bm = (BYTE) (0xff00 >> iKeepBlue );
        bool ok = true;

#define SW2(a,b) (((a)<<8)|(b))
        switch ( SW2(iPal,iAlg) )
                {
#ifdef RELEASE_V3
                 case SW2(CVT_BW,CVT_NEAREST):
                        gbm_trunc_pal_BW(modNew->gbmrgb);
                        gbm_trunc_BW(&(modNew->gbm), (unsigned char*)mod24->pbData, (unsigned char*)modNew->pbData);
                        break;
                case SW2(CVT_4G,CVT_NEAREST):
                        gbm_trunc_pal_4G(modNew->gbmrgb);
                        gbm_trunc_4G(&(modNew->gbm), (unsigned char*)mod24->pbData, (unsigned char*)modNew->pbData);
                        break;
                case SW2(CVT_8,CVT_NEAREST):
                        gbm_trunc_pal_8(modNew->gbmrgb);
                        gbm_trunc_8(&(modNew->gbm), (unsigned char*)mod24->pbData, (unsigned char*)modNew->pbData);
                        break;
                case SW2(CVT_VGA,CVT_NEAREST):
                        gbm_trunc_pal_VGA(modNew->gbmrgb);
                        gbm_trunc_VGA(&(modNew->gbm), (unsigned char*)mod24->pbData, (unsigned char*)modNew->pbData);
                        break;
                case SW2(CVT_784,CVT_NEAREST):
                        gbm_trunc_pal_7R8G4B(modNew->gbmrgb);
                        gbm_trunc_7R8G4B(&(modNew->gbm), (unsigned char*)mod24->pbData, (unsigned char*)modNew->pbData);
                        break;
                case SW2(CVT_666,CVT_NEAREST):
                        gbm_trunc_pal_6R6G6B(modNew->gbmrgb);
                        gbm_trunc_6R6G6B(&(modNew->gbm), (unsigned char*)mod24->pbData, (unsigned char*)modNew->pbData);
                        break;
                case SW2(CVT_8G,CVT_NEAREST):
                        ToGreyPal(modNew->gbmrgb);
                        ToGrey(&(modNew->gbm), (unsigned char*)mod24->pbData, (unsigned char*)modNew->pbData);
                        break;
                case SW2(CVT_TRIPEL,CVT_NEAREST):
                        TripelPal(modNew->gbmrgb);
                        Tripel(&(modNew->gbm), (unsigned char*)mod24->pbData, (unsigned char*)modNew->pbData);
                        break;
                case SW2(CVT_FREQ,CVT_NEAREST):
                        memset(modNew->gbmrgb, 0, sizeof(modNew->gbmrgb));
                        gbm_hist(&(modNew->gbm), (unsigned char*)mod24->pbData, modNew->gbmrgb, (unsigned char*)modNew->pbData, nCols, rm, gm, bm);
                        break;
                case SW2(CVT_MCUT,CVT_NEAREST):
                        memset(modNew->gbmrgb, 0, sizeof(modNew->gbmrgb));
                        gbm_mcut(&(modNew->gbm), (unsigned char*)mod24->pbData, modNew->gbmrgb, (unsigned char*)modNew->pbData, nCols);
                        break;
                case SW2(CVT_RGB,CVT_NEAREST):
                        gbm_trunc_24(&(modNew->gbm), (unsigned char*)mod24->pbData, (unsigned char*)modNew->pbData, rm, gm, bm);
                        break;
#endif
                case SW2(CVT_BW,CVT_ERRDIFF):
                        gbm_errdiff_pal_BW(modNew->gbmrgb);
                        ok = gbm_errdiff_BW(&(modNew->gbm), (unsigned char*)mod24->pbData, (unsigned char*)modNew->pbData);
                        break;
                case SW2(CVT_4G,CVT_ERRDIFF):
                        gbm_errdiff_pal_4G(modNew->gbmrgb);
                        ok = gbm_errdiff_4G(&(modNew->gbm), (unsigned char*)mod24->pbData, (unsigned char*)modNew->pbData);
                        break;
                case SW2(CVT_8,CVT_ERRDIFF):
                        gbm_errdiff_pal_8(modNew->gbmrgb);
                        ok = gbm_errdiff_8(&(modNew->gbm), (unsigned char*)mod24->pbData, (unsigned char*)modNew->pbData);
                        break;
                case SW2(CVT_VGA,CVT_ERRDIFF):
                        gbm_errdiff_pal_VGA(modNew->gbmrgb);
                        ok = gbm_errdiff_VGA(&(modNew->gbm), (unsigned char*)mod24->pbData, (unsigned char*)modNew->pbData);
                        break;
                case SW2(CVT_784,CVT_ERRDIFF):
                        gbm_errdiff_pal_7R8G4B(modNew->gbmrgb);
                        ok = gbm_errdiff_7R8G4B(&(modNew->gbm), (unsigned char*)mod24->pbData, (unsigned char*)modNew->pbData);
                        break;
                case SW2(CVT_666,CVT_ERRDIFF):
                        gbm_errdiff_pal_6R6G6B(modNew->gbmrgb);
                        ok = gbm_errdiff_6R6G6B(&(modNew->gbm), (unsigned char*)mod24->pbData, (unsigned char*)modNew->pbData);
                        break;
                case SW2(CVT_RGB,CVT_ERRDIFF):
                        ok = gbm_errdiff_24(&(modNew->gbm), (unsigned char*)mod24->pbData, (unsigned char*)modNew->pbData, rm, gm, bm);
                        break;
                case SW2(CVT_784,CVT_HALFTONE):
                        gbm_ht_pal_7R8G4B(modNew->gbmrgb);
                        gbm_ht_7R8G4B_2x2(&(modNew->gbm), (unsigned char*)mod24->pbData, (unsigned char*)modNew->pbData);
                        break;
                case SW2(CVT_666,CVT_HALFTONE):
                        gbm_ht_pal_6R6G6B(modNew->gbmrgb);
                        gbm_ht_6R6G6B_2x2(&(modNew->gbm), (unsigned char*)mod24->pbData, (unsigned char*)modNew->pbData);
                        break;
                case SW2(CVT_8,CVT_HALFTONE):
                        gbm_ht_pal_8(modNew->gbmrgb);
                        gbm_ht_8_3x3(&(modNew->gbm), (unsigned char*)mod24->pbData, (unsigned char*)modNew->pbData);
                        break;
                case SW2(CVT_VGA,CVT_HALFTONE):
                        gbm_ht_pal_VGA(modNew->gbmrgb);
                        gbm_ht_VGA_3x3(&(modNew->gbm), (unsigned char*)mod24->pbData, (unsigned char*)modNew->pbData);
                        break;
                case SW2(CVT_RGB,CVT_HALFTONE):
                        gbm_ht_24_2x2(&(modNew->gbm), (unsigned char*)mod24->pbData, (unsigned char*)modNew->pbData, rm, gm, bm);
                        break;
                }
        return ok;
        }
/*...e*/

MOD_ERR ModBppMap( MOD *mod, int iPal, int iAlg, int iKeepRed, int iKeepGreen,
                   int iKeepBlue, int nCols, MOD *modNew )
{
  MOD_ERR mrc;
  int newbpp;
  bool fOk;

  switch ( iPal )
          {
          case CVT_BW:
                  newbpp = 1;
                  break;
          case CVT_4G:
          case CVT_8:
          case CVT_VGA:
                  newbpp = 4;
                  break;
          case CVT_784:
          case CVT_666:
          case CVT_8G:
          case CVT_TRIPEL:
          case CVT_FREQ:
          case CVT_MCUT:
                  newbpp = 8;
                  break;
          case CVT_RGB:
                  newbpp = 24;
                  break;
          }

  /* The following breakdown into cases can result in significant
     savings in memory by eliminating costly intermediate bitmaps. */

  if ( mod->gbm.bpp == 24 )
          /* 24bpp -> anything, map direct from mod */
          {
          if ( (mrc = ModCreate(mod->gbm.w, mod->gbm.h, newbpp, NULL, modNew)) != MOD_ERR_OK )
                  return mrc;
          fOk = BppMap(mod, iPal, iAlg, iKeepRed, iKeepGreen, iKeepBlue, nCols, modNew);
          }
  else if ( newbpp == 24 )
          /* !24 -> 24bpp, expand mod to modNew, map modNew inline */
          {
          if ( (mrc = ModExpandTo24Bpp(mod, modNew)) != MOD_ERR_OK )
                  return mrc;
          fOk = BppMap(modNew, iPal, iAlg, iKeepRed, iKeepGreen, iKeepBlue, nCols, modNew);
          }
  else
          /* !24bpp -> 24bpp, expand mod to mod24, and map mod24 to modNew */
          {
          MOD mod24;
          if ( (mrc = ModCreate(mod->gbm.w, mod->gbm.h, newbpp, NULL, modNew)) != MOD_ERR_OK )
                  return mrc;
          if ( (mrc = ModExpandTo24Bpp(mod, &mod24)) != MOD_ERR_OK )
                  {
                  ModDelete(modNew);
                  return mrc;
                  }
          fOk = BppMap(&mod24, iPal, iAlg, iKeepRed, iKeepGreen, iKeepBlue, nCols, modNew);
          ModDelete(&mod24);
          }

  return fOk ? MOD_ERR_OK : MOD_ERR_MEM;
}

MOD_ERR ModResize( MOD *mod, int nw, int nh, MOD *modNew )
{
  MOD_ERR mrc;
  GBM_ERR grc;

  if ( (mrc = ModCreate(nw, nh, mod->gbm.bpp, mod->gbmrgb, modNew)) != MOD_ERR_OK )
          return mrc;

  if ( (grc = gbm_simple_scale((unsigned char*)mod   ->pbData, mod   ->gbm.w, mod   ->gbm.h,
                               (unsigned char*)modNew->pbData, modNew->gbm.w, modNew->gbm.h,
                               mod->gbm.bpp)) != GBM_ERR_OK )
          {
          ModDelete(modNew);
          return MOD_ERR_GBM(grc);
          }

  return MOD_ERR_OK;
}

#ifdef IC_PM
MOD_ERR ModCreateFromHPS( HPS hps, int w, int h, int bpp, MOD *modNew )
{
  MOD_ERR mrc;
  struct
  {
    BITMAPINFOHEADER2 bmp2;
    RGB2 argb2Color[0x100];
  } bm;

  if ( (mrc = ModCreate(w, h, bpp, NULL, modNew)) != MOD_ERR_OK )
    return mrc;

  memset(&(bm.bmp2), 0, sizeof(bm.bmp2));
  bm.bmp2.cbFix     = sizeof(BITMAPINFOHEADER2);
  bm.bmp2.cx        = w;
  bm.bmp2.cy        = h;
  bm.bmp2.cBitCount = bpp;
  bm.bmp2.cPlanes   = 1;
  GpiQueryBitmapBits(hps, 0L, h, modNew->pbData, (BITMAPINFO2 *) &bm);

  if ( bpp != 24 )
  {
    int i;
    for ( i = 0; i < (1<<bpp); i++ )
    {
      modNew->gbmrgb[i].r = bm.argb2Color[i].bRed  ;
      modNew->gbmrgb[i].g = bm.argb2Color[i].bGreen;
      modNew->gbmrgb[i].b = bm.argb2Color[i].bBlue ;
    }
  }

  return MOD_ERR_OK;
}
#endif // IC_PM

#ifdef IC_WIN
MOD_ERR ModMakeHBITMAP( MOD *mod, HBITMAP *phbm, HPALETTE* phpal)
{
  HDC hdc;
  int iNumClr;

  struct
  {
    BITMAPINFOHEADER bmp;
    RGBQUAD argb2Color[0x100];
  } bm;

  /* Got the data in memory, now make bitmap */

  memset(&(bm.bmp), 0, sizeof(bm.bmp));
  bm.bmp.biSize     = sizeof(BITMAPINFOHEADER);
  bm.bmp.biWidth    = mod->gbm.w;
  bm.bmp.biHeight   = mod->gbm.h;
  bm.bmp.biBitCount = mod->gbm.bpp;
  bm.bmp.biPlanes   = 1;

//  bm.bmp.biCompression   = BI_RGB;
//  bm.bmp.biXPelsPerMeter = 0;
//  bm.bmp.biYPelsPerMeter = 0;
//  bm.bmp.biClrUsed       = 256;
//  bm.bmp.biClrImportant  = 256;
//  bm.bmp.biSizeImage     = WIDTHBYTES(bm.bmp.biWidth*bm.bmp.biBitCount) * bm.bmp.biHeight;

//  bi.biSize = sizeof( BITMAPINFOHEADER );
//  bi.biWidth = bm.bmWidth;
//  bi.biHeight = bm.bmHeight;
//  bi.biPlanes = 1;
//  bi.biBitCount = 8;
//  bi.biCompression = BI_RGB;
//  bi.biSizeImage = 0;
//  bi.biXPelsPerMeter = 0;
//  bi.biYPelsPerMeter = 0;
//  bi.biClrUsed = 0;
//  bi.biClrImportant = 0;

  if ( mod->gbm.bpp != 24 )
  {
    int i;
    for ( i = 0; i < (1<<mod->gbm.bpp); i++ )
    {
      bm.argb2Color[i].rgbRed      = mod->gbmrgb[i].r;
      bm.argb2Color[i].rgbGreen    = mod->gbmrgb[i].g;
      bm.argb2Color[i].rgbBlue     = mod->gbmrgb[i].b;
      bm.argb2Color[i].rgbReserved = 0;
    }
  }

  if ( (hdc = GetDC(0)) == (HDC) NULL )
    return MOD_ERR_HDC;

  if ( mod->gbm.bpp == 1 )
  /*...shandle 1bpp case:16:*/
  /*
  1bpp presentation spaces have a reset or background colour.
  They also have a contrast or foreground colour.
  When data is mapped into a 1bpp presentation space :-
  Data which is the reset colour, remains reset, and is stored as 0's.
  All other data becomes contrast, and is stored as 1's.
  The reset colour for 1bpp screen HPSs is white.
  I want 1's in the source data to become 1's in the HPS.
  We seem to have to reverse the ordering here to get the desired effect.
  */

  {
    static RGBQUAD argb2Black = { 0x00, 0x00, 0x00, 0x00 };
    static RGBQUAD argb2White = { 0xff, 0xff, 0xff, 0x00 };
    bm.argb2Color[0] = argb2Black; /* Contrast */
    bm.argb2Color[1] = argb2White; /* Reset */
  }

  if (*phpal == 0 && mod->gbm.bpp != 24)
  {
    *phpal = CreateDIBPal((LPBITMAPINFO)&bm, false, &iNumClr);
    if (*phpal == 0)
      return MOD_ERR_HBITMAP;
  }

  HPALETTE oldPal;

  if (*phpal != 0)
  {
    oldPal = SelectPalette(hdc, *phpal, false);
    RealizePalette(hdc);
  }

  if ( (*phbm = CreateDIBitmap( hdc, &(bm.bmp), CBM_INIT, mod->pbData, (BITMAPINFO*)&(bm.bmp), DIB_RGB_COLORS )) == (HBITMAP)NULL)
  {
    ReleaseDC(0, hdc );
    return MOD_ERR_HBITMAP;
  }

  if (*phpal != 0)
  {
    SelectPalette( hdc, oldPal, false );
  }

  ReleaseDC(0, hdc );

  return MOD_ERR_OK;
}
#endif // IC_WIN
#ifdef IC_PM
MOD_ERR ModMakeHBITMAP( MOD *mod, HAB hab, HBITMAP *phbm )
{
  SIZEL sizl;
  HDC hdc;
  HPS hps;
  struct
          {
          BITMAPINFOHEADER2 bmp2;
          RGB2 argb2Color[0x100];
          } bm;

  /* Got the data in memory, now make bitmap */

  memset(&(bm.bmp2), 0, sizeof(bm.bmp2));
  bm.bmp2.cbFix     = sizeof(BITMAPINFOHEADER2);
  bm.bmp2.cx        = mod->gbm.w;
  bm.bmp2.cy        = mod->gbm.h;
  bm.bmp2.cBitCount = mod->gbm.bpp;
  bm.bmp2.cPlanes   = 1;

  if ( mod->gbm.bpp != 24 )
          {
          int i;
          for ( i = 0; i < (1<<mod->gbm.bpp); i++ )
                  {
                  bm.argb2Color[i].bRed      = mod->gbmrgb[i].r;
                  bm.argb2Color[i].bGreen    = mod->gbmrgb[i].g;
                  bm.argb2Color[i].bBlue     = mod->gbmrgb[i].b;
                  bm.argb2Color[i].fcOptions = 0;
                  }
          }

  if ( (hdc = DevOpenDC(hab, OD_MEMORY, "*", 0L, (PDEVOPENDATA) NULL, (HDC) NULL)) == (HDC) NULL )
          return MOD_ERR_HDC;

  sizl.cx = mod->gbm.w;
  sizl.cy = mod->gbm.h;
  if ( (hps = GpiCreatePS(hab, hdc, &sizl, PU_PELS | GPIF_DEFAULT | GPIT_MICRO | GPIA_ASSOC)) == (HPS) NULL )
          {
          DevCloseDC(hdc);
          return MOD_ERR_HPS;
          }

  if ( mod->gbm.bpp == 1 )
  /*...shandle 1bpp case:16:*/
  /*
  1bpp presentation spaces have a reset or background colour.
  They also have a contrast or foreground colour.
  When data is mapped into a 1bpp presentation space :-
  Data which is the reset colour, remains reset, and is stored as 0's.
  All other data becomes contrast, and is stored as 1's.
  The reset colour for 1bpp screen HPSs is white.
  I want 1's in the source data to become 1's in the HPS.
  We seem to have to reverse the ordering here to get the desired effect.
  */

  {
    static RGB2 argb2Black = { 0x00, 0x00, 0x00 };
    static RGB2 argb2White = { 0xff, 0xff, 0xff };
    bm.argb2Color[0] = argb2Black; /* Contrast */
    bm.argb2Color[1] = argb2White; /* Reset */
  }


  if ( (*phbm = GpiCreateBitmap(hps, &(bm.bmp2), CBM_INIT, mod->pbData, (BITMAPINFO2 *) &(bm.bmp2))) == (HBITMAP) NULL )
          {
          GpiDestroyPS(hps);
          DevCloseDC(hdc);
          return MOD_ERR_HBITMAP;
          }

  GpiSetBitmap(hps, (HBITMAP) NULL);
  GpiDestroyPS(hps);
  DevCloseDC(hdc);

  return MOD_ERR_OK;
}
#endif // IC_PM

#ifndef IC_MOTIF
#ifdef IC_WIN
bool ModMapVisual( MOD *mod, int viewOption, HBITMAP *phbm,
                   LONG *plColorBg, LONG *plColorFg, HPALETTE* phpal)
#endif // IC_WIN
#ifdef IC_PM
bool ModMapVisual( HAB hab, MOD *mod, int viewOption, HBITMAP *phbm,
                   LONG *plColorBg, LONG *plColorFg )
#endif // IC_PM
{

  MOD_ERR mrc = MOD_ERR_OK; MOD modTmp, *modVisual = mod;
  bool fOk(true);
  long bitCountScreen;

#ifdef IC_WIN
  HDC hdcScreen(CreateCompatibleDC(0));

  bitCountScreen = GetDeviceCaps( hdcScreen, BITSPIXEL );

  DeleteDC( hdcScreen );
#endif // IC_WIN
#ifdef IC_PM
  HPS hps(WinGetPS(HWND_DESKTOP));
  HDC hdc(GpiQueryDevice(hps));
  DevQueryCaps(hdc, CAPS_COLOR_BITCOUNT, 1L, &bitCountScreen);
  WinReleasePS(hps);
#endif // IC_PM

  switch ( viewOption )
  {
    case 2:        // IBitmap::HalfTone:
      switch ( bitCountScreen )
      {
        case 1:
          /* Are there any 1bpp screens still in existence? */
          mrc = ModBppMap(mod, CVT_BW, CVT_NEAREST, 8,8,8, 2, &modTmp);
          modVisual = &modTmp;
          break;
        case 4:
          mrc = ModBppMap(mod, CVT_VGA, CVT_HALFTONE, 8,8,8, 16, &modTmp);
          modVisual = &modTmp;
          break;
        case 8:
          mrc = ModBppMap(mod, CVT_784, CVT_HALFTONE, 8,8,8, 256, &modTmp);
          modVisual = &modTmp;
          break;
        case 16:
          mrc = ModBppMap(mod, CVT_RGB, CVT_HALFTONE, 5,6,5, 65536, &modTmp);
          modVisual = &modTmp;
          break;
      }
    break;

    case 1:    //  IBitmap::ErrorDiffused:
      switch ( bitCountScreen )
      {
        case 1:
          /* Are there any 1bpp screens still in existence? */
          mrc = ModBppMap(mod, CVT_BW, CVT_ERRDIFF, 8,8,8, 2, &modTmp);
          modVisual = &modTmp;
          break;
        case 4:
          mrc = ModBppMap(mod, CVT_VGA, CVT_ERRDIFF, 8,8,8, 16, &modTmp);
          modVisual = &modTmp;
          break;
        case 8:
          mrc = ModBppMap(mod, CVT_784, CVT_ERRDIFF, 8,8,8, 256, &modTmp);
          modVisual = &modTmp;
          break;
        case 16:
          mrc = ModBppMap(mod, CVT_RGB, CVT_ERRDIFF, 5,6,5, 65536, &modTmp);
          modVisual = &modTmp;
          break;
      }
    break;
  }

  if ( mrc != MOD_ERR_OK )
  {
    ModDelete(modVisual);
    return false; /* Unable to make improved quality bitmap */
  }

  if ( modVisual->gbm.bpp == 1 )
  /*...sremember Bg and Fg colours:16:*/
  {
    *plColorBg = (modVisual->gbmrgb[0].r << 16) + (modVisual->gbmrgb[0].g << 8) + modVisual->gbmrgb[0].b;
    *plColorFg = (modVisual->gbmrgb[1].r << 16) + (modVisual->gbmrgb[1].g << 8) + modVisual->gbmrgb[1].b;
  }

#ifdef IC_WIN
  ModMakeHBITMAP( modVisual, phbm, phpal );
#endif // IC_WIN
#ifdef IC_PM
  ModMakeHBITMAP( modVisual, hab, phbm );
#endif // IC_PM

  if ( modVisual != mod )
          ModDelete(modVisual);

  return fOk;
}

#ifdef IC_WIN
MOD_ERR ModCreateFromHBitmap( MOD* mod, HBITMAP hbm, HPALETTE hpal )
{
  HDC     hdc;
  MOD_ERR mrc;
  BITMAP  bmp;
  int     rc;
  struct
  {
    BITMAPINFOHEADER bih;
    RGBQUAD          argb2Color[0x100];
  } bm;

  hdc = GetDC(0);

  if (!hpal)
    hpal = (HPALETTE) GetStockObject( DEFAULT_PALETTE );

  GetObject(hbm, sizeof(bmp), (LPSTR)&bmp);

  memset(&(bm.bih), 0, sizeof(bm.bih));
  bm.bih.biSize = sizeof( BITMAPINFOHEADER );
  bm.bih.biWidth              = bmp.bmWidth;
  bm.bih.biHeight             = bmp.bmHeight;
  bm.bih.biPlanes             = 1;
  bm.bih.biBitCount           = bmp.bmPlanes * bmp.bmBitsPixel;
  bm.bih.biCompression        = BI_RGB;
  bm.bih.biSizeImage          = 0;
  bm.bih.biXPelsPerMeter      = 0;
  bm.bih.biYPelsPerMeter      = 0;
  bm.bih.biClrUsed            = 0;
  bm.bih.biClrImportant       = 0;

  if ( bm.bih.biBitCount == 16 || bm.bih.biBitCount == 32)
    bm.bih.biBitCount = 24;

  if ( (mrc = ModCreate(bmp.bmWidth,
                        bmp.bmHeight,
                        bm.bih.biBitCount,
                        0,
                        mod)) != MOD_ERR_OK )
    return mrc;

  hpal = SelectPalette( hdc, hpal, false );
  RealizePalette( hdc );

  rc = GetDIBits( hdc,
                  hbm,
                  0,
                  bmp.bmHeight,
                  0,
                  (BITMAPINFO*)&(bm.bih),
                  (DWORD)DIB_RGB_COLORS);

  rc = GetDIBits( hdc,
                  hbm,
                  0,
                  bmp.bmHeight,
                  mod->pbData,
                  (BITMAPINFO*)&(bm.bih),
                  (DWORD)DIB_RGB_COLORS);
  if (rc == 0)
    ITHROWGUIERROR("GetDIBits");

  SelectPalette( hdc, hpal, false );
  ReleaseDC( 0, hdc );

  if ( bm.bih.biBitCount != 24 )
  {
    int i;
    for ( i = 0; i < (1<<bm.bih.biBitCount); i++ )
    {
      mod->gbmrgb[i].r = bm.argb2Color[i].rgbRed  ;
      mod->gbmrgb[i].g = bm.argb2Color[i].rgbGreen;
      mod->gbmrgb[i].b = bm.argb2Color[i].rgbBlue ;
    }
  }
  return mrc;
}
#endif // IC_WIN
#ifdef IC_PM
MOD_ERR ModCreateFromHBitmap( MOD* mod, HAB hab, HBITMAP hbm )
{
  HDC     hdc;
  SIZEL   sizl;
  HPS     hps;
  MOD_ERR mrc;
  struct
  {
    BITMAPINFOHEADER2 bmp2;
    RGB2 argb2Color[0x100];
  } bm;

  memset(&(bm.bmp2), 0, sizeof(bm.bmp2));
  bm.bmp2.cbFix = 16;
  GpiQueryBitmapInfoHeader(hbm, &bm.bmp2);

  if ( bm.bmp2.cBitCount == 16 )
    bm.bmp2.cBitCount = 24;

  if ( (hdc = DevOpenDC(hab, OD_MEMORY, "*", 0L, (PDEVOPENDATA) NULL, (HDC) NULL)) == (HDC) NULL )
  {
    return MOD_ERR_CREATE;
  }

  sizl.cx = bm.bmp2.cx;
  sizl.cy = bm.bmp2.cy;
  if ( (hps = GpiCreatePS(hab, hdc, &sizl, PU_PELS | GPIF_DEFAULT | GPIT_MICRO | GPIA_ASSOC)) == (HPS) NULL )
  {
    DevCloseDC(hdc);
    return MOD_ERR_CREATE;
  }

  GpiSetBitmap(hps, hbm);
  mrc = ModCreateFromHPS(hps, bm.bmp2.cx, bm.bmp2.cy, bm.bmp2.cBitCount, mod);

  GpiSetBitmap(hps, (HBITMAP) NULL);
  GpiDestroyPS(hps);
  DevCloseDC(hdc);

  return mrc;
}

#ifdef RELEASE_V3
/*...sModMakeHMF:0:*/
/*
I have observed that if I use GpiBitBlt() instead of the GpiWCBitBlt() below,
when the MetaFile is pasted into CUADraw, although CUADraws sizing frame
appears in the middle of the window, the bitmap bits are always drawn at (0,0)
on CUADraws client window. This is why I use GpiWCBitBlt(). Also, in the
PM Programming Reference, under DevOpenDC is a comment suggesting that
GpiBitBlt() should not be used in order to be SAA conforming, presumably there
is a connection here...
*/

MOD_ERR ModMakeHMF( HBITMAP hbm, HAB hab, HMF *phmf )
{
  DEVOPENSTRUC dop = { NULL, "DISPLAY", NULL, NULL, NULL, NULL, NULL, NULL, NULL };
  SIZEL sizl;
  HPS hpsHmf;
  HDC hdcHmf;
  BITMAPINFOHEADER bmp;
  POINTL aptl[4];

  if ( (hdcHmf = DevOpenDC(hab, OD_METAFILE, "*", 5L, (PDEVOPENDATA)&dop, (HDC) NULL)) == (HDC) NULL )
    return MOD_ERR_HDC;

  GpiQueryBitmapParameters(hbm, &bmp);

  sizl.cx = bmp.cx;
  sizl.cy = bmp.cy;
  if ( (hpsHmf = GpiCreatePS(hab, hdcHmf, &sizl, PU_PELS | GPIF_DEFAULT | GPIT_MICRO | GPIA_ASSOC)) == (HPS) NULL )
  {
    DevCloseDC(hdcHmf);
    return MOD_ERR_HPS;
  }

  aptl[0].x = 0;
  aptl[0].y = 0;
  aptl[1].x = bmp.cx;
  aptl[1].y = bmp.cy;
  aptl[2].x = 0;
  aptl[2].y = 0;
  aptl[3].x = bmp.cx;
  aptl[3].y = bmp.cy;
  GpiWCBitBlt(hpsHmf, hbm, 4L, aptl, ROP_SRCCOPY, BBO_IGNORE);

  GpiDestroyPS(hpsHmf);
  (*phmf) = DevCloseDC(hdcHmf);

  if ( (*phmf) == DEV_ERROR )
          return MOD_ERR_HMF;

  return MOD_ERR_OK;
}
#endif
#endif // IC_PM
#endif // IC_MOTIF

unsigned long ModError(MOD_ERR rc)
{
  if ( rc >= MOD_ERR_GBM(0) )
    return gbm_err(rc-MOD_ERR_GBM(0));
  switch ( (int) rc )
  {
    case MOD_ERR_OK:        return 0;
    case MOD_ERR_MEM:       return IC_HEAP_EXHAUSTED;
    case MOD_ERR_OPEN:      return IC_GBM_OPEN_FAILED;
    case MOD_ERR_CREATE:    return IC_GBM_CREATE_FAILED;
    case MOD_ERR_SUPPORT:   return IC_GBM_NO_SUPPORT;
    case MOD_ERR_HDC:       return IC_GBM_HDC_FAILED;
    case MOD_ERR_HPS:       return IC_GBM_HPS_FAILED;
    case MOD_ERR_HMF:       return IC_GBM_METAFILE_FAILED;
    case MOD_ERR_HBITMAP:   return IC_GBM_BITMAP_FAILED;
    case MOD_ERR_CLIP:      return IC_GBM_NEED_CLIPPED;
  }
  return IC_GBM_UNKNOWN_ERROR;
}
