// Revision: 47 1.3.1.3 source/multmed/immsequ.cpp, multimedia, ioc.v400, 001006  
/*******************************************************************************
* FILE NAME: immsequ.cpp                                                       *
*                                                                              *
* DESCRIPTION:                                                                 *
*   This file contains the implementation of classes/functions declared        *
*   in immsequ.hpp                                                             *
*                                                                              *
* COPYRIGHT:                                                                   *
*   IBM Open Class Library                                                     *
*   (C) Copyright International Business Machines Corporation 1992, 1997       *
*   Licensed Material - Program-Property of IBM - All Rights Reserved.         *
*   US Government Users Restricted Rights - Use, duplication, or disclosure    *
*   restricted by GSA ADP Schedule Contract with IBM Corp.                     *
*                                                                              *
*******************************************************************************/

extern "C"
   {
   #include <string.h>
   #define INCL_MCIOS2
   #define IC_MULTIMEDIA
   #include <immdefs.h>
   }

#include <immexcpt.hpp>
#include <imultsta.hpp>
#include <immowin.hpp>
#include <itrace.hpp>
#include <immsequ.hpp>

// Segment definitions
#ifdef IC_PAGETUNE
  #define _IMMSEQU_CPP_
  #include <ipagetun.h>
#endif

/*------------------------------------------------------------------------------
| IMMSequencer::IMMSequencer                                                   |
| This constructor creates a new device object.                                |
|                                                                              |
| Note that for Win32, if a compound device (one requiring a data file) is     |
| opened without specifying a "device element name", the device will open, but |
| MCI_LOAD is not supported. Because of this, we defer the actual open until   |
| IMMFileMedia::load() is called by forcing openNow to false.                  |
------------------------------------------------------------------------------*/
IMMSequencer::IMMSequencer( bool openNow,
                            unsigned long instance,
                            bool openShareable)
#ifdef IC_PM
            : IMMFileMedia("SEQUENCER", openNow, instance, openShareable)
#endif
#ifdef IC_WIN
            : IMMFileMedia("SEQUENCER", false, instance, openShareable)
              , fDeviceSettings(0)
#endif
{ IMODTRACE_DEVELOP("IMMSequencer::ctor #1"); }

/*------------------------------------------------------------------------------
| IMMSequencer::~IMMSequencer                                                  |
| Virtual destructor - nothing special needed as parent does cleanup.          |
|                                                                              |
------------------------------------------------------------------------------*/
IMMSequencer::~IMMSequencer()
{ IMODTRACE_DEVELOP("IMMSequencer::dtor"); }

/*------------------------------------------------------------------------------
| IMMSequencer::isOpenStringValid                                              |
| Returns true if the string passed in is valid for this device.               |
|                                                                              |
------------------------------------------------------------------------------*/
bool IMMSequencer::isOpenStringValid(const IString &deviceName) const
{
  IString tester(deviceName);
  IMODTRACE_DEVELOP("IMMSequencer::isOpenStringValid");
  //Open string should either be a device name valid for this object,
  //or a file name with an extension (verified by existence of a '.')
  //Eventually we should check for a valid extension for this device.
  return((tester.upperCase().indexOf("SEQUENCER") == 1 ? true : false) ||
         (tester.upperCase().indexOf(".") ? true : false)
        );
}

/*------------------------------------------------------------------------------
| IMMSequencer::IMMSequencer                                                   |
| This constructor wrappers an existing device, and gives a derived class the  |
| ability to specify a desired alias (instead of ICLUI generating it).         |
------------------------------------------------------------------------------*/
IMMSequencer::IMMSequencer(unsigned long newDeviceId,
                           const IString &newAlias)
            : IMMFileMedia(newDeviceId, newAlias)
#ifdef IC_WIN
              , fDeviceSettings(0)
#endif
{ IMODTRACE_DEVELOP("IMMSequencer::ctor #2"); }

#ifdef IC_WIN
/*------------------------------------------------------------------------------
| IMMSequencer::volume                                                         |
| Override of IMMDevice::volume. Necessary for Win32 since volume (and sound   |
| shaping in general) is not consolidated by the MCI.                          |
------------------------------------------------------------------------------*/
unsigned long IMMSequencer::volume(AudioChannel channel ,CallType call) const
{
  IMODTRACE_DEVELOP("IMMSequencer::volume");

  unsigned long       ulDetails[2];
  bool             uniform = false;  // Assume a specific channel is requested

  if (channel == all)
     uniform = true;       // 1 value returned

  // cast away the const to call mixerControlValues (which is not const)
  IMMSequencer * const nonConstThis = (IMMSequencer * const) this;

  if (!nonConstThis->mixerControlValues(
              MIXERLINE_COMPONENTTYPE_SRC_SYNTHESIZER,  // class specific
              MIXERCONTROL_CONTROLTYPE_VOLUME,
              ulDetails, uniform))
     ITHROWMMERROR(lastError(),"mixerControlValues");

  if (channel == right)
     return ( ulDetails[1] );  // Right channel is in second position
  else
     return ( ulDetails[0] );  // Left channel or uniform value in first position
}

/*------------------------------------------------------------------------------
| IMMSequencer::setVolume                                                      |
| Override of IMMDevice::setVolume. Necessary for Win32 since volume (and sound|
| shaping in general) is not consolidated by the MCI.                          |
------------------------------------------------------------------------------*/
IMMSequencer& IMMSequencer::setVolume(unsigned long volume,
                                IMMDevice::AudioChannel channel,
                                const IMMMillisecondTime &over,
                                CallType call)
{
  IMODTRACE_DEVELOP("IMMSequencer::setVolume");

  unsigned long       ulDetails[2];
  bool             uniform = false;  // Assume a specific channel is requested

  if (channel == all)
  {
     uniform = true;       // 1 value returned
  }
  else
  {
     // Get current values of both channels, since one won't change
     if (!mixerControlValues(
                 MIXERLINE_COMPONENTTYPE_SRC_SYNTHESIZER,  // class specific
                 MIXERCONTROL_CONTROLTYPE_VOLUME,
                 ulDetails, uniform))
        ITHROWMMERROR(lastError(),"mixerDetails");
  }

  if (channel == right)
     ulDetails[1] = volume;  // Right channel is in second position
  else
     ulDetails[0] = volume;  // Left channel or uniform value in first position

  if (!setMixerControlValues(
              MIXERLINE_COMPONENTTYPE_SRC_SYNTHESIZER,  // class specific
              MIXERCONTROL_CONTROLTYPE_VOLUME,
              ulDetails, uniform))
     ITHROWMMERROR(lastError(),"mixerDetails");

  return *this;
}

/*------------------------------------------------------------------------------
| IMMSequencer::resume                                                         |
| Override of IMMPlayableDevice::resume. Win32 MCI sequencer does not support  |
| MCI_RESUME, so we simulate.                                                  |
------------------------------------------------------------------------------*/
IMMSequencer& IMMSequencer::resume(bool resume ,
                                   CallType call)
{
  IMODTRACE_DEVELOP("IMMSequencer::resume");

  IASSERTSTATE(isOpen());

  MCI_GENERIC_PARMS parms;

  if ( IMMDevice::paused == mode() && resume )
  {
     parms.dwCallback = deviceWindow().handle().asUnsigned();
     call = nowait;

     // Simulation of MCI_RESUME
     play(IMMTime(),IMMTime(),false,call);
     if (lastError())
        ITHROWMMERROR(lastError(),"sendCommand");
  }
  return *this;
}

/*------------------------------------------------------------------------------
| IMMSequencer::saveDeviceSettings                                                |
|                                                                              |
|                                                                              |
------------------------------------------------------------------------------*/
IMMSequencer& IMMSequencer::saveDeviceSettings()
{
  IMODTRACE_DEVELOP("IMMSequencer::saveDeviceSettings");
  Inherited::saveDeviceSettings();
  return *this;
}

/*------------------------------------------------------------------------------
| IMMSequencer::restoreDeviceSettings                                             |
|                                                                              |
|                                                                              |
------------------------------------------------------------------------------*/
IMMSequencer& IMMSequencer::restoreDeviceSettings(bool newRecordMode)
{
  IMODTRACE_DEVELOP("IMMSequencer::restoreDeviceSettings");
  Inherited::restoreDeviceSettings();
  return *this;
}

#endif
