// Revision: 06 1.3.1.3 source/multmed/immaud.cpp, multimedia, ioc.v400, 001006  
/*******************************************************************************
* FILE NAME: immaud.cpp                                                        *
*                                                                              *
* DESCRIPTION:                                                                 *
*   This file contains the implementation of classes/functions declared        *
*   in immaud.hpp.                                                             *
*                                                                              *
* COPYRIGHT:                                                                   *
*   IBM Open Class Library                                                     *
*   (C) Copyright International Business Machines Corporation 1992, 1997       *
*   Licensed Material - Program-Property of IBM - All Rights Reserved.         *
*   US Government Users Restricted Rights - Use, duplication, or disclosure    *
*   restricted by GSA ADP Schedule Contract with IBM Corp.                     *
*                                                                              *
*******************************************************************************/

extern "C"
   {
   #include <string.h>
   #define INCL_MCIOS2
   #define INCL_MMIOOS2
   #define IC_MULTIMEDIA
   #include <immdefs.h>
   }
#include <itrace.hpp>
#include <immexcpt.hpp>
#include <imultsta.hpp>
#include <immowin.hpp>
#include <immaud.hpp>

// Segment definitions
#ifdef IC_PAGETUNE
  #define _IMMAUD_CPP_
  #include <ipagetun.h>
#endif

/*------------------------------------------------------------------------------
| IMMConfigurableAudio::bytesPerSecond                                         |
|                                                                              |
|                                                                              |
------------------------------------------------------------------------------*/
unsigned long IMMConfigurableAudio::bytesPerSecond(CallType call) const
{
  IMODTRACE_DEVELOP("IMMConfigurableAudio::bytesPerSecond");

  IASSERTSTATE(isOpen());
  unsigned long rc = itemStatus(translateAudioFlag(MCI_WAVE_STATUS_AVGBYTESPERSEC), 0, call);
  if (lastError())
     ITHROWMMERROR(lastError(),"sendCommand");
  return rc;
}

/*------------------------------------------------------------------------------
| IMMConfigurableAudio::bitsPerSample                                          |
|                                                                              |
|                                                                              |
------------------------------------------------------------------------------*/
unsigned long IMMConfigurableAudio::bitsPerSample(CallType call) const
{
  IMODTRACE_DEVELOP("IMMConfigurableAudio::bitsPerSample");

  IASSERTSTATE(isOpen());
  unsigned long rc =itemStatus(translateAudioFlag(MCI_WAVE_STATUS_BITSPERSAMPLE),0, call);
  if (lastError())
     ITHROWMMERROR(lastError(),"sendCommand");
  return rc;
}

/*------------------------------------------------------------------------------
| IMMConfigurableAudio::blockAlignment                                         |
|                                                                              |
|                                                                              |
------------------------------------------------------------------------------*/
unsigned long IMMConfigurableAudio::blockAlignment(CallType call) const
{
  IMODTRACE_DEVELOP("IMMConfigurableAudio::blockAlignment");

  IASSERTSTATE(isOpen());
  unsigned long rc =itemStatus(translateAudioFlag(MCI_WAVE_STATUS_BLOCKALIGN),0, call);
  if (lastError())
     ITHROWMMERROR(lastError(),"sendCommand");
  return rc;
}

/*------------------------------------------------------------------------------
| IMMConfigurableAudio::channels                                               |
|                                                                              |
|                                                                              |
------------------------------------------------------------------------------*/
unsigned long IMMConfigurableAudio::channels(CallType call) const
{
  IMODTRACE_DEVELOP("IMMConfigurableAudio::channels");

  IASSERTSTATE(isOpen());
  unsigned long rc = itemStatus(translateAudioFlag(MCI_WAVE_STATUS_CHANNELS), 0,call);
  if (lastError())
     ITHROWMMERROR(lastError(),"sendCommand");
  return rc;
}

/*------------------------------------------------------------------------------
| IMMConfigurableAudio::format                                                 |
|                                                                              |
|                                                                              |
------------------------------------------------------------------------------*/
IMMAudioBuffer::Format IMMConfigurableAudio::format(CallType call) const
{
  IMODTRACE_DEVELOP("IMMConfigurableAudio::format");

  IASSERTSTATE(isOpen());
  IMMAudioBuffer::Format rc;
  rc = (IMMAudioBuffer::Format) itemStatus(translateAudioFlag(MCI_WAVE_STATUS_FORMATTAG),0,call);
  if (lastError())
     ITHROWMMERROR(lastError(),"sendCommand");
  return rc;
}

/*------------------------------------------------------------------------------
| IMMConfigurableAudio::samplesPerSecond                                       |
|                                                                              |
|                                                                              |
------------------------------------------------------------------------------*/
unsigned long IMMConfigurableAudio::samplesPerSecond(CallType call) const
{
  IMODTRACE_DEVELOP("IMMConfigurableAudio::samplesPerSecond");

  IASSERTSTATE(isOpen());
  unsigned long rc = itemStatus(translateAudioFlag(MCI_WAVE_STATUS_SAMPLESPERSEC), 0, call);
  if (lastError())
     ITHROWMMERROR(lastError(),"sendCommand");
  return rc;
}

/*------------------------------------------------------------------------------
| IMMConfigurableAudio::setBytesPerSecond                                      |
|                                                                              |
|                                                                              |
------------------------------------------------------------------------------*/
IMMConfigurableAudio& IMMConfigurableAudio::setBytesPerSecond(unsigned long averageBytes,
                                                     CallType call)
{
  IMODTRACE_DEVELOP("IMMConfigurableAudio::setBytesPerSecond");

  IASSERTSTATE(isOpen());
  MCI_WAVE_SET_PARMS parms;

  memset(&parms, 0, sizeof(parms));
#ifdef IC_PM
  parms.hwndCallback     = HWND(deviceWindow().handle());
  if (translateAudioFlag(MCI_WAVE_SET_AVGBYTESPERSEC) ==
               MCI_WAVE_SET_AVGBYTESPERSEC)
  {
     parms.ulAvgBytesPerSec = averageBytes;
     sendCommand(MCI_SET, MCI_WAVE_SET_AVGBYTESPERSEC | call, &parms);
  } else {
     parms.ulItem          = translateAudioFlag(MCI_WAVE_SET_AVGBYTESPERSEC);
     parms.ulValue         = averageBytes;
     sendCommand(MCI_SET,MCI_SET_ITEM | call, &parms);
  } /* endif */
#endif
#ifdef IC_WIN
  parms.dwCallback      = deviceWindow().handle().asUnsigned();
  parms.nAvgBytesPerSec = averageBytes;
  sendCommand(MCI_SET, MCI_WAVE_SET_AVGBYTESPERSEC | call, &parms);
#endif
  if (lastError())
     ITHROWMMERROR(lastError(),"sendCommand");
  return *this;
}

/*------------------------------------------------------------------------------
| IMMConfigurableAudio::setBitsPerSample                                       |
|                                                                              |
|                                                                              |
------------------------------------------------------------------------------*/
IMMConfigurableAudio& IMMConfigurableAudio::setBitsPerSample(unsigned long bitsPer,
                                             CallType call)
{
  IMODTRACE_DEVELOP("IMMConfigurableAudio::setBitsPerSample");

  IASSERTSTATE(isOpen());
  MCI_WAVE_SET_PARMS parms;

  memset(&parms, 0, sizeof(parms));
#ifdef IC_PM
  parms.hwndCallback    = HWND(deviceWindow().handle());
  if (translateAudioFlag(MCI_WAVE_SET_BITSPERSAMPLE) ==
               MCI_WAVE_SET_BITSPERSAMPLE)
  {
     parms.usBitsPerSample = (unsigned short)bitsPer;
     sendCommand(MCI_SET, MCI_WAVE_SET_BITSPERSAMPLE | call, &parms);
  } else {
     parms.ulItem          = translateAudioFlag(MCI_WAVE_SET_BITSPERSAMPLE);
     parms.ulValue         = bitsPer;
     sendCommand(MCI_SET,MCI_SET_ITEM | call, &parms);
  } /* endif */
#endif
#ifdef IC_WIN
  parms.dwCallback    = deviceWindow().handle().asUnsigned();
  parms.wBitsPerSample = (unsigned short)bitsPer;
  sendCommand(MCI_SET, MCI_WAVE_SET_BITSPERSAMPLE | call, &parms);
#endif

  if (lastError())
     ITHROWMMERROR(lastError(),"sendCommand");
  return *this;
}

/*------------------------------------------------------------------------------
| IMMConfigurableAudio::setBlockAlignment                                      |
|                                                                              |
|                                                                              |
------------------------------------------------------------------------------*/
IMMConfigurableAudio& IMMConfigurableAudio::setBlockAlignment(unsigned long alignment,
                                                CallType call)
{
  IMODTRACE_DEVELOP("IMMConfigurableAudio::setBlockAlignment");

  IASSERTSTATE(isOpen());
  MCI_WAVE_SET_PARMS parms;

  memset(&parms, 0, sizeof(parms));
#ifdef IC_PM
  parms.hwndCallback     = HWND(deviceWindow().handle());
  if (translateAudioFlag(MCI_WAVE_SET_BLOCKALIGN) ==
               MCI_WAVE_SET_BLOCKALIGN)
  {
     parms.usBlockAlign     = (unsigned short)alignment;
     sendCommand(MCI_SET, MCI_WAVE_SET_BLOCKALIGN | call, &parms);
  } else {
     parms.ulItem          = translateAudioFlag(MCI_WAVE_SET_BLOCKALIGN);
     parms.ulValue         = alignment;
     sendCommand(MCI_SET,MCI_SET_ITEM | call, &parms);
  } /* endif */
#endif
#ifdef IC_WIN
  parms.dwCallback    = deviceWindow().handle().asUnsigned();
  parms.nBlockAlign   = (unsigned short)alignment;
  sendCommand(MCI_SET, MCI_WAVE_SET_BLOCKALIGN | call, &parms);
#endif
  if (lastError())
     ITHROWMMERROR(lastError(),"sendCommand");
  return *this;
}

/*------------------------------------------------------------------------------
| IMMConfigurableAudio::setChannels                                            |
|                                                                              |
|                                                                              |
------------------------------------------------------------------------------*/
IMMConfigurableAudio& IMMConfigurableAudio::setChannels(unsigned long channels, CallType call)
{
  IMODTRACE_DEVELOP("IMMConfigurableAudio::setChannels");

  IASSERTSTATE(isOpen());
  MCI_WAVE_SET_PARMS parms;

  memset(&parms, 0, sizeof(parms));
#ifdef IC_PM
  parms.hwndCallback     = HWND(deviceWindow().handle());
  if (translateAudioFlag(MCI_WAVE_SET_CHANNELS) ==
               MCI_WAVE_SET_CHANNELS)
  {
     parms.usChannels       = (unsigned short)channels;
     sendCommand(MCI_SET, MCI_WAVE_SET_CHANNELS | call, &parms);
  } else {
     parms.ulItem          = translateAudioFlag(MCI_WAVE_SET_CHANNELS);
     parms.ulValue         = channels;
     sendCommand(MCI_SET,MCI_SET_ITEM | call, &parms);
  } /* endif */
#endif
#ifdef IC_WIN
  parms.dwCallback      = deviceWindow().handle().asUnsigned();
  parms.nChannels       = (unsigned short)channels;
  sendCommand(MCI_SET, MCI_WAVE_SET_CHANNELS | call, &parms);
#endif
  if (lastError())
     ITHROWMMERROR(lastError(),"sendCommand");
  return *this;
}

/*------------------------------------------------------------------------------
| IMMConfigurableAudio::setFormat                                              |
|                                                                              |
|                                                                              |
------------------------------------------------------------------------------*/
IMMConfigurableAudio& IMMConfigurableAudio::setFormat(IMMAudioBuffer::Format tag, CallType call)
{
  IMODTRACE_DEVELOP("IMMConfigurableAudio::setFormat");

  IASSERTSTATE(isOpen());
  MCI_WAVE_SET_PARMS parms;

  memset(&parms, 0, sizeof(parms));
#ifdef IC_PM
  parms.hwndCallback     = HWND(deviceWindow().handle());
  if (translateAudioFlag(MCI_WAVE_SET_FORMATTAG) ==
               MCI_WAVE_SET_FORMATTAG)
  {
     parms.usFormatTag      = (unsigned short)tag;
     sendCommand(MCI_SET, MCI_WAVE_SET_FORMATTAG | call, &parms);
  } else {
     parms.ulItem          = translateAudioFlag(MCI_WAVE_SET_FORMATTAG);
     parms.ulValue         = tag;
     sendCommand(MCI_SET,MCI_SET_ITEM | call, &parms);
  } /* endif */
#endif
#ifdef IC_WIN
  parms.dwCallback      = deviceWindow().handle().asUnsigned();
  parms.wFormatTag      = (unsigned short)tag;
  sendCommand(MCI_SET, MCI_WAVE_SET_FORMATTAG | call, &parms);
#endif
  if (lastError())
     ITHROWMMERROR(lastError(),"sendCommand");
  return *this;
}

/*------------------------------------------------------------------------------
| IMMConfigurableAudio::setSamplesPerSecond                                    |
|                                                                              |
|                                                                              |
------------------------------------------------------------------------------*/
IMMConfigurableAudio& IMMConfigurableAudio::setSamplesPerSecond(unsigned long samplesPer,
                                                CallType call)
{
  IMODTRACE_DEVELOP("IMMConfigurableAudio::setSamplesPerSecond");

  IASSERTSTATE(isOpen());
  MCI_WAVE_SET_PARMS parms;

  memset(&parms, 0, sizeof(parms));
#ifdef IC_PM
  parms.hwndCallback     = HWND(deviceWindow().handle());
  if (translateAudioFlag(MCI_WAVE_SET_SAMPLESPERSEC) ==
               MCI_WAVE_SET_SAMPLESPERSEC)
  {
     parms.ulSamplesPerSec  = samplesPer;
     sendCommand(MCI_SET, MCI_WAVE_SET_SAMPLESPERSEC | call, &parms);
  } else {
     parms.ulItem          = translateAudioFlag(MCI_WAVE_SET_SAMPLESPERSEC);
     parms.ulValue         = samplesPer;
     sendCommand(MCI_SET,MCI_SET_ITEM | call, &parms);
  } /* endif */
#endif
#ifdef IC_WIN
  parms.dwCallback      = deviceWindow().handle().asUnsigned();
  parms.nSamplesPerSec  = samplesPer;
  sendCommand(MCI_SET, MCI_WAVE_SET_SAMPLESPERSEC | call, &parms);
#endif
  if (lastError())
     ITHROWMMERROR(lastError(),"sendCommand");
  return *this;
}

/*------------------------------------------------------------------------------
| IMMConfigurableAudio::translateAudioFlag                                     |
|                                                                              |
|                                                                              |
------------------------------------------------------------------------------*/
unsigned long IMMConfigurableAudio::translateAudioFlag(unsigned long flag) const
{
  IMODTRACE_DEVELOP("IMMConfigurableAudio::translateAudioFlag");
  return flag;
}

/*------------------------------------------------------------------------------
| IMMConfigurableAudio::IMMConfigurableAudio                                   |
|                                                                              |
|                                                                              |
------------------------------------------------------------------------------*/
IMMConfigurableAudio::IMMConfigurableAudio(const IString &baseDeviceName,
                             bool openNow,
                             unsigned long instance,
                             bool shareable)
           : IMMRecordable(baseDeviceName, openNow, instance, shareable)
#ifdef IC_WIN
             , fDeviceSettings(0)
#endif
{ IMODTRACE_DEVELOP("IMMConfigurableAudio::ctor #1"); }

/*------------------------------------------------------------------------------
| IMMConfigurableAudio::IMMConfigurableAudio                                   |
|                                                                              |
|                                                                              |
------------------------------------------------------------------------------*/
IMMConfigurableAudio::IMMConfigurableAudio(unsigned long newDeviceId,
                             const IString &newAlias)
                    : IMMRecordable(newDeviceId, newAlias)
#ifdef IC_WIN
                      , fDeviceSettings(0)
#endif
{ IMODTRACE_DEVELOP("IMMConfigurableAudio::ctor #2"); }

/*------------------------------------------------------------------------------
| IMMConfigurableAudio::~IMMConfigurableAudio                                  |
|                                                                              |
|                                                                              |
------------------------------------------------------------------------------*/
IMMConfigurableAudio::~IMMConfigurableAudio()
//{ }
{ IMODTRACE_DEVELOP("IMMConfigurableAudio::dtor"); }

#ifdef IC_WIN
/*------------------------------------------------------------------------------
| IMMConfigurableAudio::volume                                                            |
| Override of IMMDevice::volume. Necessary for Win32 since volume (and sound   |
| shaping in general) is not consolidated by the MCI.                          |
------------------------------------------------------------------------------*/
unsigned long IMMConfigurableAudio::volume(AudioChannel channel ,CallType call) const
{
  IMODTRACE_DEVELOP("IMMConfigurableAudio::volume");

  unsigned long       ulDetails[2];
  bool             uniform = false;  // Assume a specific channel is requested

  if (channel == all)
     uniform = true;       // 1 value returned

  // cast away the const to call mixerControlValues (which is not const)
  IMMConfigurableAudio * const nonConstThis = (IMMConfigurableAudio * const) this;

  if (!nonConstThis->mixerControlValues(
              MIXERLINE_COMPONENTTYPE_SRC_WAVEOUT,      // class specific
              MIXERCONTROL_CONTROLTYPE_VOLUME,
              ulDetails, uniform))
     ITHROWMMERROR(lastError(),"mixerControlValues");

  if (channel == right)
     return ( ulDetails[1] );  // Right channel is in second position
  else
     return ( ulDetails[0] );  // Left channel or uniform value in first position
}

/*------------------------------------------------------------------------------
| IMMConfigurableAudio::setVolume                                                         |
| Override of IMMDevice::setVolume. Necessary for Win32 since volume (and sound|
| shaping in general) is not consolidated by the MCI.                          |
------------------------------------------------------------------------------*/
IMMConfigurableAudio& IMMConfigurableAudio::setVolume(unsigned long volume,
                                IMMDevice::AudioChannel channel,
                                const IMMMillisecondTime &over,
                                CallType call)
{
  IMODTRACE_DEVELOP("IMMConfigurableAudio::setVolume");

  unsigned long       ulDetails[2];
  bool             uniform = false;  // Assume a specific channel is requested

  if (channel == all)
  {
     uniform = true;       // 1 value returned
  }
  else
  {
     // Get current values of both channels, since one won't change
     if (!mixerControlValues(
                 MIXERLINE_COMPONENTTYPE_SRC_WAVEOUT,      // class specific
                 MIXERCONTROL_CONTROLTYPE_VOLUME,
                 ulDetails, uniform))
        ITHROWMMERROR(lastError(),"mixerDetails");
  }

  if (channel == right)
     ulDetails[1] = volume;  // Right channel is in second position
  else
     ulDetails[0] = volume;  // Left channel or uniform value in first position

  if (!setMixerControlValues(
              MIXERLINE_COMPONENTTYPE_SRC_WAVEOUT,      // class specific
              MIXERCONTROL_CONTROLTYPE_VOLUME,
              ulDetails, uniform))
     ITHROWMMERROR(lastError(),"mixerDetails");

  return *this;
}

/*------------------------------------------------------------------------------
| IMMConfigurableAudio::saveDeviceSettings                                                |
|                                                                              |
|                                                                              |
------------------------------------------------------------------------------*/
IMMConfigurableAudio& IMMConfigurableAudio::saveDeviceSettings()
{
  IMODTRACE_DEVELOP("IMMConfigurableAudio::saveDeviceSettings");
  Inherited::saveDeviceSettings();
  return *this;
}

/*------------------------------------------------------------------------------
| IMMConfigurableAudio::restoreDeviceSettings                                             |
|                                                                              |
|                                                                              |
------------------------------------------------------------------------------*/
IMMConfigurableAudio& IMMConfigurableAudio::restoreDeviceSettings(bool newRecordMode)
{
  IMODTRACE_DEVELOP("IMMConfigurableAudio::restoreDeviceSettings");
  Inherited::restoreDeviceSettings();
  return *this;
}

#endif
