// Revision: 24 1.6.1.4 source/dde/iddeevt.hpp, dde, ioc.v400, 001006 
#ifndef _IDDEEVT_
#define _IDDEEVT_
/*******************************************************************************
* FILE NAME: iddeevt.hpp                                                       *
*                                                                              *
* DESCRIPTION:                                                                 *
*   Declaration of the classes:                                                *
*     IDDEEvent                                                                *
*     IDDEAcknowledgeEvent                                                     *
*     IDDESetAcknowledgeInfoEvent                                              *
*     IDDEClientAcknowledgeEvent                                               *
*     IDDEServerAcknowledgeEvent                                               *
*     IDDEAcknowledgePokeEvent                                                 *
*     IDDEAcknowledgeExecuteEvent                                              *
*     IDDEDataEvent                                                            *
*     IDDEClientHotLinkEvent                                                   *
*     IDDERequestDataEvent                                                     *
*     IDDEPokeEvent                                                            *
*     IDDEServerHotLinkEvent                                                   *
*     IDDEExecuteEvent                                                         *
*     IDDEEndEvent                                                             *
*     IDDEClientEndEvent                                                       *
*     IDDEBeginEvent                                                           *
*                                                                              *
* COPYRIGHT:                                                                   *
*   IBM Open Class Library                                                     *
*   Licensed Material - Property of IBM                                        *
*   (C) Copyright IBM Corp. 1992, 1997  All Rights Reserved                    *
*                                                                              *
*******************************************************************************/
#include <ibase.hpp>

#ifdef IC_PMWIN

#include <istring.hpp>
#include <ievent.hpp>
#include <iddepl.hpp>

#if __IBMCPP__ >= 400
#pragma namemangling(compat)
#endif

class IDDEClientConversation;
class IDDETopicServer;
class IDDEEventData;

#pragma enum(4)
#pragma pack(push,4)

class IDDEEvent : public IEvent {
typedef IEvent
  Inherited;
public:
/*------------------------------- Constructors -------------------------------*/
  IDDEEvent ( const IEvent&    ddeEvent );
  IDDEEvent ( const IDDEEvent& ddeEvent );

 ~IDDEEvent ( );

/*------------------------------- operators    -------------------------------*/
  IDDEEvent& operator=( const IDDEEvent& ddeEvent );    // 28569

/*----------------------------- Event Attributes -----------------------------*/
IString
  item   ( ) const,
  format ( ) const;

protected:
/*------------------------------ Implementation ------------------------------*/
IDDEEvent
 &setStatus ( unsigned short status ),
 &setBuffer ( IString        dataBuffer );

unsigned short
  status ( ) const;

IString
  buffer ( ) const;

private:
/*--------------------------------- Private ----------------------------------*/
friend class IDDEClientConversation;
friend class IDDETopicServer;

IDDEEvent
 &setFormat ( IString format );

// new private members for Win32
#ifdef IC_WIN
void
  loadItem   ( ),
  loadFormat ( ),
  loadStatus ( ),
  loadBuffer ( );
#endif

unsigned short
  usClStatus;
IString
  strClItem,
  strClFormat,
  strClData;

IDDEEventData
 *fDDEEventData;
}; // IDDEEvent

class IDDEAcknowledgeEvent : public IDDEEvent {
typedef IDDEEvent
  Inherited;
public:
/*------------------------------- Constructors -------------------------------*/
  IDDEAcknowledgeEvent ( const IEvent& ddeEvent );

 ~IDDEAcknowledgeEvent ( );

/*----------------------------- Event Attributes -----------------------------*/
bool
  isApplicationBusy   ( ) const,
  isAckPositive       ( ) const,
  isMessageUnderstood ( ) const;

unsigned char
  applicationSpecificData ( ) const;

protected:
/*----------------------------- Transaction Type -----------------------------*/
unsigned short
  transactionType ( ) const;

private:
/*--------------------------------- Private ----------------------------------*/
friend class IDDEClientConversation;
friend class IDDETopicServer;

}; // IDDEAcknowledgeEvent

class IDDESetAcknowledgeInfoEvent : public IDDEEvent {
typedef IDDEEvent
  Inherited;
public:
/*------------------------------- Constructors -------------------------------*/
  IDDESetAcknowledgeInfoEvent ( const IEvent&                      ddeEvent );
  IDDESetAcknowledgeInfoEvent ( const IDDESetAcknowledgeInfoEvent& ddeEvent );

 ~IDDESetAcknowledgeInfoEvent ( );

/*----------------------------- Event Attributes -----------------------------*/
IDDESetAcknowledgeInfoEvent
 &setApplicationBusy         ( ),
 &setMessageNotUnderstood    ( ),
 &setApplicationSpecificData ( unsigned char applicationData );

}; // IDDESetAcknowledgeInfoEvent

class IDDEClientAcknowledgeEvent : public IDDEAcknowledgeEvent {
typedef IDDEAcknowledgeEvent
  Inherited;
public:
/*------------------------------- Constructors -------------------------------*/
  IDDEClientAcknowledgeEvent ( const IEvent& ddeEvent );

 ~IDDEClientAcknowledgeEvent ( );

/*----------------------------- Event Attributes -----------------------------*/
bool
  isAckToRequestData  ( ) const,
  isAckToBeginHotLink ( ) const,
  isAckToEndHotLink   ( ) const;

}; // IDDEClientAcknowledgeEvent

class IDDEServerAcknowledgeEvent : public IDDEAcknowledgeEvent {
typedef IDDEAcknowledgeEvent
  Inherited;
public:
/*------------------------------- Constructors -------------------------------*/
  IDDEServerAcknowledgeEvent ( const IEvent& ddeEvent );

 ~IDDEServerAcknowledgeEvent ( );

/*----------------------------- Event Attributes -----------------------------*/
bool
  isAckToHotLinkUpdate ( ) const;

IString
  data ( ) const;

}; // IDDEServerAcknowledgeEvent

class IDDEAcknowledgePokeEvent : public IDDEAcknowledgeEvent {
typedef IDDEAcknowledgeEvent
  Inherited;
public:
/*------------------------------- Constructors -------------------------------*/
  IDDEAcknowledgePokeEvent ( const IEvent& ddeEvent );

 ~IDDEAcknowledgePokeEvent ( );

/*-------------------------------- Poked Data --------------------------------*/
IString
  pokedData ( ) const;

}; // IDDEAcknowledgePokeEvent

class IDDEAcknowledgeExecuteEvent : public IDDEAcknowledgeEvent {
typedef IDDEAcknowledgeEvent
  Inherited;
public:
/*------------------------------- Constructors -------------------------------*/
  IDDEAcknowledgeExecuteEvent ( const IEvent& ddeEvent );

 ~IDDEAcknowledgeExecuteEvent ( );

/*------------------------------ Command String ------------------------------*/
IString
  commands ( ) const;

}; // IDDEAcknowledgeExecuteEvent

class IDDEDataEvent : public IDDESetAcknowledgeInfoEvent {
typedef IDDESetAcknowledgeInfoEvent
  Inherited;
public:
/*------------------------------- Constructors -------------------------------*/
  IDDEDataEvent ( const IEvent& ddeEvent );

 ~IDDEDataEvent ( );

/*----------------------------- Event Attributes -----------------------------*/
IString
  data ( ) const;

bool
  isAckRequested    ( ) const,
  isDataFromHotLink ( ) const;

}; // IDDEDataEvent

class IDDEClientHotLinkEvent : public IDDESetAcknowledgeInfoEvent {
typedef IDDESetAcknowledgeInfoEvent
  Inherited;
public:
/*------------------------------- Constructors -------------------------------*/
  IDDEClientHotLinkEvent ( const IEvent&                 ddeEvent );
  IDDEClientHotLinkEvent ( const IDDEClientHotLinkEvent& ddeEvent );

 ~IDDEClientHotLinkEvent ( );

/*----------------------------- Event Attributes -----------------------------*/
bool
  isAckRequested  ( ) const,
  isDataRequested ( ) const;

}; // IDDEClientHotLinkEvent

class IDDERequestDataEvent : public IDDESetAcknowledgeInfoEvent {
typedef IDDESetAcknowledgeInfoEvent
  Inherited;
public:
/*------------------------------- Constructors -------------------------------*/
  IDDERequestDataEvent ( const IEvent& ddeEvent );

 ~IDDERequestDataEvent ( );

/*----------------------------- Event Attributes -----------------------------*/
IDDERequestDataEvent
 &requestAck ( ),
 &setData    ( const char*   dataString ),
 &setData    ( const void*   dataBuffer,
               unsigned long dataLength );

}; // IDDERequestDataEvent

class IDDEPokeEvent : public IDDESetAcknowledgeInfoEvent {
typedef IDDESetAcknowledgeInfoEvent
  Inherited;
public:
/*------------------------------- Constructors -------------------------------*/
  IDDEPokeEvent ( const IEvent& ddeEvent );

 ~IDDEPokeEvent ( );

/*-------------------------------- Poked Data --------------------------------*/
IString
  pokedData ( ) const;

}; // IDDEPokeEvent

class IDDEExecuteEvent : public IDDESetAcknowledgeInfoEvent {
typedef IDDESetAcknowledgeInfoEvent
  Inherited;
public:
/*------------------------------- Constructors -------------------------------*/
  IDDEExecuteEvent ( const IEvent& ddeEvent );

 ~IDDEExecuteEvent ( );

/*------------------------------ Command String ------------------------------*/
IString
  commands ( ) const;

}; // IDDEExecuteEvent

class IDDEServerHotLinkEvent : public IDDESetAcknowledgeInfoEvent {
typedef IDDESetAcknowledgeInfoEvent
  Inherited;
public:
/*------------------------------- Constructors -------------------------------*/
  IDDEServerHotLinkEvent ( const IEvent& ddeEvent );

 ~IDDEServerHotLinkEvent ( );

/*----------------------------- Event Attributes -----------------------------*/
bool
  isPacingRequested ( ) const,
  isDataRequested   ( ) const;

}; // IDDEServerHotLinkEvent

class IDDEEndEvent : public IEvent {
typedef IEvent
  Inherited;
public:
/*---------------------------- Termination Source ----------------------------*/
enum Source { client, server, error };

Source
  sourceOfEnd ( ) const;

/*------------------------------- Constructors -------------------------------*/
  IDDEEndEvent ( const IEvent& ddeEvent,
                 Source        endSource );

 ~IDDEEndEvent ( );

private:
/*--------------------------------- Private ----------------------------------*/
Source
  sourceCl;

}; // IDDEEndEvent

class IDDEClientEndEvent : public IDDEEndEvent {
typedef IDDEEndEvent
  Inherited;
public:
/*------------------------------- Constructors -------------------------------*/
  IDDEClientEndEvent ( const IEvent&  ddeEvent,
                       Source         endSource,
                       IString        application,
                       IString        topic );

 ~IDDEClientEndEvent ( );

/*----------------------------- Event Attributes -----------------------------*/
IString
  application ( ) const,
  topic       ( ) const;

private:
/*--------------------------------- Private ----------------------------------*/
IString
  strClApp,
  strClTopic;

}; // IDDEClientEndEvent

class IDDEBeginEvent : public IEvent {
typedef IEvent
  Inherited;
public:
/*------------------------------- Constructors -------------------------------*/
  IDDEBeginEvent ( const IEvent& ddeBeginEvent );

 ~IDDEBeginEvent ( );

/*----------------------------- Event Attributes -----------------------------*/
IString
  application ( ) const,
  topic       ( ) const;

IDDEBeginEvent
 &setCaseSensitive ( bool caseSensitive );

private:
/*----------------------------- Hidden Functions -----------------------------*/
  IDDEBeginEvent ( const IDDEBeginEvent& event );
IDDEBeginEvent&
  operator=      ( const IDDEBeginEvent& event );

/*--------------------------------- Private ----------------------------------*/
friend class IDDEClientConversation;
friend class IDDETopicServer;

bool
  isCaseSensitive ( ) const;

IString
  strClApp,
  strClTopic;
bool
  bClCaseSens;

}; // IDDEBeginEvent

#pragma pack(pop)
#pragma enum(pop)

#if __IBMCPP__ >= 400
#pragma namemangling()
#endif

#include <iddeevt.inl>

#endif /* IC_PMWIN  */

#endif /* _IDDEEVT_ */
