// Revision: 23 1.3.1.5 source/dde/iddeevt.cpp, dde, ioc.v400, 001006 
/*******************************************************************************
* FILE NAME: iddeevt.cpp                                                       *
*                                                                              *
* DESCRIPTION:                                                                 *
*   Definition of the class(es):                                               *
*     IDDEEvent                   - Base DDE event class.                      *
*     IDDEAcknowledgeEvent        - Base DDE acknowledgement class.            *
*     IDDESetAcknowledgeInfoEvent - Base class for all events that need to set *
*                                   acknowledgement information.               *
*     IDDEClientAcknowledgeEvent  - Information for acknowledgements from a    *
*                                   server to requestData(), beginHotLink()    *
*                                   and endHotLink() requests.                 *
*     IDDEServerAcknowledgeEvent  - Information for acknowledgements from a    *
*                                   client.                                    *
*     IDDEAcknowledgePokeEvent    - Information for acknowledgements from a    *
*                                   server to pokeData() requests.             *
*     IDDEAcknowledgeExecuteEvent - Information for acknowledgements from a    *
*                                   server to executeCommands() requests.      *
*     IDDEDataEvent               - Information and data from a server in      *
*                                   response to requestData() requests and as  *
*                                   a result of beginHotLink() requests.       *
*     IDDEClientHotLinkEvent      - Information from a server as a result of   *
*                                   beginHotLink() requests.                   *
*     IDDERequestDataEvent        - Information for requestData() requests     *
*                                   from a client.                             *
*     IDDEPokeEvent               - Information for pokeData() requests from   *
*                                   a client.                                  *
*     IDDEServerHotLinkEvent      - Information for beginHotLink() requests    *
*                                   from a client.                             *
*     IDDEExecuteEvent            - Information for executeCommands() requests *
*                                   from a client.                             *
*     IDDEEndEvent                - Base DDE end conversation event class.     *
*     IDDEClientEndEvent          - Information for a client about the ending  *
*                                   of a conversation.                         *
*     IDDEBeginEvent              - Information for a server about             *
*                                   beginConversation() requests.              *
*                                                                              *
* COPYRIGHT:                                                                   *
*   IBM Open Class Library                                                     *
*   (C) Copyright International Business Machines Corporation 1992, 1997       *
*   Licensed Material - Program-Property of IBM - All Rights Reserved.         *
*   US Government Users Restricted Rights - Use, duplication, or disclosure    *
*   restricted by GSA ADP Schedule Contract with IBM Corp.                     *
*                                                                              *
*******************************************************************************/
extern "C"
{
   #define INCL_WINDDE
   #include <iwindefs.h>
   #ifdef IC_WIN
      #include <dde.h>            // for Win32 DDE definition
   #endif
}

#include <iddeevt.hpp>

#ifdef IC_PMWIN


#include <iddeinfo.hpp>
#include <itrace.hpp>
#ifdef IC_WIN
#include <iddecomm.hpp>
#include <iexcept.hpp>
#endif

// Segment definitions
#ifdef IC_PAGETUNE
  #define _IDDEEVT_CPP_
  #include <ipagetun.h>
#endif

/*------------------------------------------------------------------------------
| IDDEEventData::IDDEEventData                                                         |
------------------------------------------------------------------------------*/
#ifdef IC_WIN
class IDDEEventData
{
public:
  // TTD
  IDDEEventData() ;                     // 28569
  ~IDDEEventData() {} ;

  LPARAM
    lParam;

  UINT
    uLow,
    uHigh,
    uDDEMsg;
};

IDDEEventData::IDDEEventData()          // 28569
                 : uLow(0),             // 28569
                   uHigh(0),            // 28569
                   uDDEMsg(0),          // 28569
                   lParam(0)            // 28569
{                                       // 28569
} // IDDEEventData                      // 28569
#endif  /* IC_WIN */

/*------------------------------------------------------------------------------
| IDDEEvent::IDDEEvent                                                         |
------------------------------------------------------------------------------*/
IDDEEvent :: IDDEEvent ( const IEvent& ddeEvent )
                : IEvent(ddeEvent)
{
   IMODTRACE_DEVELOP("IDDEEvent::ctor");

#ifdef IC_PM
   PDDESTRUCT pddes = (_DDESTRUCT*)(void*)(ddeEvent.parameter2());
   usClStatus = pddes->fsStatus;
   strClItem = (char*)DDES_PSZITEMNAME(pddes);
   if (pddes->usFormat != 0)
      strClFormat = IDDEInfo__stringFromAtom(pddes->usFormat);
   else
      strClFormat = "";
   if (pddes->cbData != 0)
      strClData = IString( (void *)DDES_PABDATA(pddes), pddes->cbData );
   else
      strClData = "";
#endif  /* IC_PM */

#ifdef IC_WIN
   // create the private data class
   fDDEEventData = new IDDEEventData( );

   // extract the parameter from the event
   fDDEEventData->uDDEMsg = (UINT)ddeEvent.eventId();
   fDDEEventData->lParam  = (LPARAM)ddeEvent.parameter2().asUnsignedLong();
   ITRACE_DEVELOP( "DBug: DDEEvent CTOR eventId=" + IString( fDDEEventData->uDDEMsg )
                 + ", lParam=" + IString( fDDEEventData->lParam ));

   // initialize the private data
   usClStatus  = 0;
   strClItem   = "";
   strClFormat = "";
   strClData   = "";

   //decompose the lParam for messages using packed data
   switch ( fDDEEventData->uDDEMsg )
   {
      case WM_DDE_ACK:
      case WM_DDE_ADVISE:
      case WM_DDE_DATA:
      case WM_DDE_POKE:
      {
#ifdef  DEBUG
         struct myFoo { UINT low; UINT high; };
         struct myFoo *pFoo = (struct myFoo *)GlobalLock( (HGLOBAL)fDDEEventData->lParam );
         if ( pFoo != NULL )
         {
            ITRACE_DEVELOP( "DBug: DDEEvt CTOR low=" + IString(pFoo->low)
                          + ", high=" + IString(pFoo->high));
            GlobalUnlock( (HGLOBAL)fDDEEventData->lParam );
         }
         else
            ITRACE_DEVELOP( "DBug: DDEEvent CTOR couldn't lock the packed handle" );
#endif
         UnpackDDElParam( fDDEEventData->uDDEMsg
                        , fDDEEventData->lParam
                        , &fDDEEventData->uLow
                        , &fDDEEventData->uHigh );

         ITRACE_DEVELOP( "DBug: DDEEvent unpacklParam, uLow=" + IString( fDDEEventData->uLow )
                       + ", uHigh=" + IString( fDDEEventData->uHigh ));
      }
      break;

      default:
        fDDEEventData->uLow = fDDEEventData->uHigh = 0;
        break;
   } /* endswitch */

   // assign the initial value based on the message Id
   //   WM_DDE_INITIATE  has no affect to the IDDEEvent class
   //   WM_DDE_TERMINATE has no affect to the IDDEEvent class
   //   WM_DDE_ACK       has to be handled specially by creator after ctor,
   //                    because in Windows, ack contains different values
   //                    for different reply
   switch ( fDDEEventData->uDDEMsg )
   {
      case WM_DDE_ADVISE:
        loadItem();
        loadFormat();
        loadStatus();
        break;
      case WM_DDE_UNADVISE:
        loadItem();
//mkb        loadFormat();
        break;
      case WM_DDE_DATA:
      case WM_DDE_POKE:
        loadItem();
        loadFormat();
        loadStatus();
        loadBuffer();
        break;
      case WM_DDE_REQUEST:
        loadItem();
        loadFormat();
        break;
      case WM_DDE_EXECUTE:
        loadBuffer();
        break;
   }
#endif  /* IC_WIN */

}

/*------------------------------------------------------------------------------
| IDDEEvent::IDDEEvent                                                         |
------------------------------------------------------------------------------*/
IDDEEvent :: IDDEEvent  ( const IDDEEvent& ddeEvent )
                : IEvent(ddeEvent)
                , usClStatus ( ddeEvent.usClStatus  )    // 28569
                , strClItem  ( ddeEvent.strClItem   )    // 28569
                , strClFormat( ddeEvent.strClFormat )    // 28569
                , strClData  ( ddeEvent.strClData   )    // 28569
#ifdef IC_WIN                                            // 28569
                , fDDEEventData( new IDDEEventData() )   // 28569
#endif                                                   // 28569
{
#ifdef IC_WIN                                               // 28569
   // defect: 28569
   // - added code to handle the class's data members.  This code
   //   is required to do a correct copy.  Without it we get a trap
   //   in the destructor when we try to delete fDDEEventData.

   // NOTE:  bitwise assignment happens here which is OK since
   //        the only members in FDDEEventData are integers.
   *fDDEEventData = *(ddeEvent.fDDEEventData);              // 28569
#endif                                                      // 28569
}

/*------------------------------------------------------------------------------
| IDDEEvent::operator=( const IDDEEvent& ddeEvent )                            |
| Defect: 28569 - added this method                                            |
------------------------------------------------------------------------------*/
IDDEEvent& IDDEEvent :: operator= ( const IDDEEvent& ddeEvent )     // 28569
{                                                                   // 28569
   if( this == &ddeEvent )                                          // 28569
        return *this;                                               // 28569
                                                                    // 28569
   // make a copy of the private data and copy over the value       // 28569
#ifdef IC_WIN                                                       // 28569
   delete          fDDEEventData;       // remove old one first.    // 28569
                                                                    // 28569
   fDDEEventData = new IDDEEventData( );                            // 28569
   *fDDEEventData = *(ddeEvent.fDDEEventData);                      // 28569
#endif                                                              // 28569
                                                                    // 28569
   usClStatus  = ddeEvent.usClStatus ;                              // 28569
   strClItem   = ddeEvent.strClItem  ;                              // 28569
   strClFormat = ddeEvent.strClFormat;                              // 28569
   strClData   = ddeEvent.strClData  ;                              // 28569
                                                                    // 28569
   return *this;                                                    // 28569
}                                                                   // 28569

/*------------------------------------------------------------------------------
| IDDEEvent::~IDDEEvent                                                        |
------------------------------------------------------------------------------*/
IDDEEvent :: ~IDDEEvent ( )
{
   ;
#ifdef IC_WIN
   // delete the private data class
   delete fDDEEventData;
#endif
}

#ifdef IC_WIN
/*------------------------------------------------------------------------------
| IDDEEvent::loadItem                                                          |
------------------------------------------------------------------------------*/
void IDDEEvent :: loadItem ( )
{
   switch ( fDDEEventData->uDDEMsg )
   {
      case WM_DDE_REQUEST:
      case WM_DDE_UNADVISE:
         if ( (strClItem == "") && (HIWORD(fDDEEventData->lParam) != 0) )
         {
            strClItem = IDDEInfo__stringFromAtom(
                           (unsigned long)HIWORD(fDDEEventData->lParam));
         }
         break;
      case WM_DDE_ACK:
      case WM_DDE_ADVISE:
      case WM_DDE_DATA:
      case WM_DDE_POKE:
         if ( (strClItem == "") && ( fDDEEventData->uHigh != 0) )
         {
            ATOM aItem = fDDEEventData->uHigh;
            strClItem  = IDDEInfo__stringFromAtom( (unsigned long)aItem );
         }
         break;
      case WM_DDE_EXECUTE:
         strClItem = "";
         break;
   } /* endswitch */
}

/*------------------------------------------------------------------------------
| IDDEEvent::loadFormat                                                        |
------------------------------------------------------------------------------*/
void IDDEEvent :: loadFormat ( )
{
   IMODTRACE_DEVELOP("IDDEInfo::loadFormat") ;

   unsigned short usFormat;

   if ( strClFormat == "" )
   {
      switch ( fDDEEventData->uDDEMsg )
      {
         case WM_DDE_ADVISE:
            {
               HGLOBAL hDdeAdvise = (void *)fDDEEventData->uLow;
               DDEADVISE *lpDdeAdvise = (DDEADVISE *)GlobalLock( hDdeAdvise );
               if ( lpDdeAdvise != NULL )
               {
                  usFormat = lpDdeAdvise->cfFormat ;
                  GlobalUnlock( hDdeAdvise );
               }
               else
               {
               ITHROWSYSTEMERROR( GetLastError(), "GlobalLock",
               IBaseErrorInfo::accessError, IException::recoverable );
               }
            }
            break ;

         case WM_DDE_DATA:
            {
               // 28265
               // if we got a WM_DDE_DATA, then uLow could be zero if
               // we are responding to a warm link.
               // If zero, then simply return with no format information
               if( fDDEEventData->uLow == 0 )                   // 28265
                return;                                         // 28265

               HGLOBAL hDdeData = (void *)fDDEEventData->uLow;
               DDEDATA *lpDdeData = (DDEDATA *)GlobalLock( hDdeData );
               if ( lpDdeData != NULL )
               {
                  usFormat = lpDdeData->cfFormat ;
                  GlobalUnlock( hDdeData );
               }
               else
               {
               ITHROWSYSTEMERROR( GetLastError(), "GlobalLock",
               IBaseErrorInfo::accessError, IException::recoverable );
               }
            }
            break ;

         case WM_DDE_POKE:
            {
               HGLOBAL hDdePoke = (void *)fDDEEventData->uLow;
               DDEPOKE *lpDdePoke = (DDEPOKE *)GlobalLock( hDdePoke );
               if ( lpDdePoke != NULL )
               {
                  usFormat = lpDdePoke->cfFormat ;
                  GlobalUnlock( hDdePoke );
               }
               else
               {
                  ITHROWSYSTEMERROR( GetLastError(), "GlobalLock",
                                     IBaseErrorInfo::accessError, IException::recoverable );
               }
            }
            break;
         case WM_DDE_REQUEST:
         case WM_DDE_UNADVISE:
            usFormat = LOWORD( fDDEEventData->lParam );
            break;
         default:
            usFormat = CF_TEXT ;

      } /* switch uDDEMsg */

      switch ( usFormat )
      {
         case CF_TEXT:
            strClFormat = IDDE::textFormat;
            break;
         case CF_BITMAP:
            strClFormat = IDDE::bitmapFormat;
            break;
         case CF_METAFILEPICT:
            strClFormat = IDDE::metafilePictureFormat;
            break;
         case CF_SYLK:
            strClFormat = IDDE::sylkFormat;
            break;
         case CF_DIF:
            strClFormat = IDDE::difFormat;
            break;
         case CF_TIFF:
            strClFormat = IDDE::tiffFormat;
            break;
         case CF_OEMTEXT:
            strClFormat = IDDE::oemTextFormat;
            break;
         case CF_DIB:
            strClFormat = IDDE::dibFormat;
            break;
         case CF_PALETTE:
            strClFormat = IDDE::paletteFormat;
            break;
         case CF_ENHMETAFILE:
            strClFormat = IDDE::metafileFormat;
            break;
         case CF_DSPTEXT:
            strClFormat = IDDE::displayTextFormat;
            break;
         case CF_DSPBITMAP:
            strClFormat = IDDE::displayBitmapFormat;
            break;
         case CF_DSPENHMETAFILE:
            strClFormat = IDDE::displayMetafileFormat;
            break;
         case CF_DSPMETAFILEPICT:
            strClFormat = IDDE::displayMetafilePictureFormat;
            break;
         case CF_PENDATA:
            strClFormat = "CF_PENDATA" ;
            break;
         case CF_RIFF:
            strClFormat = "CF_RIFF" ;
            break;
         case CF_WAVE:
            strClFormat = "CF_WAVE" ;
            break;
         case CF_UNICODETEXT:
            strClFormat = "CF_UNICODETEXT" ;
            break;
         case CF_HDROP:
            strClFormat = "CF_HDROP" ;
            break;
         case CF_LOCALE:
            strClFormat = "CF_LOCALE" ;
            break;
         case CF_OWNERDISPLAY:
            strClFormat = "CF_OWNERDISPLAY" ;
            break;
         case CF_GDIOBJFIRST:
            strClFormat = "CF_GDIOBJFIRST" ;
            break;
         case CF_GDIOBJLAST:
            strClFormat = "CF_GDIOBJLAST" ;
            break;
         case CF_PRIVATEFIRST:
            strClFormat = "CF_PRIVATEFIRST" ;
            break;
         case CF_PRIVATELAST:
            strClFormat = "CF_PRIVATELAST" ;
            break;
         default:
            {
               char cFormatNameBuf[256] ;
               memset(cFormatNameBuf, 0, sizeof(cFormatNameBuf)) ;
               if (GetClipboardFormatName(usFormat, cFormatNameBuf, 256))
                  strClFormat = cFormatNameBuf ;
               else
                  ITHROWSYSTEMERROR( GetLastError(), "GetClipboardFormatName",
                                     IBaseErrorInfo::accessError, IException::recoverable );

            }
      }
   }
}

/*------------------------------------------------------------------------------
| IDDEEvent::loadStatus                                                        |
------------------------------------------------------------------------------*/
void IDDEEvent :: loadStatus ( )
{
   IMODTRACE_DEVELOP("IDDEEvent::loadStatus") ;
   if ( (usClStatus == 0) && (fDDEEventData->uLow != 0) )
   {
      switch ( fDDEEventData->uDDEMsg )
      {
         case WM_DDE_ACK:
         {
            DDEACK *lpDdeAck = (DDEACK *) &(fDDEEventData->uLow) ; // TTD

            ITRACE_DEVELOP(IString("::loadStatus ack is ") +
                           IString(lpDdeAck->fAck) ) ;

            lpDdeAck->fAck  ? (usClStatus |= IDDEInfo::acknowledge)
                            : (usClStatus |= IDDEInfo::notProcessed);
            lpDdeAck->fBusy ? (usClStatus |= IDDEInfo::busy)
                            : (usClStatus |= 0L);
            // get the app specific RC
            unsigned short usTmp = lpDdeAck->bAppReturnCode;
            usClStatus |= usTmp << 8;

            break;
         }
         case WM_DDE_ADVISE:
         {
            HGLOBAL hDdeAdvise = (void *)fDDEEventData->uLow;
            DDEADVISE FAR *lpDdeAdvise = (DDEADVISE FAR *)GlobalLock( hDdeAdvise );
            if ( lpDdeAdvise != NULL )
            {
               lpDdeAdvise->fAckReq   ? (usClStatus |= IDDEInfo::responseFromReq)
                                      : (usClStatus |= 0L);
               lpDdeAdvise->fDeferUpd ? (usClStatus |= IDDEInfo::noData)
                                      : (usClStatus |= 0L);
               GlobalUnlock( hDdeAdvise );
            }
            else
            {
               ITHROWSYSTEMERROR( GetLastError(), "GlobalLock",
                                  IBaseErrorInfo::accessError, IException::recoverable );
            }
            break;
         }
         case WM_DDE_DATA:
         {
            ITRACE_DEVELOP("ttd - in data") ;
            HGLOBAL hDdeData = (void *)fDDEEventData->uLow;
            DDEDATA FAR *lpDdeData = (DDEDATA FAR *)GlobalLock( hDdeData );
            if ( lpDdeData != NULL )
            {
               ITRACE_DEVELOP("ttd- fackreq = " + IString(lpDdeData->fAckReq)) ;
               lpDdeData->fAckReq   ? (usClStatus |= IDDEInfo::responseFromReq)
                                    : (usClStatus |= 0L);
               lpDdeData->fRelease  ? (usClStatus |= IDDEInfo::releaseData)
                                    : (usClStatus |= 0L);
               lpDdeData->fResponse ? (usClStatus |= IDDEInfo::acknowledgeRequested)
                                    : (usClStatus |= 0L);
               GlobalUnlock( hDdeData );
            }
            else
            {
               ITHROWSYSTEMERROR( GetLastError(), "GlobalLock",
                                  IBaseErrorInfo::accessError, IException::recoverable );
            }
            break;
         }
         case WM_DDE_POKE:
         {
            HGLOBAL hDdePoke = (void *)fDDEEventData->uLow;
            DDEPOKE FAR *lpDdePoke = (DDEPOKE FAR *)GlobalLock( hDdePoke );
            if ( lpDdePoke != NULL )
            {
               lpDdePoke->fRelease ? (usClStatus |= IDDEInfo::releaseData)
                                   : (usClStatus |= 0L);
               GlobalUnlock( hDdePoke );
            }
            else
            {
               ITHROWSYSTEMERROR( GetLastError(), "GlobalLock",
                                  IBaseErrorInfo::accessError, IException::recoverable );
            }
            break;
         }
      }
   }
}

/*------------------------------------------------------------------------------
| IDDEEvent::loadBuffer                                                        |
------------------------------------------------------------------------------*/
void IDDEEvent :: loadBuffer ( )
{
   if ( strClData == "" )
   {
      switch ( fDDEEventData->uDDEMsg )
      {
         case WM_DDE_DATA:
            if ( fDDEEventData->uLow != 0 )
            {
               HGLOBAL hDdeData = (void *)fDDEEventData->uLow;
               ITRACE_DEVELOP( "DBug: Data hDdeData=" + IString((unsigned long)hDdeData ));
               DDEDATA FAR *lpDdeData = (DDEDATA FAR *)GlobalLock( hDdeData );
               if ( lpDdeData != NULL )
               {
                  ITRACE_DEVELOP("shared mem @ 0x"
                  + IString( (unsigned long)lpDdeData).d2x().upperCase()
                  + "=" + IString((char*)lpDdeData->Value)) ;
                  strClData = IString( (char FAR *)lpDdeData->Value );
                  GlobalUnlock( hDdeData );
               }
               else
               {
                  ITHROWSYSTEMERROR( GetLastError(), "GlobalLock",
                                     IBaseErrorInfo::accessError, IException::recoverable );
               }
            }
            break;

         case WM_DDE_POKE:
            if ( fDDEEventData->uLow != 0 )
            {
               HGLOBAL hDdePoke = (void *)fDDEEventData->uLow;
               ITRACE_DEVELOP( "DBug: Poke hDdePoke=" + IString((unsigned long)hDdePoke ));
               DDEPOKE FAR *lpDdePoke = (DDEPOKE FAR *)GlobalLock( hDdePoke );
               if ( lpDdePoke != NULL )
               {
                  ITRACE_DEVELOP("shared mem at " + IString((unsigned long)lpDdePoke)) ;
                  strClData = IString( (char FAR *)lpDdePoke->Value );
                  GlobalUnlock( hDdePoke );
               }
               else
               {
                  ITHROWSYSTEMERROR( GetLastError(), "GlobalLock",
                                     IBaseErrorInfo::accessError, IException::recoverable );
               }
            }
            break;

         case WM_DDE_EXECUTE:
            if ( fDDEEventData->lParam != 0 )
            {
               HGLOBAL hCommands = (void *)fDDEEventData->lParam;
               ITRACE_DEVELOP( "DBug: Execute hCommand=" + IString((unsigned long)hCommands ));
               char FAR *lpCommands = (char FAR *)GlobalLock( hCommands );
               if ( lpCommands != NULL )
               {
                  ITRACE_DEVELOP("shared mem @ 0x"
                                + IString((unsigned long)lpCommands).d2x().upperCase()
                                + "=" + IString(lpCommands)) ;
                  strClData = IString( lpCommands );
                  GlobalUnlock( hCommands );
               }
               else
               {
                  ITHROWSYSTEMERROR( GetLastError(), "GlobalLock",
                                     IBaseErrorInfo::accessError, IException::recoverable );
               }
            }
            break;

         case WM_DDE_ACK:
            if ( fDDEEventData->uHigh != 0 )
            {
               HGLOBAL hCommands = (void *)fDDEEventData->uHigh;
               ITRACE_DEVELOP( "DBug: Ack hCommand=" + IString((unsigned long)hCommands ));
               char FAR *lpCommands = (char FAR *)GlobalLock( hCommands );
               if ( lpCommands != NULL )
               {
                  ITRACE_DEVELOP("shared mem @ 0x"
                                + IString((unsigned long)lpCommands).d2x().upperCase()
                                + "=" + IString(lpCommands)) ;
                  strClData = IString( lpCommands );
                  GlobalUnlock( hCommands );
               }
               else
               {
                  ITHROWSYSTEMERROR( GetLastError(), "GlobalLock",
                                     IBaseErrorInfo::accessError, IException::recoverable );
               }
            }
            break;
      }
   }
}
#endif  /* IC_WIN */

/*------------------------------------------------------------------------------
| IDDEAcknowledgeEvent::IDDEAcknowledgeEvent                                   |
------------------------------------------------------------------------------*/
IDDEAcknowledgeEvent :: IDDEAcknowledgeEvent ( const IEvent& ddeEvent )
                                    : IDDEEvent(ddeEvent)
{
   ;
}

/*------------------------------------------------------------------------------
| IDDEAcknowledgeEvent::~IDDEAcknowledgeEvent                                  |
------------------------------------------------------------------------------*/
IDDEAcknowledgeEvent :: ~IDDEAcknowledgeEvent ( )
{
   ;
}

/*------------------------------------------------------------------------------
| IDDEAcknowledgeEvent::isApplicationBusy                                      |
------------------------------------------------------------------------------*/
bool IDDEAcknowledgeEvent :: isApplicationBusy ( ) const
{
#ifdef IC_PM
   if (status() & DDE_FBUSY)
#endif
#ifdef IC_WIN
   if (status() & IDDEInfo::busy)
#endif
      return true;
   return false;
}

/*------------------------------------------------------------------------------
| IDDEAcknowledgeEvent::isAckPositive                                          |
------------------------------------------------------------------------------*/
bool IDDEAcknowledgeEvent :: isAckPositive ( ) const
{
#ifdef IC_PM
   if (status() & DDE_FACK)
#endif
#ifdef IC_WIN
   if (status() & IDDEInfo::acknowledge)
#endif
      return true;
   return false;
}

/*------------------------------------------------------------------------------
| IDDEAcknowledgeEvent::isMessageUnderstood                                    |
------------------------------------------------------------------------------*/
bool IDDEAcknowledgeEvent :: isMessageUnderstood ( ) const
{
#ifdef IC_PM
   if (status() & DDE_NOTPROCESSED)
#endif
#ifdef IC_WIN
   if (status() & IDDEInfo::notProcessed)
#endif
      return false;
   return true;
}

/*------------------------------------------------------------------------------
| IDDEAcknowledgeEvent::applicationSpecificData                                |
------------------------------------------------------------------------------*/
unsigned char IDDEAcknowledgeEvent :: applicationSpecificData ( ) const
{
   unsigned short usTemp = status();
#ifdef IC_PM
   usTemp = usTemp & DDE_FAPPSTATUS;
#endif
#ifdef IC_WIN
   usTemp = usTemp & IDDEInfo::applicationSpecific;
#endif
   usTemp = usTemp >> 8;
   unsigned char ucTemp = usTemp;
   return ucTemp;
}

/*------------------------------------------------------------------------------
| IDDESetAcknowledgeInfoEvent::IDDESetAcknowledgeInfoEvent                     |
------------------------------------------------------------------------------*/
IDDESetAcknowledgeInfoEvent :: IDDESetAcknowledgeInfoEvent (
                                  const IEvent& ddeEvent )
   : IDDEEvent(ddeEvent)
{
   ;
}

/*------------------------------------------------------------------------------
| IDDESetAcknowledgeInfoEvent::IDDESetAcknowledgeInfoEvent                     |
------------------------------------------------------------------------------*/
IDDESetAcknowledgeInfoEvent :: IDDESetAcknowledgeInfoEvent (
                                  const IDDESetAcknowledgeInfoEvent& ddeEvent )
   : IDDEEvent(ddeEvent)
{
   ;
}

/*------------------------------------------------------------------------------
| IDDESetAcknowledgeInfoEvent::~IDDESetAcknowledgeInfoEvent                    |
------------------------------------------------------------------------------*/
IDDESetAcknowledgeInfoEvent :: ~IDDESetAcknowledgeInfoEvent ( )
{
   ;
}

/*------------------------------------------------------------------------------
| IDDESetAcknowledgeInfoEvent::setApplicationSpecificData                      |
------------------------------------------------------------------------------*/
IDDESetAcknowledgeInfoEvent&
   IDDESetAcknowledgeInfoEvent :: setApplicationSpecificData (
                                     unsigned char appData)
{
   IMODTRACE_DEVELOP("IDDESetAckInfoEvent::setAppSpecificData");
   unsigned short usTemp = appData;
   unsigned short usTemp1 = status();
   usTemp = usTemp << 8;
   usTemp1 = usTemp1 & 0x00ff;
   usTemp = usTemp1 | usTemp;
   setStatus(usTemp);
   return *this;
}

/*------------------------------------------------------------------------------
| IDDESetAcknowledgeInfoEvent::setApplicationBusy                              |
------------------------------------------------------------------------------*/
IDDESetAcknowledgeInfoEvent&
   IDDESetAcknowledgeInfoEvent :: setApplicationBusy ( )
{
#ifdef IC_PM
   setStatus( status() | DDE_FBUSY);
#endif
#ifdef IC_WIN
   setStatus( status() | IDDEInfo::busy);
#endif
   return *this;
}

/*------------------------------------------------------------------------------
| IDDESetAcknowledgeInfoEvent::setMessageNotUnderstood                         |
------------------------------------------------------------------------------*/
IDDESetAcknowledgeInfoEvent&
   IDDESetAcknowledgeInfoEvent :: setMessageNotUnderstood ( )
{
#ifdef IC_PM
   setStatus( status() | DDE_NOTPROCESSED);
#endif
#ifdef IC_WIN
   setStatus( status() | IDDEInfo::notProcessed);
#endif
   return *this;
}

/*------------------------------------------------------------------------------
| IDDEClientAcknowledgeEvent::IDDEClientAcknowledgeEvent                       |
------------------------------------------------------------------------------*/
IDDEClientAcknowledgeEvent :: IDDEClientAcknowledgeEvent (
                                 const IEvent& ddeEvent )
   : IDDEAcknowledgeEvent(ddeEvent)
{
   ;
}

/*------------------------------------------------------------------------------
| IDDEClientAcknowledgeEvent::~IDDEClientAcknowledgeEvent                      |
------------------------------------------------------------------------------*/
IDDEClientAcknowledgeEvent :: ~IDDEClientAcknowledgeEvent ( )
{
   ;
}

/*------------------------------------------------------------------------------
| IDDEClientAcknowledgeEvent::isAckToRequestData                               |
------------------------------------------------------------------------------*/
bool IDDEClientAcknowledgeEvent :: isAckToRequestData ( ) const
{
   if (transactionType() == WM_DDE_REQUEST)
      return true;
   return false;
}

/*------------------------------------------------------------------------------
| IDDEClientAcknowledgeEvent::isAckToBeginHotLink                              |
------------------------------------------------------------------------------*/
bool IDDEClientAcknowledgeEvent :: isAckToBeginHotLink ( ) const
{
   if (transactionType() == WM_DDE_ADVISE)
      return true;
   return false;
}

/*------------------------------------------------------------------------------
| IDDEClientAcknowledgeEvent::isAckToEndHotLink                                |
------------------------------------------------------------------------------*/
bool IDDEClientAcknowledgeEvent :: isAckToEndHotLink ( ) const
{
   if (transactionType() == WM_DDE_UNADVISE)
      return true;
   return false;
}

/*------------------------------------------------------------------------------
| IDDEServerAcknowledgeEvent::IDDEServerAcknowledgeEvent                       |
------------------------------------------------------------------------------*/
IDDEServerAcknowledgeEvent :: IDDEServerAcknowledgeEvent (
                                 const IEvent& ddeEvent)
   : IDDEAcknowledgeEvent(ddeEvent)
{
   ;
}

/*------------------------------------------------------------------------------
| IDDEServerAcknowledgeEvent::~IDDEServerAcknowledgeEvent                      |
------------------------------------------------------------------------------*/
IDDEServerAcknowledgeEvent :: ~IDDEServerAcknowledgeEvent ( )
{
   ;
}

/*------------------------------------------------------------------------------
| IDDEServerAcknowledgeEvent::isAckToHotLinkUpdate                             |
------------------------------------------------------------------------------*/
bool IDDEServerAcknowledgeEvent :: isAckToHotLinkUpdate ( ) const
{
   if (transactionType() == WM_DDE_ADVISE)
      return true;
   return false;
}


/*------------------------------------------------------------------------------
| IDDEAcknowledgePokeEvent::IDDEAcknowledgePokeEvent                           |
------------------------------------------------------------------------------*/
IDDEAcknowledgePokeEvent :: IDDEAcknowledgePokeEvent ( const IEvent& ddeEvent )
                              : IDDEAcknowledgeEvent(ddeEvent)
{
   ;
}

/*------------------------------------------------------------------------------
| IDDEAcknowledgePokeEvent::~IDDEAcknowledgePokeEvent                          |
------------------------------------------------------------------------------*/
IDDEAcknowledgePokeEvent :: ~IDDEAcknowledgePokeEvent ( )
{
   ;
}

/*------------------------------------------------------------------------------
| IDDEAcknowledgeExecuteEvent::IDDEAcknowledgeExecuteEvent                     |
------------------------------------------------------------------------------*/
IDDEAcknowledgeExecuteEvent :: IDDEAcknowledgeExecuteEvent (
                                  const IEvent& ddeEvent )
                      : IDDEAcknowledgeEvent(ddeEvent)
{
   ;
}

/*------------------------------------------------------------------------------
| IDDEAcknowledgeExecuteEvent::~IDDEAcknowledgeExecuteEvent                    |
------------------------------------------------------------------------------*/
IDDEAcknowledgeExecuteEvent :: ~IDDEAcknowledgeExecuteEvent ( )
{
   ;
}

/*------------------------------------------------------------------------------
| IDDEDataEvent::IDDEDataEvent                                                 |
------------------------------------------------------------------------------*/
IDDEDataEvent :: IDDEDataEvent ( const IEvent& ddeEvent )
                         : IDDESetAcknowledgeInfoEvent(ddeEvent)
{
   ;
}

/*------------------------------------------------------------------------------
| IDDEDataEvent::~IDDEDataEvent                                                |
------------------------------------------------------------------------------*/
IDDEDataEvent :: ~IDDEDataEvent ( )
{
   ;
}

/*------------------------------------------------------------------------------
| IDDEDataEvent::isAckRequested                                                |
------------------------------------------------------------------------------*/
bool IDDEDataEvent :: isAckRequested ( ) const
{
#ifdef IC_PM
   if (status() & DDE_FACKREQ)
#endif
#ifdef IC_WIN
   if (status() & IDDEInfo::acknowledgeRequested)
#endif
      return true;
   return false;
}

/*------------------------------------------------------------------------------
| IDDEDataEvent::isDataFromHotLink                                             |
------------------------------------------------------------------------------*/
bool IDDEDataEvent :: isDataFromHotLink ( ) const
{
#ifdef IC_PM
   if (status() & DDE_FRESPONSE)
#endif
#ifdef IC_WIN
   if (status() & IDDEInfo::responseFromReq)
#endif
      return false;
   return true;
}

/*------------------------------------------------------------------------------
| IDDEClientHotLinkEvent::IDDEClientHotLinkEvent                               |
------------------------------------------------------------------------------*/
IDDEClientHotLinkEvent :: IDDEClientHotLinkEvent ( const IEvent& ddeEvent )
                              : IDDESetAcknowledgeInfoEvent(ddeEvent)
{
   ;
}

/*------------------------------------------------------------------------------
| IDDEClientHotLinkEvent::IDDEClientHotLinkEvent                               |
------------------------------------------------------------------------------*/
IDDEClientHotLinkEvent :: IDDEClientHotLinkEvent (
                                    const IDDEClientHotLinkEvent& ddeEvent )
                              : IDDESetAcknowledgeInfoEvent(ddeEvent)
{
   ;
}

/*------------------------------------------------------------------------------
| IDDEClientHotLinkEvent::~IDDEClientHotLinkEvent                              |
------------------------------------------------------------------------------*/
IDDEClientHotLinkEvent :: ~IDDEClientHotLinkEvent ( )
{
   ;
}

/*------------------------------------------------------------------------------
| IDDEClientHotLinkEvent::isAckRequested                                       |
------------------------------------------------------------------------------*/
bool IDDEClientHotLinkEvent :: isAckRequested ( ) const
{
#ifdef IC_PM
   if (status() & DDE_FACKREQ)
#endif
#ifdef IC_WIN
   if (status() & IDDEInfo::acknowledgeRequested)
#endif
      return true;
   return false;
}

/*------------------------------------------------------------------------------
| IDDEClientHotLinkEvent::isDataRequested                                      |
------------------------------------------------------------------------------*/
bool IDDEClientHotLinkEvent :: isDataRequested ( ) const
{
#ifdef IC_PM
   if (status() & DDE_FNODATA)
#endif
#ifdef IC_WIN
   if (status() & IDDEInfo::noData)
#endif
      return false;
   return true;
}

/*------------------------------------------------------------------------------
| IDDERequestDataEvent::IDDERequestDataEvent                                   |
------------------------------------------------------------------------------*/
IDDERequestDataEvent :: IDDERequestDataEvent  ( const IEvent& ddeEvent )
                             : IDDESetAcknowledgeInfoEvent(ddeEvent)
{
   ;
}

/*------------------------------------------------------------------------------
| IDDERequestDataEvent::~IDDERequestDataEvent                                  |
------------------------------------------------------------------------------*/
IDDERequestDataEvent :: ~IDDERequestDataEvent ( )
{
   ;
}

/*------------------------------------------------------------------------------
| IDDERequestDataEvent::setData                                                |
------------------------------------------------------------------------------*/
IDDERequestDataEvent& IDDERequestDataEvent :: setData ( const char* data )
{
   IString strTemp(data);
   setBuffer(strTemp);
   return *this;
}

/*------------------------------------------------------------------------------
| IDDERequestDataEvent::setData                                                |
------------------------------------------------------------------------------*/
IDDERequestDataEvent& IDDERequestDataEvent :: setData ( const void* data,
                                                      unsigned long dataLength )
{
   IString strTemp(data, dataLength);
   setBuffer(strTemp);
   return *this;
}

/*------------------------------------------------------------------------------
| IDDERequestDataEvent::requestAck                                             |
------------------------------------------------------------------------------*/
IDDERequestDataEvent& IDDERequestDataEvent :: requestAck ( )
{
#ifdef IC_PM
   setStatus( status() | DDE_FACKREQ);
#endif
#ifdef IC_WIN
   setStatus( status() | IDDEInfo::acknowledgeRequested );
#endif
   return *this;
}

/*------------------------------------------------------------------------------
| IDDEPokeEvent::IDDEPokeEvent                                                 |
------------------------------------------------------------------------------*/
IDDEPokeEvent :: IDDEPokeEvent  ( const IEvent& ddeEvent )
                        : IDDESetAcknowledgeInfoEvent(ddeEvent)
{
   ;
}

/*------------------------------------------------------------------------------
| IDDEPokeEvent::~IDDEPokeEvent                                                |
------------------------------------------------------------------------------*/
IDDEPokeEvent :: ~IDDEPokeEvent ( )
{
   ;
}

/*------------------------------------------------------------------------------
| IDDEExecuteEvent::IDDEExecuteEvent                                           |
------------------------------------------------------------------------------*/
IDDEExecuteEvent :: IDDEExecuteEvent  ( const IEvent& ddeEvent )
                             : IDDESetAcknowledgeInfoEvent(ddeEvent)
{
   ;
}

/*------------------------------------------------------------------------------
| IDDEExecuteEvent::~IDDEExecuteEvent                                          |
------------------------------------------------------------------------------*/
IDDEExecuteEvent :: ~IDDEExecuteEvent ( )
{
   ;
}

/*------------------------------------------------------------------------------
| IDDEServerHotLinkEvent::IDDEServerHotLinkEvent                               |
------------------------------------------------------------------------------*/
IDDEServerHotLinkEvent :: IDDEServerHotLinkEvent  ( const IEvent& ddeEvent )
                                  : IDDESetAcknowledgeInfoEvent(ddeEvent)
{
   ;
}

/*------------------------------------------------------------------------------
| IDDEServerHotLinkEvent::~IDDEServerHotLinkEvent                              |
------------------------------------------------------------------------------*/
IDDEServerHotLinkEvent :: ~IDDEServerHotLinkEvent ( )
{
   ;
}

/*------------------------------------------------------------------------------
| IDDEServerHotLinkEvent::isPacingRequested                                    |
------------------------------------------------------------------------------*/
bool IDDEServerHotLinkEvent :: isPacingRequested ( ) const
{
#ifdef IC_PM
   if (status() & DDE_FACKREQ)
#endif
#ifdef IC_WIN
   if (status() & IDDEInfo::acknowledgeRequested)
#endif
      return true;
   return false;
}

/*------------------------------------------------------------------------------
| IDDEServerHotLinkEvent::isDataRequested                                      |
------------------------------------------------------------------------------*/
bool IDDEServerHotLinkEvent :: isDataRequested ( ) const
{
#ifdef IC_PM
   if (status() & DDE_FNODATA)
#endif
#ifdef IC_WIN
   if (status() & IDDEInfo::noData)
#endif
      return false;
   return true;
}

/*------------------------------------------------------------------------------
| IDDEEndEvent::IDDEEndEvent                                                   |
------------------------------------------------------------------------------*/
IDDEEndEvent :: IDDEEndEvent ( const IEvent& ddeEvent,
                               Source        endSource )
                     : IEvent(ddeEvent), sourceCl(endSource)
{
   ;
}

/*------------------------------------------------------------------------------
| IDDEEndEvent::~IDDEEndEvent                                                  |
------------------------------------------------------------------------------*/
IDDEEndEvent :: ~IDDEEndEvent ( )
{
   ;
}

/*------------------------------------------------------------------------------
| IDDEClientEndEvent::IDDEClientEndEvent                                       |
------------------------------------------------------------------------------*/
IDDEClientEndEvent :: IDDEClientEndEvent ( const IEvent&  ddeEvent,
                                           Source         endSource,
                                           IString        application,
                                           IString topic )
                      : IDDEEndEvent(ddeEvent,endSource),
                        strClApp(application), strClTopic(topic)
{
   ;
}

/*------------------------------------------------------------------------------
| IDDEClientEndEvent::~IDDEClientEndEvent                                      |
------------------------------------------------------------------------------*/
IDDEClientEndEvent :: ~IDDEClientEndEvent ( )
{
   ;
}

/*------------------------------------------------------------------------------
| IDDEBeginEvent::IDDEBeginEvent                                               |
------------------------------------------------------------------------------*/
IDDEBeginEvent :: IDDEBeginEvent ( const IEvent& ddeBeginEvent )
                        : IEvent(ddeBeginEvent)
{
   IMODTRACE_DEVELOP("IDDEBeginEvent::IDDEBeginEvent") ;
#ifdef IC_PM
   PDDEINIT pddei = (_DDEINIT*)(void*)(ddeBeginEvent.parameter2());
   strClApp = pddei->pszAppName;
   strClTopic = pddei->pszTopic;
   unsigned long ulCaseSens = DDEI_PCONVCONTEXT(pddei)->fsContext;
   if (ulCaseSens == DDECTXT_CASESENSITIVE)
      bClCaseSens =  true;
   else bClCaseSens =  false;
#endif  /* IC_PM */
#ifdef IC_WIN
// TTD   LONG lParam = (LONG)(void*)(ddeBeginEvent.parameter2());
   LONG lParam = ddeBeginEvent.parameter2().asUnsignedLong();

   // initialize the private data
   //
   ATOM aApp,
        aTopic;
// TTD   UnpackDDElParam( ddeBeginEvent.eventId(), lParam,
// TTD                    (PUINT)&aApp, (PUINT)&aTopic );
   aApp   = LOWORD(lParam) ;
   aTopic = HIWORD(lParam) ;
   if ( aApp )
      strClApp   = IDDEInfo__stringFromAtom( (unsigned long)aApp );
   if ( aTopic )
      strClTopic = IDDEInfo__stringFromAtom( (unsigned long)aTopic );

   // Windows not support this case sensitive, set dummy to fulfill the method
   bClCaseSens =  false;
#endif  /* IC_WIN */
}

/*------------------------------------------------------------------------------
| IDDEBeginEvent::~IDDEBeginEvent                                              |
------------------------------------------------------------------------------*/
IDDEBeginEvent :: ~IDDEBeginEvent ( )
{
   ;
}

#endif /* IC_PMWIN  */
