/*
*****************************************************************************************
*                                                                                       *
* COPYRIGHT:                                                                            *
*   IBM Open Class Library                                                              *
*   (C) Copyright International Business Machines Corporation,  1997                    *
*   Licensed Material - Program-Property of IBM - All Rights Reserved.                  *
*   US Government Users Restricted Rights - Use, duplication, or disclosure             *
*   restricted by GSA ADP Schedule Contract with IBM Corp.                              *
*                                                                                       *
*****************************************************************************************
*/

// Revision: 13 1.5.1.4 source/core/utils/os2/os2refct.cpp, utilities, ioc.v400, 001006 
//OS2REFCT.CPP

#include "imrefcnt.hpp"
//#include "atomicop.hpp"
extern void*    AtomicGet486(void* const volatile* addr);

extern void     AtomicIncrement486( void* const volatile* address);

extern int      AtomicDecrement486( void* const volatile* address);



#ifdef IC_PAGETUNE
    #define _OS2REFCT_CPP_
    #include <ipagetun.h>
#endif

void
IMRefCounted::addRef()
{
   //LockedIncrement( fCount );

   AtomicIncrement486( (void* const volatile*)&fCount);

}

void
IMRefCounted::removeRef()
{
   //if (LockedDecrement( fCount) == 0)
   //   delete this;

   if( 0 == AtomicDecrement486( (void* const volatile*)&fCount)) delete this;

}

unsigned long
IMRefCounted::count() const
{
  return (unsigned long) AtomicGet486( (void*const*) &fCount );
}
