#ifndef _ISTATICS_INL_
#define _ISTATICS_INL_

// <prologue>
// <copyright>
/*****************************************************************************
* FILE NAME: istatics.inl                                                    *
*                                                                            *
* COPYRIGHT:                                                                 *
*   IBM Open Class Library                                                   *
*   (C) Copyright International Business Machines Corporation 1992, 1999     *
*   Licensed Material - Program-Property of IBM - All Rights Reserved.       *
*   US Government Users Restricted Rights - Use, duplication, or disclosure  *
*   restricted by GSA ADP Schedule Contract with IBM Corp.                   *
*                                                                            *
*****************************************************************************/
// </copyright>
//
// Revision: 44 1.4.1.1 source/core/utils/istatics.inl, utilities, ioc.v400, 001006 
//
// </prologue>
// <header>

// <include-files>
#include <istatics.hpp>
// </include-files>

template<class T>
inline
void
adoptStaticObject(T* obj)
{
    IStaticObjectManager::adopt(new IStaticObjectHelper<T>(obj));
}

template<class T>
inline
void
adoptStaticObjectArray(T* obj)
{
    IStaticObjectManager::adopt(new IStaticObjectArrayHelper<T>(obj));
}

#endif // _ISTATICS_INL_
