// Revision: 55 1.9.2.2 source/core/utils/iautoptr.inl, filesystem, ioc.v400, 001006  
/*
*****************************************************************************************
*                                                                                       *
* COPYRIGHT:                                                                            *
*   IBM Open Class Library                                                              *
*   (C) Copyright Taligent, Inc.,  1996                                                 *
*   (C) Copyright International Business Machines Corporation,  1997                    *
*   Licensed Material - Program-Property of IBM - All Rights Reserved.                  *
*   US Government Users Restricted Rights - Use, duplication, or disclosure             *
*   restricted by GSA ADP Schedule Contract with IBM Corp.                              *
*                                                                                       *
*****************************************************************************************
*/

#ifndef _IAUTOPTR_INL_
#define _IAUTOPTR_INL_

#ifndef IC_BUILD
#define __IOC_INLINE inline
#else
#define __IOC_INLINE
#endif

//----------------------------------------------------------------------
// auto_ptr inlines
// Temporary until we get the ANSI C++ standard library
//
template <class T> inline
auto_ptr<T>::auto_ptr(T* p)
	: fObject(p)
{
}

template <class T> inline
auto_ptr<T>::auto_ptr(auto_ptr<T>& p)
	: fObject( p.release() )
{
}

template <class T> inline auto_ptr<T>&
auto_ptr<T>::operator=(auto_ptr<T>& p)
{
	reset(p.release());
	return *this;
}

template <class T> 
__IOC_INLINE
auto_ptr<T>::~auto_ptr()
{
	delete get();
}

template <class T>
__IOC_INLINE
T*
auto_ptr<T>::get() const
{
	return fObject;
}

template <class T>
__IOC_INLINE
T&
auto_ptr<T>::operator*() const
{
	return *fObject;
}

template <class T>
__IOC_INLINE
T*
auto_ptr<T>::operator->() const
{
	return fObject;
}

template <class T>
__IOC_INLINE
T*
auto_ptr<T>::release()
{
	T* temp = get();
	fObject = 0;
	return temp;
}

template <class T>
__IOC_INLINE
void
auto_ptr<T>::reset(T *p)
{
	delete fObject;
	fObject = p;
}

//----------------------------------------------------------------------
// IAutoArray inlines
//
template <class T> inline IAutoArray<T>::IAutoArray( T* obj ) :
	fObject(obj)
{
}

template <class T>
__IOC_INLINE
IAutoArray<T>::~IAutoArray()
{
	delete [] get();
}

template <class T> inline IAutoArray<T>::IAutoArray(IAutoArray<T>& p)
	: fObject( p.release() )
{
}

template <class T> inline IAutoArray<T>&
IAutoArray<T>::operator=(IAutoArray<T>& p)
{
	reset(p.release());
	return *this;
}

template <class T> inline T* IAutoArray<T>::get() const
{
	return fObject;
}

template <class T> inline T& IAutoArray<T>::operator[](int i) const
{
	return fObject[i];
}

template <class T>
__IOC_INLINE
T* IAutoArray<T>::release()
{
	T* temp = get();
	fObject = 0;
	return temp;
}

template <class T>
__IOC_INLINE
void IAutoArray<T>::reset(T *p)
{
	delete[] fObject;
	fObject = p;
}


inline void* IAutoHeap::get() const
{
    return fBuffer;
}

inline IAutoHeap::IAutoHeap(void* p) :
    fBuffer(p)
{
}

inline IAutoHeap::~IAutoHeap()
{
    delete get();
}

inline void* IAutoHeap::release()
{
    void* temp = get();
    fBuffer = 0;
    return temp;
}

inline void IAutoHeap::reset(void* p)
{
    delete fBuffer;
    fBuffer = p;
}

#endif // _IAUTOPTR_INL_
