/*
*****************************************************************************************
*                                                                                       *
* COPYRIGHT:                                                                            *
*   IBM Open Class Library                                                              *
*   (C) Copyright International Business Machines Corporation,  1997                    *
*   Licensed Material - Program-Property of IBM - All Rights Reserved.                  *
*   US Government Users Restricted Rights - Use, duplication, or disclosure             *
*   restricted by GSA ADP Schedule Contract with IBM Corp.                              *
*                                                                                       *
*****************************************************************************************
*/
// Revision: 40 1.5.2.2 source/core/text/itext/istylsto.inl, text, ioc.v400, 001006 
//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
//
//      IStylSto.hpp    (IStyleStorage.h)
//
//      Contains: IStyleStorage, the style-run-array mechanism for IText, and
//              IStyleRunIterator, which allows fast iteration through the style runs in an
//              IStyleStorage.
//
// Author:
//      Richard Gillam
//
// COPYRIGHT:
//      IBM Open Class Library
//      (C) Copyright International Business Machines Corporation 1997
//      Licensed Material - Program-Property of IBM - All Rights Reserved.
//      US Government Users Restricted Rights - Use, duplication, or disclosure
//      restricted by GSA ADP Schedule Contract with IBM Corp.
//
//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

#ifndef _ISTYLSTO_INL_
#define _ISTYLSTO_INL_

#ifndef IC_BUILD
#define __IOC_INLINE inline
#else
#define __IOC_INLINE
#endif

//========================================================================================
// OPERATIONS:  These classes are defined here to allow a simple way of specifying
// transformations of the styles in an IStyleStorage (it saves me copying and pasting the
// same code for five different variations on addStyles() and removeStyles() and leaves
// the door open for future additional transformations (such as tab-stop maintenance).
// These classes are written in a slightly more general way than strictly necessary in
// case we see a good reason to expose them to the API.
//========================================================================================

template <class AnOperand>
__IOC_INLINE 
IOperationOn<AnOperand>::IOperationOn()
{
}

template <class AnOperand>
__IOC_INLINE 
IOperationOn<AnOperand>::~IOperationOn()
{
}

template <class AnOperand>
__IOC_INLINE 
IPmfOperationOn<AnOperand>::IPmfOperationOn(void        (AnOperand::* function)())
: fFunction(function)
{
}

template <class AnOperand>
__IOC_INLINE 
IPmfOperationOn<AnOperand>::~IPmfOperationOn()
{
}

template <class AnOperand>
__IOC_INLINE 
void
IPmfOperationOn<AnOperand>::operator()(AnOperand*       operand) const
{
        (operand->*fFunction)();
}

template <class AnOperand, class AParameter>
__IOC_INLINE 
IPmf1OperationOn<AnOperand, AParameter>::IPmf1OperationOn(      void            (AnOperand::* function)(AParameter),
                                                                                                                        AParameter      parameter)
: fFunction(function),
  fParameter(parameter)
{
}

template <class AnOperand, class AParameter>
__IOC_INLINE 
IPmf1OperationOn<AnOperand, AParameter>::~IPmf1OperationOn()
{
}

template <class AnOperand, class AParameter>
__IOC_INLINE 
void
IPmf1OperationOn<AnOperand, AParameter>::operator()(AnOperand*  operand) const
{
        (operand->*fFunction)(fParameter);
}

//========================================================================================
// CLASS IStyleRunIterator:  An iterator that allows the user to iterate across the
// style runs in an IStyleStorage.  This iterator obeys the protocol for an STL-
// compatible bidirectional iterator.
//========================================================================================

inline
IStyleRunIterator::IStyleRunIterator()
: fRun(0),
  fPosition(0)
{
        // WARNING:  You can't dereference this iterator!  All you can do with a default-constructed
        // IStyleRunIterator is assign to it.
}

inline
IStyleRunIterator::IStyleRunIterator(const IStyleRunIterator&   that)
: fRun(that.fRun),
  fPosition(that.fPosition)
{
}

inline
IStyleRunIterator::IStyleRunIterator(   IStyleRun*              run,
                                                                                offset_type             position)
: fRun(run),
  fPosition(position)
{
}

inline
IStyleRunIterator::~IStyleRunIterator()
{
}

inline IStyleRunIterator&
IStyleRunIterator::operator=(const IStyleRunIterator&   that)
{
        fRun = that.fRun;
        fPosition = that.fPosition;
        return *this;
}

inline bool
IStyleRunIterator::operator==(const IStyleRunIterator&  that) const
{
        return fRun == that.fRun;
}

inline bool
IStyleRunIterator::operator!=(const IStyleRunIterator&  that) const
{
        return fRun != that.fRun;
}

inline IStyleRun&
IStyleRunIterator::operator*() const
{
        return *fRun;
}

inline IStyleRun*
IStyleRunIterator::operator->() const
{
        return fRun;
}

inline const ITextStyleSet*
IStyleRunIterator::runSet() const
{
        return fRun->fStyles;
}

inline IStyleRunIterator::length_type
IStyleRunIterator::runLength() const
{
        return fRun->fLength;
}

inline IStyleRunIterator::offset_type
IStyleRunIterator::runStart() const
{
        return fPosition;
}

inline void
IStyleRunIterator::setRunStart(offset_type      newStart)
{
        fPosition = newStart;
}

inline void
IStyleRunIterator::offsetRunStart(long  offsetBy)
{
        fPosition += offsetBy;
        fRun->fLength -= offsetBy;
}

inline IStyleRunIterator&
IStyleRunIterator::operator++()
{
        fPosition += fRun->fLength;
        fRun++;
        return *this;
}

inline IStyleRunIterator
IStyleRunIterator::operator++(int)
{
        IStyleRunIterator       temp(*this);
        operator++();
        return temp;
}

inline IStyleRunIterator&
IStyleRunIterator::operator--()
{
        fRun--;
        fPosition -= fRun->fLength;
        return *this;
}

inline IStyleRunIterator
IStyleRunIterator::operator--(int)
{
        IStyleRunIterator       temp(*this);
        operator--();
        return temp;
}

inline bool
IStyleRunIterator::containsPosition(offset_type position) const
{
        return position == fPosition || (position > fPosition && position < fPosition + fRun->fLength);
}

inline void
IStyleRunIterator::seekToPosition(offset_type   position)
{
        // WARNING:  There is no error checking on this routine!  The caller must guarantee
        // that the position passed in is valid for the IText we're iterating over.
        if (position >= fPosition)
                while (!containsPosition(position))
                        operator++();
        else
                do
                        operator--();
                while (!containsPosition(position));
}

//inline bidirectional_iterator_tag
//iterator_categoy(const IStyleRunIterator&)
//{
//      return bidirectional_iterator_tag();
//}

inline IStyleRun*
value_type(const IStyleRunIterator&)
{
        return 0;
}

inline IStyleRunIterator::offset_type
distance_type(const IStyleRunIterator&)
{
        return 0;
}

//========================================================================================
// INLINE METHODS ON IStyleStorage
//========================================================================================

inline IStyleRunIterator
IStyleStorage::begin() const
{
        return IStyleRunIterator(fRuns, 0);
}

inline IStyleRunIterator
IStyleStorage::end() const
{
        return IStyleRunIterator(&fRuns[fNumRuns], fNumChars);
                // WARNING:  You can't dereference this iterator!  Unless you back it up into the actual run
                // array, you can only use it for termination testing!
}

#endif // _ISTYLSTO_INL_
