// Revision: 76 1.1 source/core/dllinit/dde4cdll.cpp, uiproj, ioc.v400, 001006 
/*******************************************************************************
* FILE NAME: DDE4CDLL.CPP                                                      *
*                                                                              *
* DESCRIPTION: Initialization/termination code for the core dll on OS/2.       *
*   This file is basically equivalent to dde4udll.cpp, but contains code       *
*   added to dde4udlu.cpp in VAC++ 3.0 for OS/2.                               *
*   As specified by OS/2 support, this function cleans up the thread           *
*   watcher thread, to avoid having a running thread still attempt to          *
*   access code in the DLL after the DLL has been freed via DosFreeModule.     *
*                                                                              *
* COPYRIGHT:                                                                   *
*   Licensed Materials - Property of IBM                                       *
*   (C) Copyright IBM Corporation 1992, 1997                                   *
*   All Rights Reserved                                                        *
*   US Government Users Restricted Rights - Use, duplication, or               *
*   disclosure                                                                 *
*   restricted by GSA ADP Schedule Contract with IBM Corp.                     *
*                                                                              *
* Revision: 76 1.1 source/core/dllinit/dde4cdll.cpp, uiproj, ioc.v400, 001006 
*******************************************************************************/
#ifdef __OS2__
#include <stdio.h>

// function prototypes
extern "C" {
  int  _CRT_init      (void );
  void __ctordtorInit (int);
  void _CRT_term      (void );
  void __ctordtorTerm (int);
  void threadWatcher_Terminate ( void );  // In core/base/ingthrd.cpp
}

// Segment definitions
#ifdef IC_PAGETUNE
  #define _DDE4CDLL_CPP_
  #include <ipagetun.h>
#endif

unsigned long gCoreDllHandle = 0;

unsigned long _System _DLL_InitTerm ( unsigned long hmodule,
                                      unsigned long ulFlag )
{
  unsigned long ulRc = 1;         // assume no errors

  if (ulFlag == 0)
  {
     gCoreDllHandle = hmodule;    // DLL being loaded
     if (_CRT_init() == -1)
     {
        ulRc = 0;                 // error
     }
     __ctordtorInit(0);
  } /* endif */
  else if (ulFlag == 1)
  {                               // DLL being freed

// It appears we should do neither of these at shutdown
// There were problems with Driver 27 when ctordtorTerm() was called
// and _CRT_term() wasn't.
#ifdef IC_STATIC_LINK
     __ctordtorTerm();
     _CRT_term();
#else
     // Be sure to end thread watcher threads. The function being called
     // is in core/base/ingthrd.cpp.
     threadWatcher_Terminate();
#endif
  }
  else
  {
     ulRc = 0;                    // error
  }

  return ulRc;
}
#endif // __OS2__
