// IBM Open Class Library
//
// Licensed Materials - Property of IBM
//
// (C) Copyright IBM Corporation, 1992, 1997 All Rights Reserved
//
// Revision: 20 1.6.1.4 source/core/collect/iivss.h, collection, ioc.v400, 001006 
#ifndef _IIVSS_
#define _IIVSS_

#include <ilanglvl.hpp>
#include <iiass.h>

#if defined (__SOM_ENABLED__)
#if defined (__RRBC_LIB__)
#pragma SOMAsDefault (on)
#else
#pragma SOMAsDefault (off)
#endif
#endif

#if defined (__OS2__) || defined (__OS400__) || defined (__WINDOWS__)
#pragma info (nocls, nocnd, nocns, nocnv, noext, nognr, novft)
#endif

#if __IBMCPP__ >= 400
#pragma namemangling(compat)
#endif

#pragma pack(push,4)
#pragma enum(4)

template <class VInherited>
class IVSortedSetImpl : public VInherited {
public:

  typedef TYPENAME VInherited::Ops Ops;

           IVSortedSetImpl
                            (Ops&, INumber);

           IVSortedSetImpl
                            (Ops&, IVSortedSetImpl
                                    <VInherited> const&);

  bool     Add              (void const*, ICursorImpl&);

  void     AddAllFrom       (IACollectionImpl const&);

  void     AddAntivalence   (IASortedSetImpl const&,
                             IASortedSetImpl const&);

  void     AddDifference    (IASortedSetImpl const&,
                             IASortedSetImpl const&);

  void     AddIntersection  (IASortedSetImpl const&,
                             IASortedSetImpl const&);

  void     AddUnion         (IASortedSetImpl const&,
                             IASortedSetImpl const&);

  void     Antivalence      (IASortedSetImpl const&);

  void     Copy             (IACollectionImpl const&);

  void     Difference       (IASortedSetImpl const&);

  void     Intersection     (IASortedSetImpl const&);

  bool     LocateOrAdd      (void const*, ICursorImpl&);

  bool     Remove           (void const*);

  INumber  RemoveAll        ();

  INumber  RemoveAll        (IPredFunc, void*);

  INumber  RemoveAllOccurrences
                            (void const*);

  void     RemoveAt         (ICursorImpl&);

  void     RemoveAtPosition (IPosition);

  void     RemoveFirst      ();

  void     RemoveLast       ();

  void     ReplaceAt        (ICursorImpl const&, void const*);

  void     Union            (IASortedSetImpl const&);

protected:

private:

#if defined (__SOM_ENABLED__) && defined (__RRBC_LIB__)
#pragma SOMClassVersion (*, 5, 0)
#pragma SOMReleaseOrder (\
           IVSortedSetImpl\
                            (Ops&, INumber),\
           IVSortedSetImpl\
                            (Ops&, IVSortedSetImpl\
                                    <VInherited> const&)\
                        )
#endif

};

#pragma enum(pop)
#pragma pack(pop)

#if __IBMCPP__ >= 400
#pragma namemangling()
#endif

#if defined (__SOM_ENABLED__)
#pragma SOMAsDefault (pop)
#endif

#if defined (_AIX)        || defined (__MVS__)   ||\
    defined (__OS2__)     || defined (__OS400__) ||\
    defined (__WINDOWS__)
#if ! defined (__TEMPINC__)
#include <iivss.c>
#endif
#endif

#if defined (__OS2__) || defined (__OS400__) || defined (__WINDOWS__)
#pragma info (restore)
#endif

#endif // _IIVSS_
