// IBM Open Class Library
//
// Licensed Materials - Property of IBM
//
// (C) Copyright IBM Corporation, 1992, 1997 All Rights Reserved
//
// Revision: 34 1.5.1.4 source/core/collect/iismavl.c, collection, ioc.v400, 001006 
#ifndef _IISMAVL_C_
#define _IISMAVL_C_

#if defined (__OS2__) || defined (__OS400__) || defined (__WINDOWS__)
#pragma info (nocls, nocnd, nocns, nocnv, noext, nognr, novft)
#endif

#ifdef IC_BUILD
#define __IOC_INLINE
#else
#define __IOC_INLINE inline
#endif

// ---
// ISortedMapAsAvlTreeOps
// ---

// public members

template <class Element, class Key,
          class ElementOps, class Implementation>
__IOC_INLINE
ISortedMapAsAvlTreeOps <Element, Key, ElementOps, Implementation>::
ISortedMapAsAvlTreeOps (INumber numberOfElements)
: ivElementOps (),
  ivBase (numberOfElements),
  ivImpl (*this, numberOfElements)
{
}

template <class Element, class Key,
          class ElementOps, class Implementation>
__IOC_INLINE
ISortedMapAsAvlTreeOps <Element, Key, ElementOps, Implementation>::
ISortedMapAsAvlTreeOps (INumber numberOfElements, void* opsArg)
: ivElementOps (opsArg),
  ivBase (numberOfElements, opsArg),
  ivImpl (*this, numberOfElements)
{
}

template <class Element, class Key,
          class ElementOps, class Implementation>
__IOC_INLINE
ISortedMapAsAvlTreeOps <Element, Key, ElementOps, Implementation>::
ISortedMapAsAvlTreeOps
  (ISortedMapAsAvlTreeOps
    <Element, Key, ElementOps, Implementation> const& collection)
: ivElementOps (collection.ivElementOps),
  ivBase (collection.ivBase),
  ivImpl (*this, collection.ivImpl)
{
}

template <class Element, class Key,
          class ElementOps, class Implementation>
__IOC_INLINE
ISortedMapAsAvlTreeOps <Element, Key, ElementOps, Implementation>::
~ISortedMapAsAvlTreeOps ()
{
}

template <class Element, class Key,
          class ElementOps, class Implementation>
__IOC_INLINE
IACollectionImpl*
ISortedMapAsAvlTreeOps <Element, Key, ElementOps, Implementation>::
Clone () const
{ return (Implementation*) *new Self (*this);
}

template <class Element, class Key,
          class ElementOps, class Implementation>
__IOC_INLINE
bool
ISortedMapAsAvlTreeOps <Element, Key, ElementOps, Implementation>::
EqualElements (void const* element1, void const* element2) const
{ return ivElementOps.Equal (*(Element const*)element1,
                             *(Element const*)element2);
}

template <class Element, class Key,
          class ElementOps, class Implementation>
__IOC_INLINE
ISortedMapAsAvlTreeOps <Element, Key, ElementOps, Implementation>::
operator IKeySortedSetAsAvlTreeImpl& ()
{ return *(IKeySortedSetAsAvlTreeImpl*) ivBase;
}

template <class Element, class Key,
          class ElementOps, class Implementation>
__IOC_INLINE
ISortedMapAsAvlTreeOps <Element, Key, ElementOps, Implementation>::
operator Implementation* ()
{ ivImpl.CheckPointer (this);
  return &ivImpl;
}

#if defined (__OS2__) || defined (__OS400__) || defined (__WINDOWS__)
#pragma info (restore)
#endif

#endif // _IISMAVL_C_
