// IBM Open Class Library
//
// Licensed Materials - Property of IBM
//
// (C) Copyright IBM Corporation, 1992, 1997 All Rights Reserved
//
// Revision: 05 1.5.3.2 source/core/collect/iiseqlst.c, collection, ioc.v400, 001006 
#ifndef _IISEQLST_C_
#define _IISEQLST_C_

#include <new.h>

#if defined (__OS2__) || defined (__OS400__) || defined (__WINDOWS__)
#pragma info (nocls, nocnd, nocns, nocnv, noext, nognr, novft)
#endif

#ifdef IC_BUILD
#define __IOC_INLINE
#else
#define __IOC_INLINE inline
#endif

// ------------------
// ISequenceAsListOps
// ------------------

// public members

template <class Element, class ElementOps, class Implementation>
__IOC_INLINE
ISequenceAsListOps <Element, ElementOps, Implementation>::
ISequenceAsListOps (INumber numberOfElements)
: Inherited (__isDTSClass (Element)),
  ivElementOps (),
  ivImpl (*this, numberOfElements)
{
}

template <class Element, class ElementOps, class Implementation>
__IOC_INLINE
ISequenceAsListOps <Element, ElementOps, Implementation>::
ISequenceAsListOps (INumber numberOfElements, void* opsArg)
: Inherited (__isDTSClass (Element)),
  ivElementOps (opsArg),
  ivImpl (*this, numberOfElements)
{
}

template <class Element, class ElementOps, class Implementation>
__IOC_INLINE
ISequenceAsListOps <Element, ElementOps, Implementation>::
ISequenceAsListOps
  (ISequenceAsListOps <Element, ElementOps,
                       Implementation> const& collection)
: Inherited (__isDTSClass (Element)),
  ivElementOps (collection.ivElementOps),
  ivImpl (*this, collection.ivImpl)
{
}

template <class Element, class ElementOps, class Implementation>
__IOC_INLINE
void
ISequenceAsListOps <Element, ElementOps, Implementation>::
Assign (void* element1, void const* element2) const
{ ivElementOps.Assign (*(Element*)element1,
                       *(Element const*)element2);
}

template <class Element, class ElementOps, class Implementation>
__IOC_INLINE
IACollectionImpl*
ISequenceAsListOps <Element, ElementOps, Implementation>::
Clone () const
{ return (Implementation*) *new Self (*this);
}

template <class Element, class ElementOps, class Implementation>
__IOC_INLINE
void*
ISequenceAsListOps <Element, ElementOps, Implementation>::
CreateNode (void const* element) const
{ void* node = ivElementOps.Allocate (sizeof (Node)
#if defined (__OS2__) || defined (__OS400__) || defined (__WINDOWS__) || defined (_AIX)
#if defined (__DEBUG_ALLOC__)
                                      , __FILE__, __LINE__
#endif
#endif
#if defined (__OSTORE__)
                                      , Node::get_os_typespec (), 1
#endif
                                     );
  return new (ivImpl.CheckPointer (node))
              Node (*(Element const*)element);
}

#if ! defined (__INO_STREAMING__)
template <class Element, class ElementOps, class Implementation>
__IOC_INLINE
void*
ISequenceAsListOps <Element, ElementOps, Implementation>::
CreateNodeWithStreamer(IACollectionStreamer *streamer,
                       IDataStream& fromWhere) const
{ void* node = ivElementOps.Allocate (sizeof (Node)
#if defined (__OS2__) || defined (__OS400__) || defined (__WINDOWS__) || defined (_AIX)
#if defined (__DEBUG_ALLOC__)
                                      , __FILE__, __LINE__
#endif
#endif
                                     );
  ivImpl.CheckPointer (node);
  ((Node*)node)->StreamIn (streamer, fromWhere);
  return node;
}
#endif

template <class Element, class ElementOps, class Implementation>
__IOC_INLINE
void
ISequenceAsListOps <Element, ElementOps, Implementation>::
DeleteNode (void* node) const
{ ((Node*)node)->~Node ();
  ivElementOps.Deallocate (node
#if defined (__OS2__) || defined (__OS400__) || defined (__WINDOWS__) || defined (_AIX)
#if defined (__DEBUG_ALLOC__)
                           , __FILE__, __LINE__
#endif
#endif
                          );
}

template <class Element, class ElementOps, class Implementation>
__IOC_INLINE
ISequenceAsListOps <Element, ElementOps, Implementation>::
operator Implementation* ()
{ ivImpl.CheckPointer (this);
  return &ivImpl;
}

#if defined (__OS2__) || defined (__OS400__) || defined (__WINDOWS__)
#pragma info (restore)
#endif

#endif // _IISEQLST_C_
