// IBM Open Class Library
//
// Licensed Materials - Property of IBM
//
// (C) Copyright IBM Corporation, 1992, 1997 All Rights Reserved
//
// Revision: 03 1.5.1.5 source/core/collect/iiseqdil.h, collection, ioc.v400, 001006 
#ifndef _IISEQDIL_
#define _IISEQDIL_

#include <iiaseq.h>
#include <iitable.h>

#if defined (__OSTORE__)
#include <ostore/ostore.hh>
#include <ostore/manschem.hh>
#endif

#if defined (__OS2__) || defined (__OS400__) || defined (__WINDOWS__)
#pragma info (nocls, nocnd, nocns, nocnv, noext, nognr, novft)
#endif

#if defined (__SOM_ENABLED__)
#pragma SOMAsDefault (off)
#endif

#if __IBMCPP__ >= 400
#pragma namemangling(compat)
#endif

#pragma enum (4)
#pragma pack (push,4)

template <class Element>
struct ISequenceAsDilTableNodeImpl {

  void*    ivPtr;

  Element  ivElement;

           ISequenceAsDilTableNodeImpl
                            (Element const&);

          ~ISequenceAsDilTableNodeImpl
                            ();

#if !defined(__INO_STREAMING__)
  void     StreamIn         (IACollectionStreamer*, IDataStream&);
#endif

#if defined (__OSTORE__)
  static
  os_typespec*
           get_os_typespec  ();
#endif

};

struct IDilTableImpl : public ITableImpl {

  typedef  ISequenceAsDilTableNodeImpl <void*> Node;

  typedef struct {
    void *unused;
    size_t offset;
  } UnusedOffset;

  UnusedOffset* ivUnused;

  void*    ElementAtIndex   (INumber) const;

  void     GetUnused        (INumber);

  void*&   PtrAtIndex       (INumber) const;

  void     PutUnused        (INumber);

  void     RemoveAtIndex    (INumber);

};

#if defined (__SOM_ENABLED__)
#pragma SOMAsDefault (pop)
#if defined (__RRBC_LIB__)
#pragma SOMAsDefault (on)
#else
#pragma SOMAsDefault (off)
#endif
#endif

class IC_EXPORTC ISequenceAsDilTableCursorImpl : public ICursorImpl {

  typedef  ICursorImpl Inherited;

  typedef  ISequenceAsDilTableCursorImpl Self;

public:

           ISequenceAsDilTableCursorImpl
                            (IACollectionImpl const&);

           ISequenceAsDilTableCursorImpl
                            (ISequenceAsDilTableCursorImpl const&);

          ~ISequenceAsDilTableCursorImpl
                            ();

  ICursorImpl*
           Clone            () const;

  void     Copy             (ICursorImpl const&);

  void     Invalidate       ();

  bool IsInBetween      () const;

  bool IsValid          () const;

  void     operator=        (ISequenceAsDilTableCursorImpl const&);

  bool operator==       (ICursorImpl const&) const;

protected:

private:

  INumber  ivIndex;

  friend
  class    ISequenceAsDilTableImpl;

#if defined (__SOM_ENABLED__) && defined (__RRBC_LIB__)
#pragma SOMClassVersion (*, 5, 0)
#pragma SOMReleaseOrder (\
           ISequenceAsDilTableCursorImpl\
                            (IACollectionImpl const&),\
           operator=\
                        )
#endif

};

#if ! defined (__INO_MNGCURSOR__)
class IC_EXPORTC ISequenceAsDilTableMngCursorImpl :
  public ISequenceAsDilTableCursorImpl {

  typedef  ISequenceAsDilTableCursorImpl Inherited;

  typedef  ISequenceAsDilTableMngCursorImpl Self;

public:

           ISequenceAsDilTableMngCursorImpl
                            (ISequenceAsDilTableImpl const&);

           ~ISequenceAsDilTableMngCursorImpl
                            ();

  ICursorImpl*
           Clone            () const;

  void     Copy             (ICursorImpl const&);

  bool IsInBetween      () const;

  bool IsMngCursor      () const;

  void     operator=        (ISequenceAsDilTableMngCursorImpl const&);

protected:

private:

  static
  INumber const
           kIsInBetween;

  ISequenceAsDilTableImpl*
           ivMngCollection;

  Self*    ivNext;

  INumber  ivNextIndex,
           ivPreviousIndex;

  friend
  class    ISequenceAsDilTableImpl;

#if defined (__SOM_ENABLED__) && defined (__RRBC_LIB__)
#pragma SOMClassVersion (*, 5, 0)
#pragma SOMReleaseOrder (\
           ISequenceAsDilTableMngCursorImpl\
                            (ISequenceAsDilTableImpl const&),\
           operator=,\
           kIsInBetween\
                        )
#endif

};
#endif

class IASequenceAsDilTableOps;

class IC_EXPORTC ISequenceAsDilTableImpl : public IASequenceImpl {

  typedef  IASequenceImpl Inherited;

  typedef  ISequenceAsDilTableImpl Self;

public:

  typedef  IASequenceAsDilTableOps Ops;

  typedef  ISequenceAsDilTableCursorImpl Cursor;

#if ! defined (__INO_MNGCURSOR__)
  typedef  ISequenceAsDilTableMngCursorImpl MngCursor;
#else
  typedef  ISequenceAsDilTableCursorImpl MngCursor;
#endif

           ISequenceAsDilTableImpl
                            (Ops&, INumber);

           ISequenceAsDilTableImpl
                            (Ops&, ISequenceAsDilTableImpl const&);

          ~ISequenceAsDilTableImpl
                            ();

  bool Add              (void const*, ICursorImpl&);

  void     AddAllFrom       (IACollectionImpl const&);

  void     AddAsFirst       (void const*, ICursorImpl&);

  void     AddAsLast        (void const*, ICursorImpl&);

  void     AddAsNext        (void const*, ICursorImpl&);

  void     AddAsPrevious    (void const*, ICursorImpl&);

  void     AddAtPosition    (IPosition, void const*, ICursorImpl&);

  bool AllElementsDo    (IApplFunc, void*);

  void*    Any              () const;

  bool CheckCursor      (ICursorImpl const&) const;

  char const*
           ClassName        () const;

  IACollectionImpl*
           Clone            () const;

  void     Copy             (IACollectionImpl const&);

  Cursor*  CreateCursor     () const;

  MngCursor*
           CreateMngCursor  () const;

  void*    ElementAt        (ICursorImpl const&) const;

  void*    ElementAtPosition
                            (IPosition) const;

  void*    First            () const;

  bool IsBounded        () const;

  bool IsConsistent     () const;

  bool IsEmpty          () const;

  bool IsFirstAt        (ICursorImpl const&) const;

  bool IsFull           () const;

  bool IsLastAt         (ICursorImpl const&) const;

  void*    Last             () const;

  INumber  NumberOfElements () const;

  IPosition
           PositionAt       (ICursorImpl const&) const;

  INumber  RemoveAll        ();

  INumber  RemoveAll        (IPredFunc, void*);

  void     RemoveAt         (ICursorImpl&);

  void     RemoveAtPosition (IPosition);

  void     RemoveFirst      ();

  void     RemoveLast       ();

  void     ReplaceAt        (ICursorImpl const&, void const*);

  void     ReplaceAtPosition
                            (IPosition position, void const*);

  void     Reverse          ();

  bool SetToFirst       (ICursorImpl&) const;

  bool SetToLast        (ICursorImpl&) const;

  bool SetToNext        (ICursorImpl&) const;

  void     SetToPosition    (IPosition, ICursorImpl&) const;

  bool SetToPrevious    (ICursorImpl&) const;

  void     Sort             (ICompFunc, void*);

  void     operator=        (ISequenceAsDilTableImpl const&);

protected:

  void     Assign           (void*, void const*) const;

  void*    CreateNodes      (INumber, size_t&) const;

  void     ConstructNode    (void*, void const*) const;

  void     DeleteNodes      (void*) const;

  void     DestroyNode      (void*) const;

private:

  enum { kOriginalVersion };

  static
  char const*
           cvClassName;

  MngCursor*
           ivMngCursors;

  IDilTableImpl
           ivTable;

  virtual
  void     CopyFrom         (ISequenceAsDilTableImpl const&);

  void*    ElementOf        (void const*) const;

  void     GrowBy           (INumber);

  static
  INumber& IndexOf          (ICursorImpl const&);

  void     Initialize       (INumber);

  static
  bool IsInBetween      (ICursorImpl const&);

  bool IsRemoved        (INumber) const;

  void     MakeFree         (INumber&);

  static
  INumber& NextIndexOf      (ICursorImpl const&);

  static
  Ops&     OpsOf            (ISequenceAsDilTableImpl const&);

  IPosition
           PositionAtIndex  (INumber) const;

  static
  INumber& PreviousIndexOf  (ICursorImpl const&);

  void     RemoveAtIndex    (INumber);

  void     SetInBetween     (MngCursor&) const;

  bool SetToNextIndex   (INumber&) const;

  bool SetToPreviousIndex
                            (INumber&) const;

  void     UpdateMngCursorsForCopyFrom
                            (INumber, INumber) const;

  void     UpdateMngCursorsForGrowBy
                            () const;

  void     UpdateMngCursorsForRemoveOf
                            (INumber) const;

  void     UpdateMngCursorsForSwap
                            (INumber, INumber) const;

  friend
  class    ISequenceAsDilTableMngCursorImpl;

#if ! defined (__INO_STREAMING__)
protected:
  void     AddAsLastFromStreamer
                            (IDataStream&, ICursorImpl&);

  void     ConstructNodeWithStreamer
                            (void*, IDataStream&) const;

public:
  IStreamerPtr&
           StreamerOf       (IACollectionImpl const&);

  void     StreamIn         (IDataStream&);

  void     StreamOut        (IDataStream&) const;

  void     AdoptStreamer    (IACollectionStreamer*);
#endif

#if defined (__SOM_ENABLED__) && defined (__RRBC_LIB__)
#pragma SOMClassVersion (*, 5, 0)
#pragma SOMReleaseOrder (\
           ISequenceAsDilTableImpl\
                            (Ops&, INumber),\
           ISequenceAsDilTableImpl\
                            (Ops&, ISequenceAsDilTableImpl const&),\
           CheckCursor      (ICursorImpl const&) const,\
           operator=,\
           Assign           (void*, void const*) const,\
           CreateNodes      (INumber, size_t&) const,\
           ConstructNode    (void*, void const*) const,\
           DeleteNodes      (void*) const,\
           DestroyNode      (void*) const,\
           cvClassName,\
           CopyFrom         (ISequenceAsDilTableImpl const&),\
           ElementOf        (void const*) const,\
           GrowBy           (INumber),\
           IndexOf          (ICursorImpl const&),\
           Initialize       (INumber),\
           IsInBetween      (ICursorImpl const&),\
           IsRemoved        (INumber) const,\
           MakeFree         (INumber&),\
           NextIndexOf      (ICursorImpl const&),\
           OpsOf            (ISequenceAsDilTableImpl const&),\
           PositionAtIndex  (INumber) const,\
           PreviousIndexOf  (ICursorImpl const&),\
           RemoveAtIndex    (INumber),\
           SetInBetween     (MngCursor&) const,\
           SetToNextIndex   (INumber&) const,\
           SetToPreviousIndex\
                            (INumber&) const,\
           UpdateMngCursorsForCopyFrom\
                            (INumber, INumber) const,\
           UpdateMngCursorsForGrowBy\
                            () const,\
           UpdateMngCursorsForRemoveOf\
                            (INumber) const,\
           UpdateMngCursorsForSwap\
                            (INumber, INumber) const\
#if ! defined (__INO_STREAMING__)
           ,AddAsLastFromStreamer \
                            (IDataStream&, ICursorImpl&)\
           ,ConstructNodeWithStreamer \
                            (void*, IDataStream&) const\
           ,StreamerOf       (IACollectionImpl const&)\
           ,StreamIn         (IDataStream&)\
           ,StreamOut        (IDataStream&) const\
           ,AdoptStreamer    (IACollectionStreamer*)\
#endif
                       )
#endif

};

class IC_EXPORTC IASequenceAsDilTableOps {
public:

  virtual ~IASequenceAsDilTableOps
                            ();

  virtual
  void     Assign           (void*, void const*) const = 0;

  virtual
  IACollectionImpl*
           Clone            () const = 0;

  virtual
  void*    CreateNodes      (INumber, size_t&, size_t&) const = 0;

  virtual
  void     ConstructNode    (void*, void const*) const = 0;

  virtual
  void     DeleteNodes      (void*) const = 0;

  virtual
  void     DestroyNode      (void*) const = 0;

protected:

           IASequenceAsDilTableOps
                            (bool);

private:

  bool ivContainsDTSObjects;

  friend
  class    ISequenceAsDilTableImpl;

#if ! defined (__INO_STREAMING__)
public:
  virtual
  void     ConstructNodeWithStreamer
                         (void*, IACollectionStreamer*, IDataStream&) const = 0;
#endif

#if defined (__SOM_ENABLED__) && defined (__RRBC_LIB__)
#pragma SOMReleaseOrder (\
           Assign           (void*, void const*) const,\
           Clone            () const,\
           CreateNodes      (INumber, size_t&, size_t&) const,\
           ConstructNode    (void*, void const*) const,\
           DeleteNodes      (void*) const,\
           DestroyNode      (void*) const,\
           IASequenceAsDilTableOps\
                            (bool)\
#if ! defined (__INO_STREAMING__)
           ,ConstructNodeWithStreamer \
                         (void*, IACollectionStreamer*, IDataStream&) const\
#endif
                       )
#endif

};

template <class Element, class ElementOps, class Implementation>
class IC_EXPORTC ISequenceAsDilTableOps : public IASequenceAsDilTableOps {

  typedef  IASequenceAsDilTableOps Inherited;

  typedef  ISequenceAsDilTableOps
            <Element, ElementOps, Implementation> Self;

  typedef  ISequenceAsDilTableNodeImpl <Element> Node;

public:

  typedef  Implementation ImplType;

  typedef  Element ElementType;

  typedef  void KeyType;

           ISequenceAsDilTableOps
                            (INumber);

           ISequenceAsDilTableOps
                            (INumber, void*);

           ISequenceAsDilTableOps
                            (ISequenceAsDilTableOps
                              <Element, ElementOps,
                               Implementation> const&);

          ~ISequenceAsDilTableOps
                            ();

  void     Assign           (void*, void const*) const;

  IACollectionImpl*
           Clone            () const;

  void*    CreateNodes      (INumber, size_t&, size_t&) const;

  void     ConstructNode    (void*, void const*) const;

  void     DeleteNodes      (void*) const;

  void     DestroyNode      (void*) const;

           operator Implementation*
                            ();

#if defined (__OSTORE__)
  static
  os_typespec*
           get_os_typespec  ();

  static
  void     os_mark_schema_type ()
           {
#if ! defined (_AIX)
             OS_MARK_SCHEMA_TYPESPEC((Self));
             OS_MARK_SCHEMA_TYPESPEC((Self::Node));
#else
             { Self* _OSMT_ = 0; }
             { Self::Node* _OSMT_ = 0; }
#endif
           }
#endif

protected:

private:

  ElementOps
           ivElementOps;

  Implementation
           ivImpl;

#if ! defined (__INO_STREAMING__)
public:
  void     ConstructNodeWithStreamer
                            (void*, IACollectionStreamer*, IDataStream&) const;
#endif

#if defined (__SOM_ENABLED__) && defined (__RRBC_LIB__)
#pragma SOMReleaseOrder (\
           ISequenceAsDilTableOps\
                           (INumber),\
           ISequenceAsDilTableOps\
                           (INumber, void*),\
           operator Implementation*\
                           ()\
                        )
#endif

};

#pragma pack (pop)
#pragma enum (pop)

#if __IBMCPP__ >= 400
#pragma namemangling()
#endif

#if defined (__SOM_ENABLED__)
#pragma SOMAsDefault (pop)
#endif

#if defined (__OS2__) || defined (__OS400__) || defined (__WINDOWS__)
#pragma info (restore)
#endif

#include <iiseqdil.inl>

#if defined (_AIX)        || defined (__MVS__)   ||\
    defined (__OS2__)     || defined (__OS400__) ||\
    defined (__WINDOWS__)
#if ! defined (__TEMPINC__)
#include <iiseqdil.c>
#endif
#endif

#endif // _IISEQDIL_
