// IBM Open Class Library
//
// Licensed Materials - Property of IBM
//
// (C) Copyright IBM Corporation, 1992, 1997 All Rights Reserved
//
// Revision: 01 1.5.2.3 source/core/collect/iiseqdil.c, collection, ioc.v400, 001006 
#ifndef _IISEQDIL_C_
#define _IISEQDIL_C_

#include <new.h>

#if defined (__OS2__) || defined (__OS400__) || defined (__WINDOWS__)
#pragma info (nocls, nocnd, nocns, nocnv, noext, nognr, novft)
#endif

// -----------------------
// ISequenceAsDilTableImpl
// -----------------------

// public members

template <class Element, class ElementOps, class Implementation>
ISequenceAsDilTableOps <Element, ElementOps, Implementation>::
ISequenceAsDilTableOps (INumber numberOfElements)
: Inherited (__isDTSClass (Element)),
  ivElementOps (),
  ivImpl (*this, numberOfElements)
{
}

template <class Element, class ElementOps, class Implementation>
ISequenceAsDilTableOps <Element, ElementOps, Implementation>::
ISequenceAsDilTableOps (INumber numberOfElements, void* opsArg)
: Inherited (__isDTSClass (Element)),
  ivElementOps (opsArg),
  ivImpl (*this, numberOfElements)
{
}

template <class Element, class ElementOps, class Implementation>
ISequenceAsDilTableOps <Element, ElementOps, Implementation>::
ISequenceAsDilTableOps
  (ISequenceAsDilTableOps <Element, ElementOps,
                           Implementation> const& collection)
: Inherited (__isDTSClass (Element)),
  ivElementOps (collection.ivElementOps),
  ivImpl (*this, collection.ivImpl)
{
}

template <class Element, class ElementOps, class Implementation>
ISequenceAsDilTableOps <Element, ElementOps, Implementation>::
~ISequenceAsDilTableOps ()
{
}

template <class Element, class ElementOps, class Implementation>
void
ISequenceAsDilTableOps <Element, ElementOps, Implementation>::
Assign (void* element1, void const* element2) const
{ ivElementOps.Assign (*(Element*)element1,
                       *(Element const*)element2);
}

template <class Element, class ElementOps, class Implementation>
IACollectionImpl*
ISequenceAsDilTableOps <Element, ElementOps, Implementation>::
Clone () const
{ return (Implementation*) *new Self (*this);
}

template <class Element, class ElementOps, class Implementation>
void
ISequenceAsDilTableOps <Element, ElementOps, Implementation>::
ConstructNode (void* node, void const* element) const
{ new (node) Node (*(Element const*)element);
}

#if ! defined (__INO_STREAMING__)
template <class Element, class ElementOps, class Implementation>
void
ISequenceAsDilTableOps <Element, ElementOps, Implementation>::
ConstructNodeWithStreamer (void* node, IACollectionStreamer *streamer,
                           IDataStream& fromWhere) const
{ ((Node*)node)->StreamIn (streamer, fromWhere);
}
#endif

template <class Element, class ElementOps, class Implementation>
void*
ISequenceAsDilTableOps <Element, ElementOps, Implementation>::
CreateNodes (INumber n, size_t& size, size_t& offset) const
{ size = sizeof (Node) > 2 * sizeof (Node*) ?
         sizeof (Node) : 2 * sizeof (Node*);
#if __IBMCPP__ >= 400
#pragma report(level, E)
#endif 
  offset = offsetof(Node, ivElement);
#if __IBMCPP__ >= 400
#pragma report(pop)
#endif 
  void* node = ivElementOps.Allocate ((size_t) (size * n)
#if defined (__OS2__) || defined (__OS400__) || defined (__WINDOWS__) || defined (_AIX)
#if defined (__DEBUG_ALLOC__)
                                      , __FILE__, __LINE__
#endif
#endif
#if defined (__OSTORE__)
                                      , Node::get_os_typespec (), n
#endif
                                     );
  return ivImpl.CheckPointer (node);
}

template <class Element, class ElementOps, class Implementation>
void
ISequenceAsDilTableOps <Element, ElementOps, Implementation>::
DeleteNodes (void* nodes) const
{ ivElementOps.Deallocate (nodes
#if defined (__OS2__) || defined (__OS400__) || defined (__WINDOWS__) || defined (_AIX)
#if defined (__DEBUG_ALLOC__)
                           , __FILE__, __LINE__
#endif
#endif
                          );
}

template <class Element, class ElementOps, class Implementation>
void
ISequenceAsDilTableOps <Element, ElementOps, Implementation>::
DestroyNode (void* node) const
{ ((Node*)node)->~Node ();
}

template <class Element, class ElementOps, class Implementation>
ISequenceAsDilTableOps <Element, ElementOps, Implementation>::
operator Implementation* ()
{ ivImpl.CheckPointer (this);
  return &ivImpl;
}

#if defined (__OS2__) || defined (__OS400__) || defined (__WINDOWS__)
#pragma info (restore)
#endif

#endif // _IISEQDIL_C_
