// IBM Open Class Library
//
// Licensed Materials - Property of IBM
//
// (C) Copyright IBM Corporation, 1992, 1997 All Rights Reserved
//
// Revision: 91 1.6.1.4 source/core/collect/iisbdil.h, collection, ioc.v400, 001006 
#ifndef _IISBDIL_
#define _IISBDIL_

#include <iisbksb.h>
#include <iiksbdil.h>

#if defined (__OSTORE__)
#include <ostore/ostore.hh>
#include <ostore/manschem.hh>
#endif

#if defined (__OS2__) || defined (__OS400__) || defined (__WINDOWS__)
#pragma info (nocls, nocnd, nocns, nocnv, noext, nognr, novft)
#endif

#if defined (__SOM_ENABLED__)
#if defined (__RRBC_LIB__)
#pragma SOMAsDefault (on)
#else
#pragma SOMAsDefault (off)
#endif
#endif

#if __IBMCPP__ >= 400
#pragma namemangling(compat)
#endif

typedef ISortedBagOnKeySortedBagImpl
         <IKeySortedBagAsDilTableImpl> ISortedBagAsDilTableImpl;

typedef IASortedBagOnKeySortedBagOps
          <IKeySortedBagAsDilTableImpl> IASortedBagAsDilTableOps;

#pragma pack(push,4)
#pragma enum(4)

template <class Element, class ElementOps, class Implementation>
class IC_EXPORTC ISortedBagAsDilTableOps :
  public IASortedBagAsDilTableOps {

  typedef  IASortedBagAsDilTableOps Inherited;

  typedef  ISortedBagAsDilTableOps
            <Element, ElementOps, Implementation> Self;

  typedef  IKeySortedBagAsDilTableOps
            <Element, Element, IOpsWithKey <Element, ElementOps>,
             IKeySortedBagAsDilTableImpl > Base;

public:

  typedef  Implementation ImplType;

  typedef  Element ElementType;

  typedef  void KeyType;

           ISortedBagAsDilTableOps
                           (INumber);

           ISortedBagAsDilTableOps
                           (INumber, void*);

           ISortedBagAsDilTableOps
                           (ISortedBagAsDilTableOps
                             <Element, ElementOps,
                              Implementation> const&);

          ~ISortedBagAsDilTableOps
                           ();

  IACollectionImpl*
           Clone           () const;

           operator IKeySortedBagAsDilTableImpl&
                           ();

           operator Implementation*
                           ();

#if defined (__OSTORE__)
  static
  os_typespec*
           get_os_typespec ();

  static
  void     os_mark_schema_type ()
           {
             Base::os_mark_schema_type ();
#if ! defined (_AIX)
             OS_MARK_SCHEMA_TYPESPEC((Self)):
#else
             { Self* _OSMT_ = 0; }
#endif
           }
#endif

protected:

private:

  Base     ivBase;

  Implementation
           ivImpl;

#if defined (__SOM_ENABLED__) && defined (__RRBC_LIB__) 
#pragma SOMReleaseOrder (\
           ISortedBagAsDilTableOps\
                            (INumber),\
           ISortedBagAsDilTableOps\
                            (INumber, void*),\
           operator Implementation*\
                            ()\
                        )
#endif 

};

#pragma enum(pop)
#pragma pack(pop)

#if __IBMCPP__ >= 400
#pragma namemangling()
#endif

#if defined (__SOM_ENABLED__)
#pragma SOMAsDefault (pop)
#endif

#if defined (_AIX)        || defined (__MVS__)   ||\
    defined (__OS2__)     || defined (__OS400__) ||\
    defined (__WINDOWS__)
#if ! defined (__TEMPINC__)
#include <iisbdil.c>
#endif
#endif

#if defined (__OS2__) || defined (__OS400__) || defined (__WINDOWS__)
#pragma info (restore)
#endif

#endif // _IISBDIL_
