// IBM Open Class Library
//
// Licensed Materials - Property of IBM
//
// (C) Copyright IBM Corporation, 1992, 1997 All Rights Reserved
//
// Revision: 57 1.6.1.4 source/core/collect/iimapdil.h, collection, ioc.v400, 001006 
#ifndef _IIMAPDIL_
#define _IIMAPDIL_

#include <iimapks.h>
#include <iiksdil.h>

#if defined (__OSTORE__)
#include <ostore/ostore.hh>
#include <ostore/manschem.hh>
#endif

#if defined (__OS2__) || defined (__OS400__) || defined (__WINDOWS__)
#pragma info (nocls, nocnd, nocns, nocnv, noext, nognr, novft)
#endif

#if defined (__SOM_ENABLED__)
#if defined (__RRBC_LIB__)
#pragma SOMAsDefault (on)
#else
#pragma SOMAsDefault (off)
#endif
#endif

#if __IBMCPP__ >= 400
#pragma namemangling(compat)
#endif

typedef IMapOnKeySetImpl
         <IKeySetAsDilTableImpl> IMapAsDilTableImpl;

typedef IAMapOnKeySetOps
         <IKeySetAsDilTableImpl> IAMapAsAsDilTableOps;

#pragma pack(push,4)
#pragma enum(4)

template <class Element, class _Key,
          class ElementOps, class Implementation>
class IC_EXPORTC IMapAsDilTableOps :
  public IAMapAsAsDilTableOps {

  typedef  IMapAsDilTableOps
            <Element, _Key, ElementOps, Implementation> Self;

  typedef  IKeySetAsDilTableOps
            <Element, _Key,
             ElementOps, IKeySetAsDilTableImpl> Base;

public:

  typedef  Implementation ImplType;

  typedef  Element ElementType;

  typedef  _Key KeyType;

           IMapAsDilTableOps
                           (INumber);

           IMapAsDilTableOps
                           (INumber, void*);

           IMapAsDilTableOps
                           (IMapAsDilTableOps
                             <Element, _Key,
                              ElementOps, Implementation> const&);

          ~IMapAsDilTableOps
                           ();

  IACollectionImpl*
           Clone           () const;

  bool     EqualElements    (void const*, void const*) const;

           operator IKeySetAsDilTableImpl&
                           ();

           operator Implementation*
                           ();

#if defined (__OSTORE__)
  static
  os_typespec*
           get_os_typespec ();

  static
  void     os_mark_schema_type ()
           {
             Base::os_mark_schema_type ();
#if ! defined (_AIX)
             OS_MARK_SCHEMA_TYPESPEC((Self));
#else
             { Self* _OSMT_ = 0; }
#endif
           }
#endif

protected:

private:

  ElementOps
           ivElementOps;
 
  Base     ivBase;

  Implementation
           ivImpl;

#if defined (__SOM_ENABLED__) && defined (__RRBC_LIB__)
#pragma SOMReleaseOrder (\
           IMapAsDilTableOps\
                            (INumber),\
           IMapAsDilTableOps\
                            (INumber, void*),\
           operator Implementation*\
                            ()\
                        )
#endif

};

#pragma enum(pop)
#pragma pack(pop)

#if __IBMCPP__ >= 400
#pragma namemangling()
#endif

#if defined (__SOM_ENABLED__)
#pragma SOMAsDefault (pop)
#endif

#if defined (_AIX)        || defined (__MVS__)   ||\
    defined (__OS2__)     || defined (__OS400__) ||\
    defined (__WINDOWS__)
#if ! defined (__TEMPINC__)
#include <iimapdil.c>
#endif
#endif

#if defined (__OS2__) || defined (__OS400__) || defined (__WINDOWS__)
#pragma info (restore)
#endif

#endif // _IIMAPDIL_
