// IBM Open Class Library
//
// Licensed Materials - Property of IBM
//
// (C) Copyright IBM Corporation, 1992, 1997 All Rights Reserved
//
// Revision: 48 1.6.1.4 source/core/collect/iikstab.h, collection, ioc.v400, 001006 
#ifndef _IIKSTAB_
#define _IIKSTAB_

#include <iikskss.h>
#include <iiksstab.h>

#if defined (__OSTORE__)
#include <ostore/ostore.hh>
#include <ostore/manschem.hh>
#endif

#if defined (__OS2__) || defined (__OS400__) || defined (__WINDOWS__)
#pragma info (nocls, nocnd, nocns, nocnv, noext, nognr, novft)
#endif

#if defined (__SOM_ENABLED__)
#if defined (__RRBC_LIB__)
#pragma SOMAsDefault (on)
#else
#pragma SOMAsDefault (off)
#endif
#endif

#if __IBMCPP__ >= 400
#pragma namemangling(compat)
#endif

typedef IKeySetOnKeySortedSetImpl
         <IKeySortedSetAsTableImpl> IKeySetAsTableImpl;

typedef IAKeySetOnKeySortedSetOps
         <IKeySortedSetAsTableImpl> IAKeySetAsTableOps;

#pragma pack(push,4)
#pragma enum(4)

template <class Element, class Key,
          class ElementOps, class Implementation>
class IC_EXPORTC IKeySetAsTableOps :
  public IAKeySetAsTableOps {

  typedef  IKeySetAsTableOps
            <Element, Key, ElementOps, Implementation> Self;

  typedef  IKeySortedSetAsTableOps
            <Element, Key,
             ElementOps, IKeySortedSetAsTableImpl> Base;

public:

  typedef  Implementation ImplType;

  typedef  Element ElementType;

  typedef  Key KeyType;

           IKeySetAsTableOps
                           (INumber);

           IKeySetAsTableOps
                           (INumber, void*);

           IKeySetAsTableOps
                           (IKeySetAsTableOps
                             <Element, Key,
                              ElementOps, Implementation> const&);

          ~IKeySetAsTableOps
                           ();

  IACollectionImpl*
           Clone           () const;

           operator IKeySortedSetAsTableImpl&
                           ();

           operator Implementation*
                           ();

#if defined (__OSTORE__)
  static
  os_typespec*
           get_os_typespec ();

  static
  void     os_mark_schema_type ()
           {
             Base::os_mark_schema_type ();
#if ! defined (_AIX)
             OS_MARK_SCHEMA_TYPESPEC((Self));
#else
             { Self* _OSMT_ = 0; }
#endif
           }
#endif

protected:

private:

  Base     ivBase;

  Implementation
           ivImpl;

#if defined (__SOM_ENABLED__) && defined (__RRBC_LIB__)
#pragma SOMReleaseOrder (\
           IKeySetAsTableOps\
                           (INumber),\
           IKeySetAsTableOps\
                           (INumber, void*),\
           operator Implementation*\
                           ()\
                        )
#endif

};

#pragma enum(pop)
#pragma pack(pop)

#if __IBMCPP__ >= 400
#pragma namemangling()
#endif

#if defined (__SOM_ENABLED__)
#pragma SOMAsDefault (pop)
#endif

#if defined (_AIX)        || defined (__MVS__)   ||\
    defined (__OS2__)     || defined (__OS400__) ||\
    defined (__WINDOWS__)
#if ! defined (__TEMPINC__)
#include <iikstab.c>
#endif
#endif

#if defined (__OS2__) || defined (__OS400__) || defined (__WINDOWS__)
#pragma info (restore)
#endif

#endif // _IIKSTAB_
