// IBM Open Class Library
//
// Licensed Materials - Property of IBM
//
// (C) Copyright IBM Corporation, 1992, 1997 All Rights Reserved
//
// Revision: 25 1.6.1.4 source/core/collect/iikslst.h, collection, ioc.v400, 001006 
#ifndef _IIKSLST_
#define _IIKSLST_

#include <iikskss.h>
#include <iiksslst.h>

#if defined (__OSTORE__)
#include <ostore/ostore.hh>
#include <ostore/manschem.hh>
#endif

#if defined (__OS2__) || defined (__OS400__) || defined (__WINDOWS__)
#pragma info (nocls, nocnd, nocns, nocnv, noext, nognr, novft)
#endif

#if defined (__SOM_ENABLED__)
#if defined (__RRBC_LIB__)
#pragma SOMAsDefault (on)
#else
#pragma SOMAsDefault (off)
#endif
#endif

#if __IBMCPP__ >= 400
#pragma namemangling(compat)
#endif

typedef IKeySetOnKeySortedSetImpl
         <IKeySortedSetAsListImpl> IKeySetAsListImpl;

typedef IAKeySetOnKeySortedSetOps
         <IKeySortedSetAsListImpl> IAKeySetAsListOps;

#pragma pack(push,4)
#pragma enum(4)

template <class Element, class Key,
          class ElementOps, class Implementation>
class IC_EXPORTC IKeySetAsListOps :
  public IAKeySetAsListOps {

  typedef  IKeySetAsListOps
            <Element, Key, ElementOps, Implementation> Self;

  typedef  IKeySortedSetAsListOps
            <Element, Key,
             ElementOps, IKeySortedSetAsListImpl> Base;

public:

  typedef  Implementation ImplType;

  typedef  Element ElementType;

  typedef  Key KeyType;

           IKeySetAsListOps
                           (INumber);

           IKeySetAsListOps
                           (INumber, void*);

           IKeySetAsListOps
                           (IKeySetAsListOps
                             <Element, Key,
                              ElementOps, Implementation> const&);

          ~IKeySetAsListOps
                           ();

  IACollectionImpl*
           Clone           () const;

           operator IKeySortedSetAsListImpl&
                           ();

           operator Implementation*
                           ();

#if defined (__OSTORE__)
  static
  os_typespec*
           get_os_typespec ();

  static
  void     os_mark_schema_type ()
           {
             Base::os_mark_schema_type ();
#if ! defined (_AIX)
             OS_MARK_SCHEMA_TYPESPEC((Self));
#else
             { Self* _OSMT_ = 0; }
#endif
           }
#endif

protected:

private:

  Base     ivBase;

  Implementation
           ivImpl;

#if defined (__SOM_ENABLED__) && defined (__RRBC_LIB__)
#pragma SOMReleaseOrder (\
           IKeySetAsListOps\
                           (INumber),\
           IKeySetAsListOps\
                           (INumber, void*),\
           operator Implementation*\
                           ()\
                        )
#endif

};

#pragma enum(pop)
#pragma pack(pop)

#if __IBMCPP__ >= 400
#pragma namemangling()
#endif

#if defined (__SOM_ENABLED__)
#pragma SOMAsDefault (pop)
#endif

#if defined (_AIX)        || defined (__MVS__)   ||\
    defined (__OS2__)     || defined (__OS400__) ||\
    defined (__WINDOWS__)
#if ! defined (__TEMPINC__)
#include <iikslst.c>
#endif
#endif

#if defined (__OS2__) || defined (__OS400__) || defined (__WINDOWS__)
#pragma info (restore)
#endif

#endif // _IIKSLST_
