// IBM Open Class Library
//
// Licensed Materials - Property of IBM
//
// (C) Copyright IBM Corporation, 1992, 1997 All Rights Reserved
//
// Revision: 14 1.4.3.2 source/core/collect/iikshsh.c, collection, ioc.v400, 001006 
#ifndef _IIKSHSH_C_
#define _IIKSHSH_C_

#if defined (__OS2__) || defined (__OS400__) || defined (__WINDOWS__)
#pragma info (nocls, nocnd, nocns, nocnv, noext, nognr, novft)
#endif

#ifdef IC_BUILD
#define __IOC_INLINE
#else
#define __IOC_INLINE inline
#endif

// ---
// IKeySetAsHshTableOps
// ---

// public members

template <class Element, class Key,
          class ElementOps, class Implementation>
__IOC_INLINE
IKeySetAsHshTableOps <Element, Key, ElementOps, Implementation>::
IKeySetAsHshTableOps (INumber numberOfElements)
: ivBase (numberOfElements),
  ivImpl (*this, numberOfElements)
{
}

template <class Element, class Key,
          class ElementOps, class Implementation>
__IOC_INLINE
IKeySetAsHshTableOps <Element, Key, ElementOps, Implementation>::
IKeySetAsHshTableOps (INumber numberOfElements, void* opsArg)
: ivBase (numberOfElements, opsArg),
  ivImpl (*this, numberOfElements)
{
}

template <class Element, class Key,
          class ElementOps, class Implementation>
__IOC_INLINE
IKeySetAsHshTableOps <Element, Key, ElementOps, Implementation>::
IKeySetAsHshTableOps
  (IKeySetAsHshTableOps
    <Element, Key, ElementOps, Implementation> const& collection)
: ivBase (collection.ivBase),
  ivImpl (*this, collection.ivImpl)
{
}

template <class Element, class Key,
          class ElementOps, class Implementation>
__IOC_INLINE
IKeySetAsHshTableOps <Element, Key, ElementOps, Implementation>::
~IKeySetAsHshTableOps ()
{
}

template <class Element, class Key,
          class ElementOps, class Implementation>
__IOC_INLINE
IACollectionImpl*
IKeySetAsHshTableOps <Element, Key, ElementOps, Implementation>::
Clone () const
{ return (Implementation*) *new Self (*this);
}

template <class Element, class Key,
          class ElementOps, class Implementation>
__IOC_INLINE
IKeySetAsHshTableOps <Element, Key, ElementOps, Implementation>::
operator IKeyBagAsHshTableImpl& ()
{ return *(IKeyBagAsHshTableImpl*)ivBase;
}

template <class Element, class Key,
          class ElementOps, class Implementation>
__IOC_INLINE
IKeySetAsHshTableOps <Element, Key, ElementOps, Implementation>::
operator Implementation* ()
{ ivImpl.CheckPointer (this);
  return &ivImpl;
}

#if defined (__OS2__) || defined (__OS400__) || defined (__WINDOWS__)
#pragma info (restore)
#endif

#endif // _IIKSHSH_C_
