// IBM Open Class Library
//
// Licensed Materials - Property of IBM
//
// (C) Copyright IBM Corporation, 1992, 1997 All Rights Reserved
//
// Revision: 93 1.4.3.2 source/core/collect/iiksavl.c, collection, ioc.v400, 001006 
#ifndef _IIKSAVL_C_
#define _IIKSAVL_C_

#if defined (__OS2__) || defined (__OS400__) || defined (__WINDOWS__)
#pragma info (nocls, nocnd, nocns, nocnv, noext, nognr, novft)
#endif

#ifdef IC_BUILD
#define __IOC_INLINE
#else
#define __IOC_INLINE inline
#endif

// ---
// IKeySetAsAvlTreeOps
// ---

// public members

template <class Element, class Key,
          class ElementOps, class Implementation>
__IOC_INLINE
IKeySetAsAvlTreeOps <Element, Key, ElementOps, Implementation>::
IKeySetAsAvlTreeOps (INumber numberOfElements)
: ivBase (numberOfElements),
  ivImpl (*this, numberOfElements)
{
}

template <class Element, class Key,
          class ElementOps, class Implementation>
__IOC_INLINE
IKeySetAsAvlTreeOps <Element, Key, ElementOps, Implementation>::
IKeySetAsAvlTreeOps (INumber numberOfElements, void* opsArg)
: ivBase (numberOfElements, opsArg),
  ivImpl (*this, numberOfElements)
{
}

template <class Element, class Key,
          class ElementOps, class Implementation>
__IOC_INLINE
IKeySetAsAvlTreeOps <Element, Key, ElementOps, Implementation>::
IKeySetAsAvlTreeOps
  (IKeySetAsAvlTreeOps
    <Element, Key, ElementOps, Implementation> const& collection)
: ivBase (collection.ivBase),
  ivImpl (*this, collection.ivImpl)
{
}

template <class Element, class Key,
          class ElementOps, class Implementation>
__IOC_INLINE
IKeySetAsAvlTreeOps <Element, Key, ElementOps, Implementation>::
~IKeySetAsAvlTreeOps ()
{
}

template <class Element, class Key,
          class ElementOps, class Implementation>
__IOC_INLINE
IACollectionImpl*
IKeySetAsAvlTreeOps <Element, Key, ElementOps, Implementation>::
Clone () const
{ return (Implementation*) *new Self (*this);
}

template <class Element, class Key,
          class ElementOps, class Implementation>
__IOC_INLINE
IKeySetAsAvlTreeOps <Element, Key, ElementOps, Implementation>::
operator IKeySortedSetAsAvlTreeImpl& ()
{ return *(IKeySortedSetAsAvlTreeImpl*)ivBase ;
}

template <class Element, class Key,
          class ElementOps, class Implementation>
__IOC_INLINE
IKeySetAsAvlTreeOps <Element, Key, ElementOps, Implementation>::
operator Implementation* ()
{ ivImpl.CheckPointer (this);
  return &ivImpl ;
}

#if defined (__OS2__) || defined (__OS400__) || defined (__WINDOWS__)
#pragma info (restore)
#endif

#endif // _IIKSAVL_C_
