// IBM Open Class Library
//
// Licensed Materials - Property of IBM
//
// (C) Copyright IBM Corporation, 1992, 1997 All Rights Reserved
//
// Revision: 59 1.6.1.4 source/core/collect/iiestab.h, collection, ioc.v400, 001006 
#ifndef _IIESTAB_
#define _IIESTAB_

#include <iiesseq.h>
#include <iiseqtab.h>

#if defined (__OSTORE__)
#include <ostore/ostore.hh>
#include <ostore/manschem.hh>
#endif

#if defined (__OS2__) || defined (__OS400__) || defined (__WINDOWS__)
#pragma info (nocls, nocnd, nocns, nocnv, noext, nognr, novft)
#endif

#if defined (__SOM_ENABLED__)
#if defined (__RRBC_LIB__)
#pragma SOMAsDefault (on)
#else
#pragma SOMAsDefault (off)
#endif
#endif

#if __IBMCPP__ >= 400
#pragma namemangling(compat)
#endif

typedef IEqualitySequenceOnSequenceImpl
         <ISequenceAsTableImpl> IEqualitySequenceAsTableImpl;

typedef IAEqualitySequenceOnSequenceOps
         <ISequenceAsTableImpl> IAEqualitySequenceAsTableOps;

#pragma pack(push,4)
#pragma enum(4)

template <class Element, class ElementOps, class Implementation>
class IC_EXPORTC IEqualitySequenceAsTableOps :
  public IAEqualitySequenceAsTableOps {

  typedef  IEqualitySequenceAsTableOps
            <Element, ElementOps, Implementation> Self;

  typedef  ISequenceAsTableOps
            <Element, ElementOps, ISequenceAsTableImpl> Base;

public:

  typedef  Implementation ImplType;

  typedef  Element ElementType;

  typedef  void KeyType;

           IEqualitySequenceAsTableOps
                           (INumber);

           IEqualitySequenceAsTableOps
                           (INumber, void*);

           IEqualitySequenceAsTableOps
                           (IEqualitySequenceAsTableOps
                             <Element, ElementOps,
                              Implementation> const&);

          ~IEqualitySequenceAsTableOps
                           ();

  IACollectionImpl*
           Clone           () const;

  bool     EqualElements   (void const*, void const*) const;

           operator ISequenceAsTableImpl&
                           ();

           operator Implementation*
                           ();

#if defined (__OSTORE__)
  static
  os_typespec*
           get_os_typespec ();

  static
  void     os_mark_schema_type ()
           {
             Base::os_mark_schema_type ();
#if ! defined (_AIX)
             OS_MARK_SCHEMA_TYPESPEC((Self));
#else
             { Self* _OSMT_ = 0; }
#endif
           }
#endif

protected:

private:

  ElementOps
           ivElementOps;
 
  Base     ivBase;

  Implementation
           ivImpl;

#if defined (__SOM_ENABLED__) && defined (__RRBC_LIB__)
#pragma SOMReleaseOrder (\
           IEqualitySequenceAsTableOps\
                            (INumber),\
           IEqualitySequenceAsTableOps\
                            (INumber, void*),\
           operator Implementation*\
                            ()\
                        )
#endif

};

#pragma enum(pop)
#pragma pack(pop)

#if __IBMCPP__ >= 400
#pragma namemangling()
#endif

#if defined (__SOM_ENABLED__)
#pragma SOMAsDefault (pop)
#endif

#if defined (_AIX)        || defined (__MVS__)   ||\
    defined (__OS2__)     || defined (__OS400__) ||\
    defined (__WINDOWS__)
#if ! defined (__TEMPINC__)
#include <iiestab.c>
#endif
#endif

#if defined (__OS2__) || defined (__OS400__) || defined (__WINDOWS__)
#pragma info (restore)
#endif

#endif // _IIESTAB_
