// IBM Open Class Library
//
// Licensed Materials - Property of IBM
//
// (C) Copyright IBM Corporation, 1992, 1997 All Rights Reserved
//
// Revision: 43 1.6.1.5 source/core/collect/iicsm.h, collection, ioc.v400, 001006 
#ifndef _IICSM_
#define _IICSM_

#include <ilanglvl.hpp>
#include <iiasm.h>

#if defined (__SOM_ENABLED__)
#if defined (__RRBC_LIB__)
#pragma SOMAsDefault (on)
#else
#pragma SOMAsDefault (off)
#endif
#endif

#if defined (__OS2__) || defined (__OS400__) || defined (__WINDOWS__)
#pragma info (nocls, nocnd, nocns, nocnv, noext, nognr, novft)
#endif

#if __IBMCPP__ >= 400
#pragma namemangling(compat)
#endif

#pragma pack(push,4)
#pragma enum(4)

template <class CInherited>
class ICSortedMapImpl : public CInherited {
public:

  typedef TYPENAME CInherited::Ops Ops;

           ICSortedMapImpl
                            (Ops&, INumber);

           ICSortedMapImpl
                            (Ops&, ICSortedMapImpl
                                    <CInherited> const&);

  bool     Add              (void const*, ICursorImpl&);

  void     AddAllFrom       (IACollectionImpl const&);

  bool     AddOrReplaceElementWithKey
                            (void const*, ICursorImpl&);

  void*    Any              () const;

  void*    ElementAt        (ICursorImpl const&) const;

  void*    ElementAtPosition
                            (IPosition) const;

  void*    ElementWithKey   (void const*) const;

  void*    First            () const;

  bool     IsFirstAt        (ICursorImpl const&) const;

  bool     IsLastAt         (ICursorImpl const&) const;

  void*    Last             () const;

  bool     Locate           (void const*, ICursorImpl&) const;

  bool     LocateElementWithKey
                            (void const*, ICursorImpl&) const;

  bool     LocateNext       (void const*, ICursorImpl&) const;

  bool     LocateNextElementWithKey
                            (void const*, ICursorImpl&) const;

  bool     LocateOrAdd      (void const*, ICursorImpl&);

  bool     LocateOrAddElementWithKey
                            (void const*, ICursorImpl&);

  IPosition
           PositionAt       (ICursorImpl const&) const;

  void     RemoveAt         (ICursorImpl&);

  void     RemoveAtPosition (IPosition);

  void     RemoveFirst      ();

  void     RemoveLast       ();

  void     ReplaceAt        (ICursorImpl const& cursor,
                             void const*);

  void     ReplaceAtPosition
                            (IPosition, void const*);

  bool     ReplaceElementWithKey
                            (void const*, ICursorImpl&);

  bool     SetToFirst       (ICursorImpl&) const;

  bool     SetToLast        (ICursorImpl&) const;

  bool     SetToNext        (ICursorImpl&) const;

  bool     SetToNextWithDifferentKey
                            (ICursorImpl&) const;

  void     SetToPosition    (IPosition, ICursorImpl&) const;

  bool     SetToPrevious    (ICursorImpl&) const;

protected:

private:

#if defined (__SOM_ENABLED__) && defined (__RRBC_LIB__)
#pragma SOMClassVersion (*, 5, 0)
#pragma SOMReleaseOrder (\
           ICSortedMapImpl\
                            (Ops&, INumber),\
           ICSortedMapImpl\
                            (Ops&, ICSortedMapImpl\
                                    <CInherited> const&)\
                        )
#endif

};

#pragma enum(pop)
#pragma pack(pop)

#if __IBMCPP__ >= 400
#pragma namemangling()
#endif

#if defined (__SOM_ENABLED__)
#pragma SOMAsDefault (pop)
#endif

#if defined (_AIX)        || defined (__MVS__)   ||\
    defined (__OS2__)     || defined (__OS400__) ||\
    defined (__WINDOWS__)

#ifndef IC_BUILD
#include <iicsm.c>
#else
#if ! defined (__TEMPINC__)
#include <iicsm.c>
#endif
#endif

#endif

#if defined (__OS2__) || defined (__OS400__) || defined (__WINDOWS__)
#pragma info (restore)
#endif

#endif // _IICSM_
