// IBM Open Class Library
//
// Licensed Materials - Property of IBM
//
// (C) Copyright IBM Corporation, 1992, 1997 All Rights Reserved
//
// Revision: 39 1.6.1.5 source/core/collect/iicseq.h, collection, ioc.v400, 001006 
#ifndef _IICSEQ_
#define _IICSEQ_

#include <ilanglvl.hpp>
#include <iiaseq.h>

#if defined (__SOM_ENABLED__)
#if defined (__RRBC_LIB__)
#pragma SOMAsDefault (on)
#else
#pragma SOMAsDefault (off)
#endif
#endif

#if defined (__OS2__) || defined (__OS400__) || defined (__WINDOWS__)
#pragma info (nocls, nocnd, nocns, nocnv, noext, nognr, novft)
#endif

#if __IBMCPP__ >= 400
#pragma namemangling(compat)
#endif

#pragma pack(push,4)
#pragma enum(4)

template <class CInherited>
class ICSequenceImpl : public CInherited {
public:

  typedef TYPENAME CInherited::Ops Ops;

           ICSequenceImpl
                            (Ops&, INumber);

           ICSequenceImpl
                            (Ops&, ICSequenceImpl
                                    <CInherited> const&);

  bool     Add              (void const*, ICursorImpl&);

  void     AddAllFrom       (IACollectionImpl const&);

  void     AddAsFirst       (void const*, ICursorImpl&);

  void     AddAsLast        (void const*, ICursorImpl&);

  void     AddAsNext        (void const*, ICursorImpl&);

  void     AddAsPrevious    (void const*, ICursorImpl&);

  void     AddAtPosition    (IPosition, void const*, ICursorImpl&);

  void*    Any              () const;

  void*    ElementAt        (ICursorImpl const&) const;

  void*    ElementAtPosition
                            (IPosition) const;

  void*    First            () const;

  bool     IsFirstAt        (ICursorImpl const&) const;

  bool     IsLastAt         (ICursorImpl const&) const;

  void*    Last             () const;

  IPosition
           PositionAt       (ICursorImpl const&) const;

  void     RemoveAt         (ICursorImpl&);

  void     RemoveAtPosition (IPosition);

  void     RemoveFirst      ();

  void     RemoveLast       ();

  void     ReplaceAt        (ICursorImpl const& cursor,
                             void const*);

  void     ReplaceAtPosition
                            (IPosition, void const*);

  bool     SetToFirst       (ICursorImpl&) const;

  bool     SetToLast        (ICursorImpl&) const;

  bool     SetToNext        (ICursorImpl&) const;

  void     SetToPosition    (IPosition, ICursorImpl&) const;

  bool     SetToPrevious    (ICursorImpl&) const;

protected:

private:

#if defined (__SOM_ENABLED__) && defined (__RRBC_LIB__)
#pragma SOMClassVersion (*, 5, 0)
#pragma SOMReleaseOrder (\
           ICSequenceImpl\
                            (Ops&, INumber),\
           ICSequenceImpl\
                            (Ops&, ICSequenceImpl\
                                    <CInherited> const&)\
                        )
#endif

};

#pragma enum(pop)
#pragma pack(pop)

#if __IBMCPP__ >= 400
#pragma namemangling()
#endif

#if defined (__SOM_ENABLED__)
#pragma SOMAsDefault (pop)
#endif

#if defined (_AIX)        || defined (__MVS__)   ||\
    defined (__OS2__)     || defined (__OS400__) ||\
    defined (__WINDOWS__)

#ifndef IC_BUILD
#include <iicseq.c>
#else
#if ! defined (__TEMPINC__)
#include <iicseq.c>
#endif
#endif

#endif

#if defined (__OS2__) || defined (__OS400__) || defined (__WINDOWS__)
#pragma info (restore)
#endif

#endif // _IICSEQ_
