// IBM Open Class Library
//
// Licensed Materials - Property of IBM
//
// (C) Copyright IBM Corporation, 1992, 1997 All Rights Reserved
//
// Revision: 38 1.5.1.4 source/core/collect/iicseq.c, collection, ioc.v400, 001006 
#ifndef _IICSEQ_C_
#define _IICSEQ_C_

#include <iiexc.h>

#if defined (__OS2__) || defined (__OS400__) || defined (__WINDOWS__)
#pragma info (nocls, nocnd, nocns, nocnv, noext, nognr, novft)
#endif

#ifdef IC_BUILD
#define __IOC_INLINE
#else
#define __IOC_INLINE inline
#endif


// ---
// ICSequenceImpl
// ---

// public members

template <class CInherited>
__IOC_INLINE
ICSequenceImpl <CInherited>::
ICSequenceImpl (Ops& ops, INumber numberOfElements)
: CInherited (ops, numberOfElements)
{
}

template <class CInherited>
__IOC_INLINE
ICSequenceImpl <CInherited>::
ICSequenceImpl
  (Ops& ops, ICSequenceImpl <CInherited> const& collection)
: CInherited (ops, collection)
{
}

template <class CInherited>
__IOC_INLINE
bool
ICSequenceImpl <CInherited>::
Add (void const* element, ICursorImpl& cursor)
{ ICHECK_IsFor      (this->ClassName (), "Add")

  bool hasBeenAdded = CInherited::Add (element, cursor);
  return hasBeenAdded;
}

template <class CInherited>
__IOC_INLINE
void
ICSequenceImpl <CInherited>::
AddAllFrom (IACollectionImpl const& collection)
{ ICHECK_Identical (this->ClassName (), "AddAllFrom")

  CInherited::AddAllFrom (collection);
}

template <class CInherited>
__IOC_INLINE
void
ICSequenceImpl <CInherited>::
AddAsFirst (void const* element, ICursorImpl& cursor)
{ ICHECK_IsFor (this->ClassName (), "AddAsFirst")

  CInherited::AddAsFirst (element, cursor);
}

template <class CInherited>
__IOC_INLINE
void
ICSequenceImpl <CInherited>::
AddAsLast (void const* element, ICursorImpl& cursor)
{ ICHECK_IsFor (this->ClassName (), "AddAsLast")

  CInherited::AddAsLast (element, cursor);
}

template <class CInherited>
__IOC_INLINE
void
ICSequenceImpl <CInherited>::
AddAsNext (void const* element, ICursorImpl& cursor)
{ ICHECK_IsFor   (this->ClassName (), "AddAsNext")
  ICHECK_IsValid (this->ClassName (), "AddAsNext")
#if defined (IALL_CHECKS)
  ICHECK_Cursor  (this->ClassName (), "AddAsNext")
#endif

  CInherited::AddAsNext (element, cursor);
}

template <class CInherited>
__IOC_INLINE
void
ICSequenceImpl <CInherited>::
AddAsPrevious (void const* element, ICursorImpl& cursor)
{ ICHECK_IsFor   (this->ClassName (), "AddAsPrevious")
  ICHECK_IsValid (this->ClassName (), "AddAsPrevious")
#if defined (IALL_CHECKS)
  ICHECK_Cursor  (this->ClassName (), "AddAsPrevious")
#endif

  CInherited::AddAsPrevious (element, cursor);
}

template <class CInherited>
__IOC_INLINE
void
ICSequenceImpl <CInherited>::
AddAtPosition (IPosition position,
               void const* element,
               ICursorImpl& cursor)
{ ICHECK_IsFor     (this->ClassName (), "AddAtPosition")
  ICHECK_Position2 (this->ClassName (), "AddAtPosition")

  CInherited::AddAtPosition (position, element, cursor);
}

template <class CInherited>
__IOC_INLINE
void*
ICSequenceImpl <CInherited>::
Any () const
{ ICHECK_IsEmpty (this->ClassName (), "Any")

  return CInherited::Any ();
}

template <class CInherited>
__IOC_INLINE
void*
ICSequenceImpl <CInherited>::
ElementAt (ICursorImpl const& cursor) const
{ ICHECK_IsFor        (this->ClassName (), "ElementAt")
  ICHECK_IsValid      (this->ClassName (), "ElementAt")
#if ! defined (__INO_MNGCURSOR__)
  ICHECK_NotInBetween (this->ClassName (), "ElementAt")
#endif
#if defined (IALL_CHECKS)
  ICHECK_Cursor       (this->ClassName (), "ElementAt")
#endif

  return CInherited::ElementAt (cursor);
}

template <class CInherited>
__IOC_INLINE
void*
ICSequenceImpl <CInherited>::
ElementAtPosition (IPosition position) const
{ ICHECK_Position (this->ClassName (), "ElementAtPosition")

  return CInherited::ElementAtPosition (position);
}

template <class CInherited>
__IOC_INLINE
void*
ICSequenceImpl <CInherited>::
First () const
{ ICHECK_IsEmpty (this->ClassName (), "First")

  return CInherited::First ();
}

template <class CInherited>
__IOC_INLINE
bool
ICSequenceImpl <CInherited>::
IsFirstAt (ICursorImpl const& cursor) const
{ ICHECK_IsFor        (this->ClassName (), "IsFirstAt")
  ICHECK_IsValid      (this->ClassName (), "IsFirstAt")
#if ! defined (__INO_MNGCURSOR__)
  ICHECK_NotInBetween (this->ClassName (), "IsFirstAt")
#endif
#if defined (IALL_CHECKS)
  ICHECK_Cursor       (this->ClassName (), "IsFirstAt")
#endif

  return CInherited::IsFirstAt (cursor);
}

template <class CInherited>
__IOC_INLINE
bool
ICSequenceImpl <CInherited>::
IsLastAt (ICursorImpl const& cursor) const
{ ICHECK_IsFor        (this->ClassName (), "IsLastAt")
  ICHECK_IsValid      (this->ClassName (), "IsLastAt")
#if ! defined (__INO_MNGCURSOR__)
  ICHECK_NotInBetween (this->ClassName (), "IsLastAt")
#endif
#if defined (IALL_CHECKS)
  ICHECK_Cursor       (this->ClassName (), "IsLastAt")
#endif

  return CInherited::IsLastAt (cursor);
}

template <class CInherited>
__IOC_INLINE
void*
ICSequenceImpl <CInherited>::
Last () const
{ ICHECK_IsEmpty (this->ClassName (), "Last")

  return CInherited::Last ();
}

template <class CInherited>
__IOC_INLINE
IPosition
ICSequenceImpl <CInherited>::
PositionAt (ICursorImpl const& cursor) const
{ ICHECK_IsFor        (this->ClassName (), "PositionAt")
  ICHECK_IsValid      (this->ClassName (), "PositionAt")
#if ! defined (__INO_MNGCURSOR__)
  ICHECK_NotInBetween (this->ClassName (), "PositionAt")
#endif
#if defined (IALL_CHECKS)
  ICHECK_Cursor       (this->ClassName (), "PositionAt")
#endif

  return CInherited::PositionAt (cursor);
}

template <class CInherited>
__IOC_INLINE
void
ICSequenceImpl <CInherited>::
RemoveAt (ICursorImpl& cursor)
{ ICHECK_IsFor        (this->ClassName (), "RemoveAt")
  ICHECK_IsValid      (this->ClassName (), "RemoveAt")
#if ! defined (__INO_MNGCURSOR__)
  ICHECK_NotInBetween (this->ClassName (), "RemoveAt")
#endif
#if defined (IALL_CHECKS)
  ICHECK_Cursor       (this->ClassName (), "RemoveAt")
#endif

  CInherited::RemoveAt (cursor);
}

template <class CInherited>
__IOC_INLINE
void
ICSequenceImpl <CInherited>::
RemoveAtPosition (IPosition position)
{ ICHECK_Position (this->ClassName (), "RemoveAtPosition")

  CInherited::RemoveAtPosition (position);
}

template <class CInherited>
__IOC_INLINE
void
ICSequenceImpl <CInherited>::
RemoveFirst ()
{ ICHECK_IsEmpty (this->ClassName (), "RemoveFirst")

  CInherited::RemoveFirst ();
}

template <class CInherited>
__IOC_INLINE
void
ICSequenceImpl <CInherited>::
RemoveLast ()
{ ICHECK_IsEmpty (this->ClassName (), "RemoveLast")

  CInherited::RemoveLast ();
}

template <class CInherited>
__IOC_INLINE
void
ICSequenceImpl <CInherited>::
ReplaceAt (ICursorImpl const& cursor, void const* element)
{ ICHECK_IsFor        (this->ClassName (), "ReplaceAt")
  ICHECK_IsValid      (this->ClassName (), "ReplaceAt")
#if ! defined (__INO_MNGCURSOR__)
  ICHECK_NotInBetween (this->ClassName (), "ReplaceAt")
#endif
#if defined (IALL_CHECKS)
  ICHECK_Cursor       (this->ClassName (), "ReplaceAt")
#endif

  CInherited::ReplaceAt (cursor, element);
}

template <class CInherited>
__IOC_INLINE
void
ICSequenceImpl <CInherited>::
ReplaceAtPosition (IPosition position, void const* element)
{ ICHECK_Position    (this->ClassName (), "ReplaceAtPosition")

  CInherited::ReplaceAtPosition (position, element);
}

template <class CInherited>
__IOC_INLINE
bool
ICSequenceImpl <CInherited>::
SetToFirst (ICursorImpl& cursor) const
{ ICHECK_IsFor (this->ClassName (), "SetToFirst")

  return CInherited::SetToFirst (cursor);
}

template <class CInherited>
__IOC_INLINE
bool
ICSequenceImpl <CInherited>::
SetToLast (ICursorImpl& cursor) const
{ ICHECK_IsFor (this->ClassName (), "SetToLast")

  return CInherited::SetToLast (cursor);
}

template <class CInherited>
__IOC_INLINE
bool
ICSequenceImpl <CInherited>::
SetToNext (ICursorImpl& cursor) const
{ ICHECK_IsFor   (this->ClassName (), "SetToNext")
  ICHECK_IsValid (this->ClassName (), "SetToNext")
#if defined (IALL_CHECKS)
  ICHECK_Cursor  (this->ClassName (), "SetToNext")
#endif

  return CInherited::SetToNext (cursor);
}

template <class CInherited>
__IOC_INLINE
void
ICSequenceImpl <CInherited>::
SetToPosition (IPosition position, ICursorImpl& cursor) const
{ ICHECK_IsFor     (this->ClassName (), "SetToPosition")
  ICHECK_Position  (this->ClassName (), "SetToPosition")

  CInherited::SetToPosition (position, cursor);
}

template <class CInherited>
__IOC_INLINE
bool
ICSequenceImpl <CInherited>::
SetToPrevious (ICursorImpl& cursor) const
{ ICHECK_IsFor   (this->ClassName (), "SetToPrevious")
  ICHECK_IsValid (this->ClassName (), "SetToPrevious")
#if defined (IALL_CHECKS)
  ICHECK_Cursor  (this->ClassName (), "SetToPrevious")
#endif

  return CInherited::SetToPrevious (cursor);
}

#if defined (__OS2__) || defined (__OS400__) || defined (__WINDOWS__)
#pragma info (restore)
#endif

#endif // _IICSEQ_C_
