// IBM Open Class Library
//
// Licensed Materials - Property of IBM
//
// (C) Copyright IBM Corporation, 1992, 1997 All Rights Reserved
//
// Revision: 06 1.6.1.4 source/core/collect/iibaghsh.h, collection, ioc.v400, 001006 
#ifndef _IIBAGHSH_
#define _IIBAGHSH_

#include <iibagkb.h>
#include <iikbhsh.h>

#if defined (__OSTORE__)
#include <ostore/ostore.hh>
#include <ostore/manschem.hh>
#endif

#if defined (__OS2__) || defined (__OS400__) || defined (__WINDOWS__)
#pragma info (nocls, nocnd, nocns, nocnv, noext, nognr, novft)
#endif

#if defined (__SOM_ENABLED__)
#if defined (__RRBC_LIB__)
#pragma SOMAsDefault (on)
#else
#pragma SOMAsDefault (off)
#endif
#endif

#if __IBMCPP__ >= 400
#pragma namemangling(compat)
#endif

typedef IBagOnKeyBagImpl
         <IKeyBagAsHshTableImpl> IBagAsHshTableImpl;

typedef IABagOnKeyBagOps
         <IKeyBagAsHshTableImpl> IABagAsHshTableOps;

#pragma pack(push,4)
#pragma enum(4)

template <class Element, class ElementOps, class Implementation>
class IC_EXPORTC IBagAsHshTableOps :
  public IABagAsHshTableOps {

  typedef  IABagAsHshTableOps Inherited;

  typedef  IBagAsHshTableOps
            <Element, ElementOps, Implementation> Self;

  typedef  IKeyBagAsHshTableOps
            <Element, Element, IOpsWithKey <Element, ElementOps>,
             IKeyBagAsHshTableImpl> Base;

public:

  typedef  Implementation ImplType;

  typedef  Element ElementType;

  typedef  void KeyType;

           IBagAsHshTableOps
                           (INumber);

           IBagAsHshTableOps
                           (INumber, void*);

           IBagAsHshTableOps
                           (IBagAsHshTableOps
                             <Element, ElementOps,
                              Implementation> const&);

          ~IBagAsHshTableOps
                           ();

  IACollectionImpl*
           Clone           () const;

           operator IKeyBagAsHshTableImpl&
                           ();

           operator Implementation*
                           ();

#if defined (__OSTORE__)
  static
  os_typespec*
           get_os_typespec ();

  static
  void     os_mark_schema_type ()
           {
             Base::os_mark_schema_type ();
#if ! defined (_AIX)
             OS_MARK_SCHEMA_TYPESPEC((Self)):
#else
             { Self* _OSMT_ = 0; }
#endif
           }
#endif

protected:

private:

  Base     ivBase;

  Implementation
           ivImpl;

#if defined (__SOM_ENABLED__) && defined (__RRBC_LIB__) 
#pragma SOMReleaseOrder (\
           IBagAsHshTableOps\
                            (INumber),\
           IBagAsHshTableOps\
                            (INumber, void*),\
           operator Implementation*\
                            ()\
                        )
#endif 

};

#pragma enum(pop)
#pragma pack(pop)

#if __IBMCPP__ >= 400
#pragma namemangling()
#endif

#if defined (__SOM_ENABLED__)
#pragma SOMAsDefault (pop)
#endif

#if defined (_AIX)        || defined (__MVS__)   ||\
    defined (__OS2__)     || defined (__OS400__) ||\
    defined (__WINDOWS__)
#if ! defined (__TEMPINC__)
#include <iibaghsh.c>
#endif
#endif

#if defined (__OS2__) || defined (__OS400__) || defined (__WINDOWS__)
#pragma info (restore)
#endif

#endif // _IIBAGHSH_
