// IBM Open Class Library
//
// Licensed Materials - Property of IBM
//
// (C) Copyright IBM Corporation, 1992, 1997 All Rights Reserved
//
// Revision: 65 1.6.1.5 source/core/collect/iarstrct.h, collection, ioc.v400, 001006 
#ifndef _IARSTRCT_
#define _IARSTRCT_

#include <ibcllct.h>

#if defined (__OS2__) || defined (__OS400__) || defined (__WINDOWS__)
#pragma info (nocls, nocnd, nocns, nocnv, noext, nognr, novft)
#endif

#if defined (__SOM_ENABLED__)
#if defined (__RRBC_IBM__)
#pragma SOMAsDefault (on)
#else
#pragma SOMAsDefault (off)
#endif
#endif

#if __IBMCPP__ >= 400
#pragma namemangling(compat)
#endif

#pragma pack(push,4)
#pragma enum(4)

#if ! defined(__INO_L1_LOCKING__)
template <class Element>
class IRestrictedAccessCollectionGuard
{
public:
  IRestrictedAccessCollectionGuard
      (IARestrictedAccessCollection<Element>&, long timeout=-1);

  ~IRestrictedAccessCollectionGuard ();

private:

  IARestrictedAccessCollection<Element>& ivCollection;

  IRestrictedAccessCollectionGuard
      (const IRestrictedAccessCollectionGuard<Element>&);

  IRestrictedAccessCollectionGuard<Element>
      &operator= (const IRestrictedAccessCollectionGuard<Element>&);

#if defined (__SOM_ENABLED__) && defined (__RRBC_IBM__)
#pragma SOMDefine (*)
#pragma SOMClassVersion (*, 5, 0)
#pragma SOMReleaseOrder (\
                         IRestrictedAccessCollectionGuard(\
                          IARestrictedAccessCollection<Element>&,\
                          long timeout=-1),\
                         operator= \
                          (const IRestrictedAccessCollectionGuard<Element>&)\
                        )
#endif
};
#endif

template <class Element>
class IARestrictedAccessCollection : protected IACollectionBase {

  typedef  IACollectionImpl Implementation;

public:

#if ! defined (__INO_AVALON__)
           IARestrictedAccessCollection
                            (INotifier&);

#endif
  virtual ~IARestrictedAccessCollection
                            ();

#if ! defined (INO_VIRTUAL)
  virtual
#endif
  bool add              (Element const&);

#if ! defined (INO_VIRTUAL)
  virtual
#endif
  bool add              (Element const&, ICursor&);

#if ! defined (INO_VIRTUAL)
  virtual
#endif
  void     addAllFrom       (IARestrictedAccessCollection
                              <Element> const&);

  bool allElementsDo    (bool (*applicatorFunction)
                              (Element const&, void*),
                             void* additionalArgument = 0) const;

  bool allElementsDo    (IConstantApplicator <Element>&) const;

  Element const&
           any              () const;

#if ! defined (INO_VIRTUAL)
  virtual
#endif
  void     copy             (IARestrictedAccessCollection
                              <Element> const&);

#if ! defined (__INO_AVALON__)
  INotifier&
           disableNotification
                            ();

#endif
  Element const&
           elementAt        (ICursor const&) const;

  Element const&
           elementAtPosition
                            (IPosition) const;

#if ! defined (__INO_AVALON__)
  INotifier&
           enableNotification
                            (bool = true);

#endif
  Element const&
           first            () const;

  bool isBounded        () const;

  bool isConsistent     () const;

  bool isEmpty          () const;

#if ! defined (__INO_AVALON__)
  bool isEnabledForNotification
                            () const;

#endif
  bool isFirstAt        (ICursor const&) const;

  bool isFull           () const;

  bool isLastAt         (ICursor const&) const;

  Element const&
           last             () const;

  INumber  maxNumberOfElements
                            () const;

#if ! defined (INO_VIRTUAL)
  virtual
#endif
  ICursor* newCursor        () const;

#if ! defined (__INO_MNGCURSOR__)
  ICursor* newMngCursor     () const;

#endif
#if ! defined (__INO_AVALON__)
  INotifier&
           notifier
                            ();

  INotifier const&
           notifier
                            () const;

  INotifier&
           notifyObservers  (INotificationEvent const&);

#endif
  INumber  numberOfElements () const;

  IPosition
           positionAt       (ICursor const&) const;

#if ! defined (INO_VIRTUAL)
  virtual
#endif
  INumber  removeAll        ();

  bool setToFirst       (ICursor&) const;

  bool setToLast        (ICursor&) const;

  bool setToNext        (ICursor&) const;

  void     setToPosition    (IPosition, ICursor&) const;

  bool setToPrevious    (ICursor&) const;

#if ! defined (__INO_AVALON__)
           operator INotifier&
                            () const;

#endif
  // for backward compatibility
  Element const&
           anyElement       () const;

  Element const&
           firstElement     () const;

  bool isFirst          (ICursor const&) const;

  bool isLast           (ICursor const&) const;

  Element const&
           lastElement      () const;

  IPosition
           position         (ICursor const&) const;

protected:

#if ! defined(__INO_L1_LOCKING__)
                friend class IRestrictedAccessCollectionGuard<Element>;
#endif

           IARestrictedAccessCollection
                            ();

           IARestrictedAccessCollection
                            (IARestrictedAccessCollection
                              <Element> const&);

  static
  Implementation&
           ImplOf           (IARestrictedAccessCollection
                              <Element> const&);

private:

#if ! defined (__INO_STREAMING__)
public:
#if ! defined (INO_VIRTUAL)
  virtual
#endif
  void   operator<<=      (IDataStream&);

#if ! defined (INO_VIRTUAL)
  virtual
#endif
  void   operator>>=      (IDataStream&);

  void   adoptStreamer    (IACollectionStreamer*);
#endif

#if defined (__SOM_ENABLED__) && defined (__RRBC_IBM__)
#pragma SOMDefine (*)
#pragma SOMClassVersion (*, 5, 0)
#pragma SOMReleaseOrder (\
           add              (Element const&),\
           add              (Element const&, ICursor&),\
           addAllFrom       (IARestrictedAccessCollection\
                              <Element> const&),\
           allElementsDo    (bool (*) (Element const&, void*),
                              void*) const,\
           allElementsDo    (IConstantApplicator <Element>&) const,\
           anyElement       () const,\
           copy             (IARestictedAccessCollection\
                              <Element> const &),\
           elementAt        (ICursor const&) const,\
           elementAtPosition\
                            (IPosition) const,\
           firstElement     () const,\
           isBounded        () const,\
           isConsistent     () const,\
           isEmpty          () const,\
           isFirst          (ICursor const&) const,\
           isFull           () const,\
           isLast           (ICursor const&) const,\
           lastElement      () const,\
           maxNumberOfElements\
                            () const,\
           newCursor        () const,\
           numberOfElements () const,\
           position         (ICursor const&) const,\
           removeAll        (),\
           removeLast       (),\
           setToFirst       (ICursor&) const,\
           setToLast        (ICursor&) const,\
           setToNext        (ICursor&) const,\
           setToPosition    (IPosition, ICursor&) const,\
           setToPrevious    (ICursor&) const,\
           ImplOf           (IARestrictedAccessCollection\
                              <Element> const&),\
           operator<<=      (IDataStream&),\
           operator>>=      (IDataStream&),\
           adoptStreamer    (IACollectionStreamer*)\
                       )
#endif

};

#pragma enum(pop)
#pragma pack(pop)

#if __IBMCPP__ >= 400
#pragma namemangling()
#endif

#if defined (__SOM_ENABLED__)
#pragma SOMAsDefault (pop)
#endif

#include <iarstrct.inl>

#if defined (__OS2__) || defined (__OS400__) || defined (__WINDOWS__)
#pragma info (restore)
#endif

#endif // _IARSTRCT_
