// IBM Open Class Library
//
// Licensed Materials - Property of IBM
//
// (C) Copyright IBM Corporation, 1992, 1997 All Rights Reserved
//
// Revision: 15 1.4.1.4 source/core/collect/iacllct.inl, collection, ioc.v400, 001006 
#ifndef _IACLLCT_INL_
#define _IACLLCT_INL_

#include <ilanglvl.hpp>

#ifndef IC_BUILD
#define __IOC_INLINE inline
#else
#define __IOC_INLINE
#endif

#if ! defined(__INO_L1_LOCKING__)
// -----------------
// ICollectionGuard
// -----------------

// public members

template <class Element>
inline
ICollectionGuard<Element>::
ICollectionGuard (IACollection<Element>& c, long timeout)
: ivCollection(c)
{ c.ImplOf(c).Seize(timeout);
}

template <class Element>
inline
ICollectionGuard<Element>::
~ICollectionGuard ()
{ ivCollection.ImplOf(ivCollection).Release();
}

#endif

// --------------
// IElementCursor
// --------------

// public members

template <class Element>
inline Element const&
IElementCursor <Element>::
element () const
{ return *(Element const*) ImplOf (*this).Element ();
}

// protected members

template <class Element>
inline
IElementCursor <Element>::
IElementCursor (Implementation* impl)
: ICursor (impl)
{
}

// ------------
// IACollection
// ------------

// public members

#if ! defined (__INO_AVALON__)
template <class Element>
inline
IACollection <Element>::
IACollection (INotifier& notifier)
{ SetImpl ((Implementation*)&notifier);
}

#endif
template <class Element>
inline
IACollection <Element>::
~IACollection ()
{
}

template <class Element>
inline bool
IACollection <Element>::
add (Element const& element)
{ return ImplOf (*this).Add (&element);
}

template <class Element>
inline bool
IACollection <Element>::
add (Element const& element, ICursor& cursor)
{ return ImplOf (*this).Add (&element, CrsrImplOf (cursor));
}

template <class Element>
inline void
IACollection <Element>::
addAllFrom (IACollection <Element> const& collection)
{ ImplOf (*this).AddAllFrom (ImplOf (collection));
}

template <class Element>
inline bool
IACollection <Element>::
allElementsDo (bool (*applFunc) (Element&, void*), void* addArg)
{ return ImplOf (*this).AllElementsDo ((IApplFunc)applFunc, addArg);
}

template <class Element>
inline bool
IACollection <Element>::
allElementsDo (bool (*applFunc) (Element const&, void*),
               void* addArg) const
{ return ImplOf (*this).AllElementsDo ((IApplFunc)applFunc, addArg);
}

template <class Element>
inline bool
IACollection <Element>::
allElementsDo (IApplicator <Element>& applicator)
{ return ImplOf (*this).AllElementsDo (__applFunc, &applicator);
}

template <class Element>
inline bool
IACollection <Element>::
allElementsDo (IConstantApplicator <Element>& applicator) const
{ return ImplOf (*this).AllElementsDo (__applFunc, &applicator);
}

template <class Element>
inline Element const&
IACollection <Element>::
any () const
{ return *(Element const*) ImplOf (*this).Any ();
}

template <class Element>
inline Element const&
IACollection <Element>::
anyElement () const
{ return *(Element const*) ImplOf (*this).Any ();
}

template <class Element>
inline void
IACollection <Element>::
copy (IACollection <Element> const& collection)
{ ImplOf (*this).Copy (ImplOf (collection));
}

#if ! defined (__INO_AVALON__)
template <class Element>
inline INotifier&
IACollection <Element>::
disableNotification ()
{ return ImplOf (*this).DisableNotification ();
}

#endif
template <class Element>
inline Element&
IACollection <Element>::
elementAt (ICursor const& cursor)
{ return *(Element*) ImplOf (*this).ElementAt (CrsrImplOf (cursor));
}

template <class Element>
inline Element const&
IACollection <Element>::
elementAt (ICursor const& cursor) const
{ return *(Element const*) ImplOf (*this).
    ElementAt (CrsrImplOf (cursor));
}

#if ! defined (__INO_AVALON__)
template <class Element>
inline INotifier&
IACollection <Element>::
enableNotification (bool enable)
{ return ImplOf (*this).EnableNotification (enable);
}

#endif
template <class Element>
inline bool
IACollection <Element>::
isBounded () const
{ return ImplOf (*this).IsBounded ();
}

template <class Element>
inline bool
IACollection <Element>::
isConsistent () const
{ return ImplOf (*this).IsConsistent ();
}

template <class Element>
inline bool
IACollection <Element>::
isEmpty () const
{ return ImplOf (*this).IsEmpty ();
}

#if ! defined (__INO_AVALON__)
template <class Element>
inline bool
IACollection <Element>::
isEnabledForNotification () const
{ return ImplOf (*this).IsEnabledForNotification ();
}

#endif
template <class Element>
inline bool
IACollection <Element>::
isFull () const
{ return ImplOf (*this).IsFull ();
}

template <class Element>
inline INumber
IACollection <Element>::
maxNumberOfElements () const
{ return ImplOf (*this).MaxNumberOfElements ();
}

template <class Element>
inline ICursor*
IACollection <Element>::
newCursor () const
{ return InterfaceFor (ImplOf (*this).CreateCursor ());
}

#if ! defined (__INO_MNGCURSOR__)
template <class Element>
inline ICursor*
IACollection <Element>::
newMngCursor () const
{ return InterfaceFor (ImplOf (*this).CreateMngCursor ());
}

#endif
#if ! defined (__INO_AVALON__)
template <class Element>
inline INotifier&
IACollection <Element>::
notifier ()
{ return ImplOf (*this);
}

template <class Element>
inline INotifier const&
IACollection <Element>::
notifier () const
{ return ImplOf (*this);
}

template <class Element>
inline INotifier&
IACollection <Element>::
notifyObservers (INotificationEvent const& event)
{ return ImplOf (*this).notifyObservers (event);
}

#endif
template <class Element>
inline INumber
IACollection <Element>::
numberOfElements () const
{ return ImplOf (*this).NumberOfElements ();
}

template <class Element>
inline INumber
IACollection <Element>::
removeAll ()
{ return ImplOf (*this).RemoveAll ();
}

template <class Element>
inline INumber
IACollection <Element>::
removeAll (bool (*predFunc) (Element const&, void*), void* addArg)
{ return ImplOf (*this).RemoveAll ((IPredFunc)predFunc, addArg);
}

template <class Element>
inline void
IACollection <Element>::
removeAt (ICursor& cursor)
{ ImplOf (*this).RemoveAt (CrsrImplOf (cursor));
}

template <class Element>
inline void
IACollection <Element>::
replaceAt (ICursor const& cursor, Element const& element)
{ ImplOf (*this).ReplaceAt (CrsrImplOf (cursor), &element);
}

template <class Element>
inline bool
IACollection <Element>::
setToFirst (ICursor& cursor) const
{ return ImplOf (*this).SetToFirst (CrsrImplOf (cursor));
}

template <class Element>
inline bool
IACollection <Element>::
setToNext (ICursor& cursor) const
{ return ImplOf (*this).SetToNext (CrsrImplOf (cursor));
}

#if ! defined (__INO_AVALON__)
template <class Element>
inline
IACollection <Element>::
operator INotifier& () const
{ return ImplOf (*this);
}

#endif

#if ! defined (__INO_STREAMING__)
template <class Element>
inline
void
IACollection <Element>::
operator<<= (IDataStream& stream)
{ ImplOf (*this).StreamIn (stream);
}

template <class Element>
__IOC_INLINE
void
IACollection <Element>::
operator>>= (IDataStream& stream)
{ ImplOf (*this).StreamOut (stream);
}

template <class Element>
inline void
IACollection<Element>::
adoptStreamer (IACollectionStreamer *streamer)
{ ImplOf (*this).AdoptStreamer(streamer);
}
#endif

// protected members

template <class Element>
inline
IACollection <Element>::
IACollection ()
: IACollectionBase ()
{
}

template <class Element>
inline
IACollection <Element>::
IACollection (IACollection <Element> const& collection)
: IACollectionBase (collection)
{
}

template <class Element>
inline TYPENAME IACollection <Element>::Implementation&
IACollection <Element>::
ImplOf (IACollection <Element> const& collection)
{ return *(Implementation*)collection.ivImpl;
}

#endif // _IACLLCT_INL_
