// ----------------------------------------------------------------------------
// FILE NAME: istdntfy.cpp
//
// DESCRIPTION:
//   This file contains the implementation of classes/functions declared
//   in istdntfy.hpp.
//
// COPYRIGHT:
//   IBM Open Class Library
//   (C) Copyright International Business Machines Corporation 1992, 1997
//   Licensed Material - Program-Property of IBM - All Rights Reserved.
//   US Government Users Restricted Rights - Use, duplication, or disclosure
//   restricted by GSA ADP Schedule Contract with IBM Corp.
//
// Revision: 73 1.7.1.4 source/core/base/istdntfy.cpp, notification, ioc.v400, 001006 
// ----------------------------------------------------------------------------

//
//{2} DK IObserverList is an implementation class that is exposed through the
//       INotifier api through the accessor observerList. I had to put this
//       back in so as not to break collections which seems to use this. Also,
//       userdata seems to be used by clients so we need to obsolete this from
//       the API once people stop using it. I also typedefed IObserverlist to
//       IConnectionList because the name is confusing since Observers are
//       really notification "connections".
//


#include <istdntfy.hpp>
#include <iobslist.hpp>
#include <iobservr.hpp>
#include <inotifev.hpp>
#include <iintpair.hpp>
#include <inotadr.hpp>
#include <ingthrd.hpp>
#include <iprimlck.hpp>
#include <ireslock.hpp>

// Segment definitions
#ifdef IC_PAGETUNE
    #define _ISTDNTFY_CPP_
    #include <ipagetun.h>
#endif

//
//  Define all changes id. Info pragma turns off previously declared as _Import
//  warning
//
#pragma info(nodcl)
INotificationId const IC_EXPORTB INotifier::allChangesId = "INotifier::allChanges";
#pragma info(restore)

static IPrivateResource& dictionaryKey()
{
    static IPrivateResource* gDictionaryKey = 0;

    if (!gDictionaryKey)
    {
        IPrimalLock lockInit;

        if (!gDictionaryKey)
            gDictionaryKey = new IPrivateResource;
    }
    return *gDictionaryKey;
}


/*------------------------------------------------------------------------------
| INotifierImplementation::INotifierImplementation                             |
------------------------------------------------------------------------------*/
INotifierImplementation::INotifierImplementation() :

    fInterestDict(0)
{
}

/*------------------------------------------------------------------------------
| INotifierImplementation::~INotifierImplementation                            |
------------------------------------------------------------------------------*/
INotifierImplementation::~INotifierImplementation()
{
    // This should remove all the entries
    delete fInterestDict;
    fInterestDict = 0;
}

/*------------------------------------------------------------------------------
| INotifierImplementation::interestDict                                        |
------------------------------------------------------------------------------*/
IInterestDictionary &INotifierImplementation::interestDict()
{
    if (!fInterestDict)
        fInterestDict = new IInterestDictionary(50);

    return *fInterestDict;
}

/*------------------------------------------------------------------------------
| IInterestConnectionListPair::IInterestConnectionListPair                     |
------------------------------------------------------------------------------*/
IInterestConnectionListPair::IInterestConnectionListPair() :

    fConnectionList(0)
{
}

/*------------------------------------------------------------------------------
| IInterestConnectionListPair::IInterestConnectionListPair                     |
------------------------------------------------------------------------------*/
IInterestConnectionListPair::IInterestConnectionListPair(
                    const IInterest& anInterest, IConnectionList* adoptTheList) :
    fInterest(anInterest),
    fConnectionList(adoptTheList)
{
}

/*------------------------------------------------------------------------------
| IInterestConnectionListPair::~IInterestConnectionListPair                    |
------------------------------------------------------------------------------*/
IInterestConnectionListPair::~IInterestConnectionListPair()
{
    delete fConnectionList;
}

/*------------------------------------------------------------------------------
| IInterestConnectionListPair::operator=                                       |
------------------------------------------------------------------------------*/
IInterestConnectionListPair& IInterestConnectionListPair::operator=(
                                        const IInterestConnectionListPair& rhs)
{
    if(this != &rhs) 
    {
        fInterest = rhs.fInterest;
        delete fConnectionList;
        fConnectionList = new IConnectionList(*rhs.fConnectionList);
    }
    return *this;
}

/*------------------------------------------------------------------------------
| IInterestConnectionListPair::IInterestConnectionListPair                     |
------------------------------------------------------------------------------*/
IInterestConnectionListPair::IInterestConnectionListPair(
                                        const IInterestConnectionListPair& rhs)
{
    fConnectionList = 0;
    fInterest = rhs.fInterest;

    if (rhs.fConnectionList)
        fConnectionList = new IConnectionList(*rhs.fConnectionList);
}

/*------------------------------------------------------------------------------
| IInterestConnectionListPair::operator==                                      |
------------------------------------------------------------------------------*/
bool IInterestConnectionListPair::operator==(const IInterestConnectionListPair& rhs) const
{
    return ((fInterest == rhs.fInterest) && (fConnectionList == rhs.fConnectionList));
}

/*------------------------------------------------------------------------------
| IInterestConnectionListPair::getKey                                          |
------------------------------------------------------------------------------*/
IInterest const& IInterestConnectionListPair::getKey() const
{
    return fInterest;
}

/*------------------------------------------------------------------------------
| IInterestConnectionListPair::getElement                                      |
------------------------------------------------------------------------------*/
IConnectionList* IInterestConnectionListPair::getElement()
{
    if (! fConnectionList)
        fConnectionList = new IConnectionList();

    return fConnectionList;
}


/*------------------------------------------------------------------------------
| INotifier::INotifier                                                         |
------------------------------------------------------------------------------*/
INotifier::INotifier() :

    fThreadId (INonGUIThread::currentId())
{
}

/*------------------------------------------------------------------------------
| INotifier::~INotifier                                                        |
------------------------------------------------------------------------------*/
INotifier::~INotifier()
{
}

/*------------------------------------------------------------------------------
| INotifier::threadId
------------------------------------------------------------------------------*/
const IThreadId& INotifier::threadId() const
{
    return fThreadId;
}

/*------------------------------------------------------------------------------
| INotifier::notifyObserversAsync
| This does nothing by default.(for compatiblity)
------------------------------------------------------------------------------*/
INotifier& INotifier::notifyObserversAsync(const INotificationEvent& event)
{
    return *this;
}

/*------------------------------------------------------------------------------
| INotifier::notifierAddress
------------------------------------------------------------------------------*/
INotifierAddress INotifier::notifierAddress() const
{
    return INotifierAddress(this);
}

/*------------------------------------------------------------------------------
| INotifier::addObserver
| This interest version does nothing by default(for compatiblity)
------------------------------------------------------------------------------*/
INotifier& INotifier::addObserver(IObserver& observer, const IInterest& interest)
{
    return *this;
}

/*------------------------------------------------------------------------------
| INotifier::removeObserver
| This interest version does nothing by default (for compatiblity)
------------------------------------------------------------------------------*/
INotifier& INotifier::removeObserver(IObserver& observer, const IInterest& interest)
{
    return *this;
}

/*------------------------------------------------------------------------------
| IStandardNotifier::IStandardNotifier                                         |
|                                                                              |
| Default IStandardNotifier constructor. By default, IStandardNotifier objects |
| are created in a disabled state and therefore require a call to              |
| enableNotification before they will pass notifications on to observer        |
| objects.                                                                     |
------------------------------------------------------------------------------*/
IStandardNotifier::IStandardNotifier() :

    enabled(false),
    fNotifierImp(0)
{
}

/*------------------------------------------------------------------------------
| IStandardNotifier::IStandardNotifier                                         |
|                                                                              |
| IStandardNotifier copy constructor.                                          |
| NOTE:  The ObserverList will be initialized to 0 and will not be copied.     |
------------------------------------------------------------------------------*/
IStandardNotifier::IStandardNotifier (const IStandardNotifier& copy) :

    fNotifierImp(0)
{
    this->enabled = copy.enabled;
}

/*------------------------------------------------------------------------------
| IStandardNotifier::operator=                                                 |
|                                                                              |
| IStandardNotifier assignment operator.                                       |
| NOTE:  The ObserverList will be initialized to 0 and will not be copied.     |
------------------------------------------------------------------------------*/
IStandardNotifier& IStandardNotifier::operator= (const IStandardNotifier& rhs)
{
    /* Make sure we are not assigning to ourselves. */
    if (this != &rhs)
    {
        this->enabled = rhs.enabled;
        if ( notifierImp (false) )// test, but don't construct one
        {
            delete fNotifierImp;
            fNotifierImp = 0;
        }
    }
    return *this;
}

/*------------------------------------------------------------------------------
| IStandardNotifier::notifierImp                                               |
------------------------------------------------------------------------------*/
//implement the Jit construction, courtesy of r.meseck
INotifierImplementation*
IStandardNotifier::notifierImp( bool create /* = true */ )   
{
    if ((fNotifierImp == 0) && create)
    {
        fNotifierImp = new INotifierImplementation;
    }
    return fNotifierImp;
}

/*------------------------------------------------------------------------------
| IStandardNotifier::notifierImp                                               |
------------------------------------------------------------------------------*/
INotifierImplementation*
IStandardNotifier::notifierImp( bool create /* = true */ ) const
{
    return ((IStandardNotifier*) this)->notifierImp( create);
}

/*------------------------------------------------------------------------------
| IStandardNotifier::~IStandardNotifier                                        |
|                                                                              |
| IStandardNotifier destructor.  Deletes the observer list.                    |
------------------------------------------------------------------------------*/
IStandardNotifier::~IStandardNotifier()
{
    if (fNotifierImp) {
        notifyObservers(INotificationEvent(INotifier::deleteId, *this));
        delete fNotifierImp;
    }
}

/*------------------------------------------------------------------------------
| IStandardNotifier::enableNotification                                        |
|                                                                              |
| Flags this notifier as being ready to accept notifications.  A Notifier,     |
| like IStandardNotifier, does not send notifications to observer objects      |
| until it is enabled.                                                         |
------------------------------------------------------------------------------*/
IStandardNotifier& IStandardNotifier::enableNotification(bool enabled)
{
    this->enabled = enabled;
    return *this;
}

/*------------------------------------------------------------------------------
| IStandardNotifier::disableNotification                                       |
|                                                                              |
| Flags this notifier as being not ready to accept notifications.  A Notifier, |
| like IStandardNotifier, does not send notifications to observer objects      |
| unless it is  enabled                                                        |
------------------------------------------------------------------------------*/
IStandardNotifier& IStandardNotifier::disableNotification()
{
    this->enabled = false;
    return *this;
}

/*------------------------------------------------------------------------------
| IStandardNotifier::isEnabledForNotification                                  |
|                                                                              |
| Returns true if this notifier is enabled for notification.                   |
------------------------------------------------------------------------------*/
bool IStandardNotifier::isEnabledForNotification() const
{
    return this->enabled;
}

#if (IC_OBSOLETE <= IC_OBSOLETE_3)
/*------------------------------------------------------------------------------
| IStandardNotifier::addObserver                                               |
|                                                                              |
| This is the implementation of the INotifier::addObserver protocol.  We just  |
| pass requests on to the observer list.                                       |
------------------------------------------------------------------------------*/
IStandardNotifier& IStandardNotifier::addObserver(IObserver& observer,
                                                  const IEventData& userData)
{
    //Add the connection to the connection list
    observerList().add (observer, userData);
    return *this;
}
#endif // IC_OBSOLETE

/*------------------------------------------------------------------------------
| IStandardNotifier::addObserver                                               |
|                                                                              |
| This is the implementation of the INotifier::addObserver protocol.  We just  |
| pass requests on to the observer list.                                       |
------------------------------------------------------------------------------*/
IStandardNotifier& IStandardNotifier::addObserver(IObserver& theObserver,
                                                  const IInterest& theInterest)
{
    //
    //  Add the connection to the connection list
    //  {2} Obsolete - need to remove IEventData parameter from observer list seq
    //
    observerList(&theInterest).add(theObserver, 0);
    return *this;
}


/*------------------------------------------------------------------------------
| IStandardNotifier::removeObserver                                            |
|                                                                              |
| This is the implementation of the INotifier::removeObserver protocol. We     |
| just pass requests on to the observer list.                                  |
------------------------------------------------------------------------------*/
IStandardNotifier& IStandardNotifier::removeObserver(IObserver& theObserver,
                                                    const IInterest& theInterest)
{
    //Look in the dict for this interest
    bool found = notifierImp()->interestDict().containsElementWithKey(theInterest);

    //Does this interest exist?
    if (found)
    {
        //Get the connections
        IInterestConnectionListPair& thePair = notifierImp()->interestDict().elementWithKey(theInterest);

        //Remove this observers  connections
        IConnectionList* theConnections = thePair.getElement();

        if (theConnections)
            theConnections->remove(theObserver);
    }
    return *this;
}

/*------------------------------------------------------------------------------
| IStandardNotifier::removeObserver                                            |
|                                                                              |
| This is the implementation of the INotifier::removeObserver protocol. We     |
| just pass requests on to the observer list.                                  |
------------------------------------------------------------------------------*/
IStandardNotifier& IStandardNotifier::removeObserver( IObserver& observer )
{
    IResourceLock threadsLock(dictionaryKey());

    IInterestDictionary::Cursor cursor(notifierImp()->interestDict());

    //Remove observer for every interest (including allInterest)
    forCursor(cursor)
    {
        IInterestConnectionListPair& thePair = notifierImp()->interestDict().elementAt(cursor);

        //Get the connection list and remove the observer
        thePair.getElement()->remove( observer );
    }
    return *this;
}

/*------------------------------------------------------------------------------
| IStandardNotifier::removeObserver                                            |
|                                                                              |
| This is the implementation of the INotifier::removeAllObservers protocol. We |
| pass requests on to the observer list.                                       |
------------------------------------------------------------------------------*/
IStandardNotifier& IStandardNotifier::removeAllObservers ( )
{
    IResourceLock threadsLock(dictionaryKey());

    IInterestDictionary::Cursor cursor(notifierImp()->interestDict());

    //For every interest
    forCursor(cursor)
    {
        IInterestConnectionListPair& thePair = notifierImp()->interestDict().elementAt(cursor);

        //Get the connection list and remove the connections
        thePair.getElement()->removeAll();
    }
    return *this;
}

/*------------------------------------------------------------------------------
| IStandardNotifier::notifyObservers                                           |
|                                                                              |
| This is the implementation of the INotifier::notifyObservers protocol. We    |
| pass requests on to the observer list.                                       |
------------------------------------------------------------------------------*/
IStandardNotifier& IStandardNotifier::notifyObservers(
    const INotificationEvent& anEvent)
{
    if  (isEnabledForNotification())
    {
        static const unsigned int maxInterestArraySz = 2;

        //
        // Perhaps it is better to create allChangesInterest once by adding
        //  fAllChangesInterest field
        //

        IInterest allChangesInterest(*this, INotifier::allChangesId);

        //
        //  Use this array to check for *both* allChangesInterest and the event
        //  interest
        //
        const IInterest* interestArray[maxInterestArraySz] = 
        {
            &allChangesInterest,
            &anEvent.interest()
        };
        int numInterests = maxInterestArraySz;

        //Only check for 1 if these are the same
        if (allChangesInterest == anEvent.interest())
            numInterests = 1;

        for (int i = 0; i < numInterests; i++) 
        {
            const IInterest& theInterest = *interestArray[i];

            //Does this interest exist?
            bool found = notifierImp()->interestDict().containsElementWithKey(theInterest);

            //Get the connections
            if (found)
            {
                //Get the connections for the interest
                IInterestConnectionListPair&
                    thePair = notifierImp()->interestDict().elementWithKey( theInterest );

                //pass event to connection list
                IConnectionList* theConnections = thePair.getElement();

                theConnections->notifyObservers( anEvent );
            }
        }
    }
    return *this;
}

/*------------------------------------------------------------------------------
| IStandardNotifier::notifyObservers                                           |
|                                                                              |
| This is the implementation of the INotifier::notifyObservers protocol. We    |
| pass requests on to the observer list.                                       |
------------------------------------------------------------------------------*/
IStandardNotifier& IStandardNotifier::notifyObservers(const INotificationId& nId)
{
    if (isEnabledForNotification())
    {
        IInterest theInterest(*this, nId);
        notifyObservers(INotificationEvent(theInterest));
    }
    return *this;
}

/*------------------------------------------------------------------------------
| IStandardNotifier::observerList                                              |
|                                                                              |
| Returns a reference to the observer list. The creation of the observer       |
| list is delayed until this function is called for the first time -- all      |
| access to the observer list MUST be obtained through this function.          |
------------------------------------------------------------------------------*/
IObserverList& IStandardNotifier::observerList(const IInterest* anInterest) const
{
    IInterest allChangesInterest(*this, INotifier::allChangesId);

    bool found = false;

    if (!anInterest)
        anInterest = &allChangesInterest;

    found = notifierImp()->interestDict().containsElementWithKey(*anInterest);
    if (!found)
    {
        //If not, then enter an empty connectionlist
        IConnectionList* pConnections = new IConnectionList();

        //pConnections will get adopted by the Pair
        notifierImp()->interestDict().add
        (
            IInterestConnectionListPair(*anInterest, pConnections)
        );
    }

    //Get the connections for the interest
    IInterestConnectionListPair&
            thePair = notifierImp()->interestDict().elementWithKey(*anInterest);

    //return reference to connection list
    return(*(thePair.getElement()));
}


/*------------------------------------------------------------------------------
| IStandardNotifier::notifierAddress                                           |
|                                                                              |
------------------------------------------------------------------------------*/
INotifierAddress IStandardNotifier::notifierAddress() const
{
    return INotifierAddress(this);
}

/*------------------------------------------------------------------------------
| IStandardNotifier::notifyObserversAsync                                      |
|                                                                              |
------------------------------------------------------------------------------*/
IStandardNotifier& IStandardNotifier::notifyObserversAsync(const INotificationEvent& anEvent)
{
    if (isEnabledForNotification())
    {
        static const unsigned int maxInterestArraySz = 2;

        // Perhaps it is better to create allChangesInterest once by adding fAllChangesInterest field
        IInterest allChangesInterest( *this, INotifier::allChangesId );

        // Use this array to check for *both* allChangesInterest and the event interest
        const IInterest* interestArray[maxInterestArraySz] = {&allChangesInterest, &anEvent.interest()};
        int numInterests = maxInterestArraySz;

        //Only check for 1 if these are the same
        if (allChangesInterest == anEvent.interest())
            numInterests = 1;

        for (int i = 0; i < numInterests; i++) 
        {
            const IInterest& theInterest = *interestArray[i];

            //Does this interest exist?
            bool
              found = notifierImp()->interestDict().containsElementWithKey( theInterest);

            //Get the connections
            if (found)
            {
                //Get the connections for the interest
                IInterestConnectionListPair&
                      thePair = notifierImp()->interestDict().elementWithKey( theInterest );

                //pass event to connection list
                IConnectionList* theConnections = thePair.getElement();

                //
                // The connectionList just stores a sequence of connections, which could
                // live in the same/diff thread as this thread and may or may not have
                // a request processor.  So let it create a bunch of INotificationRequests
                // for each connection and let it try to stick them on the correct request
                // processor
                //
                theConnections->notifyObserversAsync( anEvent );
            }
        }
    }
    return *this;
}
