// ----------------------------------------------------------------------------
// FILE NAME: irect.hpp
//
// DESCRIPTION:
//   Declaration of the classes:
//     IRectangle
//
// COPYRIGHT:
//   IBM Open Class Library
//   (C) Copyright International Business Machines Corporation 1992, 1997
//   Licensed Material - Program-Property of IBM - All Rights Reserved.
//
//
// Revision: 64 1.5.1.7 source/core/base/irect.hpp, appsupport, ioc.v400, 001006 
// ----------------------------------------------------------------------------

#ifndef _IRECT_
#define _IRECT_

#include <istream.hpp>
#include <ibase.hpp>
#include <ipoint.hpp>

#if __IBMCPP__ >= 400
#pragma namemangling(compat)
#endif

#ifndef IC_BUILD
class IRectangle;
inline ostream &operator<<(ostream& stream, const IRectangle& rectangle);
#endif

#pragma pack(push,4)
#pragma enum(4)

struct _RECTL;
struct tagRECT;

class IRectangle
{
public:
/*------------------------------ Related Types -------------------------------*/
  typedef IPair::Coord Coord;

/*------------------------------- Constructors -------------------------------*/
  IRectangle ( );

  IRectangle ( const IPoint& point1,
               const IPoint& point2 );

  IRectangle ( const IPoint& point,
               const ISize&  size );

  IRectangle ( Coord point1X,
               Coord point1Y,
               Coord point2X,
               Coord point2Y );

#ifdef IC_PMWIN
  IRectangle ( const struct _RECTL& rectl);
#endif
#ifdef IC_WIN
  IRectangle ( const struct tagRECT& rect);
#endif

  IRectangle ( Coord width,
               Coord height      );
  IRectangle ( const IPair& pair );

/*-------------------------------- Points ------------------------------------*/
IPoint
  minXMinY        ( ) const,
  minXCenterY     ( ) const,
  minXMaxY        ( ) const,
  centerXMinY     ( ) const,
  centerXCenterY  ( ) const,
  centerXMaxY     ( ) const,
  maxXMinY        ( ) const,
  maxXCenterY     ( ) const,
  maxXMaxY        ( ) const;


/*-------------------------------- Dimensions --------------------------------*/
ISize
  size   ( ) const;

Coord
  area   ( ) const,
  height ( ) const,
  minX   ( ) const,
  minY   ( ) const,
  maxX   ( ) const,
  maxY   ( ) const,
  width  ( ) const;

/*-------------------------------- Conversions -------------------------------*/
#ifdef IC_PMWIN
struct _RECTL
  asRECTL ( ) const;
#endif

IString
  asString    ( ) const,
  asDebugInfo ( ) const;

/*------------------------------- Comparisons --------------------------------*/
bool
  operator == ( const IRectangle& rectangle ) const,
  operator != ( const IRectangle& rectangle ) const;

/*-------------------------- Manipulation Operators --------------------------*/
IRectangle
  operator &  ( const IRectangle& rectangle ) const,
 &operator &= ( const IRectangle& rectangle ),
  operator |  ( const IRectangle& rectangle ) const,
 &operator |= ( const IRectangle& rectangle );

/*------------------------------- Manipulation -------------------------------*/
IRectangle
  &centerAt   ( const IPoint& point    ),
   centeredAt ( const IPoint& point    ) const,
  &expandBy   ( const IPair&  pair     ),
  &expandBy   ( Coord         coord    ),
   expandedBy ( const IPair&  pair     ) const,
   expandedBy ( Coord         coord    ) const,
  &moveBy     ( const IPair&  pair     ),
   movedBy    ( const IPair&  pair     ) const,
  &moveTo     ( const IPoint& point    ),
   movedTo    ( const IPoint& point    ) const,
  &scaleBy    ( const IPair&  pair     ),
  &scaleBy    ( Coord         coord    ),
  &scaleBy    ( double        factor   ),
  &scaleBy    ( double        xfactor,
                double        yfactor  ),
   scaledBy   ( const IPair&  pair     ) const,
   scaledBy   ( Coord         coord    ) const,
   scaledBy   ( double        factor   ) const,
   scaledBy   ( double        xfactor,
                double        yfactor  ) const,
  &shrinkBy   ( const IPair&  pair     ),
  &shrinkBy   ( Coord         coord    ),
   shrunkBy   ( const IPair&  pair     ) const,
   shrunkBy   ( Coord         coord    ) const,
  &sizeTo     ( const IPair&  pair     ),
   sizedTo    ( const IPair&  pair     ) const,
  &sizeBy     ( const IPair&  pair     ),
  &sizeBy     ( Coord         factor   ),
  &sizeBy     ( double        factor   ),
  &sizeBy     ( double        xfactor,
                double        yfactor  ),
   sizedBy    ( const IPair&  pair     ) const,
   sizedBy    ( Coord         factor   ) const,
   sizedBy    ( double        factor   ) const,
   sizedBy    ( double        xfactor,
                double        yfactor  ) const;

/*--------------------------------- Testing ----------------------------------*/
bool
  contains   ( const IPoint&     point     ) const,
  contains   ( const IRectangle& rectangle ) const,
  intersects ( const IRectangle& rectangle ) const;

/*--------------------------------- Synonyms ---------------------------------*/
IPoint
  bottomLeft   ( ) const,
  bottomCenter ( ) const,
  bottomRight  ( ) const,
  center       ( ) const,
  leftCenter   ( ) const,
  rightCenter  ( ) const,
  topLeft      ( ) const,
  topCenter    ( ) const,
  topRight     ( ) const;

Coord
  bottom ( ) const,
  left   ( ) const,
  right  ( ) const,
  top    ( ) const;

/*----------------------------- Stream operators -----------------------------*/
friend ostream
 &operator << ( ostream&          stream,
                const IRectangle& rectangle );

protected:
/*------------------------------ Implementation ------------------------------*/
IRectangle
 &validate ( );

private:
/*--------------------------------- Private ----------------------------------*/
IPoint
  origin,
  corner;
}; // class IRectangle

#pragma enum(pop)
#pragma pack(pop)

#if __IBMCPP__ >= 400
#pragma namemangling()
#endif

#include <irect.inl>

#endif
