//
// FILE NAME: iprimlck.cpp
//
// DESCRIPTION:
//
//  This module implements the very simple IPrimalLock class, which is used to
//  synchronize the creation of static/global data.
//
// COPYRIGHT:
//   IBM Open Class Library
//   Licensed Materials - Property of IBM
//   (C) Copyright IBM Corp. 1997
//
// Revision: 93 1.3.1.3 source/core/base/iprimlck.cpp, oss, ioc.v400, 001006 

#include <ireslock.hpp>
#include <isynchr.hpp>
#include <iprimlck.hpp>
#include <istatics.hpp>

#ifdef IC_PAGETUNE
    #define _IPRIMLCK_CPP_
    #include <ipagetun.h>
#endif

//
//  This is the private resource that is used. It is created upon 
//  request using the ISynchronized class.
//
ISynchronized<IPrivateResource*> gPrimalRes;

IPrimalLock::IPrimalLock()
{
    if (!gPrimalRes.get())
    {
        // Do a synchronized init of the pointer
        // Suppose multiple threads are trying to initialize gPrimalRes,
        // only one of them will succeed. We have to, therefore, delete
        // the unused IPrivateResource objects.
        // The chosen one should then be managed by the IStaticObjectManager.

        IPrivateResource* myRes = new IPrivateResource;
        synchronizedInit(gPrimalRes, myRes);

        if (myRes == gPrimalRes.get())
            adoptStaticObject(myRes);
        else
            delete myRes;
    }

    // Get a lock on the primal private resource
    gPrimalRes.get()->lock();
}

IPrimalLock::~IPrimalLock()
{
    // And let the primal private resource go now
    gPrimalRes.get()->unlock();
}
