/* NOSHIP */
// ----------------------------------------------------------------------------
// FILE NAME: iplatfrm.hpp
//
// DESCRIPTION:
//   This file contains a class that sets static variables that determine
//   the runtime operating system (platform)
//
// COPYRIGHT:
//   IBM Open Class Library
//   (C) Copyright International Business Machines Corporation 1992, 1997
//   Licensed Material - Program-Property of IBM - All Rights Reserved.
//   US Government Users Restricted Rights - Use, duplication, or disclosure
//   restricted by GSA ADP Schedule Contract with IBM Corp.
//
// Revision: 55 1.4.2.1 source/core/base/iplatfrm.hpp, appsupport, ioc.v400, 001006 
// ----------------------------------------------------------------------------

#ifndef _IPLATFRM_
#define _IPLATFRM_

// ----------------------------------------------------------------------------
//  The platform variables are static.  They are initialized once,
//  automatically during initialization.
//
//  Therefore when querying the current platform, there is no need to create
//  an instance of this class.
//  Call the static functions.  For example:  IPlatform::isWin32()
// ----------------------------------------------------------------------------
#include <ibase.hpp>

#if __IBMCPP__ >= 400
#pragma namemangling(compat)
#endif

#pragma pack(push,4)
#pragma enum(4)

class IPlatform
{
public:
    // ------------------------------- Public Functions -----------------------
    static bool isWin32();
    static bool isWinNT();
    static bool isNTNewShell();
    static bool isWin32S();
    static bool isWin95();
    static bool isWin98();
    static bool isWin9x();
    static bool isWin2000();                // defect 28954

private:
    // ------------------------------- Constructors ---------------------------
    IPlatform();
    IPlatform(const IPlatform& x);

    // ------------------------------- Other Private functions-----------------
    IPlatform& operator=(const IPlatform&);


    // ------------------------------- Private Data ---------------------------
    static const bool fgWin32;
    static const bool fgWinNT;
    static const bool fgNTNewShell;
    static const bool fgWin32S;
    static const bool fgWin95;
    static const bool fgWin98;
    static const bool fgWin2000;            // defect 28954
};

#pragma enum(pop)
#pragma pack(pop)

#if __IBMCPP__ >= 400
#pragma namemangling()
#endif

#endif
