// Revision: 54 1.2.3.1 source/core/base/iplatfrm.cpp, appsupport, ioc.v400, 001006 
/*----------------------------------------------------------------------------*/
/* FILE NAME: iplatfrm.cpp                                                    */
/*                                                                            */
/* DESCRIPTION:                                                               */
/*   This file contains the implementation of a class that sets static        */
/*   variables that determine the runtime operating system (currently         */
/*   only for Windows platform), declared in iplatfrm.hpp.                    */
/*                                                                            */
/* COPYRIGHT:                                                                 */
/*   IBM Open Class Library                                                   */
/*   Licensed Materials - Property of IBM                                     */
/*                                                                            */
#ifdef __WINDOWS__
/*   (C) Copyright IBM Corporation 1992, 1997                                 */
#endif
/*                                                                            */
/*   US Government Users Restricted Rights - Use, duplication, or             */
/*   disclosure restricted by GSA ADP Schedule Contract with IBM              */
/*   Corp.                                                                    */
/*                                                                            */
/*                                                                            */
/*----------------------------------------------------------------------------*/


/* Same priority as ibase.cpp.  This must be the first! */
#pragma priority ( -2147482624)

#ifdef IC_WIN
extern "C"
{
  #include <windows.h>
}
#endif

#include <iplatfrm.hpp>

static bool getIsWin98();
static bool getIsWin2000();         // defect 28954 : add 2000 detection suport

#ifdef IC_PAGETUNE
    #define _IPLATFRM_CPP_
    #include <ipagetun.h>
#endif

#ifdef IC_WIN
  const bool IPlatform::fgWin32 = true;
  const bool IPlatform::fgWinNT = IPlatform::fgWin32 &&
                                     (GetVersion() < 0x80000000ul);
  const bool IPlatform::fgNTNewShell = IPlatform::fgWinNT &&
                                          (LOBYTE(LOWORD(GetVersion())) >= 4);
  const bool IPlatform::fgWin32S = IPlatform::fgWin32 &&
                                      (!(IPlatform::fgWinNT) &&
                                      (LOBYTE(LOWORD(GetVersion()))<4));
  const bool IPlatform::fgWin98 = getIsWin98();
  const bool IPlatform::fgWin2000 =  getIsWin2000();    // defect 28954
  const bool IPlatform::fgWin95 = (!(IPlatform::fgWinNT) &&
                                   !(IPlatform::fgWin32S) &&
                                   !(IPlatform::fgWin98)) && IPlatform::fgWin32;
#else
  const bool IPlatform::fgWin32 = false;
  const bool IPlatform::fgWinNT = false;
  const bool IPlatform::fgNTNewShell = false;
  const bool IPlatform::fgWin32S = false;
  const bool IPlatform::fgWin95 = false;
  const bool IPlatform::fgWin98 = false;
  const bool IPlatform::fgWin2000 = false;              // defect 28954
#endif

/*------------------------------------------------------------------------------
| IPlatform::isWin32                                                           |
------------------------------------------------------------------------------*/
bool IPlatform :: isWin32()
{
   return IPlatform::fgWin32;
}

/*------------------------------------------------------------------------------
| IPlatform::isWinNT                                                           |
------------------------------------------------------------------------------*/
bool IPlatform :: isWinNT()
{
   return IPlatform::fgWinNT;
}
/*------------------------------------------------------------------------------
| IPlatform::isNTNewShell                                                      |
------------------------------------------------------------------------------*/
bool IPlatform :: isNTNewShell()
{
   return IPlatform::fgNTNewShell;
}
/*------------------------------------------------------------------------------
| IPlatform::isWin32S                                                          |
------------------------------------------------------------------------------*/
bool IPlatform :: isWin32S()
{
   return IPlatform::fgWin32S;
}
/*------------------------------------------------------------------------------
| IPlatform::isWin95                                                           |
------------------------------------------------------------------------------*/
bool IPlatform :: isWin95()
{
   return IPlatform::fgWin95;
}
/*------------------------------------------------------------------------------
| IPlatform::isWin98                                                           |
------------------------------------------------------------------------------*/
bool IPlatform :: isWin98()
{
   return IPlatform::fgWin98;
}

/*------------------------------------------------------------------------------
| IPlatform::isWin9x                                                           |
------------------------------------------------------------------------------*/
bool IPlatform :: isWin9x()
{
   return (IPlatform::fgWin98 || IPlatform::fgWin95);
}

/*------------------------------------------------------------------------------
| IPlatform::isWin2000                                                         |
------------------------------------------------------------------------------*/
bool IPlatform :: isWin2000()
{
  return IPlatform::fgWin2000;
}

#ifdef IC_WIN
/*------------------------------------------------------------------------------
| getIsWin98                                                                   |
------------------------------------------------------------------------------*/
static bool getIsWin98()
{
    OSVERSIONINFO versionInfo;

    versionInfo.dwOSVersionInfoSize = sizeof(OSVERSIONINFO);

    if (::GetVersionEx(&versionInfo)) {
        // In order for it to be Windows98, we have to check we are on a
        // Windows 95 type platform (VER_PLATFORM_WIN32_WINDOWS) and
        // also that either the major version is greater than 4 or if the
        // major version is equal to 4 the minor version must be greater than
        // zero.
        //
        if (versionInfo.dwPlatformId == VER_PLATFORM_WIN32_WINDOWS)
            if (versionInfo.dwMajorVersion > 4 ||
                (versionInfo.dwMajorVersion == 4 && versionInfo.dwMinorVersion > 0))
                return true;
    }
    return false;
}
//----------------------------------------------------------------------
// DEFECT 28954 : adding check if Windows 2000 or greater
//----------------------------------------------------------------------
/*------------------------------------------------------------------------------
| getIsWin2000                                                                 |
------------------------------------------------------------------------------*/
bool getIsWin2000()
{
  OSVERSIONINFO versionInfo;

  versionInfo.dwOSVersionInfoSize = sizeof( OSVERSIONINFO );

  if ( ::GetVersionEx( &versionInfo ) )
  { //
    // In order for it to be Windows2000 we need to check:
    // 1. we are nt.
    // 2. we are major version 5 or greater
    //
    if ( versionInfo.dwPlatformId == VER_PLATFORM_WIN32_NT )
      if ( versionInfo.dwMajorVersion >= 5 )
        return true;
  }
  return false;
}
#endif
