/* NOSHIP */

// ----------------------------------------------------------------------------
// FILE NAME: iobsptr.hpp
//
// DESCRIPTION:
//   Declaration of the classes:
//     IObserverPtr
//
// COPYRIGHT:
//   IBM Open Class Library
//   (C) Copyright International Business Machines Corporation 1992, 1997
//   Licensed Material - Program-Property of IBM - All Rights Reserved.
//   US Government Users Restricted Rights - Use, duplication, or disclosure
//   restricted by GSA ADP Schedule Contract with IBM Corp.
//
// Revision: 50 1.6.2.2 source/core/base/iobsptr.hpp, notification, ioc.v400, 001006 
// ----------------------------------------------------------------------------

#ifndef _IOBSPTR_
#define _IOBSPTR_

#include <ibase.hpp>
#include <ievtdata.hpp>

#if __IBMCPP__ >= 400
#pragma namemangling(compat)
#endif

class IObserver;
class IObserverDataList;
class INotificationEvent;
class IObserverPtrData;
class IObserverPtr;

#ifndef IC_BUILD
inline unsigned long hash(const IObserverPtr& theObserver,unsigned long hashMax);
#endif

#pragma pack(push,4)
#pragma enum(4)

class IObserverPtr
{
public:
    // ------------------------------- Constructors ---------------------------
    IObserverPtr(IObserver* observerIn = 0, IEventData observerDataIn = 0) :
        observerData(observerDataIn),
        obsrvr(observerIn)
    {
    }

    ~IObserverPtr()
    {
    }

    IObserver& observer() const
    {
        return *obsrvr;
    }

    IEventData observerData;
    IObserver *obsrvr;

    // -------------------------------- Operators -----------------------------
    bool operator==(const IObserverPtr& obsptr) const
    {
        return (obsptr.obsrvr == this->obsrvr);
    }

    bool operator<(const IObserverPtr& obsptr) const
    {
        return (this->obsrvr < obsptr.obsrvr);
    }

    // ------------------------------------------------------------------------
    // NOTE: This operator= function as written may seem to be broken.
    //       It does not allocate any new memory for the obsrvr pointer
    //       it is copying.  This was written this way for a reason,
    //       namely efficiency.  This is a private, no ship, header and
    //       this function is used in a specific optimized implementation
    //       of the IObserverList::notifyObservers() function.  The fact
    //       that this function is not allocating new memory does NOT
    //       break the implementation.  If you change it, it will.  This
    //       function purposefully points to the existing IObserver
    //       object to use during notification.  It is pointed to from a
    //       temporary array created to do the notifications from.  There
    //       is no reason to create a copy of the observer object...for
    //       efficiency we just use what's already there.   See
    //       IObserverList::notifyObservers() for implementation details.
    // ------------------------------------------------------------------------
    IObserverPtr& operator=(const IObserverPtr& observerPtr)
    {
        if (this != &observerPtr)
        {
            observerData = observerPtr.observerData;
            obsrvr = observerPtr.obsrvr;
        }
        return *this;
    }

    //Collections hash function for ISetHshTable:
    friend unsigned long hash(const IObserverPtr& theObserver,unsigned long hashMax) 
    {
        return ((unsigned long) theObserver.obsrvr) % hashMax;
    }

private:
    // --------------------------------- Private ------------------------------
    IObserverPtrData* fObserverPtrData;
};

#pragma enum(pop)
#pragma pack(pop)

#if __IBMCPP__ >= 400
#pragma namemangling()
#endif

#endif
