// Revision: 42 1.5.1.5 source/core/base/inotifev.inl, notification, ioc.v400, 001006  
#ifndef _INOTIFEV_INL_
#define _INOTIFEV_INL_
/*******************************************************************************
* FILE NAME: inotifev.inl                                                      *
*                                                                              *
* DESCRIPTION:                                                                 *
*   This file contains the definition of the inline functions for the          *
*   classes declared in inotifev.hpp.                                          *
*                                                                              *
* COPYRIGHT:                                                                   *
*   IBM Open Class Library                                                     *
*   (C) Copyright International Business Machines Corporation 1992, 1997       *
*   Licensed Material - Program-Property of IBM - All Rights Reserved.         *
*                                                                              *
*******************************************************************************/
//{1} Taligent fortified

#ifndef IC_BUILD
#define __IOC_INLINE inline
#else
#define __IOC_INLINE
#endif

#if (IC_OBSOLETE <= IC_OBSOLETE_3)

inline INotificationEvent& INotificationEvent::setEventData( const IEventData& eventData )
{
  this->fEvtData = eventData;
  return *this;
}

inline INotificationEvent& INotificationEvent::setObserverData( const IEventData& observerData)
{
  this->fObsData = observerData;
  return *this;
}

inline INotificationEvent& INotificationEvent::setNotifierAttrChanged(
                                                       bool changed)
{
  this->fAttrChanged = changed;
  return *this;
}

inline IEventData INotificationEvent::eventData( ) const
{
  return this->fEvtData;
}

inline IEventData INotificationEvent::observerData( ) const
{
  return this->fObsData;
}

inline bool INotificationEvent::hasNotifierAttrChanged( ) const
{
  return this->fAttrChanged;
}

inline INotifier& INotificationEvent::notifier ( ) const
{
  return fInterest->notifierAddress().notifier();
}

#endif // (IC_OBSOLETE <= IC_OBSOLETE_3)

inline INotificationId INotificationEvent::notificationId ( ) const
{
  return this->fInterest->notificationId();
}

//{1}
inline INotifierAddress INotificationEvent::notifierAddress ( ) const
{
  //return *(this->fEvtNotifier);
	return this->fInterest->notifierAddress();
}


//{1}
template <class AType>
__IOC_INLINE
const AType& INotificationEventFor<AType>::eventData() const
{
	return *fData;
}

//{1}
template <class AType>
inline
INotificationEventFor<AType>::INotificationEventFor ( const IInterest& theInterest , const AType&  data) :
  fInterest (new IInterest(theInterest)),
  fData(new AType (data))
{
}

//{1}
template <class AType>
__IOC_INLINE
INotificationEventFor<AType>::~INotificationEventFor ()
{
  delete fData;
  delete fInterest;
}

//{1}
template <class AType>
inline
const IInterest&
INotificationEventFor<AType>::interest() const
{
  return *fInterest;
}


//{1}
template <class AType>
inline
INotifierAddress
INotificationEventFor<AType>::notifierAddress( ) const
{
  return fInterest->notifierAddress();
}

//{1}
template <class AType>
inline
INotificationId
INotificationEventFor<AType>::notificationId( ) const
{
  return fInterest->notificationId();
}

//{1}
template <class AType>
inline
INotificationEventFor<AType>::INotificationEventFor ( const INotificationEventFor<AType>& copy )
{
  if (copy.fInterest)
	fInterest = new IInterest(*copy.fInterest);
  if (copy.fData)
	fData = new AType(*copy.fData);
}


//{1}
template <class AType>
inline
INotificationEventFor<AType>&
INotificationEventFor<AType>::operator= ( const INotificationEventFor<AType>& rhs )
{
  if (this != &rhs) {

	if (fInterest)
	  delete fInterest;

	fInterest = new IInterest(*rhs.fInterest);

	if (fData)
	  delete fData;

	if (rhs.fData)
	  fData = new AType(*rhs.fData);
  }
  return *this;
}


//Polymorphic copy
template <class AType>
inline
INotificationEvent* 
INotificationEventFor<AType>::clone() const {
  return new INotificationEventFor<AType> (*this);
}

#endif // _INOTIFEV_INL_
