// Revision: 08 1.4.2.1 source/core/base/ievtdata.inl, basewin, ioc.v400, 001006 
#ifndef _IEVTDATA_INL_
#define _IEVTDATA_INL_
/*----------------------------------------------------------------------------*/
/* FILE NAME: ievtdata.inl                                                    */
/*                                                                            */
/* DESCRIPTION:                                                               */
/*   This file contains the definition of the inline functions for the        */
/*   classes declared in ievtdata.hpp                                         */
/*                                                                            */
/* COPYRIGHT:                                                                 */
/*   IBM Open Class Library                                                   */
/*   Licensed Materials - Property of IBM                                     */
/*                                                                            */
#ifdef __MVS__
/*   5645-001                                                                 */
/*   (C) Copyright IBM Corporation 1992, 1997  All Rights Reserved.           */
#endif
#ifdef __OS400__
/*   ????-???                                                                 */
/*   (C) Copyright IBM Corporation 1992, 1997  All Rights Reserved.           */
#endif
#ifdef __OS2__
/*   (C) Copyright IBM Corporation 1992, 1997  All Rights Reserved.           */
#endif
#ifdef __WINDOWS__
/*   (C) Copyright IBM Corporation 1992, 1997  All Rights Reserved.           */
#endif
#ifdef _AIX
/*   (C) Copyright IBM Corporation 1992, 1997  All Rights Reserved.           */
#endif
#ifdef _sparc
/*   (C) Copyright IBM Corporation 1992, 1997  All Rights Reserved.           */
#endif
#ifdef __sparc
/*   (C) Copyright IBM Corporation 1992, 1997  All Rights Reserved.           */
#endif
/*                                                                            */
/*   US Government Users Restricted Rights - Use, duplication, or             */
/*   disclosure restricted by GSA ADP Schedule Contract with IBM Corp.        */
/*                                                                            */
/*----------------------------------------------------------------------------*/

inline IEventData :: IEventData ( )
  : pvClMsg ( 0 )
  { }
inline IEventData :: IEventData ( void* value )
  {
  pvClMsg = value;
  }
inline IEventData :: IEventData ( unsigned long value )
  {
  pvClMsg = (void*)value;
  }
inline IEventData :: IEventData ( int value )
  {
  pvClMsg = (void*)((unsigned long)value);
  }
inline IEventData :: IEventData ( unsigned short lowValue,
                                  unsigned short hiValue )
  {
  pvClMsg = (void*)(lowValue | (unsigned long)hiValue << 16);
  }
inline IEventData :: IEventData ( unsigned short lowValue,
                                  char lowByte, char hiByte )
  {
  unsigned short hiValue = (unsigned short)(lowByte | (unsigned short)hiByte <<
  8); pvClMsg = (void*)(lowValue | (unsigned long)hiValue << 16);
  }
inline char  IEventData :: lowLowByte ( ) const
  {
  return (char)(unsigned long)pvClMsg;
  }
inline char  IEventData :: lowHighByte ( ) const
  {
  return (char)((unsigned long)pvClMsg >> 8);
  }
inline char  IEventData :: highLowByte ( ) const
  {
  return (char)((unsigned long)pvClMsg >> 16);
  }
inline char  IEventData :: highHighByte ( ) const
  {
  return (char)((unsigned long)pvClMsg >> 24);
  }
inline char  IEventData :: char1 ( ) const
  {
  return lowLowByte();
  }
inline char  IEventData :: char2 ( ) const
  {
  return lowHighByte();
  }
inline char  IEventData :: char3 ( ) const
  {
  return highLowByte();
  }
inline char  IEventData :: char4 ( ) const
  {
  return highHighByte();
  }
inline unsigned short  IEventData :: lowNumber ( ) const
  {
  return (unsigned short)(unsigned long)pvClMsg;
  }
inline unsigned short  IEventData :: highNumber ( ) const
  {
  return (unsigned short)((unsigned long)pvClMsg >> 16);
  }
inline unsigned short  IEventData :: number1 ( ) const
  {
  return lowNumber();
  }
inline unsigned short  IEventData :: number2 ( ) const
  {
  return highNumber();
  }
inline unsigned long  IEventData :: asUnsignedLong ( ) const
  {
  return (unsigned long)pvClMsg;
  }
inline long  IEventData :: asLong ( ) const
  {
  return (long)pvClMsg;
  }
inline IEventData :: operator char* ( ) const
  {
  return (char*)pvClMsg;
  }
#ifdef IC_WIN
 #ifdef IC_WIN_STRICT
inline IEventData::operator struct HACCEL__* ( ) const
  {
  return (struct HACCEL__*) pvClMsg;
  }
inline IEventData::operator struct HBITMAP__* ( ) const
  {
  return (struct HBITMAP__*) pvClMsg;
  }
inline IEventData::operator struct HDC__* ( ) const
  {
  return (struct HDC__*) pvClMsg;
  }
inline IEventData::operator struct HFONT__* ( ) const
  {
  return (struct HFONT__*) pvClMsg;
  }
inline IEventData::operator struct HICON__* ( ) const
  {
  return (struct HICON__*) pvClMsg;
  }
inline IEventData::operator struct HINSTANCE__* ( ) const
  {
  return (struct HINSTANCE__*) pvClMsg;
  }
inline IEventData::operator struct HMENU__* ( ) const
  {
  return (struct HMENU__*) pvClMsg;
  }
inline IEventData::operator struct HRGN__* ( ) const
  {
  return (struct HRGN__*) pvClMsg;
  }
inline IEventData::operator struct HWND__* ( ) const
  {
  return (struct HWND__*) pvClMsg;
  }
inline IEventData::operator void* ( ) const
  {
  return (void*) pvClMsg;
  }
 #endif // IC_WIN_STRICT
#endif // IC_WIN
inline IEventData :: operator unsigned long ( ) const
  {
  return (unsigned long)pvClMsg;
  }

#endif // _IEVTDATA_INL_
