// ----------------------------------------------------------------------------
// FILE NAME: ievtdata.hpp
//
// DESCRIPTION:
//   Declaration of the classes:
//     IEventData
//     IEventParameter1
//     IEventParameter2
//     ILowEventParameter
//     IHighEventParameter
//     IEventResult
//
// COPYRIGHT:
//   IBM Open Class Library
//   Licensed Materials - Property of IBM
//
//   5645-001
//   (C) Copyright IBM Corporation 1992, 1997  All Rights Reserved.
//
// Revision: 07  1.5.2.1  source/core/base/ievtdata.hpp, appsupport, ioc.v400, 001006  
// ----------------------------------------------------------------------------

#ifndef _IEVTDATA_
#define _IEVTDATA_

#include <ibase.hpp>

#if __IBMCPP__ >= 400
#pragma namemangling(compat)
#endif

struct HACCEL__;
struct HBITMAP__;
struct HDC__;
struct HFONT__;
struct HICON__;
struct HINSTANCE__;
struct HMENU__;
struct HRGN__;
struct HWND__;

#pragma pack(push,4)
#pragma enum(4)

class IC_EXPORTB IEventData
{
public:
    // ------------------------------- Constructors ---------------------------
    IEventData( );
    IEventData(void* value );
    IEventData(unsigned long value );
    IEventData(int value );
    IEventData(unsigned short lowValue, unsigned short hiValue );

    IEventData(unsigned short lowValue, char lowByte, char hiByte );

    // --------------------------------- Contents -----------------------------
    unsigned short lowNumber() const;
    unsigned short highNumber() const;
    unsigned short number1() const;
    unsigned short number2() const;

    char lowLowByte() const;
    char lowHighByte() const;
    char highLowByte() const;
    char highHighByte() const;
    char char1() const;
    char char2() const;
    char char3() const;
    char char4() const;

    // -------------------------------- Conversion ----------------------------
    unsigned long asUnsignedLong() const;
    long asLong() const;

    operator char*() const;

#ifdef IC_WIN
 #ifdef IC_WIN_STRICT
    operator struct HACCEL__*    ( ) const;
    operator struct HBITMAP__*   ( ) const;
    operator struct HDC__*       ( ) const;
    operator struct HFONT__*     ( ) const;
    operator struct HICON__*     ( ) const;
    operator struct HINSTANCE__* ( ) const;
    operator struct HMENU__*     ( ) const;
    operator struct HRGN__*      ( ) const;
    operator struct HWND__*      ( ) const;
    operator void*               ( ) const;
 #endif
#endif // IC_WIN

    operator unsigned long() const;

private:
    // --------------------------------- Private ------------------------------
    void* pvClMsg;
};

#pragma enum(pop)
#pragma pack(pop)

typedef IEventData IEventParameter1;
typedef IEventData IEventParameter2;
typedef IEventData ILowEventParameter;
typedef IEventData IHighEventParameter;
typedef IEventData IEventResult;

#if __IBMCPP__ >= 400
#pragma namemangling()
#endif

#include <ievtdata.inl>

#endif // _IEVTDATA_
