// Revision: 82 1.6.1.7 source/core/base/ibuffer.hpp, appsupport, ioc.v400, 001006  
#ifdef __MVS__
                   ??=ifndef _IBUFFER_M_
                     ??=ifdef __COMPILER_VER__
                       ??=pragma filetag("IBM-1047")
                     ??=endif
                     #pragma nomargins nosequence
                     #pragma checkout(suspend)
                     #define _IBUFFER_M_
                   ??=endif
#endif

#ifndef _IBUFFER_
#define _IBUFFER_
/*----------------------------------------------------------------------------*/
/* FILE NAME: ibuffer.hpp                                                     */
/*                                                                            */
/* DESCRIPTION:                                                               */
/*   Declaration of the classes:                                              */
/*     IBuffer                                                                */
/*                                                                            */
/* COPYRIGHT:                                                                 */
/*   IBM Open Class Library                                                   */
/*   Licensed Materials - Property of IBM                                     */
/*                                                                            */
/*   (C) Copyright IBM Corporation 1992, 1997  All Rights Reserved.           */
/*                                                                            */
/*----------------------------------------------------------------------------*/

extern "C" {
  #include <stddef.h>
  #include <stdio.h>
  #include <string.h>
  }

#include <ibase.hpp>
#include <istrenum.hpp>
#include <imrefcnt.hpp>

#if __IBMCPP__ >= 400
#pragma namemangling(compat)
#endif

class IString;
class IStringTest;
template<class T> class IStaticObjectHelper;

#pragma enum(4)
#pragma pack(push,4)

class IC_EXPORTB IBuffer : public IMRefCounted {
public:
/*------------------------------- Reallocation -------------------------------*/
IBuffer
 *newBuffer           ( const void* p1,
                        unsigned    len1,
                        const void* p2      = 0,
                        unsigned    len2    = 0,
                        const void* p3      = 0,
                        unsigned    len3    = 0,
                        char        padChar = 0 ) const;

static unsigned
  checkAddition       ( unsigned addend1,
                        unsigned addend2 ),
  checkMultiplication ( unsigned factor1,
                        unsigned factor2 ),
  overflow            ( );

static void
  setDefaultBuffer    ( IBuffer* newDefaultBuffer );

/*--------------------------------- Queries ----------------------------------*/
static IBuffer
 *defaultBuffer ( ),
 *fromContents  ( const char *pBuffer );

IBuffer
 *null          ( ) const;

unsigned
  useCount      ( ) const,
  length        ( ) const;

const char
 *contents      ( ) const;

char
 *contents      ( );

virtual IStringEnum::CharType
  charType      ( unsigned index ) const;

virtual char
 *next          ( const char *prev );

virtual const char
 *next          ( const char *prev ) const;

/*------------------------------- Comparisons --------------------------------*/
typedef enum {
  equal,
  greaterThan,
  lessThan
  } Comparison;

virtual Comparison
  compare ( const void* p,
            unsigned    len ) const;
/*---------------------------------- Subset ----------------------------------*/
virtual IBuffer
 *subString ( unsigned startPos,
              unsigned len,
              char     padCharacter ) const;

/*-----------------Internationalization functions----------------------*/
#ifdef IC_NLS
virtual IBuffer
 *subString ( unsigned startPos ) const;
#endif

/*------------------------------- Diagnostics --------------------------------*/
virtual IString
  asDebugInfo ( ) const;

/*--------------------------------- Testing ----------------------------------*/
virtual bool
  isAlphanumeric ( ) const,
  isAlphabetic   ( ) const,
  isASCII        ( ) const,
  isControl      ( ) const,
  isDigits       ( ) const,
  isGraphics     ( ) const,
  isHexDigits    ( ) const,
  isLowerCase    ( ) const,
  isPrintable    ( ) const,
  isPunctuation  ( ) const,
  isUpperCase    ( ) const,
  isWhiteSpace   ( ) const;

/*------------------------------- NLS Testing --------------------------------*/
virtual bool
  isMBCS       ( ) const,
  isDBCS       ( ) const,
  isSBCS       ( ) const,
  isValidMBCS  ( ) const,
  isValidDBCS  ( ) const,
  includesMBCS ( ) const,
  includesDBCS ( ) const,
  includesSBCS ( ) const;

/*--------------------------------- Searches ---------------------------------*/
virtual unsigned
  indexOf           ( const char*        pString,
                      unsigned           len,
                      unsigned           startPos = 1 ) const,
  indexOf           ( const IStringTest& aTest,
                      unsigned           startPos = 1 ) const,
  indexOfAnyBut     ( const char*        pString,
                      unsigned           len,
                      unsigned           startPos = 1 ) const,
  indexOfAnyBut     ( const IStringTest& aTest,
                      unsigned           startPos = 1 ) const,
  indexOfAnyOf      ( const char*        pString,
                      unsigned           len,
                      unsigned           startPos = 1 ) const,
  indexOfAnyOf      ( const IStringTest& aTest,
                      unsigned           startPos = 1 ) const,
  lastIndexOf       ( const char*        pString,
                      unsigned           len,
                      unsigned           startPos = 0 ) const,
  lastIndexOf       ( const IStringTest& aTest,
                      unsigned           startPos = 0 ) const,
  lastIndexOfAnyBut ( const char*        pString,
                      unsigned           len,
                      unsigned           startPos = 0 ) const,
  lastIndexOfAnyBut ( const IStringTest& aTest,
                      unsigned           startPos = 0 ) const,
  lastIndexOfAnyOf  ( const char*        pString,
                      unsigned           len,
                      unsigned           startPos = 0 ) const,
  lastIndexOfAnyOf  ( const IStringTest& aTest,
                      unsigned           startPos = 0 ) const;

/*--------------------------------- Editing ----------------------------------*/
virtual IBuffer
 *center       ( unsigned newLen,
                 char     padCharacter ),
 *change       ( const char* pSource,
                 unsigned    sourceLen,
                 const char* pTarget,
                 unsigned    targetLen,
                 unsigned    startPos,
                 unsigned    numChanges ),
 *copy         ( unsigned numCopies ),
 *insert       ( const char* pInsert,
                 unsigned    insertLen,
                 unsigned    pos,
                 char        padCharacter ),
 *leftJustify  ( unsigned newLen,
                 char     padCharacter ),
 *lowerCase    ( ),
 *overlayWith  ( const char* overlay,
                 unsigned    len,
                 unsigned    pos,
                 char        padCharacter ),
 *remove       ( unsigned startPos,
                 unsigned numChars ),
 *reverse      ( ),
 *rightJustify ( unsigned newLen,
                 char     padCharacter ),
 *strip        ( const char*            pChars,
                 unsigned               len,
                 IStringEnum::StripMode mode ),
 *strip        ( const IStringTest&     aTest,
                 IStringEnum::StripMode mode ),
 *translate    ( const char* pInputChars,
                 unsigned    inputLen,
                 const char* pOutputChars,
                 unsigned    outputLen,
                 char        padCharacter ),
 *upperCase    ( );

protected:

static bool is32bytesAligned;

#ifdef IC_PMWIN
static bool isDBCSLead(char inByte);
#endif


/*-------------------------- Search Initialization ---------------------------*/
virtual unsigned
  startSearch          ( unsigned startPos,
                         unsigned searchLen ) const,
  startBackwardsSearch ( unsigned startPos,
                         unsigned searchLen ) const;

/*-------------------------------- Allocation --------------------------------*/
virtual IBuffer
 *allocate        ( unsigned bufLength ) const;

#ifdef __DEBUG_ALLOC__
void
 *operator new    ( size_t      t,
                    const char* filename,
                    size_t      linenum,
                    unsigned    bufLen );
void
  operator delete ( void*       p,
                    const char* filename,
                    size_t      linenum );
#else
void
 *operator new    ( size_t   t,
                    unsigned bufLen );
void
  operator delete ( void*    p );
#endif

/*-------------------------------- Initialize --------------------------------*/
static IBuffer
 *initialize ( );

/*---------------------------- Protected Queries -----------------------------*/
virtual const char
 *className ( ) const;

/*-------------------------- Protected Constructors --------------------------*/
  IBuffer ( unsigned newLen );
virtual
 ~IBuffer ( );

private:
/*--------------------------------- Private ----------------------------------*/
unsigned
  len;
char
  data[1];

static IBuffer
 *nullBuffer;

static IBuffer
 *nullIBuffer;

#ifdef IC_PMWIN
/*-------------------------------- DBCS Table --------------------------------*/
static char
  dbcsTable[ 256 ];
#endif

friend class IString;
friend class IStaticObjectHelper<IBuffer>;
};

#pragma pack(pop)
#pragma enum(pop)

#if __IBMCPP__ >= 400
#pragma namemangling()
#endif

#include <ibuffer.inl>
#include <ibuffern.inl>

#endif // _IBUFFER_


#ifdef __MVS__
                   #pragma checkout(resume)
#endif

