//----------------------------------------------------------------------------
// FILE NAME: ibhandle.hpp
//
// DESCRIPTION:
//   Declaration of the classes:
//     IAnchorBlockHandle
//     IHandle
//     ISemaphoreHandle
//     IThreadId
//     IModuleHandle
//     IProcessId
//     IThreadHandle
//     IEnumHandle
//     IPrivateSemaphoreHandle
//     ISharedSemaphoreHandle
//
// COPYRIGHT:
//   IBM Open Class Library
//   Licensed Materials - Property of IBM
//
//   5645-001
//   (C) Copyright IBM Corporation 1992, 1997
//
// Revision: 80  1.7.1.9  source/core/base/ibhandle.hpp, appsupport, ioc.v400, 001006  
// ----------------------------------------------------------------------------

#ifndef _IBHANDLE_
#define _IBHANDLE_

#include <ibase.hpp>
#include <istring.hpp>

extern "C"
{
#ifdef IC_POSIX

    // define feature test macros
    #ifdef IC_MVS
        #ifndef _OPEN_THREADS
            #define _OPEN_THREADS
        #endif

        #ifndef _POSIX_SOURCE
            #define _POSIX_SOURCE
        #endif

        #include <asclocal.h>
        // force inclusion of feature.h in pthread.h
        #define __inc_features
    #endif

    #ifdef IC_MVS
        #undef  __inc_features
    #endif

    #include <unistd.h>
    #include <errno.h>
#endif

#ifdef ASC_DEBUG
    #include <stdio.h>
#endif
}

#include <ievtdata.hpp>

#if __IBMCPP__ >= 400
#pragma namemangling(compat)
#endif

class ostream;
class IString;
struct HINSTANCE__;
struct _XtAppStruct;

#ifndef IC_BUILD
class IHandle;
class IThreadId;
class IProcessId;
class IEnumHandle;
class IPrivateSemaphoreHandle;
class ISharedSemaphoreHandle;
class IModuleHandle;
class IAnchorBlockHandle;
inline ostream IC_EXPORTB &operator<<(ostream& aStream, const IHandle& aHandle);
inline ostream IC_EXPORTB &operator<< (ostream& aStream, const IThreadId& aHandle);
inline ostream IC_EXPORTB &operator<<(ostream& aStream, const IProcessId& aHandle);
inline ostream IC_EXPORTB &operator<<(ostream& aStream, const IEnumHandle& aHandle);
inline ostream IC_EXPORTB &operator<<(ostream& aStream, const IPrivateSemaphoreHandle& aHandle);
inline ostream IC_EXPORTB &operator<<(ostream& aStream, const ISharedSemaphoreHandle& aHandle);
inline ostream &operator<<(ostream& aStream, const IModuleHandle& aHandle);
inline ostream &operator<<(ostream& aStream, const IAnchorBlockHandle& aHandle);
#endif

#pragma pack(push,4)
#pragma enum(4)

class IC_EXPORTB IHandle
{
public:
    // ---------------------------------- Value -------------------------------
#ifdef IC_WIN
    typedef void*  Value;
#else
    typedef unsigned long Value;
#endif

    // ------------------------------- Constructors ---------------------------
    IHandle (Value value);

    // ------------------------------- Diagnostics ----------------------------
    IString asString() const;
    IString asDebugInfo() const;

    friend ostream IC_EXPORTB
        &operator<<(ostream& aStream, const IHandle& aHandle);

    unsigned long asUnsigned() const;

    // -------------------------------- Operators -----------------------------
    operator Value() const;

protected:
    // ---------------------------------- Value -------------------------------
    Value handle;
};


class IC_EXPORTB IThreadId
{
public:
    // ------------------------------- Constructors ---------------------------
    IThreadId();
    IThreadId(const IThreadId& tid );
    IThreadId& operator= ( const IThreadId& tid );

    IThreadId(unsigned long thid);

    // ------------------------------- Destructors ----------------------------
    ~IThreadId();


    // -------------------------------- Operators -----------------------------
    friend bool IC_EXPORTB operator==(  const IThreadId  &threadId1,
                                        const IThreadId  &threadId2);

    friend bool IC_EXPORTB operator!=(  const IThreadId  &threadId1,
                                        const IThreadId  &threadId2);

    bool isValid() const;


    // ------------------------------- Diagnostics ----------------------------
    IString asString() const;
    IString asDebugInfo() const;

    friend ostream IC_EXPORTB &
        operator<< (ostream& aStream, const IThreadId& aHandle );

    unsigned long asUnsigned() const;

    // -------------------------------- Operators -----------------------------
    operator unsigned long() const;

private:
    unsigned long   fSystemThreadId;
};


#ifdef IC_WIN
class IC_EXPORTB IThreadHandle
{
public:
    typedef void* Value;

    // ------------------------------- Constructors ---------------------------
    IThreadHandle(Value thread = 0);

    // -------------------------- Thread Handle Specifics ---------------------
    static const IThreadHandle IC_IMPORTB noHandle;

    // ------------------------------- Diagnostics ----------------------------
    IString asString() const;
    IString asDebugInfo() const;

    friend ostream  IC_EXPORTB
        &operator<<(ostream& aStream, const IThreadHandle& aHandle);

    unsigned long asUnsigned() const;

    // -------------------------------- Operators -----------------------------
    operator Value() const;

private:
    // ---------------------------------- Value -------------------------------
    Value handle;
};
#else
typedef IThreadId IThreadHandle;
#endif


class IC_EXPORTB IProcessId
{
public:
#ifdef IC_WIN
    typedef void* Value;
#else
    typedef unsigned long Value;
#endif

    // ------------------------------- Constructors ---------------------------
    IProcessId(Value pid = 0);

    // ------------------------------- Diagnostics ----------------------------
    IString asString() const;
    IString asDebugInfo() const;

    friend ostream IC_EXPORTB
        &operator<<(ostream& aStream, const IProcessId& aHandle);

    unsigned long asUnsigned() const;

    // -------------------------------- Operators -----------------------------
    operator Value() const;

private:
    // ---------------------------------- Value -------------------------------
    Value handle;

};


class IC_EXPORTB IEnumHandle
{
public:
#ifdef IC_WIN
    typedef void* Value;
#else
    typedef unsigned long Value;
#endif

    // ------------------------------- Constructors ---------------------------
    IEnumHandle(Value henum = 0);

    // ------------------------------- Diagnostics ----------------------------
    IString asString () const;
    IString asDebugInfo() const;

    friend ostream IC_EXPORTB
        &operator<<(ostream& aStream, const IEnumHandle& aHandle);

    unsigned long asUnsigned() const;

    // -------------------------------- Operators -----------------------------
    operator Value() const;

private:
    // ---------------------------------- Value -------------------------------
    Value handle;
};


class IC_EXPORTB IPrivateSemaphoreHandle
{
public:

#ifdef IC_PM
  typedef  unsigned long  Value;
#else
  typedef void* Value;
#endif

    // ------------------------------- Constructors ---------------------------
    IPrivateSemaphoreHandle(Value privSemId = 0);

#ifdef IC_POSIX
//     IPrivateSemaphoreHandle& operator=(pthread_mutex_t* privSemId);
    IPrivateSemaphoreHandle& operator=(Value privSemId);
#endif

    // ------------------------------- Destructors ----------------------------
    ~IPrivateSemaphoreHandle();

    // ------------------------------- Diagnostics ----------------------------
    IString asString() const;
    IString asDebugInfo() const;

    friend ostream IC_EXPORTB
        &operator<<(ostream& aStream, const IPrivateSemaphoreHandle& aHandle);

// #ifdef IC_PMWIN
    unsigned long asUnsigned() const;
// #endif

    // -------------------------------- Operators -----------------------------
    operator Value() const;


private:
    // ---------------------------------- Value -------------------------------
    Value fSystemPrivSemId;
};


class IC_EXPORTB ISharedSemaphoreHandle
{
public:
#ifdef IC_WIN
    typedef void* Value;
#else
    typedef unsigned long  Value;
#endif

    // ------------------------------- Constructors ---------------------------
    ISharedSemaphoreHandle(Value hsem = 0);

    // ------------------------------- Diagnostics ----------------------------
    IString asString() const;
    IString asDebugInfo() const;

    friend ostream IC_EXPORTB
        &operator<<(ostream& aStream, const ISharedSemaphoreHandle& aHandle);

    unsigned long asUnsigned() const;

    // -------------------------------- Operators -----------------------------
    operator Value() const;

private:
    // ---------------------------------- Value -------------------------------
    Value handle;
};

typedef ISharedSemaphoreHandle ISemaphoreHandle;

class IModuleHandle
{
public:
    // ---------------------------------- Value -------------------------------
#ifdef IC_MOTIF
    typedef void* Value;
#endif

#ifdef IC_PM
    typedef unsigned long Value;
#endif

#ifdef IC_WIN
 #ifdef IC_WIN_STRICT
    typedef HINSTANCE__* Value;
    // Both HINSTANCE__* and HMODULE__* are valid, and equivalent.
 #else
    typedef void* Value;
 #endif
#endif // IC_WIN

    // ------------------------------- Constructors ---------------------------
#ifdef IC_MOTIFPM
    IModuleHandle(Value value = 0);
#endif
#ifdef IC_WIN
 #ifdef IC_WIN_STRICT
  #ifdef IC_WIN_STRICT_HANDLES
    IModuleHandle ( Value value = 0 );
  #else
    IModuleHandle ( void* value = 0 );
  #endif
 #else
    IModuleHandle ( Value value = 0 );
 #endif
#endif // IC_WIN

    // ------------------------------- Diagnostics ----------------------------
    IString asString() const;
    IString asDebugInfo() const;

    friend ostream
        &operator<<(ostream& aStream, const IModuleHandle& aHandle);

    unsigned long asUnsigned() const;

    // -------------------------------- Operators -----------------------------
    operator Value() const;

private:
    // ---------------------------------- Value -------------------------------
    Value fhandle;
};

class IAnchorBlockHandle
{
public:
    // ---------------------------------- Value -------------------------------
#ifdef IC_MOTIF
    typedef _XtAppStruct*  Value;
#endif

#ifdef IC_PM
    typedef unsigned long Value;
#endif

#ifdef IC_WIN
    typedef void* Value;
#endif

    // ------------------------------- Constructors ---------------------------
    IAnchorBlockHandle(Value value = 0);

    // ------------------------------- Diagnostics ----------------------------
    IString asString() const;
    IString asDebugInfo() const;

    friend ostream
        &operator<<(ostream& aStream, const IAnchorBlockHandle& aHandle);

    unsigned long asUnsigned() const;

    // -------------------------------- Operators -----------------------------
    operator Value() const;

private:
    // ---------------------------------- Value -------------------------------
    Value fhandle;
};


#pragma enum(pop)
#pragma pack(pop)

#if __IBMCPP__ >= 400
#pragma namemangling()
#endif

#include <ibhandle.inl>

#endif // _IBHANDLE_
