//----------------------------------------------------------------------------
// FILE NAME: ibase.hpp
//
// DESCRIPTION:
//   Declaration of the classes:
//     IBase
//
// COPYRIGHT:
//   IBM Open Class Library
//   Licensed Materials - Property of IBM
//
//   5645-001
//   (C) Copyright IBM Corporation 1992, 1997  All Rights Reserved.
//
// Revision: 77  1.13.2.9  source/core/base/ibase.hpp, appsupport, ioc.v400, 001006  
//----------------------------------------------------------------------------

#ifndef _IBASE_
#define _IBASE_

#ifdef _MSC_VER
#pragma warning(once : 4068 4237 4103)
#endif

#include <ilanglvl.hpp>
#include <iexcbase.hpp>
#include <istream.hpp>

#ifdef __MVS__
#define  FALSE 0
#define  TRUE  1
#endif

// ---------------------------- Platform Macros ------------------------------
#ifndef  IC_PM
    #ifdef __OS2__
        #define IC_PM
    #endif
#endif

#ifndef  IC_WIN
    #ifdef __WINDOWS__
        #define IC_WIN
    #endif
#endif

#ifndef  IC_MOTIF
    #ifdef _sparc
        #define IC_MOTIF
    #endif
    #ifdef _AIX
        #define IC_MOTIF
    #endif
#endif


#if defined(IC_PM)
    #define IC_PMWIN
    #define IC_MOTIFPM
#endif

#if defined(IC_MOTIF)
    #define IC_MOTIFPM
    #define IC_MOTIFWIN
#endif

#if defined(IC_WIN)
    #define IC_PMWIN
    #define IC_MOTIFWIN
#endif

#if defined(__sparc)
    #ifndef IC_SUN
        #define IC_SUN
    #endif
#endif

#ifdef __OS400__
    #ifndef IC_400
        #define IC_400
    #endif
#endif

#ifdef __MVS__
    #ifndef IC_MVS
        #define IC_MVS
    #endif
    #ifndef IC_NONGUI
        #define IC_NONGUI
    #endif
    #ifndef IC_POSIX
        #define IC_POSIX
    #endif
#endif

#if defined(IC_MVS)
    #define IC_MVS400
#endif

#if defined(IC_400)
    #define IC_MVS400
#endif

#if defined(IC_PM_FLAGNOP)
    #define IC_PMWIN_FLAGNOP
    #define IC_MOTIFPM_FLAGNOP
#endif

#if defined(IC_MOTIF_FLAGNOP)
    #define IC_MOTIFPM_FLAGNOP
    #define IC_MOTIFWIN_FLAGNOP
#endif

#if defined(IC_WIN_FLAGNOP)
    #define IC_PMWIN_FLAGNOP
    #define IC_MOTIFWIN_FLAGNOP
#endif

// ------------------------------ Version Levels ------------------------------
#ifdef IC_WIN
#define IC_MAJOR_VERSION 400
#define IC_MINOR_VERSION 300
#endif

#ifdef IC_PM
#define IC_MAJOR_VERSION 400
#define IC_MINOR_VERSION 100
#endif

#ifdef IC_MOTIF
#define IC_MAJOR_VERSION 400
#define IC_MINOR_VERSION 300
#endif

#ifdef IC_400
#define IC_MAJOR_VERSION 310
#define IC_MINOR_VERSION 0
#endif

#ifdef IC_MVS
#define IC_MAJOR_VERSION 310
#define IC_MINOR_VERSION 0
#endif


#define IC_OBSOLETE_1    310
#define IC_OBSOLETE_2    400
#define IC_OBSOLETE_3    410

// ----------------------------- Obsolete Levels ------------------------------
#ifndef IC_OBSOLETE
    #ifdef IC_WIN
        #define IC_OBSOLETE  400
    #endif

    #ifdef IC_PM
        #define IC_OBSOLETE  400
    #endif

    #ifdef IC_MOTIF
        #define IC_OBSOLETE  400
    #endif

    #ifdef IC_400
        #define IC_OBSOLETE  310
    #endif

    #ifdef IC_MVS
        #define IC_OBSOLETE  310
    #endif
#endif

#if __IBMCPP__ >= 400
#pragma namemangling(compat)
#endif

class IString;

#if ( IC_OBSOLETE <= IC_OBSOLETE_3 )

#ifndef IC_BUILD
class IBase;
inline ostream& IC_EXPORTB operator<<(ostream &aStream, const IBase &anObject);
#endif

#pragma pack(push,4)
#pragma enum(4)

class IC_EXPORTB IBase
{
public:
    // --------------------------- bool Definitions ---------------------------
    #if ( IC_OBSOLETE <= IC_OBSOLETE_2 )
    typedef bool Boolean;
    #endif

    // ------------------------------ Messages --------------------------------
    static char* messageFile( );

    static void setMessageFile ( const char *msgFileName );

    static IMessageText
    messageText(unsigned long messageId,
                const char*   textInsert1 = 0,
                const char*   textInsert2 = 0,
                const char*   textInsert3 = 0,
                const char*   textInsert4 = 0,
                const char*   textInsert5 = 0,
                const char*   textInsert6 = 0,
                const char*   textInsert7 = 0,
                const char*   textInsert8 = 0,
                const char*   textInsert9 = 0 );

    // ------------------------------- Diagnostics ----------------------------
    friend ostream& IC_EXPORTB
    operator <<( ostream &aStream, const IBase &anObject );

    char* asText() const;

    IString asString() const;

    IString asDebugInfo() const;

    struct Version
    {
        unsigned short major;
        unsigned short minor;
    };

    static Version version();

protected:
    // -------------------------- Exception Severity --------------------------
    static const IException::Severity IC_IMPORTB unrecoverable;
    static const IException::Severity IC_IMPORTB recoverable;

private:
    // ------------------------------- Private --------------------------------
};

#pragma enum(pop)
#pragma pack(pop)

#if __IBMCPP__ >= 400
#pragma namemangling()
#endif

inline ostream &operator<<(ostream& aStream, const IBase& anObject)
{
    char* pszText = anObject.asText();
    aStream << pszText;
    delete pszText;
    return aStream;
}

#endif // ( IC_OBSOLETE <= IC_OBSOLETE_3 )


// -------------------------- Static Object Priority --------------------------
#define IBASE_PRIORITY -2147483647 - 1 + 1024

// with NLS (wide char) support
#define IC_NLS

// has restartable version
#define IC_HAS_RESTARTABLE

#ifdef _MSC_VER
    #define _System __stdcall
    #define _Optlink __fastcall
#endif

#ifdef __xlC__
#ifndef __THW_PPC__
    #define _System
    #define _Optlink
#endif
#endif

#ifdef __OS400__
    #define _System
    #define _Optlink
#endif

#ifdef  __MVS__
    #define _System
    #define _Optlink
#endif


#ifdef __OS400__
    // AS/400 NLS-enabled in V3 R7
    // #undef IC_NLS
    #undef IC_HAS_RESTARTABLE
#endif

#ifdef _sparc
    #undef IC_NLS
    #undef IC_HAS_RESTARTABLE
#endif

#ifdef _AIX
    #undef IC_HAS_RESTARTABLE
#endif

#ifdef IC_WIN
// --------------- Type-Checking Strictness for Handle Classes ----------------
// Notes: IC_WIN_STRICT is used to mirror the setting of STRICT in
//        the Windows SDK file, WinDef.h. Applications are not intended
//        to set this macro.
//        IC_WIN_STRICT_HANDLES controls the degree that IOC enforces
//        the use of SDK STRICT handle types. This macro should be
//        defined by applications that want maximum type checking. Note
//        that defining this has the potential to break existing code.
 #ifndef IC_WIN_STRICT
  #ifdef STRICT
   #define IC_WIN_STRICT
  #else
   // This covers the case when WinDef.h is brought in after this file.
   // Default to IC_WIN_STRICT, in the same manner as WinDef.h defaults
   // to STRICT in the Windows 2000 SDK. To use an older SDK with a
   // different default, comment out the next three lines.
   #ifndef NO_STRICT
    #define IC_WIN_STRICT
   #endif
  #endif // STRICT
 #endif // ! IC_WIN_STRICT
#endif // IC_WIN

// ----------------------- Functions Excluded from Documentation --------------
#ifndef _ISYNONYM_
#include <isynonym.hpp>
#endif

#ifdef IC_PMWIN
#  ifdef _MSC_VER
#    ifndef _MT
#      error Error: Use of IBM Open Class Library requires the /MD compiler option. Check the makefile (or its profile) for a missing /MD option.
#    endif
#  else // ! _MSC_VER
#    ifndef __MULTI__
#      if __IBMCPP__ >= 400
#        error Error: Use of IBM Open Class Library requires the "link(linkWithMultithreadLib, yes)" option.
#      else // __IBMCPP__ < 400
#        error Error: Use of IBM Open Class Library requires the /Gm+ compiler option. Check the makefile (or its profile) for a missing /Gm+ option.
#      endif // __IBMCPP__ >= 400
#    endif // __MULTI__
#  endif // _MSC_VER
#else // ! IC_PMWIN
// AIX4.3 and AS/400 runtimes are really thread safe
#  if ! defined(_AIX43) && ! defined(__OS400__)
#    if __IBMCPP__ >= 400
#      ifndef __VACPP_MULTI__
#        error Error: Use of IBM Open Class Library requires the "defaults(xlC_r)" option or the "vacbld_r" command.
#      endif // __VACPP_MULTI__
#    else // __IBMCPP__ >= 400
#      ifndef _THREAD_SAFE
#        error Error: Use of IBM Open Class Library requires the "xlC_r" command.
#      endif // _THREAD_SAFE
#    endif // __IBMCPP__ >= 400
#  endif // _AIX43
#endif // IC_PMWIN

#endif // _IBASE_
