// ----------------------------------------------------------------------------
// FILE NAME: ibase.cpp
//
// DESCRIPTION:
//   This file contains the implementation of classes/functions declared
//   in ibase.hpp.
//
//
// COPYRIGHT:
//   IBM Open Class Library
//   Licensed Materials - Property of IBM
//
//   5645-001
//   (C) Copyright IBM Corporation 1992, 1997  All Rights Reserved.
//
//   US Government Users Restricted Rights - Use, duplication, or
//   disclosure restricted by GSA ADP Schedule Contract with IBM Corp.
//
// Revision: 76 1.6.2.2 source/core/base/ibase.cpp, appsupport, ioc.v400, 001006 
// ----------------------------------------------------------------------------
#include <ibase.hpp>

#ifdef IC_MOTIF
extern "C"
{
#include <pthread.h>
}
#endif

#include <ireslock.hpp>
#include <new.h>

#ifdef IC_PMWIN
#define INCL_DOSMODULEMGR
#endif

extern "C"
{
    #include <stdlib.h>
    #include <stdio.h>
}

#include <istring.hpp>
#include <icconsta.h>
#include <itrace.hpp>
#include <iexcept.hpp>

// Segment definitions
#ifdef IC_PAGETUNE
    #define _IBASE_CPP_
    #include <ipagetun.h>
#endif

#ifdef IC_MOTIF
// defect 29176
int __page_size;
int __page_size_K;
int __page_sizeX16;
int __page_sizeX24;
int __page_sizeM1;
pthread_mutex_t  _mutex_global_np;
#endif

#ifndef IC_MVS

//
// for MVS - this struct is defined in  ASCLOCAL.H
// Local struct for library initialization.
//
struct ICLUI_Init : IException::TraceFn
{
    ICLUI_Init();
    ~ICLUI_Init();
    virtual void write(const char *exceptionText);
    static void newHandler();
};

#endif


// Dump Memory statistics
#ifdef __DEBUG_ALLOC__
class IDumpAllRemainingStorage
{
public:
    ~IDumpAllRemainingStorage()
    {
        _dump_allocated(20);
    }
};

static IDumpAllRemainingStorage dumpIt;
#endif

#ifndef IC_MVS
// For MVS it is moved to IEXCBASE.CPP
static ICLUI_Init initializer;
#endif

ICLUI_Init ::   ICLUI_Init()
{
    // Add this object as exception trace function:
    IException::setTraceFunction( *this );
//  Register newHandler function:

#if !defined (__RRBC_LIB__)
    // SOM Version uses different linkages
    set_new_handler( ICLUI_Init::newHandler );
#endif
}


ICLUI_Init :: ~ICLUI_Init()
{
}


void ICLUI_Init :: write ( const char *exceptionText )
{
    ITrace log;
    log.write(exceptionText);
}

void ICLUI_Init::newHandler()
{
#ifdef IC_MOTIF
  IOutOfMemory exception(IMessageText(IC_HEAP_EXHAUSTED),
                           IC_HEAP_EXHAUSTED, IException::unrecoverable);
  ITHROW( exception );
#else
  ITHROWLIBRARYERROR(IC_HEAP_EXHAUSTED,
                     IBaseErrorInfo::outOfMemory,
                     IException::unrecoverable);
#endif
}

#if ( IC_OBSOLETE <= IC_OBSOLETE_3 )

// Initialize synonyms for IException::Severity
const IException::Severity IBase::unrecoverable = IException::unrecoverable;
const IException::Severity IBase::recoverable   = IException::recoverable;


/*------------------------------------------------------------------------------
| functions related to message file handling                                   |
------------------------------------------------------------------------------*/
char* IBase :: messageFile ( )
{
    return IMessageText::messageFile();
}

void IBase :: setMessageFile ( const char *msgFileName )
{
    IMessageText::setMessageFile(msgFileName);
}

/*-----------------------------------------------------------------------------
| messageText - returns the message specified by "messageId",                 |
| with the specified text strings inserted at the proper places.              |
-----------------------------------------------------------------------------*/
IMessageText IBase :: messageText ( unsigned long messageId,
                                    const char*   textInsert1,
                                    const char*   textInsert2,
                                    const char*   textInsert3,
                                    const char*   textInsert4,
                                    const char*   textInsert5,
                                    const char*   textInsert6,
                                    const char*   textInsert7,
                                    const char*   textInsert8,
                                    const char*   textInsert9 )
{
    IMessageText msg(messageId, IMessageText::messageFile(),
                    textInsert1, textInsert2, textInsert3,
                    textInsert4, textInsert5, textInsert6,
                    textInsert7, textInsert8, textInsert9);
    return msg;
}

char* IBase::asText() const
{
    // <TBD> Just testing now
    return "Testing";
}

IString IBase::asString ( ) const
{
    return "IBase object";
}

IString IBase::asDebugInfo ( ) const
{
    IString result = "IBase(@";
    result += IString( (unsigned long)this ).d2x();
    result += ")";
    return result;
}

IBase::Version IBase::version()
{
    Version current = { IC_MAJOR_VERSION, IC_MINOR_VERSION };
    return current;
}

#endif // ( IC_OBSOLETE <= IC_OBSOLETE_3 )
