/*
******************************************************************************
*                                                                              *
* COPYRIGHT:                                                                   *
*   IBM Open Class Library                                                     *
*   (C) Copyright Taligent, Inc.,  1996                                        *
*   (C) Copyright International Business Machines Corporation,  1997           *
*   Licensed Material - Program-Property of IBM - All Rights Reserved.         *
*   US Government Users Restricted Rights - Use, duplication, or disclosure    *
*   restricted by GSA ADP Schedule Contract with IBM Corp.                     *
*                                                                              *
********************************************************************************
||
||  File:       pixbuf.inl
||
||  What:       Routines which stores the image data read in both original
||                              data and also in native image format
||
||              Copyright(C) 1996 Taligent, Inc. All rights reserved.
||
*/

// Revision: 74 1.6.1.1 source/albert/graph2d/pixbuf.inl, 2d, ioc.v400, 001006 

#ifndef _PIXBUF_INL_
#define _PIXBUF_INL_

inline unsigned long IPixelBuffer::handle() const
{
	//update the fBitmap if image has changed
	if(bImgUpdated){
		((IPixelBuffer*)this)->updateNativeImage();
	}
#ifdef IC_MOTIF
        return (((IXDC*)fBitmapHDC)->xDrawable);
#else
        return (unsigned long)fBitmap;
#endif
}

inline nativeImage IPixelBuffer::imageHandle() const
{
#ifdef IC_MOTIF
	//sync image drawn on the Pixmap to Ximage
	((IPixelBuffer*)this)->syncXImageFromPixmap(); 
#endif //IC_MOTIF

	//update the fBitmap if image has changed
	if(bImgUpdated){
		((IPixelBuffer*)this)->updateNativeImage();
	}
        return fBitmap;
}


inline bool IPixelBuffer::operator== (const IPixelBuffer& src) const
{
        return  isEqual(src);
}

inline bool IPixelBuffer::operator!= (const IPixelBuffer& src) const
{
        return  !isEqual(src);
}

inline IPresSpaceHandle IPixelBuffer::deviceContext() const
{
        return fBitmapHDC;
}

// reference counting stuff

inline unsigned long IPixelBuffer::refCount() const
{
        return fRefCount;
}

inline void IPixelBuffer::incrementCount()
{
        ++fRefCount;
}

inline void IPixelBuffer::decrementCount()
{
        --fRefCount;
}

inline unsigned long IPixelBuffer::width() const
{
        return  fWidth;
}

inline unsigned long IPixelBuffer::height() const
{
        return  fHeight;
}

inline unsigned long IPixelBuffer::xHotSpot() const
{
        return  xHot;
}

inline unsigned long IPixelBuffer::yHotSpot() const
{
        return  yHot;
}

inline IGImagePixelAccessor::EImageFormat IPixelBuffer::sourceImageFormat() const
{
        return srcImageFormat;
}

inline void IPixelBuffer::setImageUpdated(bool upd)
{
        bImgUpdated = upd;
}

inline bool IPixelBuffer::imageUpdated() const
{
        return bImgUpdated;
}
inline void IPixelBuffer::setImageSync(bool upd)
{
        bSyncImage = upd;
}

inline bool IPixelBuffer::imageSync() const
{
        return bSyncImage;
}

#ifdef IC_MOTIF
inline void IPixelBuffer::setXImageSyncFromPixmap(bool upd)
{
        bSyncXImageFromPixmap = upd;
}

inline bool IPixelBuffer::xImageSyncFromPixmap() const
{
        return bSyncXImageFromPixmap;
}
#endif //IC_MOTIF

inline iBYTE IPixelBuffer::bitsPerPixel() const
{
        return fBitsPerPixel;
}

inline unsigned long IPixelBuffer::pixelStride() const
{
        return fPixelStride;
}

inline bool IPixelBuffer::pointInImage(const IGPoint2D& pnt) const
{
        long x = (long)pnt.fX,
                y = (long)pnt.fY;

        if((( x >= 0) && ( x < fWidth)) &&
                (( y >= 0) && ( y < fHeight)))
                return true;

        return false;
}

inline bool IPixelBuffer::rectInImage(const IGRect2D& rect) const
{
        long tx = (long)rect.fLeft,
                ty = (long)rect.fTop,
                bx = (long)rect.fRight,
                by = (long)rect.fBottom;

        if((( tx >= 0) && ( tx < fWidth)) &&
                (( ty >= 0) && ( ty < fHeight)) &&
                (( bx >= 0) && ( bx < fWidth)) &&
                (( by >= 0) && ( by < fHeight)))
                return true;

        return false;
}

inline void IPixelBuffer::reflectHorizontaly()
{
        framebufferFlip(false, true);
        bImgUpdated = true;
}

inline void IPixelBuffer::reflectVerticaly()
{
        framebufferFlip(true, false);
        bImgUpdated = true;
}

inline void IPixelBuffer::rotate180()
{
        framebufferFlip(false, false);
        bImgUpdated = true;
}

inline void IPixelBuffer::rotate90()
{
        framebufferRotate(false);
}

inline void IPixelBuffer::rotate270()
{
        framebufferRotate(true);
}

//Transparency Related functions
inline void IPixelBuffer::setTransparencyFlag(bool flag)
{
        bTransparencyEnabled = flag;
}

inline bool IPixelBuffer::transparencyFlag()
{
        return bTransparencyEnabled ;
}

inline void IPixelBuffer::setTransparencyColor(const IBaseColor& clr)
{
        transparencyClr = clr;
}

inline IBaseColor IPixelBuffer::transparencyColor() const
{
        return transparencyClr ;
}

inline IPixelBuffer::IPixelBuffer (const IPixelBuffer& source)
{
        fRefCount=source.fRefCount;
        srcImageFormat=source.srcImageFormat;
        fWidth=source.fWidth;
        fHeight=source.fHeight;
        xHot=source.xHot;
        yHot=source.yHot;
        fBitsPerPixel=source.fBitsPerPixel;
        fPixelStride=source.fPixelStride;
        bImgUpdated=source.bImgUpdated;
        bSyncImage = source.bSyncImage;
        fBitmap = source.fBitmap;
        fMaskBitmap = source.fMaskBitmap;
        fBitmapHDC = source.fBitmapHDC;
        bTransparencyEnabled = source.bTransparencyEnabled;
        transparencyClr = source.transparencyClr;
        fImage=source.fImage;
#ifdef IC_MOTIF
		bSyncXImageFromPixmap = source.bSyncXImageFromPixmap;
#endif //IC_MOTIF
}

inline IPixelBuffer& IPixelBuffer::operator= (const IPixelBuffer& source)
{
        fRefCount=source.fRefCount;
        srcImageFormat=source.srcImageFormat;
        fWidth=source.fWidth;
        fHeight=source.fHeight;
        xHot=source.xHot;
        yHot=source.yHot;
        fBitsPerPixel=source.fBitsPerPixel;
        fPixelStride=source.fPixelStride;
        bImgUpdated=source.bImgUpdated;
        bSyncImage = source.bSyncImage;
        fBitmap = source.fBitmap;
        fMaskBitmap = source.fMaskBitmap;
        fBitmapHDC = source.fBitmapHDC;
        bTransparencyEnabled = source.bTransparencyEnabled;
        transparencyClr = source.transparencyClr;
        fImage=source.fImage;
#ifdef IC_MOTIF
		bSyncXImageFromPixmap = source.bSyncXImageFromPixmap;
#endif //IC_MOTIF

        return(*this);
}

inline void IPixelBuffer::copyPixelBuffer(const IPixelBuffer& source)
{
        fRefCount=1;
        fBitmap=0;
        fMaskBitmap=0;
        srcImageFormat=source.srcImageFormat;
        fWidth=source.fWidth;
        fHeight=source.fHeight;
        xHot=source.xHot;
        yHot=source.yHot;
        fBitsPerPixel=source.fBitsPerPixel;
        fPixelStride=source.fPixelStride;
        bImgUpdated=true;
        bSyncImage = false;
        bTransparencyEnabled = source.bTransparencyEnabled;
        transparencyClr = source.transparencyClr;
#ifdef IC_MOTIF
		bSyncXImageFromPixmap = source.bSyncXImageFromPixmap;
#endif //IC_MOTIF

        fImage= new iBYTE[fHeight * fPixelStride];

        memcpy(fImage, source.fImage, (size_t)(fHeight * fPixelStride));
        initializeDeviceContext();
	convertToNativeImage();
}

inline IR8G8B8A8PixelBuffer::IR8G8B8A8PixelBuffer (const IR8G8B8A8PixelBuffer& source)

{
}

inline IR8G8B8A8PixelBuffer& IR8G8B8A8PixelBuffer::operator= (const IR8G8B8A8PixelBuffer& source)
{
        IPixelBuffer::operator=(source);

        return(*this);
}
inline bool IR8G8B8A8PixelBuffer::operator==(const IPixelBuffer& src) const
{
        return  isEqual(src);
}

inline bool IR8G8B8A8PixelBuffer::operator!= (const IPixelBuffer& src) const
{
        return  !isEqual(src);
}

inline nativeImage IR8G8B8A8PixelBuffer::convertToNativeImage(const iBYTE *srcImg)
{
        return(buildNativeImage(srcImg));
}

inline unsigned long IR8G8B8A8PixelBuffer::createPatternImage()
{
        return(buildPatternImage());
}

inline bool IR8G8B8A8PixelBuffer::isEqual (const IPixelBuffer& obj) const
{
        if(IPixelBuffer::isEqual(obj))
                return true;

        return false;
}

//Dosent have colortable but need support
inline IRGBAColorArray* IR8G8B8A8PixelBuffer::colorTable()
{
        return( NULL);
}
inline void IR8G8B8A8PixelBuffer::setColorTable(const IRGBAColorArray &colorTable)
{
}

inline IR8G8B8PixelBuffer::IR8G8B8PixelBuffer (const IR8G8B8PixelBuffer& source) :
                IPixelBuffer(source)
{
}

inline IR8G8B8PixelBuffer& IR8G8B8PixelBuffer::operator= (const IR8G8B8PixelBuffer& source)
{
        IPixelBuffer::operator=(source);

        return(*this);
}
inline bool IR8G8B8PixelBuffer::operator== (const IPixelBuffer& src) const
{
        return  isEqual(src);
}

inline bool IR8G8B8PixelBuffer::operator!= (const IPixelBuffer& src) const
{
        return  !isEqual(src);
}

inline nativeImage IR8G8B8PixelBuffer::convertToNativeImage(const iBYTE *srcImg)
{
        return(buildNativeImage(srcImg));
}

inline unsigned long IR8G8B8PixelBuffer::createPatternImage()
{
        return(buildPatternImage());
}


inline bool IR8G8B8PixelBuffer::isEqual (const IPixelBuffer& obj) const
{
        if(IPixelBuffer::isEqual(obj))
                return true;

        return false;
}

//Dosent have colortable but need support
inline IRGBAColorArray* IR8G8B8PixelBuffer::colorTable()
{
        return( NULL);
}
inline void IR8G8B8PixelBuffer::setColorTable(const IRGBAColorArray &colorTable)
{
}

inline IR5G6B5PixelBuffer::IR5G6B5PixelBuffer (const IR5G6B5PixelBuffer& source) :
        IPixelBuffer(source)
{
}
inline IR5G6B5PixelBuffer& IR5G6B5PixelBuffer::operator= (const IR5G6B5PixelBuffer& source)
{
        IPixelBuffer::operator=(source);
        return(*this);
}
inline bool IR5G6B5PixelBuffer::operator== (const IPixelBuffer& src) const
{
        return  isEqual(src);
}
inline bool IR5G6B5PixelBuffer::operator!= (const IPixelBuffer& src) const
{
        return  !isEqual(src);
}
inline nativeImage IR5G6B5PixelBuffer::convertToNativeImage(const iBYTE *srcImg)
{
        return(buildNativeImage(srcImg));
}

inline unsigned long IR5G6B5PixelBuffer::createPatternImage()
{
        return(buildPatternImage());
}

inline bool IR5G6B5PixelBuffer::isEqual (const IPixelBuffer& obj) const
{
        if(IPixelBuffer::isEqual(obj))
                return true;
        return false;
}

//Dosent have colortable but need support
inline IRGBAColorArray* IR5G6B5PixelBuffer::colorTable()
{
        return( NULL);
}
inline void IR5G6B5PixelBuffer::setColorTable(const IRGBAColorArray &colorTable)
{
}

inline ICLUT8PixelBuffer::ICLUT8PixelBuffer (const ICLUT8PixelBuffer& source) :
        IPixelBuffer(source)
{
//        fColorTable = *(new IRGBAColorArray(source.fColorTable));
        fColorTable = source.fColorTable;
}
inline ICLUT8PixelBuffer& ICLUT8PixelBuffer::operator= (const ICLUT8PixelBuffer& source)
{
        IPixelBuffer::operator=(source);
        fColorTable = source.fColorTable;
        return(*this);
}
inline bool ICLUT8PixelBuffer::operator== (const IPixelBuffer& src) const
{
        return  isEqual(src);
}
inline bool ICLUT8PixelBuffer::operator!= (const IPixelBuffer& src) const
{
        return  !isEqual(src);
}
inline nativeImage ICLUT8PixelBuffer::convertToNativeImage(const iBYTE *srcImg)
{
        return(buildNativeImage(srcImg,&fColorTable));
}

inline unsigned long ICLUT8PixelBuffer::createPatternImage()
{
        return(buildPatternImage(&fColorTable));
}

inline bool ICLUT8PixelBuffer::isEqual (const IPixelBuffer& obj) const
{
        if((IPixelBuffer::isEqual(obj)) &&
                (fColorTable == ((ICLUT8PixelBuffer*)&obj)->fColorTable))
                return true;
        return false;
}
inline IRGBAColorArray* ICLUT8PixelBuffer::colorTable()
{
        return(&fColorTable);
}
inline void ICLUT8PixelBuffer::setColorTable(const IRGBAColorArray &colorTable)
{
        fColorTable = colorTable;
                //colorTable Updated modify the native image
                buildNativeImage(NULL, &fColorTable);
}

inline ICLUT4PixelBuffer::ICLUT4PixelBuffer (const ICLUT4PixelBuffer& source) :
        IPixelBuffer(source)
{
//        fColorTable = *(new IRGBAColorArray(source.fColorTable));
        fColorTable = source.fColorTable;        
}
inline ICLUT4PixelBuffer& ICLUT4PixelBuffer::operator= (const ICLUT4PixelBuffer& source)
{
        IPixelBuffer::operator=(source);
        fColorTable = source.fColorTable;
        return(*this);
}
inline bool ICLUT4PixelBuffer::operator== (const IPixelBuffer& src) const
{
        return  isEqual(src);
}
inline bool ICLUT4PixelBuffer::operator!= (const IPixelBuffer& src) const
{
        return  !isEqual(src);
}
inline nativeImage ICLUT4PixelBuffer::convertToNativeImage(const iBYTE *srcImg)
{
        return(buildNativeImage(srcImg,&fColorTable));
}

inline unsigned long ICLUT4PixelBuffer::createPatternImage()
{
        return(buildPatternImage(&fColorTable));
}

inline bool ICLUT4PixelBuffer::isEqual (const IPixelBuffer& obj) const
{
        if((IPixelBuffer::isEqual(obj)) &&
                (fColorTable == ((ICLUT4PixelBuffer*)&obj)->fColorTable))
                return true;
        return false;
}
inline IRGBAColorArray* ICLUT4PixelBuffer::colorTable()
{
        return(&fColorTable);
}
inline void ICLUT4PixelBuffer::setColorTable(const IRGBAColorArray &colorTable)
{
        fColorTable = colorTable;
                //colorTable Updated modify the native image
                buildNativeImage(NULL, &fColorTable);
}

inline IMonochromePixelBuffer::IMonochromePixelBuffer (const IMonochromePixelBuffer& source) :
                IPixelBuffer(source)
{
//        fColorTable = *(new IRGBAColorArray(source.fColorTable));
        fColorTable = source.fColorTable;        
}
inline IMonochromePixelBuffer& IMonochromePixelBuffer::operator= (const IMonochromePixelBuffer& source)
{
        IPixelBuffer::operator=(source);
        fColorTable = source.fColorTable;
        return(*this);
}
inline bool IMonochromePixelBuffer::operator== (const IPixelBuffer& src) const
{
        return  isEqual(src);
}
inline bool IMonochromePixelBuffer::operator!= (const IPixelBuffer& src) const
{
        return  !isEqual(src);
}
inline nativeImage IMonochromePixelBuffer::convertToNativeImage(const iBYTE *srcImg)
{
        return(buildNativeImage(srcImg,&fColorTable));
}

inline unsigned long IMonochromePixelBuffer::createPatternImage()
{
        return(buildPatternImage(&fColorTable));
}

inline bool IMonochromePixelBuffer::isEqual (const IPixelBuffer& obj) const
{
        if((IPixelBuffer::isEqual(obj)) &&
                (fColorTable == ((IMonochromePixelBuffer*)&obj)->fColorTable))
                return true;
        return false;
}
inline IRGBAColorArray* IMonochromePixelBuffer::colorTable()
{
        return(&fColorTable);
}
inline void IMonochromePixelBuffer::setColorTable(const IRGBAColorArray &colorTable)
{
        fColorTable = colorTable;
                //colorTable Updated modify the native image
                buildNativeImage(NULL, &fColorTable);
}
#endif //_PIXBUF_INL_
