/* NOSHIP */
#ifndef _IXLFDSTR_
#define _IXLFDSTR_

// <prologue>
// <copyright>
/******************************************************************************
* COPYRIGHT:                                                                  *
*   IBM Open Class Library                                                    *
*   Licensed Materials - Property of IBM                                      *
*   (C) Copyright IBM Corp. 1992, 2000.  All Rights Reserved.                 *
*   US Government Users Restricted Rights - Use, duplication, or disclosure   *
*   restricted by GSA ADP Schedule Contract with IBM Corp.                    *
*                                                                             *
******************************************************************************/
// </copyright>
//
// Revision: 01 1.2 source/albert/graph2d/ixlfdstr.hpp, 2d, ioc.v400, 001006 
//
// </prologue>
// <header>

// <include-files>
#include <ibase.hpp>
#include <istring.hpp>
#include <ixdc.hpp>
#include <irel.h>
// </include-files>

// <pragmas - info/report>
#pragma info(none)
#pragma report(level, __IOC_HEADER_REPORT_LEVEL)
#pragma info(restore)
// </pragma info/report>

// <pragma namemangling/enum/pack/align>
#if __IBMCPP__ >= 400
#pragma namemangling(__IOC_NAMEMANGLING_SCHEME)
#endif /* __IBMCPP__ */
#if __IBMCPP__ >= 500
#pragma object_model(__IOC_OBJECT_MODEL)
#endif /* __IBMCPP__ */

#pragma enum(4)

#if defined(__TOS_WIN__) || defined(__TOS_OS2__)
  #pragma pack(push,4)
#endif
#if defined(__TOS_AIX__)
  #pragma options align=power
#endif
// </pragma namemangling/enum/pack/align>
// <defines>
// </defines>

// <forward-declarations>
class IXLFDString;
typedef IRelation<IXLFDString, IString> IFontList;
IString const& key(IXLFDString const& f);
// </forward-declarations>

// <class-declarations>

// Locations of fields within an XLFD

class IXLFDString {
/*******************************************************************************
* Class to wrapper XLFD string.                                                *
*******************************************************************************/
public:
/*------------------------- Constructors/Destructor ----------------------------
   You can create an IXLFDString object from a null terminated character
   string.  Typically, this string is obtained via XFontList or similar
   technique.  IXLFDString does very little error checking, so the input
   should NOT be raw user input or resource file contents.
------------------------------------------------------------------------------*/
   IXLFDString() ;
   IXLFDString( const char * rawXLFD ) ;
   IXLFDString( const IXLFDString& orig);   
   ~IXLFDString() ;
   
   IXLFDString& operator=( const IXLFDString& orig);
   bool  operator == ( const IXLFDString& rhs ) const;

/*----------------- Accessing Information About the Font -----------------------
   Functions for manipulating the fields of an XLFD
     isBold       - returns true if the font is bold
     isItalic     - returns true if the font is italic
     isScalable   - returns true if the font is scalable
     foundryName  - returns the FOUNDRY field of the font
     familyName   - returns the FAMILY_NAME field of the font
     weightName   - returns the WEIGHT_NAME field of the font
     slant        - returns the SLANT field of the font
     pixelSize    - returns the PIXEL_SIZE field of the font
     pointSize    - returns the POINT_SIZE field of the font
     spacing      - returns the SPACING field of the font
     averageWidth - returns the AVERAGE_WIDTH field of the font
     charsetRegistry - returns the CHARSET_REGISTRY of the font
     charsetEncoding - returns the CHARSET_ENCODING of the font
     pointSizes   - returns the possible point size(s) for this font
     
     isVector - this is used to keep track of how a font was created
------------------------------------------------------------------------------*/
bool
   isBold() const,
   isItalic() const,
   isScalable() const,
   isFixed() const,
   isVector() const;   

IString
   foundryName() const,
   familyName() const,
   weightName() const,
   slant() const,
   spacing() const,
   charsetRegistry() const,
   charsetEncoding() const;
IString const& keyName() const;
IString const& keyNameLong() const;
IString const asString() const;
static IFontList* getFontListForCurrentLocale(Display* display);
static IString fontListLocale;

unsigned long
   pixelSize() const,
   pointSize() const,
   averageWidth() const;

/*----------------- Setting Information About the Font -------------------------
     setPointSize - sets the point size value in the XLFD.  Should only
                    be done for scalable fonts.
------------------------------------------------------------------------------*/
IXLFDString
   &setPointSize( unsigned long newPointSize );

/*------------------------- Accessor -------------------------------------------
     value  - returns the whole XLFD string
------------------------------------------------------------------------------*/

IString
   value() const;//  {return xlfdCl;};

IXLFDString& setWord( IString val, short index);
IString getWord( short index);

typedef enum {FOUNDRY=1
							,NAME=2
							,WEIGHT=3
							,SLANT=4
							,SETWIDTH=5
							,SIXTHWORD=6
							,PIXELS=7
							,POINTSIZE=8
							,RESX=9
							,RESY=10
							,SPACING=11
							,AVGWIDTH=12
							,CHARSETREGISTRY=13
							,CHARSETENCODING=14
							} LFD;

private:
  enum FlagValues {bold=1,italic=2,scalable=4,vector=8};
  IString         xlfdCl, key1, keyLong;
  IString ChangeToXLFDFormat(const IString& val) const;  
};    //IXLFDString

// </class-declarations>

// <pragma align/pack/enum/namemangling restore>
#if defined(__TOS_WIN__) || defined(__TOS_OS2__) || defined(__TOS_OS400__)
  #pragma pack(pop)
#endif
#if defined(__TOS_AIX__)
  #pragma options align=reset
#endif

#pragma enum(pop)

#if __IBMCPP__ >= 400
#pragma namemangling(pop)
#endif /* __IBMCPP__ */
#if __IBMCPP__ >= 500
#pragma object_model(pop)
#endif /* __IBMCPP__ */
// </pragma align/pack/enum/namemangling restore>

// <inline-functions>
// </inline-functions>

// <pragma info/report restore>
#pragma info(none)
#pragma report(pop)
#pragma info(restore)
// </pragma info/report restore>

// </header>
#endif /* IXLFDSTR_HPP */
