/* This really looks like -*- C++ -*- */

#ifndef IXFONTSET_INL
#define IXFONTSET_INL 1

#include <strings.h>

inline
IXLFDFontSet::IXLFDFontSet(Display *aDisplay, IString aXLFD, XFontSet aFontSet)
{
    my_xlfd = aXLFD;
    my_fontset = aFontSet;
    my_display = aDisplay;
}

inline
IXLFDFontSet::IXLFDFontSet(const IXLFDFontSet& aCopy)
{
    my_xlfd = aCopy.my_xlfd;
    my_fontset = aCopy.my_fontset;
    my_display = aCopy.my_display;
}

inline IXLFDFontSet&
IXLFDFontSet::operator=(const IXLFDFontSet& aCopy)
{
    my_xlfd = aCopy.my_xlfd;
    my_fontset = aCopy.my_fontset;
    my_display = aCopy.my_display;
    return *this;
}

inline const char *
IXLFDFontSet::xlfd() const
{ 
    return (const char *)my_xlfd;
}

inline XFontSet
IXLFDFontSet::fontset() const
{
    return my_fontset;
}

inline Display *
IXLFDFontSet::display() const
{
    return my_display;
}

inline bool
IXLFDFontSet::operator==(const IXLFDFontSet& aXLFDFontSet) const
{
    return ((strcasecmp((const char *)my_xlfd,
                        (const char *)(aXLFDFontSet.my_xlfd)) == 0) &&
            (my_display == aXLFDFontSet.my_display));
}

inline bool
IXLFDFontSet::operator<(const IXLFDFontSet& aXLFDFontSet) const
{
    return (strcasecmp((const char *)my_xlfd,
                       (const char *)(aXLFDFontSet.my_xlfd)) < 0);
}

#endif
