/*******************************************************************************
* FILE NAME: ixfntset.hpp                                                      *
*                                                                              *
* COPYRIGHT:                                                                   *
*   IBM Open Class Library                                                     *
*   Licensed Materials - Property of IBM                                       *
*   (C) Copyright IBM Corporation 1992, 1997 All Rights Reserved.              *
*   US Government Users Restricted Rights - Use, duplication, or disclosure    *
*   restricted by GSA ADP Schedule Contract with IBM Corp.                     *
*                                                                              *
*******************************************************************************/
// Revision: 51 1.2.1.2 source/albert/graph2d/ixfntset.hpp, 2d, ioc.v400, 001006 

#ifndef IXFONTSET_HPP
#define IXFONTSET_HPP 1

#include <ilanglvl.hpp>
#include <ixdc.hpp>
#include <iss.h>
#include <ixlfdstr.hpp>

#if __IBMCPP__ >= 400
#pragma namemangling(compat)
#endif

#pragma enum(4)
#pragma pack(push,4)

#define CODESET_INITIAL_SIZE 32

class IXLFDFontSet
{
public:
    IXLFDFontSet(Display *aDisplay, IString aXLFD, XFontSet aFontSet);
    IXLFDFontSet(const IXLFDFontSet& aCopy);
    IXLFDFontSet& operator=(const IXLFDFontSet& aCopy);
    ~IXLFDFontSet() {}

    const char *xlfd() const;
    XFontSet fontset() const;
    Display *display() const;
    bool operator==(const IXLFDFontSet& aXLFDFontSet) const;
    bool operator<(const IXLFDFontSet& aXLFDFontSet) const;

private:
    IString my_xlfd;
    XFontSet my_fontset;
    Display *my_display;
};

class IXFontSet
{
public:
    XFontSet getFontSet(Display *dpy, const char *xlfd);
    ~IXFontSet();
    typedef enum { NO_PRIORITY=0
                  ,VECTOR_PRIORITY=1
		    					,PROP_PRIORITY=2
				    			,PTSIZE_PRIORITY=3
							   } PRIORITY;
    
private:
    ISortedSet<IXLFDFontSet> xlfd_cache;
};

#pragma pack(pop)
#pragma enum(pop)

XFontSet IXCreateFontSet(Display *display, const char *xlfd);
XFontSet IXCreateFontSet( Display *display
                        , IXLFDString XLFDStr
                        , bool strict
                        , IXFontSet::PRIORITY priority = IXFontSet::NO_PRIORITY);
                        
int IXRateMatch(  IXLFDString& desiredXLFD
                , IXLFDString& possibleXLFD
                , IXFontSet::PRIORITY priority = IXFontSet::NO_PRIORITY);

#if __IBMCPP__ >= 400
#pragma namemangling()
#endif

#include <ixfntset.inl>

#endif /* IXFONTSET_HPP */
