// IBM Open Class Library
//
// Licensed Materials - Property of IBM
//
// "Restricted Materials of IBM"
//
// (C) Copyright IBM Corporation, 1992, 1997 All Rights Reserved
//
// NOSHIP
// Revision: 06 1.7.1.11 source/albert/graph2d/ixdc.hpp, 2d, ioc.v400, 001006 

#ifdef IC_MOTIF
#ifndef _IXDC_
#define _IXDC_


#include <ilanglvl.hpp>
#include <itrace.hpp>
extern "C" {
#include <X11/Xlib.h>
}

#if __IBMCPP__ >= 400
#pragma namemangling(compat)
#endif

class IXDC {

    public:

	IXDC();
 	IXDC(Display*, Drawable);
	IXDC(const IXDC& xDC);

	~IXDC();
		
	IXDC& operator = (const IXDC& xDC);
	void setGC(GC );
	GC gc();
	

 	Display *xDisplay;
 	Drawable xDrawable;

	unsigned long fRefCount;
	
	private:

	friend class IPresSpaceHandle; //uses refrence counting
	friend class IXDevice; //uses refrence counting

	unsigned long refCount() const;
	void incrementCount();
	void decrementCount();
	GC	xGC;
};

inline unsigned long IXDC::refCount() const
{
    return fRefCount;
}



//--------------------------
//  IXDisplay class
//--------------------------

class IXDisplay
{

	public:
		IXDisplay(Display*); //used only by ICurrentThread::initializeGUI to set the display  
		~IXDisplay();

		static  Display* display(); //get back the Display 
		static void closeDisplay(); //used by ICurrentThread::terminateGUI to invalidate the dsiplay
		static void queryMasks(unsigned long*,
					unsigned long*,
					unsigned long*,
					unsigned long*,
					unsigned long*,
					unsigned long*,
					unsigned long*);
		static unsigned long rgbToPixel(unsigned char, 
				unsigned char,
				unsigned char);
		static void pixelToRGB(unsigned long, 
				unsigned char*, 
				unsigned char*, 
				unsigned char*);
		static bool isRGBFormat();

	private:
		static Display* fDisplay;
		static bool fDisplayOpened;
		static unsigned long redMask; //red Mask
		static unsigned long greenMask; //green Mask
		static unsigned long blueMask; //blue Mask
		static unsigned long rgbDepth; //Bits per Color Component
		static unsigned long redShift; //red bits to shift in a ulong word
		static unsigned long greenShift; //green bits to shift in a ulong word
		static unsigned long blueShift; //blue bits to shift in a ulong word

};

#if __IBMCPP__ >= 400
#pragma namemangling()
#endif

#endif // _IXDC_

#endif //IC_MOTIF
