// Revision: 63 1.7.2.1 source/albert/graph2d/ibmpstat.hpp, 2d, ioc.v400, 001006 
/* NOSHIP */
#ifndef _IBMPSTAT_
#define _IBMPSTAT_
/*******************************************************************************
* FILE NAME: ibmpstat.hpp                                                      *
*                                                                              *
* DESCRIPTION:                                                                 *
*   Declarations of the classes:                                               *
*     IBmpStaticPointer                                                        *
*                                                                              *
* COPYRIGHT:                                                                   *
*   IBM Open Class Library                                                     *
*   (C) Copyright International Business Machines Corporation 1992, 1997       *
*   Licensed Material - Program-Property of IBM - All Rights Reserved.         *
*   US Government Users Restricted Rights - Use, duplication, or disclosure    *
*   restricted by GSA ADP Schedule Contract with IBM Corp.                     *
*                                                                              *
*******************************************************************************/
#include <ibase.hpp>
#include <igraphpl.hpp>
#include <i2dghand.hpp>

#ifdef IC_MOTIF
  #include <istring.hpp>
#endif

#if __IBMCPP__ >= 400
#pragma namemangling(compat)
#endif

class IPointerSet;
class IBitmapSet;
class IPrivateResource;
class ISize;
class IPixelBuffer;

#pragma pack(push,4)

class IBitmapStaticPtr {
public:

static unsigned long
  addPointerRef   ( IPointerHandle::Value pointerHandle ),
  addBitmapRef    ( IBitmapHandle::Value  bitmapHandle ),
  removePointerRef( IPointerHandle::Value pointerHandle ),
  removeBitmapRef ( IBitmapHandle::Value  bitmapHandle );
#ifdef IC_WIN
 #ifndef IC_WIN_STRICT
// The implementation of these functions in ibmstat.cpp are always
// compiled with STRICT. For the case where the caller is compiled
// with NO_STRICT, map these function names to their STRICT versions
// to avoid errors at link time.
  #pragma map( IBitmapStaticPtr::addPointerRef(void*), "?addPointerRef__16IBitmapStaticPtrFP7HICON__" )
  #pragma map( IBitmapStaticPtr::addBitmapRef(void*), "?addBitmapRef__16IBitmapStaticPtrFP9HBITMAP__" )
  #pragma map( IBitmapStaticPtr::removePointerRef(void*), "?removePointerRef__16IBitmapStaticPtrFP7HICON__" )
  #pragma map( IBitmapStaticPtr::removeBitmapRef(void*), "?removeBitmapRef__16IBitmapStaticPtrFP9HBITMAP__" )
 #endif
#endif // IC_WIN

#ifdef IC_PMWIN
static IPointerHandle
  loadIcon        ( unsigned long        iconId,
                    const IModuleHandle& moduleHandle,
                    const IString&       fileName,
                    bool                 managed);

static IPixelBuffer* loadBitmapFromResource(
			const IModuleHandle& ,
			const unsigned long );

static IBitmapHandle
  loadBitmap     ( unsigned long        bitmapId,
                   const IModuleHandle& moduleHandle,
                   const IString&       fileName,
                   const ISize&         sizeBitmap,
                   bool                 managed);
#endif

#ifdef IC_MOTIF
static IPointerHandle
  loadIcon        ( unsigned long        iconId,
                    const IString&       fileName,
                    char*                xpmData,
                    bool                 managed,
                    bool                 isPointer);

static IBitmapHandle
  loadBitmap     ( unsigned long        bitmapId,
                   const IString&       fileName,
                   char*                xpmData,
                   const ISize&         sizeBitmap,
                   bool                 managed);
#endif


static IPointerSet
 &pointerSet();

static IBitmapSet
 &bitmapSet();

static IPrivateResource
 &bitmapKey();


#ifdef IC_MOTIF
static unsigned long
  shapeMaskFor      ( const IPointerHandle& pointerHandle ) ;

static unsigned long
  insensitivePixmap ( const IBitmapHandle&  bitmapHandle );

static IBitmapHandle
  sizeBitmapTo      ( const IBitmapHandle&  currentHandle,
                      const ISize&          newSize );

static IPointerHandle
  sizePointerTo     ( const IPointerHandle&  currentHandle,
                      const ISize&           newSize );
static IPointerHandle
  pointerFromBitmap ( const IBitmapHandle&   bitmapHandle);

#endif // IC_MOTIF

#ifdef IC_PMWIN
static IPointerHandle::Value
  systemPointer ( unsigned long systemPointerId,
                  bool          copy = false,
                  bool          iconAPI = false );
static IBitmapHandle::Value
  systemBitmap  ( unsigned long systemBitmapId);
#endif // IC_PMWIN
#ifdef IC_PM
static IBitmapHandle desktopCompatibleBitmap(const IBitmapHandle&);
#endif //IC_PM

private:
static IPointerSet
 *fgPointerSet;
static IBitmapSet
 *fgBitmapSet;
};

#pragma pack(pop)

#if __IBMCPP__ >= 400
#pragma namemangling()
#endif

#endif // _IBMPSTAT_
