// Revision: 64 1.14.2.5 source/albert/graph2d/ibmpstat.cpp, 2d, ioc.v400, 001006 
/*******************************************************************************
* FILE NAME: ibmpstat.cpp                                                      *
*                                                                              *
* DESCRIPTION:                                                                 *
*   Implementation of the class(es):                                           *
*     IBitmapStaticPtr                                                         *
*                                                                              *
* COPYRIGHT:                                                                   *
*   IBM Open Class Library                                                     *
*   (C) Copyright International Business Machines Corporation 1992, 1997       *
*   Licensed Material - Program-Property of IBM - All Rights Reserved.         *
*   US Government Users Restricted Rights - Use, duplication, or disclosure    *
*   restricted by GSA ADP Schedule Contract with IBM Corp.                     *
*                                                                              *
*******************************************************************************/
#pragma priority( -2147482112 )

// For Windows, force compiling with STRICT, to ensure the compiler will
// generate mangled names that match the ones we are exporting. This must
// precede the inclusion of ibase.hpp.
#define STRICT  1

#include <ibase.hpp>

#ifdef IC_MOTIF
#include <X11/Intrinsic.h>
#include <ixdc.hpp>
#include <xpm.h>
#include <ixpmconv.hpp>
#endif // IC_MOTIF

#include <ibmpstat.hpp>
#include <ibmpdata.hpp>
#include <ireslock.hpp>
#include <iexcept.hpp>
#include <iplatfrm.hpp>
#include <iprimlck.hpp>
#include <icolmap.hpp>

#ifdef IC_PM
  #define INCL_WINPOINTERS
#endif

#include <grassert.hpp>
#include <igimage.hpp>

// Segment definitions
#ifdef IC_PAGETUNE
  #define _IBMPSTAT_CPP_
  #include <ipagetun.h>
#endif


#ifdef IC_PM
  #define INCL_WINPOINTERS
  #define INCL_DOSPROCESS
  #define INCL_GPI
  #include <os2.h>
  #define IGETSYSBITMAP(idx)              (WinGetSysBitmap( HWND_DESKTOP, idx ))
  #define IQUERYSYSPOINTER(idPtr,bCpy,iWin)                               \
                            (WinQuerySysPointer( HWND_DESKTOP, idPtr, bCpy ))
#endif // IC_PM

#ifdef IC_WIN
  #include <windows.h>

  #define ILOADPOINTER(hInst,idPtr)                                       \
                        (LoadCursor( hInst, MAKEINTRESOURCE( idPtr ) ))
  #define IGETSYSBITMAP(idx)          (LoadBitmap( NULL, (LPCSTR)idx ))
  #define IQUERYSYSPOINTER(idPtr,bCpy,iWin)                               \
                  ((iWin) ?                                             \
                  (LoadCursor( NULL, MAKEINTRESOURCE(idPtr) )) : \
                  (LoadIcon( NULL, MAKEINTRESOURCE(idPtr) )))
#endif // IC_WIN

#include <pixbuf.hpp>


IPointerSet* IBitmapStaticPtr::fgPointerSet = 0;
IBitmapSet* IBitmapStaticPtr::fgBitmapSet = 0;

/*------------------------------------------------------------------------------
| IBitmapStaticPtr::bitmapKey                                                  |
------------------------------------------------------------------------------*/
static IPrivateResource* fgBitmapKey = 0;

IPrivateResource& IBitmapStaticPtr::bitmapKey()
{
    if (!fgBitmapKey) {
        IPrimalLock lock;
        if (!fgBitmapKey) {
            fgBitmapKey = new IPrivateResource;
        }
    }
    return *fgBitmapKey;
}

/*------------------------------------------------------------------------------
| IBitmapStaticPtr::bitmapSet                                                  |
------------------------------------------------------------------------------*/
IBitmapSet& IBitmapStaticPtr::bitmapSet()
{
    if (!fgBitmapSet) {
        IResourceLock lock(bitmapKey());
        if (!fgBitmapSet) {
            fgBitmapSet = new IBitmapSet;
        }
    }
    return *fgBitmapSet;
}

/*------------------------------------------------------------------------------
| IBitmapStaticPtr::addBitmapRef                                               |
------------------------------------------------------------------------------*/
unsigned long IBitmapStaticPtr::addBitmapRef( IBitmapHandle::Value bitmapHandle)
{
  IFUNCTRACE_ALL();
  ITRACE_ALL(IString("BMPHandle is: ") + IString((unsigned long)bitmapHandle));

  unsigned long ulUseCount=0;

  IBitmapData* bitmapData;
  if(bitmapHandle!=0)
  {
    /* Lock Resource Table */
    IResourceLock reslibLock(IBitmapStaticPtr::bitmapKey());

    bitmapData = IBitmapStaticPtr::bitmapSet().find( bitmapHandle );
    if ( bitmapData )
    {
      ulUseCount = bitmapData->addRef();
      ITRACE_ALL(IString("Handle is: ")+IString((unsigned long)bitmapData->handle()) +
                 " UseCount now: " + IString(ulUseCount));
    }
  } /* endif */

  return(ulUseCount);
}

/*------------------------------------------------------------------------------
| IBitmapStaticPtr::removeBitmapRef                                            |
------------------------------------------------------------------------------*/
unsigned long IBitmapStaticPtr::removeBitmapRef( IBitmapHandle::Value bitmapHandle)
{
  IFUNCTRACE_ALL();
  ITRACE_ALL(IString("BMPHandle is: ") + IString((unsigned long)bitmapHandle));

  unsigned long ulUseCount=0;

  IBitmapData* bitmapData;
  if(bitmapHandle!=0)
  {
    /* Lock Resource Table */
    IResourceLock reslibLock(IBitmapStaticPtr::bitmapKey());

    bitmapData = IBitmapStaticPtr::bitmapSet().find( bitmapHandle );
    if ( bitmapData )
    {
      ulUseCount = bitmapData->removeRef();
      ITRACE_ALL(IString("Handle is: ")+IString((unsigned long)bitmapData->handle()) +
                 " UseCount now: " + IString(ulUseCount));
      if(ulUseCount==0)
      {
        IBitmapStaticPtr::bitmapSet().remove(bitmapData);
        delete(bitmapData);
      }
    }
  } /* endif */

  return ulUseCount;
}

/*------------------------------------------------------------------------------
| IBitmapStaticPtr::pointerSet                                                 |
------------------------------------------------------------------------------*/
IPointerSet& IBitmapStaticPtr::pointerSet()
{
  if(fgPointerSet==0)
  {
    IResourceLock reslibLock(IBitmapStaticPtr::bitmapKey());
    if(fgPointerSet==0)
        fgPointerSet = new IPointerSet;
  }
  return *fgPointerSet;
}


/*------------------------------------------------------------------------------
| IBitmapStaticPtr::addPointerRef                                               |
------------------------------------------------------------------------------*/
unsigned long IBitmapStaticPtr::addPointerRef( IPointerHandle::Value pointerHandle)
{
  IFUNCTRACE_ALL();

  ITRACE_ALL(IString("PTRHandle is: ") + IString((unsigned long)pointerHandle));

  unsigned long ulUseCount = 0;
  IPointerData* pointerData;
  if(pointerHandle!=0)
  {
     /* Lock Resource Table */
     IResourceLock reslibLock(IBitmapStaticPtr::bitmapKey());
     pointerData = IBitmapStaticPtr::pointerSet().find( pointerHandle );
     if(pointerData)
     {
       ulUseCount = pointerData->addRef();
       ITRACE_ALL(IString("Handle is: ")+IString((unsigned long)pointerData->handle()) +
                  " UseCount now: " + IString(ulUseCount));
     }
  } /* endif */
  return(ulUseCount);

}

/*------------------------------------------------------------------------------
| IBitmapStaticPtr::removePointerRef                                           |
------------------------------------------------------------------------------*/
unsigned long IBitmapStaticPtr::removePointerRef( IPointerHandle::Value pointerHandle)
{
  IFUNCTRACE_ALL();

  ITRACE_ALL(IString("PTRHandle is: ") + IString((unsigned long)pointerHandle));

  unsigned long ulUseCount = 0;
  IPointerData* pointerData;
  if(pointerHandle!=0)
  {
     /* Lock Resource Table */
     IResourceLock reslibLock(IBitmapStaticPtr::bitmapKey());
     pointerData = IBitmapStaticPtr::pointerSet().find( pointerHandle );
     if(pointerData)
     {
       ulUseCount = pointerData->removeRef();
       ITRACE_ALL(IString("Handle is: ")+IString((unsigned long)pointerData->handle()) +
                  " UseCount now: " + IString(ulUseCount));
       if(ulUseCount==0)
       {
         IBitmapStaticPtr::pointerSet().remove(pointerData);

         delete(pointerData);
       }
     }
  } /* endif */
  return ulUseCount;
}


#ifdef IC_MOTIF
/*------------------------------------------------------------------------------
| IBitmapStaticPtr::sizeBitmapTo                                               |
------------------------------------------------------------------------------*/
IBitmapHandle IBitmapStaticPtr::sizeBitmapTo(
                        const IBitmapHandle& currentHandle,
                        const ISize& newSize  )
{
  IFUNCTRACE_ALL();

  IBitmapData* bitmapData = 0;

  bool found = false;
  /* First find the bitmap with the specified handle */
  IResourceLock reslibLock(IBitmapStaticPtr::bitmapKey());
  bitmapData = IBitmapStaticPtr::bitmapSet().find( currentHandle );


  // Note:  Because there is currently code in the library that
  // casts IPointerHandle to IBitmapHandle and then calls this function
  // to resize the bitmap, we also look in the pointerSet for the
  // IPointerData (which IS-A IBitmapData) that the handle points to.
  if (!bitmapData)
    bitmapData = IBitmapStaticPtr::pointerSet()
        .find( (IPointerHandle::Value)(IBitmapHandle::Value)currentHandle );

  if (!bitmapData)
    GrafDeviceException("Tried to size non-existant bitmap");

  // If it's currently at the desired size we are done.
  // If the desired width or height is 0, any size will do.
  if ( bitmapData && (bitmapData->size() == newSize))
    return IBitmapHandle(bitmapData->handle());

  // Add a new item to collection with a copy of the image
  XImage* newXImage = XSubImage( bitmapData->image(), 0, 0,
                                 bitmapData->trueSize().width(),
                                 bitmapData->trueSize().height() );
  IBitmapData* newBitmapData = new IBitmapData(bitmapData->id(),
                              bitmapData->resourceFileName(),
                              bitmapData->trueSize(),
                              newSize,
                              newXImage);

  IBitmapStaticPtr::bitmapSet().add(newBitmapData);

  return newBitmapData->handle();
}


/*------------------------------------------------------------------------------
| IBitmapStaticPtr::sizePointerTo                                              |
------------------------------------------------------------------------------*/
IPointerHandle IBitmapStaticPtr::sizePointerTo(
                        const IPointerHandle& currentHandle,
                        const ISize& newSize  )
{
  IFUNCTRACE_ALL();

  IPointerData* pointerData = 0;

  bool found = false;
  /* First find the bitmap with the specified handle */
  IResourceLock reslibLock(IBitmapStaticPtr::bitmapKey());
  pointerData = IBitmapStaticPtr::pointerSet().find( currentHandle );

  if (!pointerData)
    GrafDeviceException("Tried to size non-existant icon");

  // If it's currently at the desired size we are done.
  // If the desired width or height is 0, any size will do.
  if ( pointerData && (pointerData->size() == newSize))
    return IPointerHandle(pointerData->handle());

  // Add a new item to collection with a copy of the image
  XImage* newXImage = XSubImage( pointerData->image(), 0, 0,
                                 pointerData->trueSize().width(),
                                 pointerData->trueSize().height() );

  XImage* newXMaskImage = 0;
  if(pointerData->maskImage())
     newXMaskImage = XSubImage( pointerData->maskImage(), 0, 0,
                                 pointerData->trueSize().width(),
                                 pointerData->trueSize().height() );

  IPointerData* newPointerData = new IPointerData(pointerData->id(),
                              pointerData->resourceFileName(),
                              pointerData->trueSize(),
                              newSize,
                              newXImage,
                              newXMaskImage,
                              pointerData->hotSpot());


  IBitmapStaticPtr::pointerSet().add(newPointerData);

  return newPointerData->handle();
}


/*------------------------------------------------------------------------------
| IBitmapStaticPtr::shapeMaskFor                                               |
------------------------------------------------------------------------------*/
unsigned long IBitmapStaticPtr::shapeMaskFor
                                  ( const IPointerHandle& currentHandle )
{
  IFUNCTRACE_ALL();

  /* Find the bitmap with the specified handle */
  IResourceLock reslibLock(IBitmapStaticPtr::bitmapKey());
  IPointerData* pointerData =
     IBitmapStaticPtr::pointerSet().find( currentHandle );

  if(pointerData)
      return pointerData->maskPixmap();
  else
      return 0;
}

/*------------------------------------------------------------------------------
| IBitmapStaticPtr::insensitivePixmap                                          |
------------------------------------------------------------------------------*/
unsigned long IBitmapStaticPtr::insensitivePixmap
                                  ( const IBitmapHandle& bitmapHandle )
{
  IFUNCTRACE_ALL();

  IBitmapData* bitmapData = 0;

  /* First find the bitmap with the specified handle */
  IResourceLock reslibLock(IBitmapStaticPtr::bitmapKey());
  bitmapData = IBitmapStaticPtr::bitmapSet().find( bitmapHandle );

  if(bitmapData)
     return  bitmapData->insensitivePixmap();
  else
     return 0;
}


/*------------------------------------------------------------------------------
| IBitmapStaticPtr::pointerFromBitmap                                          |
------------------------------------------------------------------------------*/
IPointerHandle IBitmapStaticPtr::pointerFromBitmap
                                  ( const IBitmapHandle& bitmapHandle )
{
  IFUNCTRACE_ALL();

  IBitmapData* bitmapData = 0;

  /* First find the bitmap with the specified handle */
  IResourceLock reslibLock(IBitmapStaticPtr::bitmapKey());
  bitmapData = IBitmapStaticPtr::bitmapSet().find( bitmapHandle );

  if (!bitmapData)
    GrafDeviceException("Tried to convert non-existant bitmap to icon");

  // Create a copy of the XImage.
  XImage* newXImage = XSubImage( bitmapData->pixelBuffer()->imageHandle(), 0, 0,
                                 bitmapData->trueSize().width(),
                                 bitmapData->trueSize().height() );

  XImage* newXMaskImage = bitmapData->pixelBuffer()->maskImageOf1Bit();

  IPointerData* newPointerData = new IPointerData(bitmapData->id(),
                              bitmapData->resourceFileName(),
                              bitmapData->trueSize(),
                              bitmapData->trueSize(),
                              newXImage,
                              newXMaskImage);  // no mask image for now


  IBitmapStaticPtr::pointerSet().add(newPointerData);

  return newPointerData->handle();


}


#endif

#ifdef IC_PMWIN
/*------------------------------------------------------------------------------
| IBitmapStaticPtr::loadIcon                                                   |
------------------------------------------------------------------------------*/
IPointerHandle IBitmapStaticPtr::loadIcon( unsigned long iconId,
                                           const IModuleHandle& moduleHandle,
                                           const IString& fileName,
                                           bool managed)
{
  IFUNCTRACE_ALL();

#ifdef IC_WIN
  // Windows manages icons loaded from resource files automatically.
  // We don't need to do it also.
  managed = false;
#endif

  /* Lock Resource Table */
  IResourceLock reslibLock(IBitmapStaticPtr::bitmapKey());

  IPointerHandle::Value returnHandle = 0;
  IPointerData* pointerData = 0;

  /* If resources are managed, build a cursor to see if we have already */
  /* loaded this Icon.  If so just update the use count                 */
  bool found = false;
  if(managed)
  {
      IPointerSet::Cursor cursor(IBitmapStaticPtr::pointerSet());
      for(cursor.setToFirst(); cursor.isValid(); cursor.setToNext())
      {
        pointerData = IBitmapStaticPtr::pointerSet().elementAt(cursor);
        if( (pointerData->id() == iconId)               &&
          (pointerData->resourceFileName() == fileName) )
        {
           ITRACE_ALL("PTR Match found");
           found = true;
           break;
        }
      }
  }
  if(found==true)
  {
    returnHandle = (IPointerHandle::Value) pointerData->handle();
  }
  else
  /* Either we are not managing the resource, or it doesn't exist yet   */
  {

#ifdef IC_WIN
     // In windows, need to try to load both an icon and pointer
     if (IPlatform::isWin9x())
        {
        returnHandle = (HICON)
                        LoadImage( moduleHandle,
                                   MAKEINTRESOURCE(iconId),
                                   IMAGE_ICON, 0, 0, LR_DEFAULTSIZE |
                                   LR_DEFAULTCOLOR | LR_SHARED );

        if (returnHandle == 0)
          {
          returnHandle = (HICON)
                          LoadImage( moduleHandle,
                                     MAKEINTRESOURCE(iconId),
                                     IMAGE_CURSOR, 0, 0, LR_DEFAULTSIZE |
                                     LR_DEFAULTCOLOR | LR_SHARED );
          }
        //returnHandle = CopyImage ( tempHandle, IMAGE_ICON, 0, 0, LR_COPYRETURNORG);
        }
     else
        {
        returnHandle = LoadIcon( moduleHandle, MAKEINTRESOURCE(iconId) );
        if (returnHandle == 0)
          {
          returnHandle = LoadCursor( moduleHandle, MAKEINTRESOURCE( iconId ) );
          }
        }
#endif
#ifdef IC_PM
     /* Load the Icon or Pointer */
     returnHandle = WinLoadPointer( HWND_DESKTOP, moduleHandle, iconId );
#endif
     ITRACE_ALL(IString("Pointer loaded is: ")+IString((unsigned long)returnHandle));

     if ( returnHandle && managed)
     {
        IPointerData* pointerDataNew = new IPointerData(iconId, returnHandle,
                                           fileName);
        IBitmapStaticPtr::pointerSet().add(pointerDataNew);
     }
  }

  return IPointerHandle(returnHandle);
}
#endif // IC_PMWIN

#ifdef IC_MOTIF
/*------------------------------------------------------------------------------
| IBitmapStaticPtr::loadIcon                                                   |
------------------------------------------------------------------------------*/
IPointerHandle IBitmapStaticPtr::loadIcon( unsigned long iconId,
                                           const IString& fileName,
                                           char*  xpmData,
                                           bool managed,
                                           bool isPointer)
{
  IFUNCTRACE_ALL();

  IPointerData* pointerData = 0;

  /*------------------------------------------------------------------*/
  /* Note that under Motif we ignore the managed parameter and       */
  /* always check the IBitmapSet. We can't efficiently resize without */
  /* the IBitmap object in the set.                                   */
  /*------------------------------------------------------------------*/

  /*------------------------------------------------------------------*/
  /* Build a cursor to see if we have already loaded this icon. If so */
  /* just update the use count                                        */
  /*------------------------------------------------------------------*/
  bool found = false;

  /*------------------------------------------------------------------*/
  /* Lock Resource Table                                              */
  /*------------------------------------------------------------------*/
  IResourceLock reslibLock(IBitmapStaticPtr::bitmapKey());
  IPointerSet::Cursor cursor(IBitmapStaticPtr::pointerSet());
  for(cursor.setToFirst(); cursor.isValid(); cursor.setToNext())
  {
     pointerData = IBitmapStaticPtr::pointerSet().elementAt(cursor);
     /*---------------------------------------------------------------*/
     /* If the id's match then we have a true match                   */
     /*---------------------------------------------------------------*/
     if( pointerData->id() == iconId &&
         pointerData->resourceFileName() == fileName)
     {
       ITRACE_ALL("ICON Match found");
       found = true;
       break;
     }
  }

  /*------------------------------------------------------------------*/
  /* If the icon resource is not already loaded try to load           */
  /* it from the memory resource data. IF this fails, return 0.       */
  /*------------------------------------------------------------------*/
  if(!found)
  {
    pointerData = 0;
    if (xpmData)
      {
        ISize sizeIcon;
#if 1
        IXPMConverter xpmConv;
        IResourceLock reslibLock(IBitmapStaticPtr::bitmapKey());
   		//create pixmap from the native image handle
   		IPixelBuffer *pixbuf=xpmConv.createPixBufFromResource(xpmData, strlen(xpmData));

        sizeIcon.setWidth(pixbuf->width());
        sizeIcon.setHeight(pixbuf->height());
        IPoint hotSpot(pixbuf->xHotSpot(), pixbuf->yHotSpot());
        pointerData = new IPointerData(iconId,
                             fileName,
                             sizeIcon,
                             sizeIcon,
                            ((isPointer) ? pixbuf->colorImageOf1Bit() :
                                             pixbuf->imageHandle()),
                             pixbuf->maskImageOf1Bit(),
                             hotSpot,
                            ((isPointer) ? 0 :
                                             pixbuf));

        IBitmapStaticPtr::pointerSet().add(pointerData);
		if(isPointer){
			delete pixbuf;
		}
#else
      unsigned long handle = 0;
      Display* display = IXDisplay::display();
      XImage* image_return;
      XImage* shapeimage_return;
      Screen* screen = DefaultScreenOfDisplay(display);
      /*--------------------------------------------------------------*/
      /* According to the XPM documentation, the XpmAttributes        */
      /* structures that is passed in must have a valid valuemask or  */
      /* the xpm call will trap.                                      */
      /*--------------------------------------------------------------*/
      XpmAttributes xpmAtt;
      xpmAtt.valuemask = XpmVisual | XpmColormap | XpmCloseness;
      xpmAtt.visual = XDefaultVisualOfScreen(screen);
      xpmAtt.colormap = IColorMap::defaultColorMap().nativeColorMap();
      // By giving a value for closeness, we cause the Xpm code to look
      // for the closest matching color if the DefaultColormap has no more
      // free cells. The is much better than just having XpmReadFileToImage
      // fail and for us to then throw an exception.
      // The Xpm documentation recommended 40000 as a good value for finding
      // a match that is resonable. If you change closeness you get:
      //    > 40000 - closer match but chance of not finding a match
      //    < 40000 - better at finding a match, color may not be close
      xpmAtt.closeness = 65535;

      // If we are using our own colormap (not the default), we assume that
      // all necessary colors have been allocated.
      Colormap defaultColormap =  XDefaultColormap(display, DefaultScreen(display));
      if(xpmAtt.colormap != defaultColormap)
      {
        xpmAtt.valuemask |=  XpmAllocCloseColors;
        xpmAtt.alloc_close_colors = 0;
      }
      // Set the depth to 1 if we are a pointer type otherwise get
      // the default depth
      if(isPointer)
      {
        ITRACE_DEVELOP("Icon depth set to 1");
        xpmAtt.valuemask |= XpmDepth;
        xpmAtt.depth = 1;
      }


      IResourceLock reslibLock(IBitmapStaticPtr::bitmapKey());
      handle = XpmCreateImageFromBuffer(display,
                                        xpmData,
                                        &image_return,
                                        &shapeimage_return,
                                        &xpmAtt);
      if(image_return)
      {
        sizeIcon.setWidth(xpmAtt.width);
        sizeIcon.setHeight(xpmAtt.height);
        IPoint hotSpot(xpmAtt.x_hotspot, xpmAtt.y_hotspot);
        pointerData = new IPointerData(iconId,
                             fileName,
                             sizeIcon,
                             sizeIcon,
                             image_return,
                             shapeimage_return,
                             hotSpot);

        IBitmapStaticPtr::pointerSet().add(pointerData);
      }
#endif
    }
  }  /* endif !found */

  if (pointerData)
    return IPointerHandle(pointerData->handle());
  else
    return IPointerHandle(0);
}
#endif // IC_MOTIF

#ifdef IC_PMWIN
#include <ibmpconv.hpp>

IPixelBuffer* IBitmapStaticPtr::loadBitmapFromResource(
			const IModuleHandle& moduleHandle,
			const unsigned long bitmapId)
{
#ifdef IC_WIN

  HRSRC                resourceInfoBlockHandle;
  HGLOBAL              bitmapGlobalHandle;
  BITMAPINFO*          bitmapInfo;
  unsigned long        resSize;

  resourceInfoBlockHandle = FindResource(moduleHandle, (LPSTR)MAKEINTRESOURCE(bitmapId), RT_BITMAP);
  if (resourceInfoBlockHandle)
  {
    resSize  = SizeofResource(moduleHandle, resourceInfoBlockHandle);
    if ( resSize == 0 )
       fprintf(stdout,"SizeofResource = %d\n", resSize);
    bitmapGlobalHandle = LoadResource(moduleHandle, resourceInfoBlockHandle);
    bitmapInfo = (BITMAPINFO*)LockResource(bitmapGlobalHandle);

    IBMPConverter bmpConv;
    IPixelBuffer *pixbuf = bmpConv.createDIBFromResource((char *)bitmapInfo, resSize);

    UnlockResource(bitmapGlobalHandle);
    FreeResource(bitmapGlobalHandle);
    return(pixbuf);
  }
#endif
    return(0);
}


/*------------------------------------------------------------------------------
| IBitmapStaticPtr::loadBitmap                                                 |
------------------------------------------------------------------------------*/
IBitmapHandle IBitmapStaticPtr::loadBitmap(unsigned long bitmapId,
                                           const IModuleHandle& moduleHandle,
                                           const IString& fileName,
                                           const ISize& sizeBitmap,
                                           bool managed)
{
  IFUNCTRACE_ALL();

  IBitmapHandle::Value bitmapHandle = 0;
  IBitmapData* bitmapData = 0;
  IPixelBuffer* pixbuf = 0;

  /* If resources are managed, build a cursor to see if we have already */
  /* loaded this Icon.  If so, just update the use count                */
  bool found = false;

  if (managed)
  {
    bitmapData = IBitmapStaticPtr::bitmapSet().find(bitmapId, fileName, sizeBitmap);
    if (bitmapData)
    {
      found = true;
      bitmapHandle = bitmapData->handle();
    }
  }

  if (!found)
  {
    // Loading the bitmap from the resource library...
#ifdef IC_WIN
    // Windows :
	pixbuf = loadBitmapFromResource(moduleHandle, bitmapId);
	if(pixbuf)
      bitmapHandle = (IBitmapHandle::Value) pixbuf->handle();
#else // for OS2:
    HDC hdcMem = DevOpenDC( 0, OD_MEMORY, "*", 0, 0, 0 );
    SIZEL di = {0,0};
    IPresSpaceHandle hdc = GpiCreatePS( 0, hdcMem, &di, PU_PELS | GPIF_DEFAULT | GPIT_NORMAL  | GPIA_ASSOC );
    HBITMAP hbmOld = GpiLoadBitmap(hdc, moduleHandle, bitmapId, sizeBitmap.width(), sizeBitmap.height());

	if(hbmOld){
		//create pixmap from the native image handle
		pixbuf=IPixelBuffer::createPixbufFromNativeImage(hbmOld);

		//no need to make a copy of the bitmap
		bitmapHandle = pixbuf->handle();
		GpiDeleteBitmap(hbmOld); //delete the original
	} else {
		bitmapHandle = hbmOld;
	}
    GpiAssociate(hdc, NULLHANDLE);
    GpiDestroyPS(hdc);
    DevCloseDC(hdcMem);
#endif // IC_WIN
    // The bitmap is loaded.

    if(bitmapHandle && managed)
    {
      // Lock Resource Table
      IResourceLock reslibLock(IBitmapStaticPtr::bitmapKey());
      IBitmapData* bitmapDataNew = new IBitmapData(bitmapId, bitmapHandle,
                                             fileName, sizeBitmap, pixbuf);
      IBitmapStaticPtr::bitmapSet().add(bitmapDataNew);

    } /* endif (managed) */
  }  /* endif !found */

  return IBitmapHandle(bitmapHandle);
}
#endif // IC_PMWIN



#ifdef IC_MOTIF
/*------------------------------------------------------------------------------
| IBitmapStaticPtr::loadBitmap                                                 |
------------------------------------------------------------------------------*/
IBitmapHandle IBitmapStaticPtr::loadBitmap(unsigned long bitmapId,
                                           const IString& fileName,
                                           char* xpmData,
                                           const ISize& sizeBitmap,
                                           bool managed)
{
  IFUNCTRACE_ALL();

  IBitmapData* bitmapData = 0;

  /*------------------------------------------------------------------*/
  /* Note that under Motif we ignore the managed parameter and       */
  /* always check the IBitmapSet. We can't efficiently resize without */
  /* the IBitmap object in the set.                                   */
  /*------------------------------------------------------------------*/

  /*------------------------------------------------------------------*/
  /* Build a cursor to see if we have already loaded this bitmap. If  */
  /* so just update the use count                                     */
  /*------------------------------------------------------------------*/
  bool found = false;

  /*------------------------------------------------------------------*/
  /* Lock Resource Table                                              */
  /*------------------------------------------------------------------*/
  IResourceLock reslibLock(IBitmapStaticPtr::bitmapKey());
  IBitmapSet::Cursor cursor(IBitmapStaticPtr::bitmapSet());
  for(cursor.setToFirst(); cursor.isValid(); cursor.setToNext())
  {
     bitmapData = IBitmapStaticPtr::bitmapSet().elementAt(cursor);
     /*---------------------------------------------------------------*/
     /* If the id's match then we have a true match if no size was    */
     /* specified and the bitmap is at its trueSize                   */
     /*                or                                             */
     /* the requested size matches currentSize                        */
     /*---------------------------------------------------------------*/
     if( (bitmapData->id() == bitmapId)     &&
         ( (ISize() == sizeBitmap && bitmapData->size() == bitmapData->trueSize())
               ||
            (sizeBitmap == bitmapData->size())
         )
       )
     {
       ITRACE_ALL("BMP Match found");
       found = true;
       break;
     }
  }

  /*------------------------------------------------------------------*/
  /* If the bitmap resource is not already loaded try to load it from */
  /* memory resource data.                                            */
  /*------------------------------------------------------------------*/
  if(!found)
  {
    bitmapData = 0;
    if (xpmData)
    {
#if 1
        IXPMConverter xpmConv;
        IResourceLock reslibLock(IBitmapStaticPtr::bitmapKey());
   		//create pixmap from the native image handle
   		IPixelBuffer *pixbuf=xpmConv.createPixBufFromResource(xpmData, strlen(xpmData));

         ISize imageSize(pixbuf->width(), pixbuf->height());
         ISize requestedBitmapSize = sizeBitmap;
         if(sizeBitmap == ISize(0,0))
            requestedBitmapSize = imageSize;

         bitmapData = new IBitmapData(bitmapId,
                                fileName,
                                imageSize,
                                requestedBitmapSize,
                                pixbuf->imageHandle(),
                                pixbuf);

         IBitmapStaticPtr::bitmapSet().add(bitmapData);
#else
      unsigned long handle = 0;
      Display* display = IXDisplay::display();
      XImage* image_return;
      XImage* shapeimage_return;
      Screen* screen = DefaultScreenOfDisplay(display);
      /*--------------------------------------------------------------*/
      /* According to the XPM documentation, the XpmAttributes        */
      /* structures that is passed in must have a valid valuemask or  */
      /* the xpm call will trap.                                      */
      /*--------------------------------------------------------------*/
      XpmAttributes xpmAtt;
      xpmAtt.valuemask = XpmVisual | XpmColormap | XpmCloseness;
      xpmAtt.visual = XDefaultVisualOfScreen(screen);
      xpmAtt.colormap = IColorMap::defaultColorMap().nativeColorMap();
      // By giving a value for closeness, we cause the Xpm code to look
      // for the closest matching color if the DefaultColormap has no more
      // free cells. The is much better than just having XpmReadFileToImage
      // fail and for us to then throw an exception.
      // The Xpm documentation recommended 40000 as a good value for finding
      // a match that is resonable. If you change closeness you get:
      //    > 40000 - closer match but chance of not finding a match
      //    < 40000 - better at finding a match, color may not be close
      //    > 65535 - match anything (never return an error)
      xpmAtt.closeness = 65535;

      // If we are using our own colormap (not the default), we assume that
      // all necessary colors have been allocated.
      Colormap defaultColormap =  XDefaultColormap(display, DefaultScreen(display));
      if(xpmAtt.colormap != defaultColormap)
      {
        xpmAtt.valuemask |=  XpmAllocCloseColors;
        xpmAtt.alloc_close_colors = 0;
      }

      IResourceLock reslibLock(IBitmapStaticPtr::bitmapKey());
      handle = XpmCreateImageFromBuffer(display,
                                        xpmData,
                                        &image_return,
                                        &shapeimage_return,
                                        &xpmAtt);


   	IPixelBuffer *pixbuf=NULL;

   	if(image_return)
      {
   		//create pixmap from the native image handle
   		pixbuf=IPixelBuffer::createPixbufFromNativeImage(image_return);


         ISize imageSize(xpmAtt.width, xpmAtt.height);
         ISize requestedBitmapSize = sizeBitmap;
         if(sizeBitmap == ISize(0,0))
            requestedBitmapSize = imageSize;

         bitmapData = new IBitmapData(bitmapId,
                                fileName,
                                imageSize,
                                requestedBitmapSize,
                                image_return,
                                pixbuf);

         IBitmapStaticPtr::bitmapSet().add(bitmapData);
   	}

#endif
    }
  }  /* endif !found */

  if (bitmapData)
    return IBitmapHandle(bitmapData->handle());
  else
    return IBitmapHandle(0);
}
#endif //IC_MOTIF

#ifdef IC_PMWIN
/*------------------------------------------------------------------------------
| IBitmapStaticPtr::systemBitmap                                               |
------------------------------------------------------------------------------*/
IBitmapHandle::Value IBitmapStaticPtr::systemBitmap ( unsigned long systemBitmapId )
{
  IBitmapHandle::Value bitmapHandle;
  IBitmapData*
    bitmapData = IBitmapStaticPtr::bitmapSet().find( systemBitmapId,
                                                   IString(),
                                                   ISize(0,0));
  if ( bitmapData )
  {
    bitmapHandle = bitmapData->handle();
  }
  else
  {
    bitmapHandle = IGETSYSBITMAP( systemBitmapId );

    if (!bitmapHandle)
    {
      GrafDeviceException("IGETSYSBITMAP( Id:" + IString(systemBitmapId) + ")");
    }
    // If we return a copy we will reference count this resource
    // otherwise not (don't want to destroy a system pointer).
#if 0
    bitmapData = new IBitmapData( systemBitmapId, bitmapHandle, IString());
    IBitmapStaticPtr::bitmapSet().add(bitmapData);
#else
	IGImage igimage(bitmapHandle);
	bitmapHandle = igimage.handle();
	// Extract the node and add a ref, else this object gets deleted by
	// the igimage destructor
	IBitmapData* node = IBitmapStaticPtr::bitmapSet().find(bitmapHandle);
	if (node)
	{
		node->addRef();
	}
#endif
  }
  return bitmapHandle;
}
#endif //IC_PMWIN

#ifdef IC_PMWIN
/*------------------------------------------------------------------------------
| IBitmapStaticPtr::systemPointer                                              |
------------------------------------------------------------------------------*/
IPointerHandle::Value
   IBitmapStaticPtr::systemPointer ( unsigned long systemPointerId,
                                     bool makeCopy,
                                     bool iconAPI )
{
  IPointerHandle::Value pointerHandle =
       IQUERYSYSPOINTER( systemPointerId, makeCopy,iconAPI );
  if (!pointerHandle)
  {
     GrafDeviceException("IQUERYSYSPOINTER");
  }
  /* If we return a copy we will reference count this resource        */
  /* otherwise not (don't want to destroy a system pointer).          */
  if(makeCopy)
  {
    IPointerData* pointerDataNew = new IPointerData( systemPointerId,
                                      pointerHandle,
                                      IString());
    IBitmapStaticPtr::pointerSet().add(pointerDataNew);
  }
  return pointerHandle;
}
#endif  // IC_PMWIN

#ifdef IC_PM
IBitmapHandle IBitmapStaticPtr::desktopCompatibleBitmap(const IBitmapHandle& bitmap)
{
	IBitmapHandle bmp=0;
	if(bitmap== 0)
		GrafDeviceException("desktopCompatibleBitmap:Invalid IBitmapHandle specified");

	IBitmapData* node = IBitmapStaticPtr::bitmapSet().find(bitmap);
	if (node)
	{
		bmp=node->pixelBuffer()->desktopCompatibleBitmap();
	} else { //not in the collection
		GrafDeviceException("desktopCompatibleBitmap:IBitmapHandle specified not in the collection");
	}
	return bmp;
}
#endif //IC_PM
